/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.ByScLocator;
import com.isomorphic.webdriver.Operation;
import com.isomorphic.webdriver.ScActions;
import com.isomorphic.webdriver.ValueComparator;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class SmartClientWebDriver
implements WebDriver,
Interactive,
HasInputDevices,
TakesScreenshot,
JavascriptExecutor {
    private static final int WAIT_QUANTUM_MILLIS = 100;
    private static final int CLICK_OCCLUDED_STEPS = 16;
    private static final String UNDEFINED_RECT = "rect is undefined";
    private static final String COORDS_NO_CLICK_EX = "not clickable at point";
    private static final String RETURN_NOT_IN_FUNCTION = "return not in function";
    private static final String MODIFIER_CLEAR_SEQUENCE = "\ue008\ue009\ue009\ue008";
    private static final String CANNOT_CLEAR_NON_EDITABLE = "(?i)(?s).*(element must be user.editable|unable to clear.*cannot be edited).*";
    private static final String STOREDVARS = "if (!window.storedVars) window.storedVars = {}; window.storedVars[arguments[0]] = ";
    private static final String CALL_NEAREST_DESCENDANTS = "return isc.AutoTest.getNearestDescendantElement(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);";
    private static Map<String, String> scriptMap = new HashMap<String, String>(){
        {
            this.put("selenium\\.getAutWindow\\(\\)", "window");
            this.put("(this|selenium)\\.browserbot\\.get(Aut|User|Current)Window\\(\\)", "window");
        }
    };
    private String baseUrl = "";
    private JavascriptExecutor js;
    private RemoteWebDriver driver;
    public ScActions actions;
    private RegExMatcher regExMatcher = new RegExMatcher();
    private ToleranceChecker tolChecker = new ToleranceChecker();
    private boolean captureServerLogs;
    private ServerLogMode serverLogMode;
    private OccludedElementApproach occludedApproach = OccludedElementApproach.NEAREST_DESCENDANT;
    private boolean useFrameworkValueAsFallback = false;
    private boolean allowJavaScriptToStringMatch = true;
    private boolean spacesMatchAllWhitespace = true;
    private Duration timeout = Duration.ofSeconds(30L);
    private Duration implicitWait = Duration.ofMillis(5000L);
    private long valueTolerance = 10L;
    private long elementTolerance = 10L;
    private Long canvasWidthTolerance;
    private Long canvasHeightTolerance;
    boolean hoverConfigured;
    private int[] keysDown = new int[256];
    private static final String MODIFIER_REGEX = "[" + Keys.CONTROL + Keys.SHIFT + "]";
    private Map<Character, Integer> modifierCharMap = new HashMap<Character, Integer>(){
        {
            this.put(Character.valueOf(Keys.SHIFT.charAt(0)), 16);
            this.put(Character.valueOf(Keys.CONTROL.charAt(0)), 17);
        }
    };

    SmartClientWebDriver() {
    }

    SmartClientWebDriver(RemoteWebDriver driver) {
        this.setDriver(driver);
    }

    void setDriver(RemoteWebDriver driver) {
        this.driver = driver;
        this.setImplicitWait(this.implicitWait);
        this.js = driver;
        this.actions = new ScActions(this);
    }

    protected boolean isLegacy() {
        return false;
    }

    private void setImplicitWait(Duration implicitWait) {
        WebDriver.Timeouts timeouts = this.driver.manage().timeouts();
        timeouts.implicitlyWait(implicitWait.toMillis(), TimeUnit.MILLISECONDS);
    }

    private static String buildCompleteTestURL(String baseURL, String relativeURL) {
        if (baseURL != null) {
            baseURL = baseURL.trim().replaceAll(" ", "%20");
        }
        if (relativeURL != null) {
            relativeURL = relativeURL.trim().replaceAll(" ", "%20");
        }
        if (SmartClientWebDriver.isAbsoluteUrl(relativeURL)) {
            baseURL = relativeURL;
            relativeURL = "";
        }
        try {
            URI lastURI;
            URI baseURI = new URI(baseURL);
            URI combinedURI = baseURI.resolve(relativeURL);
            String query = combinedURI.getQuery();
            query = query == null ? "" : query + "&";
            query = query + "sc_selenium=true";
            URI uRI = lastURI = StringUtils.isEmpty((String)relativeURL) ? baseURI : combinedURI;
            if (baseURI.getQuery() != null) {
                query = baseURI.getQuery() + "&" + query;
            }
            URI uri = new URI(baseURI.getScheme(), baseURI.getUserInfo(), baseURI.getHost(), baseURI.getPort(), lastURI.getPath(), query, lastURI.getFragment());
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(StringUtils.isEmpty((String)relativeURL) ? "Base URL " + baseURL + " is not valid" : "Failed to combine base URL " + baseURL + " with relative URL " + relativeURL + "; one or both may be invalid", e);
        }
    }

    public void setMaxDragPause(long maxDragPauseMillis) {
        this.actions.setMaxDragPause(maxDragPauseMillis);
    }

    public void setDefaultWaitTimeout(long timeoutInSeconds) {
        if (timeoutInSeconds <= 0L) {
            throw new IllegalArgumentException("The default timeout must be positive");
        }
        this.timeout = Duration.ofSeconds(timeoutInSeconds);
    }

    public void setDefaultImplicitWait(long implicitWaitMillis) {
        if (implicitWaitMillis <= 0L) {
            throw new IllegalArgumentException("The default implicit wait must be positive");
        }
        this.implicitWait = Duration.ofMillis(implicitWaitMillis);
    }

    public void setOccludedElementApproach(OccludedElementApproach occludedApproach) {
        this.occludedApproach = occludedApproach;
    }

    @Deprecated
    public void setAllowCoordClickOnOccludingElement(boolean allow) {
        this.occludedApproach = allow ? OccludedElementApproach.ELEMENT_AT_POINT : OccludedElementApproach.ELEMENT;
    }

    public void setValueTolerance(long valueTolerance) {
        this.valueTolerance = valueTolerance;
    }

    public void setElementTolerance(long elementTolerance) {
        this.elementTolerance = elementTolerance;
    }

    public void setCanvasWidthTolerance(long canvasWidthTolerance) {
        this.canvasWidthTolerance = canvasWidthTolerance;
    }

    public void setCanvasHeightTolerance(long canvasHeightTolerance) {
        this.canvasHeightTolerance = canvasHeightTolerance;
    }

    public void clearTolerances() {
        this.elementTolerance = 10L;
        this.valueTolerance = 10L;
        this.canvasWidthTolerance = null;
        this.canvasHeightTolerance = null;
    }

    public int getElementWidth(By by) {
        return this.findElement((By)by).getSize().width;
    }

    public int getElementHeight(By by) {
        return this.findElement((By)by).getSize().height;
    }

    public int getElementPositionLeft(By by) {
        return this.findElement((By)by).getLocation().x;
    }

    public int getElementPositionTop(By by) {
        return this.findElement((By)by).getLocation().y;
    }

    public Object getValue(By scLocator) {
        if (!(scLocator instanceof ByScLocator)) {
            return null;
        }
        return this.js.executeScript("return window._lastValue = isc.AutoTest.getValue(arguments[0])", new Object[]{((ByScLocator)scLocator).getLocatorString()});
    }

    public String getValueAsString(By scLocator) {
        return this.getValueAsString(scLocator, true);
    }

    public String getValueAsString(By scLocator, boolean asJavaScriptString) {
        if (!(scLocator instanceof ByScLocator)) {
            return null;
        }
        String script = "var value = window._lastValue = isc.AutoTest.getValue(arguments[0]);";
        if (asJavaScriptString) {
            script = script + "if (value != null) value = value.toString();";
        }
        return String.valueOf(this.js.executeScript(script + " return value", new Object[]{((ByScLocator)scLocator).getLocatorString()}));
    }

    public void setUseFrameworkValueAsFallback(boolean useFrameworkValue) {
        this.useFrameworkValueAsFallback = useFrameworkValue;
    }

    public String getText(By by) {
        return this.getText(by, false);
    }

    protected String getText(By by, boolean waitFor) {
        List<WebElement> elements = this.findElements(by);
        if (elements.isEmpty()) {
            if (!waitFor) {
                System.err.println("Text is null because no WebElement present for " + by);
            }
            return null;
        }
        WebElement element = elements.get(0);
        String text = element.getText();
        if (text == null || text.length() == 0) {
            this.scrollIntoViewIfNeeded(by, element);
            text = element.getText();
        }
        if (text != null && text.length() > 0) {
            return text;
        }
        Object value = this.useFrameworkValueAsFallback ? this.getValue(by) : element.getAttribute("value");
        return value != null ? value.toString() : "";
    }

    public String getTable(By scLocator, long row, long col) {
        WebElement element = this.findElement(scLocator);
        if (element == null) {
            return null;
        }
        return (String)this.js.executeScript("return isc.AutoTest.getTableCellValue(arguments[0],arguments[1],arguments[2])", new Object[]{element, row, col});
    }

    private static String cleanScript(String javaScript) {
        for (String key : scriptMap.keySet()) {
            javaScript = javaScript.replaceAll(key, scriptMap.get(key));
        }
        return javaScript;
    }

    private Object evalScript(String evalScript, String fallbackValue, boolean asString) {
        return this.evalScript(evalScript, fallbackValue, asString ? EvalResultType.STRING : EvalResultType.OBJECT);
    }

    private Object evalScript(String evalScript, String fallbackValue, EvalResultType asType) {
        if (evalScript != null) {
            evalScript = SmartClientWebDriver.cleanScript(evalScript);
        }
        if (fallbackValue != null) {
            evalScript = "try { " + evalScript + "; } catch (notUsed) { " + fallbackValue + ";}";
        }
        String execScript = evalScript != null ? "(window._lastEval = eval(arguments[0]));" : "window._lastEval;";
        switch (asType) {
            case STRING: {
                execScript = "var result = " + execScript + " return result != null ? result.toString() : null;";
                break;
            }
            case BOOLEAN: {
                execScript = "!!" + execScript;
            }
            case OBJECT: {
                execScript = "return " + execScript;
            }
        }
        return this.js.executeScript(execScript, new Object[]{evalScript});
    }

    private Object execLegacyEvalScript(String execScript, boolean asString) {
        execScript = execScript == null ? "window._lastEval;" : "(_lastEval = function () {" + SmartClientWebDriver.cleanScript(execScript) + "}());";
        execScript = asString ? "var result = " + execScript + " return result != null ? result.toString() : null;" : "return " + execScript;
        return this.js.executeScript(execScript, new Object[0]);
    }

    public String getEval(String javaScript) {
        return String.valueOf(this.evalScript(javaScript, null, EvalResultType.STRING));
    }

    public String getEval(String javaScript, String fallbackValue) {
        return String.valueOf(this.evalScript(javaScript, fallbackValue, EvalResultType.STRING));
    }

    public String storeEval(String javaScript, String variableName) {
        String result = this.getEval(javaScript);
        this.js.executeScript("if (!window.storedVars) window.storedVars = {}; window.storedVars[arguments[0]] = window._lastEval;", new Object[]{variableName});
        return result;
    }

    public Object storeValue(By scLocator, String variableName) {
        Object result = this.getValue(scLocator);
        this.js.executeScript("if (!window.storedVars) window.storedVars = {}; window.storedVars[arguments[0]] = window._lastValue;", new Object[]{variableName});
        return result;
    }

    public Object storeVariable(String variableName, Object value) {
        this.js.executeScript("if (!window.storedVars) window.storedVars = {}; window.storedVars[arguments[0]] = arguments[1];", new Object[]{variableName, value});
        return value;
    }

    public Boolean setCanvasPropertyTrue(By scLocator, String propertyName) {
        return (Boolean)this.setCanvasProperty(scLocator, propertyName, true);
    }

    public Boolean setCanvasPropertyFalse(By scLocator, String propertyName) {
        return (Boolean)this.setCanvasProperty(scLocator, propertyName, false);
    }

    public Boolean clearCanvasProperty(By scLocator, String propertyName) {
        return (Boolean)this.setCanvasProperty(scLocator, propertyName, null);
    }

    public Object setCanvasProperty(By scLocator, String propertyName, Object value) {
        if (!(scLocator instanceof ByScLocator)) {
            return null;
        }
        return this.executeScript("var canvas = isc.AutoTest.getObject(arguments[0]); var result = canvas ? canvas.getProperty(arguments[1]) : null;if (canvas) canvas.setProperty(arguments[1], arguments[2]); return result;", ((ByScLocator)scLocator).getLocatorString(), propertyName, value);
    }

    public boolean verifyElementWidth(By by, long expectedWidth) {
        return (long)this.getElementWidth(by) == expectedWidth;
    }

    public boolean verifyElementHeight(By by, long expectedHeight) {
        return (long)this.getElementHeight(by) == expectedHeight;
    }

    public boolean verifyElementPositionLeft(By by, long expectedLeft) {
        return (long)this.getElementPositionLeft(by) == expectedLeft;
    }

    public boolean verifyElementPositionTop(By by, long expectedTop) {
        return (long)this.getElementPositionTop(by) == expectedTop;
    }

    public boolean verifyElementPresent(By by) {
        List<WebElement> elements = this.findElements(by);
        return elements != null && !elements.isEmpty();
    }

    public boolean verifyElementVisible(By by) {
        List<WebElement> elements = this.findElements(by);
        if (elements == null || elements.isEmpty()) {
            return false;
        }
        return elements.get(0).isDisplayed();
    }

    public boolean verifyElementSelected(By by) {
        List<WebElement> elements = this.findElements(by);
        if (elements == null || elements.isEmpty()) {
            return false;
        }
        return elements.get(0).isSelected();
    }

    public boolean verifyElementClickable(By scLocator) {
        List<WebElement> elements = this.findElements(scLocator);
        if (elements == null || elements.isEmpty()) {
            return false;
        }
        return this.performJavascriptFunction(elements.get(0), "isElementClickable", null);
    }

    public boolean verifyElementReadyForKeyPresses(By scLocator) {
        List<WebElement> elements = this.findElements(scLocator);
        if (elements == null || elements.isEmpty()) {
            return false;
        }
        return this.performJavascriptFunction(elements.get(0), "isElementReadyForKeyPresses", null);
    }

    public boolean verifyCanvasWidth(By scLocator, long expectedWidth) {
        if (!(scLocator instanceof ByScLocator)) {
            return false;
        }
        Long actualWidth = (Long)this.executeScript("var canvas = isc.AutoTest.getObject(arguments[0]); return canvas ? canvas.getVisibleWidth() : null;", ((ByScLocator)scLocator).getLocatorString());
        if (actualWidth == null) {
            return false;
        }
        long tolerance = this.canvasWidthTolerance != null ? this.canvasWidthTolerance : this.valueTolerance;
        return Math.abs(actualWidth - expectedWidth) <= tolerance;
    }

    public boolean verifyCanvasHeight(By scLocator, long expectedHeight) {
        if (!(scLocator instanceof ByScLocator)) {
            return false;
        }
        Long actualHeight = (Long)this.executeScript("var canvas = isc.AutoTest.getObject(arguments[0]); return canvas ? canvas.getVisibleHeight() : null;", ((ByScLocator)scLocator).getLocatorString());
        if (actualHeight == null) {
            return false;
        }
        long tolerance = this.canvasHeightTolerance != null ? this.canvasHeightTolerance : this.valueTolerance;
        return Math.abs(actualHeight - expectedHeight) <= tolerance;
    }

    public boolean verifyElementWidthWithTolerance(By by, long expectedWidth) {
        WebElement element = this.findElement(by);
        if (element == null) {
            return false;
        }
        long actualWidth = element.getSize().width;
        return Math.abs(actualWidth - expectedWidth) <= this.elementTolerance;
    }

    public boolean verifyElementHeightWithTolerance(By by, long expectedHeight) {
        WebElement element = this.findElement(by);
        if (element == null) {
            return false;
        }
        long actualHeight = element.getSize().height;
        return Math.abs(actualHeight - expectedHeight) <= this.elementTolerance;
    }

    public void setAllowJavaScriptToStringMatch(boolean allowJSMatch) {
        this.allowJavaScriptToStringMatch = allowJSMatch;
    }

    public boolean verifyValueEmpty(By scLocator) {
        boolean match;
        Object value = this.getValue(scLocator);
        boolean bl = match = value == null || value instanceof String && ((String)value).isEmpty() || this.allowJavaScriptToStringMatch && value instanceof List && ((List)value).isEmpty();
        if (!match) {
            System.err.println("Non-empty value found: '" + value + "'");
            return false;
        }
        return true;
    }

    public boolean verifyValue(By scLocator, Boolean expected) {
        Object value = this.getValue(scLocator);
        if (value == null) {
            return expected == null;
        }
        if (expected == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return this.regExMatcher.compare(expected, (Object)((Boolean)value));
        }
        this.regExMatcher.printErr("Non-Boolean found: '" + value + "'");
        return false;
    }

    private boolean isSingletonList(Object value) {
        return value instanceof List && ((List)value).size() == 1;
    }

    public boolean verifyValue(By scLocator, Long expected) {
        return this.verifyValue(scLocator, expected, false);
    }

    public boolean verifyValueWithTolerance(By scLocator, Long expected) {
        return this.verifyValue(scLocator, expected, true);
    }

    private boolean verifyValue(By scLocator, Long expected, boolean withTolerance) {
        RegExMatcher policy;
        Object value = this.getValue(scLocator);
        if (value == null) {
            return expected == null;
        }
        if (expected == null) {
            return false;
        }
        if (this.allowJavaScriptToStringMatch && this.isSingletonList(value)) {
            value = ((List)value).get(0);
        }
        RegExMatcher regExMatcher = policy = withTolerance ? this.tolChecker : this.regExMatcher;
        if (value instanceof Long) {
            return policy.compare((Object)expected, (Object)((Long)value));
        }
        if (value instanceof String) {
            return policy.compare(expected, (String)value);
        }
        if (value instanceof Double) {
            return policy.compare(expected, (Double)value);
        }
        if (value instanceof Integer) {
            return policy.compare(expected, (Integer)value);
        }
        policy.printErr("Can't compare expected Long to the value: '" + value + "'");
        return false;
    }

    public boolean verifyValue(By scLocator, Integer expected) {
        return this.verifyValue(scLocator, (long)expected);
    }

    public boolean verifyValueWithTolerance(By scLocator, Integer expected) {
        return this.verifyValueWithTolerance(scLocator, (long)expected);
    }

    public boolean verifyValue(By scLocator, String expected) {
        return this.verifyValue(scLocator, expected, false);
    }

    public boolean verifyValueWithTolerance(By scLocator, String expected) {
        return this.verifyValue(scLocator, expected, true);
    }

    private String getLastValueAsString(boolean asJavaScriptString) {
        String script = "var value = window._lastValue;";
        if (asJavaScriptString) {
            script = script + "if (value != null) value = value.toString();";
        }
        return String.valueOf(this.js.executeScript(script + " return value", new Object[0]));
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean verifyValue(By scLocator, String expected, boolean withTolerance) {
        boolean match;
        RegExMatcher policy;
        Object value;
        block10: {
            value = this.getValue(scLocator);
            if (value == null) {
                if (this.allowJavaScriptToStringMatch) {
                    value = "null";
                    break block10;
                } else {
                    if (expected != null) return false;
                    return true;
                }
            }
            if (expected == null) {
                return false;
            }
        }
        RegExMatcher regExMatcher = policy = withTolerance ? this.tolChecker : this.regExMatcher;
        if (SmartClientWebDriver.haveBooleans(expected, value)) {
            return policy.compare(expected, (Boolean)value);
        }
        if (SmartClientWebDriver.haveIntegers(expected, value)) {
            return policy.compare(expected, (Integer)value);
        }
        if (SmartClientWebDriver.haveDoubles(expected, value)) {
            return policy.compare(expected, (Double)value);
        }
        if (SmartClientWebDriver.haveLongs(expected, value)) {
            return policy.compare(expected, (Long)value);
        }
        boolean bl = match = SmartClientWebDriver.haveLists(expected, value) ? policy.compare(expected, (List)value) : policy.compare(expected, String.valueOf(value));
        if (!match && this.allowJavaScriptToStringMatch) {
            String expectedJS = expected;
            if (value instanceof List && withTolerance && expectedJS.matches("[^,]*[0-9]+[^,]*\\s[^,]*[0-9]+[^,]*")) {
                expectedJS = expectedJS.trim().replaceAll("(\\s)+", " ").replaceAll(" ", ",");
            }
            match = policy.compare(expectedJS, this.getLastValueAsString(true));
        }
        if (match) return match;
        policy.printErr("Expected: '" + expected + "', found: '" + value + "'");
        return match;
    }

    public boolean verifyTextPresent(String expected) {
        return this.verifyText(By.tagName((String)"body"), "*" + expected + "*");
    }

    public boolean verifyText(By by) {
        return this.verifyText(by, "");
    }

    public boolean verifyText(By by, String expected) {
        String pattern;
        boolean match;
        String value = this.getText(by);
        if (value == null) {
            return false;
        }
        if (expected == null) {
            expected = "";
        }
        if (!(match = Pattern.matches((pattern = SmartClientWebDriver.getPatternRegEx(expected, this.spacesMatchAllWhitespace)).trim(), value.trim()))) {
            System.err.println("Expected: '" + expected + "', found: '" + value + "'");
        }
        return match;
    }

    public boolean verifyTitle(String expected) {
        String pattern;
        boolean match;
        String value = this.getTitle();
        if (value == null) {
            return false;
        }
        if (expected == null) {
            expected = "";
        }
        if (!(match = Pattern.matches((pattern = SmartClientWebDriver.getPatternRegEx(expected, this.spacesMatchAllWhitespace)).trim(), value.trim()))) {
            System.err.println("Expected: '" + expected + "', found: '" + value + "'");
        }
        return match;
    }

    public boolean verifyTable(By scLocator, long row, long col, String expected) {
        WebElement element = this.findElement(scLocator);
        if (element == null) {
            return expected == null;
        }
        String cellValue = this.getTable(scLocator, row, col);
        if (cellValue == null) {
            return expected == null;
        }
        String pattern = SmartClientWebDriver.getPatternRegEx(expected, this.spacesMatchAllWhitespace);
        boolean match = Pattern.matches(pattern.trim(), cellValue.trim());
        if (!match) {
            System.err.println("Expected: '" + expected + "', found: '" + cellValue + "'");
        }
        return match;
    }

    public boolean verifyTable(By scLocator, long row, long col) {
        return this.verifyTable(scLocator, row, col, "");
    }

    public boolean assertEval(String javaScript) {
        return this.assertEval(javaScript, this.allowJavaScriptToStringMatch ? "" : null);
    }

    public boolean assertEval(String javaScript, Object expected) {
        return this.assertEval(javaScript, expected, false);
    }

    public boolean assertEval(String javaScript, Object expected, boolean asJavaScriptString) {
        boolean match;
        Object result;
        try {
            result = this.evalScript(javaScript, null, asJavaScriptString);
        }
        catch (JavascriptException je) {
            String message = je.getMessage();
            if (message != null && message.toLowerCase().contains(RETURN_NOT_IN_FUNCTION)) {
                result = this.execLegacyEvalScript(javaScript, asJavaScriptString);
                System.err.println("JavaScript passed to eval APIs should not contain return statements; support for this may be removed in future releases");
            }
            throw je;
        }
        boolean bl = expected == null ? result == null : (match = expected.equals(result));
        if (!match && !asJavaScriptString && this.allowJavaScriptToStringMatch) {
            return this.assertEval(null, String.valueOf(expected), true);
        }
        if (!match) {
            System.err.println("Expected: '" + expected + "', found: '" + result + "'");
        }
        return match;
    }

    public boolean assertEval(String javaScript, String expected) {
        return this.assertEval(javaScript, expected, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean assertEval(String javaScript, String expected, boolean asJavaScriptString) {
        Object result;
        block5: {
            result = this.evalScript(javaScript, null, asJavaScriptString);
            if (result == null) {
                if (this.allowJavaScriptToStringMatch) {
                    result = "null";
                    break block5;
                } else {
                    if (expected != null) return false;
                    return true;
                }
            }
            if (expected == null) {
                return false;
            }
        }
        String pattern = SmartClientWebDriver.getPatternRegEx(expected);
        boolean match = Pattern.matches(pattern.trim(), String.valueOf(result).trim());
        if (!match && !asJavaScriptString && this.allowJavaScriptToStringMatch) {
            return this.assertEval(null, expected, true);
        }
        if (match) return match;
        System.err.println("Expected: '" + expected + "', found: '" + result + "'");
        return match;
    }

    private static String getPatternRegEx(String pattern) {
        return SmartClientWebDriver.getPatternRegEx(pattern, false);
    }

    private static String getPatternRegEx(String pattern, boolean replaceSpaces) {
        String suffix = pattern.substring(pattern.indexOf(":") + 1);
        String regex = null;
        if (pattern.startsWith("regex:") || pattern.startsWith("regex:")) {
            regex = "(?s)" + suffix;
        } else if (pattern.startsWith("regexi:") || pattern.startsWith("regexpi:")) {
            regex = "(?s)(?i)" + suffix;
        } else if (pattern.startsWith("exact:")) {
            regex = suffix.replaceAll("([\\-+*?.,{}()|#\\^$\\[\\]\\s\\\\])", "\\\\$1");
        } else if (pattern.startsWith("glob:")) {
            pattern = suffix;
        }
        if (regex == null) {
            regex = "(?s)" + pattern.replaceAll("([\\-+.,{}()|#\\^$\\[\\]\\\\])", "\\\\$1").replace("*", ".*").replace("?", ".");
        }
        return replaceSpaces ? regex.replace(" ", "\\s") : regex;
    }

    private static List<String> getPatternRegExForJavaScript(String pattern, boolean replaceSpaces) {
        String regex = SmartClientWebDriver.getPatternRegEx(pattern, replaceSpaces);
        String modifiers = "";
        if (regex.startsWith("(?s)")) {
            regex = regex.substring(4).replaceAll("(?<!\\\\)\\.", "[^]");
        }
        if (regex.startsWith("(?i)")) {
            regex = regex.substring(4);
            modifiers = modifiers + "i";
        }
        return Arrays.asList(regex, modifiers);
    }

    private static boolean haveIntegers(String expected, Object value) {
        return value instanceof Integer && Operation.isInteger(expected);
    }

    private static boolean haveLongs(String expected, Object value) {
        return value instanceof Long && Operation.isLong(expected);
    }

    private static boolean haveDoubles(String expected, Object value) {
        return value instanceof Double && Operation.isDouble(expected);
    }

    private static boolean haveBooleans(String expected, Object value) {
        return value instanceof Boolean && Operation.isBoolean(expected);
    }

    private static boolean haveLists(String expected, Object value) {
        return value instanceof List && Operation.isDoubleList(expected);
    }

    public boolean waitForElementClickable(By scLocator) {
        return this.waitForElementClickable(scLocator, 0L);
    }

    public boolean waitForElementClickable(By scLocator, long timeoutInSeconds) {
        return this.waitForJavascriptFunction(scLocator, "isElementClickable", null, null, Duration.ofSeconds(timeoutInSeconds));
    }

    public boolean waitForElementNotClickable(By scLocator) {
        return this.waitForElementNotClickable(scLocator, 0L);
    }

    public boolean waitForElementNotClickable(By scLocator, long timeoutInSeconds) {
        return this.waitForNotJavascriptFunction(scLocator, "isElementClickable", null, null, Duration.ofSeconds(timeoutInSeconds));
    }

    public boolean waitForElementVisible(By by) {
        return this.waitForElementVisible(by, 0L);
    }

    public boolean waitForElementVisible(By by, long timeoutInSeconds) {
        return new Waiter(Duration.ofSeconds(timeoutInSeconds)){

            @Override
            boolean success(List<WebElement> results, String notUsed) {
                return !results.isEmpty() && results.get(0).isDisplayed();
            }
        }.waitFor(by, null);
    }

    public boolean waitForElementPresent(By by) {
        return this.waitForElementPresent(by, 0L);
    }

    public boolean waitForElementPresent(By by, long timeoutInSeconds) {
        return new Waiter(Duration.ofSeconds(timeoutInSeconds)){

            @Override
            boolean success(List<WebElement> results, String notUsed) {
                return !results.isEmpty();
            }
        }.waitFor(by, null);
    }

    public boolean waitForElementNotPresent(By by) {
        return this.waitForElementNotPresent(by, 0L);
    }

    public boolean waitForElementNotPresent(By by, long timeoutInSeconds) {
        return new Waiter(Duration.ofSeconds(timeoutInSeconds)){

            @Override
            boolean success(List<WebElement> results, String notUsed) {
                return results.isEmpty();
            }
        }.waitFor(by, null);
    }

    public boolean waitForElementNotVisible(By by) {
        return this.waitForElementNotVisible(by, 0L);
    }

    public boolean waitForElementNotVisible(By by, long timeoutInSeconds) {
        return new Waiter(Duration.ofSeconds(timeoutInSeconds)){

            @Override
            boolean success(List<WebElement> results, String notUsed) {
                return results.isEmpty() || !results.get(0).isDisplayed();
            }
        }.waitFor(by, null);
    }

    public boolean waitForElementReadyForKeyPresses(By scLocator) {
        return this.waitForElementReadyForKeyPresses(scLocator, 0L);
    }

    public boolean waitForElementReadyForKeyPresses(By scLocator, long timeoutInSeconds) {
        return this.waitForJavascriptFunction(scLocator, "isElementReadyForKeyPresses", null, null, Duration.ofSeconds(timeoutInSeconds));
    }

    public boolean waitForCanvasDone(By scLocator) {
        return this.waitForCanvasDone(scLocator, 0L);
    }

    public boolean waitForCanvasDone(By scLocator, long timeoutInSeconds) {
        return this.waitForJavascriptFunction(scLocator, "isCanvasDone", null, null, Duration.ofSeconds(timeoutInSeconds));
    }

    public boolean waitForGridDone(By scLocator) {
        return this.waitForGridDone(scLocator, 0L);
    }

    public boolean waitForGridDone(By scLocator, long timeoutInSeconds) {
        return this.waitForGridDone(scLocator, null, 0L);
    }

    public boolean waitForGridDone(By scLocator, Boolean includeEdits) {
        return this.waitForGridDone(scLocator, includeEdits, 0L);
    }

    public boolean waitForGridDone(By scLocator, Boolean includeEdits, long timeoutInSeconds) {
        return this.waitForJavascriptFunction(scLocator, "isGridDone", includeEdits, null, Duration.ofSeconds(timeoutInSeconds));
    }

    public boolean waitForTileGridDone(By scLocator) {
        return this.waitForTileGridDone(scLocator, 0L);
    }

    public boolean waitForTileGridDone(By scLocator, long timeoutInSeconds) {
        return this.waitForJavascriptFunction(scLocator, "isTileGridDone", null, null, Duration.ofSeconds(timeoutInSeconds));
    }

    public boolean waitForTileLayoutDone(By scLocator) {
        return this.waitForTileLayoutDone(scLocator, 0L);
    }

    public boolean waitForTileLayoutDone(By scLocator, long timeoutInSeconds) {
        return this.waitForJavascriptFunction(scLocator, "isTileLayoutDone", null, null, Duration.ofSeconds(timeoutInSeconds));
    }

    public boolean waitForFormDone(By scLocator) {
        return this.waitForFormDone(scLocator, 0L);
    }

    public boolean waitForFormDone(By scLocator, long timeoutInSeconds) {
        return this.waitForJavascriptFunction(scLocator, "isFormDone", null, null, Duration.ofSeconds(timeoutInSeconds));
    }

    public boolean waitForItemDone(By scLocator) {
        return this.waitForItemDone(scLocator, 0L);
    }

    public boolean waitForItemDone(By scLocator, long timeoutInSeconds) {
        return this.waitForJavascriptFunction(scLocator, "isItemDone", null, null, Duration.ofSeconds(timeoutInSeconds));
    }

    public boolean waitForSystemDone() {
        return this.waitForSystemDone(0L);
    }

    public boolean waitForSystemDone(long timeoutInSeconds) {
        return this.waitForSystemDone(false, false, timeoutInSeconds);
    }

    public boolean waitForSystemDone(Boolean includeRedraws) {
        return this.waitForSystemDone(includeRedraws, false, 0L);
    }

    public boolean waitForSystemDone(Boolean includeRedraws, Boolean includeEdits) {
        return this.waitForSystemDone(includeRedraws, includeEdits, 0L);
    }

    public boolean waitForSystemDone(Boolean includeRedraws, Boolean includeEdits, long timeoutInSeconds) {
        return this.waitForJavascriptFunction(null, "isSystemDone", includeRedraws, includeEdits, Duration.ofSeconds(timeoutInSeconds));
    }

    public boolean waitForText(By by, String expected) {
        return this.waitForText(by, expected, 0L);
    }

    public boolean waitForText(final By by, String expected, long timeoutInSeconds) {
        String pattern = SmartClientWebDriver.getPatternRegEx(expected, this.spacesMatchAllWhitespace);
        return new Waiter(Duration.ofSeconds(timeoutInSeconds)){

            @Override
            boolean success(List<WebElement> results, String pattern) {
                if (results.isEmpty()) {
                    return false;
                }
                String value = SmartClientWebDriver.this.getText(by, true);
                if (pattern == null) {
                    return value == null;
                }
                if (value == null) {
                    return false;
                }
                return Pattern.matches(pattern.trim(), value.trim());
            }
        }.waitFor(by, pattern);
    }

    public boolean waitForHoverTextPresent(String expected) {
        return this.waitForHoverTextPresent(expected, 0L);
    }

    public boolean waitForHoverTextPresent(String expected, long timeoutInSeconds) {
        if (!expected.matches("[a-z]+:.*")) {
            expected = "regex:" + expected;
        }
        List<String> newRegExpArgs = SmartClientWebDriver.getPatternRegExForJavaScript(expected, this.spacesMatchAllWhitespace);
        String pattern = newRegExpArgs.get(0);
        String modifiers = newRegExpArgs.get(1);
        String script = "var hover = isc.Hover.hoverCanvas;if (hover == null || !hover.isDrawn() || !hover.isVisible()) return false; return hover.contents.search(new RegExp(arguments[0],\"" + modifiers + "\")) >= 0";
        return this.waitForCondition(script, timeoutInSeconds, pattern);
    }

    public boolean waitForValue(By scLocator, Object expected) {
        return this.waitForValue(scLocator, expected, 0L);
    }

    public boolean waitForValue(final By scLocator, final Object expected, long timeoutInSeconds) {
        return new Waiter(Duration.ofSeconds(timeoutInSeconds)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            boolean success(List<WebElement> results, String notUsed1) {
                boolean success;
                if (results.isEmpty()) {
                    return false;
                }
                SmartClientWebDriver.this.regExMatcher.hideErrors();
                try {
                    success = expected instanceof Long ? SmartClientWebDriver.this.verifyValue(scLocator, (Long)expected) : (expected instanceof Integer ? SmartClientWebDriver.this.verifyValue(scLocator, (Integer)expected) : (expected instanceof Boolean ? SmartClientWebDriver.this.verifyValue(scLocator, (Boolean)expected) : SmartClientWebDriver.this.verifyValue(scLocator, String.valueOf(expected))));
                }
                finally {
                    SmartClientWebDriver.this.regExMatcher.showErrors();
                }
                return success;
            }
        }.waitFor(scLocator, null);
    }

    public boolean waitForCondition(String javaScript) {
        return this.waitForCondition(javaScript, 0L);
    }

    public boolean waitForCondition(String javaScript, long timeoutInSeconds) {
        return new Waiter(Duration.ofSeconds(timeoutInSeconds)){

            @Override
            boolean success(List<WebElement> results, String javaScript) {
                try {
                    if (Boolean.TRUE.equals(SmartClientWebDriver.this.evalScript(javaScript, null, EvalResultType.BOOLEAN))) {
                        return true;
                    }
                }
                catch (StaleElementReferenceException e) {
                    throw e;
                }
                catch (Exception e) {
                    System.err.println("Exception in executeScript(): " + javaScript + ":" + e);
                    e.printStackTrace(System.err);
                }
                return false;
            }
        }.waitFor(null, javaScript);
    }

    public boolean waitForCondition(String javaScript, long timeoutInSeconds, final Object ... argument) {
        return new Waiter(Duration.ofSeconds(timeoutInSeconds)){

            @Override
            boolean success(List<WebElement> results, String javaScript) {
                try {
                    if (Boolean.TRUE.equals(SmartClientWebDriver.this.js.executeScript(javaScript, argument))) {
                        return true;
                    }
                }
                catch (StaleElementReferenceException e) {
                    throw e;
                }
                catch (Exception e) {
                    System.err.println("Exception in executeScript(): " + javaScript + ":" + e);
                    e.printStackTrace(System.err);
                }
                return false;
            }
        }.waitFor(null, javaScript);
    }

    public boolean waitForEval(String javaScript, String expected) {
        return this.waitForEval(javaScript, expected, 0L);
    }

    public boolean waitForEval(String javaScript, String expected, long timeoutInSeconds) {
        final String pattern = SmartClientWebDriver.getPatternRegEx(expected).trim();
        return new Waiter(Duration.ofSeconds(timeoutInSeconds)){

            @Override
            boolean success(List<WebElement> results, String javaScript) {
                try {
                    if (Pattern.matches(pattern, SmartClientWebDriver.this.getEval(javaScript).trim())) {
                        return true;
                    }
                }
                catch (StaleElementReferenceException e) {
                    throw e;
                }
                catch (Exception e) {
                    System.err.println("Exception in executeScript(): " + javaScript + ":" + e);
                    e.printStackTrace(System.err);
                }
                return false;
            }
        }.waitFor(null, javaScript);
    }

    public boolean waitForFrameToLoad(String frameLocator, long timeoutInSeconds) {
        WebDriverWait wait = new WebDriverWait((WebDriver)this.driver, timeoutInSeconds);
        try {
            ExpectedCondition frameAvailable = ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)frameLocator);
            wait.until(driver -> (WebDriver)frameAvailable.apply(driver));
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    private boolean waitForJavascriptFunction(final By by, String methodName, final Object argument1, final Object argument2, Duration timeout) {
        boolean success = new Waiter(timeout){

            @Override
            boolean success(List<WebElement> results, String name) {
                return by == null ? SmartClientWebDriver.this.performJavascriptFunction(null, name, argument1, argument2) : !results.isEmpty() && SmartClientWebDriver.this.performJavascriptFunction(results.get(0), name, argument1, argument2);
            }
        }.waitFor(by, methodName);
        if (!this.hoverConfigured && success && by instanceof ByScLocator) {
            this.executeScript("isc.Canvas.addProperties({hoverDelay:1000})", new Object[0]);
            this.hoverConfigured = true;
        }
        return success;
    }

    private boolean waitForNotJavascriptFunction(final By by, String methodName, final Object argument1, final Object argument2, Duration timeout) {
        return new Waiter(timeout){

            @Override
            boolean success(List<WebElement> results, String name) {
                return !(by != null ? !results.isEmpty() && SmartClientWebDriver.this.performJavascriptFunction(results.get(0), name, argument1, argument2) : SmartClientWebDriver.this.performJavascriptFunction(null, name, argument1, argument2));
            }
        }.waitFor(by, methodName);
    }

    private boolean performJavascriptFunction(WebElement element, String methodName, Object methodArg) {
        return this.performJavascriptFunction(element, methodName, methodArg, null);
    }

    private boolean performJavascriptFunction(WebElement element, String methodName, Object methodArg1, Object methodArg2) {
        try {
            Boolean done;
            String script = "return isc.AutoTest." + methodName + "(arguments[0],arguments[1])";
            Boolean bl = done = element == null ? (Boolean)this.js.executeScript(script, new Object[]{methodArg1, methodArg2}) : (Boolean)this.js.executeScript(script, new Object[]{element, methodArg1});
            if (Boolean.TRUE.equals(done)) {
                return true;
            }
        }
        catch (StaleElementReferenceException e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println("Exception in WebDriver." + methodName + ":" + e);
            e.printStackTrace(System.err);
        }
        return false;
    }

    private static boolean isAbsoluteUrl(String url) {
        return url.matches("(?i)^https?://.*");
    }

    private void reset() {
        this.clearTolerances();
        for (int i = 0; i < this.keysDown.length; ++i) {
            this.keysDown[i] = 0;
        }
        this.actions.reset();
    }

    public void setBaseUrl(String baseUrl) {
        if (baseUrl != null) {
            this.baseUrl = baseUrl;
        }
    }

    public void get(String relativeUrl) {
        this.get(relativeUrl, true);
    }

    public void get(String relativeUrl, boolean maximize) {
        if (maximize) {
            this.manage().window().maximize();
        }
        this.driver.get(SmartClientWebDriver.buildCompleteTestURL(this.baseUrl, relativeUrl));
        if (this.isLegacy() && this.driver.getCapabilities().getCapability("nativeEvents") == null) {
            System.err.println("*** Warning: Native events are not enabled. You may need to update your WebDriver version ***");
        }
        this.reset();
        if (this.isLegacy()) {
            this.executeScript("window.focus()", new Object[0]);
        }
        if (this.serverLogMode == ServerLogMode.ALL) {
            this.captureServerLogs();
        }
    }

    public void pause(long waitInMillis) {
        try {
            Thread.sleep(waitInMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void selectWindowByName(String name) {
        this.switchTo().window(name);
    }

    public void selectWindowByTitle(String title) {
        String originalHandle = this.getWindowHandle();
        for (String handle : this.getWindowHandles()) {
            this.switchTo().window(handle);
            if (StringUtils.isEmpty((String)title)) {
                return;
            }
            if (!title.equals(this.getTitle())) continue;
            return;
        }
        this.switchTo().window(originalHandle);
        throw new IllegalArgumentException("Unable to find window with title: " + title);
    }

    void selectWindow(String windowLocator) {
        if (StringUtils.isEmpty((String)windowLocator)) {
            this.selectWindowByTitle(windowLocator);
            return;
        }
        if (windowLocator.matches("(name|title)\\=.*")) {
            int splitIndex = windowLocator.indexOf("=");
            String type = windowLocator.substring(0, splitIndex);
            String value = windowLocator.substring(splitIndex + 1);
            switch (type) {
                case "name": {
                    windowLocator = value;
                    break;
                }
                case "title": {
                    this.selectWindowByTitle(value);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported window locator: " + windowLocator);
                }
            }
        }
        this.selectWindowByName(windowLocator);
    }

    boolean waitForAndSelectWindow(String windowLocator) {
        return this.waitForAndSelectWindow(windowLocator, 0L);
    }

    boolean waitForAndSelectWindow(String windowLocator, long timeoutInSeconds) {
        return new Waiter(Duration.ofSeconds(timeoutInSeconds)){

            @Override
            boolean success(List<WebElement> results, String windowLocator) {
                try {
                    SmartClientWebDriver.this.selectWindow(windowLocator);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        }.waitFor(null, windowLocator);
    }

    public void scrollIntoViewIfNeeded(By by) {
        this.scrollIntoViewIfNeeded(by, null);
    }

    public boolean scrollIntoViewIfNeeded(By by, WebElement element) {
        if (!(by instanceof ByScLocator)) {
            if (element == null) {
                element = this.findElement(by);
            }
            this.js.executeScript("arguments[0].scrollIntoView();", new Object[]{element});
            return true;
        }
        Boolean scrolled = (Boolean)this.js.executeScript("return isc.AutoTest.scrollElementIntoViewIfNeeded(arguments[0]);", new Object[]{((ByScLocator)by).getLocatorString()});
        if (scrolled.booleanValue()) {
            this.waitForSystemDone(true, true);
            this.js.executeScript("isc.AutoTest.scrolledElementIntoView();", new Object[0]);
        }
        return scrolled;
    }

    private WebElement getElementFromPoint(Point point) {
        return (WebElement)this.js.executeScript("return document.elementFromPoint(arguments[0],arguments[1])", new Object[]{point.getX(), point.getY()});
    }

    private boolean elementIsMasked(WebElement element) {
        return (Boolean)this.js.executeScript("var canvas = isc.AutoTest.locateCanvasFromDOMElement(arguments[0]);return canvas && isc.EH.targetIsMasked(canvas);", new Object[]{element});
    }

    private void clickInternal(By by, boolean scrollIfNeeded) {
        if (scrollIfNeeded) {
            this.scrollIntoViewIfNeeded(by);
        }
        this.clickInternal(by, null);
    }

    private void clickInternal(By by, WebElement element) {
        this.clickInternal(by, element, null, false, 0);
    }

    private void clickInternal(By by, WebElement element, Point coordinates, boolean occluded, int exceptionDepth) {
        WebElement target;
        if (element == null) {
            element = this.findElement(by);
        }
        if (coordinates == null && by instanceof ByScLocator) {
            coordinates = ((ByScLocator)by).findElementCoordinates(this.js);
        }
        if (!(this.isLegacy() || occluded || coordinates == null || element.equals(target = this.getElementFromPoint(coordinates)))) {
            occluded = true;
        }
        try {
            if (occluded) {
                switch (this.occludedApproach) {
                    case NEAREST_DESCENDANT: {
                        if (!this.elementIsMasked(element)) {
                            this.clickOccludedElement(by, element, coordinates);
                            break;
                        }
                    }
                    case ELEMENT_AT_POINT: {
                        WebElement occluding = this.getElementFromPoint(coordinates);
                        this.clickInternal(by, occluding, coordinates, false, exceptionDepth + 1);
                        break;
                    }
                    case ELEMENT: {
                        element.click();
                    }
                }
            } else {
                this.actions.clickAt(element, coordinates).perform();
            }
        }
        catch (ElementNotVisibleException e) {
            if (exceptionDepth > 5) {
                throw e;
            }
            this.clickInternal(by, null, null, true, exceptionDepth + 1);
        }
        catch (StaleElementReferenceException e) {
            if (exceptionDepth > 5) {
                throw e;
            }
            this.clickInternal(by, null, null, occluded, exceptionDepth + 1);
        }
        catch (WebDriverException e) {
            String message = e.getMessage();
            if (message != null && (message.toLowerCase().contains(UNDEFINED_RECT) || message.toLowerCase().contains(COORDS_NO_CLICK_EX))) {
                if (exceptionDepth > 5) {
                    throw e;
                }
                this.clickInternal(by, null, null, true, exceptionDepth + 1);
            }
            throw e;
        }
    }

    private List<Integer> getXCoordinates(List<Point> points) {
        ArrayList<Integer> xCoordinates = new ArrayList<Integer>();
        for (Point point : points) {
            xCoordinates.add(point.x);
        }
        return xCoordinates;
    }

    private List<Integer> getYCoordinates(List<Point> points) {
        ArrayList<Integer> yCoordinates = new ArrayList<Integer>();
        for (Point point : points) {
            yCoordinates.add(point.y);
        }
        return yCoordinates;
    }

    private boolean clickOccludedElement(By by, WebElement element, Point originalCoords) {
        Point location = element.getLocation();
        int left = location.getX();
        int top = location.getY();
        Dimension size = element.getSize();
        float width = size.getWidth();
        float height = size.getHeight();
        float xStep = width / 16.0f;
        float yStep = height / 16.0f;
        ArrayList<Point> points = new ArrayList<Point>();
        int i = 1;
        float offsetX = xStep;
        float offsetY = yStep;
        while (i < 16) {
            points.add(new Point(Math.round((float)left + offsetX), Math.round((float)top + offsetY)));
            ++i;
            offsetX += xStep;
            offsetY += yStep;
        }
        NearestSpecifier nearest = new NearestSpecifier(element, originalCoords, points, (List)this.js.executeScript(CALL_NEAREST_DESCENDANTS, new Object[]{this.getXCoordinates(points), this.getYCoordinates(points), element, originalCoords.x, originalCoords.y}));
        if (nearest.foundElement()) {
            this.actions.clickAt(nearest.getElement(), nearest.getCoordinates()).perform();
            return true;
        }
        System.err.println("Unable to click on occluded element with locator " + by);
        return false;
    }

    public SmartClientWebDriver click(By by) {
        this.js.executeScript("if (isc.EH._isSecondClick == null){ isc.EH._isSecondClick = false;}", new Object[0]);
        try {
            this.clickInternal(by, !this.isLegacy());
        }
        catch (MoveTargetOutOfBoundsException e) {
            try {
                this.actions.boundedMotion();
                this.clickInternal(by, this.isLegacy());
            }
            finally {
                this.actions.bestMotion();
            }
        }
        this.js.executeScript("isc.EH._isSecondClick = null;", new Object[0]);
        return this;
    }

    public SmartClientWebDriver secondClick(By by) {
        this.js.executeScript("isc.EH._isSecondClick = true;", new Object[0]);
        try {
            this.clickInternal(by, !this.isLegacy());
        }
        catch (MoveTargetOutOfBoundsException e) {
            try {
                this.actions.boundedMotion();
                this.clickInternal(by, this.isLegacy());
            }
            finally {
                this.actions.bestMotion();
            }
        }
        this.js.executeScript("isc.EH._isSecondClick = null;", new Object[0]);
        return this;
    }

    public SmartClientWebDriver doubleClick(By by) {
        return this.click(by).secondClick(by);
    }

    public SmartClientWebDriver clickAndHold(By by) {
        try {
            this.clickAndHoldInternal(by, !this.isLegacy());
        }
        catch (MoveTargetOutOfBoundsException e) {
            try {
                this.actions.boundedMotion();
                this.clickAndHoldInternal(by, this.isLegacy());
            }
            finally {
                this.actions.bestMotion();
            }
        }
        return this;
    }

    private void clickAndHoldInternal(By by, boolean scrollIfNeeded) {
        if (scrollIfNeeded) {
            this.scrollIntoViewIfNeeded(by);
        }
        Point coordinates = by instanceof ByScLocator ? ((ByScLocator)by).findElementCoordinates(this.js) : null;
        WebElement element = this.findElement(by);
        this.actions.clickAndHoldAt(element, coordinates).perform();
    }

    public SmartClientWebDriver clickAndHoldAt(By by, int xOffset, int yOffset) {
        try {
            this.clickAndHoldAtInternal(by, xOffset, yOffset, !this.isLegacy(), false);
        }
        catch (MoveTargetOutOfBoundsException e) {
            this.clickAndHoldAtInternal(by, xOffset, yOffset, this.isLegacy(), true);
        }
        return this;
    }

    public void clickAndHoldAtInternal(By by, int xOffset, int yOffset, boolean scrollIfNeeded, boolean limit) {
        if (scrollIfNeeded) {
            this.scrollIntoViewIfNeeded(by);
        }
        WebElement element = this.findElement(by);
        if (limit) {
            Dimension size = element.getSize();
            xOffset = Math.max(0, Math.min(xOffset, size.width - 1));
            yOffset = Math.max(0, Math.min(yOffset, size.height - 1));
        }
        Point coordinates = element.getLocation();
        coordinates = new Point(coordinates.getX() + xOffset, coordinates.getY() + yOffset);
        this.actions.clickAndHoldAt(element, coordinates).perform();
    }

    public SmartClientWebDriver release(By by) {
        try {
            this.releaseInternal(by, !this.isLegacy());
        }
        catch (MoveTargetOutOfBoundsException e) {
            this.releaseInternal(by, this.isLegacy());
        }
        return this;
    }

    private void releaseInternal(By by, boolean scrollIfNeeded) {
        if (scrollIfNeeded) {
            this.scrollIntoViewIfNeeded(by);
        }
        Point coordinates = by instanceof ByScLocator ? ((ByScLocator)by).findElementCoordinates(this.js) : null;
        WebElement element = this.findElement(by);
        this.actions.releaseAt(element, coordinates).perform();
    }

    public SmartClientWebDriver releaseAt(By by, int xOffset, int yOffset) {
        try {
            this.releaseAtInternal(by, xOffset, yOffset, !this.isLegacy(), false);
        }
        catch (MoveTargetOutOfBoundsException e) {
            this.releaseAtInternal(by, xOffset, yOffset, this.isLegacy(), true);
        }
        return this;
    }

    private void releaseAtInternal(By by, int xOffset, int yOffset, boolean scrollIfNeeded, boolean limit) {
        if (scrollIfNeeded) {
            this.scrollIntoViewIfNeeded(by);
        }
        WebElement element = this.findElement(by);
        if (limit) {
            Dimension size = element.getSize();
            xOffset = Math.max(0, Math.min(xOffset, size.width - 1));
            yOffset = Math.max(0, Math.min(yOffset, size.height - 1));
        }
        Point coordinates = element.getLocation();
        coordinates = new Point(coordinates.getX() + xOffset, coordinates.getY() + yOffset);
        this.actions.releaseAt(element, coordinates).perform();
    }

    public SmartClientWebDriver contextClick(By by) {
        Point coordinates = by instanceof ByScLocator ? ((ByScLocator)by).findElementCoordinates(this.js) : null;
        this.actions.contextClickAt(this.findElement(by), coordinates).perform();
        return this;
    }

    public SmartClientWebDriver mouseMove(By by) {
        this.actions.moveToElement(this.findElement(by)).perform();
        return this;
    }

    public SmartClientWebDriver mouseMoveAt(By by, int xOffset, int yOffset) {
        try {
            this.mouseMoveAtInternal(by, xOffset, yOffset, !this.isLegacy(), false);
        }
        catch (MoveTargetOutOfBoundsException e) {
            this.mouseMoveAtInternal(by, xOffset, yOffset, this.isLegacy(), true);
        }
        return this;
    }

    private void mouseMoveAtInternal(By by, int xOffset, int yOffset, boolean scrollIfNeeded, boolean limit) {
        if (scrollIfNeeded) {
            this.scrollIntoViewIfNeeded(by);
        }
        WebElement element = this.findElement(by);
        if (limit) {
            Dimension size = element.getSize();
            xOffset = Math.max(0, Math.min(xOffset, size.width - 1));
            yOffset = Math.max(0, Math.min(yOffset, size.height - 1));
        }
        Point coordinates = element.getLocation();
        coordinates = new Point(coordinates.getX() + xOffset, coordinates.getY() + yOffset);
        this.actions.moveToElement(element, coordinates).perform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmartClientWebDriver dragAndDrop(By sourceBy, By targetBy) {
        try {
            if (this.isEdgeLocator(sourceBy)) {
                this.actions.edgeMotion();
            }
            this.clickAndHold(sourceBy);
        }
        finally {
            this.actions.bodyMotion();
        }
        if (targetBy instanceof ByScLocator) {
            String targetLocator = ((ByScLocator)targetBy).getLocatorString();
            Object dropPosition = this.js.executeScript("var dropElement = isc.AutoTest.getElement(arguments[0]),gridRenderer = isc.AutoTest.locateCanvasFromDOMElement(dropElement);if (!isc.isA.GridRenderer(gridRenderer)) return null;if (gridRenderer.getHandle() == dropElement) return 'body';return Math.ceil(dropElement.offsetHeight/8);", new Object[]{targetLocator});
            if ("body".equals(dropPosition)) {
                if (!targetLocator.matches(".*/[TBLR]+")) {
                    targetLocator = targetLocator + (targetLocator.endsWith("/") ? "B" : "/B");
                    targetBy = ByScLocator.scLocator(targetLocator);
                }
            } else if (dropPosition instanceof Long) {
                int yOffset = targetLocator.matches(".*/(?i:after)") ? 0 : ((Long)dropPosition).intValue();
                Point elementPoint = this.findElement(targetBy).getLocation();
                Point locatorPoint = ((ByScLocator)targetBy).findElementCoordinates(this.js);
                this.releaseAt(targetBy, locatorPoint.x - elementPoint.x, locatorPoint.y - elementPoint.y + yOffset);
                return this;
            }
        }
        try {
            if (this.isEdgeLocator(targetBy)) {
                this.actions.edgeMotion();
            }
            this.release(targetBy);
        }
        finally {
            this.actions.bodyMotion();
        }
        return this;
    }

    public SmartClientWebDriver dragAndDrop(By sourceBy, String offset) {
        String[] xy = offset.replace("+", "").split(",");
        int xOffset = 0;
        int yOffset = 0;
        try {
            xOffset = Integer.parseInt(xy[0].trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            yOffset = Integer.parseInt(xy[1].trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.dragAndDropBy(sourceBy, xOffset, yOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmartClientWebDriver dragAndDropBy(By sourceBy, int xOffset, int yOffset) {
        try {
            if (this.isEdgeLocator(sourceBy)) {
                this.actions.edgeMotion();
            }
            if (sourceBy instanceof ByScLocator) {
                Point coordinates = ((ByScLocator)sourceBy).findElementCoordinates(this.js);
                this.actions.dragAndDropBy(this.findElement(sourceBy), coordinates, xOffset, yOffset).perform();
            } else {
                this.actions.dragAndDropBy(this.findElement(sourceBy), xOffset, yOffset).perform();
            }
        }
        finally {
            this.actions.bodyMotion();
        }
        return this;
    }

    private boolean isEdgeLocator(By by) {
        if (by instanceof ByScLocator) {
            return ((ByScLocator)by).isEdge();
        }
        return false;
    }

    public SmartClientWebDriver sendKeys(By by, String keysToSend) {
        this.focus(by);
        if (this.isLegacy()) {
            this.actions.sendKeys(this.findElement(by), keysToSend).perform();
            return this;
        }
        this.actions.sendKeys(this.findElement(by), "");
        Pattern pattern = Pattern.compile(MODIFIER_REGEX);
        Matcher matcher = pattern.matcher(keysToSend);
        int end = 0;
        while (matcher.find()) {
            int start = matcher.start();
            if (end < start) {
                this.actions.sendKeys(null, keysToSend.substring(end, start));
            }
            end = matcher.end();
            int keyCode = this.modifierCharMap.get(Character.valueOf(keysToSend.charAt(start)));
            if (this.keysDown[keyCode] == 0) {
                this.actions.keyDown(null, this.getWebDriverKey(keyCode));
                int n = keyCode;
                this.keysDown[n] = this.keysDown[n] + 1;
                continue;
            }
            if (this.keysDown[keyCode] != 1) continue;
            this.actions.keyUp(null, this.getWebDriverKey(keyCode));
            int n = keyCode;
            this.keysDown[n] = this.keysDown[n] - 1;
        }
        if (end < keysToSend.length()) {
            this.actions.sendKeys(null, keysToSend.substring(end));
        }
        this.actions.perform();
        return this;
    }

    public SmartClientWebDriver sendKeys(By by, CharSequence ... keysToSend) {
        StringBuffer buffer = new StringBuffer();
        for (CharSequence charSequence : keysToSend) {
            buffer.append(charSequence);
        }
        return this.sendKeys(by, buffer.toString());
    }

    public SmartClientWebDriver type(By by) {
        return this.type(by, "");
    }

    public SmartClientWebDriver type(By by, String keysToSend) {
        WebElement element;
        block5: {
            element = this.findElement(by);
            try {
                element.clear();
            }
            catch (InvalidElementStateException e) {
                String message = e.getMessage();
                if (message.matches(CANNOT_CLEAR_NON_EDITABLE)) break block5;
                throw e;
            }
        }
        this.focus(by);
        element = this.findElement(by);
        while (element != null) {
            try {
                element.sendKeys(new CharSequence[]{keysToSend});
                break;
            }
            catch (ElementNotInteractableException e) {
                element = this.getParentElement(element);
            }
        }
        this.js.executeScript("var item = isc.AutoTest.getObject(arguments[0]); if (isc.isA.FormItem(item)) {if (isc.isA.ComboBoxItem(item)) item.refreshPickList(arguments[1]);item._handleInput();}", new Object[]{((ByScLocator)by).getLocatorString(), keysToSend});
        return this;
    }

    public SmartClientWebDriver type(By by, Long keyToSend) {
        this.type(by, keyToSend.toString());
        return this;
    }

    private Keys getWebDriverKey(int seleniumCode) {
        switch (seleniumCode) {
            case 8: {
                return Keys.BACK_SPACE;
            }
            case 9: {
                return Keys.TAB;
            }
            case 13: {
                return Keys.ENTER;
            }
            case 16: {
                return Keys.SHIFT;
            }
            case 17: {
                return Keys.CONTROL;
            }
            case 32: {
                return Keys.SPACE;
            }
            case 35: {
                return Keys.END;
            }
            case 36: {
                return Keys.HOME;
            }
            case 37: {
                return Keys.ARROW_LEFT;
            }
            case 38: {
                return Keys.ARROW_UP;
            }
            case 39: {
                return Keys.ARROW_RIGHT;
            }
            case 40: {
                return Keys.ARROW_DOWN;
            }
            case 46: {
                return Keys.DELETE;
            }
        }
        System.err.println("Unmapped selenium keyCode: " + seleniumCode);
        return null;
    }

    public SmartClientWebDriver keyPress(By by, Long charToSend) {
        Keys key = this.getWebDriverKey(charToSend.intValue());
        if (this.keysDown[charToSend.intValue()] <= 0) {
            this.actions.sendKeys(null, new CharSequence[]{key}).perform();
        }
        return this;
    }

    public SmartClientWebDriver keyPress(By by, String keysToSend) {
        this.actions.sendKeys(null, keysToSend).perform();
        return this;
    }

    public SmartClientWebDriver keyDown(By by, Long charToSend) {
        Keys key = this.getWebDriverKey(charToSend.intValue());
        if (key.equals((Object)Keys.ENTER)) {
            this.actions.sendKeys(this.findElement(by), new CharSequence[]{key}).perform();
            return this;
        }
        try {
            if (this.keysDown[charToSend.intValue()] == 0) {
                this.keyDown(null, key);
            }
            int n = charToSend.intValue();
            this.keysDown[n] = this.keysDown[n] + 1;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: keyDown/keyUp ignored for non-modifier key " + charToSend + " @ " + by + " - use keyPress instead");
        }
        return this;
    }

    public SmartClientWebDriver keyUp(By by, Long charToSend) {
        Keys key = this.getWebDriverKey(charToSend.intValue());
        try {
            int n = charToSend.intValue();
            this.keysDown[n] = this.keysDown[n] - 1;
            if (this.keysDown[charToSend.intValue()] == 0) {
                this.keyUp(null, key);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: keyDown/keyUp ignored for non-modifier key " + charToSend + " @ " + by + " - use keyPress instead");
        }
        return this;
    }

    public SmartClientWebDriver keyDown(By by, Keys theKey) {
        this.actions.keyDown(this.findElement(by), theKey).perform();
        return this;
    }

    public SmartClientWebDriver keyUp(By by, Keys theKey) {
        this.actions.keyUp(this.findElement(by), theKey).perform();
        return this;
    }

    SmartClientWebDriver shiftKeyDown(By by) {
        return this.keyDown(null, 16L);
    }

    SmartClientWebDriver shiftKeyUp(By by) {
        return this.keyUp(null, 16L);
    }

    public SmartClientWebDriver shiftKeyDown() {
        return this.shiftKeyDown(null);
    }

    public SmartClientWebDriver shiftKeyUp() {
        return this.shiftKeyUp(null);
    }

    public SmartClientWebDriver controlKeyDown() {
        return this.keyDown(null, 17L);
    }

    public SmartClientWebDriver controlKeyUp() {
        return this.keyUp(null, 17L);
    }

    protected WebElement getParentElement(WebElement element) {
        return (WebElement)this.executeScript("return arguments[0].parentElement", element);
    }

    public SmartClientWebDriver focus(By by) {
        return this.focus(by, false);
    }

    public SmartClientWebDriver focus(By by, boolean clearModifiers) {
        return this.focus(by, clearModifiers, false);
    }

    public SmartClientWebDriver focus(By by, boolean clearModifiers, boolean refocus) {
        WebElement element = this.findElement(by);
        if (by instanceof ByScLocator) {
            Boolean focused = (Boolean)this.js.executeScript("return isc.AutoTest.locatorFocus(arguments[0],arguments[1]);", new Object[]{((ByScLocator)by).getLocatorString(), refocus});
            if (!Boolean.FALSE.equals(focused) && !this.waitForElementReadyForKeyPresses(by)) {
                throw new FocusInconsistentException("Unable to focus on " + by);
            }
        } else if (element != null) {
            this.js.executeScript("var element = arguments[0]; if (element.focus) element.focus()", new Object[]{element});
        }
        if (clearModifiers) {
            this.actions.sendKeys(element, MODIFIER_CLEAR_SEQUENCE).perform();
        }
        return this;
    }

    public SmartClientWebDriver blur(By by) {
        for (WebElement element : this.findElements(by)) {
            this.js.executeScript("var element = arguments[0]; if (element.blur) element.blur()", new Object[]{element});
        }
        return this;
    }

    protected void setForClientOnlyOperation(By scLocator) {
        WebElement element = this.findElement(scLocator);
        this.js.executeScript("var dbc = isc.AutoTest.locateCanvasFromDOMElement(arguments[0]); if (!isc.isA.DataBoundComponent(dbc)) return; var ds = dbc.getDataSource(); if (ds && !ds.clientOnly) {ds.autoCacheAllData = true; ds.invalidateCache(); ds.fetchData()}", new Object[]{element});
    }

    protected boolean waitForClientOnlyReady(By scLocator) {
        WebElement element = this.findElement(scLocator);
        return this.waitForCondition("var dbc = isc.AutoTest.locateCanvasFromDOMElement(arguments[0]); if (!isc.isA.DataBoundComponent(dbc)) return true; var ds = dbc.getDataSource(); if (ds && !ds.clientOnly) {if (!ds.hasAllData()) return false; ds.setClientOnly(true);} return true;", 0L, element);
    }

    public void showConsole() {
        this.js.executeScript("isc.showConsole()", new Object[0]);
    }

    public void setClientLogLevel(String category, long level) {
        this.js.executeScript("isc.Log.setPriority(category, isc.Log[" + level + "])", new Object[0]);
    }

    public void setClientLogLevel(String category, String level) {
        this.js.executeScript("isc.Log.setPriority(category, isc.Log['" + level + "'])", new Object[0]);
    }

    protected void setServerLogMode(String mode) {
        if (mode == null) {
            this.serverLogMode = null;
        } else {
            switch (mode) {
                case "all": {
                    this.serverLogMode = ServerLogMode.ALL;
                    break;
                }
                case "some": {
                    this.serverLogMode = ServerLogMode.SOME;
                }
            }
        }
    }

    public List<String> getClientLogs() {
        return (List)this.js.executeScript("return isc.Log.getMessages()", new Object[0]);
    }

    public void captureServerLogs() {
        if (this.captureServerLogs) {
            return;
        }
        if (this.serverLogMode == null) {
            System.err.println("Ignoring captureServerLogs() command since SmartClientWebDriver has not been configured to receive any server logs");
            return;
        }
        this.captureServerLogs = true;
        this.waitForCondition("isc.DMI.clearServerLogs();");
    }

    public void setServerLogLevel(String category, String level) {
        if (!this.waitForCondition("isc.DMI.configureServerLogs(arguments);", 0L, category, level)) {
            System.err.println("Timed out trying to set server log level for " + category + " to " + level);
        }
    }

    public List<String> getServerLogs() {
        this.executeScript("isc.DMI.requestServerLogs()", new Object[0]);
        if (!this.waitForCondition("isc.DMI.receivedServerLogs()")) {
            System.err.println("Timed out waiting for server logs");
            return new ArrayList<String>();
        }
        return (List)this.executeScript("return isc.DMI.getServerLogs()", new Object[0]);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        return this.driver.findElements(by);
    }

    public WebElement findElement(By by) {
        if (by == null) {
            return null;
        }
        return this.driver.findElement(by);
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.driver.close();
    }

    public void quit() {
        this.driver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.driver.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public Keyboard getKeyboard() {
        return this.driver.getKeyboard();
    }

    public Mouse getMouse() {
        return this.driver.getMouse();
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        return (X)this.driver.getScreenshotAs(target);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.driver.executeAsyncScript(script, args);
    }

    public Object executeScript(String script, Object ... args) {
        return this.driver.executeScript(script, args);
    }

    public void perform(Collection<Sequence> actions) {
        this.driver.perform(actions);
    }

    public void resetInputState() {
        this.driver.resetInputState();
    }

    public static class FocusInconsistentException
    extends RuntimeException {
        public FocusInconsistentException(String message) {
            super(message);
        }
    }

    private static class NearestSpecifier {
        private List specifier;
        private Point original;
        private WebElement element;
        private List<Point> points;

        public NearestSpecifier(WebElement element, Point original, List<Point> points, List specifier) {
            this.points = points;
            this.element = element;
            this.original = original;
            this.specifier = specifier;
        }

        public boolean foundElement() {
            return this.specifier != null;
        }

        public WebElement getElement() {
            long index = (Long)this.specifier.get(1);
            return index >= 0L ? (WebElement)this.specifier.get(0) : this.element;
        }

        public Point getCoordinates() {
            long index = (Long)this.specifier.get(1);
            return index >= 0L ? this.points.get((int)index) : this.original;
        }
    }

    private abstract class Waiter {
        private Duration timeout;

        public Waiter(Duration timeout) {
            this.timeout = SmartClientWebDriver.this.timeout;
            if (timeout.toMillis() > 0L) {
                this.timeout = timeout;
            }
        }

        List<WebElement> operation(By by) {
            if (by == null) {
                return Collections.emptyList();
            }
            return SmartClientWebDriver.this.findElements(by);
        }

        abstract boolean success(List<WebElement> var1, String var2);

        public boolean waitFor(By by, String argument) {
            long maximumTicks = this.timeout.toMillis() / 100L;
            try {
                int tick = 0;
                while ((long)tick <= maximumTicks) {
                    List<WebElement> elements = this.operation(by);
                    try {
                        if (this.success(elements, argument)) {
                            for (WebElement element : elements) {
                                element.getLocation();
                            }
                            return true;
                        }
                        Thread.sleep(100L);
                    }
                    catch (StaleElementReferenceException e) {
                        Thread.sleep(100L);
                    }
                    ++tick;
                }
            }
            catch (InterruptedException e) {
                System.err.println("WebDriver.waiter interrupted: " + e);
            }
            return false;
        }
    }

    private class ToleranceChecker
    extends RegExMatcher {
        private ToleranceChecker() {
        }

        @Override
        public boolean compare(Object expected, Object value) {
            if (expected instanceof Number && value instanceof Number) {
                double error = Math.abs(((Number)value).doubleValue() - ((Number)expected).doubleValue());
                if (error > (double)SmartClientWebDriver.this.valueTolerance) {
                    this.printErr("Expected '" + expected + "' and found: '" + value + "' values differ by more than " + SmartClientWebDriver.this.valueTolerance);
                    return false;
                }
                return true;
            }
            if (expected instanceof List && value instanceof List) {
                return this.compare((List)expected, (List)value);
            }
            return super.compare(expected, value);
        }

        @Override
        public boolean compare(String expected, List value) {
            return this.compare(Operation.parseDoubleList(expected), value);
        }

        public boolean compare(List expected, List value) {
            int nExpected;
            int nValue = value.size();
            if (nValue != (nExpected = expected.size())) {
                this.printErr("Expected and found Java arrays have different lengths: '" + expected + "' != '" + value + "'");
                return false;
            }
            for (int i = 0; i < nValue; ++i) {
                if (this.compare(expected.get(i), value.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean compare(String expected, String value) {
            String[] expecteds;
            String[] values = value.split("(\\s)*,(\\s)*");
            if (values.length != (expecteds = expected.split("(\\s)*,(\\s)*")).length) {
                this.printErr("Expected and found String-format arrays have different lengths: '" + expected + "' != '" + value + "'");
                return false;
            }
            for (int i = 0; i < values.length; ++i) {
                boolean result;
                boolean bl = result = Operation.isDouble(values[i]) && Operation.isDouble(expecteds[i]) ? this.compare(Operation.parseDouble(values[i]), (Object)Operation.parseDouble(expecteds[i])) : super.compare(values[i], expecteds[i]);
                if (result) continue;
                return false;
            }
            return true;
        }
    }

    private class RegExMatcher
    implements ValueComparator {
        boolean showErrs = true;

        private RegExMatcher() {
        }

        @Override
        public void showErrors() {
            this.showErrs = true;
        }

        @Override
        public void hideErrors() {
            this.showErrs = false;
        }

        @Override
        public void printErr(String message) {
            if (this.showErrs) {
                System.err.println(message);
            }
        }

        @Override
        public boolean compare(Object expected, Object value) {
            boolean match;
            boolean bl = expected == null ? value == null : (match = expected.equals(value));
            if (!match) {
                this.printErr("Expected: '" + expected + "', found: '" + value + "'");
            }
            return match;
        }

        @Override
        public boolean compare(Long expected, String value) {
            return this.compare(expected == null ? null : expected.toString(), value);
        }

        @Override
        public boolean compare(Long expected, Integer value) {
            return this.compare((Object)expected, (Object)value);
        }

        @Override
        public boolean compare(Long expected, Double value) {
            return this.compare((Object)expected, (Object)value);
        }

        @Override
        public boolean compare(String expected, Integer value) {
            return this.compare(expected == null ? null : Integer.valueOf(Integer.parseInt(expected)), (Object)value);
        }

        @Override
        public boolean compare(String expected, Long value) {
            return this.compare((Object)(expected == null ? null : Long.valueOf(Long.parseLong(expected))), (Object)value);
        }

        @Override
        public boolean compare(String expected, Double value) {
            return this.compare(expected == null ? null : Double.valueOf(Double.parseDouble(expected)), (Object)value);
        }

        @Override
        public boolean compare(String expected, Boolean value) {
            return this.compare(expected == null ? null : Boolean.valueOf(expected), (Object)value);
        }

        @Override
        public boolean compare(String expected, List value) {
            return this.compare(expected, String.valueOf(value));
        }

        @Override
        public boolean compare(String expected, String value) {
            String pattern = SmartClientWebDriver.getPatternRegEx(expected);
            return Pattern.matches(pattern.trim(), value.trim());
        }
    }

    private static enum EvalResultType {
        STRING,
        OBJECT,
        BOOLEAN;

    }

    public static enum OccludedElementApproach {
        NEAREST_DESCENDANT,
        ELEMENT_AT_POINT,
        ELEMENT,
        SKIP;

    }

    private static enum ServerLogMode {
        ALL,
        SOME;

    }
}

