/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.log.Logger;
import com.isomorphic.messaging.ISCMessage;
import com.isomorphic.messaging.ISCMessageDispatcher;
import com.isomorphic.messaging.ISubscriber;
import com.isomorphic.util.DataTools;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocalMessageDispatcher
extends ISCMessageDispatcher {
    private static Logger log = new Logger(LocalMessageDispatcher.class.getName());
    private static final Map<String, Set<ISubscriber>> channelToSubscriberMap = new HashMap<String, Set<ISubscriber>>();
    private static final Map<String, String> selectorForSubscribedChannelMap = new HashMap<String, String>();
    private static final Map<ISubscriber, Set<String>> subscriberToChannelMap = new HashMap<ISubscriber, Set<String>>();
    private static final Set<ISubscriber> localSubscribers = new HashSet<ISubscriber>();
    String clientID;

    @Override
    public void setClientID(String clientID) throws Exception {
        this.clientID = clientID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ISubscriber subscriber) throws Exception {
        Class<LocalMessageDispatcher> clazz = LocalMessageDispatcher.class;
        synchronized (LocalMessageDispatcher.class) {
            localSubscribers.add(subscriber);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ISubscriber subscriber) throws Exception {
        Class<LocalMessageDispatcher> clazz = LocalMessageDispatcher.class;
        synchronized (LocalMessageDispatcher.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localSubscribers.contains(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ISubscriber subscriber) throws Exception {
        Class<LocalMessageDispatcher> clazz = LocalMessageDispatcher.class;
        synchronized (LocalMessageDispatcher.class) {
            Set<String> channels = subscriberToChannelMap.get(subscriber);
            if (channels != null) {
                channels = new HashSet<String>(channels);
            }
            if (channels != null) {
                log.debug((Object)("unregistering channels: " + DataTools.prettyPrint(channels)));
                for (String channel : channels) {
                    log.debug((Object)("unregistering channel: " + channel));
                    this.unsubscribe(subscriber, channel);
                }
            }
            localSubscribers.remove(subscriber);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(ISubscriber subscriber, String channel, String selector) throws Exception {
        Class<LocalMessageDispatcher> clazz = LocalMessageDispatcher.class;
        synchronized (LocalMessageDispatcher.class) {
            Set<String> channels = subscriberToChannelMap.get(subscriber);
            if (channels == null) {
                channels = new HashSet<String>();
                subscriberToChannelMap.put(subscriber, channels);
            }
            channels.add(channel);
            Set<ISubscriber> subscribers = channelToSubscriberMap.get(channel);
            if (subscribers == null) {
                subscribers = new HashSet<ISubscriber>();
                channelToSubscriberMap.put(channel, subscribers);
            }
            subscribers.add(subscriber);
            if (selectorForSubscribedChannelMap.get(channel) == null && selector != null) {
                selectorForSubscribedChannelMap.put(channel, selector);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(ISubscriber subscriber, String channel) throws Exception {
        Class<LocalMessageDispatcher> clazz = LocalMessageDispatcher.class;
        synchronized (LocalMessageDispatcher.class) {
            Set<String> channels;
            Set<ISubscriber> subscribers = channelToSubscriberMap.get(channel);
            if (subscribers != null) {
                subscribers.remove(subscriber);
            }
            if ((channels = subscriberToChannelMap.get(subscriber)) != null) {
                channels.remove(channel);
                if (channels.isEmpty()) {
                    subscriberToChannelMap.remove(subscriber);
                }
            }
            selectorForSubscribedChannelMap.remove(channel);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubscribed(ISubscriber subscriber, String channel) throws Exception {
        Class<LocalMessageDispatcher> clazz = LocalMessageDispatcher.class;
        synchronized (LocalMessageDispatcher.class) {
            Set<String> channels = subscriberToChannelMap.get(subscriber);
            if (channels != null && channels.contains(channel)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliver(ISCMessage msg) throws Exception {
        List<String> targetChannels = msg.getTargetChannels();
        if (targetChannels == null) {
            return;
        }
        HashMap<ISubscriber, ISCMessage> targetSubscriberToMessageMap = new HashMap<ISubscriber, ISCMessage>();
        Class<ISCMessageDispatcher> clazz = ISCMessageDispatcher.class;
        synchronized (ISCMessageDispatcher.class) {
            for (String channel : targetChannels) {
                log.debug((Object)("sending message to channel: " + channel));
                Set<ISubscriber> channelMembers = channelToSubscriberMap.get(channel);
                if (channelMembers == null) continue;
                for (ISubscriber subscriber : channelMembers) {
                    if (targetSubscriberToMessageMap.containsKey(subscriber)) continue;
                    List channelsIntersection = DataTools.setIntersection(targetChannels, (Collection)subscriberToChannelMap.get(subscriber));
                    ISCMessage targetedMessage = new ISCMessage(channelsIntersection, msg.getData(), msg.getID());
                    targetSubscriberToMessageMap.put(subscriber, targetedMessage);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (Map.Entry e : targetSubscriberToMessageMap.entrySet()) {
                ISubscriber s = (ISubscriber)e.getKey();
                ISCMessage targetedMessage = (ISCMessage)e.getValue();
                try {
                    s.send(targetedMessage);
                }
                catch (Exception ee) {
                    log.warn((Object)("Failed to deliver messsage " + targetedMessage.getID() + " to subscriber '" + s.hashCode() + "' delivering to channel(s): " + targetedMessage.getTargetChannels()), (Throwable)ee);
                }
            }
            return;
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void closeConnection() {
    }
}

