/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools.dmi;

import com.isomorphic.auth.Authentication;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class ReifyCustomizations
extends SQLDataSource {
    protected static Logger log = new Logger(ReifyCustomizations.class);
    public static final String CSS_MIMETYPE = "text/css";

    public static String getCustomJS(Long orgId, Long devId, String loadTiming, boolean insideScriptTag, HttpServletRequest context) throws Exception {
        return ReifyCustomizations.getCustomJS(orgId, devId, loadTiming, "designTime", true, insideScriptTag, null, context);
    }

    public static String getCustomJS(Long orgId, Long devId, List<String> loadTimings, boolean checkUser, String loadStyleRule, HttpServletRequest context) throws Exception {
        LoadStyleRule rule = loadStyleRule != null ? LoadStyleRule.valueOf(loadStyleRule) : null;
        StringBuffer buffer = new StringBuffer();
        boolean content = false;
        for (String loadTiming : loadTimings) {
            String timingJS = ReifyCustomizations.getCustomJS(orgId, devId, loadTiming, "runTime", checkUser, true, rule, context);
            if (StringUtils.isEmpty((String)timingJS)) continue;
            if (content) {
                buffer.append("\n");
            }
            buffer.append(timingJS);
            content = true;
        }
        return buffer.toString();
    }

    private static Map getCriteria(Long orgId, Long devId, String environment, LoadStyleRule loadStyleRule) {
        DataTypeMap crit = DataTools.buildMap((Object[])new Object[]{"devId", devId});
        if (orgId != null) {
            crit.put("orgId", orgId);
        }
        if (loadStyleRule != null) {
            switch (loadStyleRule) {
                case EXTERNAL_FILES_ONLY: {
                    crit.put("loadStyle", "externalFile");
                    break;
                }
                case SKIP_EXTERNAL_FILES: {
                    crit.put("loadStyle", Arrays.asList("inline", "reference"));
                }
            }
        }
        if (environment != null && !environment.equals("both")) {
            crit.put("environment", Arrays.asList("both", null, environment));
        }
        return crit;
    }

    private static Map<String, List> getCustomJS(Long orgId, Long devId, String environment, boolean checkUser, LoadStyleRule loadStyleRule) throws Exception {
        List records;
        String loadTiming;
        Map work;
        int i;
        List data;
        Map crit;
        DSRequest req;
        HashMap<String, List> customizations = new HashMap<String, List>();
        if (orgId != null) {
            req = new DSRequest("isc_reifyCustomizations", "fetch");
            req.setSortBy(Arrays.asList("environment", "id"));
            crit = ReifyCustomizations.getCriteria(orgId, null, environment, loadStyleRule);
            req.setCriteria((Object)crit);
            data = req.execute().getDataList();
            if (data != null && data.size() > 0) {
                for (i = 0; i < data.size(); ++i) {
                    work = (Map)data.get(i);
                    loadTiming = (String)work.get("loadTiming");
                    records = (ArrayList<Map>)customizations.get(loadTiming);
                    if (records == null) {
                        records = new ArrayList<Map>();
                        customizations.put(loadTiming, records);
                    }
                    records.add(work);
                }
            }
        }
        if (checkUser) {
            req = new DSRequest("isc_reifyCustomizations", "fetch");
            req.setSortBy(Arrays.asList("environment", "id"));
            crit = ReifyCustomizations.getCriteria(null, devId, environment, loadStyleRule);
            req.setCriteria((Object)crit);
            data = req.execute().getDataList();
            if (data != null && data.size() > 0) {
                for (i = 0; i < data.size(); ++i) {
                    work = (Map)data.get(i);
                    loadTiming = (String)work.get("loadTiming");
                    records = (List)customizations.get(loadTiming);
                    if (records == null) {
                        records = new ArrayList();
                        customizations.put(loadTiming, records);
                    }
                    records.add(work);
                }
            }
        }
        return customizations;
    }

    private static String getCustomJS(Long orgId, Long devId, String loadTiming, String environment, boolean checkUser, boolean insideScriptTag, LoadStyleRule loadStyleRule, HttpServletRequest context) throws Exception {
        Map<String, List> customizations = ReifyCustomizations.getCachedCustomizations(orgId, devId, environment, checkUser, loadStyleRule, context);
        List timingCustoms = customizations.get(loadTiming);
        if (timingCustoms == null) {
            return "";
        }
        ArrayList<Map> inlineCustoms = new ArrayList<Map>();
        ArrayList inlineCSS = new ArrayList();
        ArrayList viaURLCustoms = new ArrayList();
        boolean includesJS = false;
        boolean includesCSS = false;
        for (Map customization : timingCustoms) {
            Object target;
            switch (customization.getOrDefault("loadStyle", "inline")) {
                default: {
                    target = CSS_MIMETYPE.equals(customization.get("mimeType")) ? inlineCSS : inlineCustoms;
                    break;
                }
                case "reference": {
                    target = "runTime".equals(environment) ? inlineCustoms : viaURLCustoms;
                    break;
                }
                case "externalFile": {
                    target = viaURLCustoms;
                }
            }
            target.add(customization);
        }
        String script = "";
        if (inlineCSS.size() > 0) {
            if (ReifyCustomizations.deferExecution(loadTiming, environment)) {
                log.error((Object)("Cannot include a CSS reifyCustomization at loadTiming point '" + loadTiming + "' because that implies deferred execution, which makes no sense for CSS text"));
            } else {
                if (insideScriptTag) {
                    script = script + "</script>\n";
                }
                script = script + "<style>\n";
                boolean content = false;
                for (Map map : inlineCSS) {
                    String inline = (String)map.get("contents");
                    if (inline != null) {
                        inline = inline.trim();
                    }
                    if (StringUtils.isEmpty((String)inline)) continue;
                    if (content) {
                        script = script + "\n";
                    }
                    script = script + inline;
                    content = true;
                }
            }
            script = script + "\n</style>";
            if (insideScriptTag) {
                script = script + "\n<script>\n";
            }
        }
        if (inlineCustoms.size() > 0) {
            if (!insideScriptTag) {
                script = script + "<script>\n";
            }
            if (ReifyCustomizations.deferExecution(loadTiming, environment)) {
                script = script + "isc." + loadTiming + "Custom = function() {\n";
            }
            boolean content = false;
            for (Map map : inlineCustoms) {
                String inlineJS = (String)map.get("contents");
                if (inlineJS != null) {
                    inlineJS = inlineJS.trim();
                }
                if (StringUtils.isEmpty((String)inlineJS)) continue;
                if (content) {
                    script = script + "\n";
                }
                script = script + inlineJS;
                content = true;
            }
            if (ReifyCustomizations.deferExecution(loadTiming, environment)) {
                script = script + "\n}";
            }
            script = script + (insideScriptTag ? "" : "\n</script>");
        }
        if (viaURLCustoms.size() > 0) {
            ArrayList<String> jsURLs = new ArrayList<String>();
            ArrayList<String> cssURLs = new ArrayList<String>();
            for (Map customization : viaURLCustoms) {
                String url = null;
                switch ((String)customization.get("loadStyle")) {
                    case "reference": {
                        int id = (Integer)customization.get("id");
                        url = ReifyCustomizations.getRESTURL(id);
                        break;
                    }
                    case "externalFile": {
                        url = (String)customization.get("contents");
                    }
                }
                if (url == null) continue;
                if (CSS_MIMETYPE.equals(customization.get("mimeType"))) {
                    cssURLs.add("\"" + url.trim() + "\"");
                    continue;
                }
                jsURLs.add("\"" + url.trim() + "\"");
            }
            if (insideScriptTag) {
                script = script + "</script>\n";
            }
            if (!ReifyCustomizations.deferExecution(loadTiming, environment)) {
                for (String url : cssURLs) {
                    script = script + "<link href=\"" + url + "\" rel=\"stylesheet\">\n";
                }
                for (String url : jsURLs) {
                    script = script + "<script src=" + url + "></script>\n";
                }
            } else {
                if (cssURLs.size() > 0) {
                    log.error((Object)("Cannot include a CSS reifyCustomization at loadTiming point '" + loadTiming + "' because that implies deferred execution, which makes no sense for CSS text"));
                }
                String string = "[" + String.join((CharSequence)",", jsURLs) + "]";
                script = script + "<script>\nisc." + loadTiming + "Loading = true;\nisc.Log.logInfo('Ready to call FL.ensureLoaded for " + loadTiming + "');\nisc.FileLoader.ensureLoaded(function() {\n    isc.Log.logInfo('In FL.ensureLoaded callback.  Loading " + loadTiming + "');\n    isc.FileLoader.cacheFiles(" + jsURLs + ", \"isc." + loadTiming + "Loaded()\", \"js\");\n});\nisc." + loadTiming + "Loaded = function() {\n    isc.Log.logInfo('In " + loadTiming + "Loaded');\n    delete isc." + loadTiming + "Loading;\n    if (isc." + loadTiming + "Waiting) {\n        delete isc." + loadTiming + "Waiting;\n        isc.Log.logInfo('Reached wait point, loading " + loadTiming + "');\n        isc.FileLoader.loadFiles(" + jsURLs + ", function() {\n            isc.Log.logInfo('Finished loading " + loadTiming + "');\n            isc." + loadTiming + "LoadCompleted = true;\n            VB." + loadTiming + "CustomCallback();\n        }, \"js\");\n    } else {\n        isc.Log.logInfo('Not yet reached trigger point for " + loadTiming + " insertion.  Waiting...')\n    }\n}\n</script>\n";
            }
            if (insideScriptTag) {
                script = script + "<script>\n";
            }
        }
        return script;
    }

    private static boolean deferExecution(String loadTiming, String environment) {
        if ("runTime".equals(environment)) {
            return false;
        }
        return loadTiming.equals("afterPalette") || loadTiming.equals("afterProject");
    }

    private static String getRESTURL(int id) {
        return "isomorphic/RESTHandler?isc_isReifyCustomizationRequest=true&isc_dataFormat=json&operationType=viewFile&_dataSource=isc_reifyCustomizations&download_fieldname=contents&id=" + id;
    }

    private static String getCacheKey(LoadStyleRule rule) {
        String key = "_reifyCustomizations_";
        if (rule != null) {
            key = key + (Object)((Object)rule);
        }
        return key;
    }

    private static Map<String, List> getCachedCustomizations(Long orgId, Long devId, String environment, boolean checkUser, LoadStyleRule rule, HttpServletRequest context) throws Exception {
        Map<String, List> customizations;
        String cacheKey = ReifyCustomizations.getCacheKey(rule);
        Map<String, List> map = customizations = context != null ? (Map<String, List>)context.getAttribute(cacheKey) : null;
        if (customizations == null) {
            customizations = ReifyCustomizations.getCustomJS(orgId, devId, environment, checkUser, rule);
            if (context != null) {
                context.setAttribute(cacheKey, customizations);
            }
        }
        return customizations;
    }

    public DSResponse execute(DSRequest req) throws Exception {
        if (!"viewFile".equals(req.getOperationType()) && req.getHttpServletRequest() != null && !req.isUserInRole("superuser", req.getHttpServletRequest())) {
            return (DSResponse)new DSResponse().setStatus(-3);
        }
        return super.execute(req);
    }

    public DSResponse executeDownload(DSRequest req) throws Exception {
        DSResponse resp = super.executeDownload(req);
        Map record = (Map)resp.getData();
        Map user = (Map)Authentication.getUser((RequestContext)req.getRequestContext());
        Integer devId = (Integer)record.get("devId");
        Integer orgId = (Integer)record.get("orgId");
        if (user == null || devId != null && user.get("id") != devId || orgId != null && user.get("orgId") != orgId) {
            resp = new DSResponse();
            resp.setStatus(-3);
            return resp;
        }
        String contents = (String)record.get(req.getDownloadFieldName());
        record.put(req.getDownloadFieldName(), contents.getBytes("UTF-8"));
        resp.setData((Object)record);
        return resp;
    }

    public static enum LoadStyleRule {
        EXTERNAL_FILES_ONLY,
        SKIP_EXTERNAL_FILES;

    }
}

