/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLTransform;
import com.isomorphic.util.AtomicFileOutputStream;
import com.isomorphic.util.DataTools;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DataExport
extends com.isomorphic.rpc.DataExport {
    private static PrintStream sysout = System.out;
    private static PrintStream syserr = System.err;
    private static String db;
    private static Logger log;
    protected static JSTranslater jsTrans;
    protected int outputType;
    protected List order;
    public static final int DATASOURCE = 1;
    public static final int TABLE = 2;
    public static final int CSV = 1;
    public static final int JS_LITERAL = 2;
    public static final int XML = 3;
    public static final int DEFAULT_OUTPUT = 1;

    public DataExport() {
        this.outputType = 1;
    }

    public DataExport(int output) {
        this.outputType = output;
    }

    public DataExport(int output, String database) {
        this.outputType = output;
        db = database;
    }

    public void setDatabase(String database) {
        db = database;
    }

    public void setOutputType(int output) {
        this.outputType = output;
    }

    public void setOrder(List order) {
        this.order = order;
    }

    public void setOrder(String[] order) {
        this.order = DataTools.arrayToList((Object[])order);
    }

    public String exportDataSourceData(String sourceName) throws Exception {
        return this.exportDataSourceData(sourceName, (Map)null);
    }

    public String exportDataSourceData(String sourceName, List columns) throws Exception {
        return this.exportDataSourceData(sourceName, DataTools.identityMap((List)columns));
    }

    public String exportDataSourceData(String sourceName, Map columnRemap) throws Exception {
        StringWriter out = new StringWriter();
        this.exportDataSourceData(sourceName, columnRemap, (Writer)out);
        return out.toString();
    }

    public void exportDataSourceData(String sourceName, Writer out) throws Exception {
        this.exportDataSourceData(sourceName, (Map)null, out);
    }

    public void exportDataSourceData(String sourceName, List columns, Writer out) throws Exception {
        this.exportDataSourceData(sourceName, DataTools.identityMap((List)columns), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDataSourceData(String dsName, Map columnRemap, Writer out) throws Exception {
        SQLDataSource ds = null;
        try {
            ds = (SQLDataSource)DataSourceManager.getDataSource((String)dsName, null);
        }
        catch (Exception e) {
            throw new Exception("Problem instantiating datasource: " + dsName + "\n" + e.toString());
        }
        if (ds == null) {
            throw new Exception("Failed to create datasource for: " + dsName);
        }
        try {
            List rows = ds.select((Object)null);
            if (columnRemap == null) {
                this.exportResultSet(rows, ds._getFieldNames(), out);
            } else {
                this.exportResultSet(rows, columnRemap, out);
            }
        }
        finally {
            DataSourceManager.freeDataSource((DataSource)ds);
        }
    }

    public void exportTable(String tableName, Writer out) throws Exception {
        this.exportTable(tableName, (Map)null, out);
    }

    public void exportTable(String tableName, List columns, Writer out) throws Exception {
        this.exportTable(tableName, DataTools.identityMap((List)columns), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTable(String tableName, Map columnRemap, Writer out) throws Exception {
        Connection conn = SQLConnectionManager.getConnection((String)db);
        Statement statement = null;
        try {
            statement = conn.createStatement();
            ResultSet rs = statement.executeQuery("SELECT * FROM " + tableName);
            this.exportResultSet(rs, columnRemap, out);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            SQLConnectionManager.free((Connection)conn);
        }
    }

    public void exportResultSet(ResultSet rs, Writer out) throws Exception {
        this.exportResultSet(rs, (Map)null, out);
    }

    public void exportResultSet(ResultSet rs, List columns, Writer out) throws Exception {
        this.exportResultSet(rs, DataTools.identityMap((List)columns), out);
    }

    public void exportResultSet(ResultSet rs, Map columnRemap, Writer out) throws Exception {
        ArrayList rows = new ArrayList();
        ArrayList headers = new ArrayList();
        if (rs == null) {
            throw new Exception("Null result set");
        }
        if (columnRemap == null) {
            columnRemap = new HashMap<String, String>();
            ResultSetMetaData header = rs.getMetaData();
            int columns = header.getColumnCount();
            for (int i = 1; i <= columns; ++i) {
                String column = header.getColumnName(i);
                columnRemap.put(column, column);
            }
        }
        this.exportResultSet(SQLTransform.toListOfMaps((ResultSet)rs), columnRemap, out);
    }

    public static void processDataExportRequest(int inputType, int outputType, String source, String columns, String columnOrder, Writer out) throws Exception {
        DataExport de = new DataExport(outputType);
        Object fields = null;
        if (columns != null) {
            fields = jsTrans.fromJS(columns);
        }
        if (columnOrder != null) {
            de.setOrder((List)jsTrans.fromJS(columnOrder));
        }
        if (inputType == 1) {
            if (fields == null) {
                de.exportDataSourceData(source, out);
            } else if (fields instanceof List) {
                de.exportDataSourceData(source, (List)fields, out);
            } else if (fields instanceof Map) {
                de.exportDataSourceData(source, (Map)fields, out);
            }
        } else if (inputType == 2) {
            if (fields == null) {
                de.exportTable(source, out);
            } else if (fields instanceof List) {
                de.exportTable(source, (List)fields, out);
            } else if (fields instanceof Map) {
                de.exportTable(source, (Map)fields, out);
            }
        } else {
            throw new Exception("Invalid input type: " + String.valueOf(inputType));
        }
    }

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        String cmdLineSyntax = "dataExport [options] [output file]";
        Options options = new Options();
        options.addOption("h", "help", false, "Display this help message");
        options.addOption("j", "jsInput", false, "Specifies that the output format is a Javascript literal.  (Default format is comma-separated values).");
        options.addOption("o", "order", false, "Specify the column output order as a Javascript literal (Array).");
        OptionBuilder.withLongOpt((String)"datasource");
        OptionBuilder.withDescription((String)"Export data from the table associated with this datasource");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"datasourceName");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"table");
        OptionBuilder.withDescription((String)"Export data from this table");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"tableName");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"columns");
        OptionBuilder.withDescription((String)"Specify the fields to be included in the output as a JS literal.  Provide either a list of the field names or a map of the field names to the column headers that will appear in the output");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"columns");
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'c'));
        if (args.length == 0) {
            DataExport.outputHelp(cmdLineSyntax, options);
            System.exit(0);
        }
        String userColumns = null;
        String columnOrder = null;
        boolean datasource = false;
        boolean table = false;
        boolean JSLiteral = false;
        String source = null;
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("c")) {
                userColumns = line.getOptionValue("c");
            }
            if (line.hasOption("o")) {
                columnOrder = line.getOptionValue("o");
            }
            if (line.hasOption("d")) {
                datasource = true;
                source = line.getOptionValue("d");
            }
            if (line.hasOption("h")) {
                DataExport.outputHelp(cmdLineSyntax, options);
                System.exit(0);
            }
            if (line.hasOption("j")) {
                JSLiteral = true;
            }
            if (line.hasOption("t")) {
                table = true;
                source = line.getOptionValue("t");
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            System.exit(1);
        }
        String outFileName2 = null;
        String extension = JSLiteral ? ".js" : ".csv";
        List fileList = line.getArgList();
        for (String outFileName2 : fileList) {
            int index = outFileName2.indexOf(extension);
            if (index != -1) continue;
            outFileName2 = outFileName2 + extension;
        }
        if (datasource && table) {
            sysout.println("Please provide only one source (datasource or table name).");
            System.exit(1);
        } else if (!datasource && !table) {
            sysout.println("Please provide a source (datasource or table name).");
            System.exit(1);
        }
        try {
            PrintWriter out = outFileName2 != null ? new PrintWriter((OutputStream)new AtomicFileOutputStream(outFileName2)) : new PrintWriter(System.out);
            DataExport.processDataExportRequest(table ? 2 : 1, JSLiteral ? 2 : 1, source, userColumns, columnOrder, out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "\nNotes:\nIf an output-file is not specified, output goes to stdout. If the output file does not end with .csv (or .js, for JS literal format output), the appropriate extension will be appended to the file name. If no columns are specified, all columns will be output.");
    }

    static {
        log = new Logger(DataExport.class.getName());
        jsTrans = new JSTranslater();
        db = config.getString((Object)"sql.defaultDatabase");
        if (db == null) {
            log.error((Object)"sql.defaultDatabase not defined in config file!");
        }
    }
}

