/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.ISCSystem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class SkinUtil {
    protected static Config config = Config.getGlobal();
    protected static Logger log = new Logger(SkinUtil.class.getName());
    protected static String compassCompileCommand = "compass compile ";
    protected static String tmpDir = config.getPath("tmpDir");
    protected static String skinsDir = config.getPath("skinsDir");
    protected static String skinToolsDir = config.getPath("toolsDir") + "/skinTools";

    protected static boolean devTheme(String theme) {
        return new File(SkinUtil.skinDir(theme) + "/_internalSource").exists();
    }

    protected static String skinTemplateDir(String theme) {
        return SkinUtil.skinDir(theme) + (SkinUtil.devTheme(theme) ? "/_internalSource" : "/template");
    }

    protected static String skinSettingsDir(String theme) {
        return SkinUtil.skinTemplateDir(theme) + "/sass";
    }

    protected static String skinDir(String theme) {
        return skinsDir + "/" + theme;
    }

    protected static String skinSettings(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/" + (SkinUtil.devTheme(theme) ? "_Theme" + theme : "_skinSettings") + ".scss";
    }

    protected static String skinSettingsCustom(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/" + (SkinUtil.devTheme(theme) ? "_Theme" + theme + "_custom" : "_skinStyles") + ".scss";
    }

    protected static String skinSettingsShowcase(String theme) {
        if (SkinUtil.devTheme(theme)) {
            return SkinUtil.skinSettingsDir(theme) + "/_Theme" + theme + "_showcase.scss";
        }
        return "Not a Showcase theme.";
    }

    protected static String skinConfig(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/config.json";
    }

    protected static String skinCssProperties(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/_cssProperties.scss";
    }

    protected static String userSettings(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/_userSettings.scss";
    }

    protected static String skinStylesSCSSFile(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/skin_styles.scss";
    }

    protected static String skinStylesCSS(String theme) {
        return SkinUtil.skinDir(theme) + "/skin_styles.css";
    }

    protected static String variableMetadata() {
        return skinToolsDir + "/data/variableMetadata.json";
    }

    protected static String variableGroupMetadata() {
        return skinToolsDir + "/data/groupMetadata.json";
    }

    protected static String baseFlatWithCSSVariables() {
        return skinToolsDir + "/data/_baseFlat_cssProps.scss";
    }

    protected static String baseFlat(String theme) {
        return SkinUtil.skinSettingsDir(theme) + "/_base.scss";
    }

    protected static String getValidatedTheme(DSRequest req, String fieldName) throws Exception {
        return SkinUtil.getValidatedTheme(req, fieldName, SkinType.ALL);
    }

    protected static String getValidatedTheme(DSRequest req, String fieldName, SkinType skinType) throws Exception {
        String theme = (String)req.getValues().get(fieldName);
        if (SkinUtil.assertValidTheme(theme, skinType)) {
            return theme;
        }
        throw new Exception("Invalid theme name: " + theme);
    }

    protected static boolean assertValidTheme(String theme) throws Exception {
        return SkinUtil.assertValidTheme(theme, SkinType.ALL);
    }

    protected static boolean assertValidTheme(String theme, SkinType skinType) throws Exception {
        if (theme == null) {
            throw new Exception("Null theme");
        }
        if (theme.contains("/") || theme.contains("\\")) {
            throw new Exception("Invalid theme name: " + theme);
        }
        if (theme.equals(".") || theme.equals("..") || IOUtil.isTmpFileName(theme)) {
            return false;
        }
        if (skinType == SkinType.ALL) {
            return true;
        }
        if (skinType == SkinType.USER) {
            return !SkinUtil.assertValidTheme(theme, SkinType.BASE);
        }
        try {
            if (!ISCFile.newInstance(SkinUtil.skinSettings(theme)).exists()) {
                return false;
            }
            if (!ISCFile.newInstance(SkinUtil.skinStylesCSS(theme)).exists()) {
                return false;
            }
            if (skinType == SkinType.ON_FILESYSTEM) {
                return true;
            }
            ISCFile userSettingsFile = ISCFile.newInstance(SkinUtil.userSettings(theme));
            if (userSettingsFile.exists()) {
                if (skinType == SkinType.BASE) {
                    return userSettingsFile.length() == 0L;
                }
                if (skinType == SkinType.USER_ON_FILESYSTEM) {
                    return userSettingsFile.length() != 0L;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to determine validity of base theme '" + theme + "'."), e);
        }
        return false;
    }

    public static List getThemes(SkinType skinType) throws Exception {
        ArrayList<String> themes = new ArrayList<String>();
        for (File file : new File(skinsDir).listFiles()) {
            String theme = file.getName();
            if (!SkinUtil.assertValidTheme(theme, skinType)) continue;
            themes.add(theme);
        }
        return themes;
    }

    public static String getSkinStylesCSS(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinStylesCSS(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static String getSkinSettings(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinSettings(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSkinSettings(String theme, String settings) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.skinSettings(theme)).write(settings);
    }

    public static String getSkinSettingsCustom(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinSettingsCustom(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSkinSettingsCustom(String theme, String settings) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.skinSettingsCustom(theme)).write(settings);
    }

    public static String getSkinSettingsShowcase(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinSettingsShowcase(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSkinSettingsShowcase(String theme, String content) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.skinSettingsShowcase(theme)).write(content);
    }

    public static String getSkinConfig(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinConfig(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSkinConfig(String theme, String config) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.skinConfig(theme)).write(config);
    }

    public static String getSkinCssProperties(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.skinCssProperties(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSkinCssProperties(String theme, String cssProperties) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.skinCssProperties(theme)).write(cssProperties);
    }

    public static String getUserSettings(String theme) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.ON_FILESYSTEM);
        ISCFile f = ISCFile.newInstance(SkinUtil.userSettings(theme));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveUserSettings(String theme, String userSettings) throws Exception {
        SkinUtil.assertValidTheme(theme, SkinType.USER_ON_FILESYSTEM);
        ISCFile.newInstance(SkinUtil.userSettings(theme)).write(userSettings);
    }

    public static String updatesForLivePreview(String theme) throws Exception {
        FileUtils.copyFile((File)new File(SkinUtil.baseFlatWithCSSVariables()), (File)new File(SkinUtil.baseFlat(theme)), (boolean)false);
        if (SkinUtil.devTheme(theme)) {
            String path = SkinUtil.skinStylesSCSSFile(theme);
            ISCFile f = ISCFile.newInstance(path);
            String content = null;
            if (f.exists()) {
                content = f.getAsString();
            }
            if (content != null) {
                content = content.replace("../../../_internalSource/FlatSeries/sass/_baseFlat.scss", "./_base.scss");
            }
            ISCFile.newInstance(path).write(content);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePreview(DSRequest req) throws Exception {
        Map values = req.getValues();
        String theme = SkinUtil.getValidatedTheme(req, "theme");
        String baseTheme = SkinUtil.getValidatedTheme(req, "baseTheme");
        String content = (String)values.get("content");
        Boolean livePreview = (Boolean)values.get("livePreview");
        File src = new File(SkinUtil.skinDir(baseTheme));
        String tmpTheme = IOUtil.threadSafeTmpFileName(baseTheme);
        File dst = null;
        try {
            dst = new File(SkinUtil.skinDir(tmpTheme));
            if (dst.exists()) {
                FileUtils.deleteDirectory((File)dst);
            }
            FileUtils.copyDirectory((File)src, (File)dst, (boolean)false);
            if (livePreview.booleanValue()) {
                SkinUtil.updatesForLivePreview(tmpTheme);
            }
            ISCFile.newInstance(SkinUtil.userSettings(tmpTheme)).write(content);
            String skinStylesCSS = SkinUtil.compileTheme(tmpTheme);
            skinStylesCSS = skinStylesCSS.replaceAll(baseTheme, theme);
            HttpSession session = req.getHttpServletRequest().getSession(true);
            HashMap<String, String> tmpSkinStyles = (HashMap<String, String>)session.getAttribute("isc.skinEditor.tmpSkinStyles");
            if (tmpSkinStyles == null) {
                tmpSkinStyles = new HashMap<String, String>();
                session.setAttribute("isc.skinEditor.tmpSkinStyles", tmpSkinStyles);
            }
            tmpSkinStyles.put(theme + "_base", baseTheme);
            tmpSkinStyles.put(theme + "_skinStylesCSS", skinStylesCSS);
        }
        finally {
            if (dst != null && dst.exists()) {
                FileUtils.deleteDirectory((File)dst);
            }
        }
    }

    public static String compileTheme(String theme) throws Exception {
        File tmpSkinFile = new File(SkinUtil.skinStylesCSS(theme));
        boolean origWriteableSetting = true;
        if (tmpSkinFile.exists()) {
            origWriteableSetting = tmpSkinFile.canWrite();
            tmpSkinFile.setWritable(true);
        }
        ISCSystem result = ISCSystem.execute(compassCompileCommand + "'" + SkinUtil.skinTemplateDir(theme) + "' --force");
        result.waitFor();
        int exitValue = result.exitValue();
        if (exitValue != 0) {
            throw new Exception(result.getFormattedErrorString());
        }
        tmpSkinFile.setWritable(origWriteableSetting);
        return ISCFile.newInstance(SkinUtil.skinStylesCSS(theme)).getAsString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compileTheme(String theme, String baseTheme, String userSettings) throws Exception {
        SkinUtil.assertValidTheme(theme);
        SkinUtil.assertValidTheme(baseTheme, SkinType.BASE);
        File src = new File(SkinUtil.skinDir(baseTheme));
        String tmpTheme = IOUtil.threadSafeTmpFileName(baseTheme);
        File dst = null;
        try {
            dst = new File(SkinUtil.skinDir(tmpTheme));
            if (dst.exists()) {
                FileUtils.deleteDirectory((File)dst);
            }
            FileUtils.copyDirectory((File)src, (File)dst, (boolean)false);
            ISCFile.newInstance(SkinUtil.userSettings(tmpTheme)).write(userSettings);
            String skinStylesCSS = SkinUtil.compileTheme(tmpTheme);
            String string = skinStylesCSS = skinStylesCSS.replaceAll(baseTheme, theme);
            return string;
        }
        finally {
            if (dst != null && dst.exists()) {
                FileUtils.deleteDirectory((File)dst);
            }
        }
    }

    public void export(DSRequest req, RPCManager rpc, HttpServletResponse response) throws Exception {
        Map values = req.getValues();
        String baseTheme = SkinUtil.getValidatedTheme(req, "baseSkin", SkinType.ON_FILESYSTEM);
        String theme = SkinUtil.getValidatedTheme(req, "name", SkinType.USER);
        String content = (String)values.get("content");
        String thumbnail = (String)values.get("thumbnail");
        String skinStylesContent = (String)values.get("skinStylesContent");
        rpc.doCustomResponse();
        response.addHeader("content-disposition", "attachment; " + rpc.encodeParameter("fileName", theme + ".zip"));
        response.setContentType("application/zip");
        ZipOutputStream zos = new ZipOutputStream((OutputStream)response.getOutputStream());
        Iterator i = FileUtils.iterateFilesAndDirs((File)new File(SkinUtil.skinDir(baseTheme)), (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        while (i.hasNext()) {
            File f = (File)i.next();
            if (f.getName().contains(".gz") || f.getName().equals("_userSettings.scss")) continue;
            String zipFileName = theme + f.getPath().substring(skinsDir.length() + baseTheme.length() + 1);
            if (!f.isDirectory() && f.getName().equals("skin_styles.css")) {
                if (skinStylesContent == null) continue;
                zos.putNextEntry(new ZipEntry(zipFileName));
                IOUtil.copyStreams(new ByteArrayInputStream(skinStylesContent.getBytes(StandardCharsets.UTF_8)), zos);
                zos.closeEntry();
                continue;
            }
            if (!f.isDirectory() && f.getName().equals("thumbnail.png") && thumbnail != null && thumbnail.length() > 0) {
                byte[] imagedata = DatatypeConverter.parseBase64Binary((String)thumbnail.substring(thumbnail.indexOf(",") + 1));
                zos.putNextEntry(new ZipEntry(zipFileName));
                IOUtil.copyStreams(new ByteArrayInputStream(imagedata), zos);
                zos.closeEntry();
                continue;
            }
            if (f.isDirectory()) {
                if (f.list().length == 0) {
                    zipFileName = zipFileName + "/";
                } else {
                    if (!f.getName().equals("sass")) continue;
                    if (content == null) {
                        log.debug("provided content for _userSettings.scss is null - writing zero length file");
                        content = "";
                    }
                    zos.putNextEntry(new ZipEntry(zipFileName + "/_userSettings.scss"));
                    IOUtil.copyStreams(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), zos);
                    zos.closeEntry();
                    continue;
                }
            }
            zos.putNextEntry(new ZipEntry(zipFileName));
            if (!f.isDirectory()) {
                IOUtil.copyStreams(new FileInputStream(f), zos);
            }
            zos.closeEntry();
        }
        zos.flush();
        zos.close();
    }

    public void updateVariableMetadata(DSRequest req) throws Exception {
        Map values = req.getValues();
        Object metadataObj = values.get("metadata");
        String output = JSTranslater.strict().toJS(metadataObj);
        ISCFile.newInstance(SkinUtil.variableMetadata()).write(output);
    }

    public void updateVariableGroupMetadata(DSRequest req) throws Exception {
        Map values = req.getValues();
        Object metadataObj = values.get("metadata");
        String output = JSTranslater.strict().toJS(metadataObj);
        ISCFile.newInstance(SkinUtil.variableGroupMetadata()).write(output);
    }

    public static List getSeriesList() throws Exception {
        ArrayList<String> seriesList = new ArrayList<String>();
        seriesList.add("Flat");
        return seriesList;
    }

    protected static String seriesBaseFile(String series) {
        return skinsDir + "/_internalSource/" + series + "Series/sass/_base" + series + ".scss";
    }

    protected static String seriesDynamicBaseFile(String series) {
        return skinsDir + "/_internalSource/" + series + "Series/sass/_base" + series + "_cssProps.scss";
    }

    public static String getSeriesBaseFile(String series) throws Exception {
        ISCFile f = ISCFile.newInstance(SkinUtil.seriesBaseFile(series));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSeriesBaseFile(String series, String content) throws Exception {
        ISCFile.newInstance(SkinUtil.seriesBaseFile(series)).write(content);
    }

    public static String getSeriesDynamicBaseFile(String series) throws Exception {
        ISCFile f = ISCFile.newInstance(SkinUtil.seriesDynamicBaseFile(series));
        if (f.exists()) {
            return f.getAsString();
        }
        return null;
    }

    public static void saveSeriesDynamicBaseFile(String series, String content) throws Exception {
        ISCFile.newInstance(SkinUtil.seriesDynamicBaseFile(series)).write(content);
    }

    public static enum SkinType {
        BASE,
        USER,
        ON_FILESYSTEM,
        USER_ON_FILESYSTEM,
        ALL;

    }
}

