/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class DeclarativeSecurity {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(DeclarativeSecurity.class.getName());
    public static final String OWNER_ID_FIELD = "ownerIdField";
    public static final String GUEST_USER_ID = "guestUserId";
    static final int NONE = 0;
    static final int UPDATE = 1;
    static final int INIT = 2;
    static final int EDIT = 3;

    public static boolean dsRequestPassesSecurityChecks(DSRequest dsRequest, DataSource ds, String fieldName) throws Exception {
        List opBindings;
        Boolean rtnValue;
        List opBindings2;
        String user;
        List opBindings3;
        Boolean requiresAuth;
        log.debug("Processing security checks for DataSource " + (ds == null ? "null" : ds.getID()) + ", field " + fieldName);
        if (!dsRequest.isClientRequest()) {
            log.debug("Request is not a client request, ignoring security checks.");
            return true;
        }
        if (config.getBoolean((Object)"security.disabled", Boolean.FALSE).booleanValue()) {
            log.debug("security.disabled set in config, ignoring security checks.");
            return true;
        }
        RequestContext context = dsRequest.context;
        if (ds == null) {
            ds = dsRequest.getDataSource();
        }
        if (ds == null) {
            return true;
        }
        if (dsRequest.checkedDataSources.contains(ds.getName())) {
            return dsRequest.checkRelatedSecurity(ds, fieldName);
        }
        log.debug("DataSource " + ds.getID() + " is not in the pre-checked list, processing...");
        DataTypeMap<String, Object> dsConfig = ds.getConfig();
        String operationType = dsRequest.getOperationType();
        String operationId = dsRequest.getOperationId();
        Object opBinding = ds.getOperationBinding(operationType, operationId);
        if (dsRequest.isCacheSyncRequest() && opBinding != null && DataTools.getBoolean((Map)opBinding, "relaxSecurityForCacheSync")) {
            return true;
        }
        ISCHttpServletRequest req = context != null ? context.request : null;
        Boolean authenticate = null;
        String ownerIdField = null;
        String guestUserId = null;
        if (opBinding != null) {
            requiresAuth = (Boolean)opBinding.get("requiresAuthentication");
            if (requiresAuth != null) {
                authenticate = requiresAuth;
            }
            if (ownerIdField == null) {
                ownerIdField = (String)opBinding.get(OWNER_ID_FIELD);
            }
            if (guestUserId == null) {
                guestUserId = (String)opBinding.get(GUEST_USER_ID);
            }
        }
        if (!(authenticate != null && ownerIdField != null && guestUserId != null || operationId == null || operationId.equals("") || (opBindings3 = (List)dsConfig.get("operationBindings")) == null)) {
            for (int i = 0; i < opBindings3.size(); ++i) {
                Boolean requiresAuth2;
                String defaultOpId;
                opBinding = (Map)opBindings3.get(i);
                if (!operationType.equals(opBinding.get("operationType")) || (defaultOpId = (String)opBinding.get("operationId")) != null && !defaultOpId.equals("")) continue;
                if (authenticate == null && (requiresAuth2 = (Boolean)opBinding.get("requiresAuthentication")) != null) {
                    authenticate = requiresAuth2;
                }
                if (ownerIdField == null) {
                    ownerIdField = (String)opBinding.get(OWNER_ID_FIELD);
                }
                if (guestUserId != null) break;
                guestUserId = (String)opBinding.get(GUEST_USER_ID);
                break;
            }
        }
        if (authenticate == null && (requiresAuth = (Boolean)ds.getConfig().get("requiresAuthentication")) != null) {
            authenticate = requiresAuth;
        }
        if (ownerIdField == null) {
            ownerIdField = (String)ds.getConfig().get(OWNER_ID_FIELD);
        }
        if (guestUserId == null) {
            guestUserId = (String)ds.getConfig().get(GUEST_USER_ID);
        }
        if (StringUtils.isBlank(ownerIdField)) {
            ownerIdField = null;
        }
        if (StringUtils.isBlank(guestUserId)) {
            guestUserId = null;
        }
        if (authenticate == null && ownerIdField != null) {
            authenticate = Boolean.TRUE;
        }
        if (authenticate == null) {
            authenticate = config.getBoolean((Object)"authentication.defaultRequired", Boolean.FALSE);
        }
        if (authenticate != null && authenticate.booleanValue()) {
            Boolean nonServletAuth = dsRequest.getAuthenticated();
            if (nonServletAuth != null && !nonServletAuth.booleanValue()) {
                dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + "', operationId '" + operationId + "'.  No authenticated user";
                return false;
            }
            if (nonServletAuth == null && (user = dsRequest.getUserId()) == null) {
                dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + "', operationId '" + operationId + "'.  No authenticated user";
                return false;
            }
        }
        if ((user = dsRequest.getUserId()) == null) {
            user = guestUserId;
        }
        if (Boolean.TRUE.equals((Boolean)dsRequest.getAttribute("skipAuthentication"))) {
            authenticate = false;
            user = null;
        }
        opBinding = ds.getOperationBinding(operationType, operationId);
        String rolesList = null;
        Boolean creatorOverrides = null;
        if (opBinding != null) {
            rolesList = (String)opBinding.get("requiresRole");
            creatorOverrides = DataTools.getBooleanObject((Map)opBinding, "creatorOverrides");
        }
        if (rolesList == null && operationId != null && !operationId.equals("") && (opBindings2 = (List)dsConfig.get("operationBindings")) != null) {
            for (int i = 0; i < opBindings2.size(); ++i) {
                String defaultOpId;
                opBinding = (Map)opBindings2.get(i);
                if (!operationType.equals(opBinding.get("operationType")) || (defaultOpId = (String)opBinding.get("operationId")) != null && !defaultOpId.equals("")) continue;
                rolesList = (String)opBinding.get("requiresRole");
                if (creatorOverrides != null) break;
                creatorOverrides = DataTools.getBooleanObject((Map)opBinding, "creatorOverrides");
                break;
            }
        }
        String dsRolesList = (String)ds.getConfig().get("requiresRole");
        if (rolesList == null) {
            rolesList = dsRolesList;
        } else if (dsRolesList != null) {
            rolesList = rolesList + ", " + dsRolesList;
        }
        if (creatorOverrides == null) {
            creatorOverrides = DataTools.getBooleanObject(ds.getConfig(), "creatorOverrides");
        }
        if (rolesList != null && !rolesList.equals("")) {
            if (!(authenticate == null || authenticate.booleanValue() || req != null && req.getRemoteUser() != null)) {
                dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + "', operationId '" + operationId + "'.  requiresAuthentication was not set, but requiresRole was.  Roles cannot be checked without an authenticated user";
                return false;
            }
            boolean inRoles = dsRequest.isUserInRole(rolesList, (HttpServletRequest)req);
            if (!inRoles) {
                if (Boolean.TRUE.equals(creatorOverrides)) {
                    if (!DeclarativeSecurity.restrictCriteria(dsRequest, DeclarativeSecurity.getCreatorFieldName(dsRequest), user)) {
                        dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + "', operationId '" + operationId + "'.  This operation requires role(s) '" + rolesList + (user == null ? "'. This user " : "'. User '" + user + "' ") + "fails the role check.  creatorOverrides is in force, but we have been unable to modify the criteria because " + (user == null ? "the user is null." : "the criteria already contains a reference to the creator field.");
                        return false;
                    }
                } else {
                    dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + "', operationId '" + operationId + "'.  This operation requires role(s) '" + rolesList + (user == null ? "'. This user " : "'. User '" + user + "' ") + "fails the role check.";
                    return false;
                }
            }
        }
        if (ownerIdField != null && user != null) {
            Object clientProvidedValue;
            Map values;
            boolean logOwnerIdFieldWarning = false;
            if (DataSource.isAdd(operationType)) {
                values = dsRequest.getValues();
                if (values != null && values.containsKey(ownerIdField)) {
                    logOwnerIdFieldWarning = true;
                }
                dsRequest.setFieldValue(ownerIdField, user);
            }
            if (DataSource.isUpdate(operationType) && (values = dsRequest.getValues()) != null && (clientProvidedValue = values.remove(ownerIdField)) != null) {
                logOwnerIdFieldWarning = true;
            }
            if (logOwnerIdFieldWarning) {
                log.warn("The client-supplied value for field " + ownerIdField + " will be ignored because it is the automatically-populated ownerIdField.");
            }
            boolean allowNonOwnerFetch = config.getBoolean((Object)"security.allowNonOwnerFetch", false);
            if (!(DataSource.isAdd(operationType) || allowNonOwnerFetch || DeclarativeSecurity.restrictCriteria(dsRequest, ownerIdField, user))) {
                dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + "', operationId '" + operationId + "'. This operation specifies an ownerIdField of '" + ownerIdField + "'. However, we have been unable to modify the criteria because " + (user == null ? "the user is null." : "the criteria already contains a reference to the ownerIdField.");
                return false;
            }
        }
        String requires = null;
        Map<Object, Object> params = Velocity.getStandardContextMap(dsRequest);
        boolean dsLevelFailed = false;
        requires = (String)ds.getConfig().get("requires");
        if (requires != null) {
            rtnValue = Velocity.evaluateBooleanExpression(requires, params, "DataSource.requires", ds);
            creatorOverrides = DataTools.getBooleanObject(ds.getConfig(), "creatorOverrides");
            if (rtnValue == null) {
                dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + ".  The \"requires\" check returned a value that could not be interpreted as 'true' or 'false', assuming 'false'.";
            } else if (!rtnValue.booleanValue()) {
                dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + ".  Failed the \"requires\" check.";
            }
            if (rtnValue == null || !rtnValue.booleanValue()) {
                if (Boolean.TRUE.equals(creatorOverrides)) {
                    if (!DeclarativeSecurity.restrictCriteria(dsRequest, DeclarativeSecurity.getCreatorFieldName(dsRequest), user)) {
                        dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + "'.  Failed the \"requires\" check.  creatorOverrides is in force, but we have been unable to modify the criteria because " + (user == null ? "the user is null." : "the criteria already contains a reference to the creator field.");
                        return false;
                    }
                } else {
                    dsLevelFailed = true;
                }
            }
        }
        if ((opBinding = ds.getOperationBinding(operationType, operationId)) != null) {
            requires = (String)opBinding.get("requires");
            creatorOverrides = DataTools.getBooleanObject((Map)opBinding, "creatorOverrides");
        }
        if (requires == null && operationId != null && !operationId.equals("") && (opBindings = (List)dsConfig.get("operationBindings")) != null) {
            for (int i = 0; i < opBindings.size(); ++i) {
                String defaultOpId;
                opBinding = (Map)opBindings.get(i);
                if (!operationType.equals(opBinding.get("operationType")) || (defaultOpId = (String)opBinding.get("operationId")) != null && !defaultOpId.equals("")) continue;
                requires = (String)opBinding.get("requires");
                if (creatorOverrides != null) break;
                creatorOverrides = DataTools.getBooleanObject((Map)opBinding, "creatorOverrides");
                break;
            }
        }
        rtnValue = Boolean.TRUE;
        if (requires != null && !requires.trim().equals("")) {
            rtnValue = Velocity.evaluateBooleanExpression(requires, params, "OperationBinding.requires", ds);
            if (rtnValue == null) {
                dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + "', operationId '" + operationId + "'.  The \"requires\" check returned a value that could not be interpreted as 'true' or 'false', assuming 'false'.";
            } else if (!rtnValue.booleanValue()) {
                dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + "', operationId '" + operationId + "'.  Failed the \"requires\" check.";
            }
        }
        if (dsLevelFailed || rtnValue == null || !rtnValue.booleanValue()) {
            if (Boolean.TRUE.equals(creatorOverrides)) {
                if (!DeclarativeSecurity.restrictCriteria(dsRequest, DeclarativeSecurity.getCreatorFieldName(dsRequest), user)) {
                    dsRequest.securityFailureMessage = "DataSource '" + ds.getName() + "', operationType '" + operationType + "', operationId '" + operationId + "'.  Failed the \"requires\" check.  creatorOverrides is in force, but we have been unable to modify the criteria because " + (user == null ? "the user is null." : "the criteria already contains a reference to the creator field.");
                    return false;
                }
            } else {
                return false;
            }
        }
        if (DataSource.isModificationOperation(dsRequest.getOperationType())) {
            return true;
        }
        return dsRequest.checkRelatedSecurity(ds, fieldName);
    }

    public static void performFieldLevelDSRequestChecks(DSRequest dsRequest) throws Exception {
        boolean isEdit;
        if (!dsRequest.isClientRequest()) {
            return;
        }
        if (config.getBoolean((Object)"security.disabled", Boolean.FALSE).booleanValue()) {
            return;
        }
        RequestContext context = dsRequest.context;
        if (context == null || dsRequest.getDsTransaction() == null) {
            return;
        }
        if (!config.getBoolean((Object)"security.fieldLevelSecurityEnabled", Boolean.FALSE).booleanValue()) {
            return;
        }
        DataSource ds = dsRequest.getDataSource();
        if (ds == null) {
            return;
        }
        String opType = dsRequest.getOperationType();
        boolean isFetch = DataSource.isFetch(opType);
        boolean isUpdate = DataSource.isUpdate(opType);
        boolean isAdd = DataSource.isAdd(opType);
        boolean bl = isEdit = isAdd || isUpdate;
        if (!isFetch && !isEdit) {
            return;
        }
        boolean authenticated = true;
        Boolean nonServletAuth = dsRequest.getAuthenticated();
        String userId = dsRequest.getUserId();
        ISCHttpServletRequest req = null;
        if (nonServletAuth != null && !nonServletAuth.booleanValue()) {
            authenticated = false;
        } else if (nonServletAuth == null) {
            if (context.request == null) {
                authenticated = false;
            } else {
                req = context.request;
                userId = req.getRemoteUser();
                if (userId == null) {
                    authenticated = false;
                }
            }
        }
        boolean haveCreator = false;
        boolean userIsCreator = false;
        String creatorField = null;
        if (authenticated && (creatorField = DeclarativeSecurity.getCreatorFieldName(ds)) != null) {
            haveCreator = true;
        }
        if (haveCreator && isUpdate && DeclarativeSecurity.creatorOverrides(dsRequest)) {
            DSRequest inline = new DSRequest(ds.getName(), "fetch");
            inline.setRPCManager(dsRequest.getRPCManager());
            inline.setCriteria(dsRequest.getCriteria());
            Map existing = inline.execute().getDataMap();
            if (existing != null) {
                String creator = (String)existing.get(creatorField);
                userIsCreator = userId.equals(creator);
            }
        }
        Map<Object, Object> velocityContext = Velocity.getStandardContextMap(dsRequest);
        velocityContext.put("dsName", ds.getName());
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (isFetch) {
            if (dsRequest.getConsolidatedOutputs() != null) {
                fieldNames.addAll(dsRequest.getConsolidatedOutputs());
            } else {
                fieldNames.addAll(ds.getFieldNames());
            }
        } else if (dsRequest.getValues() != null) {
            fieldNames.addAll(dsRequest.getValues().keySet());
        }
        for (String fieldName : fieldNames) {
            boolean canView = true;
            velocityContext.put("fieldName", fieldName);
            boolean creatorOverrides = false;
            if (haveCreator) {
                creatorOverrides = DeclarativeSecurity.creatorOverrides(dsRequest, fieldName);
            }
            if (!DeclarativeSecurity.canFetchField(fieldName, ds, (HttpServletRequest)req, authenticated, dsRequest.getDsTransaction(), velocityContext) && !creatorOverrides) {
                canView = false;
                dsRequest.removeField(fieldName, true);
            }
            if (isFetch) continue;
            if (!(DeclarativeSecurity.canEditField(fieldName, ds, (HttpServletRequest)req, authenticated, isUpdate, dsRequest.getDsTransaction(), velocityContext) || userIsCreator && DeclarativeSecurity.creatorOverrides(dsRequest, fieldName))) {
                log.info("Field '" + fieldName + "' is not allowed for '" + opType + "' operation for user '" + dsRequest.getUserId() + "'.  Removing this field from the record");
                dsRequest.removeField(fieldName, false);
                continue;
            }
            if (canView || DeclarativeSecurity.hasEditSecuritySetting(fieldName, ds, false)) continue;
            dsRequest.removeField(fieldName, false);
        }
    }

    protected static boolean canEditField(String fieldName, DataSource ds, HttpServletRequest req, boolean authenticated, Boolean isUpdate, DSTransaction dsTransaction, Map velocityContext) throws Exception {
        int rtn = DeclarativeSecurity.canEditFieldEnhanced(fieldName, ds, req, authenticated, dsTransaction, velocityContext);
        if (isUpdate == null) {
            return rtn != 0;
        }
        if (isUpdate.booleanValue()) {
            return (rtn & 1) > 0;
        }
        return (rtn & 2) > 0;
    }

    protected static int canEditFieldEnhanced(String fieldName, DataSource ds, HttpServletRequest req, boolean authenticated, DSTransaction dsTransaction, Map velocityContext) throws Exception {
        Boolean rtnValue;
        DSField field = ds.getField(fieldName);
        if (field == null) {
            return 3;
        }
        int authenticate = 0;
        if (field.getBoolean("editRequiresAuthentication") || field.get("editRequiresRole") != null) {
            authenticate = 3;
        }
        if (authenticate == 0) {
            if (field.getBoolean("updateRequiresAuthentication") || field.get("updateRequiresRole") != null) {
                ++authenticate;
            }
            if (field.getBoolean("initRequiresAuthentication") || field.get("initRequiresRole") != null) {
                authenticate += 2;
            }
        }
        if (authenticate != 0 && !authenticated) {
            if (req == null) {
                log.warn("Could not authenticate - no context HttpServletRequest found - removing field '" + fieldName + "'");
            }
            return authenticate ^ 3;
        }
        String editRoles = (String)field.get("editRequiresRole");
        String updateRoles = (String)field.get("updateRequiresRole");
        String initRoles = (String)field.get("initRequiresRole");
        int inRoles = 0;
        if (editRoles != null && !editRoles.equals("") && !DeclarativeSecurity.isUserInRole(editRoles, req, dsTransaction)) {
            inRoles = 3;
        }
        if (initRoles != null && !initRoles.equals("")) {
            inRoles = !DeclarativeSecurity.isUserInRole(initRoles, req, dsTransaction) ? (inRoles |= 2) : (inRoles &= 1);
        }
        if (updateRoles != null && !updateRoles.equals("")) {
            inRoles = !DeclarativeSecurity.isUserInRole(updateRoles, req, dsTransaction) ? (inRoles |= 1) : (inRoles &= 2);
        }
        if (inRoles != 0) {
            return inRoles ^ 3;
        }
        String editRequires = (String)field.get("editRequires");
        String updateRequires = (String)field.get("updateRequires");
        String initRequires = (String)field.get("initRequires");
        int requires = 0;
        if (editRequires != null && editRequires.length() > 0) {
            rtnValue = Velocity.evaluateBooleanExpression(editRequires, velocityContext, "DataSourceField.editRequires", ds);
            if (rtnValue == null) {
                log.warn("DataSource '" + ds.getName() + "'': The \"editRequires\" check returned a value that could not be interpreted as 'true' or 'false', assuming 'false'");
                log.warn("NOTE: The template evaluated by Velocity was: '" + editRequires + "'");
                requires = 3;
            } else if (!rtnValue.booleanValue()) {
                requires = 3;
            }
        }
        if (initRequires != null && initRequires.length() > 0 && requires != 3) {
            rtnValue = Velocity.evaluateBooleanExpression(initRequires, velocityContext, "DataSourceField.initRequires", ds);
            if (rtnValue == null) {
                log.warn("DataSource '" + ds.getName() + "'': The \"initRequires\" check returned a value that could not be interpreted as 'true' or 'false', assuming 'false'");
                log.warn("NOTE: The template evaluated by Velocity was: '" + initRequires + "'");
                requires += 2;
            } else if (!rtnValue.booleanValue()) {
                requires += 2;
            }
        }
        if (updateRequires != null && updateRequires.length() > 0 && requires != 3) {
            rtnValue = Velocity.evaluateBooleanExpression(updateRequires, velocityContext, "DataSourceField.updateRequires", ds);
            if (rtnValue == null) {
                log.warn("DataSource '" + ds.getName() + "'': The \"updateRequires\" check returned a value that could not be interpreted as 'true' or 'false', assuming 'false'");
                log.warn("NOTE: The template evaluated by Velocity was: '" + updateRequires + "'");
                ++requires;
            } else if (!rtnValue.booleanValue()) {
                ++requires;
            }
        }
        return requires ^ 3;
    }

    protected static boolean canFetchField(String fieldName, DataSource ds, HttpServletRequest req, boolean authenticated, DSTransaction dsTransaction, Map velocityContext) throws Exception {
        DSField field = ds.getField(fieldName);
        if (field == null) {
            return true;
        }
        if (!field.canView()) {
            return false;
        }
        boolean authenticate = field.getBoolean("viewRequiresAuthentication");
        if (!authenticate) {
            boolean bl = authenticate = field.get("viewRequiresRole") != null;
        }
        if (authenticate && !authenticated) {
            if (req == null) {
                log.warn("Could not authenticate - no context HttpServletRequest found - removing field '" + fieldName + "'");
            }
            return false;
        }
        String rolesList = (String)field.get("viewRequiresRole");
        if (rolesList != null && !rolesList.equals("") && !DeclarativeSecurity.isUserInRole(rolesList, req, dsTransaction)) {
            return false;
        }
        String requires = (String)field.get("viewRequires");
        if (requires != null) {
            Boolean rtnValue = Velocity.evaluateBooleanExpression(requires, velocityContext, "DataSourceField.viewRequires", ds);
            if (rtnValue == null) {
                log.warn("DataSource '" + ds.getName() + "', operationType 'fetch': The \"viewRequires\" check returned a value that could not be interpreted as 'true' or 'false', assuming 'false'");
                return false;
            }
            if (!rtnValue.booleanValue()) {
                return false;
            }
        }
        return true;
    }

    protected static boolean hasEditSecuritySetting(String fieldName, DataSource ds, boolean editConstraintsOnly) throws Exception {
        if (ds == null || ds.getField(fieldName) == null) {
            return false;
        }
        DSField field = ds.getField(fieldName);
        if (editConstraintsOnly) {
            return field.get("editRequiresAuthentication") != null || field.get("editRequiresRole") != null || field.get("editRequires") != null;
        }
        return field.get("editRequiresAuthentication") != null || field.get("editRequiresRole") != null || field.get("editRequires") != null || field.get("initRequiresRole") != null || field.get("initRequires") != null || field.get("updateRequiresRole") != null || field.get("updateRequires") != null;
    }

    public static void annotateDataSourceFields(DataSource ds, ServletRequest sreq) throws Exception {
        HttpServletRequest req = null;
        if (sreq instanceof HttpServletRequest) {
            req = (HttpServletRequest)sreq;
        }
        if (ds == null) {
            return;
        }
        if (config.getBoolean((Object)"security.disabled", Boolean.FALSE).booleanValue()) {
            return;
        }
        if (!config.getBoolean((Object)"security.fieldLevelSecurityEnabled", Boolean.FALSE).booleanValue()) {
            return;
        }
        boolean authenticated = false;
        String userId = req == null ? null : req.getRemoteUser();
        authenticated = userId != null;
        Map velocityContext = Velocity.getServletContextMap(req);
        velocityContext.put("dsName", ds.getName());
        Map fields = (Map)ds.getAnnotatedConfig().get("fields");
        Iterator i = fields.keySet().iterator();
        while (i.hasNext()) {
            int editProfile;
            boolean canView = true;
            String fieldName = (String)i.next();
            Map fieldDef = (Map)fields.get(fieldName);
            velocityContext.put("fieldName", fieldName);
            if (!DeclarativeSecurity.canFetchField(fieldName, ds, req, authenticated, null, velocityContext)) {
                if (!DeclarativeSecurity.canEditField(fieldName, ds, req, authenticated, null, null, velocityContext) || !DeclarativeSecurity.hasEditSecuritySetting(fieldName, ds, false)) {
                    fieldDef.put("canView", false);
                } else {
                    fieldDef.put("hidden", true);
                }
                canView = false;
            }
            if ((editProfile = DeclarativeSecurity.canEditFieldEnhanced(fieldName, ds, req, authenticated, null, velocityContext)) == 0) {
                fieldDef.put("canEdit", false);
                fieldDef.put("canSave", false);
                continue;
            }
            if ((editProfile & 2) == 0) {
                fieldDef.put("canInit", false);
            }
            if ((editProfile & 1) == 0) {
                fieldDef.put("canUpdate", false);
            }
            if (canView || DeclarativeSecurity.hasEditSecuritySetting(fieldName, ds, false)) continue;
            fieldDef.put("canEdit", false);
            fieldDef.put("canSave", false);
        }
    }

    public static boolean restrictCriteria(DSRequest dsRequest, String fieldName, String requiredValue) throws Exception {
        if (requiredValue == null) {
            log.warn("restrictCriteria called with a null requiredValue - this is unexpected, bailing out with a 'failed security check' error");
            return false;
        }
        Map critMap = dsRequest.getCriteria();
        HashMap<String, String> userCriterion = new HashMap<String, String>();
        userCriterion.put("fieldName", fieldName);
        userCriterion.put("operator", "equals");
        userCriterion.put("value", requiredValue);
        if ("AdvancedCriteria".equals(critMap.get("_constructor"))) {
            if ("and".equals(critMap.get("operator"))) {
                ((List)critMap.get("criteria")).add(userCriterion);
            } else {
                HashMap newCrit = new HashMap();
                newCrit.put("operator", critMap.get("operator"));
                newCrit.put("criteria", critMap.get("criteria"));
                ArrayList<HashMap<String, Object>> critList = new ArrayList<HashMap<String, Object>>();
                critList.add(newCrit);
                critList.add(userCriterion);
                critMap.put("operator", "and");
                critMap.put("criteria", critList);
            }
        } else if (!critMap.containsKey(fieldName)) {
            critMap.put(fieldName, requiredValue);
        } else if (!requiredValue.equals(critMap.get(fieldName))) {
            return false;
        }
        return true;
    }

    public static boolean isUserInRole(String roles, HttpServletRequest req, DSTransaction dsTransaction) {
        List<String> userRoles = null;
        if (dsTransaction != null) {
            userRoles = dsTransaction.getUserRoles();
        }
        if (userRoles == null && req == null) {
            return true;
        }
        String superUserRole = config.getString("authentication.superuserRole");
        if (superUserRole != null && !superUserRole.equals("")) {
            superUserRole = superUserRole.trim();
            if (userRoles == null ? req.isUserInRole(superUserRole) : userRoles.contains(superUserRole)) {
                return true;
            }
        }
        Boolean requireAllRoles = config.getBoolean((Object)"authentication.requireAllRoles", Boolean.FALSE);
        List<String> rolesList = DataTools.commaSeparatedStringToList(roles);
        for (String role : rolesList) {
            boolean inRole = userRoles != null ? userRoles.contains(role) : req.isUserInRole(role);
            if (requireAllRoles.booleanValue()) {
                if (inRole) continue;
                return false;
            }
            if (!inRole) continue;
            return true;
        }
        return requireAllRoles;
    }

    public static boolean creatorOverrides(DSRequest req) {
        return DeclarativeSecurity.creatorOverrides(req, null);
    }

    public static boolean creatorOverrides(DSRequest req, String fieldName) {
        try {
            List<String> fieldNames;
            DataSource ds = req.getDataSource();
            if (ds == null) {
                return false;
            }
            Boolean override = null;
            if (fieldName != null) {
                fieldNames = new ArrayList<String>();
                fieldNames.add(fieldName);
            } else {
                fieldNames = ds.getFieldNames();
            }
            Iterator<String> i = fieldNames.iterator();
            while (i.hasNext()) {
                DSField field = ds.getField(i.next());
                if (field == null || (override = DataTools.asBooleanObject(field.get("creatorOverrides"))) == null) continue;
                if (override.booleanValue()) {
                    return true;
                }
                if (fieldName == null) continue;
                return false;
            }
            DataTypeMap opConfig = ds.getOperationBinding(req.getOperationType(), req.getOperationId());
            if (opConfig != null && (override = DataTools.asBooleanObject(opConfig.get("creatorOverrides"))) != null && override.booleanValue()) {
                return true;
            }
            override = DataTools.asBooleanObject(ds.getConfig().get("creatorOverrides"));
            if (override != null && override.booleanValue()) {
                return true;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception during getCreatorOverrides", e);
            return false;
        }
        return false;
    }

    public static String getCreatorFieldName(DataSource ds) {
        if (ds == null) {
            return null;
        }
        for (DSField field : ds.getFields()) {
            if (!"creator".equals(field.getType())) continue;
            return field.getName();
        }
        return null;
    }

    public static String getCreatorFieldName(DSRequest req) {
        DataSource ds;
        try {
            ds = req.getDataSource();
        }
        catch (Throwable ex) {
            return null;
        }
        return DeclarativeSecurity.getCreatorFieldName(ds);
    }

    public static void applyCreatorOverridesToResultSet(List data, DSRequest req) throws Exception {
        if (!config.getBoolean((Object)"security.fieldLevelSecurityEnabled", Boolean.FALSE).booleanValue()) {
            return;
        }
        if (data == null || data.size() == 0) {
            return;
        }
        DataSource ds = null;
        ds = req.getDataSource();
        if (ds == null) {
            return;
        }
        if (!DeclarativeSecurity.creatorOverrides(req)) {
            return;
        }
        String user = req.getUserId();
        String creatorField = DeclarativeSecurity.getCreatorFieldName(ds);
        Map<Object, Object> velocityContext = Velocity.getStandardContextMap(req);
        for (Object obj : data) {
            if (!(obj instanceof Map)) continue;
            Map record = (Map)obj;
            log.debug("Filtering record: " + record);
            DeclarativeSecurity.filterRecord(record, ds, req, user, creatorField, velocityContext);
        }
    }

    public static void filterRecord(Map record, DataSource ds, DSRequest req, String user, String creatorField, Map<Object, Object> velocityContext) throws Exception {
        Object creator;
        ISCHttpServletRequest httpReq = null;
        if (req.context != null) {
            httpReq = req.context.request;
        }
        if (ds != null) {
            velocityContext.put("dsName", ds.getName());
        }
        if ((creator = record.get(creatorField)) != null && creator.equals(user)) {
            log.debug("User " + user + " is this record's creator");
        } else {
            log.debug("User " + user + " is not this record's creator (" + creator + ")");
        }
        Iterator i = record.keySet().iterator();
        while (i.hasNext()) {
            String fieldName = (String)i.next();
            velocityContext.put("fieldName", fieldName);
            if (creator != null && creator.equals(user) && DeclarativeSecurity.creatorOverrides(req, fieldName)) {
                log.debug("creatorOverrides: Retaining field " + fieldName);
                continue;
            }
            if (DeclarativeSecurity.canFetchField(fieldName, ds, (HttpServletRequest)httpReq, user != null, req.getDsTransaction(), velocityContext)) continue;
            log.debug("Dropping field " + fieldName);
            i.remove();
        }
    }
}

