/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.tasks;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.tasks.VfsTask;
import org.apache.tools.ant.BuildException;

public class ShowFileTask
extends VfsTask {
    private static final String INDENT = "  ";
    private String url;
    private boolean showContent;
    private boolean recursive;

    public void setFile(String url) {
        this.url = url;
    }

    public void setShowContent(boolean showContent) {
        this.showContent = showContent;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void execute() throws BuildException {
        try {
            FileObject file = this.resolveFile(this.url);
            this.log("Details of " + file.getPublicURIString());
            this.showFile(file, INDENT);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void showFile(FileObject file, String prefix) throws Exception {
        StringBuilder msg = new StringBuilder(prefix);
        msg.append(file.getName().getBaseName());
        if (file.exists()) {
            msg.append(" (");
            msg.append(file.getType().getName());
            msg.append(")");
        } else {
            msg.append(" (unknown)");
        }
        this.log(msg.toString());
        if (file.exists()) {
            String newPrefix = prefix + INDENT;
            if (file.getType().hasContent()) {
                FileContent content = file.getContent();
                this.log(newPrefix + "Content-Length: " + content.getSize());
                this.log(newPrefix + "Last-Modified" + new Date(content.getLastModifiedTime()));
                if (this.showContent) {
                    this.log(newPrefix + "Content:");
                    this.logContent(file, newPrefix);
                }
            }
            if (file.getType().hasChildren()) {
                FileObject[] children;
                for (FileObject child : children = file.getChildren()) {
                    if (this.recursive) {
                        this.showFile(child, newPrefix);
                        continue;
                    }
                    this.log(newPrefix + child.getName().getBaseName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logContent(FileObject file, String prefix) throws Exception {
        InputStream instr = file.getContent().getInputStream();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(instr));
            while ((line = reader.readLine()) != null) {
                this.log(prefix + line);
            }
        }
        finally {
            instr.close();
        }
    }
}

