/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.MemoryStore;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import java.util.List;
import java.util.Map;

public class MemoryDataSource
extends BasicDataSource {
    private static final String CLASS_NAME = MemoryDataSource.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    public static final String AUTO_DERIVE_PROPERTY = "autoDeriveSchema";
    public static final String STORE_NAME_PROPERTY = "tableName";
    private String storeName = null;

    @Override
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        super.init(theConfig, dsRequest);
    }

    protected void initRequest(DSRequest dsRequest) throws Exception {
        DataTypeMap<String, Object> theConfig = this.getConfig();
        Object storeNameObj = theConfig.get(STORE_NAME_PROPERTY);
        if (storeNameObj == null) {
            throw new Exception("Store name should be specified in DS configuration property 'tableName'.");
        }
        this.storeName = storeNameObj.toString();
        Object autoDerive = theConfig.get(AUTO_DERIVE_PROPERTY);
        if (autoDerive != null && autoDerive.toString().equalsIgnoreCase("true")) {
            String id = (String)theConfig.get("ID") + "_inheritsFrom";
            Object dsObject = DataStructCache.getCachedObjectWithNoConfigFile(id);
            if (dsObject instanceof DataSource) {
                this.autoDeriveDS = (DataSource)dsObject;
            } else {
                throw new Exception("Unable to create autoDerive datasource for DataSource " + theConfig.get("ID") + ".");
            }
        }
        MemoryStore.createStore(this.storeName, this);
    }

    public String getStoreName() {
        return this.storeName;
    }

    @Override
    public Class getFieldJavaType(String fieldName) {
        return this.getFieldJavaType(this.getField(fieldName));
    }

    @Override
    public Class getFieldJavaType(DSField field) {
        if (field == null) {
            return null;
        }
        return MemoryStore.getFieldType(this.storeName, field.getName());
    }

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        this.initRequest(req);
        log.debug("Executing fetch.");
        DSResponse dsResponse = new DSResponse(this);
        dsResponse.setSuccess();
        List records = MemoryStore.find(this.storeName, req.getCriteria());
        if (req.isPaged()) {
            if (req.getEndRow() != -1L && req.getEndRow() - req.getStartRow() > req.getBatchSize()) {
                req.setBatchSize(req.getEndRow() - req.getStartRow());
            }
            int start = (int)req.getStartRow();
            int end = Math.min(records.size(), (int)req.getStartRow() + (int)req.getBatchSize());
            records = DataTools.arrayToList(records.toArray(), start, end);
        }
        long totalRows = records.size();
        dsResponse.setTotalRows(totalRows);
        long startRow = 0L;
        long endRow = 0L;
        if (totalRows != 0L) {
            startRow = req.getStartRow();
            endRow = startRow + (long)records.size();
        }
        dsResponse.setStartRow(startRow);
        dsResponse.setEndRow(endRow);
        dsResponse.setData(records);
        return dsResponse;
    }

    @Override
    public DSResponse executeAdd(DSRequest req) throws Exception {
        this.initRequest(req);
        log.debug("Executing add.");
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        List valueSets = req.getValueSets();
        if (valueSets.size() > 1) {
            long affectedRows = 0L;
            for (Map values : valueSets) {
                Map<String, Object> record = MemoryStore.insert(this.storeName, values);
                ++affectedRows;
            }
            dsResponse.setAffectedRows(affectedRows);
        } else {
            Map<String, Object> record = MemoryStore.insert(this.storeName, req.getValues());
            dsResponse.setData(record);
            dsResponse.setAffectedRows(1L);
        }
        return dsResponse;
    }

    @Override
    public DSResponse executeRemove(DSRequest req) throws Exception {
        this.initRequest(req);
        log.debug("Executing remove.");
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        long affectedRows = 0L;
        Map<String, Object> record = MemoryStore.delete(this.storeName, req.getCriteria());
        if (record != null) {
            dsResponse.setData(record);
            ++affectedRows;
        } else {
            dsResponse.setData(req.getCriteria());
            log.warn("Did not remove. Record not found for PK=" + req.getCriteria());
        }
        dsResponse.setAffectedRows(affectedRows);
        return dsResponse;
    }

    @Override
    public DSResponse executeUpdate(DSRequest req) throws Exception {
        this.initRequest(req);
        log.debug("Executing update.");
        DSResponse dsResponse = new DSResponse();
        dsResponse.setSuccess();
        long affectedRows = 0L;
        if (req.getValues() == null) {
            log.warn("DSRequest with no values passed to executeUpdate(), no records modified.");
            dsResponse.setData(null);
        } else {
            Map<String, Object> record = MemoryStore.update(this.storeName, req.getCriteria(), req.getValues());
            if (record != null) {
                ++affectedRows;
            } else {
                log.warn("Did not update. Record not found for PK=" + req.getCriteria());
            }
            dsResponse.setData(record);
        }
        dsResponse.setAffectedRows(affectedRows);
        return dsResponse;
    }
}

