/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import com.sun.applet2.AppletParameters;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.BASE64Decoder;
import sun.plugin2.main.server.ClientJVMSelectionParameters;
import sun.plugin2.main.server.JVMManager;
import sun.plugin2.os.windows.OSVERSIONINFOA;
import sun.plugin2.os.windows.Windows;

public class SystemUtil {
    static boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    static boolean VERBOSE = SystemUtil.getenv("JPI_PLUGIN2_VERBOSE") != null;
    private static final String JAVA_EXT_DIRS = "-Djava.ext.dirs=";
    private static final String TRUSTED_DIR = File.separator + "lib" + File.separator + "trusted";
    private static String javaHome;
    private static volatile boolean getenvSupported;
    public static final int WINDOWS = 1;
    public static final int UNIX = 2;
    public static final int MACOSX = 3;
    private static int osType;
    private static boolean isVista;
    private static final String JPI_VM_OPTIONS = "_JPI_VM_OPTIONS";

    public static String getJavaHome() {
        if (javaHome == null) {
            javaHome = SystemUtil.getSystemProperty("java.home");
        }
        return javaHome;
    }

    public static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public static boolean debug(String string) {
        return SystemUtil.getSystemProperty("sun.plugin2.debug." + string) != null;
    }

    public static String getenv(final String string) {
        if (getenvSupported) {
            try {
                return (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getenv(string);
                    }
                });
            }
            catch (Error error) {
                getenvSupported = false;
            }
        }
        return null;
    }

    private static void computeIsVista() {
        OSVERSIONINFOA oSVERSIONINFOA = OSVERSIONINFOA.create();
        oSVERSIONINFOA.dwOSVersionInfoSize(OSVERSIONINFOA.size());
        if (Windows.GetVersionExA(oSVERSIONINFOA)) {
            isVista = oSVERSIONINFOA.dwPlatformId() == 2 && oSVERSIONINFOA.dwMajorVersion() >= 6;
        }
    }

    public static int getOSType() {
        if (osType == 0) {
            String string = SystemUtil.getSystemProperty("os.name").toLowerCase();
            if (string.startsWith("windows")) {
                osType = 1;
                SystemUtil.computeIsVista();
            } else {
                osType = string.indexOf("os x") != -1 ? 3 : 2;
            }
        }
        return osType;
    }

    public static boolean isWindowsVista() {
        SystemUtil.getOSType();
        return isVista;
    }

    public static String formatExecutableName(String string) {
        if (SystemUtil.getOSType() == 1) {
            return string + ".exe";
        }
        return string;
    }

    public static boolean isDebug() {
        return DEBUG;
    }

    public static boolean isVerbose() {
        return VERBOSE;
    }

    public static byte[] decodeBase64(String string) {
        if (string == null) {
            return null;
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        try {
            return bASE64Decoder.decodeBuffer(string);
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return null;
        }
    }

    private static String getVmArgs(JREInfo jREInfo) {
        String string = SystemUtil.getenv("FORCED_CLIENTVM_ARGS");
        if (DEBUG && string != null) {
            System.out.println("JVMManager: using override from FORCED_CLIENTVM_ARGS" + string);
        }
        if (string == null) {
            string = SystemUtil.getenv(JPI_VM_OPTIONS);
        }
        if (string != null) {
            return string;
        }
        return jREInfo.getVmArgs();
    }

    public static JVMParameters getDefaultVmArgs(JREInfo jREInfo) {
        JVMParameters jVMParameters = new JVMParameters();
        jVMParameters.parseTrustedOptions(SystemUtil.getVmArgs(jREInfo));
        jVMParameters.setDefault(true);
        return jVMParameters;
    }

    public static JVMParameters extractAppletParamsToJVMParameters(AppletParameters appletParameters, String string, boolean bl) {
        JVMParameters jVMParameters = new JVMParameters();
        jVMParameters.parseBootClassPath(JVMParameters.getPlugInDependentJars());
        jVMParameters.addInternalArgument("-Djava.class.path=" + Config.getJREHome() + File.separator + "classes");
        String string2 = (String)appletParameters.get((Object)"__applet_session_data");
        if (string2 != null && bl) {
            jVMParameters.addInternalArgument("-Djnlpx.session.data=" + string2);
        }
        jVMParameters.setDefault(true);
        String string3 = (String)appletParameters.get((Object)"java_arguments");
        if (string3 != null) {
            jVMParameters.setHtmlJavaArgs(true);
            jVMParameters.addEncodedArguments(string3, false, !bl);
        } else {
            jVMParameters.setHtmlJavaArgs(false);
        }
        if (SystemUtil.getOSType() == 3) {
            SystemUtil.scopeJVMInstanceByHost(SystemUtil.getURLHost(string), jVMParameters);
        }
        return jVMParameters;
    }

    private static String getURLHost(String string) {
        if (string != null) {
            try {
                URI uRI = new URI(string);
                return uRI.getHost();
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
        return null;
    }

    public static JVMParameters prepareJVMParameter(JVMParameters jVMParameters, JREInfo jREInfo, JVMParameters jVMParameters2, ClientJVMSelectionParameters clientJVMSelectionParameters) {
        JVMParameters jVMParameters3 = new JVMParameters();
        VersionID versionID = clientJVMSelectionParameters.getJfxRequirement();
        boolean bl = false;
        JfxRuntime jfxRuntime = null;
        if (null != versionID) {
            if (DEBUG && VERBOSE) {
                System.out.println("Need JavaFX version: " + versionID);
            }
            if (!jREInfo.getProductVersion().isGreaterThanOrEqual(ClientJVMSelectionParameters.JFX_JRE_MINIMUM_VER)) {
                if (DEBUG && VERBOSE) {
                    System.out.println("JavaFX requires minimum JRE version: " + ClientJVMSelectionParameters.JFX_JRE_MINIMUM_VER);
                }
                return null;
            }
            jfxRuntime = jREInfo.getJfxRuntime();
            if (jfxRuntime == null) {
                System.out.println("Launching in a vanilla JVM to install JavaFX and relaunch.");
            } else {
                if (!clientJVMSelectionParameters.useJfxToolkit()) {
                    jVMParameters3.addInternalArgument("-Djnlp.tk=awt");
                } else {
                    bl = true;
                }
                jVMParameters3.addInternalArgument("-Djnlp.fx=" + jfxRuntime.getProductVersion().toString());
            }
        }
        if (DEBUG && VERBOSE) {
            System.out.println("    JVMManager.createJVMInstance passing along JVM parameters from deployment.properties");
        }
        jVMParameters3.addArguments(jVMParameters2);
        if (DEBUG && VERBOSE) {
            System.out.println("    JVMManager.createJVMInstance passing along JVM parameters from this applet instance");
        }
        jVMParameters3.addArguments(jVMParameters);
        jVMParameters3.setHtmlJavaArgs(jVMParameters.isHtmlJavaArgs());
        SystemUtil.maintainCurrentArchFlag(jVMParameters3, jREInfo);
        SystemUtil.addJavaExtDirsOption(jVMParameters3);
        SystemUtil.addXToolkitOption(jVMParameters3, jREInfo.getProductVersion());
        SystemUtil.addUIElementOption(jVMParameters3);
        if (!bl) {
            jVMParameters3.addInternalArgument("-Dsun.awt.warmup=true");
        }
        return jVMParameters3;
    }

    private static void scopeJVMInstanceByHost(String string, JVMParameters jVMParameters) {
        String string2;
        String string3;
        if (string != null) {
            jVMParameters.addInternalArgument("-Djava.applet.host=" + string);
            string3 = ResourceManager.getFormattedMessage((String)"applet.host.app.title", (Object[])new String[]{string});
        } else {
            string3 = ResourceManager.getMessage((String)"applet.host.app.title.nohost");
        }
        String string4 = "-Xdock:name=" + string3;
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CharsetEncoder charsetEncoder = charset.newEncoder();
        try {
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string4));
            CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
            string2 = charBuffer.toString();
        }
        catch (CharacterCodingException characterCodingException) {
            string2 = "-Xdock:name=Java Applet - " + string;
        }
        jVMParameters.addInternalArgument(string2);
        jVMParameters.addInternalArgument("-Xdock:icon=" + Platform.get().getDefaultIconPath());
    }

    private static void maintainCurrentArchFlag(JVMParameters jVMParameters, JREInfo jREInfo) {
        if (SystemUtil.getOSType() == 3 && !jVMParameters.contains("-d32") && !jVMParameters.contains("-d64")) {
            if ("x86_64".equals(jREInfo.getOSArch()) || "amd64".equals(jREInfo.getOSArch())) {
                jVMParameters.addInternalArgument("-d64");
            } else {
                jVMParameters.addInternalArgument("-d32");
            }
        }
    }

    private static void addXToolkitOption(JVMParameters jVMParameters, VersionID versionID) {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("sunos") && new VersionID("1.5*").match(versionID)) {
            jVMParameters.addInternalArgument("-Dawt.toolkit=sun.awt.X11.XToolkit");
        }
    }

    private static void addUIElementOption(JVMParameters jVMParameters) {
        if (SystemUtil.getOSType() == 3) {
            jVMParameters.addInternalArgument("-Dapple.awt.UIElement=true");
        }
    }

    private static void addJavaExtDirsOption(JVMParameters jVMParameters) {
        String string = SystemUtil.getJavaExtDirsProp(jVMParameters);
        if (null != string) {
            jVMParameters.addInternalArgument(string);
        }
    }

    private static String getJavaExtDirsProp(JVMParameters jVMParameters) {
        String string;
        String string2;
        File file;
        boolean bl;
        if (jVMParameters.containsPrefix(JAVA_EXT_DIRS)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(JAVA_EXT_DIRS);
        stringBuffer.append(Config.getJREHome() + File.separator + "lib" + File.separator + "ext");
        String string3 = stringBuffer.toString();
        boolean bl2 = bl = JVMManager.getBrowserType() == 3;
        if (bl && (file = new File(string2 = Platform.get().getBrowserHomePath() + File.separator + "jss")).exists()) {
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(string2);
        }
        string2 = Config.getSystemHome() + TRUSTED_DIR;
        file = new File(string2);
        if (SystemUtil.getOSType() == 1 && file.exists()) {
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(string2);
        }
        if ((string = stringBuffer.toString()).equals(string3)) {
            return null;
        }
        return string;
    }

    static {
        getenvSupported = true;
    }
}

