/*

  SmartClient Ajax RIA system
  Version v12.1p_2025-11-20/EVAL Development Only (2025-11-20)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

var isc = window.isc ? window.isc : {};if(window.isc&&!window.isc.module_Core){isc.module_Core=1;isc._moduleStart=isc._Core_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log && isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={ message:'Core load/parse time: ' + (isc._moduleStart-isc._moduleEnd) + 'ms', category:'loadTime'};
if(isc.Log && isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');
else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;
else isc._preLog=[isc._pTM]}isc.definingFramework=true;


if (!window.isc || typeof isc.Packager != "object") {


//> @object isc
// <code>window.isc</code> is the base object for the Isomorphic SmartClient framework.
// Every SmartClient class is available on this object as <code>isc.<i>ClassName</i></code>.
// The <code>isc</code> also contains a number of static utility methods.
// <P>
// See also +link{group:simpleNamesMode,Simple Names mode}.
//
// @treeLocation Client Reference/System
// @visibility external
//<

//> @groupDef simpleNamesMode
// When SmartClient runs in "simple names" mode (the default), all ISC Classes and several
// global methods are installed as JavaScript global variables, that is, properties of the
// browser's "window" object.  When simple names mode is disabled (called "portal mode"),
// the framework uses only the global variable: "isc" and global variables prefixed with
// "isc_".
// <P>
// Portal mode is intended for applications which must integrate with fairly arbitrary
// JavaScript code written by third-party developers, and/or third party JavaScript frameworks,
// where it is important that each framework stays within it's own namespace.
// <P>
// <smartclient>
// In portal mode, all references to ISC classes and global functions must be prefixed with
// "isc.", for example:<pre>
//
//      Canvas.create(addProperties({}, myDefaults))
//
// </pre>would become<pre>
//
//      isc.Canvas.create(isc.addProperties({}, myDefaults));
//
// </pre>
// </smartclient>
// Portal mode is enabled by setting <code>window.isc_useSimpleNames = false</code> <b>before</b>
// SmartClient is loaded, generally inside the &lt;head&gt; element.
//
// @treeLocation Client Reference/System
// @title Simple Names mode
// @visibility external
//<





var isc = window.isc ? window.isc : {};
isc._start = new Date().getTime();

// versioning - values of the form ${value} are replaced with user-provided values at build time.
// Valid values are: version, date, project (not currently used)
isc.version = "v12.1p_2025-11-20/EVAL Development Only";
isc.versionNumber = "v12.1p_2025-11-20";
isc.buildDate = "2025-11-20";
isc.expirationDate = "2026.01.19_09.31.49";

isc.scVersion = "12.1p";
isc.scVersionNumber = "12.1";
isc.sgwtVersion = "12.1p";
isc.sgwtVersionNumber = "12.1";

// these reflect the latest stable version relative to the branch from which this build is
// created.  So for example for 11.0d/6.0d, this will be 10.1/5.1.  But for 10.0/5.0 this will
// be 10.0/5.0.
isc.scParityStableVersionNumber = "12.1";
isc.sgwtParityStableVersionNumber = "12.1";

// license template data
isc.licenseType = "Eval";
isc.licenseCompany = "Isomorphic Software";
isc.licenseSerialNumber = "ISC_EVAL_NIGHTLY";
isc.licensingPage = "http://smartclient.com/product/";

isc._$debugModules = "debugModules";
isc._$nonDebugModules = "nonDebugModules";
isc.checkForDebugAndNonDebugModules = function () {
    if (isc.checkForDebugAndNonDebugModules._loggedWarning) return;
    var debugModules = isc['_' + this._$debugModules],
        haveDebugModules = debugModules != null && debugModules.length > 0,
        nonDebugModules = isc['_' + this._$nonDebugModules],
        haveNonDebugModules = nonDebugModules != null && nonDebugModules.length > 0;

    if (haveDebugModules && haveNonDebugModules) {
        isc.logWarn("Both Debug and non-Debug modules were loaded; the Debug versions of '" +
        debugModules.join("', '") + "' and the non-Debug versions of '" + nonDebugModules.join("', '") +
        "' were loaded. Mixing Debug and non-Debug modules is not supported and may lead to " +
        "JavaScript errors and/or unpredictable behavior. " +
        "To fix, ensure that only modules in the modules/ folder or the modules-debug/ " +
        "folder are loaded and clear the browser cache. If using Smart GWT, also clear the " +
        "GWT unit cache and recompile.");
        isc.checkForDebugAndNonDebugModules._loggedWarning = true;
    }
};

isc._optionalModules = {
    SCServer: {present: "true", name: "SmartClient Server", serverOnly: true, isPro: true},
    Drawing: {present: "true", name: "Drawing Module"},
    PluginBridges: {present: "true", name: "PluginBridges Module"},
    RichTextEditor: {present: "true", name: "RichTextEditor Module"},
    Calendar: {present: "true", name: "Calendar Module"},
    Analytics: {present: "true", name: "Analytics Module"},
    Charts: {present: "true", name: "Charts Module"},
    Tools: {present: "${includeTools}", name: "Dashboards and Tools Module"},
    NetworkPerformance: {present: "true", name: "Network Performance Module"},
    // alias for NetworkPerformance
    FileLoader: {present: "true", name: "Network Performance Module"},
    RealtimeMessaging: {present: "true", name: "RealtimeMessaging Module"},
    // Enterprise Features
    serverCriteria: {present: "true", name: "Server Advanced Filtering", serverOnly: true, isFeature: true},
    customSQL: {present: "true", name: "SQL Templating", serverOnly: true, isFeature: true},
    chaining: {present: "true", name: "Transaction Chaining", serverOnly: true, isFeature: true},
    batchDSGenerator: {present: "true", name: "Batch DS-Generator", serverOnly: true, isFeature: true},
    batchUploader: {present: "true", name: "Batch Uploader", serverOnly: true, isFeature: true},
    transactions: {present: "true", name: "Automatic Transaction Management", serverOnly: true, isFeature: true}
};
isc.canonicalizeModules = function (modules) {
    if (!modules) return null;

    // canonicalize to Array, split on comma
    if (isc.isA.String(modules)) {
        if (modules.indexOf(",") != -1) {
            modules = modules.split(",");
            var trimLeft = /^\s+/, trimRight = /\s+$/;
            for (var i=0; i<modules.length; i++) {
                modules[i] = modules[i].replace(trimLeft, "").replace(trimRight, "");
            }
        } else modules = [modules];
    }
    return modules;
};
isc.hasOptionalModules = function (modules) {
    // ease of use shortcut, null value means no optional module requirements
    if (!modules) return true;

    modules = isc.canonicalizeModules(modules);

    for (var i = 0; i < modules.length; i++) if (!isc.hasOptionalModule(modules[i])) return false;
    return true;
};
isc.getMissingModules = function (requiredModules) {
    var result = [];
    requiredModules = isc.canonicalizeModules(requiredModules);
    for (var i = 0; i < requiredModules.length; i++) {
        var module = requiredModules[i];
        if (!isc.hasOptionalModule(module)) result.add(isc._optionalModules[module]);
    }
    return result;
};
isc.hasOptionalModule = function (module) {
    var v = isc._optionalModules[module];
    if (!v) {
        if(isc.Log) isc.Log.logWarn("isc.hasOptionalModule - unknown module: " + module);
        return false;
    }
    // has module or devenv
    return v.present == "true" || v.present.charAt(0) == "$";
};
isc.getOptionalModule = function (module) {
    return isc._optionalModules[module];
};


isc.$P5hy05Xgj7AN = function (moduleName) {
    if (this.hasOptionalModule(moduleName)) return;
    var moduleEntry = isc._optionalModules[moduleName];
    if (moduleEntry) moduleEntry.present = !!moduleName + "";
};

// default to "simple names" mode, where all ISC classes are defined as global variables
isc._useSimpleNames = window.isc_useSimpleNames;
if (isc._useSimpleNames == null) isc._useSimpleNames = true;

// register with the OpenAjax hub, if present
if (window.OpenAjax) {
    // OpenAjax insists on only numbers and dots.  This regex will convert eg 5.6b3 to 5.6.03,
    // which is not really accurate
    isc._numericVersion = isc.versionNumber.replace(/[a-zA-Z_]+/, ".0");
    OpenAjax.registerLibrary("SmartClient", "http://smartclient.com/SmartClient",
                             isc._numericVersion,
                             { namespacedMode : !isc._useSimpleNames,
                               iscVersion : isc.version,
                               buildDate : isc.buildDate,
                               licenseType : isc.licenseType,
                               licenseCompany : isc.licenseCompany,
                               licenseSerialNumber : isc.licenseSerialNumber });
    OpenAjax.registerGlobals("SmartClient", ["isc"]);
}


isc._longDOMIds = window.isc_useLongDOMIDs;

// add a property to global scope.  This property will always be available as "isc[propName]" and
// will also be available as "window[propName]" if we are in "simpleNames" mode.
// NOTE: even in simpleNames mode, where we assume it's OK to put things into global scope, we
// should still think carefully about creating globals.  Eg a variable like "params" which holds the
// current URL parameters (which we used to have) could easily get clobbered by some sloppy global
// JS, causing mysterious crashes.  Consider creating a class method (eg Page.getWidth()) or class
// property (Log.logViewer) instead, or making the variable isc.myMethod() or isc.myProperty.
isc._$iscPrefix = "isc.";
isc.addGlobal = function (propName, propValue) {
    if (propName.indexOf(isc._$iscPrefix) == 0) propName = propName.substring(4);
    isc[propName] = propValue;
    if (isc._useSimpleNames) window[propName] = propValue;
}





//>Offline

//XXX need to determine this flag correctly at load time
isc.onLine = true;

isc.isOffline = function () {
    return !isc.onLine;
};
isc.goOffline = function () { isc.onLine = false; };
isc.goOnline = function () { isc.onLine = true; };
if (window.addEventListener) {
    window.addEventListener("online", isc.goOnline, false);
    window.addEventListener("offline", isc.goOffline, false);
}
//<Offline


}




if (typeof isc.Browser != "object") {




//> @class Browser
// The <code>Browser</code> class contains various class attributes that indicate basic properties
// of the browser and whether certain features are enabled.
// @treeLocation Client Reference/Foundation
// @visibility external
//<
isc.addGlobal("Browser", {
    isSupported: false


    ,_assert : function (b, message) {
        if (!b) {
            message = "assertion failed" + (message ? " with message: '" + message + "'" : "");

            if (isc.logWarn) {
                isc.logWarn(message + ". Stack trace:" + isc.Class.getStackTrace());

            } else if (console) { // useful fallback crash info before logging loads
                console.log(message);
                console.trace();
            }


        }
    }


});


// ----------------------------------------------------------------
// Detecting browser type
// ----------------------------------------------------------------
// Bot/Crawler discriminators.  In many cases the bots will use something approximating a
// browser engine to "run your javascript", but the UA string, which we use to determine the
// proper rendering path, either does not reflect the engine type at all or reflects a generic
// "Mozilla/5.0" or similar.  So first, we detect the bot type, and then this is used below to
// also set browser type - e.g. isGoogleBot -> isChrome + specific version from docs

// https://support.google.com/webmasters/answer/1061943?hl=en
isc.Browser.isGoogleBot = navigator.userAgent.indexOf("Googlebot/") != -1;
// https://www.bing.com/webmaster/help/which-crawlers-does-bing-use-8c184ec0
isc.Browser.isBingBot = navigator.userAgent.indexOf("bingbot/") != -1;
// https://perishablepress.com/list-all-user-agents-top-search-engines/
// Note that DuckDuckGo appears to use Bing, Yahoo, and Yandex and only go out directly for
// "answers": https://duck.co/help/results/sources
isc.Browser.isDuckDuckBot = navigator.userAgent.indexOf("DuckDuckBot/") != -1;
// https://help.yahoo.com/kb/SLN22600.html?guccounter=1
isc.Browser.isYahooBot = navigator.userAgent.indexOf("Slurp;") != -1;
// http://www.baiduguide.com/baidu-spider/
isc.Browser.isBaiduBot = navigator.userAgent.indexOf("Baiduspider") != -1;
// https://yandex.com/support/webmaster/robot-workings/check-yandex-robots.xml
isc.Browser.isYandexBot = navigator.userAgent.indexOf("YandexBot/") != -1;

// generic bot discriminator
isc.Browser.isBot = isc.Browser.isGoogleBot || isc.Browser.isBingBot ||
        isc.Browser.isDuckDuckBot || isc.Browser.isYahooBot || isc.Browser.isBaiduBot ||
        isc.Browser.isYandexBot;

//>    @classAttr    Browser.isOpera        (boolean : ? : R)
//        Are we in Opera ?
//<

isc.Browser.isOpera = (navigator.appName == "Opera" ||
                    navigator.userAgent.indexOf("Opera") != -1);

//console.log("navigator.appName:" + navigator.appName
//            + ", navigator.userAgent:" + navigator.userAgent);
//console.log("is opera?:" + isc.Browser.isOpera);

//>    @classAttr    Browser.isNS (boolean : ? : R)
//        Are we in Netscape (including Navigator 4+, NS6 & 7, and Mozilla)
//      Note: Safari also reports itself as Netscape, so isNS is true for Safari.
//<
isc.Browser.isNS = (navigator.appName == "Netscape" && !isc.Browser.isOpera);
//console.log("is NS?:" + isc.Browser.isNS);

//>    @classAttr    Browser.isIE        (boolean : ? : R)
//        Are we in Internet Explorer?
//<
isc.Browser.isIE = (navigator.appName == "Microsoft Internet Explorer" &&
                    !isc.Browser.isOpera) ||
                   navigator.userAgent.indexOf("Trident/") != -1;
//console.log("is IE?:" + isc.Browser.isIE);

//>    @classAttr    Browser.isMSN        (boolean : ? : R)
//      Are we in the MSN browser (based on MSIE, so isIE will be true in this case)
//<
isc.Browser.isMSN = (isc.Browser.isIE && navigator.userAgent.indexOf("MSN") != -1);
//console.log("is MSN?:" + isc.Browser.isMSN);


//>    @classAttr    Browser.isMoz        (boolean : ? : R)
//        Are we in any Mozilla-derived browser, that is, a browser based on Netscape's Gecko
//      engine? (includes Mozilla and Netscape 6+)
//<
isc.Browser.isMoz = (navigator.userAgent.indexOf("Gecko") != -1) &&
    // NOTE: Safari sends "(like Gecko)", but behaves differently from Moz in many ways

    (navigator.userAgent.indexOf("Safari") == -1) &&
    (navigator.userAgent.indexOf("AppleWebKit") == -1) &&
    !isc.Browser.isIE;
//console.log("is Moz?:" + isc.Browser.isMoz);

//>    @classAttr    Browser.isCamino (boolean : false : R)
//  Are we in Mozilla Camino?
//<
isc.Browser.isCamino = (isc.Browser.isMoz && navigator.userAgent.indexOf("Camino/") != -1);
//console.log("is Camino?:" + isc.Browser.isCamino);


//>    @classAttr    Browser.isFirefox (boolean : false : R)
//  Are we in Mozilla Firefox?
//<
isc.Browser.isFirefox = (isc.Browser.isMoz && navigator.userAgent.indexOf("Firefox/") != -1);
//console.log("is Fire Fox?:" + isc.Browser.isFirefox);


//> @classAttr  Browser.isAIR    (boolean : ? : R)
// Is this application running in the Adobe AIR environment?
//<
isc.Browser.isAIR = (navigator.userAgent.indexOf("AdobeAIR") != -1);
//console.log("is AIR?:" + isc.Browser.isAIR);


//>    @classAttr    Browser.isWebKit (boolean : ? : R)
// Are we in a WebKit-based browser (Safari, Chrome, mobile Safari and Android, others).
//<
isc.Browser.isWebKit = navigator.userAgent.indexOf("WebKit") != -1;
//console.log("is webkit?:" + isc.Browser.isWebKit);


//>    @classAttr    Browser.isSafari (boolean : ? : R)
// Are we in Apple's "Safari" browser? Note that this property will also be set for other
// WebKit based browsers (such as Google Chrome).
//<
// As far as we know all "true" Safari implementations identify themselves in the userAgent with
// the string "Safari", but so does Microsoft Edge, so that can't be used to identify "true"
// Safari.  GWT hosted mode browser on OSX is also based on apple webkit and should be treated
// like Safari but is not a Safari browser and doesn't identify itself as such in the userAgent.
// Reported UserAgent:
//  Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_5; en-us) AppleWebKit/525.18 (KHTML, like Gecko)
isc.Browser.isSafari = isc.Browser.isAIR || navigator.userAgent.indexOf("Safari") != -1 ||
        navigator.userAgent.indexOf("AppleWebKit") != -1 ||
        // GoogleBot uses the Chrome engine: https://developers.google.com/search/docs/guides/rendering
        // and isChrome implies isSafari (see below in the isChrome definition)
        isc.Browser.isGoogleBot;
//console.log("is Safari?:" + isc.Browser.isSafari);

//> @classAttr Browser.isEdge (boolean : ? : R)
// Are we in the Microsoft Edge browser (not the version based on Chromium)?
//<

isc.Browser.isEdge = isc.Browser.isSafari && (navigator.userAgent.indexOf("Edge/") != -1);
//console.log("is Edge?:" + isc.Browser.isEdge);


//> @classAttr Browser.isChromiumEdge (boolean : ? : R)
// Are we in the Microsoft Edge browser (the version based on Chromium)?
//<

isc.Browser.isChromiumEdge = isc.Browser.isSafari && (navigator.userAgent.indexOf("Edg/") != -1);


//> @classAttr Browser.isChrome (boolean : ? : R)
// Are we in the Google Chrome browser?
//<
// Behaves like Safari in most ways.  Note: do not detect Edge as Chrome - causes odd scrollbar
// misrenderings.  As of 7/30/2015 appears to work better with the isSafari codepaths
// Note: the Google crawler does not identify itself as Chrome, even though it is in fact using
// the Chrome engine.  This leads to us mis-detecting the render path and producing all sorts
// of errors that result in a failure to render at all as far as the crawler is concerned.
isc.Browser.isChrome = (isc.Browser.isSafari && !isc.Browser.isEdge &&
                        (navigator.userAgent.indexOf("Chrome/") != -1)) ||
        // GoogleBot uses the Chrome engine: https://developers.google.com/search/docs/guides/rendering
        isc.Browser.isGoogleBot;
//console.log("is Chrome?:" + isc.Browser.isChrome);

//>    @classAttr    Browser.isSafariStrict (boolean : ? : R)
// Are we in Apple's "Safari" browser? This property is only set on "true" Safari browsers.
//<

isc.Browser.isSafariStrict = isc.Browser.isSafari &&
        !isc.Browser.isAIR && !isc.Browser.isEdge && !isc.Browser.isChrome;
//console.log("is \"true\" Safari?:" + isc.Browser.isSafariStrict);


if (!isc.Browser.isIE && !isc.Browser.isOpera && !isc.Browser.isMoz &&
    !isc.Browser.isAIR && !isc.Browser.isWebkit && !isc.Browser.isSafari)
{
    if (navigator.appVersion.indexOf("MSIE") != -1) {
        isc.Browser.isIE = true;
        //console.log("is IE (inside embedded browser, etc)?:" + isc.Browser.isIE);

    }
}

//>    @classAttr    Browser.isChromeoS (boolean : ? : R)
// Is the operating system for the browser Chrome OS?
//<

//isc.Browser.isChromeOS = navigator.userAgent.match("\\([^)]*CrOS x86_64[^(]*\\)") != null;
isc.Browser.isChromeOS = navigator.userAgent.indexOf("CrOS x86_64") != -1;


// ----------------------------------------------------------------
// END Detecting browser type
// ----------------------------------------------------------------


//>    @classAttr Browser.minorVersion        (number : ? : R)
//        Browser version, with minor revision included (4.7, 5.5, etc).
//
// NOTE: In Firefox 16+, Browser.minorVersion will equal Browser.version by design. See
// Firefox +externalLink{https://bugzilla.mozilla.org/show_bug.cgi?id=728831,Bug 728831}.
//<
if (navigator.userAgent.indexOf("Trident/") >= 0 &&
    navigator.userAgent.lastIndexOf("rv:") >= 0)
{

    isc.Browser.minorVersion = parseFloat(navigator.userAgent.substring(navigator.userAgent.lastIndexOf("rv:") + "rv:".length));
} else {
    isc.Browser.minorVersion = parseFloat(isc.Browser.isIE
                                      ? navigator.appVersion.substring(navigator.appVersion.indexOf("MSIE") + 5)
                                      : navigator.appVersion );
}

if (isc.Browser.isIE) {
    // IE won't allow a documentMode higher than the version you are on.

    if (document.documentMode != null) {
        isc.Browser.minorVersion = Math.max( isc.Browser.minorVersion, document.documentMode );
    }
} else (function () {



    // per https://developers.google.com/search/docs/guides/rendering, accurate as of 6/5/2018
    // This number is not surfaced by the bot, so must hardcode
    if (isc.Browser.isGoogleBot) {
        isc.Browser.minorVersion = 41;
        return;
    }

    var needle, pos;
    if (navigator.appVersion) {
        // Safari
        needle = "Version/";
        pos = navigator.appVersion.indexOf(needle);
        if (pos >= 0) {
            isc.Browser.minorVersion = parseFloat(navigator.appVersion.substring(pos + needle.length));
            return;
        }
    }

    var ua = navigator.userAgent;

    needle = "Chrome/";
    pos = ua.indexOf(needle);
    if (pos >= 0) {
        isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
        return;
    }

    // Handle Camino before Firefox because Camino includes "(like Firefox/x.x.x)" in the UA.
    needle = "Camino/";
    pos = ua.indexOf(needle);
    if (pos >= 0) {
        isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
        return;
    }

    needle = "Firefox/";
    pos = ua.indexOf(needle);
    if (pos >= 0) {
        isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
        return;
    }

    if (ua.indexOf("Opera/") >= 0) {
        needle = "Version/";
        pos = ua.indexOf(needle);
        if (pos >= 0) {
            isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
            return;
        } else {
            // Opera 9.64
            needle = "Opera/";
            pos = ua.indexOf(needle);
            isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
            return;
        }
    }
})();

//>    @classAttr    Browser.version        (number : ? : R)
//        Browser major version number (integer: 4, 5, etc).
//<
isc.Browser.version = parseInt(isc.Browser.minorVersion);

// actually means IE6 or earlier, which requires radically different optimization techniques
isc.Browser.isIE6 = isc.Browser.isIE && isc.Browser.version <= 6;

//> @classAttr Browser.supportsHTML5Audio (boolean : varies : RA)
// Does this browser support HTML5 Audio via the &lt;AUDIO&gt; element?
//<
isc.Browser.supportsHTML5Audio = (document.createElement("audio") != null) ? "play" : null;

//>    @classAttr    Browser.caminoVersion (String : ? : R)
//        For Camino-based browsers, the Camino version number.
//<
if (isc.Browser.isCamino) {
    // Camino Version is the last thing in the userAgent
    isc.Browser.caminoVersion =
        navigator.userAgent.substring(navigator.userAgent.indexOf("Camino/") +7);
}

if (isc.Browser.isFirefox) {
//>    @classAttr    Browser.firefoxVersion (String : ? : R)
//        For Firefox-based browsers, the Firefox version number.
//          - 0.10.1    is Firefox PR 1
//      After this the version numbers reported match those in the about dialog
//          - 1.0       is Firefox 1.0
//          - 1.0.2     is Firefox 1.0.2
//          - 1.5.0.3   is Firefox 1.5.0.3
//<
    var userAgent = navigator.userAgent,
        firefoxVersion = userAgent.substring(userAgent.indexOf("Firefox/")+ 8),
        majorMinorVersion = firefoxVersion.replace(/([^.]+\.[^.]+)\..*/, "$1");
    isc.Browser.firefoxVersion          = firefoxVersion;
    isc.Browser.firefoxMajorMinorNumber = parseFloat(majorMinorVersion);
}

//>    @classAttr    Browser.geckoVersion (Integer : ? : R)
//        For Gecko-based browsers, the Gecko version number.
//      Looks like a datestamp:
//          - 20011019 is Netscape 6.2
//          - 20020530 is Mozilla 1.0
//          - 20020823 is Netscape 7.0
//          - 20020826 is Mozilla 1.1
//          - 20021126 is Mozilla 1.2
//          - 20030312 is Mozilla 1.3
//          - 20030624 is Mozilla 1.4
//          - 20031007 is Mozilla 1.5
//          - 20031120 is Mozilla 1.5.1 (Mac only release)
//          - 20040113 is Mozilla 1.6
//          - 20040616 is Mozilla 1.7
//          - 20040910 is Mozilla 1.73
//          - 20041001 is Mozilla Firefox PR1 (-- also see firefox version)
//          - 20041107 is Mozilla Firefox 1.0
//          - 20050915 is Mozilla Firefox 1.0.7
//          - 20051107 is Mozilla Firefox 1.5 RC2
//          - 20051111 is Mozilla Firefox 1.5 final
//          - 20060426 is Mozilla Firefox 1.5.0.3
//          - 20061010 is Mozilla Firefox 2.0
//          - 20070321 is Netscape 8.1.3 - LIES - really based on Firefox 1.0 codebase
//          - 20071109 is Firefox 3.0 beta 1
//          - 20080529 is Firefox 3.0
//          - 20100101 is Firefox 4.0.1
//<

if (isc.Browser.isMoz) {
    isc.Browser._geckoVIndex = navigator.userAgent.indexOf("Gecko/") + 6;
    // The 'parseInt' actually means we could just grab everything from the
    // end of "Gecko/" on, as we know that even if the gecko version is followed
    // by something, there will be a space before the next part of the UA string
    // However, we know the length, so just use it
    isc.Browser.geckoVersion = parseInt(
        navigator.userAgent.substring(
            isc.Browser._geckoVIndex, isc.Browser._geckoVIndex+8
        )
    );



    if (isc.Browser.isFirefox) {
        // clamp 1.0.x series to last known pre 1.5 version (1.0.7)
        if (isc.Browser.firefoxVersion.match(/^1\.0/)) isc.Browser.geckoVersion = 20050915;
        // clamp 2.0.x series to one day before near-final FF3 beta
        else if (isc.Browser.firefoxVersion.match(/^2\.0/)) isc.Browser.geckoVersion = 20071108;
    }


    if (isc.Browser.version >= 17) isc.Browser.geckoVersion = 20121121;
}

// Doctypes
//  Are we in strict standards mode.  This applies to IE6+ and all Moz 1.0+.
//
//  In strict mode, browsers attempt to behave in a more standards-compliant manner.  Of course,
//  standards interpretation varies pretty drastically between browser makers, so this is in effect
//  just another fairly arbitrary set of behaviors which continues to vary across browser makers,
//  and now also across modes within the same browser.
//
// Traditionally, we have essentially 3 cases to consider:
// - BackCompat / Quirks mode. This is the rendering used if docType is not specified, or if
//   specified as 'Transitional' or 'Frameset' / with no URI
//   (EG: <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">)
//   This is the default mode.
// - Strict. Completely standards complient.
//   Triggered by
//   <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
// - "Almost Strict" (AKA Transitional).
//   In IE this matches Strict mode completely.
//   In Moz it matches strict mode except for rendering of images within tables - see
//   http://developer.mozilla.org/en/docs/Images%2C_Tables%2C_and_Mysterious_Gaps
//   Triggered "transitional" doctype with URI
//   Reports document.compatMode as "CSS1Compat"
// - http://developer.mozilla.org/en/docs/Gecko%27s_%22Almost_Standards%22_Mode
// - http://www.htmlhelp.com/reference/html40/html/doctype.html
// - http://developer.mozilla.org/en/docs/Mozilla%27s_DOCTYPE_sniffing
//
// - we also have the HTML5 doctype to consider - <!DOCTYPE html>. Only applies to modern
//   browsers, and required for some of our more recent features (EG some drawing approaches)
//   We don't explicitly have a flag to differentiate between this and "isStrict"

//> @classAttr  Browser.isStrict    (boolean : ? : R)
//  Are we in strict standards mode.
//<
// HACK: Netscape6 does not report document.compatMode, so we can't tell that a DOCTYPE has been
// specified, but Netscape6 IS affected by a DOCTYPE.  So, in Netscape6, assume we're always in
// strict mode.  At the moment (3/30/03) all strict mode workarounds have identical behavior in
// normal mode.

isc.Browser.isStrict = document.compatMode == "CSS1Compat";
if (isc.Browser.isStrict && isc.Browser.isMoz) {

    isc.Browser._docTypePublicID = document.doctype.publicId;
    isc.Browser._docTypeSystemID = document.doctype.systemId;

}

// See http://developer.mozilla.org/en/docs/Mozilla%27s_DOCTYPE_sniffing
// See Drawing.test.html for some test cases
isc.Browser.isTransitional = /.*(Transitional|Frameset)/.test((document.all && document.all[0] && document.all[0].nodeValue) || (document.doctype && document.doctype.publicId));

isc.Browser.isIE7 = isc.Browser.isIE && isc.Browser.version == 7;

//> @classAttr Browser.isIE8 (boolean : ? : R)
// Returns true if we're running IE8 and we're in IE8 mode
// IE8 has a 'back-compat' type mode whereby it can run using IE7 rendering logic.
// This is explicitly controlled via the meta tags:
//
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=8" /&gt;
// or
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=7" /&gt;
//
// In beta versions IE8 reported itself version 7 and ran in IE7 mode unless the explicit IE8
// tag was present
// In final versions (observed on 8.0.6001.18702) it reports a browser version of 8 and runs
// in IE8 mode by default - but can be switched into IE7 mode via the explicit IE=7 tag.
//
// We therefore want to check the document.documentMode tag rather than just the standard
// browser version when checking for IE8
//<
isc.Browser.isIE8 = isc.Browser.isIE && isc.Browser.version>=8 && document.documentMode == 8;

//<
//> @classAttr Browser.isIE8Strict (boolean : ? : R)
// Are we in IE8 [or greater] strict mode.
// <P>
// In IE8 when the meta tag is present to trigger IE7 / IE8 mode the document is in
//
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=8" /&gt;
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=7" /&gt;
//
// If this tag is present, the document is in strict mode even if no DOCTYPE was present.
// The presence of this tag can be detected as document.documentMode being 8 rather than 7.
// document.compatMode still reports "CSS1Compat" as with earlier IE.
//<
// IE9 running in IE9 mode will report as IE8Strict:true. This makes sense since rendering quirks
// introduced in IE8 Strict, such as requiring explicit "overflow:hidden" in addition
// to table-layout-fixed in order to clip cells horizontally in tables apply in both places.
// For cases where we really need to distinguish we can check isc.Browser.version or isc.Browser.isIE9

isc.Browser.isIE8Strict = isc.Browser.isIE &&
                            (isc.Browser.isStrict && document.documentMode ==8) ||
                            document.documentMode > 8;

//> @classAttr Browser.isIE9 (boolean : ? : R)
// True if we're running IE9 or later, actually running in the IE9+ documentMode.
//<

isc.Browser.isIE9 = isc.Browser.isIE && isc.Browser.version>=9 && document.documentMode >= 9;

isc.Browser.isIE10 = isc.Browser.isIE && isc.Browser.version >= 10;

isc.Browser.isIE11 = isc.Browser.isIE && isc.Browser.version >= 11;

//> @classAttr  Browser.AIRVersion (String : ? : R)
// If this application running in the Adobe AIR environment, what version of AIR is
// running. Will be a string, like "1.0".
//<
isc.Browser.AIRVersion = (isc.Browser.isAIR ? navigator.userAgent.substring(navigator.userAgent.indexOf("AdobeAir/") + 9) : null);


//>    @classAttr    Browser.safariVersion (number : ? : R)
//        in Safari, what is is the reported version number
//<

if (isc.Browser.isSafari) {

    if (isc.Browser.isAIR) {

        isc.Browser.safariVersion = 530;
    } else {
        if (navigator.userAgent.indexOf("Safari/") != -1) {
            isc.Browser.rawSafariVersion = navigator.userAgent.substring(
                        navigator.userAgent.indexOf("Safari/") + 7
            );
        } else if (navigator.userAgent.indexOf("AppleWebKit/") != -1) {
            isc.Browser.rawSafariVersion = navigator.userAgent.substring(
                        navigator.userAgent.indexOf("AppleWebKit/") + 12
            );

        } else {
            isc.Browser.rawSafariVersion = "530"
        }



        isc.Browser.safariVersion = (function () {
            var rawVersion = isc.Browser.rawSafariVersion,
                currentDot = rawVersion.indexOf(".");

            if (currentDot == -1) return parseInt(rawVersion);
            var version = rawVersion.substring(0,currentDot+1),
                nextDot;
            while (currentDot != -1) {
                // Check AFTER the dot
                currentDot += 1;
                nextDot = rawVersion.indexOf(".", currentDot);
                version += rawVersion.substring(currentDot,
                                                (nextDot == -1 ? rawVersion.length: nextDot));
                currentDot = nextDot;
            }
            return parseFloat(version);
        })();
    }
}

// -------------------------------------------------------------------
// Platform information
// -------------------------------------------------------------------

//>    @classAttr    Browser.isWin        (boolean : ? : R)
//        Is this a Windows computer ?
//<
isc.Browser.isWin = navigator.platform.toLowerCase().indexOf("win") > -1;
if (isc.Browser.isWin) {
    // install winVersion as float
    isc.Browser.winVersion = function() {
        var windowsMatch = navigator.userAgent.match(/Windows NT[ ]*([0-9.]+)[^0-9.]/i);

        if (windowsMatch) return parseFloat(windowsMatch[1]);
    }();

}

// NT 5.0 is Win2k, NT 5.0.1 is Win2k SP1
isc.Browser.isWin2k = isc.Browser.winVersion >= 5.0 && isc.Browser.winVersion < 5.1;


//>    @classAttr    Browser.isMac        (boolean : ? : R)
//        Is this a Macintosh computer ?
//<
isc.Browser.isMac = navigator.platform.toLowerCase().indexOf("mac") > -1;

isc.Browser.isUnix = (!isc.Browser.isMac &&! isc.Browser.isWin);

//> @groupDef mobileDevelopment
// SmartClient is designed to automatically adapt to smaller screen sizes and the lower
// accuracy of touch-based interfaces.
// <p>
// In general, a SmartClient application written with complete ignorance of mobile development
// will still be highly usable on tablet or handset-sized touch devices.  This topic explains
// all the automatic behaviors that make this possible, and the few areas developers need to
// consider in order to optimize the mobile experience, the most important being:
// <p>
// <ul>
// <li> read about potential issues created by the automatically shown and hidden browser
//      toolbars in Safari on iOS7+, discussed under "minimal-ui" below.  SmartClient
//      automatically handles this, but most applications will want to create a non-interactive
//      banner to fill the blank screen area that is rendered unusable by iOS' behavior
// <li> read about "Automatic touch scrolling" below - if your application does not already
//      have alternative UIs for performing drag operations (as is required anyway for
//      +link{group:accessibility,accessibility reasons}), this section discusses options for
//      controlling drag scrolling vs dragging of data
// <li> review your application for the rare screen that has a fixed, very wide width and
//      doesn't allow scrolling.  Such screens would already be unusable for narrow desktop
//      browsers but are more of a problem for fixed-size mobile screens.  The section
//      "Exceptionally wide screens" below explains strategies for dealing with this.
// </ul>
// <p>
// <h3>Supported Browsers</h3>
// <P>
// <ul>
// <li> Safari on iOS devices (iPad, iPhone, iPod Touch)
// <li> Android's default (WebKit-based) browser <b>*</b>
// <li> Windows Phone default browser, latest release only <b>**</b>
// <li> Blackberry 10+ default (WekKit-based) browser <b>**</b>
// </ul>
// <b>*</b>: Android issues that occur <i>exclusively</i> on rare devices (under a certain
// percent of market share) will not normally be covered by a Support plan.  This is a
// necessity because highly customized versions of Android are used for a variety of niche
// devices (even microsatellites)<br>
// <b>**</b>: These browsers generally work and bug reports are accepted, but they do not yet
// fall under the normal Enterprise+ Support guarantee of fixing every confirmed bug
// <p>
// If you would like to check whether a specific device falls under normal Support, or would
// like a quote for a Support plan that would include a specific device or platform,
// +externalLink{http://smartclient.com/company/contact.jsp,contact Isomorphic here}.
// <P>
// <h3>Adaptive Components</h3>
// <p>
// Many SmartClient components automatically change their behavior and/or appearance when used
// with touch devices in general, or tablets and handsets specifically.  There are too many
// adaptations to comprehensively list, but some of the more obvious behaviors are listed below:
// <ul>
// <li> +link{SelectItem} and +link{ComboBoxItem} controls automatically fill the entire screen
//      or a major portion of the screen when activated, and add a control to dismiss the
//      full-screen interface.  See +link{ComboBoxItem.pickListPlacement} for details
// <li> +link{Menu} components likewise fill the entire screen or a major portion, and offer
//      submenu navigation via a slide-in animation and back button instead of displaying the
//      origin menu and submenu simultaneously
// <li> +link{Calendar.minimalUI,Calendar} eliminates the tabs normally used to switch between
//      Day, Week and Month view, instead using device pivot to switch between Day and Week
//      views and offering a compact link to Month view
// <li> Windows and Dialogs fill the screen by default and remove rounded edges to save space
// <li> many controls implement an expanded hit area for clicks or drags so that finger touches
//      that are technically outside of the drawn area of the control still activate the
//      control.  This accomodates the imprecision of finger touches as compared to mouse
//      clicks, while still showing the same compact appearance as is used for desktop
//      interfaces.  This includes the +link{Slider} thumb, +link{Window.headerControls},
//      +link{canvas.resizeFrom,edge-based resizing}, and many other controls.
// <li> +link{SpinnerItem} switches to side-by-side +/- controls instead of the very small,
//      vertically stacked +/- control typical of desktop interfaces
// <li> +link{AdaptiveMenu} can either display menu items inline, or in a drop-down,
//        or mix the two modes according to available space.
// </ul>
// <p>
// In addition to automatic behavior, SmartClient offers Adaptive Layout whereby a +link{Layout}
// member may be <i>designed</i> to render itself at multiple possible sizes, in order to fit
// into the amount of space available in the Layout.  Unlike simply indicating a flexible size
// on a member, setting an adaptive width or height indicates that the member has two (or more)
// different <i>ways</i> of rendering itself with different <i>discrete</I> sizes, but does not
// have the ability to use every additional available pixel.
// <p>
// For more guidance, see the documentation under +link{canvas.canAdaptWidth} and the
// +explorerExample{inlinedMenuMobileSample, Inlined Menu Mobile} and
// +explorerExample{adaptiveMenuMobileSample, Adaptive Menu} samples.
// <p>
// <h3>Finger / touch event handling</h3>
// <P>
// Mobile and touch devices support "touch events" that correspond to finger actions on the
// screen.  By default, SmartClient simply sends touch events to UI components as normal mouse
// events.  Specifically:
// <ul>
// <li> a finger tap gesture will trigger mouseDown, mouseUp and click events
// <li> a touch-and-slide interaction will trigger drag and drop, firing the normal SmartClient
//      sequence of dragStart, dragMove, and dragStop
// <li> a touch-and-hold interaction will trigger a contextMenu event, and will trigger a hover
//      if no contextMenu is shown
// </ul>
// This means that most applications that are written with mouse interaction in mind will
// function with a touch-based UI without special efforts.  Some interfaces which rely heavily
// on mouse hovers may want to display instructions to explicitly tell the user that they have
// to touch a given element to see more information.
// <p>
// <h3>Automatic touch scrolling</h3>
// <p>
// Components that normally show scrollbars on desktop browsers will, by default, hide
// scrollbars and allow scrolling via finger dragging instead.
// <p>
// If you are using drag and drop features such as +link{listGrid.canReorderRecords}, this
// obviously conflicts with using finger drags for scrolling.  There are two options:
// <p>
// <ol>
// <li> Leave touch scrolling active for the grid, but provide additional controls, such as
//      buttons, that enable users to perform the drag operation in a different way.
//      Optionally display scrollbars <em>in addition to</em> leaving touch scrolling active
//      by setting +link{Canvas.alwaysShowScrollbars} to <code>true</code>.
// <li> Set +link{canvas.useTouchScrolling,useTouchScrolling} to <code>false</code> on the component.
//      Scrollbars will be shown, and finger drags will no longer cause scrolling, so that
//      finger drags can now be used for the drag and drop operation configured on the
//      component
// </ol>
// Option #1 above is generally preferred, since it is also considered an
// +link{group:accessibility} violation if drag and drop is the sole way to trigger an
// operation (keyboard-only users cannot use drag and drop), and also because scrollbars are
// not usually found in touch interfaces.
// <p>
// If your application is not required to be keyboard accessible, and you prefer to show
// scrollbars and use finger drags for normal drag operations, you can use
// +link{Canvas.disableTouchScrollingForDrag} to make this choice system-wide or on a
// per-component-type basis.
// <p>
// <h3>Exceptionally wide screens / forms</h3>
// <p>
// If you have designed a screen for desktop use and it is too wide to fit on a handset or
// tablet-sized screen, there are several possible strategies:
// <ul>
// <li> <b>use +link{SplitPane}</b>: any time you have two or more panes where a choice in one
//      pane decides what is displayed in the other.  See the "SplitPane" section further down
//      for details
// <li> <b>rely on horizontal scrolling</b>: if you have something like a +link{DynamicForm}
//      that has 3 columns of input fields, as long as the form itself or some parent has
//      +link{canvas.overflow,overflow:"auto"} set, horizontal touch scrolling will be
//      available to reach fields that initially render offscreen.  Most of the time, there is
//      already an <code>overflow:"auto"</code> parent component as a result of default
//      framework behaviors or application settings that also make sense for desktop mode,
//      so nothing needs to be done.
//      <p>
//      However, consider whether scrolling is already in use for other purposes: if you have a
//      grid plus an adjacent component to the right, if the adjacent component is entirely
//      offscreen, attempting touch scrollng on the grid will just scroll the grid as such and
//      won't reveal the adjacent component.  In this kind of situation, you can:
//   <ul>
//   <li> <i>use +link{SplitPane}</i> as described above, a grid with something adjacent is
//        frequently a good candidate for conversion to <code>SplitPane</code>
//   <li> <i>make the scrolling component smaller or flexible size</i>.  Whether it's a grid or
//        other scrollable component on the left, this situation usually arises because an
//        inappropriately large fixed size has been set, instead of a
//        +link{canvas.width,flexible size}.
//   <li> <i>leave some blank space</i> above or below the grid - this gives the user somewhere
//        to use touch scrolling to move both the grid and adjacent component
//   <li> <i>force scrollbars to appear</i> by setting
//        +link{canvas.useTouchScrolling,useTouchScrolling} to false.  This is another way to
//        give the user a place they can touch in order to scroll the both the grid and
//        adjacent component together
//   </ul>
// <li> <b>use +link{FlowLayout}</b>: a <code>FlowLayout</code> can automatically take two
//      side-by-side elements and switch them to vertical stacking when the screen is narrow
// </ul>
// <p>
// <h3>SplitPane</h3>
// <p>
// The +link{SplitPane} component implements the common pattern of rendering
// two or three panes simultaneously on desktop machines and on tablets in landscape
// orientation, while switching to showing a single pane for handset-sized devices or tablets
// in portrait orientation.
// <p>
// Use <code>SplitPane</code> anywhere you have two or more panes in your application where a
// choice in one pane decides what is displayed in the other pane.  For example, you may have a
// list of Records where details of a single selected Record are shown next to the list.  A
// <code>SplitPane</code> is well-suited to this interface since it provides automatic "Back"
// navigation and a place to show the title of the selected record when only the detail view is
// showing.
// <p>
// Note that you do not need to use a <code>SplitPane</code> as your top-level component
// containing the whole application, and it <i>does</i> makes sense to use multiple
// <code>SplitPane</code> components in a single application.  For example, your top-level
// container component might be a +link{TabSet}, and a +link{SplitPane} would be used to manage
// components in tabs which normally show 2 panes side-by-side on desktop browsers.
// <P>
// <h3>Device type and overriding</h3>
// <p>
// In most cases SmartClient will correctly detect the device running your application, and set
// the flags +link{Browser.isTouch}, +link{Browser.isHandset}, +link{Browser.isTablet} and
// +link{Browser.isDesktop} appropriately.
// <p>
// For any uncommon device for which these variables are not set correctly, you can use
// +link{Browser.setIsTablet()}, +link{Browser.setIsHandset()} and +link{Browser.setIsTouch()}
// to override the auto-detected settings.  If you use these APIs, call them <b>before</b>
// creating or drawing any SmartClient components or using any other SmartClient APIs.
// <p>
// Note that the various automatic behaviors triggered by flags on the +link{Browser} class can
// be overriden at a fine-grained level on individual components.  For example,
// +link{SplitPane} will use 2-pane display when a tablet is detected, however, for a
// particularly large, high-resolution tablet device, you could instead use 3-pane display by
// setting +link{SplitPane.deviceMode} to "desktop".
// <p>
// <h3>Mobile look and feel</h3>
// <P>
// We recommend using either the Tahoe, Stratus or Obsidian skins for applications
// that support mobile (or a custom skin based on one of these skins).  These skins make
// maximum use of CSS3 to minimize the number of images that need to be loaded and the number
// of DOM elements used to create components.
// <p>
// We also do <b>not</b> recommend attempting to mimic the native UI of each particular mobile
// platform, because:
// <ul>
// <li> if users access the same application via desktop and mobile browsers, consistent
// appearance and behavior between the desktop and mobile rendering of the application is more
// important for familiarity than looking similar to other applications on the mobile device
// <li> mobile platform design overhauls, such as the major changes from iOS6 to iOS7, can
// easily invalidate efforts to look like native applications on the device
// <li> there is no single consistent appearance across Android devices because different
// manufacturers customize the platform a great deal, so efforts to closely mimic any one
// device won't yield any real consistency
// </ul>
// <P>
// <h3>iOS 7, browser toolbars and "minimal-ui" setting</h3>
// <p>
// Safari in iOS 7.0 will automatically hide and show browser toolbars as the user scrolls
// around a normal web page, pivots, or touches near edges of the screen.  This creates serious
// problems for web applications, partly because notifications are not reliably fired when
// toolbars are shown and hidden, and partly because it introduces "dead zones" where an
// application cannot place interactive controls, since touching there shows browser toolbars
// instead.
// <p>
// iOS 7.1 introduces a "minimal-ui" setting on the viewport <code>meta</code> tag which
// eliminates most of these problems, by requiring that the user specifically touch the
// URL bar to reveal browser toolbars.  Even with this setting, the top 20px of space <i>in
// landscape orientation only</i> is still a "dead zone".
// <p>
// SmartClient automatically uses the minimal-ui setting whenever iOS is detected, and also
// sets +link{canvas.defaultPageSpace} to 20px in landscape orientation to avoid components
// being placed in the dead zone.  These default behaviors can be disabled by defining the
// <code>isc_useMinimalUI</code> global variable with the value <code>false</code> before the
// framework is loaded:
// <pre> &lt;script type="text/javascript"&gt;
// window.isc_useMinimalUI = false;
// &lt;/script&gt;</pre>
// <p>
// Whether minimal-ui is used or not, it is recommend to place some kind of non-interactive
// widget or content in the dead zones created by browser toolbars, for example, a +link{Label}
// showing your company name or application name.  When using +link{canvas.defaultPageSpace} to have
// all components avoid a dead zone at the top of the page, you can set
// +link{canvas.leavePageSpace,leavePageSpace:0} to allow individual components to place
// themselves in a dead zone.
// <p>
// <h3>Configuring the viewport</h3>
// <p>
// When a SmartClient application loads, by default a viewport &ltmeta&gt; tag is added to the
// page which, on touch devices, fixes the page zoom to 100% and disables the pinch-zoom gesture.
// This is usually the expected behavior of a touch-enabled web application because it makes
// the application look and feel more like a native app. This default setting can be disabled
// by defining the <code>isc_useDefaultViewport</code> global variable with the value
// <code>false</code> before the framework is loaded:
// <pre> &lt;script type="text/javascript"&gt;
// window.isc_useDefaultViewport = false;
// &lt;/script&gt;</pre>
// For more information on the mobile device viewport, see:
// <ul>
// <li>+externalLink{http://developer.apple.com/safari/library/documentation/AppleApplications/Reference/SafariWebContent/UsingtheViewport/UsingtheViewport.html,Configuring the Viewport - Safari Web Content Guide}</li>
// <li>+externalLink{https://developer.mozilla.org/en-US/docs/Mozilla/Mobile/Viewport_meta_tag,Using the viewport meta tag to control layout on mobile browsers - MDN}</li>
// </ul>
// <p>
// <h3>Orientation Change &amp; Screen Size</h3>
// <P>
// When orientation changes, this is treated identically to resizing the browser on a desktop
// machine.  If you've already created a UI that fills the browser and makes good use of
// available screen space for desktop browsers, the same behaviors will automatically apply
// when your application runs on mobile devices and the device is pivoted.
// <P>
// If you want to build specialized interfaces that respond to device orientation, the
// +link{Page.getOrientation()} API may be used to determine the current orientation of the
// application, and +link{pageEvent,the page orientationChange event} will fire whenever the
// user rotates the screen allowing applications or components to directly respond to the user
// pivoting their device.
// <p>
// <h3>Launching native helper apps (phone, facetime, maps..)</h3>
// <p>
// Generally, all that's required to launch native mobile apps is to create an ordinary HTML
// hyperlink (<code>&lt;a&gt;</code> tag) with a special prefix for the URL specified in the
// <code>href</code> attribute.  For example, the following HTML link will place a call when
// the user finger-taps it:
// <pre>
//   &lt;a href="tel:8675309"&gt;Call Jenny&lt;/a&gt;</pre>
// You can provide HTML like this as +link{HTMLFlow.contents}.  Or use a field of
// +link{type:FieldType,type:"link"} to cause various
// +link{DataBoundComponent,DataBoundComponents} to render a DataSourceField value as a
// clickable URL.
// <p>
// The URL prefixes that are valid for iOS are documented
// +externalLink{https://developer.apple.com/library/ios/featuredarticles/iPhoneURLScheme_Reference/Introduction/Introduction.html#//apple_ref/doc/uid/TP40007899-CH1-SW1,at Apple.com}.
// Typically, the same prefixes also work for Android, Windows Phone and others.
// <p>
// <h3>Configure the soft keyboard</h3>
// <p>
// +link{TextItem.browserInputType} can be set to various values such as "email" or "tel"
// (telephone number) to hint to mobile devices to use a different software keyboard with
// specialized keys appropriate for entering certain types of data values.
// <p>
// <h3>Note on mobile platform performance</h3>
// <p>
// When the first modern smartphones were released, it was necessary to use tiny,
// mobile-specific frameworks to get adequate performance for mobile web applications.
// <p>
// The situation is now completely different: through a combination of hardware improvements,
// optimizations in mobile browsers and vastly improved network speeds, typical mobile devices
// are easily able to run applications built with full-featured web platforms like SmartClient.
// For an application that supports both desktop and mobile interfaces, the worst case scenario
// for platform performance is often <b>not</b> a mobile phone, but an older desktop machine
// running Internet Explorer.
// <p>
// Unfortunately, there is a lot of out-of-date advice on the web about mobile web development
// that still advises using ultra-light, feature-poor frameworks for performance reasons.
// Carefully consider the source and recency of any such advice - the reality is that using
// such feature-poor frameworks means you will under-deliver with both your desktop <i>and</i>
// mobile interfaces.
// <p>
// For more background on choosing the right technologies for mobile and desktop web
// applications, see the
// +externalLink{http://smartclient.com/product/mobileStrategy.jsp,Mobile Strategy Page} at
// smartclient.com.
// <P>
// <h3>Offline Operation</h3>
// <P>
// SmartClient applications support "offline" operation (continuing to work without network
// access).
// <P>
// Permanent caching of resources such as .js, .css files and images are handled via the standard
// +externalLink{https://www.google.com/search?q=html5+manifest,HTML5 Manifest} - just list all
// the static files your application needs in a manifest file and mobile browsers will cache
// those resources.
// <P>
// Dynamic data is handled via the +link{Offline} APIs as well as special DataSource support
// enabled by +link{DataSource.useOfflineStorage}.
// <P>
// The end result is that you can bookmark a SmartClient application to a phone's home screen
// and use it offline with cached data, much like an installed native application.
// <P>
// <h2>Packaging as a native application</h2>
// <P>
// Via "packaging" technologies such as PhoneGap/Cordova and Titanium, a SmartClient web application
// can be packaged as an installable native application that can be delivered via the "App Store"
// for the target mobile platform.  Applications packaged in this way have access to phone-specific
// data and services such as contacts stored on the phone, or the ability to invoke the device's camera.
// <P>
// Both Titanium and PhoneGap provide access to the underlying native device APIs such as the
// accelerometer, geolocation, and UI. Both frameworks enable application development using
// only JavaScript, CSS and HTML. Additionally they provide development environments that work
// across a wide variety of devices.
// <P>
// PhoneGap has good support for native device APIs as noted +externalLink{http://www.phonegap.com/about/feature,here}.
// Titanium has similar support. There are differences between the two environments and how they
// expose their APIs, though both provide Xcode-compatible projects that can be compiled and run from the Xcode IDE.
// See +link{titaniumIntegration,Integration with Titanium} and +link{phonegapIntegration,Integration with PhoneGap}
// for more information.
//
// @title Mobile Application Development
// @treeLocation Concepts
// @visibility external
//<


//> @groupDef titaniumIntegration
// Titanium provides an extensive Javascript API to access a native device's UI, phone, camera, geolocation, etc.
// Documentation, getting started, programming guides are +externalLink{http://developer.appcelerator.com/documentation,here}.
// Titanium provides a consistent API across devices including the ability to mix webviews with native controls.
// <P>
// The Titanium sample application provides an example of accessing a device's Contacts db using SmartClient.
// The application presents 2 tabs 'Customers' and 'Contacts' and allows the user to import Customer contacts into
// his/her contacts db resident on the device. Selecting a Customer's Contact address will show a map of the contact.
// Selecting a Customer's phone number will call the customer or prompt to import the contact into the user's
// contacts. The latter option is default behavior on the iPad. Calling the customer contact is default behavior for
// devices such as the iPhone or Android.
// <P>
// The Titanium Contact object holds the following properties:
// <ul>
// <li>URL</li>
// <li>address</li>
// <li>birthday</li>
// <li>created</li>
// <li>date</li>
// <li>department</li>
// <li>email</li>
// <li>firstName</li>
// <li>firstPhonetic</li>
// <li>fullName</li>
// <li>image</li>
// <li>instantMessage</li>
// <li>jobTitle</li>
// <li>kind</li>
// <li>lastName</li>
// <li>lastPhonetic</li>
// <li>middleName</li>
// <li>middlePhonetic</li>
// <li>modified</li>
// <li>nickname</li>
// <li>note</li>
// <li>organization</li>
// <li>phone</li>
// <li>prefix</li>
// <li>relatedNames</li>
// <li>suffix</li>
// </ul>
// <P>
// The following Titanium API's are used:
// <ul>
// <li>Titanium.App.addEventListener</li>
// <li>Titanium.App.fireEvent</li>
// <li>Titanium.Contacts.getAllPeople</li>
// <li>Titanium.Geolocation.forwardGeocoder</li>
// <li>Titanium.Map.STANDARD_TYPE,</li>
// <li>Titanium.Map.createView</li>
// <li>Titanium.UI.createTab</li>
// <li>Titanium.UI.createTabGroup</li>
// <li>Titanium.UI.createWebView</li>
// <li>Titanium.UI.createWindow</li>
// <li>Titanium.UI.setBackgroundColor</li>
// </ul>
// <P>
// The following SmartClient Components are used
// <ul>
// <smartclient>
// <li>isc.DataSource</li>
// <li>isc.ListGrid</li>
// </smartclient>
// <smartgwt>
// <li>DataSource</li>
// <li>ListGrid</li>
// </smartgwt>
// </ul>
// <P>
// The following SmartClient Resources are bundled in the Titanium application
// <ul>
// <li>ISC_Containers.js</li>
// <li>ISC_Core.js</li>
// <li>ISC_DataBinding.js</li>
// <li>ISC_Foundation.js</li>
// <li>ISC_Grids.js</li>
// <li>load_skin.js</li>
// <li>skins/Mobile/images/black.gif</li>
// <li>skins/Mobile/images/blank.gif</li>
// <li>skins/Mobile/images/checked.png</li>
// <li>skins/Mobile/images/formula_menuItem.png</li>
// <li>skins/Mobile/images/grid.gif</li>
// <li>skins/Mobile/images/group_closed.gif</li>
// <li>skins/Mobile/images/group_opened.gif</li>
// <li>skins/Mobile/images/headerMenuButton_icon.gif</li>
// <li>skins/Mobile/images/loading.gif</li>
// <li>skins/Mobile/images/loadingSmall.gif</li>
// <li>skins/Mobile/images/opacity.png</li>
// <li>skins/Mobile/images/pinstripes.png</li>
// <li>skins/Mobile/images/row_collapsed.gif</li>
// <li>skins/Mobile/images/row_expanded.gif</li>
// <li>skins/Mobile/images/sort_ascending.gif</li>
// <li>skins/Mobile/images/sort_descending.gif</li>
// <li>skins/Mobile/skin_styles.css</li>
// </ul>
//
// @title Integration with Titanium
// @treeLocation Concepts/Mobile Application Development
// @visibility external
//<

//> @groupDef phonegapIntegration
// <P>
// PhoneGap documentation, quick start information, and programming guides are available at +externalLink{http://phonegap.com,http://phonegap.com}.
// <P>
// PhoneGap exposes a Contacts API which allows one to find, create and remove contacts from the device's contacts database.
// Unlike Titanium, which provides many native UI components, PhoneGap relies on 3rd party frameworks for
// UI components. Additionally, PhoneGap provides no transitions or other animation effects normally
// accessible in native applications.
// <P>
// <em>In the following guide, the name "MyMobileApp" refers to a SmartClient mobile application.
// The instructions are intended to be general, and applicable to other apps by simply substituting
// the application name and the few other app-specific details.</em>
//
// <h3>Installing PhoneGap</h3>
// Beginning with PhoneGap 2.9.0, PhoneGap is an NPM (Node.js Packager Manager) package.
// You will need to install Node.js first in order to install PhoneGap. (<b>Tip for Mac users:</b>
// +externalLink{http://brew.sh,Homebrew} is a simple and easy way
// to install the latest version of Node.js and npm: <code>brew install node</code>)
//
// <p>Once Node.js is installed, see +externalLink{http://phonegap.com/install/,http://phonegap.com/install/} for
// instructions on installing PhoneGap.
//
// <h3>Creating the PhoneGap Project</h3>
// Use the +externalLink{http://docs.phonegap.com/en/edge/guide_cli_index.md.html,<code>phonegap</code> command line utility}
// to create a new folder containing the project files:
//
// <pre style="white-space:nowrap">phonegap create --id com.mycompany.apps.MyMobileApp --name "MyMobileApp" path/to/project_folder</pre>
//
// <p>The project ID and name should be changed for your app.
//
// <h3>General Instructions</h3>
// Within the project folder, PhoneGap creates a special <code>www/</code> folder which contains
// the application JavaScript code and other assets. Within this folder, only <code>config.xml</code>
// is needed. All other files of the default "Hello PhoneGap" app can be deleted.
//
// <p>You will need to open the application's main HTML file in a text editor to make a few changes:
// <ul>
//   <li>Change the DOCTYPE to the HTML5 DOCTYPE: <code>&lt;!DOCTYPE html&gt;</code></li>
//   <li>Add a <code>&lt;script&gt;</code> tag to the <code>&lt;head&gt;</code> element to load <code>cordova.js</code>:
//       <pre>&lt;script type="text/javascript" charset="UTF-8" src="cordova.js"&gt;&lt;/script&gt;</pre>
//
//       <p><b>NOTE:</b> The <code>www/</code> folder should not contain <code>cordova.js</code>.
//       In other words, don't try to copy <code>cordova.js</code> into the <code>www/</code> folder.
//       PhoneGap automatically adds the appropriate version of this script, which is different for
//       each platform.</li>
//   <li>Ensure that the following <code>&lt;meta&gt;</code> tags are used, also in the <code>&lt;head&gt;</code> element:
//       <pre>&lt;meta http-equiv="Content-Type" content="text/html;charset=UTF-8"&gt;
//&lt;meta name="format-detection" content="telephone=no"&gt;
//&lt;meta name="viewport" content="initial-scale=1, width=device-width, user-scalable=no, minimum-scale=1, maximum-scale=1"&gt;</pre></li>
// </ul>
//
// <p>After making those changes, you will need to defer starting the application until the
//    <code>+externalLink{http://docs.phonegap.com/en/edge/cordova_events_events.md.html#deviceready,deviceready}</code> event has fired,
//    particularly if your application invokes any PhoneGap API function.
//
//        <smartclient>In SmartClient, deferring the application can be accomplished by wrapping all application code within a 'deviceready' listener:
//        <pre class="sourcefile">&lt;script type="text/javascript"&gt;
//document.addEventListener("deviceready", function onDeviceReady() {
//    // application code goes here
//}, false);
//&lt;/script&gt;</pre></smartclient>
//
//        <smartgwt>To accomplish this in Smart&nbsp;GWT, it is helpful to use a utility class together with a bit of JavaScript.
//
// <p>The following utility class can be used to defer the <code>onModuleLoad</code> code until PhoneGap is ready:
//
// <pre class="sourcefile">package com.mycompany.client;
//
//import com.google.gwt.core.client.EntryPoint;
//
//public abstract class CordovaEntryPoint implements EntryPoint {
//
//    &#x40;Override
//    public final native void onModuleLoad() &#x2F;*-{
//        var self = this;
//        if ($wnd.isDeviceReady) self.&#x40;com.mycompany.client.CordovaEntryPoint::onDeviceReady()();
//        else {
//            var listener = $entry(function () {
//                $doc.removeEventListener("deviceready", listener, false);
//                self.&#x40;com.mycompany.client.CordovaEntryPoint::onDeviceReady()();
//            });
//            $doc.addEventListener("deviceready", listener, false);
//        }
//    }-*&#x2F;;
//
//    protected abstract void onDeviceReady();
//}</pre>
//
// <p>The <code>CordovaEntryPoint</code> class is used in conjunction with the following JavaScript,
//        which should be added before the closing <code>&lt/body&gt;</code> tag:
//
//     <pre class="sourcefile">&lt;script type="text/javascript"&gt;
//document.addEventListener("deviceready", function onDeviceReady() {
//    window.isDeviceReady = true;
//    document.removeEventListener("deviceready", onDeviceReady, false);
//}, false);
//&lt;/script&gt;</pre>
//
// <p>After compiling your application with PhoneGap/Cordova support, copy the compiled Smart&nbsp;GWT
// application to the <code>www/</code> folder.
// </smartgwt>
//
// <h3>iOS Platform (iPhone &amp; iPad)</h3>
//
// <ol>
// <li>Open <b>Terminal</b>, <code>cd</code> into the project folder, and run:
// <pre>phonegap build ios</pre></li>
// <li>Within the newly-created <code>platforms/ios/</code> folder, open the Xcode project <code>MyMobileApp.xcodeproj</code>.</li>
// <li>In Xcode, set the active scheme to <b>MyMobileApp &gt; iPhone Retina (4-inch) &gt; iOS 7.0</b> or some other simulator destination.
//     Then click the <b>Run</b> button. Xcode will start the iPhone Simulator and run the app.</li>
// <li>When you are finished testing the application in the simulator, click the <b>Stop</b> button.</li>
// </ol>
//
// <p>It is helpful to pay attention to the output window when testing the app within iOS Simulator.
// The output window contains all logs to <code>+externalLink{https://developer.mozilla.org/en-US/docs/Web/API/console,window.console}</code> and messages from the Cordova
// framework itself. One common issue is <code>ERROR whitelist rejection: url='SOMEURL'</code>,
// which means that SOMEURL has not been added to <code>&lt;access origin="..."/&gt;</code> in <code>config.xml</code>.
// Refer to the +externalLink{http://docs.phonegap.com/en/edge/guide_whitelist_index.md.html#Domain%20Whitelist%20Guide,Domain Whitelist Guide}
// for more information.
//
// <p>Once you have completely tested the application within the simulator, you should test the app on
// real hardware. Refer to Apple's +externalLink{https://developer.apple.com/library/ios/documentation/IDEs/Conceptual/AppDistributionGuide/Introduction/Introduction.html,App Distribution Guide} for complete instructions on provisioning the app for testing devices, in particular, the section titled
// +externalLink{https://developer.apple.com/library/ios/documentation/IDEs/Conceptual/AppDistributionGuide/TestingYouriOSApp/TestingYouriOSApp.html#//apple_ref/doc/uid/TP40012582-CH8-SW1,Beta Testing Your iOS App}.
//
// <p>Apple has deprecated UIWebView and we recommend switching to the officially supported
// +externalLink{https://github.com/apache/cordova-plugin-wkwebview-engine,WKWebView} plugin to
// resolve momentum scrolling issues and obtain more Safari-like behavior.
//
// <h3>Android Platform</h3>
// To begin targeting Android devices, follow the instructions on the
// +externalLink{http://docs.phonegap.com/en/edge/guide_platforms_android_index.md.html,Android Platform Guide}.
//
// <p>It is helpful to monitor the LogCat view in Eclipse to verify that your application is working correctly.
// Common errors include:
// <ul>
// <li><code>Application Error The protocol is not supported. (gap://ready)</code>
//     <p>This means that the incorrect <code>cordova.js</code> script is being used. You
//     must use the <code>cordova.js</code> for Android.<!-- http://community.phonegap.com/nitobi/topics/error_starting_app_on_android -->
//     <p>Try updating the 'android' platform to fix the problem:
//     <pre>phonegap platform update android</pre>
//     </li>
// <li><code>Data exceeds UNCOMPRESS_DATA_MAX</code>
//     <p>In older versions of Android (pre-2.3.3), there is a 1 Megabyte limit on the size of individual
//        Android app assets. This error message means that one asset file exceeds this limit.
//        You should see a popup alert dialog containing the name of the problematic file, and then the app will crash.
//     <p>The "Data exceeds UNCOMPRESS_DATA_MAX" error can be seen if, for example, the SmartGWT.mobile application
//        was compiled in DETAILED or PRETTY mode.
//     </li>
// </ul>
//
// <h3>Samples</h3>
// <smartclient>
// <p>The SmartClient SDK package has a sample application called MyContacts which demonstrates how
// to work with the PhoneGap API in a SmartClient app. The main SmartClient code is located in
// <code>smartclientSDK/examples/phonegap/MyContacts</code>. An Xcode project used to package the app for iOS
// devices is located at <code>smartclientSDK/examples/phonegap/MyContacts-iOS</code>. An Eclipse project used
// to package the app for Android devices is located at <code>smartclientSDK/examples/phonegap/MyContacts-Android</code>.
// </smartclient><smartgwt>
// <p>The Smart&nbsp;GWT Google Code project has a sample application called
// +externalLink{https://github.com/isomorphic-software/smartgwt/tree/master/samples/phonegap/MyContacts,MyContacts}
// which demonstrates how to work with the PhoneGap API in a Smart&nbsp;GWT app. The main Smart&nbsp;GWT code is located at
// <code>+externalLink{https://github.com/isomorphic-software/smartgwt/tree/master/samples/phonegap/MyContacts,trunk/samples/phonegap/MyContacts}</code>.
// An Xcode project used to package the app for iOS devices is located at <code>
// +externalLink{https://github.com/isomorphic-software/smartgwt/tree/master/samples/phonegap/MyContacts-iOS,trunk/samples/phonegap/MyContacts-iOS}</code>.
// An Eclipse project used to package the app for Android devices is located at <code>
// +externalLink{https://github.com/isomorphic-software/smartgwt/tree/master/samples/phonegap/MyContacts-Android,trunk/samples/phonegap/MyContacts-Android}</code>.
//
// <p>This sample application utilizes the script changer technique to load the correct <code>cordova.js</code>.
// Additionally, GWT's +externalLink{http://www.gwtproject.org/doc/latest/DevGuideCodingBasicsOverlay.html,JavaScript overlay types}
// feature is used to easily wrap the PhoneGap Contacts API for use by the Smart&nbsp;GWT app.
// </smartgwt>
//
// @title Integration with PhoneGap
// @treeLocation Concepts/Mobile Application Development
// @visibility external
//<

isc.Browser.isAndroid = navigator.userAgent.indexOf("Android") > -1;

if (isc.Browser.isAndroid) {
    var pos = navigator.userAgent.indexOf("Android");
    if (pos >= 0) {
        isc.Browser.androidMinorVersion = parseFloat(navigator.userAgent.substring(pos + "Android".length));
        // Firefox for Android does not say which version of Android it's running on.
        // See also:
        // - https://developer.mozilla.org/en/Gecko_user_agent_string_reference#Mobile_and_Tablet_indicators
        // - Bug 625238 - Add device info to User-Agent
        //   https://bugzilla.mozilla.org/show_bug.cgi?id=625238
        if (window.isNaN(isc.Browser.androidMinorVersion)) delete isc.Browser.androidMinorVersion;
    }

    // Is the browser a WebView? This is true for the stock Android Browser and third-party apps'
    // WebViews (such as when using Cordova/PhoneGap), but should be false for other Android browsers.
    // From https://developers.google.com/chrome/mobile/docs/webview/overview#what_is_the_default_user-agent
    // "If you're attempting to differentiate between the WebView and Chrome for Android, you
    // should look for the presence of the Version/X.X string in the WebView user-agent string.
    // Don't rely on the specific Chrome version number, 30.0.0.0 as this may change with future
    // releases."
    isc.Browser.isAndroidWebView = navigator.userAgent.indexOf("Version/") >= 0;
}


isc.Browser.isRIM = isc.Browser.isBlackBerry =
    navigator.userAgent.indexOf("BlackBerry") > -1 || navigator.userAgent.indexOf("PlayBook") > -1;

isc.Browser.isMobileIE = navigator.userAgent.indexOf("IEMobile") > -1;

// Is the browser Mobile Firefox?
// https://wiki.mozilla.org/Compatibility/UADetectionLibraries
// https://developer.mozilla.org/en-US/docs/Gecko_user_agent_string_reference#Mobile_and_Tablet_indicators
isc.Browser.isMobileFirefox = isc.Browser.isFirefox && (navigator.userAgent.indexOf("Mobile") > -1 ||
                                                        navigator.userAgent.indexOf("Tablet") > -1);


isc.Browser.isMobileWebkit = (isc.Browser.isSafari &&
        (navigator.userAgent.indexOf(" Mobile/") > -1 || navigator.userAgent.indexOf("(iPad") > -1)
    || isc.Browser.isAndroid
    || isc.Browser.isBlackBerry) && !isc.Browser.isFirefox;


isc.Browser.isMobileWebkitDesktopMode = isc.Browser.isSafari &&
    navigator.platform == "MacIntel" && navigator.maxTouchPoints > 0;
if (window.isc_ignoreMobileSafariDesktopMode !== false && isc.Browser.isMobileWebkitDesktopMode) {
    isc.Browser.isMobileWebkit = true;
}


// intended for general mobile changes (performance, etc)
isc.Browser.isMobile = (isc.Browser.isMobileFirefox ||
                        isc.Browser.isMobileIE ||
                        isc.Browser.isMobileWebkit);

//> @classAttr browser.supportsDualInput (boolean : varies : RW)
// Does the browser support both mouse and touch input?
// @visibility external
//<

isc.Browser.supportsDualInput = window.isc_useDualInput != false &&
        (isc.Browser.isWin && isc.Browser.winVersion >= 6.2 || isc.Browser.isChromeOS) &&
        (isc.Browser.isMoz ||
         ((isc.Browser.isChrome || isc.Browser.isIE11 || isc.Browser.isEdge) &&
          navigator.maxTouchPoints > 0));

isc.Browser._useTouchMoveImageCSS = isc.Browser.supportsDualInput &&
        (isc.Browser.isIE11 || isc.Browser.isEdge);

isc.Browser._useTouchMoveCanvasCSS = isc.Browser._useTouchMoveImageCSS &&
        window.isc_useNativeTouchScrolling == false;


if (isc.Browser.supportsDualInput && isc.Browser.isChrome) {
    isc.Browser.minDualInputThumbLength = 28;
}

//> @classAttr browser.isTouch (boolean : auto-detected based on device : RW)
// Is the application running on a touch device (e.g. iPhone, iPad, Android device, etc.)?
// <p>
// SmartClient's auto-detected value for <code>isTouch</code> can be overridden via
// +link{Browser.setIsTouch()}.
//
// @visibility external
//<




isc.Browser._mobileBrowsers = (isc.Browser.isMobileFirefox ||
                                isc.Browser.isMobileIE || isc.Browser.isMobileWebkit);

isc.Browser.isTouch = isc.Browser.isWin || isc.Browser.isChromeOS ?
        isc.Browser._mobileBrowsers ||
            (isc.Browser.supportsDualInput && !!window.isc_useDualInput)
     :
        (( 'ontouchstart' in window ) ||
         (navigator.maxTouchPoints != null && navigator.maxTouchPoints > 0));

//> @classMethod browser.setIsTouch() (A)
// Setter for +link{Browser.isTouch} to allow this global variable to be changed at runtime.
// This advanced method is provided to override SmartClient's auto-detection logic, since the
// framework can only detect touch devices that existed at the time the platform was released.
// Any change to +link{Browser.isTouch} must be made before any component is created;
// <strong>it is an application error</strong> to attempt to change <code>isTouch</code> after
// components have been created.
// <p>
// Note that setting <code>Browser.isTouch</code> might affect the values of
// +link{Browser.isDesktop}, +link{Browser.isTablet}, and/or +link{Browser.isHandset}.
//
// @param isTouch (boolean) new setting for <code>Browser.isTablet</code>.
// @visibility external
//<
isc.Browser.setIsTouch = function (isTouch) {
    var Browser = this;

    isTouch = Browser.isTouch = !!isTouch;

    if (Browser.isDesktop) {
        Browser.isHandset = false;
        Browser.isTablet = false;
    } else {
        Browser.isHandset = isTouch && !Browser.isTablet;
        Browser.isTablet = !Browser.isHandset;
    }

    Browser.hasNativeDrag = !isTouch && "draggable" in document.documentElement &&
        !(Browser.isIE || Browser.isEdge);

    Browser.nativeMouseMoveOnCanvasScroll = !isTouch && (Browser.isSafari || Browser.isChrome);


};

//> @classAttr browser.pointerEnabled (boolean : varies : RW)
// Does the browser support pointer events as a means of capturing both touch and mouse
// interactions?  This simplifies event handling for capable browsers.
//<

isc.Browser.pointerEnabled = window.PointerEvent != null &&
        navigator.pointerEnabled != false && navigator.msPointerEnabled != false &&
        (isc.Browser.isIE || isc.Browser.isEdge) && !isc.Browser.isMobileIE;

//> @classAttr browser.hasDualInput (boolean : false : RW)
// is the browser currently sending both mouse and touch input?  For example, Microsoft Surface
// devices are touch devices that run Windows 10 but also allow the connection of USB mice.  In
// such an environment, we may not be able to auto-detect that touch input is present, so the
// switch to hasDualINput: true will only happen at the moment a touch event actually arrives.
//<
isc.Browser.hasDualInput = !!window.isc_useDualInput;

// helper called by EventHandler to switch to dual input mode if a touch event arrives
isc.Browser.setHasDualInput = function () {

    if (this.hasDualInput == true) return;



    if (isc.logInfo) {
        isc.logInfo("Switching to dual input mode to handle touch events");
    }

    this.setIsTouch(true);
    this.hasDualInput = true;


    if (isc.Canvas) {
        isc.Canvas.addProperties({
            overflowStyle: "none",
            _browserSupportsNativeTouchScrolling: isc.Browser._getSupportsNativeTouchScrolling()
        });
    }
    if (isc.ListGrid) {
        isc.ListGrid.addProperties({
            showRollOver: false,
            // if a mouse event is received, switch rollover back on
            handleMouseMove : function (event, eventInfo) {
                return this._handleDualInputMouseMove(event, eventInfo);
            }
        });
    }
}

// iPhone OS including iPad.  Search for iPad or iPhone.

isc.Browser.isIPhone = (isc.Browser.isMobileWebkit &&
                        (navigator.userAgent.indexOf("iPhone") > -1 ||
                         navigator.userAgent.indexOf("iPad") > -1));

if (isc.Browser.isIPhone) {
    // adapted from SmartGWT.mobile
    var match = navigator.userAgent.match(/CPU\s+(?:iPhone\s+)?OS\s*([0-9_]+)/i);
    if (match != null) {
        isc.Browser.iOSMinorVersion = window.parseFloat(match[1].replace('_', '.'));
        isc.Browser.iOSVersion = isc.Browser.iOSMinorVersion << 0;
    }

    // The UIWebView user agent is different from the Mobile Safari user agent in that it does
    // not contain the word "Safari".
    isc.Browser.isUIWebView = navigator.userAgent.indexOf("Safari") < 0;

    // Chrome for iOS
    // https://developers.google.com/chrome/mobile/docs/user-agent#chrome_for_ios_user-agent
    isc.Browser.isIOSChrome = navigator.userAgent.indexOf("CriOS/") >= 0;
    // Firefox for iOS
    // https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/User-Agent/Firefox
    isc.Browser.isIOSFirefox = navigator.userAgent.indexOf("FxiOS/") >= 0;

    isc.Browser.isMobileSafari = !isc.Browser.isUIWebView && !isc.Browser.isIOSChrome
                                    && !isc.Browser.isIOSFirefox;

}

// iPad.  Checks for "iPhone" OS + "iPad" in UA String.
isc.Browser.isIPad = (isc.Browser.isIPhone &&
                        navigator.userAgent.indexOf("iPad") > -1);

// Handle the mobile-safari masquerading as desktop case

if (window.isc_ignoreMobileSafariDesktopMode !== false &&
    isc.Browser.isMobileWebkitDesktopMode && !isc.Browser.isAndroid)
{
    isc.Browser.isIPhone = true;
    isc.Browser.isMobileSafari = true;

    // Assume iPad at this point rather than iPhone.
    // When isc.Page has been created we'll look at page dimensions and set to
    // iPhone/handset if necessary
    isc.Browser.isIPad = true;

    // set the iOS version from the spoofed desktop userAgent reported by iPad

    var match = navigator.userAgent.match(/Mac OS[^)]*\).*Version\/([0-9.]+)/);
    if (match != null) {
        var desktopAgentVersion = window.parseFloat(match[1]);
        isc.Browser.iOSVersion = Math.trunc(desktopAgentVersion);
        isc.Browser.iOSMinorVersion = isc.Browser.iOSVersion;
    }
}

isc.Browser.isWindowsPhone = navigator.userAgent.indexOf("Windows Phone") > -1;


if (isc.Browser.isIPad && isc.Browser.isMobileSafari && isc.Browser.iOSVersion == 7) {

    var iOS7IPadStyleSheetID = "isc_iOS7IPadStyleSheet";
    if (document.getElementById(iOS7IPadStyleSheetID) == null) {
        var styleElement = document.createElement("style");
        styleElement.id = iOS7IPadStyleSheetID;
        document.head.appendChild(styleElement);
        var s = styleElement.sheet;
        s.insertRule("\n@media (orientation:landscape) {\n" +
                         "html {" +
                             "position: fixed;" +
                             "bottom: 0px;" +
                             "width: 100%;" +
                             "height: 672px;" +
                         "}" +
                         "body {" +
                             "position: fixed;" +
                             "top: 0px;" +
                             "margin: 0px;" +
                             "padding: 0px;" +
                             "width: 100%;" +
                             "height: 672px;" +
                         "}\n" +
                     "}\n", 0);
    }


    (function () {
        var isFormItemElement = function (element) {
            if (element == null) return false;
            var tagName = element.tagName;
            return (tagName === "INPUT" ||
                    tagName === "SELECT" ||
                    tagName === "TEXTAREA");
        };

        var scrollToTopTimerID = null;
        window.addEventListener("scroll", function () {
            if (document.body == null) return;
            var scrollTop = document.body.scrollTop;
            if (scrollTop == 0) return;

            var activeElement = document.activeElement;
            if (isFormItemElement(activeElement)) {
                var onBlur = function onBlur(blurEvent) {
                    activeElement.removeEventListener("blur", onBlur, true);

                    if (scrollToTopTimerID != null) clearTimeout(scrollToTopTimerID);
                    scrollToTopTimerID = setTimeout(function () {
                        scrollToTopTimerID = null;

                        activeElement = document.activeElement;

                        // If another form item element is active, then wait for that element to lose focus.
                        if (activeElement !== blurEvent.target && isFormItemElement(activeElement)) {
                            activeElement.addEventListener("blur", onBlur, true);

                        } else {
                            document.body.scrollTop = 0;
                        }
                    }, 1);
                };
                activeElement.addEventListener("blur", onBlur, true);
            } else {
                document.body.scrollTop = 0;
            }
        }, false);
    })();
}


//> @type DeviceMode
// Possible layout modes for UI components that are sensitive to the device type being used
// (a.k.a. "responsive design").  See for example +link{SplitPane.deviceMode}.
// @value "handset" mode intended for handset-size devices (phones).  Generally only one UI
//                  panel will be shown at a time.
// @value "tablet" mode intended for tablet-size devices.  Generally, up to two panels are
//                 shown side by side in "landscape" +link{type:PageOrientation}, and only one
//                 panel is shown in "portrait" orientation.
// @value "desktop" mode intended for desktop browsers.  Three or more panels may be shown
//                  simultaneously.
// @visibility external
//<

//> @classAttr browser.isTablet (boolean : auto-detected based on device : RW)
// Is the application running on a tablet device (e.g. iPad, Nexus 7)?
// <p>
// SmartClient can correctly determine whether the device is a tablet in most cases. On any
// uncommon device for which this variable is incorrect, you can define the <code>isc_isTablet</code>
// global with the correct value, and SmartClient will use <code>isc_isTablet</code> for
// <code>Browser.isTablet</code> instead of its own detection logic. Alternatively, you can use
// +link{Browser.setIsTablet()} to change this global variable before any components are
// created.
// <p>
// The value of this variable is only meaningful on touch devices.
//
// @setter setIsTablet()
// @visibility external
//<

if (window.isc_isTablet != null) {
    isc.Browser.isTablet = !!window.isc_isTablet;
} else {
    isc.Browser.isTablet = isc.Browser.isIPad ||
                           (isc.Browser.isRIM && navigator.userAgent.indexOf("Tablet") > -1) ||
                           (isc.Browser.isAndroid && navigator.userAgent.indexOf("Mobile") == -1);
}
isc.Browser._origIsTablet = isc.Browser.isTablet;

//> @classMethod browser.setIsTablet() (A)
// Setter for +link{Browser.isTablet} to allow this global variable to be changed at runtime.
// This advanced method is provided to override SmartClient's detection of devices, since the
// framework can only detect devices that existed at the time the platform was released. Any
// changes to +link{Browser.isDesktop}, +link{Browser.isHandset}, or +link{Browser.isTablet}
// must be made before any component is created;
// <strong>it is an application error</strong> to attempt to change <code>isDesktop</code>,
// <code>isHandset</code>, or <code>isTablet</code> after components have been created.
// <p>
// Note that setting <code>Browser.isTablet</code> might affect the values of
// +link{Browser.isDesktop} and +link{Browser.isHandset}.
//
// @param isTablet (boolean) new setting for <code>Browser.isTablet</code>.
// @visibility external
//<
isc.Browser.setIsTablet = function (isTablet) {
    isTablet = isc.Browser.isTablet = !!isTablet;
    isc.Browser.isHandset = (isc.Browser.isTouch && !isc.Browser.isTablet);
    isc.Browser.isDesktop = (!isc.Browser.isTablet && !isc.Browser.isHandset);


};

//> @classAttr browser.isHandset (boolean : auto-detected based on device: RW)
// Is the application running on a handset-sized device, with a typical screen width of around
// 3-4 inches?
// <p>
// This typically implies that the application will be working with only 300-400 pixels.
//
// @setter setIsHandset()
// @visibility external
//<


isc.Browser.isHandset = (isc.Browser._mobileBrowsers && !isc.Browser.isTablet);

//> @classMethod browser.setIsHandset() (A)
// Setter for +link{Browser.isHandset} to allow this global variable to be changed at runtime.
// This advanced method is provided to override SmartClient's detection of devices, since the
// framework can only detect devices that existed at the time the platform was released. Any
// changes to +link{Browser.isDesktop}, +link{Browser.isHandset}, or +link{Browser.isTablet}
// must be made before any component is created;
// <strong>it is an application error</strong> to attempt to change <code>isDesktop</code>,
// <code>isHandset</code>, or <code>isTablet</code> after components have been created.
// <p>
// Note that setting <code>Browser.isHandset</code> might affect the values of
// +link{Browser.isDesktop} and +link{Browser.isTablet}.
//
// @param isHandset (boolean) new setting for <code>Browser.isHandset</code>.
// @visibility external
//<
isc.Browser.setIsHandset = function (isHandset) {
    isHandset = isc.Browser.isHandset = !!isHandset;
    isc.Browser.isTablet = (isc.Browser.isTouch && !isc.Browser.isHandset);
    isc.Browser.isDesktop = (!isc.Browser.isTablet && !isc.Browser.isHandset);


};

//> @classAttr browser.isDesktop (boolean : auto-detected based on device : RW)
// Is the application running in a desktop browser? This is true if +link{Browser.isTablet}
// and +link{Browser.isHandset} are both <code>false</code>.
//
// @setter setIsDesktop()
// @visibility external
//<

isc.Browser.isDesktop = (!isc.Browser.isTablet && !isc.Browser.isHandset);

//> @classMethod browser.setIsDesktop() (A)
// Setter for +link{Browser.isDesktop} to allow this global variable to be changed at runtime.
// This advanced method is provided to override SmartClient's detection of devices, since the
// framework can only detect devices that existed at the time the platform was released. Any
// changes to +link{Browser.isDesktop}, +link{Browser.isHandset}, or +link{Browser.isTablet}
// must be made before any component is created;
// <strong>it is an application error</strong> to attempt to change <code>isDesktop</code>,
// <code>isHandset</code>, or <code>isTablet</code> after components have been created.
// <p>
// Note that setting <code>Browser.isDesktop</code> might affect the values of
// +link{Browser.isHandset} and +link{Browser.isTablet}.
//
// @param isDesktop (boolean) new setting for <code>Browser.isDesktop</code>.
// @visibility external
//<
isc.Browser.setIsDesktop = function (isDesktop) {
    isDesktop = isc.Browser.isDesktop = !!isDesktop;
    if (isDesktop) {
        isc.Browser.isHandset = false;
        isc.Browser.isTablet = false;
    } else {
        isc.Browser.isTablet = isc.Browser._origIsTablet;
        isc.Browser.isHandset = !isc.Browser.isTablet;
    }


};

//> @classAttr  Browser.isBorderBox    (boolean : ? : R)
// Do divs render out with "border-box" sizing by default.
//<
// See comments in Canvas.adjustHandleSize() for a discussion of border-box vs content-box sizing

isc.Browser.isBorderBox = (isc.Browser.isIE && !isc.Browser.isStrict);

//>    @classAttr    Browser.lineFeed    (String : ? : RA)
//        Linefeed for this platform
//<

isc.Browser.lineFeed = (isc.Browser.isWin ? "\r\n" : "\n");

//>    @classAttr    Browser._supportsMethodTimeout    (String : ? : RA)
//        setTimeout() requires text string parameter in MacIE or IE 4
//<
isc.Browser._supportsMethodTimeout = false;//!(isc.Browser.isIE && (isc.Browser.isMac || isc.Browser.version == 4));

//>    @classAttr    Browser.isDOM (String : ? : RA)
//        Whether this is a DOM-compliant browser.  Indicates general compliance with DOM standards,
//      not perfect compliance.
//<
isc.Browser.isDOM = (isc.Browser.isMoz || isc.Browser.isOpera ||
                     isc.Browser.isSafari || (isc.Browser.isIE && isc.Browser.version >= 5));

//> @classAttr browser.isSupported (boolean : auto-detected based on browser : R)
// Whether SmartClient supports the current browser.
// <P>
// Note that this flag will only be available on browsers that at least support basic
// JavaScript.
//
// @visibility external
//<
isc.Browser.isSupported = (
    // we support all versions of IE 5.5 and greater on Windows only
    (isc.Browser.isIE && isc.Browser.minorVersion >= 5.5 && isc.Browser.isWin) ||
    // Mozilla and Netscape 6, all platforms
    isc.Browser.isMoz ||
    isc.Browser.isOpera ||
    isc.Browser.isSafari || // NB: really means "is Webkit", so includes Chrome, mobile Safari
    isc.Browser.isAIR
);


isc.Browser.nativeMouseMoveOnCanvasScroll =
    !isc.Browser.isTouch && (isc.Browser.isSafari || isc.Browser.isChrome);

//> @classAttr Browser.seleniumPresent (boolean : varies : R)
// Whether current page has been loaded by Selenium WebDriver.
//<
isc.Browser.seleniumPresent = (function () {
    var match = location.href.match(/[?&](?:sc_selenium)=([^&#]*)/);
    return match && match.length > 1 && "true" == match[1];
})();


if (isc.Browser.isSafariStrict) {
    isc.Browser._writingModeCSS = {
        vertical_ltr: "vertical-rl;",
        vertical_rtl: "vertical-lr;",
        rotate_ltr: true,
        rotate_rtl: true,
        horizontal: "horizontal-tb;"
    };
} else if (isc.Browser.isEdge) {
    isc.Browser._writingModeCSS = {
        vertical_ltr: "tb-rl;",
        vertical_rtl: "tb;",
        rotate_ltr: true,
        rotate_rtl: true,
        horizontal: "unset;"
    };
} else {
    isc.Browser._writingModeCSS = {
        vertical_ltr: "tb-rl;",
        vertical_rtl: "tb;",
        rotate_ltr: true,
        rotate_rtl: true,
        horizontal: "lr;"
    };
}

//> @type Autotest
// @value isc.Browser.SHOWCASE autotest is targeting SmartClient or SGWT showcases
// @value isc.Browser.SELENESE autotest is targeting a single sample with Selenese
// @value isc.Browser.RUNNER autotest is targeting TestRunner-based JS tests
//<

//> @classAttr Browser.SHOWCASE (Constant : "showcase" : [R])
// A declared value of the enum type
// +link{type:Autotest,Autotest}.
// @constant
//<
isc.Browser.SHOWCASE = "showcase";

//> @classAttr Browser.SELENESE (Constant : "selenese" : [R])
// A declared value of the enum type
// +link{type:Autotest,Autotest}.
// @constant
//<
isc.Browser.SELENESE = "selenese";

//> @classAttr Browser.RUNNER (Constant : "runner" : [R])
// A declared value of the enum type
// +link{type:Autotest,Autotest}.
// @constant
//<
isc.Browser.RUNNER = "runner";

//> @classAttr Browser.autotest (Autotest : varies : R)
// The current mode of the autotest system (null if not in autotest mode)
//<
isc.Browser.autotest = (function () {
    var match = location.href.match(/[?&](?:autotest)=([^&#]*)/);
    return match && match.length > 1 ? match[1] : null;
})();

//>    @classAttr    Browser.allowsXSXHR    (boolean : ? : RA)
//    Traditionally, web browsers reject attempts to make an XmlHttpRequest of a server other than the origin
//  server. However, some more recent browsers allow cross-site XmlHttpRequests to be made, relying on the
//  server to accept or reject them depending on what the origin server is.
//<
isc.Browser.allowsXSXHR = (
    (isc.Browser.isFirefox && isc.Browser.firefoxMajorMinorNumber >= 3.5) ||
    // Chrome auto-updates to latest stable version every time you start it, and there is no option to prevent
    // this from happening, so there's no point in querying version
    (isc.Browser.isChrome) ||
    (isc.Browser.isSafari && isc.Browser.safariVersion >= 531)
);

//> @classAttr Browser.useCSSFilters (boolean : ? : R)
// Whether the current browser supports gradients and whether SmartClient is
// configured to use gradients (via the setting of window.isc_useGradientsPreIE9).
//<


var isc_useGradientsPreIE9 = window.isc_useGradientsPreIE9;
isc.Browser.useCSSFilters =
    !isc.Browser.isIE || isc.Browser.isIE9 || isc_useGradientsPreIE9 != false;

//> @classAttr Browser.isSGWT (boolean : ? : RA)
// Are we running in SGWT.
// This is set up by SmartGWT wrapper code in JsObject.init().
// Obviously only applies to internal SmartClient code since developer code for an SGWT app
// would be written in Java and there'd be no need to check this var!
// @visibility internal
//<

//> @classAttr browser.useCSS3 (boolean : see below : R)
// Whether the current browser supports CSS3 and whether SmartClient is configured to use
// CSS3 features (via the setting of window.isc_css3Mode).
// <P>
// If isc_css3Mode is "on" then useCSS3 is set to true.  If isc_css3Mode is set to
// "supported", "partialSupport", or is unset, then useCSS3 is set to true only if the browser
// is a WebKit-based browser, Firefox, IE 9 in standards mode, or IE 10+.  If isc_css3Mode is set
// to "off" then useCSS3 is set to false.
// @visibility external
//<
var isc_css3Mode = window.isc_css3Mode;
if (isc_css3Mode == "on") {
    isc.Browser.useCSS3 = true;
} else if (isc_css3Mode == "off") {
    isc.Browser.useCSS3 = false;
} else if (isc_css3Mode == "supported" ||
           isc_css3Mode == "partialSupport" ||
           (typeof isc_css3Mode) === "undefined")
{
    isc.Browser.useCSS3 = isc.Browser.isWebKit ||
                          isc.Browser.isFirefox ||
                          (isc.Browser.isIE && (isc.Browser.isIE9 || isc.Browser.version >= 10));
} else {
    isc.Browser.useCSS3 = false;
}

var isc_spriting = window.isc_spriting;
if (isc_spriting == "off") {
    isc.Browser.useSpriting = false;
} else {
    isc.Browser.useSpriting = (!isc.Browser.isIE || isc.Browser.version >= 7);
}

isc.Browser.useInsertAdjacentHTML = !!document.documentElement.insertAdjacentHTML;

//> @classAttr Browser.supportsFlatSkins (boolean : varies : IR)
// Whether browser is capable of rendering flat skins (e.g. Tahoe).
// @visibility sgwt
//<
isc.Browser.supportsFlatSkins = isc.Browser.useCSS3 && isc.Browser.useSpriting;

//> @classAttr Browser.defaultSkin (String : varies : IR)
// Preferred default skin if none is specified.
// @visibility sgwt
//<
isc.Browser.defaultSkin = isc.Browser.supportsFlatSkins ? "Tahoe" : "Enterprise";

//> @classAttr Browser.defaultFontIncrease (int : varies : IR)
// Preferred font size increase if none is specified.
// @visibility sgwt
//<
isc.Browser.defaultFontIncrease = isc.Browser.seleniumPresent ? 0 :
        (isc.Browser.supportsFlatSkins ? 3 : 1);

//> @classAttr Browser.defaultSizeIncrease (int : varies : IR)
// Preferred control size increase if none is specified.
// @visibility sgwt
//<
isc.Browser.defaultSizeIncrease = isc.Browser.seleniumPresent ? 0 :
        (isc.Browser.supportsFlatSkins ? 10 : 2);


isc.Browser.useInsertAdjacentHTMLForSVG = (function () {
    if (!!document.createElementNS) {
        var svgGElem = document.createElementNS("http://www.w3.org/2000/svg", "g");
        if ((typeof svgGElem.insertAdjacentHTML) === "function") {
            try {
                svgGElem.insertAdjacentHTML("beforeend", "<rect/><ellipse/>");
                return (svgGElem.childNodes.length == 2 &&
                        svgGElem.childNodes[1].namespaceURI === "http://www.w3.org/2000/svg");
            } catch (e) {
                // ignored
            }
        }
    }
    return false;
})();

// Test for availability of the Range.getBoundingClientRect() method which was added to
// CSSOM View as of the 04 August 2009 Working Draft.
// http://www.w3.org/TR/2009/WD-cssom-view-20090804/

isc.Browser.hasNativeGetRect = (!isc.Browser.isIE &&
                                (!isc.Browser.isSafari || !isc.Browser.isMac || isc.Browser.version >= 6) &&
                                !!document.createRange &&
                                !!(document.createRange().getBoundingClientRect));


// isc.Browser.useClipDiv - if true we write out 2 handles for each widget
// the content div and the clip div. This is required to allow reliable measuring of content,
// sizing, etc. in some browsers


isc.Browser.useClipDiv = (isc.Browser.isMoz || isc.Browser.isSafari || isc.Browser.isOpera);

// _useNewSingleDivSizing: Use a single div rather than double-div structure for
// widgets with overflow settings where this is supportable.
// Only has an impact if useClipDiv is true.

isc.Browser._useNewSingleDivSizing = !((isc.Browser.isIE && isc.Browser.version < 10 && !isc.Browser.isIE9) ||
                                       (isc.Browser.isWebKit && !(parseFloat(isc.Browser.rawSafariVersion) >= 532.3)));




isc.Browser.hasTextOverflowEllipsis = (!isc.Browser.isMoz || isc.Browser.version >= 7) &&
                                      (!isc.Browser.isOpera || isc.Browser.version >= 9);

// https://developer.mozilla.org/en-US/docs/CSS/text-overflow
isc.Browser._textOverflowPropertyName = (!isc.Browser.isOpera || isc.Browser.version >= 11 ? "text-overflow" : "-o-text-overflow");


isc.Browser._hasGetBCR = !isc.Browser.isSafari || isc.Browser.version >= 4;


isc.Browser._hasElementPointerEvents = ("pointerEvents" in document.documentElement.style &&
                                        !isc.Browser.isOpera &&
                                        (!isc.Browser.isIE || isc.Browser.version >= 11));

// Does the browser support HTML5 drag and drop?
// http://caniuse.com/#feat=dragndrop
// http://www.whatwg.org/specs/web-apps/current-work/multipage/dnd.html#dnd
//
// This is set to false in IE and Edge because cross-window drags are not possible.

isc.Browser.hasNativeDrag = !isc.Browser.isTouch && "draggable" in document.documentElement &&
        !(isc.Browser.isIE || isc.Browser.isEdge);

// http://dom.spec.whatwg.org/#ranges
isc.Browser._hasDOMRanges = !!(window.getSelection && document.createRange && window.Range);

// Whether the browser supports Range.createContextualFragment() generally.

isc.Browser._supportsCreateContextualFragment = isc.Browser._hasDOMRanges && !!document.createRange().createContextualFragment;

// Whether the browser supports Range.createContextualFragment() in SVG contexts.

isc.Browser._supportsSVGCreateContextualFragment = ((isc.Browser.isMoz && isc.Browser.version >= 36) ||
                                                    (isc.Browser.isChrome && isc.Browser.version >= 42));

// Whether the browser supports the CSS `background-size' property.
// https://developer.mozilla.org/en-US/docs/Web/CSS/background-size
isc.Browser._supportsBackgroundSize = "backgroundSize" in document.documentElement.style;

// Does the browser support CSS3 transitions?
// http://caniuse.com/#feat=css-transitions
// Note: No need to check for "msTransition" because IE10 was the first version of IE to have
// CSS3 transitions support and this is unprefixed.

isc.Browser._supportsCSSTransitions = (("transition" in document.documentElement.style ||
                                        "WebkitTransition" in document.documentElement.style ||
                                        "OTransition" in document.documentElement.style) &&
                                       (!isc.Browser.isMoz ||
                                        (!isc.Browser.isTouch && isc.Browser.version >= 34)));


isc.Browser._transitionEndEventType = ("WebkitTransition" in document.documentElement.style
                                       ? "webkitTransitionEnd"
                                       : ("OTransition" in document.documentElement.style
                                          ? (isc.Browser.isOpera && isc.Browser.version >= 12 ? "otransitionend" : "oTransitionEnd")
                                          : "transitionend"));

// Whether the browser supports native touch scrolling.
// This is a classMethod rather than a classAttr because it depends on isTouch, which is settable
// by the application any time up to creation of the first widget. See setIsTouch().
isc.Browser._getSupportsNativeTouchScrolling = function () {
    if (window.isc_useNativeTouchScrolling == false) return false;
    return this.isTouch && (!this.isMoz || !this.isWin) &&
        (!(this.isIPhone || this.isIPad) || this.iOSVersion >= 6);
};

isc.Browser._supportsWebkitOverflowScrolling = isc.Browser.iOSVersion >= 6 &&
                   ("webkitOverflowScrolling" in document.documentElement.style)
;

// Does the browser support CanvasRenderingContext2D.isPointInStroke()?
isc.Browser._supportsCanvasIsPointInStroke = (function () {
    var canvas = document.createElement("canvas");
    if (canvas.getContext != null) {
        var context = canvas.getContext("2d");
        return !!context.isPointInStroke;
    }
    return false;
})();


isc.Browser._supportsNativeNodeContains = ("contains" in document.documentElement);
// Node.contains() was introduced in Gecko 9.
if (!isc.Browser._supportsNativeNodeContains && window.Node != null) {
    Node.prototype.contains = function (otherNode) {
        for (; otherNode != null; otherNode = otherNode.parentNode) {
            if (this === otherNode) return true;
        }
        return false;
    };
}


isc.Browser._supportsMinimalUI = (isc.Browser.isIPhone && !isc.Browser.isIPad &&
                                  isc.Browser.isMobileSafari &&
                                  7.1 == isc.Browser.iOSMinorVersion);


isc.Browser._svgElementsHaveParentElement = (!!document.createElementNS && "parentElement" in document.createElementNS("http://www.w3.org/2000/svg", "svg"));
if (!isc.Browser._svgElementsHaveParentElement && window.SVGElement != null && Object.defineProperty) {
    Object.defineProperty(SVGElement.prototype, "parentElement", {
        enumerable: true,
        "get" : function () {
            var parentElement = this.parentNode;
            while (parentElement != null && parentElement.nodeType != 1) {
                parentElement = parentElement.parentNode;
            }
            return parentElement;
        }
    });
}

isc.Browser._svgElementsHaveContains = (!!document.createElementNS && "contains" in document.createElementNS("http://www.w3.org/2000/svg", "svg"));
if (!isc.Browser._svgElementsHaveContains && window.SVGElement != null) {
    SVGElement.prototype.contains = function (otherNode) {
        for (; otherNode != null; otherNode = otherNode.parentNode) {
            if (this === otherNode) return true;
        }
        return false;
    };
}

// Does the browser support the HTML5 'placeholder' attribute?

isc.Browser._supportsPlaceholderAttribute = ("placeholder" in document.createElement("input") &&
                                             "placeholder" in document.createElement("textarea"));

isc.Browser._supportsIOSTabs = isc.Browser.isMobileWebkit && "webkitMaskBoxImage" in document.documentElement.style;

// Does the browser support the Screen Orientation API?
// https://w3c.github.io/screen-orientation/
// http://caniuse.com/#feat=screen-orientation

isc.Browser._supportsScreenOrientationAPI = (window.screen != null && "orientation" in screen && "type" in screen.orientation);

// Does the browser support the SVGSVGElement.getIntersectionList() SVG 1.1 DOM method?

isc.Browser._supportsSVGGetIntersectionList = (!isc.Browser.isSafari &&
                                               !isc.Browser.isChrome &&
                                               !!document.createElementNS &&
                                               "getIntersectionList" in document.createElementNS("http://www.w3.org/2000/svg", "svg") &&
                                               "createSVGRect" in document.createElementNS("http://www.w3.org/2000/svg", "svg"));

isc.Browser._supportsJSONObject = (window.JSON != null &&
                                   typeof window.JSON.parse === "function" &&
                                   typeof window.JSON.stringify === "function" &&
                                   window.JSON.stringify("\u0013") === "\"\\u0013\"");




//> @classAttr Browser.useHighPerformanceGridTimings (boolean : see below : I)
// Controls how agressive components based on the +link{class:GridRenderer} are with respect to
// redraws and data fetches. Modern browsers can generally handle much more frequent redraws
// and most server configurations can handle fetching more data more frequently in order to
// reduce the lag the end user perceives when scrolling through databound grids.  Starting with
// SmartClient 11.0/SmartGWT 6.0, this more aggressive redraw and fetch behavior us the
// default, but can be reverted to the old behavior if desired - see below.
// <P>
// This flag controls the defaults for several other properties (value on left is default for
// high performance mode, value on right is default when this mode is disabled.
// <ul>
// <li> +link{attr:ListGrid.dataFetchDelay} 1 -> 300
// <li> +link{attr:ListGrid.drawAheadRatio} 2.0 -> 1.3
// <li> +link{attr:ListGrid.quickDrawAheadRatio} 2.0 -> 1.3
// <li> +link{attr:ListGrid.scrollRedrawDelay} 0 -> 75
// <li> +link{attr:ListGrid.scrollWheelRedrawDelay} 0 -> 250
// <li> +link{attr:ListGrid.touchScrollRedrawDelay} 0 -> 300
// </ul>
// Note: since +link{class:TreeGrid} is a subclass of +link{class:ListGrid}, the above settings
// also apply to +link{class:TreeGrid}s.
// <ul>
// <li> +link{attr:GridRenderer.drawAheadRatio} 2.0 -> 1.3
// <li> +link{attr:GridRenderer.quickDrawAheadRatio} 2.0 -> 1.3
// <li> +link{attr:GridRenderer.scrollRedrawDelay} 0 -> 75
// <li> +link{attr:GridRenderer.touchScrollRedrawDelay} 0 -> 300
// </ul>
// <P>
// By default, for all browsers except Android-based Chrome, this flag is set to true, but can
// be explicitly disabled by setting <code>isc_useHighPerformanceGridTimings=false</code> in a
// script block before loading SmartClient modules.  Turning off high performance timings
// effectively enables the original SmartClient/SmartGWT behavior prior to the SmartClient
// 11.0/SmartGWT 6.0 release.
//
// @visibility external
//<
isc.Browser.canUseAggressiveGridTimings = !isc.Browser.isAndroid;
isc.Browser.useHighPerformanceGridTimings = window.isc_useHighPerformanceGridTimings == null ?
    isc.Browser.canUseAggressiveGridTimings : window.isc_useHighPerformanceGridTimings && isc.Browser.canUseAggressiveGridTimings;


isc.Browser._usePointerCursorForHand =
        isc.Browser.isMoz || (isc.Browser.isSafari && isc.Browser.isStrict) ||
        (isc.Browser.isIE && isc.Browser.version >= 9 && isc.Browser.isStrict);

}

isc.Browser.supportsAsynchFunctions = true;
try {
    new Function('async () => {}')();
} catch (e) {
    isc.Browser.supportsAsynchFunctions = false;
}




isc.noOp = function isc_noOp() {};
isc.emptyObject = {};
isc._emptyArray = [];
// normal and obfuscatable name
isc.emptyString = isc._emptyString = "";
isc.space = " ";
isc.dot = ".";
isc.semi = ";";
isc.colon = ":";
isc.slash = "/";
isc.star = "*";
isc.apos = "'";
isc.percent = "%";
isc.auto = "auto";
isc.px = "px";
isc.nbsp = "&nbsp;";
isc.xnbsp = "&amp;nbsp;"; // XHTML
isc._false = "false";
isc._falseUC = "FALSE";
isc._underscore = "_";
isc._dollar = "$";
isc._obsPrefix = "_$observed_";
isc._superProtoPrefix = "_$SuperProto_";

isc.gwtRef = "__ref";
isc.gwtModule = "__module";

//> @staticMethod isc.logWarn()
// Same as +link{classMethod:Log.logWarn}.
//
// @param message    (String)  message to log
// @param [category]   (String)  category to log in, defaults to "Log"
//
// @visibility external
//<
isc.logWarn = function isc_logWarn(message, category) { isc.Log.logWarn(message, category) };

//> @staticMethod isc.echo()
// Same as +link{classMethod:Log.echo}.
//
// @param value    (Any)  object to echo
// @return (String) a short string representation of the object
//
// @visibility external
//<
isc.echo = function isc_echo(value, multiLine) { return isc.Log.echo(value, multiLine) };

//> @staticMethod isc.echoAll()
// Same as +link{classMethod:Log.echoAll}.
//
// @param value    (Any)  object to echo
// @return (String) a short string representation of the object
//
// @visibility external
//<
isc.echoAll = function isc_echoAll(value) { return isc.Log.echoAll(value) };

//> @staticMethod isc.echoLeaf()
// Same as +link{classMethod:Log.echoLeaf}.
//
// @param value    (Any)  object to echo
// @return (String) a short string representation of the object
//
// @visibility external
//<
isc.echoLeaf = function isc_echoLeaf(value) { return isc.Log.echoLeaf(value) };

isc.echoFull = function isc_echoFull(value) { return isc.Log.echoFull(value) };

//> @staticMethod isc.logEcho()
// Logs the echoed object (using +link{staticMethod:isc.echo}) as a warning, prefixed with an
// optional message.
//
//     @param value    (Any)  object to echo
//     @param message    (String)  message to log
//
// @see Log.logWarn() for logging info
// @visibility external
//<
isc.logEcho = function isc_logEcho(value, message) {
    if (message) message += ": ";
    isc.Log.logWarn((message || isc._emptyString) + isc.echo(value))
}

//> @staticMethod isc.logEchoAll()
// Logs the echoed object (using +link{staticMethod:isc.echoAll}) as a warning, prefixed with an
// optional message.
//
//     @param value    (Any)  object to echo
//     @param message    (String)  message to log
//
// @see Log.logWarn() for logging info
// @visibility external
//<
isc.logEchoAll = function isc_logEchoAll(value, message) {
    if (message) message += ": ";
    isc.Log.logWarn((message || isc._emptyString) + isc.echoAll(value))
}

// OutputAsString / StackWalking / Tracing
// ---------------------------------------------------------------------------------------







isc._makeFunction = function isc__makeFunction(args, script) {

    var code = script || args;

    var returnVal;
    if (script == null) {
        returnVal = new Function(code);
        returnVal._argString = isc._emptyString;
    } else {
        returnVal = new Function(args, code);
    }
    return returnVal;
};


isc.doEval = function isc_doEval(code) {
    // transform code and eval inline
    if (isc.Browser.isMoz) return isc._transformCode(code);
    //return isc._transformCode(code);

    if (!isc._evalSet) isc._evalSet = [];
    isc._evalSet[isc._evalSet.length] = code;
    return null;
}
// called at module end
isc.finalEval = function isc_finalEval() {
    //!OBFUSCATEOK
    if (isc._evalSet) {
        if (isc.Browser.isMoz) {
            for (var i = 0; i < isc._evalSet.length; i++) {
                isc.eval(isc._evalSet[i]);
            }
        }
        var code = isc._evalSet.join("");

        if (isc.Browser.isSafari) code = isc._transformCode(code);
        // uncomment to use catch/rethrow stacks in IE as well
        //else if (isc.Browser.isIE) code = isc._transformCode(code);

        if (isc.Browser.isIE) {
            if (window.execScript != null) {
                window.execScript(code, "javascript");
            } else {
                window.eval(code);
            }

        // Safari
        } else {
            isc.eval(code);
        }

        // Init pipelining: set a timeout to eval so that the module init time takes place
        // while the next module is being downloaded (except for the last module)
        // Can't be used for real until
        /*
        var evalFunc = function () {
        if (isc.Browser.isIE) {
            if (window.execScript != null) {
                window.execScript(code, "javascript");
            } else {
                window.eval(code);
            }

        // Safari
        } else {
            isc.eval(code);
        }
        };

        if (isc.module_DataBinding != 1) {
            //if (isc.Log) isc.Log.logWarn("delaying eval");
            setTimeout(evalFunc, 0)
        } else {
            evalFunc();
        }
        */
    }
    isc._evalSet = null;
}

//isc._eitherMarker = /\/\/\$[01]/;
isc._startMarker = "//$0";
isc._endMarker = "//$1";
isc._totalTransformTime = 0;
// code transform time, all modules
//    - Moz: about 140ms
//      - NOTE: overall init time rises by about 400ms, the balance is due to slower parsing
//        because of the added try/catch constructs.  This can be demonstrated by doing the
//        split/join, but just restoring the markers
//    - Safari: about 300ms
//    - IE: 266ms
// - NOTE: some key advantages of this approach as compared to server-side generation *aside
//   from* not hosing IE's ability to do full stack traces w/o try/catch:
//    - allows arbitrary start/end code to be added with only client-side changes
//    - can be conditional per load
//    - much smaller code size impact: could ship w/o local vars for production use

isc._addCallouts = true;
isc._transformCode = function isc__transformCode(code) {
    // set flag indicating stack walking is enabled so that we will also add try..catch to
    // generated functions
    isc._stackWalkEnabled = true;

    var start = isc.timeStamp ? isc.timeStamp() : new Date().getTime();

    var startCode = isc._tryBlock, endCode = isc._evalFromCatchBlock;
    if (isc._addCallouts) startCode = isc._methodEnter + startCode;

    var chunks = code.split(isc._eitherMarker),
        finalCode = [];

    var chunks = code.split(isc._startMarker);
    code = chunks.join(startCode);
    chunks = code.split(isc._endMarker);
    code = chunks.join(endCode);

    if (isc._addCallouts) {
        chunks = code.split("//$2");
        code = chunks.join(isc._methodExit);
    }

    /*
    // approach of single split and join to cut down on String churn.
    // Problem is that because of nested functions, markers do not alternate.  Would need to
    // detect which kind of marker is needed for a given slot, by eg checking the next char
    // over, which might be expensive enough to wipe out any advantage; untested.
    var pos = 0;
    for (var i = 0; i < chunks.length; i++) {
        finalCode[pos++] = chunks[i];
        if (i < chunks.length-1) {
            finalCode[pos++] = i % 2 == 0 ? isc._tryBlock : isc._evalFromCatchBlock;
        }
    }
    finalCode = finalCode.join("");

    try {
        window.isc.eval(finalCode);
    } catch (e) {
        //if (!this._alerted) alert(finalCode.substring(0,5000));
        //this._alerted = true;
        document.write("chunks<br><TEXTAREA style='width:760px;height:400px'>" +
                        chunks.join("\n***") + "</" + "TEXTAREA>");
        document.write("finalCode<br><TEXTAREA style='width:760px;height:400px'>" +
                        finalCode + "</" + "TEXTAREA>");
        throw e;
    }
    //return finalCode;
    */

    var end = isc.timeStamp ? isc.timeStamp() : new Date().getTime();
    isc._totalTransformTime += (end-start);
    return code;
}

isc._evalFromCatchBlock = "}catch(_e){isc.eval(isc._handleError(";
isc._handleError = function isc__handleError(varList) {
    var code = "var _ = {";
    if (varList != "") {
        var varNames = varList.split(",");
        for (var i = 0; i < varNames.length; i++) {
            var varName = varNames[i];
            code += varName + ":" + varName;
            if (i < varNames.length-1) code += ",";
        }
    }
    code += "};";
    code += "if(isc.Log)isc.Log._reportJSError(_e,arguments,this,_);throw _e;";
    return code;
}



// fillList - utility to concat a number of individual arguments into an array
// ---------------------------------------------------------------------------------------
isc.fillList = function isc_fillList(array, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z) {

    if (array == null) array = [];
    else array.length = 0;

    var undef;
    // avoid touching the arguments object if possible

    if (X === undef && Y === undef && Z === undef) {
        array[0] = A;
        array[1] = B;
        array[2] = C;
        array[3] = D;
        array[4] = E;
        array[5] = F;
        array[6] = G;
        array[7] = H;
        array[8] = I;
        array[9] = J;
        array[10] = K;
        array[11] = L;
        array[12] = M;
        array[13] = N;
        array[14] = O;
        array[15] = P;
        array[16] = Q;
        array[17] = R;
        array[18] = S;
        array[19] = T;
        array[20] = U;
        array[21] = V;
        array[22] = W;
    } else {
        for (var i = 1; i < arguments.length; i++) {
            array[i-1] = arguments[i];
        }
    }

    return array;
}



//>    @staticMethod isc.addProperties()
//
// Add all properties and methods from any number of objects to a destination object,
// overwriting properties in the destination object.
// <p>
// Common uses of <code>addProperties</code> include creating a shallow copy of an object:<pre>
//
//     isc.addProperties({}, someObject);
//
// </pre>Combining settings in order of precedence:<pre>
//
//     isc.addProperties({}, defaults, overrides, skinOverrides);
//
// </pre>
// <P>
// <b>NOTES</b>:<ul>
// <li>Do not use <code>addProperties</code> to add defaults to an ISC class.
// Use +link{classMethod:Class.addProperties()}, as in:
// <i>MyClassName</i><code>.addProperties()</code>.
// <li>You may find it more convenient to use the instance method +link{class.addProperties()},
// as in: <i>myClassInstance</i><code>.addProperties()</code>, but there's no functional
// difference from using this method.
// </ul>
//
// @see classMethod:Class.addProperties()
// @see Class.addProperties()
//
//    @param    destination            (Object)    object to add properties to
//    @param    [arguments 1-N]    (Object)    objects to obtain properties from.  Properties of all
//                                            arguments other than destination are applied in turn.
// @return (Object) returns the destination object
// @visibility external
//<

/*
// code to count all methods according to what they are added to
isc.methodCount = 0;
isc.classMethodCount = 0;
isc.otherMethods = 0;
isc.otherMethodTargets = [];
*/

isc._sourceList = [];
isc._inAddProps = 0;

isc.addGlobal("addProperties", function isc_addProperties(destination, A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z) {

    // count recursive calls and avoid reusing the global isc._sourceList in this case.  Recursive calls
    // can happen if addPropertyList() logs something.
    var undef,
        sourceList = isc._inAddProps ? [] : isc._sourceList;
    isc._inAddProps++;

    if (X === undef && Y=== undef && Z === undef) {
        isc.fillList(sourceList, A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z);
    } else {
        sourceList.length = 0;
        for (var i = 1; i < arguments.length; i++) {
            sourceList[i -1] = arguments[i];
        }
    }


    var result = isc.addPropertyList(destination, sourceList);
    // reset the sourceList so we don't hang onto the objects in memory unnecessarily
    sourceList.length = 0;
    isc._inAddProps--;
    return result;
});


isc._interfaceInstanceProps = {};
isc._interfaceClassProps = {};
isc._getInterfaceProps = function isc__getInterfaceProps(destination) {
    var className = destination.Class,
        props;
    if (isc.isA.ClassObject(destination)) {
        props = isc._interfaceClassProps[className] =
                    isc._interfaceClassProps[className] || [];
    } else if (isc.isAn.InstancePrototype(destination)) {
        props = isc._interfaceInstanceProps[className] =
                    isc._interfaceInstanceProps[className] || [];
    }
    return props;
}

//>    @method ClassFactory.addPropertyList() or isc.addPropertyList()
//
// Add all properties from any number of objects to a destination object.
//
// This differs from addProperties() in that it takes an array as it's second argument,
// applying each object in the array as properties in turn.
//
//    @param    destination            (Object)    object to add properties to
//    @param    sourceList            (Array)        array of objects with properties to add
//  @return                     (Object)    the object after properties have been added to it
//<
isc.addPropertyList = function isc_addPropertyList(destination, sourceList, warnAboutEmptySharedInstanceArrays) {
    // Don't JS error if passed a null destination

    if (destination == null) {
        if (isc.Log) isc.Log.logWarn("Attempt to add properties to a null object. " +
                                     "Creating a new object for the list of properties."

                                     );
        destination = {};
    }

    var methods,
        // detect functions being added as properties.  Doesn't work until after "isA" has
        // initialized
        checkFunctions = (isc.isA != null),
        // don't probe certain objects in Legacy Dev Mode
        sgwtLegacyDevMode = isc.Browser.isSGWTLegacyDevMode,
        // get the registry of string methods on the destination object
        registry = (isc.isAn && isc.isAn.Instance(destination) ?
                    destination.getClass()._stringMethodRegistry :
                    destination._stringMethodRegistry);
    if (registry == null) registry = isc.emptyObject;

    var props = destination._isInterface ? isc._getInterfaceProps(destination) : null;

    var undef;
    for (var i = 0, l = sourceList.length; i < l; i++) {

        // add it's properties to the destination
        var source = sourceList[i];
        // if <code>source</code> is null, skip it.
        if (source == null) continue;

        // copy properties from source to destination
        for (var propName in source) {

            var propValue = source[propName];


            if (sgwtLegacyDevMode) {
                if (propName == isc.gwtRef || propName == isc.gwtModule ||
                    window.SmartGWT.isNativeJavaObject(propValue))
                {
                    destination[propName] = propValue;
                    continue;
                }
            }

            // if any of source's properties are functions
            // or any of the source's properties are registered as stringMethods on the
            //          destination object
            // use addMethods to copy these properties



            var propIsAFunction = checkFunctions && isc.isA.Function(propValue);
            // Check for functions / stringMethods as appropriate.

            if (registry[propName] !== undef || propIsAFunction)
            {
                if (methods == null) methods = {};
                methods[propName] = propValue;

            // don't copy an identical property
            // NOTE: unsafe: a subclass may wish to set a property to the same value as the
            //       default for its superclass, and have the subclass value remain unchanged
            //       if the superclass default is changed.
            //} else if (!(source[property] === destination[property])) {
            } else {
                // property is not a function and this slot is not a StringMethod

                // for Interfaces, keep track of all properties added to them
                if (props != null) props[props.length] = propName;

                // check for clobbering a function with a non-function value, eg setting
                // Canvas.enable:false.
                var destinationProp = destination[propName];
                if (!propIsAFunction && destinationProp != null &&
                    isc.isA.Function(destinationProp) && !isc._allowDeleteFuncProperty)
                {

                    if (isc.Log != null && !isc._suppressNonFunctionMessage) {
                        isc.Log.logWarn("method " + propName + " on " + destination +
                                        " overridden with non-function: '" + propValue + "'");
                    }
                }

                if (propValue != null && propValue._isDynamicProperty && destination.addDynamicProperty) {
                    destination.addDynamicProperty(propName, propValue, true);
                } else {
                    destination[propName] = propValue;
                }

            /*
            } else {

                if (destination.Class && isc.Log &&
                    (!isc.isAn.Instance(destination) ||
                     destination._scPrototype === destination))
                {
                    isc.Log.logWarn("needless override on class: " + destination.Class +
                                    ": " + propName + "->" + propValue);
                }

            */
            }
        }
    }
    if (methods != null) isc.addMethods(destination, methods);
    return destination;
}

//>    @staticMethod isc.addMethods()
//
//    Add all named methods from <code>source</code> to <code>destination</code>
//
//    @see addProperties()
//
//    @param    destination    (Object)    object to add methods to
//    @param    source        (Object)    object to get methods from
//  @return             (Object)    the object after methods have been added to it
//
//<
// NOTE: not externally documented since there is essentially no legitimate reason for author
// code to use this instead of Class.addMethods().

isc._$string = "string";
isc._$function = "function";
isc._$constructor = "constructor";
isc._$object = "object";
isc.addGlobal("addMethods", function isc_addMethods(destination, source) {
    if (!destination || !source) return destination;



    var props = destination._isInterface ? isc._getInterfaceProps(destination) : null;

    if (!isc.__remap) isc.__remap = {};

    for (var name in source) {

        if (props != null) props[props.length] = name;
        var method = source[name];

        // if a method was specified as a string or an action-object, see if the
        // destination defines this as a legal string method.
        // NOTE: check typeof object to support Actions, but check non-null because
        // typeof null == "object" and null specified for a method should wipe it out.
        if (isc.isA.instanceMethodsAdded && method != null &&
            (typeof method == isc._$string || typeof method == isc._$object))
        {
            var registry = (isc.isAn.Instance(destination) ?
                                (destination.getClass != null ?
                                    destination.getClass()._stringMethodRegistry : null) :
                            destination._stringMethodRegistry);
            var undef; // check for undefined rather than null
            if (registry && !(registry[name] === undef) &&

                name != isc._$constructor)
            {
                method = isc.Func.expressionToFunction(registry[name], source[name]);
            }
            // XXX If it's not a function or a stringMethod, assume it's ok to add it using the
            // addMethods logic rather than booting back to addProperties
        }

        // If someone's observing this method, the actual method will be stored under a different
        // name
        var observers = destination._observers,
            finalName = (observers != null && observers[name] != null ? isc._obsPrefix + name : name);

        // If the method is already in the correct slot, we're done.
        if (method !== destination[finalName]) {

            if (method != null) {
                //>DEBUG take the opportunity to label the function with a name for debug
                // purposes.
                this._nameMethod(method, name, destination) //<DEBUG




            }

            destination[finalName] = method;

            if (method != null) {



                // if the method was previously assigned an obfuscated name, make sure the function is
                // available under the obfuscated name in the object it's being mixed into
                if (isc.__remap[name]) {
                    // same check for observation applies here
                    var finalObfName = (destination._observers != null &&
                                        destination._observers[isc.__remap[name]] != null ?
                                        isc._obsPrefix + isc.__remap[name] : isc.__remap[name]);
                    destination[finalObfName] = method;
                }
            }
        //} else {
        //    alert("skipped identical assignment in slot: " + finalName + " of " + method);
        }
    }

    return destination;
});

// Function naming
// ---------------------------------------------------------------------------------------
//>DEBUG _nameMethod: labels a function with a name for debug purposes.



isc._allFuncs = []
isc._allFuncs._maxIndex = 0;
isc._funcClasses = new Array(5000);

isc._nameMethod = function isc__nameMethod(method, name, destination) {

    if (typeof method != isc._$function) return;

    // if not being added to a class, just use the property name as the function name
    if (destination.Class == null) return method._name = name;

    // destination is either:
    // - a class Object (eg isc.ListGrid)
    // - an instancePrototype (isc.ListGrid._instancePrototype)
    // - an instance
    // - a handful of other objects on which we've added the Class property, including isc.isA,
    //   ClassFactory, and native prototypes (eg window.Array)


    // only for instance prototypes and class objects, not for instances
    if (isc.isA != null && isc.isA.instanceMethodsAdded &&
        (isc.isAn.InstancePrototype(destination) || isc.isA.ClassObject(destination)))
    {
        var allFuncs = isc._allFuncs;
        // NOTE: functions installed twice, eg interface methods, will appear twice with
        // different classnames, but the first entry will be the one used, so interface methods
        // retain the interface name even when added to other classes.
        allFuncs[allFuncs._maxIndex] = method;
        isc._funcClasses[allFuncs._maxIndex] = destination.Class;
        allFuncs._maxIndex++;
        return;
    }

    // debug: capture all non-Class/Instance methods (eg isA, String extensions, ClassFactory
    // and other bootstrap)
    //if (isc._otherFuncs == null) isc._otherFuncs = [];
    //isc._otherFuncs[isc._otherFuncs.length] = method;

    // special case isA because isA.Class is a method which detects class objects!
    // We need to use a property other than Class for the className.
    var className = (destination == isc.isA ? "isA" : destination.Class);

    method._className = className;


    if (isc[destination.Class] == null) method._name = name;

    if (isc.isA != null && isc.isA.instanceMethodsAdded && isc.isAn.Instance(destination) &&
        !isc.isAn.InstancePrototype(destination))
    {
        // instance methods need to be labelled with their name since we don't want to store a
        // list of instance IDs for function name lookups (it would grow indefinitely)
        method._name = name;
        // this method is an instance-specific override (using an instance as an anonymous
        // class).  Mark it as such.
        method._instanceSpecific = true;
        // if there's already a method on the destination with the same name,
        // this is also an override (as opposed to just a method that was added)
        if (destination[name] != null) method._isOverride = true;
    }
    // XXX Note: we could use a check like the following to detect and label class
    // methods vs instance methods
    // if (ClassFactroy.getClass(destination.Class) === destination) {
}

//<DEBUG










//> @type Object
// An ordinary JavaScript as obtained by "new Object()" or via
// +link{type:ObjectLiteral,Object Literal} syntax.
// <P>
// Methods that return Objects or take Objects as parameters make use of the ability of a
// JavaScript Object to contain an arbitrary set of named properties, without requiring
// declaration in advance.  This capability makes it possible to use a JavaScript Object much
// like a HashMap in Java or .NET, but without the need to call get() or set() to create and
// retrieve properties.
// <P>
// For example if you created an Object using +link{type:ObjectLiteral,Object Literal} syntax
// like so:
// <pre>
//    var request = {
//        actionURL : "/foo.do",
//        showPrompt:false
//    };
// </pre>
// You could then access it's properties like so:
// <pre>
//    var myActionURL = request.actionURL;
//    var myShowPrompt = request.showPrompt;
// </pre>
// .. and you could assign new values to those properties like so:
// <pre>
//    request.actionURL = "<i>newActionURL</i>";
//    request.showPrompt = <i>newShowPromptSetting</i>;
// </pre>
// Note that while JavaScript allows you to get and set properties in this way on any Object,
// SmartClient components require that if a setter or getter exists, it must be called, or no
// action will occur.  For example, if you had a +link{ListGrid} and you wanted to change the
// +link{listGrid.showHeader,showHeader} property:
// <pre>
//     myListGrid.setShowHeader(false); // correct
//     myListGrid.showHeader = false; // incorrect (nothing happens)
// </pre>
// All documented attributes have +link{group:flags,flags} (eg IRW) that indicate when direct
// property access is allowed or not.
//
// @visibility external
//<


// Utility methods for any JavaScript Object
// ---------------------------------------------------------------------------------------

//>    @staticMethod isc.getKeys()
//
//    Return all keys (property names) of a given object
//
//    @param    object            (Object)    object to get properties from
//    @return                    (Array) String names of all properties.  NOTE: never null
// @visibility external
//<
isc.addGlobal("getKeys", function isc_getKeys(object) {
    var list = [];
    if (object != null) {
        for (var key in object) {
            list[list.length] = key;
        }
    }
    return list;
});

//> @staticMethod isc.firstKey()
// Return the first property name in a given Object, according to for..in iteration order.
//
// @param object (Object) Object to get properties from
// @return (String) first property name, or null if Object has no properties
// @visibility external
//<
isc.addGlobal("firstKey", function isc_firstKey(object) {
    for (var key in object) return key;
});

//>    @staticMethod isc.getValues()
//
//    Return all values of a given object
//
//    @param    object            (Object) object to get properties from
//    @return                    (Array) values of all properties.  NOTE: never null
// @visibility external
//<
isc.addGlobal("getValues", function isc_getValues(object) {
    var list = [];
    if (object != null) {
        for (var key in object) {
            list[list.length] = object[key];
        }
    }
    return list;
});

//> @staticMethod isc.sortObject()
// Given a simple javascript object, return that object sorted by keys, such that when iterating
// through the properties of the object, they will show up in sorted order.<br>
// Usage example - may be used to sort a +link{FormItem.valueMap, formItem valueMap} defined
// as an object.
// @param object (Object) Object to sort
// @param [comparator] (Function) Comparator function to use when sorting the objects keys
// @return (Object) sorted version of the object passed in.
// @visibility external
//<
isc.addGlobal("sortObject", function isc_sortObject(object, sortComparator) {
    if (!isc.isA.Object(object)) return object;
    if (isc.isAn.Array(object)) {
        if (sortComparator != null) return object.sort(sortComparator);
        return object.sort();
    }
    var keys = isc.getKeys(object);
    keys = (sortComparator == null ? keys.sort() : keys.sort(sortComparator));
    var sortedObject = {};
    for (var i = 0; i < keys.length; i++) {
        sortedObject[keys[i]] = object[keys[i]];

    }
    return sortedObject
});

//> @staticMethod isc.sortObjectByProperties()
// Given a simple javascript object, return that object sorted by properties, such that when
// iterating through the properties of the object, values will show up in sorted order.<br>
// Usage example - may be used to sort a +link{FormItem.valueMap, formItem valueMap} defined
// as an object by display value.
// @param object (Object) Object to sort
// @param [comparator] (Function) Comparator function to use when sorting the object properties
// @return (Object) sorted version of the object passed in.
// @visibility external
//<
isc.addGlobal("sortObjectByProperties", function isc_sortObjectByProperties(object, sortComparator) {
    if (!isc.isA.Object(object)) return object;
    if (isc.isAn.Array(object)) {
        if (sortComparator != null) return object.sort(sortComparator);
        return object.sort();
    }
    var values = isc.getValues(object);
    values = (sortComparator == null ? values.sort() : values.sort(sortComparator));
    var sortedObject = {};

    for (var i = 0; i < values.length; i++) {
        var value = values[i];
        for (var key in object) {
            if (object[key] === value) {
                sortedObject[key] = object[key];
                continue;
            }
        }
    }
    return sortedObject
});

//> @staticMethod isc.addDefaults()
//
// Copy any properties that do not already have a value in destination.  Null and zero values
// are not overwritten, but 'undef' values will be.
//
// @param destination (Object) Object to which properties will be added.
// @param source (Object) Object from which properties will be added.
// @return (Object) The destination object is returned.
// @visibility external
//<
isc.addGlobal("addDefaults", function isc_addDefaults(destination, source) {
    if (destination == null) return;
    var undef;
    for (var propName in source) {
        if (destination[propName] === undef) destination[propName] = source[propName];
    }
    return destination;
});


//> @staticMethod isc.addDefaultsRecursively()
//
// Copy any properties that do not already have a value in destination.  Null and zero values
// are not overwritten, but 'undef' values will be.  This function operates recursively,
// applying defaults in a "deep" fashion (ie, we recurse into sub-objects and apply defaults
// at the lowest level, rather than applying the original sub-objects to the target object)
//
// @param destination (Object) Object to which properties will be added.
// @param source (Object) Object from which properties will be added.
// @return (Object) The destination object is returned.
// @visibility internal for now
//<
isc.addGlobal("addDefaultsRecursively", function isc_addDefaultsRecursively(destination, source, dupList) {
    if (destination == null) return destination;
    if (source == null || isc.isAn.emptyObject(source)) return destination;

    var undef;

    if (isc.isAn.Array(source)) {
        if (!isc.isAn.Array(destination)) {
            isc.logWarn("Error during addDefaultsRecursively: source is an array but destination " +
                        "is not.  Cannot continue");
            return;
        }
        for (var i = 0; i < source.length; i++) {
            var entry = source[i];
            if (isc.isA.Function(entry)) continue;
            if (isc.isAn.Instance(entry) || isc.isA.Class(entry)) continue;

            if (entry == null || isc.isA.String(entry) || isc.isA.Boolean(entry) ||
                isc.isA.Number(entry))
            {
                if (destination[i] === undef) destination[i] = entry;
            } else if (isc.isA.Date(entry)) {
                if (destination[i] === undef) destination[i] = new Date(entry.getTime());
            } else if (isc.isAn.Object(entry)) {
                if (destination[i] === undef) destination[i] = {};
                if (!isc.isAn.Object(destination[i])) {
                    isc.logWarn("Error during addDefaultsRecursively: entry number " + i +
                                " in the source array is an object, but the existing entry " +
                                i + " in the destination is not an object.  Skipping");
                    continue;
                }
                destination[i] = isc.addDefaultsRecursively(destination[i], entry, dupList);
            }
        }
        return destination;
    }

    var propertiesToSkip = {
        __ref: true,
        __module: true
    };

    if (!dupList) dupList = [];
    if (dupList.contains(source)) {
        destination = source;
        return destination;
    }
    dupList.add(source);

    for (var prop in source) {
        if (isc.isA.Function(source[prop])) continue;
        if (propertiesToSkip[prop] == true) continue;
        if (isc.isAn.Instance(source[prop]) || isc.isA.Class(source[prop])) continue;

        var propValue = source[prop];
        if (isc.isA.Date(propValue)) {
            if (destination[prop] === undef) {
                destination[prop] = propValue.duplicate();
            }
        } else if (isc.isAn.Array(propValue)) {
            if (destination[prop] === undef) destination[prop] = [];
            if (!isc.isAn.Array(destination[prop])) {
                isc.logWarn("Error during addDefaultsRecursively: source property '" +
                            prop + "' is an array, but the target object has an existing " +
                            "property of the same name that is not an array.  Skipping");
                continue;
            }
            if (dupList.contains(propValue)) {
                destination[prop] = propValue;
                continue;
            }
            dupList.add(propValue);
            isc.addDefaultsRecursively(destination[prop], propValue, dupList);
        } else if (isc.isAn.Object(propValue)) {
            if (dupList.contains(propValue)) {
                destination[prop] = propValue;
                continue;
            }
            if (destination[prop] === undef) destination[prop] = {};
            if (!isc.isAn.Object(destination[prop])) {
                isc.logWarn("Error during addDefaultsRecursively: source property '" +
                            prop + "' is a sub-object, but the target object has an existing " +
                            "property of the same name that is not an object.  Skipping");
                continue;
            }
            isc.addDefaultsRecursively(destination[prop], propValue, dupList);
        } else {
            if (destination[prop] === undef) destination[prop] = source[prop];
        }

    }
    return destination;
});


//>    @staticMethod isc.propertyDefined()
//
//    Is some property specified on the object passed in?  This will return true if
//  <code>object[propertyName]</code> has ever been set to any value, and not deleted.<br>
//  May return true even if <code>object[propertyName] === undefined</code> if the property
//  is present on the object and has been explicitly set to undefined.
//
// @param object (Object) Object to test
// @param propertyName (String) Which property is being tested for?
// @return (boolean) true if property is defined
//  @visibility external
//<
isc.addGlobal("propertyDefined", function isc_propertyDefined(object, propertyName) {
    if (object == null) return false;

    var undef;
    if (object[propertyName] !== undef) return true;


    var properties = isc.getKeys(object);
    return (properties.contains(propertyName));
});

isc.addGlobal("objectsAreEqual", function isc_objectsAreEqual(object1, object2) {
    // match -> return true

    if (object1 === object2) return true;

    else if (isc.isAn.Object(object1) && isc.isAn.Object(object2)) {
        if (isc.isA.Date(object1)) {
            return isc.isA.Date(object2) && (isc.DateUtil.compareDates(object1,object2) == 0);
        } else if (isc.isAn.Array(object1)) {
            if (isc.isAn.Array(object2) && object1.length == object2.length) {
                for (var i = 0; i < object1.length; i++) {
                    if (!isc.objectsAreEqual(object1[i], object2[i])) return false;
                }
                return true;
            }
            return false;
        } else {
            if (isc.isAn.Array(object2)) return false;
            var numProps = 0;
            for (var prop in object1) {
                if (prop == isc.gwtRef || prop == isc.gwtModule) continue;
                if (!isc.objectsAreEqual(object1[prop],object2[prop])) return false;
                numProps ++;
            }
            var numProps2 = 0;
            for (var prop2 in object2) {
                if (prop == isc.gwtRef || prop == isc.gwtModule) continue;
                numProps2++;
                if (numProps2 > numProps) return false;
            }
            if (numProps2 != numProps) return false;

            return true;
        }
    } else {
        return false;
    }
});


// combineObject() - like addProperties() except it handles nested object data structures
// so if an attribute of the source is an object, properties from that object will be
// combined across to the destination, rather than simply clobbering the previous attribute value
// for the field.
// Note the goal here isn't to avoid the destination pointing to the same objects as the source
// (like a duplicate), it's just to merge field values in for nested objects
isc.addGlobal("combineObjects", function isc_combineObjects(destination, source) {
    if (destination == null || !isc.isAn.Object(destination)) return source;
    if (source == null || !isc.isAn.Object(source)) return destination;

    for (var prop in source) {
        var destProp = destination[prop],
            sourceProp = source[prop];
        // If both the source and destination contain simple objects, iterate through the
        // attributes on the source property object and copy them across to the destination property
        // object
        if (isc.isAn.Object(destProp) && !isc.isAn.Array(destProp) && !isc.isA.Date(destProp)
            && isc.isAn.Object(sourceProp) && !isc.isAn.Array(sourceProp) &&
            !isc.isA.Date(sourceProp))
        {
            isc.combineObjects(destProp, sourceProp);
        // Otherwise we can just copy the value across as with standard addProperties
        } else {
            destination[prop] = sourceProp;
        }

    }
    return destination;
});


//> @staticMethod isc.applyMask()
// Create a copy of an Object or Array of Objects that has been trimmed to a specified set of
// properties.
// <p>
// <code>mask</code> is the list of properties to return.  Can be an array of strings or an object.
// If an object, the properties returned will be those that are present in the object.  NOTE: this
// includes properties that exist because they've been explicitly set to null.
// <p>
// If no mask is specified, returns a duplicate of the input
// If no inputs are specified, returns an empty object.
//
// @param input   (Object | Array)   object to be masked
// @param mask    (Object | Array)   set of properties to limit output to
//
//<
// NOTE: not external because behavior is a little odd:
// - returns non-null for null input
// - if mask is null and provided an Array, returns an Object instead of a dup'd Array
// we need to check out the framework uses of applyMask and makes sure changing the behavior is
// OK
//
// XXX if applyMask with the input as an empty Array, you will get an empty Array as output.
// So applyMask cannot be used to filter properties that exist on an Array instance.
isc.applyMask = function isc_applyMask(input, mask) {
    var output = {};

    // if no input passed in, return empty output
    if (input == null) return output;

    // if no mask passed in, return all fields from input
    if (mask == null) {
        return isc.addProperties(output, input);
    }

    var inputWasSingle = false;
    if (!isc.isAn.Array(input)) {
        inputWasSingle = true;
        input = [input];
    }

    // convert the mask to an Array of property names if it's an object
    if (!isc.isAn.Array(mask)) mask = isc.getKeys(mask);

    var output = [],
        inputObj, outputObj,
        key, undef;
    for (var i = 0; i < input.length; i++) {
        inputObj = input[i];
        outputObj = output[i] = {};
        // return only the specified properties
        for (var j = 0; j < mask.length; j++) {
            key = mask[j];
            if (inputObj[key] === undef) continue;
            outputObj[key] = inputObj[key];
        }
    }
    return (inputWasSingle ? output[0] : output);
}

isc.getProperties = function isc_getProperties(input, propertyList, output) {
    if (input == null) return null;

    output = output || {};
    if (propertyList == null) return output;
    for (var i = 0; i < propertyList.length; i++) {
        var propName = propertyList[i];
        output[propName] = input[propName];
    }
    return output;
}

isc._digits = {};
isc._floor = Math.floor;
isc._$minus = "-";

for (isc._iterator = 0; isc._iterator < 10; isc._iterator++)
    isc._digits[isc._iterator] = isc._iterator.toString();

isc._fillNumber = function isc__fillNumber(template, number, startSlot, numSlots, nullRemainingSlots) {



    var lastSlot = startSlot + numSlots - 1,
        origNumber = number,
        didntFit = false,
        negative;

    if (number < 0) {
        negative = true;
        number = -number;
        template[startSlot] = this._$minus;
        startSlot += 1;
        numSlots -= 1;
    }

    while (number > 9) {
        // reduce by 10x, round off last digit and subtract to find what it was
        var newNumber = this._floor(number/10),
            lastDigit = number - (newNumber*10);
        // fill slots last first
        template[lastSlot] = this._digits[lastDigit];
        number = newNumber;

        if (lastSlot == (startSlot+1) && number > 9) {
            // number to large for allocated number of slots
            isc.Log.logWarn("fillNumber: number too large: " + origNumber +
                            isc.Log.getStackTrace());
            didntFit = true;
            break;
        }
        lastSlot -= 1;
    }

    if (didntFit) {

        lastSlot = startSlot + numSlots - 1
        template[lastSlot--] = (!negative ? origNumber : -origNumber);
    } else {
        template[lastSlot--] = this._digits[number];
    }

    // null out remaining slots
    for (var i = lastSlot; i >= startSlot; i--) {
        template[i] = null;
    }
};
if (!isc.Browser.isIE || isc.Browser.version > 7) {

    isc._fillNumber = function isc__fillNumber(template, number, startSlot, numSlots, nullRemainingSlots) {
        template[startSlot] = number;
        if (nullRemainingSlots) {
            var endI = startSlot + numSlots;
            for (var i = startSlot + 1; i < endI; ++i) {
                template[i] = null;
            }
        }
    };
}

//> @object Boolean
// Boolean object.  Attributes, parameters, or return values declared as <code>Boolean</code>
// may be null.  Contrast with +link{type:boolean}.
// @treeLocation Client Reference/System
// @visibility external
//<


//> @type boolean
// A Boolean which is either true or false.  May not be null.
// @baseType Boolean
// @treeLocation Client Reference/System
// @visibility external
//<

// try to interpolate different types as a boolean
//
// returns default if value is undefined or null
// returns false if value is
//   - the string "false" or "FALSE"
//   - the number 0
//   - the boolean value false
// otherwise returns true
isc.booleanValue = function isc_booleanValue(value, def) {
    // if the value is unset, return the specified default (so,
    if (value == null) return def;

    if (isc.isA.String(value)) return value != isc._false && value != isc._falseUC;
    return value ? true : false;
}

// isc.objectToLocaleString()
// Centralized, customizable toLocaleString() formatter for objects.
isc.iscToLocaleString = function isc_iscToLocaleString(object) {
    if (object != null) {
        return object.iscToLocaleString ? object.iscToLocaleString() :
                    (object.toLocaleString ? object.toLocaleString() :
                        (object.toString ? object.toString() : isc.emptyString + object));
    }
    return isc.emptyString + object;
}

isc.documentCurrentScriptCapable = document.currentScript != null;
isc.getCurrentScriptSrc = function () {
    if (document.currentScript != null) {
        return document.currentScript.src;
    } else if (isc.documentCurrentScriptCapable) {
        // without this check, a call to this API after script execution (e.g. via eval()) would
        // be indistinguishable from an older browser and would fall through to the logic below
        // which would inevitably return something like "anonymous", but generally, on modern
        // browsers, we would like to be able to distinguish this case (from a possible eval
        // stack mis-detection value)
        return null;
    } else {
        var error = new Error(),
            stack = error.stack
        ;

        if (stack == null) try {
            throw error;
        } catch (error) {
            stack = error.stack
        }

        if (stack != null) {


            var atText = stack.indexOf(" at ") >= 0 ? " at " : "@";
            var lastAtPos = stack.lastIndexOf(atText);
            if (lastAtPos >= 0) {
                var src = stack.substring(lastAtPos + atText.length);

                // remove outermost parentheses (required for IE10+)
                src = src.replace(/^[^(]*\((.*)\)[^)]*$/, "$1");

                // Remove the trailing lineno/colno.
                var re = new RegExp(":\\d+\\s*$");
                var result = re.exec(src);
                if (result) {
                    src = src.substring(0, result.index);
                    result = re.exec(src);
                    if (result) {
                        src = src.substring(0, result.index);
                    }
                }

                return src;
            }

        // IE9 and below will enter this section

        } else if (document.documentMode >= 8) {
            var oldOnerrorHandler = window.onerror;
            window.onerror = function (message, url, lineno) {
                return url;
                // window.onerror = oldOnerrorHandler;
                // return true;
            };

            window.noSuchMethod();
        } else {
            var scriptElems = document.getElementsByTagName("script");
            var lastScriptElem = scriptElems[scriptElems.length - 1];
            return lastScriptElem.src;
        }
    }
}











//>    @object    isA
//
//    A library of functions for determining the types of other objects.<br><br>
//
//  The "isA" methods for the basic JavaScript types are much faster and more consistent across
//  platforms than JavaScript's "typeof" operator.<br><br>
//
//  An isA method is automatically created for every ISC Class and Interface definition, for
//  example, isA.Canvas().<br><br>
//
//    @example    <code>if (isA.Number(myVariable)) ...</code>
//
//    Note: <code>is</code> and <code>isAn</code> are synonyms of <code>isA</code> and can be used
//            interchangably when it looks better syntactically, eg:
//                <code>if (myObject == null) ...</code>
//            or
//                <code>if (isAn.Array(myObject)) ...</code>
// @treeLocation Client Reference/System
// @visibility external
//<
// create the "isA", "isAn" and "is" objects
isc.addGlobal("isA", {});
isc.addGlobal("isAn", isc.isA);
isc.addGlobal("is", isc.isA);

  //>DEBUG
// give it a class name so that methods added to it get labelled
isc.isA.Class = "isA";
  //<DEBUG

isc.isA.isc = isc.isA; // so you can do isc.isA.isc.Canvas(object)


Function.__nativeType = 1;
Array.__nativeType = 2;
Date.__nativeType = 3;
String.__nativeType = 4;
Number.__nativeType = 5;
Boolean.__nativeType = 6;
RegExp.__nativeType = 7;
Object.__nativeType = 8;



Function.prototype.__nativeType = 1;


// add methods to determine the type of various simple objects
isc.addMethods(isc.isA, {
    useTypeOf : isc.Browser.isMoz || isc.Browser.isSafari,

    //> @staticMethod isA.emptyString()
    //
    //    Is <code>object</code> the empty string?<br><br>
    //
    //    NOTE: if you prefer, you can call this as <code>isAn.emptyString()</code>
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a null string
    //    @visibility external
    //<
    emptyString : function (object) {return isc.isA.String(object) && object == isc.emptyString},


    //> @staticMethod isA.nonemptyString()
    //
    //    Is <code>object</code> a non-empty String?<br><br>
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a non-empty string
    //    @visibility external
    //<
    nonemptyString : function (object) {return isc.isA.String(object) && object != isc.emptyString},


    //> @staticMethod isA.Object()
    // Returns whether the passed value is a non-null Object.
    // <p>
    // Returns false for values that are Numbers, Strings, Booleans, Functions or are null or
    // undefined.
    // <p>
    // Returns true for Object, Array, Regular Expression, Date and other kinds of
    // native objects which are considered to extend from window.Object.
    //
    // @param object (Any) value to test for whether it's an object
    // @return (boolean) whether passed value is an Object
    // @visibility external
    //<
    //  With the exception of returning false for the null value, this function's return value
    //  matches the ECMA spec for the typeof operator.  It also seems to be a reasonable expected
    //  implementation of this method as it guarantees the programmer can work with properties of
    //  the object as with a standard Object returned by "new Object()".
    _$object:"object",
    _$String :"String",
    Object : function (object) {
        if (object == null) return false;


        if (isc.Browser.isIE && typeof object == this._$function) return false;


        if (this.useTypeOf) {
            var objType = typeof object;
            return (objType == "object" || objType == "array" || objType == "date" ||

                    (isc.Browser.isMoz && objType == "function" && isc.isA.RegularExpression(object)));
        }

        if (object.constructor && object.constructor.__nativeType != null) {
            var type = object.constructor.__nativeType;
            if (type == 1) {

            } else {
                // Object, RegExp, Date, Array
                return (type == 8 || type == 7 || type == 3 || type == 2);
            }
        }

        // Workaround for a core GWT bug, fixed as of GWT 2.5.
        // http://code.google.com/p/google-web-toolkit/issues/detail?id=4301
        if (object.Class != null && object.Class == this._$String) return false;


        if (typeof object == this._$object) {
            if (isc.Browser.isIE && isc.isA.Function(object)) return false;
            else return true;
        } else return false;
    },

    //> @staticMethod isA.emptyObject()
    //
    // Is <code>object</code> an object with no properties (i.e.: <code>{}</code>)?
    // <P>
    // Note that an object that has properties with null values is considered non-empty, eg
    // <code>{ propName:null }</code> is non-empty.
    // <P>
    // NOTE: if you prefer, you can call this as <code>isAn.emptyObject()</code>
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is the empty object
    //    @visibility external
    //<
    emptyObject : function (object) {
        if (!isc.isAn.Object(object)) return false;
        for (var i in object) {
            // if we have a single property we're non-empty!
            return false;
        }
        return true;
    },

    //> @staticMethod isA.emptyArray()
    //
    // Is <code>object</code> an Array with no items?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is an empty array
    //    @visibility external
    //<
    emptyArray : function (object) {
        return isc.isAn.Array(object) && object.length == 0;
    },

    //> @staticMethod isA.String()
    //
    //    Is <code>object</code> a String object?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a String
    //    @visibility external
    //<
    // ==========================================================================================
    // IMPORTANT: If you update this function, also update its copy in FileLoader.js
    // ==========================================================================================
    String : function (object) {
        if (object == null) return false;


        if (this.useTypeOf) {
            return typeof object == "string" ||
                (object.Class != null && object.Class == this._$String);
        }


        //if (typeof object == this._$function) return false;
        if (object.constructor && object.constructor.__nativeType != null) {
            return object.constructor.__nativeType == 4;
        }

        // Workaround for a core GWT bug
        // http://code.google.com/p/google-web-toolkit/issues/detail?id=4301
        if (object.Class != null && object.Class == this._$String) return true;

        return typeof object == "string";
    },

    //> @staticMethod isA.Array()
    //
    //    Is <code>object</code> an Array object?<br><br>
    //
    //    NOTE: if you prefer, you can call this as <code>isAn.Array()</code>
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is an Array
    //    @visibility external
    //<
    Array : function (object) {
        if (object == null) return false;


        if (this.useTypeOf && typeof object == "array") return true;


        if (typeof object == this._$function) return false;
        if (object.constructor && object.constructor.__nativeType != null) {
            return object.constructor.__nativeType == 2;
        }



        if (isc.Browser.isSafari) {
            var spliceString = "" + object.splice;
            return (spliceString ==  "function splice() {\n    [native code]\n}" ||
                    spliceString == "(Internal function)");
        }
        return ""+object.constructor == ""+Array;
    },

    //> @staticMethod isA.Function()
    //
    //    Is <code>object</code> a Function object?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Function
    //    @visibility external
    //<
    _$function : "function",
    Function : function (object) {
        if (object == null) return false;


        if (isc.Browser.isIE && typeof object == this._$function) return true;

        if (isc.Browser.isIE10) return false;

        // In IE9, attempting to access the "constructor" attribute of a window
        // can lead to an odd crash. If we're passed a native window, return false immediately.

        if (isc.Browser.isIE && (
                (object == window) ||
                (object.document != null && (object.toString != null) &&
                    object.toString().contains("Window") )
            )
           )
        {
            return false;
        }

        var cons = object.constructor;
        if (cons && cons.__nativeType != null) {
            // eliminate known non-functions from an ISC frame
            if (cons.__nativeType != 1) return false;
            // eliminate functions from this frame
            if (cons === Function) return true;

        }


        //if (!object.constructor) isc.Log.logWarn("obj without cons: " + isc.Log.echo(object));
//        isc.logWarn("obj:" + object + "cons:" + isc.emptyString + object.constructor);
        return isc.Browser.isIE ? (isc.emptyString+object.constructor == Function.toString()) :
                                  (typeof object == this._$function);
    },

    //> @staticMethod isA.Number()
    //
    //    Is <code>object</code> a Number object?<br><br>
    //
    //    NOTE: this returns false if <code>object</code> is an invalid number (<code>isNaN(object) == true</code>)
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Number
    //    @visibility external
    //<
    Number : function (object) {
        if (object == null) return false;


        if (this.useTypeOf && typeof object == "number") {
            // it's a number, now check if it's a valid number
            return !isNaN(object) &&
                object != Number.POSITIVE_INFINITY &&
                object != Number.NEGATIVE_INFINITY;
        }

        if (object.constructor && object.constructor.__nativeType != null) {
            if (object.constructor.__nativeType != 5) return false;
        } else {
            if (typeof object != "number") return false;
        }
        // it's a number, now check if it's a valid number
        return !isNaN(object) &&
            object != Number.POSITIVE_INFINITY &&
            object != Number.NEGATIVE_INFINITY;
    },

    SpecialNumber : function (object) {
        // NOTE: we do need to first determine if it's a number because isNaN({}) is true
        if (object == null) return false;
        if (object.constructor && object.constructor.__nativeType != null) {
            if (object.constructor.__nativeType != 5) return false;
        } else {
            if (typeof object != "number") return false;
        }
        return (isNaN(object) || object == Number.POSITIVE_INFINITY ||
                object == Number.NEGATIVE_INFINITY);
    },

    //> @staticMethod isA.Boolean()
    //
    //    Is <code>object</code> a Boolean object?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Boolean
    //    @visibility external
    //<
    Boolean    : function (object) {
        if (object == null) return false;
        if (object.constructor && object.constructor.__nativeType != null) {
            return object.constructor.__nativeType == 6;
        }
        return typeof object == "boolean";
    },

    //> @staticMethod isA.Date()
    //
    //    Is <code>object</code> a Date object?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Date
    //    @visibility external
    //<
    Date : function (object, validate) {
        if (object == null) return false;
        // if the Date constructor is passed a string it doesn't understand, it returns a
        // sort of pseudo date object, which returns bad values from getYear(), etc.
        if (validate && !(object.getDate && isc.isA.Number(object.getDate()))) return false;
        // common case - use the constructor's __nativeType property to make a decision
        if (object.constructor && object.constructor.__nativeType != null) {
            return object.constructor.__nativeType == 3;
        }

        if (isc.Browser.isSGWT && window.SmartGWT.isNativeJavaObject(object)) return false;
        // if we're performing this test in another window / frame, Date's __nativeType won't
        // have beeen set, so compare the constructor of the object, and set it if appropriate.
        if (("" + object.constructor) == ("" + Date)) {
            object.constructor.__nativeType = 3;
            return true;
        }
        return false;
    },

    //> @staticMethod isA.RegularExpression()
    //
    //    Is <code>object</code> a Regular Expression (RegExp) object?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Boolean
    //    @visibility external
    //<
    RegularExpression : function (object) {
        if (object == null) return false;
        // common case - use the constructor's __nativeType property to make a decision
        if (object.constructor && object.constructor.__nativeType != null) {
            return object.constructor.__nativeType == 7;
        }
        // check for a "real" Java Object in SGWT to avoid GWT bug - see Date() above
        if (isc.Browser.isSGWT && window.SmartGWT.isNativeJavaObject(object)) return false;
        // if we're performing this test in another window / frame, RegExp's __nativeType won't
        // have beeen set, so compare the constructor of the object, and set it if appropriate.
        if (("" + object.constructor) == ("" + RegExp)) {
            object.constructor.__nativeType = 7;
            return true;
        }
        return false;
    },


    _$textXML : "text/xml",
    XMLNode : function (object) {
        if (object == null) return false;
        if (isc.Browser.isIE) {
            return object.specified != null && object.parsed != null &&
                   object.nodeType != null && object.hasChildNodes != null;
        }
        var doc = object.ownerDocument;
        if (doc == null) return false;
        return doc.contentType == this._$textXML;
    },


    // ---------------------------------------------------------------------------------------
    // NOTE: the following few functions are used strictly in expressionToFunction(), are not
    // i18n-safe, and should not be externally visible
    // ---------------------------------------------------------------------------------------

     //> @staticMethod isA.AlphaChar()
     //
     //  Is the character passed in an alpha character?
     //
     //  @param  char    (String)        character to test
     //  @return                 (boolean)       true == character is alpha
     //<
     AlphaChar : function (character) {
         // XXX: does not yet deal with unicode characters or extended ASCII characters.
         var code = character.charCodeAt(0);
         return ((code >= 65 &&
                  code <= 90) ||
                 (code >= 97 &&
                  code <= 122))
     },

     //> @staticMethod isA.NumChar()
     //
     //  Is the character passed in a Decimal (0-9) character?
     //
     //  @param  char    (String)        character to test
     //  @return                 (boolean)       true == character is a decimal character
     //<
     NumChar : function (character) {
         // XXX: does not yet deal with unicode characters
         var code = character.charCodeAt(0)
         return (code >= 48 &&
                 code <= 57)
     },

     //> @staticMethod isA.AlphaNumericChar()
     //
     //  Is the character passed in alphanumeric?
     //
     //  @param  char    (String)        character to test
     //  @return                 (boolean)       true == character is alphanumeric
     //<
     AlphaNumericChar : function (character) {
        return (isc.isA.AlphaChar(character) || isc.isA.NumChar(character))
    },

     //> @staticMethod isA.WhitespaceChar()
     //
     //  Is the character passed in a whitespace character?
     //  This method considers any ascii character from 0-32 to be a whitespace character.
     //
     //  @param  char    (String)        character to test
     //  @return                 (boolean)       true == character is a whitespace character
     //<
     WhitespaceChar : function (character) {
         // XXX: does not yet deal with unicode characters
         var code = character.charCodeAt(0)
         return (code >= 0 &&
                code <= 32)
     },

    //> @staticMethod isA.color
    //  Is this a valid css color.  Used by the isColor() validator
    //<

    color : function (object) {
        if (!isc.isA.String(object)) return false;

        if (!this._cssColorRegexp) {
            this._cssColorRegexp = new RegExp(
                            // hex:         "#D3D3D3", etc
                            "^(#([\\dA-F]{2}){3}|" +
                            "#([\\dA-F]{2}){4}|" +
                            // rgb:         "rgb(255,255,255)", etc.

                                "rgb\\((\\s*[\\d]{1,3}\\s*,\\s*){2}\\s*[\\d]{1,3}\\s*\\)" +
                            // colorname:   "white", "black", "pink", etc.

                                ")$",

                            // Case insensitive
                            "i"
            );
        }


        var result = this._cssColorRegexp.test(object);
        if (!result) {
            if (object == "transparent" || isc.ColorUtils.colorNames[object]) {
                // support 'transparent' and standard color-names
                result = true;
            }
        }
        return result;
    },

    // Module Dependencies:
    // ResultSet / ResultTree are both defined as part of the Databinding module but are frequently
    // checked for within grids.
    // Implement default isA functions for these classes so we can check isc.isA.ResultSet() without
    // needing an explicit check for the function being present
    ResultSet : function (data) {
        return false;
    },
    ResultTree : function (data) {
        return false;
    },

    // Overridding isA.className methods:
    // We provide custom isc.isA implementations for the following class names which we don't
    // want to be clobberred when the class method is defined

    _customClassIsA:{
        SelectItem:true,
        Time:true
    },

    // SelectItem IsA Overrides
    // ---------------------------------------------------------------------------------------

    // isc.isA.SelectItem() default implementation would come from the definition of the
    // selectItem class.
    // However we want this method to return true for NativeSelectItems (not a subclass of
    // SelectItem).
    SelectItem : function (object) {
        if(object==null||object.isA==null||
            object.ns==null||object.ns.isA==null||object.isA===object.ns.isA){
            return false;
        }
        return object.isA("SelectItem") || object.isA("NativeSelectItem");
    },

    // Support 'isA.SelectOtherItem()' to test for SelectItems or NativeSelectItems where
    // isSelectOther is true.
    SelectOtherItem : function (item) {
        return isc.isA.SelectItem(item) && item.isSelectOther == true;
    },

    // SmartClient stores Times in JavaScript Date objects so make isA.Time a synonym for isA.Date
    Time : function (object) {
        return isc.isA.Date(object);
    }

});

if (Array.isArray) {
    isc.addMethods(isc.isA, {

        Array : Array.isArray
    });
}


//    @end @object isA






//>    @object    ClassFactory
//
//    Sets up a real inheritance structure for Javascript objects.
//    We separate out class objects from prototypes, so each gets its own inheritance chain.
//    This allows us to set up superclass calls, maintain class vs. instance variables and more!
//
//    The ClassFactory is a singleton object that holds the miscellaneous pieces of our inheritance
//    mechanism.
//
//    Your main interaction with the ClassFactory is to create new classes:
//        <code>ClassFactory.defineClass("MyClass", "mySuperClass");</code>
//
//    @see class:Class
//
//    @visibility external
// @treeLocation Client Reference/System
//<

//
//    create the ClassFactory singleton object
//
//
isc.addGlobal("ClassFactory", {});

  //>DEBUG
// give it a class name so that methods added to it get labelled
isc.ClassFactory.Class = "ClassFactory";
  //<DEBUG

// ClassFactory defines the notion of an "Instance", "ClassObject" and an "Interface".  Add methods
// to isA for recognizing these objects.
isc.addMethods(isc.isA, {
    //> @staticMethod isA.Instance()
    //
    //    Is <code>object</code> an instance of some class?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is an instance of some class
    //    @visibility external
    //<
    Instance : function (object) {    return (object != null && object._scPrototype != null)},

    //> @staticMethod isA.ClassObject()
    //
    //    Is <code>object</code> a class object?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Class Object
    //    @visibility external
    //<
    ClassObject : function (object) {    return (object != null && object._isClassObject == true)},

    //> @staticMethod isA.Interface()
    //
    //    Is <code>object</code> an interface object?
    //
    //    @param    object    (Object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Interface Object
    //    @visibility external
    //<
    Interface : function (object) {    return (object != null && object._isInterface == true)},

    InstancePrototype : function (object) {
        return (isc.isAn.Instance(object) && object._scPrototype == object)
    }
});


isc.isA.instanceMethodsAdded = true;

//
// add methods to the ClassFactory
//
isc.addMethods(isc.ClassFactory, {
    //>    @classMethod    ClassFactory.defineClass()
    //
    // Create a new SmartClient class, which can then be used to create instances of this
    // object type, via +link{Class.create()}.
    // <P>
    // The new Class is returned by <code>defineClass</code>, is available as
    // <code>isc.<i>ClassName</i></code> and is also available in global scope if not in
    // +link{class:isc,portal mode}.  Typically, +link{classMethod:class.addProperties()} is then
    // called to establish different defaults in the new class, or to add methods.  For
    // example:
    // <pre>
    //    isc.defineClass("MyListGrid", "ListGrid").addProperties({
    //        headerHeight : 40, // change default for listGrid.headerHeight
    //
    //        // override listGrid.recordClick
    //        recordClick : function (viewer, record) {
    //           isc.say(record.description);
    //        }
    //    })
    //    isc.MyListGrid.create(); // create an instance of the new class
    // </pre>
    // <P>
    // See also +link{class.Super,Super()} for calling superclass methods.
    // <P>
    // NOTE: <code>isc.defineClass()</code> also creates a new function
    // <code>+link{isA,class:isA}.<i>ClassName()</i></code> object for identifying instances of
    // this Class.
    //
    //    @param    className        (String)    Name for the new class.
    //    @param    [superClass]    (Class)        Optional SuperClass Class object or name
    //    @return                    (Class)        Returns the new Class object.
    //
    //    @visibility external
    //<
    // Internal notes:
    //  Every ClassObject has:
    //  {
    //     Class : [string className],
    //     _isClassObject : true,
    //     _instancePrototype : [instance prototype for class],
    //
    //     _superClass : [pointer to superClass ClassObject (if this class is not a root class)]
    //
    //     _subClassConstructor : [constructor function that creates subclass ClassObjects]
    //  }
    //
    //  Every InstancePrototype (and Instance) has:
    //  {
    //     Class : [string className]
    //     _instanceConstructor : [constructor function that creates instances]
    //     _classObject : [ClassObject for this class]
    //    ._scPrototype : [the instance prototype (this same object)]
    //  }
    defineClass : function (className, superClass, interfaces, suppressSimpleNames) {
        return this._defineNonRootClass(className, superClass, interfaces, null, suppressSimpleNames);
    },

    //>    @classMethod    ClassFactory.overwriteClass()
    //
    // Intentionally clobber an existing SmartClient Class, if it already exists.  Works
    // identically to +link{ClassFactory.defineClass}, except that no warning is logged to the
    // console.
    //
    // @visibility external
    //<
    overwriteClass : function (className, superClass, interfaces, suppressSimpleNames) {
        return this._defineNonRootClass(className, superClass, interfaces, null, suppressSimpleNames, true);
    },

    //>    @classMethod    ClassFactory.defineInterface()
    //
    //    An "Interface" is an API definition plus a skeletal implementation of that API.
    //
    //  Interfaces are "mixed in" to another class in order to allow the target class to "support"
    //  the interface.  Interfaces typically require the target class to provide one or two core
    //  methods, and then the interface itself provides the many convenience methods and method
    //  variations that can be written in terms of the core methods.
    //
    //  For example, a List interface could require only get(index) and getLength() from the target
    //  class, and could provide getRange(), indexOf() and other standard List operations.  If the
    //  target class has a more efficient way of supporting getRange() than the generic
    //  implementation in the List interface, the target class can directly implement getRange(),
    //  and the target class' version of getRange() takes precedence.
    //
    //  Comparison to other languages:
    //  - in Java, an "interface" is just an API definition, with no implementation.  The SmartClient
    //    notion of interfaces is closer to an "abstract class", except that in Java you can only
    //    inherit from one abstract class, whereas in SmartClient you can mixin as many Interfaces
    //    as you want.  Also, in SmartClient an Interface can contain both instance and class (aka
    //    "static") methods.
    //  - in Ruby, a Mix-in module corresponds exactly to the SmartClient Interface concept.
    //
    //  Writing Interfaces:
    //  - If you are writing an interface and want to indicate that a method must be implemented in
    //      the target class in order for your interface to work, use addMethods to add a method with
    //      the special value ClassFactory.TARGET_IMPLEMENTS.  If the target class does not
    //      implement the method and it gets called, an error will be logged.
    //  - you can subclass an interface to create another interface, but you can't use Super to
    //      call superclass methods within the interface inheritance chain
    //  - you can define a special initInterface method and it will be called just prior to the
    //    init method on the class that the interface is mixed into
    //  - you can define a special destroyInterface method and it will be called by the destroy
    //    method on the class that the interface is mixed into.  Note that unlike other
    //    languages, javascript does not have a concept of a destructor.  You have to
    //    explicitly call destroy() in order for this logic to run.  But in many cases you
    //    don't have to worry about this because Canvas subclasses cascade the destroy() call
    //    automatically to all children/members/etc.
    //    - if you declare a method in an interface, and mix the interface into a class, you can't
    //      call Super() and get the interface method -- the one you place in your instance will
    //      override the one from the interface.
    //
    //      To make this work, you have to create an intermediate class, then subclass that.  Eg:
    //
    //        CF.defineInterface("face1");
    //        face1.addMethods({ foo:function() {} });
    //
    //        CF.defineClass("class1");
    //        CF.mixInInterface("class1", "face1");
    //
    //        class1.addMethods({
    //            foo : function () {
    //                // NOTE: a Super() call here will NOT go to the face1.foo method
    //            }
    //        })
    //
    //        CF.defineClass("class2", "class1");
    //        class2.addMethods({
    //            foo : function () {
    //                // NOTE: a Super() call WOULD go to the face1.foo method
    //                //             (assuming class1.foo was not present)
    //            }
    //        })
    //
    //<
    defineInterface : function (className, superClass) {
        return this._defineNonRootClass(className, superClass, null, true);
    },

    //>    @classMethod    ClassFactory.defineRootClass()
    //
    //     Variant of defineClass for creating a root class (a class with no superclass).
    //
    //    @param    className        (String)    Name for the new class
    //<
    defineRootClass : function (className) {
        return this._defineClass(className, null);
    },

    //>    @classMethod    ClassFactory._defineNonRootClass()
    //
    //  Define a class or interface which is assumed not to be a root class, that is, either the
    //  superclass must be valid or there must be a valid ClassFactory.defaultSuperClass.
    //<
    _defineNonRootClass : function (className, superClass, interfaces, asInterface, suppressSimpleNames, overwrite) {
        // if no superClass was specified, use the default rootClass
        superClass = (superClass || isc.ClassFactory.defaultSuperClass);
        // if we didn't find a superClass, something went wrong -- bail
        if (!superClass) {
            //>DEBUG
            isc.Log.logWarn("isc.ClassFactory.defineClass(" + className + ") called with null"
                        + " superClass and no ClassFactory.defaultRootClass is defined.");
            //<DEBUG
            return null;
        }
        //If the super class is a framework class, then the child should also be marked as a framework class
        isc.overridingFrameworkClass = isc.isA.ClassObject(superClass) && superClass.isFrameworkClass;
        return this._defineClass(className, superClass, interfaces, asInterface, suppressSimpleNames, overwrite);
    },


    _$Window: "Window",
    _$Selection: "Selection",
    _$DataView: "DataView",
    _$Animation: "Animation",
    _ignoredGlobalOverrides: {},
    _$simpleNamesWarning: "\nThis conflict would be avoided by disabling " +
                          "ISC Simple Names mode.  See documentation for " +
                          "further information.",
    _installIgnoredGlobalOverrides : function () {
        var browser = isc.Browser,
            ignored = this._ignoredGlobalOverrides;

        if (browser.isChrome || browser.isIE || browser.isMoz || browser.isSafari) {
            ignored[this._$Window]    = true;
            ignored[this._$Selection] = true;
            ignored[this._$DataView]  = true;
            ignored[this._$Animation] = true;
        }
    },

    //>    @classMethod    ClassFactory._defineClass()
    //
    // Internal method to actually create a class or interface.  <code>superclass</code> must
    // already be valid.
    //<
    _$iscPrefix: "isc.",
    _classTimes: {},
    _defineClass : function (className, superClass, interfaces, asInterface, suppressSimpleNames, overwrite)
    {


        // Accept superClasses defined as strings rather than references to the class object
        superClass = this.getClass(superClass);

        var definingFramework = (isc.definingFramework == true || isc.overridingFrameworkClass == true);


        if (!definingFramework && superClass && superClass._vbOnly && !isc.isVisualBuilderSDK) {
            var hasDefaultSuperClass = !!(isc.ClassFactory.defaultSuperClass);

            var errorMsg = "The framework class " + superClass.getClassName() + " is only available for subclassing if " +
                "isc.licenseType is \"Enterprise\" or \"Eval\".  " +
                (hasDefaultSuperClass ? "Continuing with the default super class." :
                "Returning null as there is no ClassFactory.defaultSuperClass specified.");

            isc.logWarn(errorMsg);
            if (!superClass._vbOnlyWarning) {
                // Only present an alert once per superclass
                superClass._vbOnlyWarning = true;
                isc.warn(errorMsg);
            }

            if (hasDefaultSuperClass) {
                superClass = this.getClass(isc.ClassFactory.defaultSuperClass);
            } else {
                return null;
            }
        }

        // If we have an ID collision, and the caller didn't pass true for the "overwrite"
        // param, warn the user before clobbering the existing object
        var existingObject, inISCSpace,
            ignoreGlobalOverride = this._ignoredGlobalOverrides[className],
            useSimpleNames = (isc._useSimpleNames && !suppressSimpleNames);
        existingObject = isc[className];
        if (existingObject != null) inISCSpace = true
        else if (useSimpleNames && !ignoreGlobalOverride)  {
            existingObject = window[className];
        }

        if (existingObject != null

            && className != "IButton"
            && overwrite != true
            // don't warn if a framework component schema is overridden ("componentSchema"
            // flag is automatically set by LoadSystemSchemaTag).  Without this check, we
            // get warnings at VB startup when eg the VisualBuilder class clobbers the
            // VisualBuilder component schema.  Component Schema don't really need to be
            // globals as framework code always looks them up with DataSource.get().
            && !(isc.DataSource && isc.isA.DataSource(existingObject) &&
                                                      existingObject.componentSchema)
            )
        {

            var errorString = "New Class ID: '" + className + "' collides with ID of existing " +
                                // NOTE: this check is required in case there is a collision on
                                // window.Class.  At that moment, isc.isA.Class is not a
                                // function, but the String "isA"
                                (isc.isA && isc.isA.Function(isc.isA.Class) && isc.isA.Class(existingObject) ?
                                    "Class object '" :
                                    "object with value '") +
                                existingObject + "'.  Existing object will be replaced.";
            if (!inISCSpace) errorString += this._$simpleNamesWarning;

            // Note: If the Log class hasn't loaded yet, we don't warn about this collision.
            // This should be ok in almost every case as Log loads early during the smartClient
            // libs, but if this proves to be an issue, we could hang onto the error string and
            // wait until after Log has loaded to log a warning.
            if (window.isc.Log) isc.Log.logWarn(errorString);
        }

        // create a new instance of the superClass to use as a prototype for this new class
        //    note: instancePrototype.init() is deliberately not called here
        var instancePrototype =
            (superClass ? new superClass._instancePrototype._instanceConstructor() : {});

        // create the class object for the new class: an object whose lookup pointer is the
        // superclass' ClassObject.
        var classObject = this._makeSubClass(superClass);

        // a constructor function that creates objects whose lookup pointer will be
        // instancePrototype.  These created objects are instances of "subClass"
        instancePrototype._instanceConstructor =
                this._getConstructorFunction(instancePrototype, className);

        // setup the class object
        classObject.Class = className;
        classObject._isClassObject = true;

        // Is this a core ISC class (defined during standard SmartClient init) or is this
        // a class added after the SC libraries have been loaded?
        // Useful for debugging / AutoTest locator APIs

        if (definingFramework) classObject.isFrameworkClass = true;
        else classObject.isFrameworkClass = false;
        if (!classObject.isFrameworkClass) {
            var scClass = superClass;
            while (scClass && !scClass.isFrameworkClass) {
                scClass = scClass.getSuperClass();
            }
            if (scClass) classObject._scClass = scClass.Class;
        }

        if (!classObject._scClass) classObject._scClass = classObject.Class;

        // NOTE: important that we always assign _isInterface so that concrete subclasses of
        // interfaces have _isInterface:false
        classObject._isInterface = instancePrototype._isInterface = !!asInterface;
        classObject._superClass = superClass;
        // crosslink the instance prototype and class object
        classObject._instancePrototype = instancePrototype;

        // setup the instance prototype: these properties appear on all instances
        instancePrototype.Class = className;
        // crosslink the instance prototype and class object
        instancePrototype._classObject = classObject;
        // this exists mostly so that instances can reference their prototype
        instancePrototype._scPrototype = instancePrototype;

        // copy the scClass information across too
        instancePrototype.isFrameworkClass = classObject.isFrameworkClass;
        instancePrototype._scClass = classObject._scClass;

        // put all Classes in the special "isc" object
        isc[className] = classObject;
        // if we're in simple names mode (eg, not worried about name collisions), make the class
        // available as a global variable
        if (useSimpleNames) {
            if (ignoreGlobalOverride) {
                var success = this.tryBindingGlobalID(window, className, classObject);
                if (!success && window.isc.Log) {
                    isc.Log.logWarn("We expected to override global " + className +
                                    " without any trouble, but were unable to replace it." +
                                    this._$simpleNamesWarning);
                }
            } else window[className] = classObject;
        }

        this.classList[this.classList.length] = className

        // create a function in the isA singleton object to tell if an object is an instance of
        // this Class, eg, isA.ListGrid()
        // Exception - the _customClassIsA object is used to track cases where isc.isA has
        // already been given a custom method which we don't want to clobber
        if (!(isc.isA._customClassIsA[className] && isc.isA[className])) {
            isc.isA[className] = this.makeIsAFunc(className);
        }

        // as a convenience, mix in a list of interfaces as part of the class definition
        if (interfaces != null) {
            if (!isc.isAn.Array(interfaces)) interfaces = [interfaces];
            for (var i = 0; i < interfaces.length; i++) {
                //alert("Mixing " + interfaces[i] + " into " + className);
                this.mixInInterface(className, interfaces[i]);
            }
        }

        return classObject;
    },


    makeIsAFunc : function (className) {


        return function (object) {
            if (object == null || object.isA == null || object.ns == null || object.ns.isA == null || object.isA === object.ns.isA) {
                return false;
            }
            return object.isA(className);
        };
    },

    // make a class object for a new subclass of superClass
    _makeSubClass : function (superClass) {
        if (!superClass) return {};

        // get the superClass' subclass constructor.  The subclass constructor creates objects
        // whose lookup pointer will be superClass.  It is created on the fly the first time a
        // class acquires a subclass (otherwise all leaf classes would have unnecessary
        // subclass constructors)
        var superSuperClass = superClass._superClass,
            subClassConstructor = superClass._subClassConstructor;
        if (!
            // if the superClass already has a subClassConstructor that differs from the
            // super-super class, use it
            (subClassConstructor &&
             (superSuperClass == null ||
              subClassConstructor !== superSuperClass._subClassConstructor))
            )
        {
            // otherwise we make it
            subClassConstructor = superClass._subClassConstructor =
                    this._getConstructorFunction(superClass, (superClass.Class || "unknown") + "Class");
        }
        return new subClassConstructor();
    },

    //>    @classMethod    ClassFactory.getClass()
    //
    //    Given a class name, return a pointer to the Class object for that class
    //
    //    @param    className    (String)    name of a class
    //    @return                (Class)        Class object, or null if not found
    //    @visibility external
    //<
    getClass : function (className, warnOnFailure) {
        // if it's a string, assume it's a className
        if (isc.isA.String(className)) {
            // see if isc[className] holds a ClassObject or an SGWTFactory
            var classObject = isc[className];
            if (classObject) {
                if (isc.isA.ClassObject(classObject)) return classObject;
                // SGWTFactory might not be defined yet ...
                if (isc.isA.SGWTFactoryObject && isc.isA.SGWTFactoryObject(classObject)) return classObject;
            }
        }
        // if it's a class object or an SGWTFactory, just return it
        if (isc.isA.ClassObject(className)) return className;
        // SGWTFactory might not be defined yet ...
        if (isc.isA.SGWTFactoryObject && isc.isA.SGWTFactoryObject(className)) return className;

        // if it's an instance of some class, return the class object for the class
        if (isc.isAn.Instance(className)) return className._classObject;
        if (isc.Log && warnOnFailure) {
            isc.Log.logWarn("ClassFactory.getClass() couldn't find class: " + className +
                            "; defined classes are: " + this.classList.sort());
        }
        return null;
    },

    //>    @classMethod    ClassFactory.newInstance
    //
    // Given the name of a class, create an instance of that class.
    //
    //        @param    className    (String)        Name of a class.
    //                            (ClassObject)    Actual class object to use.
    //        @param    [props]        (Object)        Properties to apply to the instance.
    //        @param    [props2]    (Object)        More properties to apply to the instance.
    //        @param    [props3]    (Object)        Yet more properties to apply to the instance.
    //
    //    @return                (Class)        Pointer to the new class.
    //    @visibility external
    //<
    // NOTE: ability to pass _constructor not documented until we have a more reasonable name for
    // this property.
    newInstance : function (className, props, props2, props3, props4, props5) {

        var classObject = this.getClass(className);

        // if we didn't get a classObject from getClass above,
        // and the first parameter is an object,
        // see if any of the properties objects passed have a ._constructor property,
        // which we'll treat as the classname
        if (classObject == null && isc.isAn.Object(className)) {

            var cons;
            for (var i = 0; i < arguments.length; i++) {
                var propsObj = arguments[i];
                // Note: ._constructor is used rather than .constructor to resolve a
                // number of JS issues, as constructor is present by default on native
                // JS objects.
                // In the long run we want to rename this to something more elegant, like 'class'
                // and modify the css class-specific code to look for 'style' or 'baseStyle' rather
                // than className (or even getClass()).
                if (propsObj != null && propsObj._constructor != null)
                {
                    cons = propsObj._constructor;
                }
            }

            // now fix up the props objects to include the first object
            //    as a set of properties instead of just the class name
            props5 = props4;
            props4 = props3;
            props3 = props2;
            props2 = props;
            props = className;

            className = cons;

            // Safari and Mozilla both JS Error if the 'constructor' property set to a string
            // (typically because a user is trying to specify the className to use. (it's ok in IE)
            // Note: the 'constructor' property exists as a native function on a number of standard
            // JS objects, so we can't just check for constructor == null
            if (isc.isA.String(props.constructor)) {
                // If we don't yet have a constructor className, make use of this property - then
                // log a warning and remove it.
                if (className == null) className = props.constructor;
                isc.Log.logWarn("ClassFactory.newInstance() passed an object with illegal 'constructor' " +
                             "property - removing this property from the final object. " +
                             "To avoid seeing this message in the future, " +
                             "specify the object's class using '_constructor'.", "ClassFactory");
                props.constructor = null;
            }

            classObject = this.getClass(cons);
        }

        if (classObject == null) {
            //>DEBUG
            isc.Log.logWarn("newInstance(" + className + "): class not found", "ClassFactory");
            if (isc.isA.String(className) && className.contains(".")) {
                isc.Log.logWarn("Did you make the SmartGWT class reflectable? See http://www.smartclient.com/smartgwt/javadoc/com/smartgwt/client/docs/Reflection.html", "ClassFactory");
            }
            //<DEBUG
            return null;
        }

        return classObject.newInstance(props, props2, props3, props4, props5);
    },

    //>    @classMethod    ClassFactory._getConstructorFunction
    //
    //    Given a <code>prototype</code> object, create a new constructor function that will
    //    reference this prototype.  This allows us to say <code>new constructor()</code> to
    //    create a new object that is effectively a subclass of the original <code>prototype</code>.
    //
    //    @param    proto    (Object)    Object to use as the prototype for new objects.
    //    @param    [className]    (Identifier)    Name of the class.
    //    @return            (Function)    Function that can be used to create new objects
    //                                based on the prototype.
    //<
    _getConstructorFunction : function (proto, className) {
        //!OBFUSCATEOK

        var cons;

        if (isc.Browser.isSafari) {
            cons = function () {};
        } else {

            cons = new Function();
        }
        cons.prototype = proto;
        return cons;
    },

    tryBindingGlobalID : function (wd, id, object) {
        try {
            wd[id] = object;
        } catch (e) {
            return false;
        }
        // attempting to override some keywords (for example window.document) will not
        // throw an error but simply fail to pick up the new value - catch this case as
        // well
        if (wd[id] != object) {
            return false;
        }
        return true;
    },

    //>    @classMethod    ClassFactory.addGlobalID()
    //
    // Given an <code>object</code>, declare a unique global variable and link it to object so
    // object can be addressed in the global scope.<br><br>
    // <P>
    // If the object already has an 'ID' property, it will be used. Note that if you pass an
    // object.ID, it's up to you to ensure it is unique in the global scope. If window[<i>ID</i>]
    // is already assigned to something else a warning will be logged using the developer console,
    // and the existing reference will be replaced.
    // <P>
    // If the object does not have an explicitly specified ID property already, one will be
    // automatically generated. Note that automatically generated global IDs may be reused if
    // the instance they originally referenced has been +link{Class.destroy(),destroyed}.
    //
    //    @param    object    (Object)    Object to add global ID to.
    //<
    _reservedWords: {
        toolbar:true,
        parent:true,
        window:true,
        top:true,
        opener:true,
        event:true // due to window.event in IE
    },

    addGlobalID : function (object, ID, dontWarn) {
        // if an ID was passed, use that
        object.ID = ID || object.ID || object.autoID;
        delete object.autoID;

        var wd = this.getWindow();

        // in keepGlobals mode only certain objects are allowed to actually keep their declared
        // global IDs.  Anything else is given the declared global ID temporarily, then retains
        // only its auto-generated global ID after the eval ends.
        if (isc.keepGlobals && object.ID != null) {
            if (!isc.keepGlobals.contains(object.ID) &&
                !(isc.DataSource && isc.isA.DataSource(object)))
            {
                var tempID = object._localId = object.ID;
                object.ID = null;
                isc.globalsSnapshot[tempID] = wd[tempID];
                wd[tempID] = object;
                // track temporary globals with auto-assigned IDs so IDs can be released later
                if (object._autoAssignedID) {
                    var className = object.AUTOIDClass || object.Class;

                    isc.autoAssignedTempGlobals[tempID] = className;
                }
            }
        }

        if (object.ID == null) {
            object.ID = this.getNextGlobalID(object);
            object._autoAssignedID = true;
        }


        if (isc._loadingComponentXML && isc.createLevel == 1) {
            object._screenEligible = true;
        }

        // if the ID is already taken, log a warning
        var isKeyword, checkForKeyword;
        if (wd[object.ID] != null) {
            var widgetInstance = isc.isA.BaseWidget(wd[object.ID]),
                scClassInstance = isc.isA.Class(wd[object.ID]);
            if (!(isc.isA.DataSource(wd[object.ID]) && wd[object.ID].componentSchema)) {

                dontWarn = dontWarn || (isc.isA.DataSource(wd[object.ID]) &&
                                            isc.ClassFactory._vbLoadingDataSources)
                if (!dontWarn) {


                    var widgetCollisionString =
                        "ID '{0}' collides with ID of existing widget '{1}'. The pre-existing widget will be destroyed.";
                    var otherCollisionString =
                        "ID '{0}' for object '{1}' collides with the ID of an existing object. This can occur when the " +
                        "specified ID for a new SmartClient Canvas is the same as a native attribute of 'window', or " +
                        "another variable already assigned in global scope. The global reference to this object will be replaced. " +
                        "Consider instead using a different ID to avoid this collision altogether, especially if the colliding " +
                        "ID is a native attribute of window.  Replacing such objects often has serious and " +
                        "unintended consequences. In this case, the current value of window['{0}'] is: \n\n {2} \n ";

                    var errorString = widgetInstance ? widgetCollisionString : otherCollisionString;

                    isc.Log.logWarn(String.format(errorString, object.ID, object, isc.echoAll(wd[object.ID])));

                }
            }


            if (scClassInstance && wd[object.ID].destroy != null &&
                !isc.isA.ClassObject(wd[object.ID]) &&
                !isc.isA.FormItem(wd[object.ID]))
            {
                wd[object.ID].destroy();
            }
            // If the attribute is not a pointer to a sc class instance it may be a
            // a reserved browser keyword or native window attribute which may be non overrideable.
            // Catch the cases we know about (stored in an explicit list)
            // Otherwise use a try...catch block when assigning the property to ensure we don't
            // crash

            if (!scClassInstance) {
                if (this._reservedWords[object.ID]) isKeyword = true;
                else                          checkForKeyword = true;
            }
        }

        // now assign the object under that ID globally so anyone can call it
        if (!isKeyword) {
            if (checkForKeyword) {
                if (!this.tryBindingGlobalID(wd, object.ID, object)) isKeyword = true
            } else {
                wd[object.ID] = object;
            }
        }
        // simple mechanism for instrumenting globals capture.  Simply set isc.globalsSnapshot to an
        // array and we'll fill it here.

        if (isc.globalsSnapshot) {
            if (isc.isAn.Array(isc.globalsSnapshot)) {
                // just store all globals that are established
                isc.globalsSnapshot.add(object.ID);
            } else {
                // store a mapping from new globals to original value to allow them to be
                // restored
                isc.globalsSnapshot[object.ID] = wd[object.ID];
            }
        }

        // refuse to use keywords and log a warning
        if (isKeyword) {
            var newID = this.getNextGlobalID(object);
            isc.logWarn("ClassFactory.addGlobalID: ID specified as:"+  object.ID +
                         ". This is a reserved word in Javascript or a native property of the" +
                         " browser window object and can not be used as an ID." +
                         " Setting ID to " + newID + " instead.");
            object.ID = newID;
            object._autoAssignedID = true;
            wd[object.ID] = object;
        }


        if (isc.isA && isc.isA.Canvas && !isc.isA.Canvas(object) && object._initDynamicProperties) {
            object._initDynamicProperties();
            object._createDynamicPropertyRules();
        }
    },

    _$isc_OID_ : "isc_OID_",
    _$isc_ : "isc_",
    _$underscore : "_",
    _joinBuffer : [],
    _perClassIDs:{},

    getNextGlobalID : function (object) {
        var classString;
        if (object != null && (object.AUTOIDClass != null || object.Class != null)) {
            classString = object.AUTOIDClass || object.Class;
        }
        return this.getNextGlobalIDForClass(classString);
    },
    getNextGlobalIDForClass : function (classString) {
        if (classString) {
            var freed = this._freedGlobalIDs[classString];
            if (freed && freed.length > 0) {
                var ID = freed[freed.length-1];
                freed.length = freed.length-1;
                return ID;
            }
            var idCount;
            if (this._perClassIDs[classString] == null) this._perClassIDs[classString] = 0;
            idCount = this._perClassIDs[classString]++;

            var buffer = this._joinBuffer;
            buffer[0] = this._$isc_;
            buffer[1] = classString;
            buffer[2] = this._$underscore;
            isc._fillNumber(buffer, idCount, 3,5);

            var result = buffer.join(isc.emptyString);
            return result;
        }
        return this._$isc_OID_ + this._globalObjectID++;
    },
    // dereferenceGlobalID()
    // - frees the window[ID] pointer to an object
    // - allows the global ID to be re-used within this page
    dereferenceGlobalID : function (object) {
        // remove the window.ID pointer to the object.
        // NOTE: don't destroy the global variable if it no longer points to this widget
        // (this might happen if you create a new widget with the same ID)
        if (window[object.ID] == object) {

            if (!isc.Browser.isIE || isc.Browser.isIE9) {
                try {
                    delete window[object.ID];
                } catch (e) {
                    isc.logWarn("ClassFactory.dereferenceGlobalID(): Failed to delete the '" +
                                object.ID + "' global.");
                }
                if (window[object.ID] != null) window[object.ID] = null;
            } else {
                window[object.ID] = null;
            }

            // update globals capture data structure

            if (isc.globalsSnapshot) {
                if (isc.isAn.Array(isc.globalsSnapshot)) isc.globalsSnapshot.remove(object.ID);
                else                                     delete isc.globalsSnapshot[object.ID];
            }

            if (object._autoAssignedID && (object.AUTOIDClass != null || object.Class != null)) {
                this.releaseGlobalID(object.AUTOIDClass || object.Class, object.ID);
            }

            // Don't actually delete the object.ID property - This method is typically called
            // as part of destroy() and if for some reason we have a pointer to a destroyed object
            // it's helpful to know the ID for debugging.
        }
    },

    // Maintain a pool of global IDs that are no longer in use due to destroy() calls
    // and reuse them rather than creating new IDs where possible


    // GlobalIDs are of the form isc_ClassName_int (isc_StaticTextItem_24, etc)
    // We maintain a cache of previously used global IDs indexed by className, set up each time we
    // call dereferenceGlobalID(). Then autoAssignGlobalID() can re-use IDs from the cache for
    // the appropriate object className
    reuseGlobalIDs:true,
    globalIDClassPoolSize:1000,
    _freedGlobalIDs:{
    },
    releaseGlobalID : function (className, ID) {

        if (!this.reuseGlobalIDs) return;
        var freed = this._freedGlobalIDs[className];
        if (!freed) this._freedGlobalIDs[className] = [ID];
        else if (freed.length <= this.globalIDClassPoolSize) {
            if (!freed.contains(ID)) freed[freed.length] = ID;
        }
    },

    _domIDCount:0,
    _$isc_:"isc_",
    _simpleDOMIDTemplate:[null, "_", null],

    // DOM ID Cacheing logic

    // Maintain a cache of generated DOM ID strings that are no longer in use and re-use them when
    // we need a new arbitrary DOM ID.
    // Canvii may notify us when DOM IDs are no longer in use by calling releaseDOMID()
    // Behavior may be disabled by setting reuseDOMIDs to false
    // Note that reuseDOMIDs may also be set to false on individual Canvii - see
    // Canvas._releaseDOMIDs
    reuseDOMIDs:false,
    DOMIDPoolSize:10000,
    _freedDOMIDs:[],
    releaseDOMID : function (ID) {
        if (!this.reuseDOMIDs || this._freedDOMIDs.length > this.DOMIDPoolSize) return;
        this._freedDOMIDs[this._freedDOMIDs.length] = ID;
    },

    // getDOMID() - return a unique string to be used as a DOM Id.
    //
    // Has 2 modes:
    // If isc._longDOMIds is false (production mode), the returned IDs are arbitrary short
    // strings
    // If isc._longDOMIds is true (development mode), the IDs will be generated based on the
    // ID and suffix passed into this method - useful for debugging as the DOM IDs obviously relate
    // to the canvases that created them.
    getDOMID  : function (ID, suffix) {

        // By default we return a unique but uninformative ID like "isc_1A"

        if (!isc._longDOMIds || !ID || !suffix) {

            // by preference we'll reuse a DOM ID we know has been freed
            var freedIDs = this._freedDOMIDs.length;
            if (freedIDs > 0) {
                var ID = this._freedDOMIDs[freedIDs-1];
                this._freedDOMIDs.length = freedIDs-1;
                return ID;
            }

            var number = this._domIDCount++;
            return this._convertToBase36(number, this._$isc_);
        }



        // In simpleDOMIDMode, create an ID that incorporates the ID / suffix passed to us
        // We're making an assumption that the ID / suffix passed in is already unique

        this._simpleDOMIDTemplate[0] = ID;
        this._simpleDOMIDTemplate[2] = suffix;
        return this._simpleDOMIDTemplate.join(isc.emptyString);
    },

    _base36Digits:["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H","I","J","K",
                   "L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"],
    _base36Arr:[],
    _convertToBase36 : function (number, prefix) {
        var digits = this._base36Digits,
            resultsArr = this._base36Arr;

        resultsArr.length = 0;

        // We use this to prefix with "isc_"
        if (prefix) resultsArr[0] = prefix;

        var totalDigits = 3;

        if (number > 46655) {
            while (Math.pow(36,totalDigits) <= number) totalDigits += 1;
        }

        // convert number to base 36
        while (number >= 36) {
            var remainder = number % 36;
            // always add to the end slot, so we get 100 rather than 001
            resultsArr[totalDigits-(prefix ? 0 : 1)] = digits[remainder];
            totalDigits -=1;

            number = Math.floor(number / 36);
        }
        resultsArr[totalDigits-(prefix ? 0 : 1)] = digits[number];

        return resultsArr.join(isc.emptyString);

    },

    //>    @classMethod    ClassFactory.mixInInterface()    (A)
    //
    // Add the methods of a given Interface to a Class so the class implements the methods.
    // If the class has already defined a method with the same name as the one specified
    // in the interface, the class' method will be retained.
    //
    //    @param    className        (String)    Name of the Class to add methods to.
    //    @param    interfaceName    (String)    Name of the Interface to get methods from.
    //<
    mixInInterface : function (className, interfaceName) {
        // acept list of interfaces - apply all
        if (isc.isAn.Array(interfaceName)) {
            for (var i = 0; i < interfaceName.length; i++) {
                this.mixInInterface(className, interfaceName[i]);
            }
            return;
        }
        var theInterface = this.getClass(interfaceName);

        // interface can be applied to class or instance
        var theClass;
        var instance = isc.isA.String(className) || isc.isA.ClassObject(className) ? null : className;
        if (instance) {
            className = instance.getClassName();
        }
        theClass = this.getClass(className);

        if (!theInterface || !theClass) return null;

        if (!theInterface._isInterface) {
            //>DEBUG
            isc.Log.logWarn("ClassFactory.mixInInterface asked to mixin a class which was not"
                        + " declared as an Interface: "+interfaceName+ " onto "+className);
            //<DEBUG
            return;
        }

        if (instance) {
            // applying to instance
            //
            // mark the class as implementing the interface
            if (!instance._implements) {
                if (theClass._implements) instance._implements = theClass._implements.duplicate();
                else instance._implements = [];
            }
        } else {
            // applying to class
            //
            // mark the class as implementing the interface
            if (!theClass._implements) theClass._implements = [];
            // ensure the interface doesn't apply to a superClass
            else theClass._implements = theClass._implements.duplicate();
        }

        // install all properties and methods added to this interface, and any superInterfaces
        while (theInterface) {
            if (instance) {
                if (!instance._implements.contains(interfaceName)) {
                    // mix in instance properties and methods
                    this._mixInProperties(theInterface, instance);
                    instance._implements[instance._implements.length] = interfaceName;
                }
            } else {
                if (!theClass._implements.contains(interfaceName)) {
                    // mix in instance properties and methods
                    this._mixInProperties(theInterface, theClass);

                    theClass._implements[theClass._implements.length] = interfaceName;

                    // mix in class properties and methods
                    this._mixInProperties(theInterface, theClass, true);
                }
            }
            theInterface = theInterface.getSuperClass();
            if (theInterface && !theInterface._isInterface) break;
            interfaceName = theInterface.getClassName();
        }
    },

    _initInterfaceMethodName: "initInterface",
    _destroyInterfaceMethodName: "destroyInterface",
    _mixInProperties : function (source, destination, asClassProperties) {

        var props;
        if (asClassProperties) {
            props = isc._interfaceClassProps[source.Class];
        } else {
            props = isc._interfaceInstanceProps[source.Class];
            source = source.getPrototype();
            destination = isc.isA.ClassObject(destination) ? destination.getPrototype() : destination;
        }

        if (props == null) return;

        for (var i = 0; i < props.length; i++) {
            var propName = props[i];

            // skip any properties already defined in the target
            if (destination[propName] != null) continue;

            var propValue = source[propName];

            // the interface declared that the target class must implement a method, and it's not
            // there
            if (isc.isA.String(propValue) && propValue == this.TARGET_IMPLEMENTS) {
                //>DEBUG
                var message = (asClassProperties ? "Class" : "Instance") + " method "
                    + propName + " of Interface " + source.Class + " must be implemented by "
                    + "class " + destination.Class;
                // Don't complain about interface methods not being implemented b/c it's
                // perfectly normal to mix in interfaces before adding properties to the
                // class.  In fact that may be the case most of the time b/c showing the
                // interfaces at class definition is very useful
                // (e.g: defineClass("Foo", "Bar", "SomeInterface")
                //
                //isc.Log.logWarn(message + ", is not yet implemented");

                // but it will be an error if this method is ever called, so install a function
                // that will complain
                destination[propName] = function () {
                    this.logError(message);
                };
                //<DEBUG
            } else if (propName == this._initInterfaceMethodName && !asClassProperties) {
                // patch any initInterface() methods onto a special array on the classObject to
                // be called at class creation.
                if (destination._initInterfaceMethods == null) destination._initInterfaceMethods = [];
                destination._initInterfaceMethods[destination._initInterfaceMethods.length] = propValue;
            } else if (propName == this._destroyInterfaceMethodName && !asClassProperties) {
                // patch any destroyInterface() methods onto a special array on the classObject to
                // be called at class destruction.
                if (destination._destroyInterfaceMethods == null) destination._destroyInterfaceMethods = [];
                destination._destroyInterfaceMethods[destination._destroyInterfaceMethods.length] = propValue;
            } else {
                //isc.Log.logWarn("adding property " + propName +
                //                " from interface " + source.Class);
                destination[propName] = propValue;
            }
        }
    },

    //>    @classMethod    ClassFactory.makePassthroughMethods()    (A)
    //
    // Create methods that call through to a related object stored under property
    // <code>propName</code>.  This enables easy implementation of the Delegate design
    // pattern, where one object implements part of its APIs by having another object respond
    // to them.
    //
    //    @param    methodNames    (Array of String)    list of methods names
    //    @param    propName    (String)            Property name where the target object is stored.
    //<
    _$argList : "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p",
    makePassthroughMethods : function (methodNames, propName, addNullCheck, nullCheckWarning,
                                       inheritedProperty)
    {
        if (!propName) propName = "parentElement";

        var funcTemplate;
        if (!addNullCheck) {
            funcTemplate = this._funcTemplate;
            if (funcTemplate == null) {
                funcTemplate = this._funcTemplate = ["return this.",,".",,"("+this._$argList+")"];
            }
        } else {
            funcTemplate = this._nullCheckFuncTemplate;
            if (funcTemplate == null) {
                funcTemplate = this._nullCheckFuncTemplate =
                    ["if(this.",,"==null){\n",
                     ,// optionally log a warning
                     "return;}\n",,"return this.",,".",,"("+this._$argList+")"];
            }
        }

        var methods = {};

        for (var i = 0; i < methodNames.length; i++) {
            var methodName = methodNames[i];

            // create a function that routes a function call to the target object
            if (addNullCheck) {
                funcTemplate[1] = propName;
                if (nullCheckWarning != null) {
                    var messageArgs = {
                        methodName:methodName,
                        propName:propName
                    };
                    var warning = nullCheckWarning.evalDynamicString(this, messageArgs);

                    funcTemplate[3] = "isc.logWarn(\"" + warning + "\");";
                }
                if (inheritedProperty != null) {
                    funcTemplate[5] = "this." + propName + "." + inheritedProperty + "=" +
                                      "this." +                  inheritedProperty + ";\n";
                }
                funcTemplate[7] = propName;
                funcTemplate[9] = methodName;

            } else {
                funcTemplate[1] = propName;
                funcTemplate[3] = methodName;
            }
            methods[methodName] =
                isc._makeFunction(this._$argList, funcTemplate.join(isc.emptyString));
        }

        return methods;
    },

    //>    @classMethod    ClassFactory.writePassthroughFunctions()    (A)
    //
    // Install methods in <code>destinationClass</code> which will call the same-named function
    // on a related object stored under the property name <code>memberName</code> on instances
    // of <code>destinationClass</code>.
    //
    //    @example    <code>ClassFactory.writePassthroughFunctions(
    //                    ListGrid, "selection", ["select","selectAll",..."]
    //                );</code>
    //
    //                after this, you can call
    //                    listGrid.selectRecord()
    //                rather than
    //                    listGrid.selectionManager.selectRecord()
    //<
    writePassthroughFunctions : function (destinationClass, memberName, methodNames) {
        var methods = this.makePassthroughMethods(methodNames, memberName);
        destinationClass.addMethods(methods);
    },

    // Globally track whether Visual Builder is loading a dataSource (and possibly its
    // dependencies), so we can inhibit collision messages when a DataSource is reloaded
    _setVBLoadingDataSources : function(newValue) {
        isc.ClassFactory._vbLoadingDataSources = newValue;
    }

});    // END isc.addMethods(isc.ClassFactory)

//
// add properties to the ClassFactory object
//
isc.addProperties(isc.ClassFactory, {
    // when defining interfaces, use this constant as a marker value indicating that a method
    // must be implemented by any class your interface is mixed in to
    TARGET_IMPLEMENTS : "TARGET_IMPLEMENTS",

    //>    @attr    ClassFactory.defaultSuperClass  (Class : null : [IA])
    // Class to use as the default superClass if none is specified
    //<

    // Counter which is used to generate unique object IDs
    _globalObjectID : 0,

    // Classes created with ClassFactory.defineClass
    classList : []
});

//> @staticMethod isc.defineClass
// Shortcut for <code>isc.ClassFactory.defineClass()</code>.
// @include classMethod:ClassFactory.defineClass
// @see ClassFactory.defineClass()
// @visibility external
//<
isc.defineClass = function (className, superClass, interfaces, suppressSimpleName) {
    return isc.ClassFactory.defineClass(className, superClass, interfaces, suppressSimpleName);
}

//> @staticMethod isc.overwriteClass
// Shortcut for <code>isc.ClassFactory.overwriteClass()</code>.
// @include classMethod:ClassFactory.overwriteClass
// @see ClassFactory.overwriteClass()
// @visibility external
//<
isc.overwriteClass = function (className, superClass, interfaces, suppressSimpleName) {
    return isc.ClassFactory.overwriteClass(className, superClass, interfaces, suppressSimpleName);
}

isc.defineInterface = function (className, superClass) {
    return isc.ClassFactory.defineInterface(className, superClass);
}

//> @type SCClassName
// <smartclient>Name of a SmartClient Class, that is, a Class that has been created via
// +link{staticMethod:isc.defineClass()}, including Classes built into SmartClient, such as "ListGrid".
// </smartclient>
// <smartgwt>
// Name of a SmartGWT class, including framework classes such as "ListGrid", or custom subclasses you
// have created. For your own custom classes, the classes must have
// +externalLink{https://www.smartclient.com/smartgwt/javadoc/com/smartgwt/client/docs/Reflection.html,Reflection}
// enabled.</smartgwt>
//
// @baseType String
// @visibility external
//<

isc.defer = function (code) {
    var lastClass = isc.ClassFactory.getClass(isc.ClassFactory.classList.last(), true),
        existingCode = lastClass._deferredCode;
    isc.Log.logDebug("deferred code being placed on class: " + lastClass);
    // first time
    if (!existingCode) lastClass._deferredCode = [code];
    // more times
    else existingCode.add(code);
}

// install names that are expected to collide
isc.ClassFactory._installIgnoredGlobalOverrides();





if (!isc.Browser.isSafari) {
    isc._window = window;
    isc._document = window.document;
}


if (window.isc_enableCrossWindowCallbacks && isc.Browser.isIE) {
   isc.enableCrossWindowCallbacks = true;
   Object._window = window;
}



//>    @class    Class
//
// The Class object is root of the Isomorphic SmartClient inheritance tree -- it includes
// functionality for creating instances, adding methods and properties, getting prototypes,
// etc.<br><br>
//
// To add functionality to ALL classes, add them to Class.<br><br>
//
// To create a Class, call <code>ClassFactory.defineClass("MyClass", "MySuperClass")</code>
// <P>
// <code>defineClass</code> will return the created class, and make it available as
// <code>isc.MyClass</code>, and as the global variable <code>MyClass</code> if not in
// +link{class:isc,portal mode}.
// <P>
// You can then:
// <UL>
//        <LI>add class-level (static) properties and methods to the class:
//                <code>MyClass.addClassProperties()</code>
//            these methods and properties are accessed through the Class variable itself, eg:
//                <code>MyClass.someStaticMethod()</code> or <code>MyClass.someStaticProperty</code>
//
//        <LI>add default instance properties and methods to the class:
//                <code>MyClass.addProperties()</code>
//            these methods and properties are accessed through a class instance, eg:
//                <code>var myInstance = MyClass.create();</code>
//                <code>myInstance.someInstanceMethod()</code>
//
//        <LI>create new instances of this class:
//                <code>var myInstance = MyClass.create()</code>
// </UL>
// NOTE: as a convention, all class names begin with a capital letter and all instances begin
// with a lower case letter.
//
//  @treeLocation Client Reference/System
//    @visibility external
//<
isc.ClassFactory.defineRootClass('Class');

//
// set Class as the default superclass for classes defined by ClassFactory.defineClass()
//
isc.ClassFactory.defaultSuperClass = isc.Class;

//
//    add static methods to all classes defined with our system
//
//    call on the Class object itself, as:   Class.method()
//

//  First we install the methods that allow us to addMethods to a class as a method call on the
//  class (eg Class.addClassMethods(methods) rather than addMethods(Class, methods);.
isc.addMethods(isc.Class, {

    //>    @classMethod    Class.addClassMethods()
    //
    //    Add static (Class-level) methods to this object.<br><br>
    //
    //    These methods can then be called as MyClass.method().  The value for "this" will be the
    //    class object for the class.
    //
    //    @param    [arguments 0-N] (Object)    objects with methods to add (think named parameters).
    //                                        all the methods of each argument will be applied
    //                                        as class-level methods.
    //    @visibility internal
    //<

    addClassMethods : function () {
        for (var i = 0; i < arguments.length; i++)
            isc.addMethods(this, arguments[i]);
    }


});

isc.Class.addClassMethods({

    //>    @classMethod Class.create()
    //
    // Create an instance of this class.
    // <P>
    // All arguments passed to this method are passed on to the +link{Class.init()} instance
    // method.  Unless +link{class.addPropertiesOnCreate} is set to <code>false</code>, all
    // arguments passed to this method must be Objects and all properties on those
    // objects will be copied to the newly created instance before +link{Class.init()} is
    // called.  If there are overlapping properties in the passed arguments, the last wins.
    // <p>
    // Any return value from +link{Class.init()} is thrown away.
    // <p>
    // Note: Generally, you would not override this method.  If you want to specify a
    // constructor for your class, provide an override for +link{Class.init()} for generic
    // classes or +link{canvas.initWidget()} for any subclasses of UI components
    // (i.e. descendants of +link{Canvas}).
    //
    //    @param    [arguments 0-N]    (Any)
    //      Any arguments passed will be passed along to the init() routine of the instance.
    //      Unless +link{class.addPropertiesOnCreate} is set to false, any arguments passed to
    //      this method must be of type Object.
    //    @return                     (Object)
    //      New instance of this class, whose init() routine has already been called
    //
    //    @example    <code>var myInstance = MyClass.create()</code>
    //  @example    create
    //    @visibility external
    //<
    create : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
        var clazz = this;

        // apply CreateScreenSettings - remap new instance's class, or return different instance

        var screenSettings = isc._createScreenSettings;
        if (screenSettings) {
            var replacement, newClass,
                classSubs     = screenSettings.classSubstitutions,
                componentSubs = screenSettings.componentSubstitutions
            ;


            if (isc.Browser.isSGWT && A && A[isc.gwtRef]) classSubs = componentSubs = null;

            // apply component substitutions first; these target a specific instance ID
            if (componentSubs) {
                var ID = this._getIDfromPropertyObjs(arguments);
                if (ID && componentSubs[ID]) { // found a mapped ID
                    replacement = componentSubs[ID];
                    // if the replacement is an instance, just return it
                    if (isc.isAn.Instance(replacement)) return replacement;
                    // otherwise, treat it as a class name and resolve it
                    newClass = isc.ClassFactory.getClass(replacement, true);
                }
            }
            // if we haven't executed a component substitution, try a class substitution
            if (classSubs && !newClass) {
                replacement = classSubs[clazz.getClassName()];
                // if we map the current class, try to resolve the replacement class name
                if (replacement) newClass = isc.ClassFactory.getClass(replacement, true);
            }
            // if we've remapped the current class, newClass will be non-null
            if (newClass) {
                if (this.logIsInfoEnabled("makeScreen")) {
                    this.logInfo("Using class " + newClass.getClassName() + " in place of " +
                        clazz.getClassName() + " due to createScreenSettings", "createScreen");
                }
                clazz = newClass;
            }
        }

        var newInstance = clazz.createRaw();

        if (newInstance != null) {
            newInstance = newInstance.completeCreation(A,B,C,D,E,F,G,H,I,J,K,L,M);
        }

        // return the new instance
        return newInstance;
    },

     // given a list of property objects A, B, C, D, ..., return last ID binding
     _getIDfromPropertyObjs: function (propertyObjList) {
         for (var i = propertyObjList.length - 1; i >= 0; i--) {
             var arg = propertyObjList[i];
             if (arg && arg.ID) return arg.ID;
         }
     },




    _initializedClasses : {},
    createRaw : function () {

        if (this._vbOnly && !isc.isVisualBuilderSDK) {
            var errorMsg = "Attempt to create " + this.getClassName() + ".  This class requires the " +
                           "Dashboards & Tools framework which is only included with Enterprise " +
                           "licenses.";
            isc.logWarn(errorMsg);
            if (!this._vbOnlyWarning) {
                // Only present alert once per class
                try {
                    isc.warn(errorMsg);
                    this._vbOnlyWarning = true;
                } catch (e) {
                    // ignore: possible crash when attempting to show a dialog before <body>
                    // tag is written on page
                }
            }

            return null;
        }

        if (!this.initialized()) this.init();

        // create a new instance based on the class's instancePrototype

        var newInstance = new this._instancePrototype._instanceConstructor();

        // install the appropriate namespace on the instance
        newInstance.ns = this.ns;

        return newInstance;
    },

    // class-level init
    init : function () {
        //!OBFUSCATEOK
        //this.logWarn("uninitialized class");

        // init superclass chain
        var superClass = this.getSuperClass();
        if (superClass != null && !superClass.initialized()) superClass.init();

        // execute any deferred class definition
        var deferredCode = this._deferredCode;
        if (deferredCode != null) {
            //this.logWarn("eval'ing deferred code");
            this._deferredCode = null;

            var captureDefaults = isc.captureDefaults;
            if (captureDefaults) isc.captureDefaults = false;

            deferredCode.map(function (expression) {
                //!OBFUSCATEOK
                isc.eval(expression);
            });

            if (captureDefaults) isc.captureDefaults = true;
        }



        if (this.autoDupMethods) {
            isc.Class.duplicateMethods(this, this.autoDupMethods);
        }

        this._initializedClasses[this.Class] = true;
    },

    //> @classMethod Class.modifyFrameworkStart()
    // Notifies the SmartClient Class system that any new classes created, or changes made
    // to existing classes should be treated as part of the framework. This ensures that
    // +link{Class.isFrameworkClass} will be set to true on any classes defined after this
    // method call, until +link{Class.modifyFrameworkDone()} is called.
    // <P>
    // Developers may call this method before applying changes which should be considered
    // part of the core framework, rather than application code, for example in <i>load_skin.js</i>
    // files. When changes are complete, +link{modifyFrameworkDone()} should be called.
    // Note that this is an alternative approach to calling +link{markAsFrameworkClass()}
    // directly on specific classes.
    //
    // @visibility external
    //<
    modifyFrameworkStart : function () {
        isc.definingFramework = true;
    },

    //> @classMethod Class.modifyFrameworkDone()
    // Notifies the SmartClient Class system that the developer is done making changes
    // to the SmartClient framework (as originally indicated by a call to
    // +link{modifyFrameworkStart()}).
    // <P>
    // New classes created or changes made to existing classes after this method call
    // will be considered application code. This ensures that
    // +link{Class.isFrameworkClass} will not be set to true on Classes defined after
    // this method call.
    // @visibility external
    //<
    modifyFrameworkDone : function () {
        isc.definingFramework = false;
    },

    // to get around native browser limitations with stack traces being unable to proceed
    // through recursively called methods, create duplicates of certain key functions on every
    // class and instance.

    duplicateMethods : function (target, methodNames) {
        // skip certain ultralight classes
        if (target.Class && this.dontDup[target.Class]) return;

        for (var i = 0; i < methodNames.length; i++) {
            var methodName = methodNames[i];

            this.duplicateMethod(methodName, target);
        }
    },
    duplicateMethod : function (methodName, target) {
        if (!target) target = this;

        var method = target[methodName];

        if (method == null) return;

        // avoid duplicating a duplicate, which would force Super() to follow multiple
        // _originalMethod links to discover the true original method.
        if (method._originalMethod) {
            while (method._originalMethod) method = method._originalMethod;
            //this.logWarn("double dup: " + methodName + " on target: " + target);
        }

        //!DONTOBFUSCATE
        var dup;
        if (method.toSource == null) { // IE, Safari
            dup = eval("dup = " + method.toString());
        } else {
            dup = eval(method.toSource());
        }

        // figure out the method's name
        if (!method._fullName) isc.Func.getName(method, true);
            /*
            name = (isc.isA.ClassObject(target) ? "[c]" : "") +
                    (target.Class ? target.Class : "") +
                    "." + methodName + "[d]";
            */
        dup._fullName = method._fullName + "[d]";

        // to allow Super() to do correct comparisons with superclass implementations
        dup._originalMethod = method;

        target[methodName] = dup;

        return dup;
    },
    dontDup : {
        StringBuffer : true,
        Action : true,
        MathFunction : true,
        JSONEncoder : true
    },
    // class-level auto-dups
    //autoDupMethods: [ "fireCallback" ],

    _createUnsupportedMethodImpl : function (messageTemplate, methodName) {
        // Closure variable to keep track of whether this unsupported method was called before
        // (by class name).
        var alreadyLoggedWarningForClass = {};

        var newMethod = function () {
            var className = this.getClassName();

            if (alreadyLoggedWarningForClass[className]) return;

            var message = messageTemplate.replace(/(\$?)\$(class|method)/g, function (match, p1, p2, offset, messageTemplate) {
                if (p1 === "$") return "$" + p2;
                else if (p2 === "class") return className;
                else if (p2 === "method") return methodName;


            });

            this.logWarn(message);
            alreadyLoggedWarningForClass[className] = true;


        };
        newMethod._isUnsupportedMethod = true;

        // Copy the argString of the original method.
        var origMethod = this._instancePrototype[methodName];
        if (isc.isA.Function(origMethod)) {
            newMethod._argString = isc.Func.getArgString(origMethod);
        }

        return newMethod;
    },

    //> @classMethod class.markUnsupportedMethods() (A)
    // Replaces each of the methods named in <code>methodNames</code> with a new implementation
    // that simply logs a warning the first time the method is called, and nothing else. This can
    // be used to mark methods of derived classes which do not support certain parent class
    // methods as unsupported.
    // <p>
    // The <code>messageTemplate</code> parameter is a template for the warning message logged
    // when the unsupported method is first called. The following variables in the template
    // are substituted as follows:
    // <table border="1">
    // <tr>
    //   <th>Variable</th>
    //   <th>Substitution</th>
    // </tr>
    // <tr>
    //   <td><code>$class</code></td>
    //   <td>The +link{getClassName(),class name}.</td>
    // </tr>
    // <tr>
    //   <td><code>$method</code></td>
    //   <td>The name of the method.</td>
    // </tr>
    // </table>
    // <p>
    // If you want the literal string of a substitution variable to appear in the warning message,
    // you can escape it by prefixing with a dollar sign. For example, to include "$class" in the
    // warning message, use "$$class" in the template.
    // @param messageTemplate (String) template for the warning message logged when first called.
    // If null, the default template string "$class does not support the $method() method." is used.
    // @param methodNames (Array of Identifier) the method names to mark as unsupported.
    // @see Class.isMethodSupported()
    // @visibility external
    //<
    markUnsupportedMethods : function (messageTemplate, methodNames) {
        if (messageTemplate == null) messageTemplate = "$class does not support the $method() method.";
        for (var i = 0; i < methodNames.length; ++i) {
            var methodName = methodNames[i];
            this._instancePrototype[methodName] = this._createUnsupportedMethodImpl(messageTemplate, methodName);
        }
    },

    //> @classMethod class.isMethodSupported() (A)
    // Returns true if the method is supported by this class, meaning that it is not null and
    // was not replaced by +link{Class.markUnsupportedMethods()}.
    // @param methodName (Identifier) the name of a method to test.
    // @return (boolean) true if the method is not null and is not an unsupported method; false otherwise.
    // @visibility external
    //<
    isMethodSupported : function (methodName) {
        var method = this._instancePrototype[methodName];
        return method != null && !method._isUnsupportedMethod;
    },

    isMethodUnsupported : function (methodName) {
        return !this.isMethodSupported(methodName);
    },

    // NOTE: we have to use a structure like this instead of just checking a property on the
    // class object (eg this._initialized) because any property would be inherited from
    // superclass class objects.
    initialized : function () { return this._initializedClasses[this.Class] },

    //>    @classMethod Class.getClassName()
    //
    //    Gets the name of this class as a string.
    //
    //    @return (String)    name of the class
    //    @visibility external
    //<
    getClassName : function () {
        return this.Class;
    },

    //> @classMethod Class.getScClassName()
    //
    //  Gets the name of this class as a string, if the class is a SmartClient Framework class.
    //  Otherwise, gets the name of the SmartClient Framework class which this class extends.
    //
    //  @return (String) name of the SmartClient Framework class
    //<
    getScClassName : function () {
        return this.isFrameworkClass ? this.Class : this._scClass;
    },

    //> @classMethod Class.compareScClassName()
    //
    // Compares the scClassName supplied with that of the of the class instance.
    // Useful in writing code such as:
    //     canvasList.findAll(isc.Class.compareScClassName, "Button")
    //
    // @return (boolean) whether instance has the supplied scClassName
    //<
    compareScClassName : function (instance, scClassName) {
        if (!isc.isAn.Instance(instance)) return false;
        return instance.getScClassName() == scClassName;
    },

    //>    @classMethod Class.getSuperClass()
    //
    //    Gets a pointer to the superClass' Class object.
    //
    //    @return (Class)        Class object for superclass.
    //    @visibility external
    //<
    getSuperClass : function () {
        return this._superClass;
    },

    //>    @classMethod Class.getPrototype
    //
    //    Gets a pointer to the prototype object for this class.
    //
    //    This is the object that you should install methods/properties into
    //    to have them apply to each instance.  Generally, you should use
    //    +link{Class.addProperties()} to do this
    //    rather than affecting the prototype directly
    //
    //    @return    (Object)    Prototype for all objects instances.
    //<
    // NOTE: not external because customers shouldn't muck with the prototype directly
    getPrototype : function () {
        return this._instancePrototype;
    },

    //> @classMethod Class.addMethods()
    //
    // Helper method for adding method definitions to all instances of this class.<P>
    //
    // The added methods can be called as myInstance.method().<P>
    //
    // Functionally equivalent to +link{class.addProperties}, which works with both properties
    // and methods.
    //
    // @param [arguments 0-N] (Object) objects with methods to add (think named parameters).
    //                                  all the methods of each argument will be applied
    //                                  as instance-level methods.
    // @return (Object) the class after methods have been added to it
    // @visibility external
    //<

    addMethods : function () {
        if (this._isInterface) {
            this.logWarn("Use addInterfaceMethods() to add methods to interface " + this);
        }
        for (var i = 0; i < arguments.length; i++)
            isc.addMethods(this._instancePrototype, arguments[i]);
        return this._instancePrototype;
    },

    addInterfaceMethods : function () {
        for (var i = 0; i < arguments.length; i++)
            isc.addMethods(this._instancePrototype, arguments[i]);
    },
    addInterfaceProperties : function () {
        isc.addPropertyList(this._instancePrototype, arguments, true);
    },


    //>    @classMethod Class.registerStringMethods()
    //
    //    Register a method, or set of methods, that can be provided to instances of this class as
    //    Strings (containing a JavaScript expression) and will be automatically converted into
    //    functions.
    //  <p>
    //  For example:
    //  <pre>
    //  isc.MyClass.registerStringMethods({
    //      myStringMethod: "arg1, arg2"
    //  });
    //  </pre>
    //
    //    @param    methodName (Object)        If this is a string, name of the property to register
    //                                  If this is an object, assume passing in a set of name/value
    //                                  pairs to register
    //  @param  argumentString (String) named arguments for the property in a comma separated string
    //                                  (not used if methodName is an object)
    // @see group:stringMethods
    //    @visibility external
    //<
    registerStringMethods : function (methodName, argumentString) {

        // If we haven't already done so, override the method argument registry
        // from the super class (otherwise we'll affect other classes with our changes)
        var registry = this._stringMethodRegistry;
        if (!this.isOverridden("_stringMethodRegistry")) {

            //if (registry._entries != null) {
            //    this.logWarn("Methods being registered on: " + this.Class +
            //                 " causing copy of superclass " + this._superClass.Class +
            //                 " registry");
            //}
            var registryClone = {},
                entries = registryClone._entries = (registry._entries ?
                                                    registry._entries.duplicate() : []);
            for (var i = 0; i < entries.length; i++) {
                registryClone[entries[i]] = registry[entries[i]];
            }
            this._stringMethodRegistry = registry = registryClone;
        }

        // If it's an object, rather than a string, assume it's a list of multiple methodName
        // to argument mappings to register at once.
        if (!isc.isA.String(methodName)) {
            var newMethods = methodName;

            // if it's not an object, bail - we don't know how to deal with this
            if (!isc.isAn.Object(newMethods)) {
                this.logWarn("registerStringMethods() called with a bad argument: " +
                             methodName);
                return false;
            }

            for (var methodName in newMethods) {
                registry[methodName] = newMethods[methodName]
                registry._entries.add(methodName);
            }

        } else {
            // in the registry, the distinction between null and undefined is important.
            // If the second parameter is currently undefined, set it to null
            // (this allows the second param. to be optional).
            if (argumentString == null) argumentString = null;

            registry[methodName] = argumentString;
            registry._entries.add(methodName);
        }

        // return true for success
        return true;
    },

    //> @classMethod Class.registerDupProperties() [A]
    // A common requirement in SmartClient development is to the ability have an attribute
    // be set to a "standard" type of object or array for every instance of a class.
    // <P>
    // An example might be a special subclass of TabSet which always shows a particular set
    // of tabs.<br>
    // In this case the most convenient approach would be to simply call
    // <P>
    // <code>setProperties({  tabs: <i>[array of standard tab object]</i> });</code>
    // <P>
    // However the developer does not want each instance he creates to point to <b>the same</b>
    // array of objects - instead each instance should have a separate array containing separate
    // objects with the same set of standard attributes.
    // <P>
    // This method provides an easy way to handle this case. By calling
    // +link{registerDupProperties()} the developer is notifying a class that every time
    // a new instance is generated via a call to +link{Class.create()}, the attribute
    // in question should be cloned onto the generated instance.
    // <P>
    // The <code>AutoChild</code> subsystem also respects registered properties for duplication.
    // When +link{class.addAutoChild()} or +link{class.createAutoChild()} is called, if
    // a property is set in the <code><i>autoChild</i>Defaults</code> block for the auto child,
    // that property will be cloned onto the instance rather than copied over by reference if
    // it's registered as a property for duplication via this method.
    // <P>
    // NOTE: This subsystem will only handle cloning simple javascript objects and arrays.
    // If an attribute name has been registered via this method, calling
    // <code>addProperties()</code> on the class object and passing in a live SmartClient
    // widget is not supported. If you need a standard SmartClient component to show up
    // in a class we recommend you use the +link{group:autoChildUsage,AutoChild subsystem} to
    // define a constructor and defaults for the widget and then set the attribute to
    // <code>"autoChild:<i>&lt;autoChildName&gt;</i>"</code>.
    //
    // @param attributeName (String)
    //    attribute name to register for duplication on instance creation for this class
    // @param [subAttributes] (Array of String)
    //    This parameter allows targetted support for deeper cloning.
    //    The issue is that for some attributes - for example sectionStack.sections, we know
    //    certain properties will also need cloning (sectionStack section.items).
    //    We want to use 'shallowClone()' to duplicate the objects on init rather than clone
    //    as clone is dangerous and can lead to stack overflow errors if the target happens
    //    to point to certain objects.
    //    Therefore allow developers to register properties of an attr value to also be
    //    cloned.
    //    To use this feature a developer would pass in an array of sub-properties
    //    as a second param (EG registerDupProperties("sections", ["items"]);
    // @visibility dupProperties
    //<
    registerDupProperties : function (attributeName, subAttributes) {


        if (this._dupAttrs == null || this._dupAttrs._className != this.getClassName()) {
            if (this._dupAttrs != null) {
                var dupAttrs = this._dupAttrs;
                this._dupAttrs = this._dupAttrs.duplicate();
                if (dupAttrs._subAttrs != null) {
                    this._dupAttrs._subAttrs = isc.shallowClone(dupAttrs._subAttrs);
                }
            } else {
                this._dupAttrs = [];
            }

            this._dupAttrs._className = this.getClassName();
        }
        if (!this._dupAttrs.contains(attributeName)) {
            this._dupAttrs.add(attributeName);
        }

        // support targetted deep-cloning.
        // (See JS Doc for subAttributes param)
        //
        // When given a sub attribute to explicitly dup, store it directly on the
        // registered dupAttrs array in an object of the format:
        // {attributeName:[ Array of sub attributes for cloning ] }
        if (subAttributes != null) {

            //this.logWarn("sub attribute! " + subAttr);

            var dupSubAttrs = this._dupAttrs._subAttrs || {};
            dupSubAttrs[attributeName] = subAttributes;

            this._dupAttrs._subAttrs = dupSubAttrs;
        }

    },

    //> @classMethod Class.isDupProperty()
    // Returns true if the specified attribute was registered as a property for duplication
    // at the instance level via +link{Class.registerDupProperties()}
    // @param attributeName
    // @visibility dupProperties
    //<
    isDupProperty : function (attributeName) {
        return this._dupAttrs != null && this._dupAttrs.contains(attributeName);
    },

    cloneDupPropertyValue : function (attributeName, value) {

        // We want to warn if the property is set to a Canvas instance which we can't readily
        // clone.
        // Explicitly catch arrays and run each entry through this method to also warn in the
        // case where we have an array containing live canvii.


        if (isc.isA.Array(value)) {
            var newArr = [];
            for (var i = 0; i < value.length; i++) {
                newArr[i] = this.cloneDupPropertyValue(attributeName, value[i]);
            }
            return newArr;
        }

        if (isc.Canvas && isc.isA.Canvas(value)) {
            this.logWarn("Default value for property '" + attributeName
                + "' is set to a live Canvas (with ID '"+value.getID()+"') at the Class or AutoChild-defaults level. "
                + "SmartClient cannot clone a live widget, so each instance of this "
                + "class may end up pointing to the same live component. "
                + "To avoid unpredictable behavior and suppress this warning, use the "
                + "AutoChild subsystem to set up re-usable default properties for sub-components.");
            return value;
        }

        var clonedVal = isc.shallowClone(value);

        // Support also cloning certain attribute values - see 'subAttrs' param of
        // registerDupProperties
        var dupArr = this._dupAttrs;
        if (dupArr._subAttrs != null && dupArr._subAttrs[attributeName] != null &&
            clonedVal != null)
        {
            //this.logWarn("iteratin?:" + dupArr._subAttrs[attributeName]);

            for (var i = 0; i < dupArr._subAttrs[attributeName].length; i++) {
                var subAttrName = dupArr._subAttrs[attributeName][i];
                //this.logWarn("Name:" + subAttrName + ", val:" + clonedVal[subAttrName]);
                if (clonedVal[subAttrName] != null) {
                    clonedVal[subAttrName] = isc.shallowClone(clonedVal[subAttrName]);
                }
            }
        }
        return clonedVal;
    },



    //>    @classMethod Class.evaluate()
    // Evaluate a string of script and return the result.
    // <P>
    // This method is a wrapper around the native javascript method <code>eval()</code>. It
    // papers over some native issues to ensure evaluation of script behaves consistently across
    // browsers
    //
    // @param expression (String) the expression to be evaluated
    // @param evalArgs (Object) Optional mapping of argument names to values - each key will
    //      be available as a local variable when the script is executed.
    // @return (Any) the result of the eval
    // @visibility external
    //<

    evaluate : function (expression, evalArgs, globalScope, hiddenIFrameEval, strictJSON, reviverFunction) {
        //!OBFUSCATEOK


        if (strictJSON) {
            //this.logWarn("is strict");
            return this.parseStrictJSON(expression, reviverFunction);
        }

        // Set a flag so we know an eval is executing

        if (!isc._evalRunning) isc._evalRunning = 0;
        isc._evalRunning ++;
        var returnVal;

        if (hiddenIFrameEval && isc.Browser.isIE && !globalScope && isc.Page.isLoaded()) {

            returnVal = this.evalInIFrame(expression, evalArgs);
        } else {
            //this.logWarn("args and stuff");


            if (evalArgs) {
                with (evalArgs) {
                    if (globalScope) returnVal = window.eval(expression)
                    else returnVal = eval(expression);
                }
            } else {
                if (globalScope) returnVal = window.eval(expression)
                else returnVal = eval(expression);
            }
        }

        // Decrement / clear the evalRunning flag

        if (isc._evalRunning != null) isc._evalRunning --;
        if (isc._evalRunning == 0) delete isc._evalRunning;
        return returnVal;
    },


    parseStrictJSON : function (script, reviverFunction, suppressNativeMethod, allowLoose) {

        var parseFunc;
        if (suppressNativeMethod || allowLoose || !isc.Browser._supportsJSONObject) {
            parseFunc = this.getJSONParseFunc();
        } else {
            parseFunc = window.JSON.parse;
        }
        return parseFunc(script, reviverFunction, allowLoose);
    },


    // Helper - create a JSON parsing function for browsers that don't natively
    // have support for JSON.parse
    // Note that this has the same restrictions on format as true JSON.parse() - otherwise
    // we'd have browser inconsistency over whether strict JSON response format was
    // required. We also will need to use the "reviver" function if specified to handle
    // custom conversions.
    _cx:/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,


    useHiddenFrameInJSONParseFunction:true,
    getJSONParseFunc : function () {

        if (this._jsonParseFunc) return this._jsonParseFunc;

        this.logInfo("No native JSON.parse() available in this browser." +
            " Creating strict JSON parsing function.", "jsonEval");


        var _this = this,
            cx = this._cx;

        this._walkFunc = function (holder, key, reviver, objRefs, objPath) {
            var undef;
            // The walk method is used to recursively walk the resulting structure so
            // that modifications can be made.

            var k, v, value = holder[key];
            // Don't drill into objects we know aren't simple JSON
            // window
            // isc
            // instance or class objects
            if (value && typeof value === 'object' && value != window &&
                value != window.isc && !isc.isA.Class(value) && !isc.isAn.Instance(value))
            {

                // Infinite loops can of course cause a crash here.
                // We already have logic to avoid this in the JSONEncoder class
                // so let's use the same approach.

                var alreadySeen = false;
                var prevPath = isc.JSONEncoder._serialize_alreadyReferenced(objRefs, value);
                if (prevPath != null && objPath.contains(prevPath)) {
                    var nextChar = objPath.substring(prevPath.length, prevPath.length+1);
                    //this.logWarn("backref: prevPath: " + prevPath + ", current: " + context.objPath +
                    //             ", char after prevPath: " + nextChar);
                    if (nextChar == "." || nextChar == "[" || nextChar == "]") {
                        alreadySeen = true;
                    }
                }
                if (!alreadySeen) {

                    isc.JSONEncoder._serialize_remember(objRefs, value, objPath);

                    for (k in value) {
                        if (Object.prototype.hasOwnProperty.call(value, k)) {
                            var objPath = isc.JSONEncoder._serialize_addToPath(objPath, k);
                            v = _this._walkFunc(value, k, reviver, objRefs, objPath);
                            if (v !== undef) {
                                value[k] = v;
                            } else {
                                delete value[k];
                            }
                        }
                    }
                }
            }
            return reviver.call(holder, key, value);
        };

        this._jsonParseFunc = function (text, reviver, loose) {
        //!OBFUSCATEOK

            // The parse method takes a text and an optional reviver function, and returns
            // a JavaScript value if the text is a valid JSON text.

            var j;

            // Parsing happens in four stages. In the first stage, we replace certain
            // Unicode characters with escape sequences. JavaScript handles many characters
            // incorrectly, either silently deleting them, or treating them as line endings.

            // Skip this if we're not enforcing script JSON format

            var invalidExpression = false;
            if (loose == null) loose = isc.Class._useLooseJSONParsePatch;
            if (!loose) {
                text = String(text);
                cx.lastIndex = 0;
                if (cx.test(text)) {
                    text = text.replace(cx, function (a) {
                        return '\\u' +
                            ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                    });
                }

                // In the second stage, we run the text against regular expressions that look
                // for non-JSON patterns. We are especially concerned with '()' and 'new'
                // because they can cause invocation, and '=' because it can cause mutation.
                // But just to be safe, we want to reject all unexpected forms.

                // Also skip this for the mode where we're not enforcing script JSON Format

                // We split the second stage into 4 regexp operations in order to work around
                // crippling inefficiencies in IE's and Safari's regexp engines. First we
                // replace the JSON backslash pairs with '@' (a non-JSON character). Second, we
                // replace all simple value tokens with ']' characters. Third, we delete all
                // open brackets that follow a colon or comma or that begin the text. Finally,
                // we look to see that the remaining characters are only whitespace or ']' or
                // ',' or ':' or '{' or '}'. If that is so, then the text is safe for eval.
                if (!(/^[\],:{}\s]*$/
                        .test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@')
                            .replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']')
                            .replace(/(?:^|:|,)(?:\s*\[)+/g, ''))) )
                {
                    invalidExpression = true;
                }
            }
            if (invalidExpression) {
                // If the text is not JSON parseable, then a SyntaxError is thrown.
                throw new SyntaxError('JSON.parse error');
            }

            // In the third stage we use the eval function to compile the text into a
            // JavaScript structure. The '{' operator is subject to a syntactic ambiguity
            // in JavaScript: it can begin a block or an object literal. We wrap the text
            // in parens to eliminate the ambiguity.

            // Note - we're evaluating in a hidden frame by default to avoid
            // IE9's memory leaks.
            // This should never lead to the classic "Can't execute code from a freed script"
            // javascript error since strict JSON will never directly create any
            // Date or function objects. (See comments around isc.RPCManager.allowIE9Leak
            // for more on that error).
            //
            // Exceptions
            // - In "loose" mode we may be parsing code which includes method calls etc, so
            //   don't attempt to evaluate in an iframe.
            // - Have a flag to disable trying to eval in an iframe in case we hit any
            //   edge cases that trip the JS error (or other issues such as performance
            //   concerns, etc)
            j = isc.eval('(' + text + ')',
                         !loose && isc.Class.useHiddenFrameInJSONParseFunction);

            // In the optional fourth stage, we recursively walk the new structure, passing
            // each name/value pair to a reviver function for possible transformation.
            return typeof reviver === 'function'
                ? _this._walkFunc({'':j}, '', reviver, {obj:[],path:[]}, "")
                : j;
        }

        return this._jsonParseFunc;
    },


    evalFrameResetInterval: 100,
    evalInIFrame : function (expression, evalArgs) {
        if (this.logIsDebugEnabled("iframeEval")) {
            this.logDebug("Using iframe for evaluation:\n" + expression, "iframeEval");
        }

        if (this.evalFrame == null || this._domain != document.domain) {
            this.makeEvalFrame();
        }

        if (this.evalFrame.evalCount > this.evalFrameResetInterval ||
            this.evalFrame.frame == null) {
            this.resetEvalFrame();
        }

        if (this.evalFrame.frame == null) this.logInfo("Temporarily unable to " +
            "evaluate in a HiddenFrame for domain " + document.domain + "; " +
            "falling back to a simpler evaluate that may leak memory");
        return this.evalFrame.frame == null ? this.evaluate(expression, evalArgs) :
                                      this.evalFrame.doEval(expression, evalArgs);
    },

    makeEvalFrame : function () {
        this.evalFrame = isc.HiddenFrame.create(this.evalFrameDefaults);
        // we'll rebuild if document.domain mismatches
        this._domain = document.domain;
        // Draw should be synchronous (not loading any content)
        this.evalFrame.draw();

        if (document.domain == location.hostname && this.evalFrame.getFrameDocument() == null)
        {
            var props = isc.addProperties({ location: isc.Page.getURL("[HELPERS]empty.html")},
                                          this.evalFrameDefaults);
            this.evalFrame = isc.HiddenFrame.create(props);
            this.evalFrame.draw();
        }
    },

    evalFrameDefaults: {
        useHtmlfile: false,
        doEval : function (expression, evalArgs) {
            this.evalCount++;
            return this.getHandle().doEval(expression, evalArgs);
        }
    },

    evalFrameHTML: [
                  "<html><body><script>" +
                  // Apply native object class extensions
                  "var nativeObjTypes = ['Array', 'String', 'Date'];",
                  "for (var i = 0; i < nativeObjTypes.length; i++) {" +
                    "var proto = window[nativeObjTypes[i]].prototype," +
                        "sourceProto = window.parent[nativeObjTypes[i]].prototype;" +
                  // Only attributes we've added are iterable, so just copy them
                  // across.
                    "for (var attr in sourceProto) {" +
                        "proto[attr] = sourceProto[attr];" +
                    "}" +

                  "}" +
                  // Copy ISC across so anything called directly from there is available
                  // here too.
                  "window.isc = window.parent.isc;" +

                  // Eval function to actually evaluate expression.
                  "function doEval(exp, args) {" +
                    "try{" +
                        // Use a try...catch block - if the eval fails, attempt in the main
                        // frame - there may have been an issue with scoping after all.
                        "if (args) {" +
                            "with (args) { " +
                                "return eval(exp);" +
                            "}" +
                        "} else {" +
                            "return eval(exp);" +
                        "}" +
                    "} catch (e) {" +
                        "window.parent.isc.Log.logInfo(" +
                            "'Attempt to evaluate in eval-frame threw error:' + e " +
                            "+ '. Attempting eval in main window.'," +
                            "'iframeEval');" +
                        "if (args) {" +
                            "with (args) { " +
                                "return window.parent.eval(exp);" +
                            "}" +
                        "} else {" +
                            "return window.parent.eval(exp);" +
                        "}" +
                    "}" +
                  "}" +
                  "</script></body></html>"
    ],

    resetEvalFrame : function () {
        if (this.logIsInfoEnabled("iframeEval")) {
            this.logInfo("Using iframe for evaluation - resetting iframe.", "iframeEval");
        }
        this.evalFrame.evalCount = 0;


        var frame = this.evalFrame.frame = this.evalFrame.getFrameDocument();
        if (frame != null) {
            frame.open();
            var domainString = this.evalFrame._domain ?
                "document.domain = '" + this.evalFrame._domain + "';" : "";
            frame.write(this.evalFrameHTML[0] + domainString + this.evalFrameHTML[1]);
            frame.close();
        } else {
            this.evalFrame._domain = document.domain;
        }
    },

    //>    @classMethod Class.addClassProperties()
    //
    //    Add static (Class-level) properties and methods to this object<br><br>
    //
    //    These properties can then be accessed as MyClass.property, or for functions, called as
    //  MyClass.methodName()
    //
    //    @param    [arguments 0-N] (Object)    objects with properties to add (think named parameters).
    //                                        all the properties of each argument will be applied
    //                                        as class-level properties.
    //  @return                 (Object)    the class after properties have been added to it
    //    @visibility external
    //<
    addClassProperties : function () {
        isc.addPropertyList(this, arguments);
        return this;
    },


    //> @classAttr Class.isFrameworkClass (boolean : varies : RWA)
    // Is this a core SmartClient class (part of the SmartClient framework)?
    // This attribute may be used for debugging, and by the AutoTest subsystem to
    // differentiate between SmartClient classes (part of the smartClient framework) and
    // subclasses created by specific applications
    // @setter Class.markAsFrameworkClass()
    // @visibility external
    // @group autoTest
    //<
    // Usually set at init time as part of ClassFactory.defineClass but we need to be able
    // to also set this at runtime for the cases where we replace core smartclient classes -
    // for example IButton

    //>    @classMethod Class.markAsFrameworkClass()
    // Mark this class as a framework class (member of the SmartClient framework).
    // Sets +link{Class.isFrameworkClass}. May be used in debugging and by the
    // AutoTest subsystem
    // @visibility external
    // @group autoTest
    //<
    markAsFrameworkClass : function () {
        this.isFrameworkClass = true;
        this._instancePrototype.isFrameworkClass = true;
        this._scClass = this.Class;
        this._instancePrototype._scClass = this.Class;
    },

    //>    @classMethod Class.addProperties()
    //
    //    Add default properties and methods to all instances of this class.<br><br>
    //
    //    These properties can then be accessed as <code>myInstance.property</code>,
    //  and methods can be called via <code>myInstance.methodName()</code>
    //
    //    @param    [arguments 0-N] (Object)    objects with properties to add (think named parameters).
    //                                        all the properties of each argument will be applied
    //  @see Class.addProperties()
    //  @see isc.addProperties()
    //                                        as instance-level property defaults.
    //  @return                 (Object)    the class after properties have been added to it
    //    @visibility external
    //<
    _deferredDefaults : {},
    addProperties : function () {

        if (this._isInterface) {
            this.logWarn("Use addInterfaceProperties() to add methods to interface " + this);
        }
        isc.addPropertyList(this._instancePrototype, arguments, true);
        return this;
    },

    //>    @classMethod Class.addPropertyList()
    //
    //    Add default properties to all instances of this class
    //
    //    @param    list (Array of Object[])        array of objects with properties to add
    //  @return      (Object)       the class after properties have been added to it
    //
    //    @visibility external
    //<
    addPropertyList : function (list) {
        isc.addPropertyList(this._instancePrototype, list, true);
        return this;
    },

    //> @classMethod Class.changeDefaults() (A)
    //
    // Changes a set of defaults defined as a JavaScript Object.  For these kind of properties,
    // simply calling +link{Class.addProperties()} would replace the original Object
    // with yours, wiping out settings required for the basic functionality of the component.
    // This method instead applies your overrides over the existing properties, without
    // destroying non-overridden properties.
    // <p>
    // For example let's say you have a component that's defined as follows
    // <pre>
    // isc.defineClass("MyComponent");
    // isc.MyComponent.addProperties({
    //     simpleProperty: "some value",
    //     propertyBlock : {
    //       foo: "bar",
    //       zoo: "moo"
    //     }
    // }
    // </pre>
    // If you wanted to override simpleProperty, you can just call +link{Class.addProperties()}
    // like this:
    // <pre>
    // isc.MyComponent.addProperties({
    //     simpleProperty: "my override"
    // });
    // </pre>
    // If you want to override the value of <code>propertyBlock.moo</code> above,
    // but you don't want to clobber the value of <code>propertyBlock.zoo</code>.  If you use
    // the above pattern like so:
    // <pre>
    // isc.MyComponent.addProperties({
    //     propertyBlock: {
    //         foo: "new value",
    //         zoo: "moo"
    //     }
    // });
    // </pre>
    // You need to re-specify the value of <code>propertyBlock.zoo</code> which you didn't want
    // to override.  Failing to re-specify it would destroy the value.
    // <p>
    // Instead of re-specifying the value, you can use this method to modify the value of
    // <code>foo</code> - like this:
    // <pre>
    // isc.MyComponent.changeDefaults("propertyBlock", {
    //     foo: "new value"
    // });
    // </pre>
    // <p>
    // See also the +link{AutoChild} system for information about standard sets of defaults
    // that are available for customization.
    //
    // @param defaultsName (String) name of the property to change
    // @param newDefaults (Object) overrides for defaults
    //
    // @visibility external
    //<
    changeDefaults : function (defaultsName, newDefaults) {
        // get existing defaults
        var defaults = this._getDefaults(defaultsName),
            mustAssign = false;

        // if we have a superclass with the same defaults, copy them so the superclass is not
        // affected
        var mySuper = this.getSuperClass();
        if (mySuper) {
            var superDefaults = mySuper._getDefaults(defaultsName);
            if (superDefaults != null && superDefaults == defaults) {
                //this.logWarn("copying defaults for property: " + defaultsName +
                //             " on class: " + this);
                defaults = isc.addProperties({}, defaults);
                mustAssign = true;
            }
        }

        // if defaults don't exist, create an empty object for them
        if (defaults == null) {
            defaults = newDefaults || {};
            mustAssign = true;
        } else {
            // otherwise add the specified defaults to the existing defaults
            isc.addProperties(defaults, newDefaults);
        }

        // if we created a new defaults object (because there were no existing defaults, or we
        // had to duplicate a superclass' defaults) override the slot on this class
        if (mustAssign) {
            //this.logWarn("had to assign when overriding property: " + defaultsName +
            //             " on class: " + this);
            var props = {};
            props[defaultsName] = defaults;
            this.addProperties(props);
        }
    },

    _getDefaults : function (defaultsName) {
        var deferredDefaults = this._deferredDefaults[this.Class],
            defaults = this.getInstanceProperty(defaultsName, true) ||
                        (deferredDefaults ? deferredDefaults[defaultsName] : null);
        return defaults;
    },

    // backcompat: briefly exposed as visibility external in 5.5 beta builds
    replaceDefaults : function (defaultsName, newDefaults) {
        this.changeDefaults(defaultsName, newDefaults);
    },

    //>    @classMethod Class.setProperties()
    //    Apply a set of properties to a class object, calling the appropriate setter class methods if
    //    any are found.
    //
    //    @param    [arguments 0-N] (Object)    objects with properties to add (think named parameters).
    //                                        all the properties of each argument will be applied one after another
    //                                        so later properties will override
    //    @visibility external
    //<
    setProperties : function () {

        var propertyBlock;

        // If passed multiple arguments, combine them down to a single object.
        // (Step required as setProperties() on this instance prototype doesn't take an array,
        // and we don't know how many arguments we have).
        if (arguments.length == 1) {
            propertyBlock = arguments[0];
        } else {
            propertyBlock = {};

            for (var i = 0; i < arguments.length; i++) {
                isc.addProperties(propertyBlock, arguments[i]);
            }
        }

        // set properties on the instance prototype
        this._instancePrototype.setProperties(propertyBlock);
    },

    //>    @classMethod Class.isOverridden()
    //    Determine whether we've overridden a specified class property or method from our superClass
    //
    //    @param    property    (String)    property to check
    //
    //  @return             (boolean)   true if the property has been overridden
    //<
    isOverridden : function (property) {
        // XXX Note - need another function to check for a class overriding the properties of the
        // instance prototype
        return (!(this[property] === this._superClass[property]));
    },

    //> @classMethod Class.isA()
    //
    // Returns whether this class object is the provided class or is a subclass of the provided
    // class, or implements the provided interface.
    //
    // @param  className (String)        Class name to test against
    //
    // @return           (boolean)       true == this Class is a subclass of the provided classname
    // @visibility external
    //<
    isA : function (className) {
        if (className == null) return false;

        // handle being passed Class Objects and instances of classes
        if (!isc.isA.String(className)) {
            className = className.Class;
            if (!isc.isA.String(className)) return false;
        }

        if (isc.startsWith(className, isc.ClassFactory._$iscPrefix)) {
            className = className.substring(4);
        }
        // walk the class object inheritance chain
        var superClass = this;
        while (superClass) {
            if (superClass.Class == className) return true;

            if (superClass._implements && superClass._implements.contains(className)) return true;

            superClass = superClass._superClass;
        }

        return false;
    },

    _getNextImplementingSuper : function (methodCallingSuper, superClassProto, methodName,
                                          staticSuper)
    {
        var superClassImpl;
        for (;;) {
            if (superClassProto == null) {
                // no superclass provides a differing implementation - error
                superClassImpl = null;
                break;
            }


            var superClassImpl = isc.Class._getOriginalMethod(methodName, superClassProto);

            // function is not defined in any superclass further up the chain - error
            if (superClassImpl == null) break;

            // found a superclass implementation that differs - success!
            if (methodCallingSuper != superClassImpl) {
                //this.logWarn("found differing superClass implementation: " +
                //             this.echoLeaf(superClassImpl) +
                //             " on prototype: " + superClassProto);
                break;
            }

            // go up the chain to the prototype of the superClass
            if (staticSuper) {
                superClassProto = superClassProto._superClass;
            } else {
                superClassProto = superClassProto._classObject._superClass._instancePrototype;
            }
        }
        if (superClassImpl != null) return superClassProto;
        return null;
    },

    //>    @classMethod Class.Super()
    //
    //    Call the SuperClass implementation of a class method.
    //
    //    @param methodName   (String)    name of the superclass method to call
    //    @param args         (Arguments | Array) native "arguments" object, or array of
    //                                          arguments to pass to the Super call
    //    @param [nativeArgs] (Arguments) native "arguments" object, required if an Array is
    //                                  passed for the "args" parameter in lieu of the native
    //                                  arguments object
    //
    //    @return                    (Any)        return value of the superclass call
    //
    // @visibility external
    //<

    Super : function (methodName, args, nativeArguments) {
        if (isc._traceMarkers) arguments.__this = this;

        // see Class.duplicateMethods() - Super is dup'd once at init, then dup'd on the fly
        // each time it's called so that recursive super calls on the same instance can be
        // traced through
        if (this.autoDupMethods && isc.isAn.Instance(this)) {
            this.duplicateMethod("Super");
        }

        // if args is clearly not an Array or Arguments object, make it an Array.  NOTE: you
        // can still fool us by passing an object with a .length property which is neither an
        // Array or Arguments object - to avoid this we'd have to be able to reliably
        // cross-platform tell the difference between an Arguments object and a normal Object.
        // The simplest way to do this would probably be to check the callee property, which is
        // very unlikely to be set to a function on some random object being passed as params.
        if (args != null && (args.length == null || isc.isA.String(args))) args = [args];

        if (args == null) args = isc._emptyArray;


        this._nativeArguments = nativeArguments || args;
        this._argsToSuper = args;
        //if (nativeArguments == null && nativeArguments != false && args && args.constructor &&
        //    args.constructor.nativeType == 2)
        //{
        //    this.logWarn("substitute arguments passed, but native arguments object " +
        //                 "not passed as third parameter");
        //}

        // overall plan: look through the inheritance chain for a method that differs from the
        // implementation in this instance, and call that

        // get the prototype for the last method of this name that called Super().  Null for
        // the first call to Super
        this._lastProto = isc.Class._getLastProto(methodName, this);
        // set flag to tell invokeSuper it's being called by external Super and needs to pick
        // up extra arguments from instance flags
        this._externalSuper = true;

        return this.invokeSuper(null, methodName);
    },


    _delayedSuper : function (methodName, args, nativeArguments, delay, delayUnits) {
        if (args != null && (args.length == null || isc.isA.String(args))) args = [args];

        if (args == null) args = isc._emptyArray;

        nativeArguments = nativeArguments || args;
        var argsToSuper = args;
        var lastProto = isc.Class._getLastProto(methodName, this);

        var self = this;
        return isc.Timer.setTimeout(function () {
            if (isc._traceMarkers) arguments.__this = self;

            if (self.autoDupMethods && isc.isAn.Instance(self)) {
                self.duplicateMethod("Super");
            }

            self._nativeArguments = nativeArguments;
            self._argsToSuper = argsToSuper;
            self._lastProto = lastProto;
            self._externalSuper = true;

            self.invokeSuper(null, methodName);
        }, delay, delayUnits);
    },

    // observation and timers may replace a function with a generated function, storing the
    // original function in another slot.  We need to find the original function because
    // otherwise, when we look up the superclass chain to find a differing implementation, we'd
    // be using the auto-generated function, and so think all superclasses had differing
    // implementations.
    // Note that both observation and timing indirects can be installed on classes as well as
    // instances.
    _getOriginalMethod : function (methodName, theProto) {
        var method = theProto[methodName];

        while (method != null && method._origMethodSlot) {
            //this.logWarn("indirect installed on: " + theProto + ": " + this.echoLeaf(method));
            method = theProto[method._origMethodSlot];
        }


        if (method != null && method._originalMethod != null) method = method._originalMethod;

        return method;
    },

    // high speed implementation of Super used by internal callers, where the class and method
    // of the calling function are directly passed in.  Calls to external Super can be freely
    // mixed with calls to invokeSuper because they store the same state.
    //
    // Extremely critical path code sometimes calls Super like so:
    //    isc.StatefulCanvas._instancePrototype.initWidget.call(this);
    // This is safe only if there are no calls to external Super() in any superclass
    // implementations.  If there are, with the lack of any stored lastProto, inter-recursion
    // will be falsely detected and the leaf implementation will be called.
    invokeSuper : function (clazz, methodName, a,b,c,d,e,f,g,h,i,j,lastArg) {

        if (this.autoDupMethods && isc.isAn.Instance(this)) {
            this.duplicateMethod("invokeSuper");
        }

        // static mode (class methods calling Super)
        var staticSuper = this._isClassObject;


        var externalSuper = this._externalSuper;
        this._externalSuper = null;
        var nativeArguments = this._nativeArguments;
        this._nativeArguments = null;
        var argsToSuper = this._argsToSuper;
        this._argsToSuper = null;


        var lastProto;
        if (externalSuper) {
            lastProto = this._lastProto;
            this._lastProto = null;
        } else {
            // for framework code calling invokeSuper, null indicates instance override
            if (clazz != null) {
                // in static mode, protos are class objects
                lastProto = staticSuper ? clazz : clazz._instancePrototype;
            }
        }

        // figure out the method that is calling Super in order to compare the implementation
        // against superclass implementation to find out when a superclass implementation differs
        var methodCallingSuper, nextProto;
        if (lastProto == null) {

            methodCallingSuper = isc.Class._getOriginalMethod(methodName, this);

            // in static mode, there's no such thing as an instance override
            nextProto = staticSuper ? this : this.getPrototype();
            //if (methodName == "draw") {
            //    this.logWarn("new Super call, method calling super: " +
            //                 this.echoLeaf(methodCallingSuper));
            //}
        } else {

            methodCallingSuper = isc.Class._getOriginalMethod(methodName, lastProto);

            if (staticSuper) {
                // static mode - get superclass classObject
                nextProto = lastProto._superClass;
            } else {
                // instance mode - get superclass instancePrototype
                nextProto = lastProto._classObject._superClass._instancePrototype;
            }


            if (nativeArguments && nativeArguments.callee != null &&
                nativeArguments.callee != methodCallingSuper)
            {
                //this.logWarn("recursion detected: to continue current super chain caller" +
                //             " should be: " + this.echoLeaf(methodCallingSuper) +
                //             " but caller is: " + this.echoLeaf(nativeArguments.callee));
                methodCallingSuper = isc.Class._getOriginalMethod(methodName, this);
                nextProto = staticSuper ? this : this.getPrototype();
            }
        }

        // count all calls to externalSuper
        //if (externalSuper) {
        //    var callCounts = isc._superCallCount = isc._superCallCount || [],
        //        fullName = isc.Func.getName(methodCallingSuper);
        //
        //    var record = callCounts.find("fullName", fullName);
        //    if (record) record.callCount++;
        //    else callCounts.add({fullName:fullName, callCount:1});
        //}

        //this.logWarn("methodCallingSuper: " + this.echoLeaf(methodCallingSuper) +
        //             ", lastProto: " + lastProto +
        //             ", nextProto: " + nextProto);

        // find the next superclass implementation
        nextProto = isc.Class._getNextImplementingSuper(methodCallingSuper, nextProto,
                                                        methodName, staticSuper);

        if (nextProto == null) {
            // failed to find a superclass implementation
            if (isc.Log) isc.Log.logWarn("Call to Super for method: " + methodName +
                                         " failed on: " + this +
                                         ": couldn't find a superclass implementation of : " +
                                         (lastProto ? lastProto.Class : this.Class) +
                                         "." + methodName +
                                         this.getStackTrace());
            return null;
        }

        // we found a superclass implementation
        var superClassImpl = nextProto[methodName];

        //if (methodName == "draw") {
        //    this.logWarn("about to call: " + this.echoLeaf(superClassImpl) +
        //                 ", call chain: " + superCallChains);
        //}


        isc.Class._addProto(methodName, nextProto, this);

        // NOTE: it's normal that we're invoke an indirect (an observation or timer for
        // instance), which will invoke the original method for us - it's just when comparing
        // methods that we have to avoid using the indirects
        //if (superClassImpl._origMethodSlot) {
        //    this.logWarn("invoking indirect: " + this.echoLeaf(superClassImpl) +
        //                 " found on prototype: " + nextProto);
        //}

        // call the superclass implementation on "this"
        var returnVal;
        if (externalSuper) {
            // for external callers, use apply() in order to preserve arguments.length just in
            // case external code contains a function that uses arguments.length and gets
            // called as Super
            if (argsToSuper != null || nativeArguments != null) {
                returnVal = superClassImpl.apply(this, argsToSuper == null ?
                                                       nativeArguments : argsToSuper);
            } else {
                returnVal = superClassImpl.apply(this);
            }
        } else {


            returnVal = superClassImpl.call(this, a,b,c,d,e,f,g,h,i,j);
        }

        isc.Class._clearLastProto(methodName, this);

        // and return the value returned from the apply
        return returnVal;
    },

    _getLastProto : function (methodName, obj) {
        var superCalls = obj._superCalls,
            protoList = superCalls == null ? null : superCalls[methodName];

        //this.logWarn("for method: " + methodName + " chain is: " + protoList);

        if (isc.isAn.Array(protoList)) return protoList.last();
        return protoList;
    },

    _clearLastProto : function (methodName, obj) {
        var superCalls = obj._superCalls,
            protoList = superCalls[methodName];
        if (protoList == null) {

            return;
        }
        // clear single item
        if (!protoList.__isArray) {

            superCalls[methodName] = null;
        } else {
            // shorten array, then remove if zero length
            protoList.length = Math.max(0, protoList.length-1);
            if (protoList.length == 0) superCalls[methodName] = null;
        }
    },

    _addProto : function (methodName, newProto, obj) {
        var superCalls = obj._superCalls = obj._superCalls || {},
            protoList = superCalls[methodName];
        if (protoList == null) {
            superCalls[methodName] = newProto;
        } else {
            if (isc.isAn.Array(protoList)) protoList.add(newProto);
            else {
                superCalls[methodName] = [protoList, newProto];

                superCalls[methodName].__isArray = true;
            }
        }
    },

    //>    @classMethod Class.map()
    //
    // Call <code>method</code> on each item in <code>argsList</code> and return the Array of results.
    //
    //    @param    methodName (String)
    //      Name of the method on this instance which should be called on each element of the Array
    //    @param    items      (Array)
    //      Array of items to call the method on
    //
    //    @return            (Array) Array of results, one per element in the passed "items" Array
    // @visibility external
    //<
    map : function (methodName, items, arg1, arg2, arg3, arg4, arg5) {
        if (methodName == null) return items;
        var results = [];
        for (var i = 0; i < items.length; i++) {
            results.add(this[methodName](items[i], arg1, arg2, arg3, arg4, arg5));
        }
        return results;
    },

    //>    @classMethod Class.getInstanceProperty()
    //
    //    Gets a named property from the instance defaults for this object.
    //
    //    @param property    (String)    name of the property to return
    // @visibility external
    //<
    getInstanceProperty : function (property, skipInit) {

        if (!this.initialized() && !skipInit) this.init();

        var value = this._instancePrototype[property];

        return value;
    },

    //>    @classMethod Class.setInstanceProperty()
    //
    //    Sets a named property from the instance defaults for this object.
    //
    //    @param property    (String)    name of the property to return
    //    @param value    (Any)        value to set to
    // @visibility external
    //<
    setInstanceProperty : function (property, value) {
        this._instancePrototype[property] = value;
    },

    getArgString : function (methodName) {
        // check for a string method definition
        var argString = this._stringMethodRegistry[methodName];
        var undef;
        if (argString !== undef) return argString || isc.emptyString;

        // get the arguments from the method definition (very very slow!)
        var method = this.getInstanceProperty(methodName);
        //if (method == null || !isc.isA.Function(method)) return "";
        if (method == null) return "";
        return isc.Func.getArgString(method);
    },

    // Callbacks and eval()ing
    // ---------------------------------------------------------------------------------------

    //> @type Callback
    // A <code>Callback</code> is an arbitrary action to be fired - usually passed into a
    // method to be fired asynchronously as a notificaction of some event.<br>
    // The <code>callback</code> can be defined in the following formats:<ul>
    // <li>a function</li>
    // <li>A string containing an expression to evaluate</li>
    // <li>An object with the following properties:<br>
    //     - target: fire in the scope of this target - when the action fires,
    //       the target will be available as <code>this</code>.<br>
    //     - methodName: if specified we'll check for a method on the target object with this
    //       name.<br>
    //  </li></ul>
    // <code>Callbacks</code> are fired via the +link{classMethod:Class.fireCallback()} method, which allows
    // named parameters to be passed into the callback at runtime. If the Callback was specified
    // as a string of script, these parameters are available as local variables at eval time.<br>
    // For specific SmartClient methods that make use of <code>Callback</code> objects, see
    // local documentation for information on parameters and scope.
    // @visibility external
    //<


    //>    @classMethod    Class.fireCallback()
    //
    // Fire some arbitrary action specified as a +link{type:Callback}.
    // Returns the value returned by the action.
    //
    // @param callback (Callback) Action to fire.
    // @param [argNames] (String) Comma separated string of variable names. If the callback
    //                            passed in was a string of script, any arguments passed to the
    //                            callback will be available as local variables with these names.
    // @param [args] (Array)    Array of arguments to pass to the method. Note that the number
    //                          of arguments should match the number of argNames.
    // @param [target] (Object) If specified the callback will be evaluated in the scope of this
    //                          object - the <code>this</code> keyword will be a pointer to this
    //                          target when the callback is fired.
    // @return (Any)   returns the value returned by the callback method passed in.
    // @visibility external
    //<

    fireCallback : function (callback, argNames, args, target, catchErrors) {
        arguments.__this = this;
        if (callback == null) return;


        var undef;
        if (argNames == null) argNames = undef;

        var method = callback;
        if (isc.isA.String(callback)) {
            // callback specified as the name of a method on a known target
            if (target != null && isc.isA.Function(target[callback])) method = target[callback];
            // callback is a String expression
            else method = this._makeCallbackFunction(callback, argNames);

        } else if (isc.isAn.Object(callback) && !isc.isA.Function(callback)) {

            // If this is a Process or Action (see Workflow.js), hand off to
            // 'expressionToFunction'
            var isSimpleCallback = true;
            var _constructor = callback._constructor;
            if (_constructor != null) {
                _constructor = isc.ClassFactory.getClass(_constructor);
            }
            if (_constructor != null && _constructor.isA && _constructor.isA("ProcessElement"))
            {
                isSimpleCallback = false;
            } else if (isc.isA.String(callback.target) && callback.name != null) {
                isSimpleCallback = false;
            }
            if (!isSimpleCallback) {
                method = isc.Func.expressionToFunction(argNames, callback);
            } else {
            // Object containing (possibly) target, and either methodName or action to fire

                if (callback.caller != null) target = callback.caller;
                else if (callback.target != null) target = callback.target;

                // Pick up arguments from the callback directly, if passed that way.
                if (callback.args) args = callback.args;
                if (callback.argNames) argNames = callback.argNames;

                if (callback.method) method = callback.method;


                else if (callback.methodName && target != null) method = target[callback.methodName];
                else if (callback.action)
                    method = this._makeCallbackFunction(callback.action, argNames);
            }
        }

        // At this point the target (if one was passed in) is available under 'target', and
        // we've converted the callback to a function, if possible.
        if (!isc.isA.Function(method)) {
            this.logWarn("fireCallback() unable to convert callback: " + this.echo(callback) +
                         " to a function.  target: " + target + ", argNames: " + argNames +
                         ", args: " + args);
            return;
        }

        // If no target was specified, fire it in the global scope

        if (target == null) target = window;
        // If the target has been destroyed, abort!
        else if (target.destroyed) {
            // NOTE: this isn't a warning scenario: destruction is normal, and callbacks are
            // commonly timers to do visual refreshes which don't matter if a component is
            // destroyed
            if (this.logIsInfoEnabled("callbacks")) {
                this.logInfo("aborting attempt to fire callback on destroyed target:"+ target +
                             ". Callback:"+ isc.Log.echo(callback) +
                              ",\n stack:" + this.getStackTrace());
            }
            return;
        }

        // this causes anonymous callback functions to be labelled "callback" in stack traces.
        // Non-anonymous callbacks still show their usual name
        method._isCallback = true;

        if (args == null) args = [];



        if (isc.enableCrossWindowCallbacks && isc.Browser.isIE) {
            var targetWindow = target.constructor ? target.constructor._window : target;
            if (targetWindow && targetWindow != window && targetWindow.isc) {
                var newArgs = targetWindow.Array.newInstance();
                for (var i = 0; i < args.length; i++) newArgs[i] = args[i];
                args = newArgs;
            }
        }

        var returnVal;

        if ((!catchErrors && !isc.Log.rethrowErrors) || isc.Log.supportsOnError) {
            returnVal = method.apply(target, args);
        } else {
            try {
                returnVal = method.apply(target, args);
            } catch (e) {
                if (catchErrors) isc.Log._reportJSError(e);
                else             isc.Log._onRethrowError(e);

                throw e;;
            }
        }

        return returnVal;
    },

    //> @classMethod Class.delayCall()
    //  This is a helper to delay a call to a method on some target by a specified
    //  amount of time.  Can be used to delay a call to a static method on this class by
    //  omitting the <code>target</code> parameter.
    // @param methodName (String) name of the method to call
    // @param [arrayArgs] (Array) array of arguments to pass to the method in question
    // @param [time] (number) Number of ms to delay the call by - defaults to zero (so just pulls
    //                        execution of the method out of the current execution thread.
    // @param [target] (Object) Target to fire the method on - if unspecified assume this is
    //                          a call to a classMethod on this Class.
    // @return (String) Timer ID for the delayed call - can be passed to
    //                      +link{Timer.clear()} to cancel the call before it executes
    // @visibility external
    //<
    delayCall : function (methodName, arrayArgs, time, target) {
        if (target == null) target = this;
        if (time == null) time = 0;

        return isc.Timer.setTimeout({target:target, methodName:methodName, args:arrayArgs}, time);
    },


    _makeCallbackFunction : function (callback, argNames) {


        //return isc.Func.expressionToFunction(argNames, callback);

        if (argNames == null) {
            var undef;
            argNames = undef;
        }
        var func = isc._makeFunction(argNames, callback);
        func._showBodyInTrace = true;
        return func;
    },

    // Fire on Pause
    // ---------------------------------------------------------------------------------------

    //> @classMethod Class.fireOnPause()
    // Given some repeatedly performed event (EG keypress, scroll, etc), set up an action
    // to fire when the events have stopped occurring for some set period.
    // @param id (String) arbitrary identifier for the action
    // @param callback (Callback) action to fire on quiescence
    // @param [delay] (number) delay in ms - defaults to 200ms
    // @param [target] (Object) if passed, the callback will be fired in this target's scope
    // @param [instanceID] (String) passed from instance method to support instance-level IDs
    // @param [predicate] (Function) if provided, is evaluated whenever the callback is ready
    //                    to fire; callback will be rescheduled if predicate evaluates false
    //<
    fireOnPauseDelay:200,
    _$_fireActionsOnPause:"_fireActionsOnPause",
    _actionsOnPause:{},
    _actionOnPauseTimers:{},
    fireOnPause : function (id, callback, delay, target, instanceID, predicate) {

        if (!id) return;
        if (!delay) delay = this.fireOnPauseDelay;
        // If unset, default to this.getClassName() [not legal to have any instance with the
        // same ID as a SmartClient class].
        if (instanceID == null) instanceID = this.getClassName();

        // class _fireOnPause on the Class object

        return isc.Class._fireOnPause(id, predicate ? function () {
            if (isc.Class.fireCallback(predicate, null, null, target)) {
                isc.Class.fireCallback(callback,  null, null, target);
            } else isc.Class.fireOnPause(id, callback, delay, target, instanceID, predicate);
        } : callback, delay, target, instanceID);
    },

    _fireOnPause : function (id, callback, delay, target, instanceID) {

        // Note: If we have two separate instances calling the fireOnPause instance method with
        // the same ID, both actions need to fire -- the ID is essentially unique within the
        // instance only.
        // We use the instanceID parameter to create separate callbacks for the same ID used
        // on different instances.

        if (!this._actionsOnPause[id]) {
            this._actionsOnPause[id] = {};
        }

        this._actionsOnPause[id][instanceID] =
            {fireTime:delay, callback:callback, target:target};

        var stamp = isc.timeStamp(),
            elapsed = this._lastFireOnPause ? stamp - this._lastFireOnPause : null;
        this._lastFireOnPause = stamp;

        // If we're going to fire queue of actions before the delay passed in, we're done
        // Check for this._fireActionsOnPauseRunning -- if a callback from an existing
        // 'fireOnPause' sets up a new 'fireOnPause' we need to set a timer to execute it
        // as a separate flow.
        if (!this._fireActionsOnPauseRunning &&
            elapsed && this._fireOnPauseDelay != null &&
            delay >= (this._fireOnPauseDelay - elapsed))
        {
            return;
        }
        if (this._fireOnPauseTimer) isc.Timer.clearTimeout(this._fireOnPauseTimer);
        this._fireOnPauseTimer = this.delayCall(this._$_fireActionsOnPause,null, delay);

        this._fireOnPauseDelay = delay;
    },

    _fireActionsOnPause : function () {
        this._fireActionsOnPauseRunning = true;
        var fireAgainTime;
        // In theory this._fireOnPausedDelay ms have elapsed since the call to fireOnPause
        // (or the last call to this method).
        // In practice it's probably more accurate to check the elapsed time by comparing
        // timestamps
        var elapsed = isc.timeStamp() - this._lastFireOnPause,
            fireAgainTime;
        for (var id in this._actionsOnPause) {
            var actions = this._actionsOnPause[id];
            // Get the timer-id's now so if any callback sets up a new fireOnPause
            // and changes the 'actions' object we won't worry about it as part of this flow
            var iids = isc.getKeys(actions);
            for (var i = 0; i < iids.length; i++) {
                var iid = iids[i];
                var action = actions[iid];
                if (action.fireTime <= elapsed) {
                    // Wipe the action off the actions object before firing the callback
                    // in case the callback sets up a new fireOnPause with the same ID.
                    delete this._actionsOnPause[id][iid];
                    this.fireCallback(action.callback, null, null, action.target);
                } else {
                    action.fireTime -= elapsed;
                    if (fireAgainTime == null) fireAgainTime = action.fireTime;
                    else fireAgainTime = Math.min(fireAgainTime, action.fireTime);
                }
            }
            if (isc.isAn.emptyObject(this._actionsOnPause[id])) delete this._actionsOnPause[id];
        }
        if (fireAgainTime != null) {
            this._fireOnPauseDelay = fireAgainTime;
            this._lastFireOnPause = isc.timeStamp();
            this.delayCall(this._$_fireActionsOnPause, null, fireAgainTime);
        } else {
            this._fireOnPauseDelay = null;
            this._lastFireOnPause = null;
        }
        this._fireActionsOnPauseRunning = null;

    },

    // Eval() wrappers including globals capture
    // ---------------------------------------------------------------------------------------

    //>    @classMethod    Class.evalWithVars()
    //
    // Evaluates the given string with an arbitrary number of arguments on the specified target.
    // evalVars and target are optional.
    //
    // @param   evalString  the string to evaluate
    // @param   evalVars    Map of key-value pairs.  The keys are treated as argument names that are
    //                      then made available inside the eval body as variables.  The values of
    //                      these variables are the values assigned to the keys in evalVars.
    // @param   target      the target on which to apply the eval - it will be available as the
    //                      'this' variable inside the eval block.  If not specified, the evalString
    //                      is evaluated in global context.
    // @return  (Any)       returns the result of eval(evalString)
    //<
    useFastEvalWithVars : isc.Browser.isMoz && isc.Browser.geckoVersion >= 20061010,
    evalWithVars : function (evalString, evalVars, target) {
        //!OBFUSCATEOK
        // if no target specified, eval in global scope
        if (!target) target = window;


        if (this.useFastEvalWithVars) {
            return this.evaluate.call(target, evalString, evalVars);
        }

        // create two arrays of the keys and values of the evalVars map
        var evalStringVarName = "_1";
        // Ensure that we don't step on any of the vars passed in in the evalVars object
        while (evalVars && isc.propertyDefined(evalVars, evalStringVarName)) {
            evalStringVarName += "1"
        }
        var argNames = [evalStringVarName];
        var argValues = [evalString];
        if (evalVars) {
            for (var argName in evalVars) {
                argNames.push(argName);
                argValues.push(evalVars[argName]);
            }
        }

        // make a function with argNames as arguments that evals evalString

        var theFunc = isc._makeFunction(argNames.join(","),
                                        "return eval(" + evalStringVarName + ")");

        // call the function on the target
        return theFunc.apply(target, argValues);
    },

    // calls evalWithVars(jsSrc, evalVars, target), and returns all globals created via
    // addGlobalID().  All other non-explicit globals are captured by the function body that's
    // created around the jsSrc.
    evalWithCapture : function (jsSrc, evalVars, target) {
        var globals = isc.globalsSnapshot = [];
        //
        // we need to create a function with the jsSrc as the body to avoid creating extraneous
        // globals - conveniently evalWithVars already does this for us.
        this.evalWithVars(jsSrc, evalVars, target);
        isc.globalsSnapshot = null;
        return globals;
    },

    // takes a list of global IDs and destroys them
    destroyGlobals : function (globals) {
        // avoid setting `undefined' to `null' in IE6, 7, and 8
        if (globals == null) return;

        if (!isc.isAn.Array(globals)) globals = [globals];

        for (var i = 0; i < globals.length; i++) {
            var global = globals[i];

            var val = window[global];
            // if the value is not already null (or a logical false value such as undefined)
            if (val) {
                // call destroy() on the global if it's defined
                if (isc.isA.Function(val.destroy)) val.destroy();
                else window[global] = null; // otherwise just null out the global ref
            }
        }
    },

    // Provides 'true' global eval - i.e. global vars actually stick to the window object when
    // eval'd in this manner vs a plain eval() which does not do that.
    //
    // Note: the eval logic here (separate approaches to actually perform the eval per browser)
    // duplicates FileLoader.delayedEval() - if you change this code, be sure to update that
    // method.
    // reportErrors optional param defaults to true
    globalEvalWithCapture : function (evalString, callback, evalVars, reportErrors) {

        if (reportErrors == null) reportErrors = true;
        //!OBFUSCATEOK

        // store these on these object - really for Safari's benefit, since it's the only one
        // requiring async execution.  This makes the Safari case below easier.
        this._globalEvalVars = evalVars;
        this._globalEvalCallback = callback;


        /*if ((isc.Browser.isSafari && isc.Browser.safariVersion<533.16) || (isc.Browser.isChrome && isc.Browser.safariVersion<537.4)) {

            evalString = "isc.Class.startGlobalsCapture();try {\n"
                         + "eval(" + evalString.asSource() +
                            ");\n} catch (e) { window._evalError = e; }\n"
                         +"isc.Class.endGlobalsCapture("
                         +"window._evalError," + !!reportErrors + ");";
            window.setTimeout(evalString,0);
            return;
        }*/

        // by default when globalEvalWithCapture is called with callback, the keepGlobals handling is set in globalEvalAndRestore
        // which requests startGlobalsCapture / endGlobalsCapture to run in keepGlobals mode. The globals however are restored in
        // globalEvalAndRestore, not in endGlobalsCapture() like should when startGlobalsCapture() / endGlobalsCapture() pair is called
        // standalone. To keep the globalEvalWithCapture's standalone functionality in sync with the case when callback is passed as
        // parameter, we specifically set keepGlobals (as otherwise startGlobalsCapture will be by default in keepGlobals mode)
        if (!callback) {
            var undef;
            this.startGlobalsCapture(null, isc.keepGlobals === undef ? null : isc.keepGlobals);
        } else {
            this.startGlobalsCapture();
        }
        // If an error occurs during eval, capture it and pass it to the completion block to be
        // provided to the user callback.
        var error;
        try {
            if (isc.Browser.isIE) {
                // execScript() - Special IE only function that exports to global scope -
                // can also be used to execute VBScript code. Before IE 9 no other mechanism
                // is known to work to evaluate code in the global scope. Starting
                // with IE 9, an indirect eval executes properly in the global
                // scope: http://msdn.microsoft.com/en-us/library/ie/gg622934.aspx
                // Also, execScript() is unavailable in IE11+:
                // http://msdn.microsoft.com/en-us/library/ie/ms536420.aspx
                if (window.execScript != null) {
                    window.execScript(evalString, "javascript");

                // Indirect eval
                // http://perfectionkills.com/global-eval-what-are-the-options/#windoweval
                } else {
                    window.eval(evalString);
                }
            } else {
                // pass in the 'globalScope' parameter so any defined vars get retained in global
                // scope after the eval
                isc.Class.evaluate(evalString, null, true);
            }
        } catch (e) {
            // If we have been asked to report errors, do so - also hang onto the error so
            // the callback can make use of it if necessary


            if (reportErrors) isc.Log._reportJSError(e, null, null, null,
                                                     "Problem during global eval()");
            error = e;
        }

        return this.endGlobalsCapture(error);
    },

    startGlobalsCapture : function (pEvalVars, keepGlobals) {
        var undef;



        // make sure we're not calling startGlobalsCapture without calling endGlobalsCapture first
        if (isc._startGlobalsCaptureCalled) {
            isc.logWarn("startGlobalsCapture() called again without endGlobalsCapture being called!");
            return;
        }

        isc._startGlobalsCaptureCalled = true;

        // if called standalone (not from globalEvalAndRestore), we need to set user-passed keepGlobals
        // but also consider the case when not passed at all, in which case we need to be in
        // keepGlobals mode
        if (!this._globalEvalCallback) {
            // if keepGlobals was not passed, assume we gonna need to restore the globals later
            // in the endGlobalsCapture(), so enable keepGlobals mode.
            if (keepGlobals === undef) {
                isc.keepGlobals = [];
            } else {
                isc.keepGlobals = keepGlobals;
            }
        }

        // evalVars must go onto the window object - make sure we don't overwrite existing
        // values by holding on to any conflicting refs so we can restore later
        var evalVars = this._globalEvalVars ? this._globalEvalVars : pEvalVars;
        this._restoreGlobals = {};
        if (evalVars) {
            for (var evalVar in evalVars) {
                var globalValue = window[evalVar];
                // need to be careful to preserve nulls, zeroes - so check that the value is
                // actually undefined.
                if (globalValue !== undef) this._restoreGlobals[evalVar] = globalValue;
                window[evalVar] = evalVars[evalVar];
            }
        }

        // track temporary globals with auto-assigned IDs
        isc.autoAssignedTempGlobals = {};

        // start globals capture.  See globalEvalAndRestore for 'keepGlobals' purpose
        isc.globalsSnapshot = isc.keepGlobals ? {} : [];
    },

    // revert window binding for globalId, and release globalId if it was auto-assigned
    _globalsCaptureRestoreGlobal : function (globalId, originalGlobals, idsToFree) {
        // if globalId was registered as auto-assigned, release it now
        var className = idsToFree[globalId];
        if (className) {
            delete idsToFree[globalId];
            isc.ClassFactory.releaseGlobalID(className, globalId);
        }
        // restore the original/previous window binding for globalId
        window[globalId] = originalGlobals[globalId];
    },

    endGlobalsCapture : function (error, reportErrors, restoreGlobals) {
        //!OBFUSCATEOK


        // check if we were called after startGlobalsCapture. If not, bail out with error
        if (!isc._startGlobalsCaptureCalled) {
            isc.logWarn("endGlobalsCapture() called before having a startGlobalsCapture() call!");
            return {globals:null, error:"endGlobalsCapture() called before having a startGlobalsCapture() call!"};
        }

        if (error != null && reportErrors) isc.Log._reportJSError(error, null, null, null,
                                                 "Problem during global eval()");
        // restore any conflicting globals and undefine any evalVars we set on the window object
        var undef, evalVars = this._globalEvalVars;
        if (evalVars) {
            for (var evalVar in evalVars) {
                var globalValue = this._restoreGlobals[evalVar];
                if (globalValue !== undef) window[evalVar] = this._restoreGlobals[evalVar];
                else window[evalVar] = undef; // can't delete window[evalVar] in IE!
            }
        }
        var callback = this._globalEvalCallback,
            globals = isc.globalsSnapshot,
            idsToFree = isc.autoAssignedTempGlobals;

        isc.globalsSnapshot = this._globalEvalCallback = this._globalEvalVars =
            this._restoreGlobals = window._evalError = isc.autoAssignedTempGlobals = null;
        isc._startGlobalsCaptureCalled = null;

        this.fireCallback(callback, "globals,error,idsToFree", [globals, error, idsToFree]);

        // if called in standalone mode, check if globals need to be restored
        if (!callback) {
            var keepGlobals = isc.keepGlobals;

            // globals can be restored only if we were in keepGlobals mode
            var undef;
            if (restoreGlobals === undef || restoreGlobals ) {
                if (keepGlobals) {
                    for (var globalId in globals) {
                        if (keepGlobals.contains(globalId)) {
                             continue;
                        }

                        this._globalsCaptureRestoreGlobal(globalId, globals, idsToFree);
                    }
                } else {
                   isc.logWarn("Cannot restore globals in endGlobalsCapture because " +
                               "non-keepGlobals mode was also required by caller");
                }
            }
            isc.keepGlobals = null;
        }

        return {globals: globals, error: error}
    },

    // eval code in the global scope, where only the listed IDs are allowed to become global.
    // Other widgets obtain a global ID only for the duration of the eval(), then become no
    // longer global.
    //
    // This allows widgets that interlink by global ID (eg layout.members) to find each other,
    // specifically, any inter-reference that is resolved either directly when the code eval()s
    // or by the time init()/initWidget() completes will work.
    //
    // Any code that tries to resolve an ID reference sometime after init, or stores the global
    // ID of a component during init (rather than a live reference) won't work with
    // globalEvalAndRestore().
    //
    // globalEvalAndRestore() does not prevent DataSources from registering such that they are
    // available from DataSource.get(), so in effect, all DataSources behave as if
    // dataSource.addGlobalId were false.
    //
    // Likewise globalEvalAndRestore() does not prevent other global registrations not related
    // to global IDs, such as SimpleType registration or WSDL / XML schema registrations by
    // namespace.

    globalEvalAndRestore : function (evalString, keepGlobals, callback, evalVars, reportErrors,
                                     updateLocalIds)
    {
        if (keepGlobals == null) keepGlobals = [];
        isc.keepGlobals = keepGlobals;

        return this.globalEvalWithCapture(evalString, function (globals, error, idsToFree) {
            isc.keepGlobals = null;


            var suppressedGlobals = {},
                topLevel = isc.Canvas._getTopLevelWidget(globals);

            // restore all captured globals to their original values, except the keepGlobals
            for (var globalId in globals) {
                if (keepGlobals.contains(globalId)) continue;

                // save the object temporarily ocuppied this global id, so we can pass it later
                // to the callback
                suppressedGlobals[globalId] = window[globalId];

                if (updateLocalIds) {
                    var obj = window[globalId];

                    // treat a ValuesManager like a Canvas so it gets registered with a localId
                    if (obj && (isc.isA.Canvas(obj) || isc.isA.ValuesManager(obj))) {

                        if (topLevel) {
                            // store a mapping from globalId to widget on the detected top
                            // level widget (the "screen")
                            if (!topLevel._localIds) {
                                topLevel._localIds = {};
                            }
                            topLevel._localIds[globalId] = obj;
                            // on each widget, store a reference to the screen it's registered
                            // with
                            obj.setProperty("_screen", topLevel);
                        } else {
                            // Could happen in case of potential error in evaluated code. For
                            // example if topElement or masterElement was explicitely defined
                            // for object that otherwise should be topLevel object or overridden
                            // Canvas class were used which sets topElement or masterElement
                            // property during init method.
                            if (obj.topElement || obj.masterElement) {
                                isc.logWarn("Cannot find top level of " + obj);
                            }
                        }
                    }
                }

                isc.Class._globalsCaptureRestoreGlobal(globalId, globals, idsToFree);
            }

            isc.Class.fireCallback(callback, "globals,error,suppressedGlobals",
                                   [globals, error, suppressedGlobals]);

        }, evalVars, reportErrors);
    },

    // ---------------------------------------------------------------------------------------

    // _notifyFunctionComplete
    // Static method called when the notification function for some observed method completes.
    _notifyFunctionComplete : function (object, methodName, queue) {
        // Decrement the 'notifyStack' flag.
        // This flag tracks whether the observed function is currently being run.  We implement
        // this as a number indicating the depth of stacked calls to this method.

        queue._notifyStack -= 1;
        // if the notifyStack is greater than zero the top level notificationFunction hasn't
        // yet exited, so don't proceed to modify observers.
        if (queue._notifyStack) return;

        for (var i = 0; i < queue.length; i++) {
            var q = queue[i];
            // Clear any items that were 'ignored' while the notification function was running
            if (q._removedWhileNotificationRunning) {
                queue.removeItem(i);
                i--;
                continue;
            }

            // Clear any temp flags denoting observations set up while the notification function
            // was firing.
            if (q._addedWhileNotificationRunning) {
                delete q._addedWhileNotificationRunning;
            }
        }

        if (queue.length == 0) {
            var saveMethodName = isc._obsPrefix + methodName;
            // restore the original function to its original name
            object[methodName] = object[saveMethodName];
            // clear the new method slot
            delete object[saveMethodName];
            // remove the observer queue
            delete object._observers[methodName];
        }
    },

    // Arrays of definitions (TabBar tabs, Layout members, SectionStack sections, Wizard pages..)
    // ---------------------------------------------------------------------------------------
    _$ID : "ID",
    getArrayItem : function (id, array, idProperty) {
        if (array == null) return null;



        // Number: assume index.
        if (isc.isA.Number(id)) return array[id];

        // Object: return unchanged
        if (isc.isAn.Object(id)) return id;

        // String: assume id property of section descriptor object
        if (isc.isA.String(id)) return array.find(idProperty || this._$ID, id);


        // otherwise invalid
        return null;
    },

    getArrayItemIndex : function (id, array, idProperty) {
        if (isc.isA.Number(id)) return id;

        var item = isc.Class.getArrayItem(id, array, idProperty);

        return array.indexOf(item);
    },

    // Getting DOM objects (going through these APIs makes cross-frame installation possible)
    // ---------------------------------------------------------------------------------------

    getWindow : (
        isc.Browser.isSafari ? function () {
            return window;
        } : function () {
            return this.ns._window;
        }
    ),
    getDocument : (
        isc.Browser.isSafari ? function () {
            return window.document;
        } : function () {
            return this.ns._document;
        }
    ),


    getDocumentBody : function (suppressDocElement) {
        var getDocElement = (!suppressDocElement && isc.Browser.isIE && isc.Browser.isStrict);
        var body = (getDocElement ? this.ns._documentElement : this.ns._documentBody);
        if (body != null) return body;

        var doc = this.getDocument();
        if (getDocElement) {
            this.ns._documentElement = doc.documentElement;
            return this.ns._documentElement;
        }

        if (isc.Browser.isIE) {
            body = doc.body;
        } else {
            if (doc.body != null) body = doc.body;
            else {
                // XHTML: body not available via document.body (at least in FF 1.5)
                // Using the documentElement namespace future proofs us against future XHTML
                // versions
                var documentNS = doc.documentElement.namespaceURI;
                body = doc.getElementsByTagNameNS(documentNS, "body")[0];
                if (body == null) {
                    // XHTML: body not available via getElementsByTagNameNS() before page load
                    // in FF 1.5 (possibly others), but is available via DOM navigation
                    body = doc.documentElement.childNodes[1];
                    if (body != null && body.tagName != "body") body = null;
                }
                //this.logWarn("fetching body element: " + body);
                // don't cache failure to retrieve body, it should be available later until the
                // document is completely hosed
                if (!body) return null;
            }
        }
        this.ns._documentBody = body;
        return body;
    },
    getActiveElement : function () {

        try {
            return this.getDocument().activeElement;
        } catch (e) {
            this.logWarn("error accessing activeElement: " + e.message);
        }
        return null;
    },

    //> @classMethod class._makeNotifyFunction() (A)
    // Make a function to call the original method, then each recipient in turn.
    // @param methodName (String) name of the method to observe
    // @return (Function) new function to call when method is fired
    // @group observation
    //<
    _actionRunnerCache: {},
    _makeNotifyFunction : function (methodName) {
        var notifyFunc = function observation() {
            if (isc._traceMarkers) arguments.__this = this;

            var returnVal = this[arguments.callee._origMethodSlot].apply(this, arguments);

            var queue = this._observers[methodName];

            // HACK: avoid crashing if we end up with an observation installed on an object
            // without the corresponding list of observers.  This can happen when we trace a
            // method on an entire class, in which case we install the observation method on
            // the instance prototype, but when the observation fires, it fires with each
            // individual instance's list of observers.
            if (!queue) return returnVal;

            queue._notifyStack = queue._notifyStack ? queue._notifyStack + 1 : 1;

            // call each observer
            var q,
                action;
            for (var i = 0, len = queue.length; i < len; ++i) {
                q = queue[i];

                // skip if the observer was added while this notify function is running.
                if (q._addedWhileNotificationRunning) continue;

                action = q.action;
                action._observer = q.target;
                action._observed = this;
                action._returnVal = returnVal;
                try {
                    action.apply(q.target, arguments);
                } finally {
                    action._observer = null;
                    action._observed = null;
                    action._returnVal = null;
                }

                if (q._ignoreAfterNotify) {
                    // ignore this observer now that call has been made
                    q.target.ignore(this, methodName);
                }
            }

            // Fire the 'complete' function - this will update any changes to observation made while
            // the notification function was running.

            if (isc.Browser.isSafari) {
                arguments.callee._ns.Class._notifyFunctionComplete(this, methodName, queue);
            } else {
                isc.Class._notifyFunctionComplete(this, methodName, queue);
            }

            // return the value returned by the original function
            return returnVal;
        };

        notifyFunc._isObservation = true;
        notifyFunc._fullName = methodName + "Observation";
        notifyFunc._origMethodSlot = isc._obsPrefix + methodName;

        // hang a pointer to the correct isc object onto the function in Safari.
        if (isc.Browser.isSafari) notifyFunc._ns = isc;

        return notifyFunc;
    },

    _makeThunkFunction : function (argString, action) {
        if (argString == null) argString = isc._emptyString;

        var code = "var observer = arguments.callee.caller._observer, it = observer, observed = this, returnVal = arguments.callee.caller._returnVal;\n";
        code += action;

        var cache = isc.Class._actionRunnerCache[argString];
        if (cache == null) cache = isc.Class._actionRunnerCache[argString] = {};
        var actionRunner = cache[action];
        if (actionRunner == null) {
            actionRunner = cache[action] = isc._makeFunction(argString, code);
            actionRunner._argString = argString;
        }

        return function thunk() {
            actionRunner.apply(arguments.callee._observed, arguments);
        };
    },




    _assert : function (b, message) {
        if (!b) {

            isc.logWarn("assertion failed" +
                        (message ? " with message: '" + message + "'" : "") +
                        ". Stack trace:" + (isc.Class.getStackTrace()));
            throw (message || "assertion failed");
        }
    },

    // Class-level "actions" for Reify/VB
    // ---------------------------------------------------------------------------------------



    addAsClassActionsComponent : function (icon, id) {
        if (!isc.Class._actionClasses) isc.Class._actionClasses = {};
        var type = this.getClassName();
        // If adding default component registration and there is already one, ignore
        if (isc.Class._actionClasses[type] != null && !icon && !id) return;
        var definition = {
            type: type,
            icon: icon,
            ID: id || type,
            liveObject: this
        };
        isc.Class._actionClasses[type] = definition;
    },

    getClassActionsComponents : function () {
        if (!isc.Class._actionClasses) return null;
        var components = isc.getValues(isc.Class._actionClasses);
        return (components.length > 0 ? components : null);
    },

    registerClassActions : function (actions) {
        if (!isc.isAn.Array(actions)) actions = [actions];
        this._actions = actions;

        // Make sure this class is registered as having class actions
        this.addAsClassActionsComponent();
    },

    // targetComponent can be used by subclass overrides to limit what actions are provided
    // to target component types
    getClassActions : function (targetComponent) {
        return this._actions;
    }

});    // END addClassMethods(isc.Class)



isc.Class.addClassMethods({
    // synonym for backwards compatibility
    newInstance : isc.Class.create
});

// make the isc namespace available on all Class objects
isc.Class.ns = isc;

// retrofit the ClassFactory
isc.addProperties(isc.ClassFactory, {
    ns : isc,
    getWindow : isc.Class.getWindow,
    getDocument : isc.Class.getDocument
});

//
//    add methods to all instances of any Class or subclass
//
isc.Class.addMethods({
    //>    @method    class.init()    (A)
    //
    // Initialize a new instance of this Class.  This method is called automatically by
    // +link{Class.create()}.
    // <p>
    // Override this method to provide initialization logic for your class.  If your class is
    // a subclass of a UI component (i.e. descendant of +link{Canvas}), override
    // +link{canvas.initWidget()} instead.
    //
    // @param    [arguments 0-N] (Any)    All arguments initially passed to +link{Class.create()}
    //
    // @visibility external
    //<
    init : function () {},

    // class-level destructor - call via Super() from any subclass
    //> @method class.destroy()    (A)
    // Permanently destroy a class instance and any automatically created resources,
    // recursively.
    // @see canvas.destroy()
    // @see group:memoryLeaks
    // @visibility external
    //<
    destroy : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
        var classObj = this.getClass();

        // Remove DynamicProperty rules from rulesEngine
        this._removeDynamicPropertyRules();

        // Remove this component from the ruleScope rulesEngine
        var component = this.getRuleScopeComponent();
        if (component && component.rulesEngine) component.rulesEngine.removeMember(this);

        this._clearObservationsForDestroy();

        // call destroyInterface() on any member interfaces that define the method
        if (classObj._destroyInterfaceMethods) {
            for (var i = 0; i < classObj._destroyInterfaceMethods.length; i++) {
                classObj._destroyInterfaceMethods[i].call(this, A,B,C,D,E,F,G,H,I,J,K,L,M);
            }
        }

        // destroy any SGWT object wrapping this JS object

        var sgwtDestroy = this.__sgwtDestroy;
        if (sgwtDestroy) {
            delete this.__sgwtDestroy;
            sgwtDestroy.apply(this);
        }
    },

    //> @attr class.addPropertiesOnCreate (Boolean : undefined : RA)
    // Controls whether arguments passed to +link{classMethod:Class.create()} are assumed to be
    // Objects containing properties that should be added to the newly created instance.  This
    // behavior is how <code>create()</code> works with almost all SmartClient widgets and
    // other components, allowing the convenient shorthand of setting a batch of properties via
    // an +link{type:ObjectLiteral,JavaScript Object Literal} passed to create().
    // <P>
    // The setting defaults to true if unset.  To disable this behavior for a custom class,
    // such that <code>create()</code> works more like typical constructors found in Java and
    // other languages, use:
    // <pre>
    //     isc.[i]ClassName[/i].addProperties({ addPropertiesOnCreate:false })
    // </pre>
    // <P>
    // Note that it is not valid to disable this behavior for any subclass of +link{Canvas}
    // (Canvas relies on this property).
    // <p>
    // Regardless of the setting for <code>addPropertiesOnCreate</code>, all arguments passed to
    // +link{Class.create()} are still passed on to +link{Class.init()}.
    //
    // @visibility external
    //<


    completeCreation : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
        //!OBFUSCATEOK


        var       level = isc.createLevel;
        isc.createLevel = isc.keepGlobals ? (level == null ? 1 : level + 1) : null;


        //>EditMode
        var captureDefaults = isc.captureDefaults;
        if (captureDefaults) isc.captureDefaults = false;
        //<EditMode



        if (this.addPropertiesOnCreate != false) {
            //>EditMode capture clean initialization data, and don't construct the actual
            // instance.  This is used to load a set of components for editing.  NOTE:
            // currently only applies to classes that addPropertiesOnCreate (which includes
            // all Canvas subclasses)
            if (captureDefaults) {

                var component = {
                    type: this.Class,
                    defaults: isc.addProperties({}, A,B,C,D,E,F,G,H,I,J,K,L,M)
                }
                if (!isc.capturedComponents) isc.capturedComponents = [];
                isc.capturedComponents.add(component);

                if (component.defaults.ID || component.defaults.autoID) {
                    isc.ClassFactory.addGlobalID(component, component.defaults.ID ||
                                                 component.defaults.autoID);
                    // isc.Log.logWarn("adding global component: " +
                    //                 (component.defaults.ID || component.defaults.autoID));
                }

                // restore original value of isc.captureDefaults
                if (captureDefaults) isc.captureDefaults = true;
                // restore original value of isc.createLevel
                isc.createLevel = level;

                return component;
            }
            //<EditMode

            isc.addProperties(this, A,B,C,D,E,F,G,H,I,J,K,L,M);
        }

        var classObj = this.getClass(),
            dupProps = classObj._dupAttrs;
        if (dupProps != null) {
            for (var i = 0; i < dupProps.length; i++) {
                var prop = dupProps[i];
                if (this[prop] == classObj._instancePrototype[prop]) {
                    this[prop] = classObj.cloneDupPropertyValue(prop, this[prop]);
                }
            }
        }

        // dynamic interface mixins for autochildren/instances
        //if (isc.Log && isc.Log.logWarn) isc.Log.logWarn(this.getClassName());
        if (this._mixIns) {
            this.mixInInterface(this._mixIns);
        }

        // call initInterface() on any member interfaces that define the method
        if (classObj._initInterfaceMethods) {
            for (var i = 0; i < classObj._initInterfaceMethods.length; i++) {
                classObj._initInterfaceMethods[i].call(this, A,B,C,D,E,F,G,H,I,J,K,L,M);
            }
        }

        // call initInterface() on any member interfaces that define the method
        if (this._initInterfaceMethods) {
            for (var i = 0; i < this._initInterfaceMethods.length; i++) {
                this._initInterfaceMethods[i].call(this, A,B,C,D,E,F,G,H,I,J,K,L,M);
            }
        }

        // call the init() routine on the new instance
        this.init(A,B,C,D,E,F,G,H,I,J,K,L,M);

        if (this.autoDupMethods) {
            isc.Class.duplicateMethods(this, this.autoDupMethods);
        }

        //>EditMode restore original value of isc.captureDefaults
        if (captureDefaults) isc.captureDefaults = true;
        //<EditMode
        // restore original value of isc.createLevel
        isc.createLevel = level;

        return this;
    },

    //>    @method    class.mixInInterface()    (A)
    //
    // Add the methods of a given Interface to a class instance so the class implements the methods.
    // If the class has already defined a method with the same name as the one specified
    // in the interface, the class' method will be retained.
    //
    // @param  interfaceName    (String)    Name of the Interface to get methods from.
    //<
    mixInInterface : function (interfaceName) {
        isc.ClassFactory.mixInInterface(this, interfaceName);
    },

    // instance-level auto-dups
    //autoDupMethods: [ "fireCallback", "Super", "invokeSuper", "getInnerHTML" ],
    duplicateMethod : function (methodName) {
        isc.Class.duplicateMethod(methodName, this);
    },

    //>    @method    class.getUniqueProperties
    //
    //    Gets all non-internal properties that are the different between this object and its
    //  prototype and returns a new object with those properties.
    //
    //    NOTE: this will also skip an object ID (object.ID)
    //        if it starts with our auto-generated ID string ("isc_OID_")
    //
    //    NOTE: if your object points to some complex object, the clone will pick that up... :-(
    //
    //    @param    [returnProperties]    (Object)    If passed in, properties will be added to this object.
    //                                            If not passed, a new object will be created.
    //    @return (Object)    unique properties for this object
    //<
    // NOTE: not external because lots of random state is picked up, and lots of important
    // state is discarded.
    getUniqueProperties : function (returnProperties) {
        if (returnProperties == null) returnProperties = {};

        var proto = this.getPrototype();

        for (var property in this) {
            // ignore internal properties
            if (property.startsWith("_")) continue;

            // ignore the namespace pointer installed on every instance
            if (property == "ns") continue;

            // ignore ID if it's auto-generated
            if (property == "ID" && this.ID.startsWith("isc_OID_")) continue;

            var value = this[property];

            // don't pick up functions (NOTE: we probably don't want to try to serialize
            // functions in general, or at least, that would be a very advanced and separate
            // serialization system.  Also, note that if we don't ignore functions, we'd pick
            // up observations since observations replace the original function)
            if (isc.isA.Function(value)) continue;

            // if the property still has the default value for the class, ignore it
            if (value != proto[property]) {
                /*
                if (proto[property] != null) {
                    this.logWarn("property: " + property + ": value " +
                                 this.echoLeaf(this[property]) +
                                 " !== proto value " +
                                 this.echoLeaf(proto[property]));
                }
                */
                returnProperties[property] = this[property];
            }
        }
        return returnProperties;
    },

    //>    @method    class.clone
    //
    // Make a clone of this instance.
    // Gets all non-internal properties that are the different between this object and its
    // prototype and creates a new instance with those properties
    //
    //    NOTE: if your object points to some complex object, the clone will pick that up... :-(
    //
    //    @return (Class)    clone of this class
    //<
    // NOTE: not external because this doesn't work for almost all widgets and has many issues
    // before it could be supported (eg what to do with shared data models?)
    clone : function () {
        return this.getClass().create(this.getUniqueProperties());
    },

    // NOTE: not external.  Need to define what this should do, eg, just a dump of state for
    // debugging vs recreate component in current state / transmit between browsers
    serialize : function (indent) {
        return isc.Comm.serialize(this, indent);
    },

    xmlSerialize : function (indent) {
        return isc.Comm.xmlSerialize(this.getClassName(), this, indent);
    },

    // get the fields
    getSerializeableFields : function (removeFields, keepFields) {
        // see if we can obtain a schema for this class.  If a schema is available,
        // we'll use it to filter the set of fields that are serializeable.
        var schema = isc.DS ? isc.DS.getNearestSchema(this) : null;

        var uniqueProperties = this.getUniqueProperties();

        // instead of bailing out limit to simple types only?
        if (schema == null) {
            this.logDebug("No schema available for class" + this.getClassName());
            return uniqueProperties;
        } else {
            this.logDebug("Constraining serializeable fields for class: " + this.getClassName()
                          + " with schema : " + schema.ID);
        }

        // the list of valid fields is the intersection of datasource-declared fields and unique
        // properties.  This ensures that we don't pick up fields that are really internal
        // (e.g. starting with underscore)
        var serializeableFields = isc.applyMask(uniqueProperties, schema.getFields());

        // removeFields and keepFields are Arrays of fieldNames that subclasses can modify
        // before calling Super in order to suppress or keep fields
        removeFields = removeFields || [];
        keepFields = keepFields || [];

        // strip removeFields from the set of serializeable fields.
        removeFields.map(function(arg) { delete serializeableFields[arg]; });

        // ensure that the fields that specifically requested are in
        for (var i = 0; i < keepFields.length; i++) {
            serializeableFields[keepFields[i]] = this[keepFields[i]];
        }

        return serializeableFields;
    },

    //>    @method    class.getID()
    //            Return the global identifier for this object.
    //
    //        @return    (String)    global identifier for this canvas
    // @visibility external
    //<
    getID : function () {
        return this.ID;
    },

    //>    @method    class.getClass()
    //
    //    Gets a pointer to the class object for this instance
    //
    //    @return (Class)        Class object that was used to construct this object
    // @visibility external
    //<
    getClass : function () {
        return this._classObject;
    },


    //>    @method    class.getSuperClass()
    //
    //    Gets a pointer to the class object for this instance's superclass.
    //
    //    @return (Class)        Class object for superclass.
    // @visibility external
    //<
    getSuperClass : function () {
        return this._classObject._superClass;
    },


    //>    @method    class.getClassName()
    //
    //    Gets the name of this class as a string.
    //
    //    @return    (String)    String name of this instance's Class object.
    // @visibility external
    //<
    getClassName : function () {
        return this.getClass().getClassName();
    },

    //> @method Class.getScClassName()
    //
    //  Gets the name of this class as a string, if the class is a SmartClient Framework class.
    //  Otherwise, gets the name of the SmartClient Framework class which this class extends.
    //
    //  @return (String) name of the SmartClient Framework class
    //<
    getScClassName : function () {
        return this.getClass().getScClassName();
    },

    //>    @method    class.getPrototype()    (A)
    //
    //    Gets a pointer to the prototype of this instance.
    //
    //    @return (Object)    prototype object for this instance
    //<
    getPrototype : function () {
        return this._scPrototype;
    },


    //>    @method    class.getGlobalReference()    (A)
    //
    //    Evaluate a reference in the global scope.  Within the eval,
    //        "this" will be a pointer to this instance.
    //
    //    @param    reference    (String)    String to get the reference from.  If anything other than
    //                                     a string is passed in, simply returns reference.
    //    @return (Reference)        reference to evaluate
    //<
    getGlobalReference : function (reference) {
        //!OBFUSCATEOK
        if (typeof reference == "string") return this.evaluate(reference);
        return reference;
    },

    //>    @method    class.addMethods()
    //
    //    Add methods to this specific instance.  These can either be completely new methods or can
    //    have the same name as existing methods, in which case the new methods will override the
    //    existing methods.
    //
    // @param [arguments 0-N] (Object)    Object containing name:method pairs to be added to this object
    // @return                (Object)  the object after methods have been added to it
    // @visibility internal
    //<

    addMethods : function () {

        for (var i = 0; i < arguments.length; i++) {
            // call global addMethods()
            return isc.addMethods(this, arguments[i]);
        }
    },

    //>    @method    class.addProperties()
    //
    //     Add properties or methods to this specific instance.
    //    Properties with the same name as existing properties will override.
    //
    //  @see classMethod:Class.addProperties()
    //  @see isc.addProperties()
    //
    //    @param    [arguments 0-N] (Object)    Object containing name:value pairs to be added to this object
    //  @return                 (Object)    the object after properties have been added to it
    // @visibility external
    //<
    addProperties : function () {
        return isc.addPropertyList(this, arguments);
    },

    //>    @method    class.addPropertyList()
    //
    //    Add properties to this instance.
    //
    //    @param    list (Array of Object[])        array of objects with properties to add
    //  @return                 (Object)    the object after properties have been added to it
    // @visibility external
    //<
    addPropertyList : function (list) {
        return isc.addPropertyList(this, list);
    },

    // Get / Set with automatic getter/setter
    // ---------------------------------------------------------------------------------------

    //>    @method    class._getSetter()    (A)
    //
    //    Get the setter for a particular property, if one exists
    //
    //    @param    propertyName (String)    name of the property to find the setter for
    //                                    eg: if propertyName == "contents", setter == "setContents"
    //
    //    @return    (String)                name of the setter for the property, or null if none found
    //
    //<
    _getSetter : function (propertyName) {
        var functionName = "set" + propertyName.substring(0,1).toUpperCase() + propertyName.substring(1);
        return (isc.isA.Function(this[functionName]) ? functionName : null);
    },

    //>    @method    class._getGetter()    (A)
    //
    //    Get the getter for a particular property, if one exists
    //
    //    @param    propertyName (String)    name of the property to find the getter for
    //                                    eg: if propertyName == "contents", getter == "getContents"
    //
    //    @return    (String)                name of the getter for the property, or null if none found
    //
    //<
    _getGetter : function (propertyName) {
        var functionName = "get" + propertyName.substring(0,1).toUpperCase() + propertyName.substring(1);
        return (isc.isA.Function(this[functionName]) ? functionName : null);
    },

    //>    @method    class.setProperty()
    // Set a property on this object, calling the setter method if it exists.
    // <p>
    // Whenever you set a property on an ISC component, you should call either the specific setter
    // for that property, or <code>setProperty()/setProperties()</code> if it doesn't have one.
    // This future-proofs your code against the later addition of required setters.
    //
    // @param propertyName (String) name of the property to set
    // @param newValue (Any) new value for the property
    // @see method:class.setProperties()
    // @visibility external
    //<
    setProperty : function (propertyName, newValue) {
        // NOTE: this is inefficient but unlikely to be called very often, and doing it this way
        // means subclasses can override just setProperties()
        var props = {};
        props[propertyName] = newValue;
        this.setProperties(props);
    },

    //>    @method    class.setProperties()
    // Set multiple properties on an object, calling the appropriate setter methods if any are
    // found.
    // <p>
    // Whenever you set a property on an ISC component, you should call either the specific setter
    // for that property, or <code>setProperty()/setProperties()</code> if it doesn't have one.
    // This future-proofs your code against the later addition of required setters.
    // <p>
    // With <code>setProperties()</code> in particular, some classes may be able to take shortcuts
    // and be more efficient when 2 or more related properties are set at the same time.
    //
    //    @param    [arguments 0-N] (Object)    objects with properties to add (think named parameters).
    //                                        all the properties of each argument will be applied one
    //                                        after another so later properties will override
    // @see method:class.setProperty()
    //  @visibility external
    //<
    setProperties : function () {

        var isA = isc.isA,
            propertyBlock,
            additionalProps = {};

        // if not passed any properties arguments, just bail
        if (arguments.length < 1) return;

        // Iterate through the (possibly just one) properties, combining them into a single
        // object.  We do this to avoid duplicate calls to setters, although another approach
        // would be to keep a mask of the properties we've set, starting from the last argument
        // to the first.
        if (arguments.length == 1) {
            propertyBlock = arguments[0];
            if (propertyBlock == null) return;
        } else {
            propertyBlock = {};

            for (var i = 0; i< arguments.length; i++) {
                isc.addProperties(propertyBlock, arguments[i]);
            }
        }

        for (var propertyName in propertyBlock) {
            var value = propertyBlock[propertyName],
                setter = this._getSetter(propertyName);
            if (isc.isA.StringMethod(value)) value = value.getValue();
            //this.logWarn("setting property: " + propertyName +
            //             " to value: " + this.echoLeaf(value) +
            //             " via setter: " + this.echoLeaf(setter));
            if (setter) {
                this[setter](value);
                if (this.propertyChanged) this.propertyChanged(propertyName, value);
            } else {
                additionalProps[propertyName] = value;
            }
        }
        // add any remaining properties via addProperties (will fall through to addMethods if
        // necessary)
        this.addProperties(additionalProps)

        // Fire the notification function for any properties that didn't have an explicit
        // setter
        if (this.propertyChanged) {
            for (var propertyName in additionalProps) {
                this.propertyChanged(propertyName, additionalProps[propertyName]);
            }
        }

        // Fire any "doneSettingProperties()" - allows the instance to respond to multiple
        // related properties being set without having to respond to each one.
        if (this.doneSettingProperties) this.doneSettingProperties(propertyBlock);
    },


    getProperty : function (propName) {
        var getter = this._getGetter(propName);
        if (getter) return this[getter]();
        return this[propName];
    },
    getPropertyValue : function (propName) {
        var getter = this._getGetter(propName);
        if (getter) return this[getter]();
        return this[propName];
    },


    //> @type Properties
    // When the type for a parameter mentions "properties" as in "ListGrid Properties" or
    // "RPCRequest Properties", it means that the expected value is a JavaScript Object
    // containing any set of properties generally legal when creating an object of that type.
    // <P>
    // For example, the first parameter of +link{RPCManager.sendRequest()} is of type
    // "RPCRequest Properties".  This means it should be called like:
    // <pre>
    //    isc.RPCManager.sendRequest({
    //        actionURL : "/foo.do",
    //        showPrompt:false
    //    });</pre>
    // +link{rpcRequest.actionURL,actionURL} and +link{rpcRequest.showPrompt,showPrompt} are
    // properties of +link{RPCRequest}.
    // <P>
    // Note that the notation shown above is an example of a
    // +link{type:ObjectLiteral,JavaScript object literal}.
    //
    // @visibility external
    //<

    //> @type ObjectLiteral
    // An "Object literal" is JavaScript shorthand for defining a JavaScript Object with a set
    // of properties.  For example, code like this:
    // <pre>
    //    var request = {
    //        actionURL : "/foo.do",
    //        showPrompt:false
    //    };</pre>
    // .. is equivalent to ..
    // <pre>
    //    var request = new Object();
    //    request.actionURL = "/foo.do";
    //    request.showPrompt = false;</pre>
    // In situations where a set of +link{type:Properties,properties} may be passed to a
    // method, the Object literal notation is much more compact.  For example:
    // <pre>
    //    isc.RPCManager.sendRequest({
    //        actionURL : "/foo.do",
    //        showPrompt:false
    //    });</pre>
    // <b>NOTE:</b> if you have a 'trailing comma' in an object literal, like so:
    // <pre>
    //    var request = {
    //        actionURL : "/foo.do",
    //        showPrompt:false, // TRAILING COMMA
    //    };</pre>
    // This is considered a syntax error by Internet Explorer, but not by Firefox.  This is by
    // far the #1 cause of Internet Explorer-specific errors that do not occur in other
    // browsers.  Pay special attention to this error, and, if you can, install the
    // JSSyntaxScannerFilter into your development environment (as described in the
    // +link{group:iscInstall,deployment instructions}).
    //
    // @visibility external
    //<

    // ---------------------------------------------------------------------------------------

    // useful for cascading defaults where 0 or "" is allowed so the pattern of
    // "value1 || value2 || value3" won't work.

    _firstNonNull : function (a,b,c,d,e,f) {
        return a != null ? a :
                (b != null ? b :
                    (c != null ? c :
                        (d != null ? d :
                            (e != null ? e : f)
                        )
                    )
                );
    },

    //>    @method    class.isA()
    //
    //    Returns whether this object is of a particular class by class name, either as a direct
    //    instance of that class or as subclass of that class, or by implementing an interface
    //  that has been mixed into the class.<br><br>
    //
    //    NOTE: this only applies to ISC's class system, eg:  <code>myInstance.isA("Object")</code> will be
    //    false.
    //
    //    @param    className    (String)    Class name to test against
    //
    //    @return                (boolean)    whether this object is of that Class
    //                                  or a subClass of that Class
    // @visibility external
    //<
    isA : function (className) {
        // walk the interface inheritance chain
        if (this._implements && this._implements.contains(isc.isA.String(className)?className:className.Class)) return true;

        if (this.getClass().isA(className)) {
            return true;
        }

        // If not, also check the SGWT side
        if (this.getSGWTFactory) {
            var factory = this.getSGWTFactory();
            if (factory) return factory.isA(className);
        }
        return false;
    },



    //> @groupDef stringMethods
    //
    // A method flagged as a +link{StringMethod} can be specified as a String containing a valid
    // JavaScript expression.  This expression will automatically be converted to a function
    // with a return value matching the value of the last statement.  Providing a String is not
    // required - you may use a real function instead.
    // <p>
    // For example - suppose you wanted to override the <code>leafClick()</code> method on
    // the TreeGrid.  Normally you would do so as follows:<br>
    //
    // <pre>
    // TreeGrid.create({
    //     ...
    //     leafClick : function(viewer, leaf, recordNum) {
    //         if(leaf.name == 'zoo') {
    //             alert(1);
    //         } else {
    //             alert(2);
    //         }
    //     }
    // });
    // </pre>
    //
    // Since leafClick is a +link{stringMethod}, however, you can shorten this to:<br>
    // <pre>
    // TreeGrid.create({
    //     ...
    //     leafClick : "if(leaf.name == 'zoo') { alert(1); } else { alert(2); }";
    // });
    // </pre>
    //
    // @title String Methods Overview
    // @treeLocation Client Reference/System
    //<

    //> @type StringMethod
    // A String containing a valid JavaScript expression that's automatically converted to a
    // function with a return value matching the value of the last statement.
    // <P>
    // See +link{group:stringMethods} for an example.
    // @baseType String
    // @visibility external
    //<

    //> @groupDef flags
    //
    // <ul>
    // <li> <b>I</b>: "initializable": property can be initialized.  For a simple +link{type:Object},
    //      it means the property is valid to define on the Object.  For a +link{Class} such as
    //      +link{Canvas}, this means a property can be provided in the
    //      +link{type:Object} passed to +link{Class.create()}.
    // <li> <b>R</b>: "readable": property be read.  If a getter method exists, it must be called.
    // <li> <b>W</b>: "writable": property can be written to after initialization.  If a setter method
    //      exists, it must be called.  If no setter method exists,
    //      +link{Class.setProperty,setProperty()} must be called.
    // <li> <b>A</b>: "advanced": this property or method is meant for advanced use cases.  If you are
    //      considering using an API marked "advanced" and your use case is simple or common, this is
    //      a hint that you may have missed a simpler approach
    // </ul>
    //
    // @title Flag Abbreviations
    //<



    // Observation
    // ---------------------------------------------------------------------------------------

    //> @groupDef observation
    // Observation is the ability to take an action whenever a method is called.
    // @title Observation
    //<

    //>    @method class.observe()
    // Set up a notification action to be invoked whenever some method is called on a target
    // object.
    // <P>
    // For example, if you wanted to take an action every time some ListGrid on your page
    // had its +link{listGrid.selectionUpdated(),selection updated}, instead of
    // <i>overriding</i> the <code>selectioUpdated()</code> method on the grid, you could
    // observe it with code like this:
    // <P>
    // <code>myCanvas.observe(myListGrid, "selectionUpdated", "observer.gridSelectionUpdated()")</code>
    // <P>
    // In this example, every time <i>selectionUpdated()</i> fired on the grid "myListGrid",
    // after that method completed, the specified action would be invoked. (In this case
    // the action would call a method called "gridSelectionUpdated"  on the observer, "myCanvas").
    // <P>
    // An unlimited number of observers can be set up to observe any method. The notification
    // actions will all be fired automatically in the order that the observations were set up.
    // <P>
    // NOTES:
    // <ul>
    // <li>The object to observe may be any JavaScript object with the specified method,
    //     including simple JavaScript Objects or Arrays, or instances of SmartClient classes
    //     like +link{Canvas}.</li>
    // <li>For a given observer, observed object, and observed method combination, at most one
    //     action can be registered.  If you attempt to call <code>observe()</code> again with
    //     the same combination, it will return false and the action will not be registered.
    // <li>A method could potentially trigger an observation of itself by another object,
    //     either through code within the method itself or within an observer's action.<br>
    //     In this case the observation will be set up, but the new observation action will
    //     not fire as part of this thread. For subsequent calls to the method, the newly
    //     added observer will be fired.</li>
    // <li><i>[Potential memory leak]</i>: If the target object is a simple JavaScript object
    //     (not an instance of a SmartClient class), developers should always call
    //     +link{class.ignore(),ignore()} to stop observing the object when an observation
    //     is no longer necessary.<br>
    //     This ensures that if the observed object is subsequently allowed to go out of scope by
    //     application code, the observation system will not retain a reference
    //     to it (so the browser can reclaim the allocated memory).<br>
    //     While cleaning up observations that are no longer required is always good practice,
    //     this memory leak concern is not an issue if the target object is an instance of
    //     a SmartClient class. In that case the observation is automatically released when the
    //     target is +link{class.destroy(),destroyed}.</li>
    // </ul>
    //
    // @param object (Object) Object to observe. This may be any JavaScript object with the specified
    //   target method, including native arrays, and instances of SmartClient classes such as
    //   +link{class:canvas}.
    // @param methodName (String) Name of the method to observe. Every time this method is invoked
    //   on the target object the specified action will fire
    //   (after the default implementation completes).
    // @param [action] (Function | String) Optional action to take when the observed method is invoked
    //  on the target object.<br>
    //   If <code>action</code> is a string to execute, certain keywords are available for context:
    //   <ul>
    //   <li><code>observer</code> is this object (the object on which the
    //       <code>observe(...)</code> method was called).</li>
    //   <li><code>observed</code> is the target object being observed (on which the method was invoked).</li>
    //   <li><code>returnVal</code> is the return value from the observed method (if there is one)</li>
    //   <li>For functions defined with explicit parameters, these will also be available as keywords within
    //       the action string</li>
    //   </ul>
    //   If <code>action</code> is a function, this will be executed in the scope of the
    //   observer (so <code>this</code> will be the object on which <code>observe()</code>
    //   was invoked). The arguments for the original method will also be
    //   passed to this action function as arguments. If developers need to access the target
    //   object being observed from the action function they may use native javascript techniques
    //   such as
    //   +externalLink{https://developer.mozilla.org/en-US/docs/Web/JavaScript/Closures,javascript closure}
    //   to do so. The return value from the observed method is not available to the action function.<br>
    //   If the <code>action</code> parameter is omitted the default behavior will invoke the
    //   same named method on the observer, passing in the same parameters.
    //
    //        @return    (boolean)    true == observation set up, false == observation not set up
    //      @see Class.ignore()
    //        @group    observation
    // @visibility external
    //<



    observe : function (object, methodName, action) {
        // if the object doesn't exist or doesn't implement a method with this name, return false to
        // indicate that the observation isn't going to work
        if (object == null) {
            //>DEBUG
            this.logWarn("Invalid observation: Target is not an object.  target: " + object +
                         ", methodName: " + methodName + ", action: '" + action + "'");
            //<DEBUG
            return false;
        }

        // If this property is not a method, or a methodString, log a warning and return false
        //  Note: we're calling the static isc.Func.convertToMethod(...) as we know this
        //  function exists and will return false if the object's class, and the object have
        //   no methodStringRegistry.
        if (!isc.Func.convertToMethod(object, methodName)) {
            //>DEBUG
            this.logWarn("Invalid observation: property: '" + methodName +
                         "' is not a method on " + object);
            //<DEBUG
            return false;
        }
        //this.logWarn("observing: " + methodName + " on " + object + " with action: " + action);

        // If this function has an obfuscated version, observe that also
        var obName = isc.__remap[methodName];
        if (object[obName]) this.observe(object, obName, action)

        // get the name we're going to hide the original method under.  NOTE: important to name
        // this with a leading underscore, so getUniqueProperties ignores it.
        var saveMethodName = isc._obsPrefix + methodName;

        // Now we're definitely working with a method
        var origMethod = object[methodName], argStr;
        if (origMethod._isObservation && object[saveMethodName]) {
            origMethod                 = object[saveMethodName];
        }

        if (isc.isAn.Instance(object) && object.getClass().getInstanceProperty(methodName)) {
            argStr = object.getClass().getArgString(methodName);
        // NOTE: currently, there's no such thing as a classMethod that is a stringMethod
        } else {
            // this code path is needed for two cases:
            // * methods set in autoChildDefaults (caught by getInstanceProperty)
            // * class methods (caught by isAn.Instance())
            argStr = isc.Func.getArgString(origMethod);
        }
        var args = argStr.split(",");

        // if no action was defined, set it to call the method on the target
        if (action == null || isc.is.emptyString(action)) {
            if (!this[methodName] || !this.convertToMethod(methodName)){
                //>DEBUG
                this.logWarn("Invalid Observation - no action specified, and observer: " + this +
                            " has no method '" + methodName + "', ignoring");
                //<DEBUG
                return false;
            }
            action = "it." + methodName + "(" + argStr + ")";
        }

        if (!isc.isA.Function(action)) {
            action = isc.Class._makeThunkFunction(argStr, action);
        }

        action._argString = argStr;

        //
        // add the observer and action to the object's observers list
        //

        // if there is no observers registry set up, create it.
        // object._observers is { methodName :
        //                           [{target:observingObject, action:codeString}]
        //                      }
        if (!object._observers) object._observers = {};

        // if there is not an observer queue for the method, create it
        if (!object._observers[methodName]) {
            var queue = object._observers[methodName] = [];
            if (args.length > 0) {
                // remember the args to the function for later
                queue.argStr = argStr;
            }
        // otherwise
        } else {
            // get the observer queue: the list of existing observers of this method
            var queue = object._observers[methodName];
            // see if this object is already observing this method
            for (var i = 0, len = queue.length; i < len; i++) {
                var q = queue[i];
                // if this object is found in the queue, return false since we're already observing
                // this method
                if (q.target == this) {
                    if (q._removedWhileNotificationRunning &&
                        !q._addedWhileNotificationRunning)
                    {
                        // special case: this observation was already ignored, but a re-
                        // observation is being done from inside the notified function.
                        // Disable _removedWhileNotificationRunning and update the
                        // action.
                        q._removedWhileNotificationRunning = false;
                        q._addedWhileNotificationRunning = true;
                        q.action = action;
                        return true;
                    }
                    //>DEBUG
                    this.logWarn("Observer: " + this + " is already observing method '" +
                                 methodName + "' on object '" + object + "', ignoring");
                    //<DEBUG
                    return false;
                }
            }
        }

        // Note whether we're currently running the notification function.

        var notificationRunning = !!queue._notifyStack;

        // add a reference to the observer to the observer queue for the method
        var q = {
            target: this,
            action: action,
            // Track whether this method was added while the notification function was
            // running - this allows us to avoid running this observer action until
            // after the method has completed.
            _addedWhileNotificationRunning: notificationRunning
        };
        queue.add(q);

        // if the object already has a method by that name, the same method we're trying to
        // observe is being observed by someone else.  We'll both call the original method by
        // the same name.
        if (object[saveMethodName] == null) {
            object[saveMethodName] = origMethod;

        // If we are already observing the method,
        // if the slot contains a method that isn't a notification method, log a warning and
        // copy the new method into the 'saveMethodName' slot. This will happen if a developer
        // does someObject.methodName = function () {...} rather than using addProperties on
        // a method that is already being observed.
        } else if (!object[methodName]._isObservation) {
            this.logWarn("Observation error: method " + methodName
                + " is being observed on object " + object + " but the function appears to have "
                + "been directly overridden. This may lead to unexpected behavior - to avoid "
                + "seeing this message in the future, ensure the addMethods() or addProperties() "
                + "API is used to modify methods on live SmartClient instances, rather than simply "
                + "reassigning the method name to a new function instance.");
            object[saveMethodName] = object[methodName];
        }

        // replace the observed method with a new function that will call the original method
        // then call all the observers
        if (!notificationRunning && !object[methodName]._isObservation) {
            object[methodName] = isc.Class._makeNotifyFunction(methodName);
        }

        // track our observations so we can clear them on destroy()
        if (!this._observations) this._observations = [];
        this._observations.push({object : object, methodName: methodName, action: action});

        // return true that everything went OK
        return true;
    },

    _clearObservationsForDestroy : function () {
        // Clear this objects' observations - i.e. observations this objects has on other objects
        if (this._observations) {
            // Use a copy of the internal _observations array because ignore() will modify the original.
            var observations = this._observations.duplicate();
            while (observations.length) {
                var observation = observations.pop();
                this.ignore(observation.object, observation.methodName);
            }
        }

        // Clear others' observations of me
        if (this._observers) {
            var methodNames = isc.getKeys(this._observers);
            while (methodNames.length) {
                var methodName = methodNames.pop();
                // Use a copy of array because ignore() will modify the original.
                var observersOfMethod = this._observers[methodName].duplicate();
                while (observersOfMethod.length) {
                    var observer = observersOfMethod.pop();

                    if ("destroy" == methodName) {
                        // defer ignore until notification completes
                        observer._ignoreAfterNotify = true;
                    } else {
                        observer.target.ignore(this, methodName);
                    }
                }
            }
        }
    },

    //>    @method        class.ignore()    (A)
    //        Stop observing a method on some other object.
    //
    //        @param    object        (Object)    object to observe
    //        @param    methodName    (String)    name of the method to ignore
    //
    //        @return    (boolean)    true == observation stopped, false == no change made
    //      @see Class.observe()
    //        @group    observation
    // @visibility external
    //<
    ignore : function (object, methodName) {
        var undef;
        // also ignore the obfuscated version if present
        var obName = isc.__remap[methodName];
        if (obName !== undef && object[obName]) this.ignore(object, obName);

        // get the name we would have squirreled the original method under
        var saveMethodName = isc._obsPrefix+methodName;
        // and if we can't find a method with that name, or the object has no observers
        //    return false to indicate that the object isn't currently being observed on this method
        if (!object[saveMethodName] || !object._observers) return false;

        // get a pointer to the message queue for the method
        var queue = object._observers[methodName],

            // Note: if the the observed function is currently being run, we want the observer
            // action to fire as normal in response to this thread, but not for subsequent
            // calls to the observed method.
            // To achieve this, we flag the observer action, then clear it out of the queue
            // when the observed method (actually the notification method) completes.

            notificationRunning = queue._notifyStack;


        // remove the object in the queue that points to this object
        var q;
        for (var i = 0, len = queue.length; i < len; i++) {
            q = queue[i];
            if (q.target == this) {

                if (notificationRunning) {
                    q._removedWhileNotificationRunning = true;
                } else {
                    queue.removeAt(i);
                }

                break;
            }
        }

        // if we've removed everything from the queue
        // restore the original method

        // Note - if the slot contains a non-notification function we're in an invalid state.
        // Basically this implies the developer clobbered the notification function by going
        //  someObject.methodName = function () {...}
        // on a method that was currently being observed.
        // Warn when we see this case, and assume the current function should be preserved if
        // possible.
        if (!object[methodName] || !object[methodName]._isObservation) {
            this.logWarn("Observation error caught in ignore(): Method " + methodName
                + " was being observed on object " + object + " but the function appears to have "
                + "been directly overridden. This may lead to unexpected behavior - to avoid "
                + "seeing this message in the future, ensure the addMethods() or addProperties() "
                + "API is used to modify methods on live SmartClient instances, rather than simply "
                + "reassigning the method name to a new function instance.");
            object[saveMethodName] = object[methodName];
        }

        if (queue.length == 0) {
            // restore the original function to its original name
            object[methodName] = object[saveMethodName];
            // clear the new method slot
            delete object[saveMethodName];
            // remove the observer queue
            delete object._observers[methodName];
        }

        // unregister from this._observations
        if (this._observations) {
            for (var i = 0; i < this._observations.length; i++) {
                if (this._observations[i].object == object && this._observations[i].methodName == methodName) {
                    this._observations.removeAt(i);

                    break;
                }
            }
        }

        // return true that everything went OK
        return true;
    },

    //> @method class.getObserversOf() (A)
    // Return all targets observing a message of this object.
    //
    // @param  methodName  (String)  name of the method to observed
    // @return (Array of Object)  array of observing objects or null if no observers
    // @group  observation
    //<
    getObserversOf : function (methodName) {
        if (!this._observers) return null;

        var queue = this._observers[methodName];
        if (!queue) return null;

        var observers = [];
        for (var i = 0; i < queue.length; i++) {
            if (!queue[i]._removedWhileNotificationRunning) {
                observers[observers.length] = queue[i].target;
            }
        }
        return observers.length ? observers : null;
    },

    //> @method class.isObserving() (A)
    // Return true if this object is already observing a method of another object
    //
    // @param  object      (Object)  object we may be observing
    // @param  methodName  (String)  name of the method to observed
    // @return (boolean)   true if we're already observing that method
    //
    // @group  observation
    // @visibility external
    //<
    isObserving : function (object, methodName) {
        // if nothing is being observed on the object at all, forget it
        if (!object._observers) return false;

        // get the queue of observers of that method, bailing if none found
        var queue = object._observers[methodName];
        if (!queue) return false;

        // return true if we are one of the observers
        for (var i = 0; i < queue.length; i++) {

            if (queue[i].target == this && !queue[i]._removedWhileNotificationRunning) {
                return true;
            }
        }
        // otherwise return false 'cause we're not observing
        return false;
    },

    //>    @method    class.convertToMethod()
    //
    //    This takes the name of an instance property as a parameter, and (if legal) attempts to
    //  convert the property to a function.
    //  If the property's value is a function already, or the property is registered via
    //  class.registerStringMethods() as being a legitimate target to convert to a function,
    //  return true.
    //  Otherwise return false
    //
    //    @param    functionName     (String)    name of the property to convert to a string.
    //
    //    @return                    (boolean)   false if this is not a function and cannot be converted
    //                                      to one
    //
    //<
    convertToMethod : function (methodName) {
        // accessor for isc.Func.convertToMethod, rather than duplicating that code
        return isc.Func.convertToMethod(this, methodName);
    },

    //> @method class.evaluate()
    //
    // Evaluate a string of script in the scope of this instance (so <code>this</code>
    // is available as a pointer to the instance).
    //
    // @param expression (String) the expression to be evaluated
    // @param evalArgs (Object) Optional mapping of argument names to values - each key will
    //      be available as a local variable when the script is executed.
    // @return (Any) the result of the eval
    // @see classMethod:Class.evaluate
    // @visibility external
    //<
    evaluate : function (expression, evalVars) {
        return isc.Class.evaluate.apply(this, [expression, evalVars]);
    },


    //>    @method    class.fireCallback()
    //
    //    Method to fire a callback. Callback will be fired in the scope of the object on
    //  which this method is called.<br>
    //  Falls through to +link{classMethod:Class.fireCallback()}
    //
    //    @param    callback    (Callback) Callback to fire
    //  @param  [argNames]        (String)    comma separated string of variables
    //  @param  [args]            (Array)     array of arguments to pass to the method
    //
    //  @return (Any)   returns the value returned by the callback method passed in.
    //  @visibility external
    //<

    fireCallback : function (callback, argNames, args, catchErrors) {

        return this.getClass().fireCallback(callback, argNames, args, this, catchErrors);
    },

    //> @method class.delayCall()
    //  This is a helper to delay a call to some method on this object by some specified
    //  amount of time.
    // @param methodName (String) name of the method to call
    // @param [arrayArgs] (Array) array of arguments to pass to the method in question
    // @param [time] (number) Number of ms to delay the call by - defaults to zero (so just pulls
    //                        execution of the method out of the current execution thread.
    // @return (String) Timer ID for the delayed call - can be passed to
    //                      +link{Timer.clear()} to cancel the call before it executes
    // @visibility external
    //<
    delayCall : function (methodName, arrayArgs, time) {
        return this.getClass().delayCall(methodName, arrayArgs, time, this);
    },


    //> @method Class.fireOnPause()
    // Given some repeatedly performed event (EG keypress, scroll, etc), set up an action
    // to fire when the events have stopped occurring for some set period.
    // @param id (String) arbitrary identifier for the action
    // @param callback (Callback) action to fire on quiescence
    // @param [delay] (number) delay in ms - defaults to 200ms
    // @param [predicate] (Function) if provided, is evaluated whenever the callback is ready
    //                    to fire; callback will be rescheduled if predicate evaluates false
    //<
    fireOnPause : function (id, callback, delay, predicate) {
        return this.getClass().fireOnPause(id, callback, delay, this, this.getID(), predicate);
    },

    //> @method Class.pendingActionOnPause()
    // Returns true iff an action has been scheduled by fireOnPause() to fire when
    // events have stopped occurring for some set period,
    // @param id (String) arbitrary identifier for the action
    //<
    pendingActionOnPause : function (id) {
        var actions = this.getClass()._actionsOnPause[id],
            instanceID = this.getID() || this.getClassName();
        return actions ? !!actions[instanceID] : false;
    },

    //> @method Class.cancelActionOnPause()
    // Canels a pending action that has already been scheduled.
    // @param id (String) arbitrary identifier for the action
    //<

    cancelActionOnPause : function (id) {
        var actions = this.getClass()._actionsOnPause[id],
            instanceID = this.getID() || this.getClassName();
        if (actions && actions[instanceID]) delete actions[instanceID];
    },

    //>    @method    class.evalWithVars()
    //
    // Same as the class method evalWithVars, but implicitly assigns the class on which this method
    // is called as the target.
    //
    // @see classMethod:Class.evalWithVars()
    //<
    evalWithVars : function (evalString, evalVars) {
        return isc.Class.evalWithVars(evalString, evalVars, this);
    },

    getWindow : (
        isc.Browser.isSafari ? function () {
            return window;
        } : function () {
            return this.ns._window;
        }
    ),
    getDocument : (
        isc.Browser.isSafari ? function () {
            return window.document;
        } : function () {
            return this.ns._document;
        }
    ),
    getDocumentBody : function (suppressDocElement) { return isc.Class.getDocumentBody(suppressDocElement); },
    getActiveElement : function () { return isc.Class.getActiveElement(); },

    // Auto Generated Named Children
    // ---------------------------------------------------------------------------------------
    // Subsystem for handling automatically creating the standard children of a compound widget
    // like a Window, which must create header, resizer, etc components.
    //
    // Not fully worked out or mechanisms not documented:
    // - dynamic defaults
    //   - creation via Arrays of String like (window.headerControls) prevents dynamic defaults
    //     from being passed
    //     - could be solved by a registerDynamicDefaults(autoChildName, defaults)
    //   - no way for subclasses to override dynamically provided defaults
    //     - could be solved by a registerDynamicDefaults(autoChildName, defaults, this.Class),
    //       where addAutoChild would traverse registered defaults in className order?
    //   - passthrough properties that are just renames should be declarative, not dynamic
    //     defaults.  Could have a special syntax, valid only for defaults, like:
    //        blahDefaults : {
    //           dataSource:"$creator.hiliteDS"
    //        }
    //     .. these defaults could be "compiled" to speed this up (cache prop names and
    //     assignment function).
    //   - super high-speed (createRaw()) creation
    //     - needs to be overridable (as with other dynamicDefaults), so not just a method in
    //       autoChildDefaults()
    //     - when overriding, don't want to have call Super
    //     - could use a pattern like [className]_configure_autoChildName(autoChild)?
    //     - _completeCreationWithDefaults() is an imperfect implementation of this.
    // - tabs and sections
    //   - "autoChild:blah" achieves lazy creation, but not lazy creation of a hierarchy of
    //     components
    //     - NOTE: edge case: when a tabSet sees "autoChild:blah", the use case may be:
    //       - subclassing TabSet and adding autoChildren, in which case the defaults are found
    //         on the TabSet itself OR
    //       - using a TabSet as one of your autoChildren and creating tab.panes as other
    //         autoChildren, in which case the defaults are on the TabSet's creator.
    //       The TabSet tries to "guess" by looking at whichever widget has [autoChild]Defaults
    //   - tabs, fields, items, sections etc out of reach of autoChild-based configuration
    // - plug-ins
    //   - want
    // - requirement of calling changeDefaults() awkward
    //   - class.init would keep changeDefaults() calls from having to be done in global scope
    //   - could have a specially interpreted property like autoChildDefaults
    // - default way of adding children
    //   - we could have a property like "defaultAutoParent" in order to allow eg Window to
    //     specify that autoChildren are added to the body instead.  If so, we'd need
    //     autoParent:"creator" to mean add to creator despite defaultAutoParent.
    // - for high performance creation of many similar objects, need an API that you can call
    //   that collapses properties and then re-uses then, or possibly even dynamically creates
    //   an ISC Class
    //
    // Internal (for now) usages
    // - providing dynamic properties via an override of
    //   getDynamicDefaults(autoChildName) in order to avoid manual calls to addAutoChild()
    // - widget.autoChildren can be an Array of autoChildren which will be created and added
    //   after initWidget().  This can be handy, but doesn't cleanly allow further subclassing
    //   as is
    //
    // - other best practices:
    //   - when defaults objects get very large consider replacing them with a class definition.
    //     This makes code faster since less properties are added on create(), however, it does
    //     make it less likely that application or patch code that tries to use a different
    //     constructor for that autoChild will succeed.  Splitting skinning-related properties
    //     into a class while retaining behavioral properties (like method overrides) is a good
    //     hedge.
    //
    // - cleanup
    //   - autoChildParentMap is obsoleted by autoParent setting and should be removed
    //   - _autoMaker functionality is probably obsoleted by getDynamicDefaults() and needs to
    //     be removed
    //   - several classes used the autoChild system before it was fully complete, and so have
    //     manual calls to createAutoChild() which are probably unnecessary
    //
    // - notes on design of this system
    //   - considered accepting just simple Strings as autoChild names anywhere Canvii are
    //     normally expected, eg tab.pane and section.items, but:
    //     - this conflicts with allowing globals to be specified as just a String in these
    //       spots.  Specifying strings for globals is actually useful for out-of-order
    //       creation, and when coming from XML, and is a likely newbie error when attempting
    //       to specify a global reference.  If we try to disambiguate via a check for eg
    //       [childName]Defaults and/or whether there is a global Canvas by that name, we still
    //       end up with weird cases where a global might surpress an autoChild or vice versa,
    //       like finding "footer" in window.items
    //     - the String isn't a complete definition of the autoChild anwyay, as in the case of
    //       section.items, the appropriate creator may be the SectionStack or some yet higher
    //       level parent

    //> @groupDef autoChildUsage
    // An AutoChild is an automatically generated subcomponent that a parent component creates to
    // handle part of its presentation or functionality.  An example is the +link{Window} component and
    // its subcomponent the +link{Window.header,header}.
    //
    // <smartclient>
    // <p>
    // AutoChildren support a standard set of properties that can be used to customize or skin
    // them.  The names of these properties are derived from the name of the AutoChild itself.
    // These properties will generally not be separately documented for every AutoChild unless
    // there are special usage instructions; the existence of the properties is implied whenever
    // you see an AutoChild documented.
    // <P>
    // The properties affecting AutoChildren are:
    // <dl>
    //
    // <dt> <b>"show" + name</b> (eg showHeader)
    // <dd> Controls whether the AutoChild should be created and shown at all. Note that the
    // first letter of the AutoChild name is uppercased for this property ("header" -> "Header").
    //
    // <dt> <b>name + "Properties"</b> (eg headerProperties)
    // <dd> Properties to apply to the autoChild created by this particular instance of the
    // parent component.  For example:
    // <pre>
    //        isc.Window.create({
    //            ID: "myWindow",
    //            headerProperties: { layoutMargin: 10 }
    //        });
    // </pre>
    // The above applies a +link{layout.layoutMargin,layoutMargin} of 10 to the header of <code>myWindow</code>,
    // increasing the empty space around the subcomponents of the header (buttons, title label,
    // etc).
    // <P>
    // Generally, *Properties is null.  <b>Do not</b> use the *Properties mechanism for
    // skinning.  See *Defaults next.
    //
    // <dt> <b>name + "Defaults"</b> (eg headerDefaults)
    // <dd> Defaults that will be applied to the AutoChild created by any instance of the
    // parent class.  *Defaults is used for skinning.  This property should never be set when
    // creating an instance of the parent component, as it will generally wipe out defaults
    // required for the component's operation.  Use +link{class.changeDefaults,changeDefaults()}
    // to alter defaults instead. This is generally as part of a custom skin and/or custom component
    // creation - see the +link{group:autoChildren,overview of AutoChildren for component development}
    // for details and examples.
    //
    // <dt> <b>name + "Constructor"</b> (eg headerConstructor)
    // <dd> SmartClient Class of the component to be created.  An advanced option, this
    // property should generally only be used when there is documentation encouraging you to do
    // so.  For example, +link{ListGrid} offers the ability to use simple CSS-based headers or
    // more complex +link{StretchImg} based headers via +link{listGrid.headerButtonConstructor}.
    // The constructor can also be specified using the <code>_constructor</code> property in the
    // defaults for the AutoChild.
    // </dl>
    // </smartclient><smartgwt>
    // <p>
    // AutoChildren support four standard configuration mechanisms that can be used to customize or skin
    // them. Note, however, that configuring AutoChildren in Smart&nbsp;GWT is advanced usage.
    // <p>
    // To determine which AutoChildren exist for a particular component type, search the class' Javadocs
    // for "AutoChild" as there is a getter for each AutoChild that is supported. In the case
    // of a +link{group:multiAutoChildren,MultiAutoChild}, the getter is non-functional (always
    // returns null) and exists only to make you aware that the MultiAutoChild exists.
    // <p>
    // The four different ways to configure AutoChildren in Smart&nbsp;GWT are:
    // <dl>
    // <dt> <b>Visibility</b>
    // <dd> Controls whether the AutoChild should be created and shown at all.  The
    // {@link com.smartgwt.client.widgets.Canvas#setAutoChildVisibility(String, boolean)} or
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#setAutoChildVisibility(String, boolean)} API
    // as appropriate is used to change this property for the named AutoChild.
    //
    // <dt> <b>Properties</b>
    // <dd> Properties to apply to the AutoChild created by a particular instance of the
    // parent component. In the case of a +link{MultiAutoChild}, the properties are applied to each
    // instance created by the parent.
    // <P>
    // To change the properties of an AutoChild of a widget, the
    // {@link com.smartgwt.client.widgets.Canvas#setAutoChildProperties(String, com.smartgwt.client.widgets.Canvas)} or
    // {@link com.smartgwt.client.widgets.Canvas#setAutoChildProperties(String, FormItem)} API
    // is used. To change the properties of an AutoChild of a form item, the
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#setAutoChildProperties(String, com.smartgwt.client.widgets.Canvas)} or
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#setAutoChildProperties(String, FormItem)}
    // API is used. For example:
    // <pre>
    //        final Window myWindow = new Window();
    //        final Layout headerProperties = new Layout();
    //        headerProperties.setLayoutMargin(10);
    //        myWindow.setAutoChildProperties("header", headerProperties);
    // </pre>
    // The above applies a +link{layout.layoutMargin,layoutMargin} of 10 to the header of <code>myWindow</code>,
    // increasing the empty space around the subcomponents of the header (buttons, title label,
    // etc).
    // <P>
    // <b>Do not</b> use the Properties mechanism for skinning.  See Defaults next.
    //
    // <dt> <b>Defaults</b>
    // <dd> Defaults that will be applied to the AutoChild created by any instance of the
    // parent class.  Changing the defaults is used for skinning.  The <code>changeAutoChildDefaults()</code>
    // static method of the target Smart&nbsp;GWT class is used to change the defaults for all
    // instances of the class.  For example, to change the +link{Window.header,Window.header}
    // defaults, the {@link com.smartgwt.client.widgets.Window#changeAutoChildDefaults(String, com.smartgwt.client.widgets.Canvas)}
    // API is used passing "header" for the <code>autoChildName</code>.
    // <p>
    // <code>changeAutoChildDefaults()</code> must be called before any
    // components are created, and will generally be the first thing in your module's
    // <code>onModuleLoad()</code> function.  Alternatively, you can use the JavaScript equivalent
    // <code>Class.changeDefaults()</code> inside of a load_skin.js file - see <i>Skinning
    // AutoChildren</i> below.
    //
    // <dt> <b>Constructor</b>
    // <dd> &#83;martClient Class of the component to be created.  An advanced option, the
    // AutoChild constructor should generally only be changed when there is documentation encouraging
    // you to do so.  For example, +link{ListGrid} offers the ability to use simple CSS-based headers or
    // more complex +link{StretchImg} headers via
    // <code>listGridInstance.setAutoChildConstructor("headerButton", "StretchImg")</code>.
    // To change the constructor of AutoChildren, the
    // {@link com.smartgwt.client.widgets.Canvas#setAutoChildConstructor(String, String)} or
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#setAutoChildConstructor(String, String)}
    // API is used.
    //
    // <p> In order for any class to be referenced within a constructor you must
    // register the class for reflection, and use the fully qualified name of the target
    // class. See +link{group:reflection,Reflection} for details.
    //
    // <p>
    // For some drastic customizations of an AutoChild where the constructor is changed, the
    // signature of the <code>get[AutoChild]()</code> method may have too specific a return type and the
    // {@link com.smartgwt.client.widgets.Canvas#getCanvasAutoChild(String)},
    // {@link com.smartgwt.client.widgets.Canvas#getFormItemAutoChild(String)},
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#getCanvasAutoChild(String)}, or
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#getFormItemAutoChild(String)} API
    // as appropriate would need to be used instead to retrieve the AutoChild instance.
    // </dl>
    // <p>
    // <b>NOTE:</b> When setting Properties or Defaults in Smart&nbsp;GWT, attributes and event
    // handlers can be set, but override points are not supported.
    // </smartgwt>
    //
    // <p>
    // The AutoChild system can be used to create both +link{canvas.children,direct children}
    // and indirect children (children of children).  For example, the
    // +link{window.minimizeButton,minimizeButton} of the Window is also an autoChild, even
    // though it is actually located within the window header.
    // <P>
    // <h4>Skinning AutoChildren</h4>
    // <P>
    // Skinning AutoChildren by changing the AutoChild defaults is typically done for two purposes:
    // <ul>
    // <li> Changing the default appearance or behavior of a component, for example, making all
    // Window headers shorter
    // <li> Creating a customized variation of an existing component <i>while retaining the
    // base component unchanged</i>.  For example, creating a subclass of Window called
    // "PaletteWindow" with a very compact appearance, while leaving the base Window class
    // unchanged so that warning dialogs and other core uses of Windows do not look like
    // PaletteWindows.
    // </ul>
    // The best code examples for skinning are in the load_skin.js file for the "&#83;martClient"
    // skin, in <code>isomorphic/skins/&#83;martClient/load_skin.js</code>.
    // <P>
    // <h4>Passthroughs (eg window.headerStyle)</h4>
    // <P>
    // In many cases a component will provide shortcuts to skinning or customizing its
    // AutoChildren, such as +link{window.headerStyle}, which becomes header.styleName.  When
    // these shortcuts exist, they must be used instead of the more general AutoChild skinning
    // system.
    // <P>
    // <h4>Safe Skinning</h4>
    // <P>
    // Before skinning an AutoChild consider the +link{group:safeSkinning,safe skinning guidelines}.
    // <P>
    // <h4>Accessing AutoChildren Dynamically</h4>
    // <P>
    // For a component "Window" with an AutoChild named "header", if you create a Window
    // called <code>myWindow</code>, the header AutoChild is available
    // <smartclient>as <code>myWindow.header</code></smartclient>
    // <smartgwt>via <code>myWindow.getHeader()</code></smartgwt>.
    // <P>
    // Unless documented otherwise, an AutoChild should be considered an internal part of a
    // component.  Always configure AutoChildren by APIs on the parent component when they
    // exist.  It makes sense to access an AutoChild for troubleshooting purposes or for
    // workarounds, but in general, an AutoChild's type, behavior, and internal structure are
    // subject to change without notice in future SmartClient versions.
    // <P>
    // Accessing an AutoChild may give you a way to make a dynamic change to a component that
    // is not otherwise supported by the parent component (for example, changing a text label
    // where there is no setter on the parent).  Before using this approach, consider whether
    // simply recreating the parent component from scratch is a viable option. This approach
    // is more than fast enough for most smaller components, and will not create a reliance on
    // unsupported APIs.
    //
    // @title Using AutoChildren
    // @treeLocation Concepts
    // @visibility external
    //<

    //> @type AutoChild
    // An autoChild is an automatically generated subcomponent that a component creates to
    // handle part of its presentation or functionality.  An example is the Window component and
    // its subcomponent the "header".
    // <P>
    // See +link{group:autoChildUsage,Using AutoChildren} for more information.
    //
    // @group autoChildren
    // @visibility external
    //<

    //> @type MultiAutoChild
    // @see group:multiAutoChildren
    // @visibility external
    //<

    // NOTE: the following groupDef appears only in SmartClient, not SmartGWT.
    //> @groupDef autoChildren
    // An autoChild is an automatically generated subcomponent that a component creates to
    // handle part of its presentation or functionality.
    // <P>
    // An example is the Window component and its subcomponent the "header".
    // <P>
    // AutoChildren support a standard set of properties that can be used to customize or skin
    // them.
    // <P>
    // This topic explains how to use the autoChild system when creating custom components in
    // order to create maximum flexibility.  To learn how to use the autoChild system with
    // pre-existing components, +link{group:autoChildUsage,go here}.
    // <P>
    // Before reading this topic, be sure you have read the +docTreeLink{QuickStart Guide}
    // material on creating custom components and have reviewed the provided examples.
    // <P>
    // <h3>Basics</h3>
    // <P>
    // The following is an example of creating subcomponents <b>without</b> using the AutoChild
    // pattern.  In this case a fictitious "Portlet" class is being created, which uses an
    // instance of isc.Label to serve as it's header.
    // <pre>
    // isc.defineClass("Portlet", "VLayout").addProperties({
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         this.headerLabel = isc.Label.create({
    //             autoDraw:false,
    //             contents: this.title,
    //             styleName: this.titleStyleName,
    //             portlet:this,
    //             click : function () { this.portlet.bringToFront() },
    //             wrap:false,
    //             overflow:"hidden",
    //             width:"100%"
    //         });
    //         this.addMember(this.headerLabel);
    //         ...
    // </pre>
    // While straightforward, this approach provides limited flexibility to someone using the
    // "Portlet" class.  There is no way to:
    // <ol>
    // <li> avoid creating the headerLabel, for a "headerless" portlet
    // <li> use a different, more advanced class as a header (eg, StretchImgButton or a custom
    // class)
    // <li> skin the headerLabel, other than CSS (rounded corners, animations, etc, wouldn't be
    // possible)
    // <li> change it's layout behavior (eg enable autoSize)
    // <li> add or override event handlers
    // </ol>
    // Let's imagine we wanted to add some of the above features.  We could change the code
    // like so:
    // <P>
    // <pre>
    // isc.defineClass("Portlet", "VLayout").addProperties({
    //     <b>showHeaderLabel:true,</b>
    //     <b>headerLabelConstructor:isc.Label,</b>
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         <b>if (this.showHeaderLabel) {</b>
    //             this.headerLabel = this.headerLabelConstructor.create({
    //                 autoDraw:false,
    //                 contents: this.title,
    //                 styleName: this.titleStyleName,
    //                 portlet:this,
    //                 click : function () { this.portlet.bringToFront() },
    //                 wrap:false,
    //                 overflow:"hidden",
    //                 width:"100%"
    //             }<b>, this.headerLabelProperties</b>);
    //             this.addMember(this.headerLabel);
    //         <b>}</b>
    //         ...
    // </pre>
    // Our additions solve our initial concerns:
    // <ul>
    // <li> <code>showHeaderLabel:false</code> can be set to suppress the header label
    // <li> <code>headerLabelConstructor</code> allows you to switch to a different class
    // <li> <code>headerLabelProperties</code> give you a means to add arbitrary properties
    // (skinning properties, sizing properties, event handlers, etc)
    // </ul>
    // However, the code is becoming more verbose and repetitive, and we've created a few
    // additional properties that now need documentation and testing.  This extra work is going
    // to be multiplied by every subcomponent we create where we want this kind of flexibility.
    // <P>
    // Enter the AutoChild system: the purpose of the AutoChild system is to define a standard
    // pattern for creating subcomponents with maximum flexibility.  This means:
    // <ul>
    // <li> developers creating custom components write less code, have less to test and less
    // to document
    // <li> developers can more easily understand each other's code for custom components,
    // because it follows a standard pattern
    // <li> developers <b>using</b> custom components have a standard pattern for
    // customization, instead of learning customization APIs for every component separately
    // </ul>
    // The code below uses the autoChild system to create the "headerLabel" subcomponent.  This
    // version of the code would still respect all of the customization properties from earlier
    // examples (<code>headerLabelProperties</code> et al) and offers several additional degrees
    // of flexibility still to be explained, yet it's significantly shorter.  More importantly,
    // this code is less redundant; the "boilerplate" code is gone and what's left is just the
    // actual settings for the headerLabel subcomponent.
    // <pre>
    // isc.defineClass("Portlet", "VLayout").addProperties({
    //     headerLabelDefaults : {
    //         _constructor:isc.Label,
    //         click : function () { this.creator.bringToFront() },
    //         wrap:false,
    //         overflow:"hidden",
    //         width:"100%"
    //     },
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         this.addAutoChild("headerLabel", {
    //             contents: this.title,
    //             styleName: this.titleStyleName
    //         });
    //         ...
    // </pre>
    // <P>
    // The documentation for +link{class.addAutoChild,addAutoChild()} explains why this code
    // will still respect the <code>showHeaderLabel</code> flag and other customization
    // properties even though they aren't mentioned specifically.
    // <P>
    // Note that AutoChildren are not always created as soon as the parent component, and may
    // be created only when the parent is drawn, or in some cases, only when needed.
    // For the best chance of forward compatibility, use properties and defaults instead of
    // accessing the live reference, and if you do access the live reference, access it only
    // when it is clear that the AutoChild must have been created by that point.
    // For example, even if you determined by experimentation that the Window class currently
    // creates it's "header" AutoChild when the Window is created, you should avoid accessing
    // it until the Window has drawn, to leave room for the Window's implementation to change
    // such that creation of the "header" AutoChild is deferred until draw.
    // <P>
    // <h3>AutoChildren lifecycle</h3>
    // <P>
    // By default any auto-children created by +link{class.addAutoChild()} or
    // +link{class.createAutoChild()} will be +link{canvas.destroy(),destroyed} when the
    // canvas that created them is destroyed. You can suppress this behavior by setting
    // <code>dontAutoDestroy</code> to <code>true</code> on the auto child. To do this you
    // could add the property to the defaults or properties block for the autoChild, or
    // pass it into the creating method in the dynamic set of properties.
    // <p>
    // <h3>Subclassing a component with autoChildren</h3>
    // <P>
    // If you are subclassing a component that has an autoChild and you want to change
    // defaults for that autoChild, the correct way to do so is to use
    // +link{Class.changeDefaults,changeDefaults()}:
    // <pre>
    // isc.defineClass("MyWindow", "Window");
    // isc.MyWindow.changeDefaults("headerDefaults", { layoutMargin:10 });
    // isc.MyWindow.addProperties({
    //    ...
    // </pre>
    // <P>
    // <code>changeDefaults()</code> creates a copy of the superclass defaults and applies your
    // changes, which is important because you want to inherit the superclass behavior without
    // affecting the superclass, and yet apply overrides.
    // <P>
    // The following code sample indicates two common
    // <span style="color:red;font-weight:bold">incorrect</span> patterns for working with
    // defaults, and the consequences of each:
    // <pre>
    // isc.defineClass("MyWindow", "Window").addProperties({
    //     // NO.  Superclass behavior / settings for autoChild
    //     // won't be inherited.  Use changeDefaults() instead.
    //     headerDefaults : { ... },
    //
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         // NO.  "headerDefaults" object is shared across the class,
    //         // changing it affects all instances created from here on.
    //         // Pass dynamic defaults to addAutoChild() instead
    //         this.headerDefaults.myProperty = this.newValue;
    //         ...
    // });
    // </pre>
    // <b>defaults vs properties</b>
    // <P>
    // For AutoChildren, defaults and properties both provide similar means of adding
    // properties to an AutoChild, and the distinction between them is primarily one of
    // convention: a class that uses AutoChildren should never define a default value for
    // <i>autoChildName</i>Properties, so that instances can freely specify
    // <i>autoChildName</i>Properties without overriding built-in behavior.
    // <pre>
    // isc.defineClass("MyWindow", "Window").addProperties({
    //     // NO.  Any further use of "headerProperties", in
    //     // instances or in subclasses, would wipe out behavior
    //     headerProperties : { ... },
    // </pre>
    // <P>
    // By consistently using +link{Class.changeDefaults()} whenever you override autoChild
    // defaults in a subclass, you ensure that your classes can in turn be subclassed and
    // extended uniformly.
    // <P>
    // <h3>autoParents and creation order</h3>
    // <P>
    // The AutoChild pattern can create an entire hierarchy of generated subcomponents.  For
    // example, the +link{Window} class included with SmartClient uses several AutoChildren as
    // part of the overall header structure: separate autoChildren for the minimize button,
    // close button, and then the header itself, a Layout-derived class that contains all other
    // header controls.
    // <P>
    // To facilitate construction of hierarchies of autoChildren, the special
    // <code>autoParent</code> property may appear in either defaults or properties for an
    // autoChild, and indicates the name of another autoChild that should used as a parent.
    // For example, to create a "closeButton" autoChild that will be a member of the "header"
    // autoChild:
    // <P>
    // <pre>
    // isc.defineClass("Portlet", "VLayout").addProperties({
    //     headerDefaults : {
    //         _constructor:isc.HLayout,
    //         ...
    //     },
    //     closeButtonDefaults : {
    //         <b>autoParent:"header",</b>
    //         _constructor:isc.ImgButton,
    //         ...
    //     },
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         this.addAutoChild("header");
    //         this.addAutoChild("closeButton");
    //         ...
    // </pre>
    // <P>
    // In addition to cutting down on code and making inter-autoChild relationships clearer,
    // using <code>autoParent</code> rather than manual calls to addMember() allows a
    // subclass of your component to potentially completely rearrange the autoChildren you have
    // defined, while retaining their behavior.
    // <P>
    // When using <code>autoParent</code> to arrange autoChildren, create parents first, then
    // children.
    // <P>
    // <b>Tip:</b> if you want all of the behaviors of
    // +link{class.addAutoChild(),addAutoChild()} <i>except</i> automatically adding the
    // autoChild to a parent, set <code>autoParent:"none"</code>.
    // <P>
    // <b>special case: TabSets and SectionStacks</b>
    // <p>
    // An autoChild that appears as a +link{tab.pane} or
    // +link{SectionStackSection.items,section item} does not have a clear way to refer to it's
    // tab or section via the <code>autoParent</code> property.  For this special case, the
    // TabSet and SectionStack components allow tab.pane / section.items to contain the special
    // string "autoChild:<i>autoChildName</i>".  This will cause the corresponding autoChild to
    // be automatically created when the tab is selected or section expanded.
    // <P>
    // Generally, whatever component is creating the AutoChildren should be the logically
    // reusable, self-contained component, and all the meaty logic should appear as methods on
    // that component.  Then you know that the +link{class.creator,creator} is always the same
    // thing, and always where all the logic is.
    // <P>
    // For example:
    // <pre>
    // isc.defineClass("Portlet", "VLayout").addProperties({
    //     ...
    //     mainTabsDefaults : {
    //         _constructor:isc.TabSet,
    //         tabs : [
    //             { title:"First Pane", pane:"autoChild:firstPane" }
    //         ]
    //     },
    //     firstPaneDefaults : {
    //         ...
    //     },
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         // this automatically creates firstPane as an autoChild
    //         this.addAutoChild("mainTabs");
    //         ...
    // </pre>
    //
    // @see canvas.autoParent
    // @see class.autoCreator
    // @visibility external
    //<

    //> @groupDef multiAutoChildren
    // A MultiAutoChild is an +link{AutoChild} where the creating component usually creates more than
    // one, hence, unlike a normal AutoChild, the AutoChild is not accessible as <code>creator.[autoChildName]</code>.
    // <P>
    // See +link{group:autoChildUsage,Using AutoChildren} for more information on configuring a
    // MultiAutoChild.
    // @see Class.createAutoChild()
    // @visibility external
    //<

    // break this discussion into safe skinning (visuals only) and safe customization
    // (subclasses and autoChildren)?
    //> @groupDef safeSkinning
    // The skinning mechanism is extremely powerful and gives you the ability to change
    // internal functionality of components.  While this is useful for workarounds, you should
    // think through any properties you override, considering what will happen with future
    // versions of SmartClient, where the defaults may change or be expanded.
    // <P>
    // The following kinds of overrides are generally very safe:
    // <ul>
    // <li> Change +link{canvas.styleName,styleName} or +link{button.baseStyle,baseStyle} to
    // provide a custom CSS style or series of styles
    // <li> Change a media path such as the +link{Img.src,src} of the
    // +link{Window.minimizeButton}.
    // <li> Change the size of any part of the UI that has a fixed pixel size, such as
    // the height and width of the +link{Window.minimizeButton}, especially when this is done
    // to match the size of media you have created
    // <li> Set properties such as +link{button.showRollOver} that cause a component to
    // visually react to more or fewer UI states (disabled, over, down, etc)
    // </ul>
    // The following should be very carefully considered:
    // <ul>
    // <li> Adding custom behaviors by passing in event handlers such as
    // (eg +link{canvas.showContextMenu,showContextMenu()}).  If future versions of the
    // component add more functionality, you may prevent new features from functioning, cause
    // them to function only partially, or break.
    // <P>
    // If you want to ensure that you do not break new functionality added in future SmartClient
    // versions, be sure to call +link{class.Super,Super()} for methods you override, and do not
    // prevent events from bubbling.
    // <P>
    // If you want to ensure that <b>only</b> your custom behavior is used if a future version
    // of a SmartClient component adds functionality, override all methods involved in the
    // interaction, even if your methods do nothing.  For example, for a custom drop
    // interaction, override dropOver, dropMove, dropOut and drop, even if you do nothing on
    // dropMove().  Then, do not call Super() if there is no superclass behavior required for
    // the interaction you've implemented.  Also, for any event handlers (such as drop())
    // return false if you consider your code to have completely handled the event (no
    // parent component should react).
    // </ul>
    // The following are not recommended:
    // <ul>
    // <li> Providing a global +link{Canvas.ID,ID} to a subcomponent (only works once).
    // <li> Overriding +link{canvas.backgroundColor}, +link{canvas.border,border},
    // +link{canvas.margin,margin}, +link{canvas.padding,padding}, or in general any single
    // attribute otherwise controlled by CSS.  Future SmartClient versions may change the base
    // CSS style, rendering your single-property customization senseless.  Change the entire
    // CSS style via +link{canvas.styleName,styleName} instead.
    // </ul>
    //
    // @title Safe Skinning
    // @visibility external
    //<

    //> @type AutoChildShortcut
    // A string with the format "autoChild:<i>autoChildName</i>" passed as a +link{tab.pane} or
    // +link{SectionStackSection.items,section item} instead of an actual +link{Canvas} or ID.
    //
    // @baseType String
    // @see group:autoChildren
    // @visibility external
    //<

    addAutoChildren : function (children, parent, position) {
        if (children == null) return;
        if (!isc.isAn.Array(children)) children = [children];
        for (var i = 0; i < children.length; i++) {
            var child = children[i];
            if (isc.isA.Canvas(child)) {
                parent = parent || this;
                this._addAutoChildToParent(child, parent, position);
                continue;
            }
            // string name, or block of properties specifying an autoChild
            this.addAutoChild(child, null, null, parent, position);
        }
    },

    //> @method class.addAutoChild()
    // Creates a component according to the "AutoChild" pattern, and adds it to this component.
    // <P>
    // See the +link{group:autoChildren,AutoChild usage overview} to understand the general
    // purpose and usage of this method.
    // <P>
    // <code>addAutoChild()</code> takes the following actions:
    // <ol>
    // <li> checks whether this.<i>autoChildName</i> is already populated, and returns it if so
    // <li> checks when there is a show<i>AutoChildName</i> with the value false, and if so
    // returns without creating a component
    // <li> calls +link{createAutoChild()} to create the component
    // <li> sets this.<i>autoChildName</i> to the created component
    // <li> adds the component either to this component, or to some other parent, specified
    // by the "autoParent" property in the autoChild's defaults.  The "autoParent" property may
    // be "none" indicating the autoChild should not be automatically added.
    // </ol>
    // <P>
    // When adding an autoChild to a +link{Layout} subclass,
    // +link{layout.addMember,addMember()} will be called instead of the normal
    // +link{Canvas.addChild,addChild()}.  To prevent this behavior,
    // <code>addAsChild:true</code> can be set in the autoChild defaults.  Similarly,
    // <code>addAsPeer:true</code> may be set to add an autoChild as a peer.
    // <P>
    // <b>Tip:</b> because <code>addAutoChild()</code>
    // checks specifically for show<i>AutoChildName</i>:false, you do not have to add
    // show<i>AutoChildName</i>:true in order for an autoChild to be shown by default; leaving
    // the property undefined is sufficient.
    // <P>
    // Note that by default the child created by this method will be destroyed when
    // +link{canvas.destroy(),destroy()} is called on this instance. To disable this behavior,
    // set <code>dontAutoDestroy</code> to true on the auto child.
    //
    // @param childName (String) name of the autoChild
    // @param defaults (Properties) dynamic properties for the autoChild
    // @return (Class) created autoChild
    //
    // @group autoChildren
    // @visibility external
    //<
    _$maker:"_autoMaker",
    addAutoChild : function (childName, dynamicProperties, defaultConstructor, parent, position) {
        var childValue = this[childName];
        // already created
        if (isc.isAn.Instance(childValue)) return childValue;


        // allow a properties object with autoChildName etc
        if (isc.isAn.Object(childName) && childName.autoChildName) {
            dynamicProperties = childName;
            defaultConstructor = dynamicProperties._constructor || defaultConstructor;
            childName = dynamicProperties.autoChildName;
        }

        // check to see if the value of the childName property is a string that is the global
        // ID of an existing instance (like { header : "myPreviouslyCreatedHeader" })
        if (isc.isA.String(childValue) && window[childValue]) {
            this[childName] = window[childValue];
            return this[childName];
        }

        // check flags, and existence of parents, before proceeding to create the child
        // NOTE: null check allows constructor blocks for unnamed autoChildren (automatically
        // created, but not skinnable)
        if (childName != null && !this.shouldCreateChild(childName)) return;

        // create the child
        // XXX autoMaker functionality is considered legacy; getDynamicDefaults() is believed
        // to handle all cases for which autoMaker was intended, and more cleanly
        // If this[childName]_autoMaker() is defined, call that to make the child, rather than
        // 'createAutoChild()'

        var child,
            makerName = childName + this._$maker;

        if (childName != null && this[makerName]) child = this[makerName](dynamicProperties);
        else {
            child = this.createAutoChild(childName, dynamicProperties, defaultConstructor, true);
        }
        // createAutoChild() may return null if we're not configured to create this child.
        // A custom maker function may return null if it wants to handle adding the child to
        // the appropriate parent itself (and assinging the child to the appropriate property
        // name)
        if (!child) return;

        // If we went through createAutoChild with the assignToSlot parameter, this is unnecessary
        // but if we ran the maker method, we have to actually assign this[childName] to the
        // generated object
        // Note: assignment to slot can be suppressed by the autoChild creation logic (e.g. for
        // spacer creation where assignment doesn't make sense)
        if (child._assignToSlot !== false) this[childName] = child;

        this._addToParent(childName, child, parent, position);

        return child;
    },

    _$creator:"creator",
    _addToParent : function (childName, child, parent, position) {
        // ways of specifying parent, in order of preference
        // - pass into addAutoChild / createAutoChild (becomes parent param here)
        // - as child.autoParent, for any source of properties
        // - define this.autoChildParentMap
        // - finally, "this" assumed
        if (parent == null) {
            parent = child.autoParent || this.getAutoChildParent(childName);
        }
        if (isc.isA.String(parent)) {
            // constant meaning no parent, eg, pop-up dialog
            if (parent == isc.Canvas.NONE) {
                if (this.isDrawn()) child.draw();
                return;
            }

            var canvasParent = this[parent] || window[parent] || parent;
            if (!isc.isA.Canvas(canvasParent)) {
                this.logWarn("no valid parent could be found for String '" + parent + "'");
            } else parent = canvasParent;
        }

        // do nothing if the created child is not a Canvas or derived parent isn't a canvas.
        if (!isc.isA.Canvas(child) || !isc.isA.Canvas(parent)) return;

        this._addAutoChildToParent(child, parent, position);
    },

    _addAutoChildToParent : function (child, parent, position) {
        // add to parent, as member or child
        if (child.addAsPeer || child.snapEdge) parent.addPeer(child);
        else if (isc.isA.Layout(parent) && !child.addAsChild && !child.snapTo) parent.addMember(child, position);
        else if (isc.TileLayout && isc.isA.TileLayout(parent) && !child.addAsChild && !child.snapTo) parent.addTile(child, position);

        else parent.addChild(child);
    },

    // defaults to creating child if this.show[ChildName] isn't explicitly set to false.  If the
    // child is declared to have a named parent, checks that the parent will be created too
    _$show : "show",
    shouldCreateChild : function (childName) {
        var showProperty = this._$show + childName.charAt(0).toUpperCase() + childName.substring(1);
        if (this[showProperty] != null && this[showProperty] == false) return false;

        // check whether the parent will be created
        var parentName = this._getAutoChildParentName(childName);
        if (parentName == null) return true;
        return (this.shouldCreateChild(parentName));
    },

    _$Constructor: "Constructor",

    getAutoChildClass : function (childName, dynamicProperties, defaultConstructor,
                                  childDefaultsName, childPropertiesName, isMultiChild)
    {
        // creator constructor has highest priority except for multiAutoChild
        var creatorConstructor = this[childName + this._$Constructor];
        if (creatorConstructor && !isMultiChild) return creatorConstructor;

        // dynamic properties have highest priority of all remaining sources
        if (dynamicProperties && dynamicProperties._constructor) {
            return dynamicProperties._constructor;
        }
        if (creatorConstructor) return creatorConstructor;

        // use childPropertiesName if passed, so it doesn't have to be recalc'd
        childPropertiesName = childPropertiesName || this._getPropertiesName(childName);
        var childProperties = this[childPropertiesName];
        if (childProperties && childProperties._constructor) {
            return childProperties._constructor;
        }
        // use childDefaultsName if passed, so it doesn't have to be recalc'd
        childDefaultsName = childDefaultsName || this._getDefaultsName(childName);
        var childDefaults = this[childDefaultsName];
        if (childDefaults && childDefaults._constructor) {
            return childDefaults._constructor;
        }
        return defaultConstructor || isc.Canvas;
    },

    // get defaults for all auto children
    applyBaseDefaults : function (child, childName, dynamicDefaults) {
        child.autoDraw = false;
        child._generated = true;
        child.__name = childName;

        // special "creator" property obviates the need to pass "window:this" et al dynamically
        child.creator = this;
        // ability to rename the "creator" pointer for clarity
        var creatorName = this.creatorName;
        if (creatorName) child[creatorName] = this;

        // generate an ID for the autoChild based on it's name.  NOTE: can be suppressed by
        // passing ID:null in dynamicProperties
        var undef;
        if (dynamicDefaults == null || dynamicDefaults.ID === undef) {
            child.ID = this.getID() + isc._underscore + childName;
            // if the defaultID collides, uniquify it.  This allows createAutoChild() to be
            // called multiple times on the same config block
            if (window[child.ID]) {
                child.ID = child.ID + isc._underscore + isc.ClassFactory.getNextGlobalID();
            }
        }
    },

    getDynamicDefaults : function () {},

    _$Defaults: "Defaults",
    _getDefaultsName : function (childName) {
        var cache = isc.Class._defaultsCache;
        if (!cache) isc.Class._defaultsCache = cache = {};

        if (cache[childName]) return cache[childName];

        var defaultsName = childName + this._$Defaults;
        if (this[defaultsName]) cache[childName] = defaultsName;
        return defaultsName;
    },

    _$Properties: "Properties",
    _getPropertiesName : function (childName) {
        var cache = isc.Class._propertiesCache;
        if (!cache) isc.Class._propertiesCache = cache = {};

        if (cache[childName]) return cache[childName];

        var propertiesName = childName + this._$Properties;
        if (this[propertiesName]) cache[childName] = propertiesName;
        return propertiesName;
    },

    //> @method class.createAutoChild()
    // Unconditionally creates and returns a component created according to the "AutoChild"
    // pattern.
    // <P>
    // In addition to applying defaults and properties as described under the
    // +link{group:autoChildUsage,AutoChild overview}, the created autoChild:
    // <ul>
    // <li> is automatically <code>autoDraw:false</code>
    // <li> has a <code>creator</code> property that points to this component, for easy
    // authoring of event handlers (eg click:"this.creator.doSomething()")
    // </ul>
    // <P>
    // Unlike +link{addAutoChild()}, <code>createAutoChild()</code> does not create a
    // this.<i>autoChildName</i> reference to the component, check a show<i>AutoChildName</i>
    // flag, or automatically add the autoChild via +link{Canvas.addChild()}.
    // <P>
    // General you use <code>createAutoChild</code> rather than addAutoChild when:
    // <ul>
    // <li> you are going to create several autoChildren with a common set of defaults (for
    // example the +link{columnTree.column,column} autoChild of the +link{ColumnTree}).
    // <li> children need to be created before their parents (eg, for layout/auto-sizing
    // reasons)
    // </ul>
    // <P>
    // Note that by default the child created by this method will be destroyed when
    // +link{canvas.destroy(),destroy()} is called on this instance. To disable this behavior,
    // set <code>dontAutoDestroy</code> to true on the auto child.
    //
    // @param childName (String) name of the autoChild
    // @param defaults (Properties) dynamic properties for the autoChild
    // @return (Class) created autoChild
    //
    // @group autoChildren
    // @visibility external
    //<
    _$spacerChildPrefix: "spacer:", // also used by Canvas
    createAutoChild : function (childName, passedDynamicDefaults, defaultConstructor,
                                assignToSlot, isMultiChild)
    {
        if (isc.startsWith(childName, this._$spacerChildPrefix)) {
            var spacerLength = childName.substring(this._$spacerChildPrefix.length);
            var lengthAttribute = "width";
            if (this.orientation == isc.Layout.VERTICAL) lengthAttribute = "height";
            var props = {autoDraw: false, _assignToSlot: false};
            props[lengthAttribute] = spacerLength;
            return isc.LayoutSpacer.create(props);
        }

        var dynamicDefaults = this.getDynamicDefaults(childName);

        // NOTE: dynamicDefaults: generally, you will *either* pass dynamic defaults to
        // addAutoChild() *or* implement getDynamicDefaults() for cases where you don't call
        // addAutoChild directly.  It would be weird to do both, so we make sure it works, but
        // it's not as fast.
        if (dynamicDefaults != null && passedDynamicDefaults != null) {
            dynamicDefaults = isc.addProperties({}, dynamicDefaults, passedDynamicDefaults);
        } else {
            dynamicDefaults = passedDynamicDefaults || dynamicDefaults;
        }


        // standard name for defaults (eg bodyDefaults)
        var childDefaultsName = this._getDefaultsName(childName),
            childDefaults = this[childDefaultsName],
            childPropertiesName = this._getPropertiesName(childName),
            childProperties = this[childPropertiesName],
            // pass childDefaultsName so it doesn't have to be recalc'd
            childClassName = this.getAutoChildClass(childName, dynamicDefaults,
                defaultConstructor, childDefaultsName, childPropertiesName, isMultiChild),
            childClass = isc.ClassFactory.getClass(childClassName)
        ;
        if (childClass == null) {
            this.logWarn("Unable to create autoChild '"+childName
                         +"' of type '"+childClassName+"' - no such class in runtime.");
            if (isc.isA.String(childClassName) && childClassName.contains(".")) {
                this.logWarn("Did you make the SmartGWT class reflectable? See http://www.smartclient.com/smartgwt/javadoc/com/smartgwt/client/docs/Reflection.html");
            }
            return null;
        }

        dynamicDefaults = this.applyDuplicateAutoChildDefaults(
                            childClass,
                            childDefaultsName,
                            dynamicDefaults
                          );

        var child = childClass.createRaw();

        // autoPassthroughs: mechanism for declaring that certain properties on an autoParent
        // should be passed-through to the same-named properties on children
        // DO NOT USE, this will probably be renamed
        var passthroughs = this.autoPassthroughs,
            passthroughValues,
            undef;
        if (passthroughs) {
            for (var propName in passthroughs) {
                var targetChildName = passthroughs[propName];
                if (childName == targetChildName && this[propName] !== undef) {
                    child[propName] = this[propName];
                }
            }
        }

        this.applyBaseDefaults(child, childName, passedDynamicDefaults);

        isc.addProperties(child,
                          this.autoChildDefaults,
                          childDefaults,
                          passthroughValues,
                          dynamicDefaults);

        // call configure methods if available.  These allow maximum speed dynamicDefaults
        // through direct property assignment on the half-created autoChild.  Different
        // autoChildren can be quickly identified (eg child == this.newButton), and sharing
        // defaults across different autoChildren is easier.  These APIs are very advanced
        // because caller needs to understand the half-initialized "raw" state.

        if (assignToSlot) this[childName] = child;
        if (child.autoConfigure) child.autoConfigure(this, childName);
        if (this.configureAutoChild) this.configureAutoChild(child, childName);
        isc.addProperties(child, this[childPropertiesName]);


        // dynamic interface mixins for autochildren/instances
        //if (isc.Log && isc.Log.logWarn) isc.Log.logWarn(this.getClassName());
        if (child._mixIns) {
            child.mixInInterface(child._mixIns);
        }

        // call initInterface() on any member interfaces that define the method
        if (childClass._initInterfaceMethods) {
            for (var i = 0; i < childClass._initInterfaceMethods.length; i++) {
                childClass._initInterfaceMethods[i].call(child);
            }
        }

        // call initInterface() on any member interfaces that define the method
        if (child._initInterfaceMethods) {
            for (var i = 0; i < child._initInterfaceMethods.length; i++) {
                child._initInterfaceMethods[i].call(child);
            }
        }

        child.init();

        // Possibly extract from a config block -- will return the child itself
        // if this isn't a SmartGWT config block
        child = isc.SGWTFactory.extractFromConfigBlock(child);
        // Re-assigning to slot in case we extracted the child from an SGWT config block
        if (assignToSlot) this[childName] = child;

        // Maintain a mapping between child name and generated auto children IDs
        // This allows us to auto-destroy autochildren on destroy
        // Also used by the AutoTest locator APIs
        if (!this._createdAutoChildren) this._createdAutoChildren = {};
        var ID = child.getID ? child.getID() : null;
        if (ID != null) {

            if (!isc.isAn.Array(this._createdAutoChildren[childName])) {
                if (this._createdAutoChildren[childName] != null) {
                    isc.logWarn(this + ".createAutoChild(): Creating auto child named:" + childName
                        + " appears to be replacing autoChild with same name...");
                }
                this._createdAutoChildren[childName] = [ID];

            } else {
                this._createdAutoChildren[childName].add(ID);
            }
        }

        return child;
    },

    //> @attr class.creator (Class : varies : R)
    // For an +link{group:autoChildren,AutoChild}, a read-only reference to the component on
    // which +link{createAutoChild()} or +link{addAutoChild()} was called to create it.
    // Useful for authoring of event handlers (eg click:"this.creator.doSomething()")
    // @see autoCreator
    // @group autoChildren
    // @visibility external
    //<

    //> @attr class.autoCreator (Class | String : varies : IRA)
    // Specifies the component on which +link{class.createAutoChild()} should be called to
    // create +link{group:autoChildren} defined lazily on this component in the format
    // "autoChild:<i>autoChildName</i>".  This property may be either specified as a live
    // component, or set to the <code><i>childName</i></code> of another already-created
    // AutoChild.
    // <P>
    // If left unspecified, the Framework applies rules to determine which component to use as
    // the creator.  If this component is itself an autochild, and properties or defaults for
    // the child are defined on its +link{creator} but not on the component itself, then the
    // creator of this component is also used to create the new AutoChild.  Otherwise, this
    // component is used.
    // @group autoChildren
    // @see group:autoChildren
    // @visibility external
    //<

    // When creating an autoChild, clone attributes registered for duplication
    // from the class level defaults block (or the special 'autoChildDefaults' object) and
    // apply cloned versions to dynamic defaults
    // Returns dynamicDefaults passed in - may be null or a new object if the
    // dynamicDefaults were unset originally
    applyDuplicateAutoChildDefaults : function (childClass, childDefaultsName, dynamicDefaults) {
          // clone attributes from class level defaults block that are registered for duplication
        var dupProps = childClass._dupAttrs;
        if (dupProps && dupProps.length > 0) {

            var childDefaults = this[childDefaultsName];

            if (childDefaults != null || this.autoChildDefaults != null) {
                for (var i = 0; i < dupProps.length; i++) {
                    var attr = dupProps[i],
                        undef;

                    if (childDefaults != null && childDefaults[attr] != null) {

                        if (dynamicDefaults == null) dynamicDefaults = {};
                        if (dynamicDefaults[attr] === undef) {
                            dynamicDefaults[attr] = childClass.cloneDupPropertyValue(
                                                        attr, childDefaults[attr]
                                                    );
                        }
                    } else if (this.autoChildDefaults != null &&
                                this.autoChildDefaults[attr] != null)
                    {
                        if (dynamicDefaults == null) dynamicDefaults = {};
                        if (dynamicDefaults[attr] === undef) {
                            dynamicDefaults[attr] = childClass.cloneDupPropertyValue(
                                                        attr, this.autoChildDefaults[attr]
                                                    );
                        }
                    }
                }
            }
        }
        return dynamicDefaults;
    },


    _completeCreationWithDefaults : function (childName, child, dynamicDefaults) {
        this.applyBaseDefaults(child, childName, dynamicDefaults);

        var childDefaultsName = this._getDefaultsName(childName),
            childPropertiesName = this._getPropertiesName(childName)
        ;

        // duplicate properties from the defaults to the dynamicDefaults block if necessary
        var childClass = child.getClass();

        // Note that this won't do anything for SGWT config blocks. But that's OK,
        // because the proper properties will eventually be duplicated when the
        // real Smartclient object is created.
        dynamicDefaults = this.applyDuplicateAutoChildDefaults(
                                childClass,
                                childDefaultsName,
                                dynamicDefaults
                          );

        child.completeCreation(
            // defaults for all named children
            this.autoChildDefaults,
            // instance defaults (for skinning) (eg bodyDefaults)
            this[childDefaultsName],
            // dynamic defaults
            dynamicDefaults,
            // user-provided instance properties
            this[childPropertiesName]
        );
    },

    // parents of named children can be declared as a map "autoChildParentMap" from child name
    // to parent name, on the assumption the parent is also a named child.
    _getAutoChildParentName : function (childName) {
        var parentMap = this.autoChildParentMap;
        if (parentMap) return parentMap[childName];
    },

    getAutoChildParent : function (childName) {
        var parentName = this._getAutoChildParentName(childName);
        if (parentName) return this[parentName];
        return this;
    },

    // set a named child: normally, just evaluates or re-evaluates the show flag in order to create
    // or destroy the component.  Can also be used to replace a named child with a specified
    // component.
    setAutoChild : function (childName, dynamicProperties) {

        if (!this.shouldCreateChild(childName)) {
            if (this[childName]) this[childName].destroy();
            // clear our pointer to the destroyed child
            delete this[childName];
        } else {
            // If we're passed a widget, apply it directly (unless shouldCreateChild() returns
            // false in which case we ignore the widget)
            if (isc.isA.Canvas(dynamicProperties)) {
                var child = dynamicProperties;
                // set the child to a custom-provided widget
                if (this[childName]) this[childName].destroy();
                this[childName] = child;
                this._addToParent(childName, child);
                return;
            }

            return this.addAutoChild(childName, dynamicProperties);
        }
    },


    hasStableID : function () {
        return !this._autoAssignedID;
    },
    hasStableLocalID : function () {
        return this._localId != null || !this._autoAssignedID;
    },



    //>    @method    class.map()
    //
    // Call <code>method</code> on each item in <code>argsList</code> and return the Array of results.
    //
    //    @param    methodName (String)
    //      Name of the method on this instance which should be called on each element of the Array
    //    @param    items      (Array)
    //      Array of items to call the method on
    //
    //    @return            (Array) Array of results, one per element in the passed "items" Array
    // @visibility external
    //<
    map : isc.Class.map,

    //>    @method    class.Super()
    //
    // Call the SuperClass implementation of an instance method.  For example:
    // <pre>
    //    isc.defineClass("MyButton", "Button").addProperties({
    //        // this override causes no change in behavior because it just
    //        // calls Super and returns whatever the superclass would return
    //        getTitle : function () {
    //            return this.Super("getTitle", arguments);
    //        },
    //
    //        // this override would add "foo" to the titles of all buttons
    //        getTitle : function () {
    //            // add code here to take actions before the superclass method is invoked
    //
    //            var superResult = return this.Super("getTitle", arguments);
    //
    //            // add code here to take action after the superclass method is invoked
    //
    //            return superResult + "foo";
    //        }
    //
    //    })
    // </pre>
    // Note that Super() is always called with the name of the current method.  You cannot call
    // the Super class implementation of another method directly.
    // <P>
    // It is <b>required</b> to always pass the native 'arguments' object to Super().  Arguments
    // is a JavaScript builtin that is available within any JavaScript function - see any
    // JavaScript Reference for details.
    // <P>
    // If you override a method in an instance, and then call Super(), the prototype
    // implementation will be called.  This is similar to how anonymous classes in Java handle
    // super().  For example:
    // <pre>
    //    isc.Button.create({
    //        // this will set the title to indicate the runtime button class
    //        initWidget : function () {
    //            this.Super("initWidget", arguments);
    //            this.title = "Parent Class: " + this.getSuperClass().getClassName();
    //        },
    //        width: 1,
    //        overflow: "visible"
    //    });
    // </pre>
    // See also +link{ClassFactory.defineClass,defineClass()} and
    // +link{classMethod:class.addProperties,addProperties} for the basics of creating classes
    // and overriding methods.
    //
    //    @param methodName   (String)    name of the superclass method to call
    //    @param args         (Arguments | Array) native "arguments" object, or array of
    //                                          arguments to pass to the Super call
    //    @param [nativeArgs] (Arguments) native "arguments" object, required if an Array is
    //                                  passed for the "args" parameter in lieu of the native
    //                                  arguments object
    //
    //    @return                    (Any)        return value of the superclass call
    //
    // @visibility external
    //<
    //    @param     [nativeArguments] (Arguments) native "arguments" object.  Required only if
    //                                        calling Super() with a substitute set of
    //                                        arguments
    Super : isc.Class.Super,
    _delayedSuper : isc.Class._delayedSuper,
    invokeSuper : isc.Class.invokeSuper,

    _assert : isc.Class._assert,

    // ruleScope
    //---------------------------------------------------------------------------------------

    //> @attr class.ruleScope (String : null : IR)
    // +link{canvas.ID} of the component that manages "rule context" for which
    // this class participates. A non-Canvas class can only use the ruleScope
    // for supporting +link{dynamicProperties}. Unlike +link{canvas.ruleScope}
    // <code>ruleScope</code> on a standalone class must be explicitly specified.
    //
    // @see canvas.ruleScope
    // @visibility external
    //<



    getRuleScopeComponent : function () {
        if (!this.ruleScope) return null;

        var ruleScope = this.getRuleScope();
        if (!ruleScope) return null;

        var component = window[ruleScope];
        return (!component || component.destroyed ? null : component);
    },

    getRuleScope : function () {
        if (isc.disableRuleScope) {
            // Only show message once
            if (!isc.Canvas._loggedDisabledRuleScope) {
                isc.logWarn("RuleScope has been explicitly disabled (isc.disableRuleScope=true). No ruleContext operations will be processed.")
                isc.Canvas._loggedDisabledRuleScope = true;
            }
            return null;
        }
        if (!this.ruleScope) {
            // A FormItem should take on the ruleScope of its form.
            // This is useful for pushing to Workflow Process from
            // button click for example.
            if (this.form && isc.isA.FormItem(this)) {
                return this.form.getRuleScope();
            }
            return null;
        }

        // If Canvas was provided as ruleScope, always return ID
        return (isc.isA.Canvas(this.ruleScope) ? this.ruleScope.getID() : this.ruleScope);
    },

    // dynamicProperties
    //---------------------------------------------------------------------------------------

    //> @attr class.dynamicProperties (Map : null : IR)
    // Object mapping dynamic property names to the source - a <code>DataPath</code>,
    // <code>UserSummary</code> or <code>UserFormula</code>. This is a declarative
    // alternative to calling +link{addDynamicProperty} for each property.
    // <p>
    // See +link{addDynamicProperty} for details on using dynamic properties.
    // <smartclient>
    // <p>
    // In JavaScript dynamicProperties can be declaratively initialized as follows:
    // <pre>
    // dynamicProperties: {
    //     propName1 : "a/b/c",
    //     propName2 : { formula: .. formula definition .. }
    //     propName3 : { textFormula: .. summary definition .. }
    // }
    // </pre>
    // </smartclient>
    // <p>
    // In ComponentXML dynamicProperties can be intialized as:
    // <pre>
    // &lt;dynamicProperties&gt;
    //     &lt;property name="propName" dataPath="a/b/c"/&gt;
    //     &lt;property name="propName2"&gt;
    //         &lt;formula&gt;
    //             &lt;UserFormula ... &gt;
    //         &lt;/formula&gt;
    //     &lt;/property&gt;
    //     &lt;property name="propName3"&gt;
    //         &lt;textFormula&gt;
    //             &lt;UserSummary ... &gt;
    //         &lt;/textFormula&gt;
    //     &lt;/property&gt;
    // &lt;/dynamicProperties&gt;
    // </pre>
    // @see addDynamicProperty
    // @visibility external
    //<

    _initDynamicProperties : function () {
        if (!this.dynamicProperties) return;

        if (isc.disableRuleScope) {
            this.logWarn("Dynamic properties defined while RuleScope has been explicitly disabled (isc.disableRuleScope=true). Dynamic properties will be ignored.");
            return;
        }

        if (!this._dynamicProperties) this._dynamicProperties = {};

        // Support an array of objects for initialization as well
        if (isc.isAn.Array(this.dynamicProperties)) {
            var dynamicProperties = this.dynamicProperties,
                properties = {}
            ;
            for (var i = 0; i < dynamicProperties.length; i++) {
                var property = dynamicProperties[i];
                if (property && property.name) {
                    properties[property.name] = this._normalizeDynamicProperty(property);
                }
            }
            this.dynamicProperties = properties;
        }

        isc.addProperties(this._dynamicProperties, this.dynamicProperties);
        this._pendingDynamicProperties = true;

        if (this.logIsDebugEnabled("dynamicProperties")) {
            for (var key in this.dynamicProperties) {
                var source = this.dynamicProperties[key];
                this.logDebug("Init dynamicProperty " + key + "=" + this.echoFull(source), "dynamicProperties");
            }
        }
    },



    _normalizeDynamicProperty : function (source) {
        if (isc.isA.String(source)) {
            source = { dataPath: source };

        } else if (!source.dataPath && !source.formula &&
                   !source.textFormula && !source.trueWhen)
        {
            var name = source.name;
            delete source.name;


            if (isc.DataSource && isc.DS.isAdvancedCriteria(source)) {
                source = { trueWhen: source };

            // The most common target for a dynamicProperty is a string
            // field and therefore the default if no formulaVars is
            // detected is to use textFormula
            } else if (source.formulaVars) {
                source = { formula: source };
            } else {
                source = { textFormula: source };
            }
            if (name) source.name = name;


        } else if (source.trueWhen) {
            var criteria = source.trueWhen;
            if (isc.DataSource && !isc.DS.isAdvancedCriteria(criteria) &&
                criteria.operator && criteria.criteria)
            {
                source.trueWhen = criteria = isc.clone(criteria);
                criteria._constructor = "AdvancedCriteria";
            }
        }

        return source;
    },

    //> @method class.addDynamicProperty()
    // Sets up the value of <code>propertyName</code> to be dynamically derived from the
    // +link{canvas.ruleScope,ruleScope}, by either a simple +link{DataPath} into the ruleScope or via a textual
    // or numeric formula using the ruleScope as available formula inputs.
    // <p>
    // The dataPath or formula is evaluated immediately when addDynamicProperty() is called, then re-evaluated
    // every time the ruleScope changes.
    // <p>
    // It is invalid usage to use <code>addDynamicProperty()</code> on a property that is not runtime settable,
    // however, <code>addDynamicProperty()</code> will not throw an error or log a warning if this is done.
    // <p>
    // If a property is already dynamic and addDynamicProperty() is called again, the new dynamic behavior
    // replaces the old.  If a property should no longer be dynamic, call +link{clearDynamicProperty()}.
    // <p>
    // Dynamic properties can also be declared together via +link{dynamicProperties}.
    //
    // @see dynamicProperties
    // @param propertyName (Identifier) name of a settable property on this instance
    // @param source (DataPath | UserSummary | UserFormula)
    // @visibility external
    //<

    addDynamicProperty : function (propertyName, source, fromInit) {
        if (!propertyName || !source) {
            if (!isc.isAn.Object(propertyName)) {
                this.logWarn("Attempt to add Dynamic Property with invalid propertyName or source: " +
                             [propertyName, source]);
                return;
            }
            source = this._normalizeDynamicProperty(propertyName);
            propertyName = propertyName.name;

            if (!propertyName || !source) {
                this.logWarn("Attempt to add Dynamic Property with invalid propertyName or source: " +
                             [propertyName, source]);
                return;
            }
        }
        if (!isc.isA.Object(source) && !isc.isA.String(source)) {
            this.logWarn("Attempt to add Dynamic Property with invalid source: " + source);
            return;
        }

        if (isc.isAn.Object(source)) {
            source = this._normalizeDynamicProperty(source);
        }
        if (isc.disableRuleScope) {
            this.logInfo("Attempt to add Dynamic Property while RuleScope has been explicitly disabled (isc.disableRuleScope=true). Dynamic property will be ignored.");
            return;
        }

        this.logDebug("Add dynamicProperty " + propertyName + "=" + this.echoFull(source),
                      "dynamicProperties");

        // Remove existing dynamic propery configuration and rule
        this.clearDynamicProperty(propertyName);

        // Save Dynamic Property configuration
        if (!this._dynamicProperties) this._dynamicProperties = {};
        this._dynamicProperties[propertyName] = source;

        // Create the rule for this property

        if (!fromInit) {
            this._createDynamicPropertyRules(propertyName);
        } else {
            this._pendingDynamicProperties = true;
        }
    },

    //> @method class.clearDynamicProperty()
    // Clears a dynamic property previously established via +link{addDynamicProperty()}.
    // <p>
    // If the property is not currently dynamic, nothing will be done (and no warning logged).
    // <p>
    // The current value of the property will not be changed by this call.
    //
    // @param propertyName (Identifier) property name of the dynamic property to clear
    // @visibility external
    //<
    clearDynamicProperty : function (propertyName) {
        if (!this._dynamicProperties || !propertyName) return;

        if (this._dynamicProperties[propertyName]) {
            this.logDebug("Clear dynamicProperty " + propertyName + "=" +
                this.echoFull(this._dynamicProperties[propertyName]), "dynamicProperties");
            delete this._dynamicProperties[propertyName];

            // Remove previous rule
            var ruleName = this._createDynamicPropertyRuleName(propertyName),
                component = this.getRuleScopeComponent()
            ;
            if (component) {
                var rulesEngine = component.getRulesEngine();
                if (rulesEngine) rulesEngine.removeRule(ruleName);
            }
        }
    },


    removeDynamicProperty : function (property) {
        var propertyName;
        if (isc.isA.String(property)) {
            propertyName = property;
        } else if (isc.isA.Object(property)) {
            propertyName = property.name;
        }
        this.clearDynamicProperty(propertyName);
    },

    //> @method class.hasDynamicProperty()
    // Returns true if the property is dynamic.
    //
    // @param propertyName (Identifier) name of a settable property on this instance
    // @return (boolean) true if the property is dynamic
    // @visibility external
    //<
    hasDynamicProperty : function (propertyName) {
        return (this._dynamicProperties && this._dynamicProperties[propertyName] != null);
    },


    getDynamicProperty : function (propertyName) {
        var source = (this._dynamicProperties ? this._dynamicProperties[propertyName] : null);
        return source;
    },

    //> @method class.getDynamicPropertyRuleTime()
    // Returns the last time the rule for the specified dynamic property fired, as a
    // +link{Date}.
    //
    // @param propertyName (Identifier) name of a settable property on this instance
    // @return (Date) last fire time of rule
    // @visibility external
    //<
    getDynamicPropertyRuleTime : function (propertyName) {
        var dynamicProperties = this._dynamicProperties;
        if (!dynamicProperties || dynamicProperties.length == 0) return;

        var component = this.getRuleScopeComponent();
        if (component) {
            var rulesEngine = component.rulesEngine;
            if (rulesEngine) {
                var ruleName = this._createDynamicPropertyRuleName(propertyName),
                    rule = rulesEngine.getRule(ruleName);
                if (rule) return rule._fireTime;
            }
        }
    },

    _createDynamicPropertyRules : function (propertyName) {
        var dynamicProperties = this._dynamicProperties;
        if (!dynamicProperties || dynamicProperties.length == 0) {
            return;
        }

        // Validate that a non-canvas class has a global ID
        // and has a manually-assigned ruleScope
        var wd = this.getWindow();
        if (!this.ID || !wd || !wd[this.ID]) {
            this.logInfo("Dynamic properties defined on non-canvas class but has no global ID - ignoring");
            return;
        }
        if (!this.ruleScope && (!isc.Canvas || !isc.isA.Canvas(this))) {
            this.logInfo("Dynamic properties defined on non-canvas class but has no specified ruleScope - ignoring");
            return;
        }
        if (isc.disableRuleScope) {
            this.logWarn("Dynamic properties defined while RuleScope has been explicitly disabled (isc.disableRuleScope=true). Dynamic properties will be ignored.");
            return;
        }

        this.logDebug("Create dynamicProperty rules: " + this.echoAll(this), "dynamicProperties");


        var component = this.getRuleScopeComponent();
        if (!component) {
            this._pendingDynamicProperties = true;
            return;
        }

        var rulesEngine = component.getRulesEngine();
        if (!rulesEngine) {
            this._pendingDynamicProperties = true;
            if (!component.isDrawn() && !this.isObserving(component, "draw")) {
                this.observe(component, "draw", "observer._createDynamicPropertyRules()");
            }
            return;
        }
        rulesEngine.addMember(this);

        if (this.isObserving(component, "draw")) {
            this.ignore(component, "draw");
        }

        var pendingProperties = this._pendingDynamicProperties;
        delete this._pendingDynamicProperties;

        var ruleScope = this.getRuleScope(),
            rules = []
        ;

        if (pendingProperties) {
            // Create rules for all dynamicProperties
            for (var key in dynamicProperties) {
                var source = dynamicProperties[key],
                    rule = this._createDynamicPropertyRule(key, source, ruleScope)
                ;
                if (rule) {
                    rulesEngine.addRule(rule);
                    rules.add(rule);
                }
            }
        } else if (propertyName != null) {
            // Create rule for a single dynamicProperty
            var source = this._dynamicProperties[propertyName],
                rule = this._createDynamicPropertyRule(propertyName, source, ruleScope)
            ;
            if (rule) {
                rulesEngine.addRule(rule);
                rules.add(rule);
            }
        }

        // Trigger rule(s) immediately
        rulesEngine.processRules(rules, this);
    },

    _createDynamicPropertyRuleName : function (propertyName) {
        return this.ID + "_" + propertyName + "_dynProp";
    },

    _createDynamicPropertyRule : function (propertyName, source, ruleScope) {
        var ruleName = this._createDynamicPropertyRuleName(propertyName),
            origSource = source,
            formulaProperties
        ;


        if (isc.isA.String(source) || isc.isAn.Object(source)) {
            source = this._normalizeDynamicProperty(source);
        }

        if (isc.isAn.Object(source)) {
            if (source.dataPath) {

                formulaProperties = { type: "populateFromDataPath", formula: source.dataPath };

            } else if (source.formula) {
                // Populate and PopulateText rules expect the ruleScope
                // variables to be inlined instead of using a var mapping.
                // If a mapping is provided, update the formula by expanding
                // the mapping vars.
                var formula = source.formula,
                    text = formula.text
                ;
                if (formula.formulaVars) {
                    var vars = formula.formulaVars;
                    for (var mappingKey in vars) {
                        var replace = "#{" + vars[mappingKey] + "}";
                        text = isc.FormulaBuilder.handleKeyExp(text, mappingKey, "escaped", replace);
                        text = isc.FormulaBuilder.handleKeyExp(text, mappingKey, "braced", replace);
                        text = isc.FormulaBuilder.handleKeyExp(text, mappingKey, "simple", replace);
                    }
                }
                formulaProperties = { type: "populate", formula: text };

            } else if (source.textFormula) {
                var formula = source.textFormula,
                    text = formula.text
                ;
                if (formula.summaryVars) {
                    var vars = formula.summaryVars;
                    for (var mappingKey in vars) {
                        var replace = "#{" + vars[mappingKey] + "}";
                        text = isc.FormulaBuilder.handleKeyExp(text, mappingKey, "escaped", replace);
                        text = isc.FormulaBuilder.handleKeyExp(text, mappingKey, "braced", replace);
                    }
                }
                formulaProperties = { type: "populateText", formula: text };

            } else if (source.trueWhen) {

                formulaProperties = { type: "populateFromCriteria", formula: source.trueWhen };

            } else {
                this.logWarn("Invalid dynamic property definition for " + propertyName +
                             ": " + this.echo(origSource));
                return;
            }
        }

        var rule = isc.addProperties({
            name: ruleName,
            triggerEvent: "contextChanged",
            propertyName: this.ID + "." + propertyName,
            targetRuleScope: ruleScope,
            overwriteInvalidValue: true,
            autoPopulateClearedFlag: this.autoPopulateClearedFlag,
            allowEscapedKeys: true,
            trackFireTime: true,
            logCategory: "dynamicProperties"
        }, formulaProperties);

        this.logDebug("Create dynamicProperty " + propertyName + " rule: " +
                      this.echoFull(rule), "dynamicProperties");

        return rule;
    },

    _removeDynamicPropertyRules : function () {
        var dynamicProperties = this._dynamicProperties;
        if (!dynamicProperties || dynamicProperties.length == 0) return;

        var component = this.getRuleScopeComponent();
        if (component) {
            var rulesEngine = component.rulesEngine;
            if (rulesEngine) {
                for (var key in dynamicProperties) {
                    var ruleName = this._createDynamicPropertyRuleName(key);
                    this.logDebug("Remove dynamicProperty " + key + " rule [" + ruleName + "]", "dynamicProperties");
                    rulesEngine.removeRule(ruleName);
                }
            }
        }
    }
});

// NOTE: toString functions CANNOT be added by addMethods, because a property named "toString"
// will not be enumerated by for..in.  This is actually part of the ECMAScript standard!



//>    @classMethod    Class.toString()
//
//  The default toString() for a ClassObject reports that you have a ClassObject and what class
//  it is.
// @visibility external
//<
isc.Class.toString = function () {
    return "[Class " + this.Class + "]";
}

//>    @method    class.toString()
//
//  The default toString() for instances reports that you have an instance of a class and prints
//  the instance ID if present.
// @visibility external
//<
isc.Class.getPrototype().toString = function () {
    return "[" + this.Class + " ID:" + this.ID + "]";
}

//
//  Add Class properties (useful static properties to be referenced by other code)
//
isc.Class.addClassProperties({


    // make the isc namespace available on all Class objects
    ns : isc,

    //>    @classAttr  Class.NO_OP    (Function : {} : IA)
    //      An empty (no-op) function.  Used as a default setting for event
    //      handlers to allow observation to occur.
    //      Added as a class constant rather than class method, since this will not be directly
    //      called on the Class object (as in "Class.NO_OP()"), so does not need the logic
    //      usually required for methods.
    //
    // @group    events
    //
    //<
    NO_OP : function() {},

    RET_TRUE : function () {
        return true;
    },

    //>    @classAttr  Class._stringMethodRegistry (Object : {} : IA)
    //      This object is a map of method names to strings of arguments.
    //      It serves a dual purpose
    //      1 - Any properties listed in here are instance methods of this class which can legally
    //          be assigned string values to eval.
    //      2 - Allows you to get at the set of parameter names used in the string value (for
    //          converting the string to a function).
    //
    //<
    _stringMethodRegistry: {}

});     // END isc.Class addClassProperties()

//> @type Constant
// A string used to define the value of a class attribute when it's referenced as one of the
// potential values of an enum type.  For example, one documented value of +link{Overflow} is
// +link{Canvas.HIDDEN}, which is itself a class attribute with type <code>Constant</code> and
// the value "hidden".
// @visibility external
// @baseType String
// @constant
//<

//
// add the observation methods to the ClassFactory as well so we can use 'em there
//
isc.addMethods(isc.ClassFactory, {
    observe : isc.Class.getPrototype().observe,
    ignore : isc.Class.getPrototype().ignore
});


//> @staticMethod isc.eval()
// Evaluate a string of script and return the result. Falls through to
// +link{classMethod:Class.evaluate(),Class.evaluate()}
//
// @param expression (String) Expression to evaluate
// @return (Any) Result of evaluating the expression passed in
// @visibility external
//<
// Additional 'hiddenIFrameEval' param indicating that we're evaluating a JSON block
// rather than executing arbitrary script.
// Note: this differs from a straight call to the native eval function in that you lose scope.
// You can workaround this by using the instance method 'evaluate()', and passing in a mapping
// of variable names to values to be available when the string executes.

isc.eval = function (expression, hiddenIFrameEval) {
    return isc.Class.evaluate(expression, null, false, hiddenIFrameEval);
}


isc.dynamicProperty = function (source) {
    if (isc.isA.String(source)) {
        source = { dataPath: source };
    } else if (!source.dataPath && !source.formula && !source.textFormula) {
        // The most common target for a dynamicProperty is a string
        // field and therefore the default if no formulaVars is
        // detected is to use textFormula
        if (source.formulaVars) {
            source = { formula: { formulaVars: source.formulaVars, text: source.text } };
        } else {
            var summaryVars = source.summaryVars;
            source = { textFormula: { text: source.text } };
            if (summaryVars) {
                source.textFormula.summaryVars = summaryVars;
            }
        }
    }

    return isc.DynamicProperty.create(source);
};


isc.disableCSSStyleSheets = function (hrefContains, disable) {
    if (!isc.isAn.Array(hrefContains)) hrefContains = [hrefContains];
    if (disable == null) disable = true;

    var sheets = document.styleSheets;
    for (var i=sheets.length-1; i>0; i--) {
        var valid = true;
        // a sheet is "valid" if it's href contains all of the passed hrefContains strings

        for (var j=0; j<hrefContains.length; j++) {
            if (!sheets[i].href) continue;
            if (!sheets[i].href.contains(hrefContains[j])) valid = false;
            if (!valid) break;
        }
        if (valid) {
            // disable/enable the sheet
            sheets[i].disabled = disable;
        }
    }
}


isc.ClassFactory.defineClass("DynamicProperty").addProperties({
    _isDynamicProperty: true,


    setEditableProperties : function (properties) {
        if (this.editNode && this.editContext) {
            var ctx = this.editContext,
                editTree = ctx.getEditNodeTree(),
                parentNode = editTree.getParent(this.editNode)
            ;
            if (parentNode) {
                parentNode.liveObject.clearDynamicProperty(properties.name);
                parentNode.liveObject.addDynamicProperty(properties);
            }
        }
        return this.Super("setEditableProperties", arguments);
    },


    _xmlSerialize : function (name, type, namespace, prefix) {
        return isc.Comm._xmlValue(name, this.serializeMe(), namespace, prefix);
    },

    _$schema: "DynamicProperty",
    _$tagName: "dynamicProperty",

    serializeMe : function () {
        var type = this._$schema,
            schema = isc.DS.get(type),
            tagName = this._$tagName,
            output = isc.SB.create()
        ;

        // leave the tag open..
        output.append(
            isc.Comm._xmlOpenTag(tagName, type, null, null, true)
        );

        this._serializeAttributes(output, schema);

        var subElements = this._serializeFields(schema);

        // use a short tag if possible
        if (subElements == null || isc.isAn.emptyString(subElements)) {
            output.append("/>");
            return output.release(false);
        }

        output.append(">", subElements);
        output.append(isc.Comm._xmlCloseTag(tagName));

        return output.release(false);
    },

    _attributeNames: ["name", "dataPath"],
    _serializeAttributes : function (output, schema) {
        var attributes = this._attributeNames;
        for (var i = 0; i < attributes.length; i++) {
            var fieldName = attributes[i],
                field = schema.getField(fieldName),
                value = this[fieldName]
            ;

            if (value != null) {
                output.append(" ", fieldName, "=\"",
                        schema._serializeSimpleTypeValue(field, value),
                "\"");
            }
        }
    },

    _fieldNames: ["formula", "textFormula", "text", "formulaVars", "summaryVars", "trueWhen"],
    _serializeFields : function (schema) {
        var fields = this._fieldNames,
            data = {}
        ;
        for (var i = 0; i < fields.length; i++) {
            var fieldName = fields[i],
                value = this[fieldName]
            ;

            if (value != null) {
                data[fieldName] = value;
            }
        }

        if (!isc.isAn.emptyObject(data)) {
            if (data.text && data.formulaVars) {
                data = { formula: data };
            } else if (data.text) {
                data = { textFormula: data };
            }
            return schema.xmlSerializeFields(data);
        }

        return null;
    }
});








  //>DEBUG
// This lets us label methods with a name within addMethods
Function.prototype.Class = "Function";
  //<DEBUG




// Utility methods for exploring and manipulating functions and methods
isc.ClassFactory.defineClass("Func");

isc.Func.addClassMethods({

    // create the static regular expression we use to parse out the name of a function
    _nameExpression : new RegExp("function\\s+([\\w$]+)\\s*\\("),
    parseFunctionName : function (func) {
        // derive the name from the function definition using a regular expression

        var match = isc.Func._nameExpression.exec(func.toString());
        if (match) return match[1];
        // if the regex didn't match, it's an anonymous function
        // NOTE that new Function().toString() is "function anonymous() { }" on both Moz and IE
        else return "anonymous";
    },

    // gets the name of a function as a string.  Uses
    getName : function (func, dontReport) {
        if (func == Function.prototype.apply) return "Function.apply";
        if (func == Function.prototype.call) return "Function.call";
        if (!func) {
            var undef;
            if (!arguments.callee || arguments.callee.caller === undef) return "unknown";
            if (!arguments.callee.caller) return "none";
            func = arguments.callee.caller;
        }
        // if we've previously determined our name or been explicitly labelled with a name, return
        // that
        if (func._fullName == null) {

            if (func._className == null && isc._allFuncs) {
                var index = isc._allFuncs.indexOf(func);
                if (index != -1) {
                    for (var className = isc._funcClasses[index]; className == null; index--) {
                        className = isc._funcClasses[index];
                    }
                    func._className = className;
                } else {
                    // fallback approach uses the fact that we give a global name to all
                    // functions to figure out what they are - works for functions that somehow
                    // miss out on the _allFuncs index.
                    var functionName = this.parseFunctionName(func);
                    //isc.logWarn("function: " + functionName + " not in index");
                    var isClassMethod;
                    if (functionName.startsWith("isc_c_")) {
                        functionName = functionName.substring(6);
                        isClassMethod = true;
                    } else {
                        functionName = functionName.substring(4);
                    }
                    className = functionName.substring(0, functionName.indexOf("_"));
                    methodName = functionName.substring(className.length+1);
                    var clazz = isc.ClassFactory.getClass(className),
                        method = null;
                    if (clazz) {
                        method = isClassMethod ?
                            clazz[methodName] : clazz.getInstanceProperty(methodName);
                    }
                    //if (method != null) {
                    //    isc.logWarn("lookup up method: " + this.echoLeaf(method) +
                    //                " equals func: " + (method == func));
                    //}
                }
            }

            // if we have a className but no function name, search the class (and instance
            // prototype) for the function
            var name = func._name,
                isClassMethod;
            if (name == null && func._className != null) {
                var theProto;
                var classObj = isc.ClassFactory.getClass(func._className);
                if (classObj == null) {
                    // support lookups for non-Class singletons like isc.ClassFactory and
                    // isc.FileLoader, and native globals like Array and Function
                    //Log.logWarn("className is: " + func._className);
                    classObj = isc[func._className] || window[func._className];
                } else {
                    theProto = classObj.getPrototype();
                }
                // check instance methods first (more common)
                if (theProto != null) {
                    for (var methodName in theProto) {
                        if (theProto[methodName] === func) {
                            name = methodName;
                            break;
                        }
                    }
                }
                // then class methods
                if (name == null && classObj != null) {
                    for (var methodName in classObj) {
                        if (classObj[methodName] === func) {
                            name = methodName;
                            isClassMethod = true;
                            break;
                        }
                    }
                    // if this is a native object, check the prototype methods as well
                    if (name == null && !isc.isA.Class(classObj) && classObj.prototype != null) {
                        for (var methodName in classObj.prototype) {
                            if (classObj.prototype[methodName] === func) {
                                name = methodName;
                                break;
                            }
                        }
                    }
                }
            }

            if (name != null) {
                func._fullName = (func._instanceSpecific ?
                                  (func._isOverride ? "[o]" : "[a]") : isc._emptyString) +
                                 (isClassMethod ? "[c]" : isc._emptyString) +
                                 (func._className ? func._className + isc.dot : isc._emptyString) +
                                  name;
            } else {
                if (func._isCallback) func._fullName = "callback";
                else {
                    func._fullName = isc.Func.parseFunctionName(func);
                }
            }
            //this.logWarn("function acquired _fullName: " + func._fullName);
        }

        return func._fullName;
    },

    //>    @method    Func.getArgs()    (A)
    //
    //     Gets the arguments to the function as an array of strings
    //
    //  @param  func (Function) Function to examine
    //    @return    (Array)    argument names for the function (array of strings)
    //                    returns an empty array if the function has no arguments.
    //<
    getArgs : function (func) {
        var args = isc.Func.getArgString(func);
        if (args == "") return [];
        return args.split(",");
    },

    //>    @method    Func.getArgString()    (A)
    //
    //     Gets the arguments to the function as a string of comma separated values
    //
    //  @param  func (Function) Function to examine
    //    @return    (String)    argument names for the function separated by commas
    //                    returns an empty string if the function has no arguments.
    //<
    getArgString : function (func) {
        if (func._argString != null) return func._argString;
        var string = func.toString(),
            lparenPosPlus1 = string.indexOf("(") + 1,
            args = string.substring(lparenPosPlus1, string.indexOf(")", lparenPosPlus1));
        args = args.replace(/\/\*.*?\*\/|\/\/.*$/gm, isc.space);
        args = args.replace(/\s+/g, isc.emptyString);
        func._argString = args;
        return args;
    },

    //>    @method    Func.getBody()    (A)
    //
    //     Gets the body of the function as a string.<br><br>
    //
    //    NOTE: This is the body of the function after it has been parsed -- all comments will
    //            have been removed, formatting may be changed from the original text, etc.
    //
    //  @param func (Function) function to examine
    //    @return    (String)    body of the function as a string, without leading "{" and trailing "}"
    //<
    getBody : function (func) {
        var string = func.toString();

        return string.substring(string.indexOf("{") + 1, string.lastIndexOf("}"));
    },


    //>    @method    Func.getShortBody()    (A)
    //
    //     Gets the body of the function as a string, removing all returns so it's more
    //     compact.<br><br>
    //
    //    NOTE: This is the body of the function after it has been parsed -- all comments will
    //    have been removed, formatting may be changed from the original text, etc.
    //
    //  @param func (Function) function to examine
    //    @return    (String)    body of the function as a string, without leading "{" and trailing "}"
    //<
    getShortBody : function (func) {
        var string = func.toString();

        return string.substring(string.indexOf("{") + 1, string.lastIndexOf("}")).replace(/[\r\n\t]*/g, "");
    }
});


// -----------------------------------------------------------------------------------------------
// function.apply()
// This is a native method in most browsers.
// If it's not already defined, supply the "apply" function.
// If it is already defined, patch it so it will not JS error if explicitly passed
// <code>null</code> as the arguments (2nd) parameter.






//>    @method    function.apply()    (A)
//
// Applies this function to <code>targetObject</code>, as if the function was originally
// defined as a method of the object.
//
//    @param    targetObject    (Object)            target to apply the function to.  Within the context
//                                                of the function as it evaluates, <code>this</code> == <code>targetObject</code>
//    @param    args            (Array of Object)    list of arguments to pass to the function
//
//    @return                    (Varies)            returns the normal return value of the function
//<
if (!Function.prototype.apply) {

    // temporary function number for generating a new function name
    isc.addMethods(Function.prototype, {
        apply :    function (targetObject, args) {

//!DONTOBFUSCATE
            if (targetObject == null) targetObject = window;
            // generate a temporary function name
            var tempFunctionName = "__TEMPF_" + Function.prototype._tempFuncNum++;
            var returnValue;

            // assign the function being apply'd (this) to the targetObject
            targetObject[tempFunctionName]=this;


            // if no argments passed, set args to an empty array
            if (!args) args = [];

            if (args.length <= 10) {
                // Note any undefined properties of the args array will simply be
                // undefined arguments of the function being invoked via apply, as
                // they should be.  The arguments.length of the function will be off, but so be it
                returnValue = targetObject[tempFunctionName](args[0],args[1],args[2],args[3],args[4],
                                                             args[5],args[6],args[7],args[8],args[9]);
            } else {
                // The function is being called with more than ten arguments.

                // Construct a string with the code necessary to call the function with
                // however many arguments were passed, then eval() it.
                var    functionString = 'targetObject[tempFunctionName](';
                for (var i = 0; i < args.length; i++) {
                    functionString += "args" + '[' + i + ']';
                    if (i + 1 < args.length) {
                        functionString += ',';
                    }
                }
                functionString += ');';
                isc.eval('returnValue =' + functionString);
            }
            // remove the temporary function from the targetObject
            delete targetObject[tempFunctionName];
            // and return the value returned by the function call
            return returnValue;
        }
    });
    // counter which is used to generate unique names for functions to be applied
    Function.prototype._tempFuncNum = 0;
}




// Add some static helper methods to the Func class


isc._$slash = "/";
isc._$star = "*";
isc.Func.addClassMethods({

    // Helper properties
    _commentDelimeters : [["//", "\n"], ["//", "\\n"],
        [isc._$slash + isc._$star, isc._$star + isc._$slash]],
    _stringDelimeters : ["\"", "\'"],
    _complexIdentifiers : ["switch", "while", "if", "return", "for", "var", "let", "const"],
    _multiLineDelimeters : ["(", ")", "[", "]", "{", "}", ":", "?", "!",
                            "+", "-", "/", "*", "=", ">", "<","|", "&", ",", "\\"],

    //>     @method Func.expressionToFunction() (A)
    //
    //      Given an expression or conditional as a string, convert it into
    //              a Function object.   Used to create functions that need to return
    //              values where the user specifies a string.  These were formerly done
    //              via evals.
    //
    //      @params variables       (String)                Names of variables to pass into the new function
    //      @params expression      (String)                String expression to evaluate return
    //
    //      @return (Function)      function that returns the conditional value
    //<
    expressionToFunction : function (variables, expression, comment) {





        var returnValue = this._expressionToFunction(variables, expression, comment);



        return returnValue;
    },
    _actionToExpressionTemplate: [
        // Map target to global ID if needed
        "var ID=\"",                        // 0
        ,                                   // 1 (ID of target)
        "\",canvas=isc.isA.FormItem(this)?this.containerWidget:this;", // 2
        "if(canvas&&canvas.getByLocalId){var obj=canvas.getByLocalId(ID);if(obj&&obj.ID)ID=obj.ID;}", // 3
        // Warn if we can't find the target
        "if (!window[ID]){",                // 4
        "var message='Component ID \"",     // 5
        ,                                   // 6 (ID of target)
        "\", target of action \"",          // 7
        ,                                   // 8 (action title)
        "\" does not exist';isc.Log.logWarn(message);if(isc.designTime)isc.say(message);return}", // 9
        // Call the method on the target
        "window[ID].",                      // 10
        ,                                   // 11 method name
        "(",                                // 12
        ,                                   // 13 arguments [as a ',' separated string]
        ")"                                 // then close with ")"
    ],
    _staticActionToExpressionTemplate: [
        // Warn if we can't find the target
        "if (!",                            // 0
        ,                                   // 1 (target)
        "){",                               // 2
        "var message='Class \"",            // 3
        ,                                   // 4 (target)
        "\", target of action \"",          // 5
        ,                                   // 6 (action title)
        "\" does not exist';isc.Log.logWarn(message);if(isc.designTime)isc.say(message);return}", // 7
        // Call the method on the target
        ,                                   // 8 (target)
        ".",                                // 9
        ,                                   // 10 method name
        "(",                                // 11
        ,                                   // 12 arguments [as a ',' separated string]
        ")"                                 // then close with ")"
    ],
    _resolveAction : function (action) {
        if (isc.isA.StringMethod(action)) action = action.getValue();

        else if (action.Action && !action.target) action = action.Action;
        return action;
    },
    _actionToExpressionString : function (action) {
        if (action.type == "static") {
            var template = this._staticActionToExpressionTemplate,
                target = action.target
            ;
            if (!target.startsWith(isc._$iscPrefix)) target = isc._$iscPrefix + target;

            // Plug the ID of the target, and the method to call into the function string.
            template[1] = template[4] = template[8] = target;
            template[10] = action.name;
            if (action.title) template[6] = action.title;
            else template[6] = "[No title specified]";

            // mapping is an array of expressions to pass in as parameters
            var mapping = action.mapping;
            if (mapping == null) mapping = [];
            if (isc.isAn.Array(mapping)) template[12] = mapping.join(); // automatically puts commas between args
            else template[12] = mapping; // assume a single string
        } else {
            var template = this._actionToExpressionTemplate;

            // Plug the ID of the target, and the method to call into the function string.
            template[1] = template[6] = action.target;
            template[11] = action.name;
            if (action.title) template[8] = action.title;
            else template[8] = "[No title specified]";

            // mapping is an array of expressions to pass in as parameters
            var mapping = action.mapping;
            if (mapping == null) mapping = [];
            if (isc.isAn.Array(mapping)) template[13] = mapping.join(); // automatically puts commas between args
            else template[13] = mapping; // assume a single string
        }


        return template.join(isc._emptyString);
    },
    _workflowActionToExpressionTemplate: [
        "var process = isc.ClassFactory.newInstance(",  // 0
        ,                                               // 1 Expression as string
        ");",                                           // 2
        "if (!process){",                               // 3
        "var message='Cannot create process';",         // 4
        "isc.Log.logWarn(message);if(isc.designTime)isc.say(message);return}",  // 5
        "var ruleScope=(this.getRuleScope?this.getRuleScope():null);",          // 6
        "if (ruleScope)process.ruleScope=ruleScope;",   // 7
        "var screenComponent=isc.isA.FormItem(this)?this.form._screen:this._screen;", // 8
        "if (!screenComponent && this.componentID && isc.isA.ListGrid(window[this.componentID])) screenComponent=window[this.componentID]._screen;", // 9
        "if (screenComponent)process.screenComponent=screenComponent;", // 10
        "process.start();"                              // 11
    ],

    _workflowActionToExpressionString : function (expression, varsArray) {
        var expressionString = this._replaceParameterMarkers(isc.JSON.encode(expression), varsArray);
        var template = this._workflowActionToExpressionTemplate;
        template[1] = expressionString;
        return template.join(isc._emptyString);
    },
    _replaceParameterMarkers : function (expressionString, varsArray) {
        if (!varsArray) return;
        var result = expressionString;
        for (var i = 0; i < varsArray.length; i++) {
            result = result.replace("\"^" + varsArray[i] + "\"", varsArray[i]);
        }
        return result;
    },
    _expressionToFunction : function (variables, expression, comment) {


        if (expression == null) {
            //>DEBUG
            isc.Log.logInfo("makeFunctionExpression() called with empty expression");
            //<DEBUG
            expression = "";
        }
        // Handle being passed an action type object.
        // This is an object of the format
        //   { target:"componentId", name:"fetchData", title:"click" }
        // or
        //  { target: "someForm", name : "editRecord", title:"itemChanged",
        //    // action method param name -> expression to populate it
        //    mapping : {
        //        record : "record",
        //        callback : "someExpression()" // something use manually entered
        //    }
        //  }
        // or workflow process properties object
        //  { _constructor: "Process", elements: [...], ... }
        if (isc.isAn.Object(expression)) {
            var varsArray = variables;
            if (isc.isA.String(varsArray)) varsArray= variables.split(",");
            else if (isc.isAn.Array(varsArray)) {
                variables = varsArray.join();
            }
            if (!isc.isAn.Array(varsArray)) varsArray = [];
            expression = isc.Func._resolveAction(expression);
            var expressionString;
            if (expression._constructor == "Process") {
                expressionString = isc.Func._workflowActionToExpressionString(expression, varsArray);
            } else if (isc.isAn.Array(expression)) {
                var numExpressions = expression.length;
                var expressionStrings = [];
                for (var i = 0; i < numExpressions; ++i) {
                    expression[i] = isc.Func._resolveAction(expression[i]);
                    if (!expression[i]) continue;
                    expressionStrings.add(isc.Func._actionToExpressionString(expression[i]));
                }
                expressionString = expressionStrings.join(";\n");
            } else {
                expressionString = isc.Func._actionToExpressionString(expression);
            }
            var theFunc;
            try {
                theFunc = isc._makeFunction(variables, expressionString);
            } catch (e) {
                this.logWarn("invalid code: " + expressionString +
                             " generated from action: " + this.echo(expression));
                theFunc = function () {};
            }
            theFunc.iscAction = expression;

            return theFunc;

        }

        var complexIdStartChars = "swirfv";


        // if variables passed in as an array of strings,
        // convert to a single string of vars separated by commas.
        //
        if (isc.isAn.Array(variables)) {
            variables = variables.join();
        }

        var isSimpleExpression = true;
        // loop through expression character by character. if there is any
        // indication that it contains more than one statement or a complex
        // statement, set isSimpleExpression to false and break.

        var i = 0; // character index.
        var commentDelimiters = this._commentDelimeters;
        var stringDelimiters = this._stringDelimeters;

        // strings that identify that a string is more than a simple expression
        var complexIdentifiers = this._complexIdentifiers;

        // the set of characters that can end a line while allowing a statement to continue onto the
        // next line
        var multiLineDelimiters = this._multiLineDelimeters;

        // keeps track of whether we've seen a semicolon.  Once we've seen a semicolon, anything
        // other than whitespace and comments indicates a multi-statement expression
        var commentsOnly = false;

        // set up some variables to avoid a bunch of string allocation during loops
        var nullString = isc._emptyString,
            commentStart = isc.slash,
            eol = "\n",
            backslash = "\\",
            plusSign = "+",
            semicolon = isc.semi;

        // keeps track of the last non-whitespace character,
        // so we know what it was when we get to the end of a line.
        var lastChar = nullString;

        // keeps track of the next non-whitespace character.
        var nextChar = nullString;
        // loop through each character of the expression
        while (i < expression.length) {
            var currentChar = expression.charAt(i);
            // check if we're in a comment by seeing if the current characters match any comment
            // openers
            if (currentChar == commentStart) {
                for (var j = 0; j < commentDelimiters.length; j++) {
                    var delimiterSet = commentDelimiters[j],
                        opener = delimiterSet[0],
                        closer = delimiterSet[1]
                    ;
                    //if (expression.substring(i, i + opener.length) == opener) {
                    if (expression.indexOf(opener, i) == i) {
                        // we're in a comment.. skip until we find the comment closer
                        var k = i + opener.length;
                        while (k < expression.length) {
                            if (expression.substring(k, k + closer.length) == closer) {
                                k = k + closer.length;
                                break;
                            }
                            k++;
                        }
                        i = k;
                        lastChar = nullString;
                        nextChar = this._getNextNonWhitespaceChar(expression, i);
                    }
                }
            }
            // we've seen a semicolon.  From here on, if we find anything other than a comment or
            // whitespace, we've got a complex expression
            if (commentsOnly) {
                // if we only have whitespace until the end, we can break now.
                if (nextChar == nullString) {
                    break;
                } else {
                    if (isc.isA.WhitespaceChar(currentChar)) {
                        i++;
                        continue;
                    } else {
                        isSimpleExpression = false;
                        break;
                    }
                }
            }

            // check for the beginning of string
            for (var j = 0; j < stringDelimiters.length; j++) {
                var delim = stringDelimiters[j]
                if (currentChar == delim) {
                    // we're in a string; find the next unquoted delimeter of the same kind
                    var k = i + 1;
                    while (k < expression.length) {
                        if (expression.charAt(k) == backslash) k = k + 2; // skip over escapes
                        if (expression.charAt(k) == delim) {
                            k++;
                            break;
                        }
                        k++;
                    }
                    i = k;
                    lastChar = delim.charAt(0);
                    nextChar = this._getNextNonWhitespaceChar(expression, i);
                }
            }

            // check if we've reached the end of a line
            if (currentChar == eol) {
                // see if the last character on the line is one that would allow the statement to
                // continue onto another line
                var isMLD = false;
                for (var j = 0; j < multiLineDelimiters.length; j++) {
                    if (lastChar == multiLineDelimiters[j]) {
                        isMLD = true;
                        break;
                    }
                }
                if (isMLD || nextChar == plusSign) {
                    lastChar = nullString;
                } else {
                    // the last character on this line closed a statement, and there's more
                    // characters, so this has to be a multi-statement expression
                    isSimpleExpression = false;
                    break;
                }
            }

            // look for semicolon
            if (currentChar == semicolon) {
                // set the commentsOnly flag to switch modes: from here on, if we find anything
                // other than a comment or whitespace, we've got a complex expression
                commentsOnly = true;
            }

            // check for keywords that indicate that this is not a simple expression
            // Note: There's a bug in string.charAt() in IE4 whereby a negative index will
            // return the first char of the string.
            // Therefore explicitly check whether the keyword is present and either at the
            // beginning or end of the string, or delimited by non AlphaNumeric chars.
            // (IE: it is the keyword, not just a substring of a non-keyword)

            // _complexIdentifiers :
            //     ["switch", "while", "if", "return", "for", "var", "let", "const"]
            if (complexIdStartChars.indexOf(currentChar) != -1) {

            for (var j = 0; j < complexIdentifiers.length; j++) {
                var word = complexIdentifiers[j],
                    length = word.length;

                if (
                     // Don't check if there are not enough characters for the keyword
                     (i + length <= expression.length) &&
                     // Is the keyword present?
                     (expression.substring(i, i+length) == word) &&
                     // Is it at the end of the string, or followed by a non Alpha char?
                     (i + length == expression.length ||
                      !isc.isA.AlphaNumericChar(expression.charAt(i + length))) &&
                     // Is it at the beginning of the string, or preceded by a non Alpha char?
                     (i == 0 ||
                      !isc.isA.AlphaNumericChar(expression.charAt(i - 1)))

                ) {
                    isSimpleExpression = false;
                    break;
                }
            }

            }

            // if the current char isn't whitespace, set it as the last non-whitespace char
            if (!isc.isA.WhitespaceChar(currentChar)) lastChar = currentChar;

            // increment
            i++;

            // set up a new nextChar
            nextChar = this._getNextNonWhitespaceChar(expression, i);

        }
        if (isSimpleExpression) {
            expression = "return " + expression;
        }
        // add a comment (if one was passed in) to the function
        // this lets us label the functions if we want to
        if (comment) expression = "/" + "/" + comment + "\r\n" + expression;

        // now create the new function and return it.
        var theFunc = isc._makeFunction(variables, expression);
        return theFunc;
    },

    //>    @method Func._getNextNonWhitespaceChar()    (A)
    //
    //     subroutine used by expressionToFunction(). gets the next non-whitespace character
    //     after the given index.
    //
    //  @params expression      (String)        String expression to evaluate return
    //    @params    index            (number)        index after which to look for nextChar
    //<
    _getNextNonWhitespaceChar : function (expression, index) {
        // set up a new nextChar
        var nextChar = isc._emptyString;
        for (var j = (index + 1); j < expression.length; j++) {
            if (!isc.isA.WhitespaceChar(expression.charAt(j))) {
                nextChar = expression.charAt(j);
                break;
            }
        }
        // we searched to the end of the string.
        if (j >= expression.length) nextChar = isc._emptyString;
        return nextChar;
    },


    //>    @method Func.convertToMethod()
    //
    //  A static version of class.convertToMethod()
    //    This takes an object and the name of a property as parameters, and (if legal)
    //  attempts to convert the property to a function.
    //  If the property's value is a function already, or the property is registered via
    //  Class.registerStringMethods() as being a legitimate target to convert to a function,
    //  return true.
    //  Otherwise return false
    //
    //  @param  object          (Object)    object with property to convert
    //    @param    functionName     (String)    name of the property to convert to a string.
    //
    //    @return                    (boolean)   false if this is not a function and cannot be converted
    //                                      to one
    //
    //<
    convertToMethod : function (object, methodName) {

        // Handle bad parameters
        // XXX How to log this better - we know nothing about object, so can't do getID() or
        //     whatever
        if (!isc.isAn.Object(object) || !isc.isA.nonemptyString(methodName)) {
            isc.Log.logWarn("convertToMethod() called with bad parameters.  Cannot convert " +
                            " property '" + methodName + "' on object " + object +
                            " to a function.  Returning false.");
            return false;
        }

        // If the value of this property is already a function - we don't need to make any
        // changes, and can assume it's a legal property value.
        if (object[methodName] && isc.isA.Function(object[methodName])) return true;

        // By default the _stringMethodregistry map object is a static property on the Class
        // of the object passed in.
        // If the object passed in is not a member of a subclass of 'Class', this is not the case.
        // In these cases assume the _stringMethodRegistry map has been assigned to the object
        // directly (for now)
        // XXX - Currently this is not really used anywhere in the code, but potentially could
        // be for stringMethods on (for example) the ListViewer data array.
        var registry = (isc.isAn.Instance(object) ? object.getClass()._stringMethodRegistry :
                                                object._stringMethodRegistry);
        // return false if there's no registry.
        if (registry == null) return false;

        var undef;
        var methodParamsString = registry[methodName];

        // If the value is not in the map, return false - this property can't legally be
        // converted to a function by us, so don't attempt it!
        // triple "=" - check for identity not equivalence, as having the argument string be
        // null is legitimate.

        // If this method is not listed in the stringMethodRegistry, we can't convert the
        // property value to a method.
        if (methodParamsString === undef) return false;

        // We're dealing with a valid string method - attempt to convert the property value.
        isc.Func.replaceWithMethod(object, methodName, methodParamsString);

        // and return true to indicate that this is a legal slot for a function and should now
        // contain a function (if the conversion was possible).
        return true;
    },


    //>    @method Func.replaceWithMethod()    (A)
    //
    //     Given an object with a string property, convert the string to a function
    //    and assign it to the same property name.
    //
    //    This is useful when you expect developers to pass a method (such as an event handler,
    //  etc) as a string, but you need to execute it as a function.
    //
    //    @params    object        (Object)    Object containing the property
    //    @params    methodName    (String)    Names of the method to convert from string to a function
    //    @params    variables    (String)    Names of variables to pass into the new function
    //<
    replaceWithMethod : function (object, methodName, variables, comment) {

        // If no string has been provided for the stringMethod, create a function with the
        // correct signature.  Signature has to match so that you can observe an undefined
        // string method.
        if (object[methodName] == null) {
            object[methodName] = isc.is.emptyString(variables)
                    ? isc.Class.NO_OP
                    : isc._makeFunction(variables, isc._emptyString);
        }

        var stringMethod = object[methodName];

        // already converted
        if (isc.isA.Function(stringMethod)) return;

        var convertedMethod;

        if (isc.isA.String(stringMethod) || isc.isA.Object(stringMethod)) {
            // expressionToFunction can handle stringMethods and 'action' type objects
            convertedMethod = isc.Func.expressionToFunction(variables, stringMethod, comment);
        } else {

            isc.Log.logWarn("Property '" + methodName + "' on object " + object + " is of type " +
                            typeof stringMethod + ".  This can not be converted to a method.",
                            "Function");

            return;
        }

        // add the converted function to the object:
        var temp = {};
        temp[methodName] = convertedMethod;
        isc.addMethods(object, temp);
    }

});




//>    @object    Array
// Generic extensions to JavaScript Arrays.  You can call these on any Array.
// <P>
// JavaScript's native Array is retrofitted to support the <code>List</code> API.
//
// @implements List
// @see List
// @treeLocation Client Reference/System
// @visibility external
//<

// Internal notes: Array vs the List interface
// - List is an interface which the native JavaScript Array object is retrofitted to implement
// - When a given method can be implemented solely in terms of other parts of the List interface,
//   there is the possibility that Array and the List interface can share the actual JavaScript
//   function object.  When this is done, the method is first defined on Array (for load order
//   reasons).
// - on Array, several methods can be faster if they use various native functions (like splice()),
//   and so a unique implementation appears here
// - on List, in order to allow a valid List implementation with a minimum of effort, all methods
//   boil down to very simple primitives like addAt

// - public documentation for the List interface is in List.js

//> @groupDef dataChanged
// Operations that change the Array
// @title Data Changes
//<

//> @groupDef iteration
// Operations on entire Arrays at once
// @title Iteration
//<

//> @groupDef arrayMath
// Math operations on entire Arrays at once
// @title Array Math
//<

// add a "Class" property to the array prototype
//    so we can recognize Array instances
Array.prototype.Class = "Array";

//>    @classMethod        Array.newInstance()
//        Create a new array, adding any arguments passed in as properties.
//        Here so we can make standard newInstance() calls on arrays.
//
//        @param    [all arguments]    (Object)    objects with properties to override from default
//        @return    (Array)    new array.
//<
Array.newInstance = function () {
    var instance = [];
    isc.addPropertyList(instance, arguments);
    return instance;
}
Array.create = Array.newInstance;

//> @classMethod Array.duplicate()
// Return an array that is a shallow copy of the supplied array, that is, containing the same
// items.
//
// @param array (Array) array to duplicate
// @return      (Array) new array
//<
Array.duplicate = function (array) {
    return isc._emptyArray.concat(array);
},

//> @classMethod Array.createFromItemArgs()
// Return a new array consisting of the provided arguments as array items.
//
// @param [arguments 1-N] (Object) objects to add as items of the new array
// @return (Array) new array
//<
Array.createFromItemArgs = function () {
    return Array.prototype.slice.call(arguments);
},

//> @classAttr Array.LOADING (String : "loading" : IRA)
// Marker value returned by Lists that manage remote datasets, indicating the requested data is
// being loaded. Note that the recommended test for loading data is to call +link{Array.isLoading()}
// rather than compare to this value directly.
// @visibility external
//<

Array.LOADING = "loading";

//> @classMethod Array.isLoading() (A)
// Is the object passed in a loading marker value? For use with Lists that manage remote
// datasets, to indicate that a record has not yet been retrieved from the server. A typical
// use case might be to check if a row has been loaded in a ListGrid - for example:
// <P>
// <code>
// if (Array.isLoading(myList.getRecord(0))) isc.warn("Please wait for the data to load.");
// </code>
// @param value (Any) data to test.
// @visibility external
//<
Array.isLoading = function (row) {

    return row != null &&

            !isc.isAn.XMLNode(row) &&

            (row === Array.LOADING);
}

//> @classAttr Array.CASE_INSENSITIVE (Function : See below : R)
// This is a built-in comparator for the +link{array.find,find} and +link{array.findIndex,findIndex}
// methods of Array.  Passing this comparator to those methods will find case-insensitively,
// so, eg, <code>find("foo", "bar")</code> would find objects with a "foo" property set to
// "Bar", "BAR" or "bar"
// @visibility external
//<
Array.CASE_INSENSITIVE = function(arrayMemberProperty, comparisonProperty, propertyName) {
    return (
        arrayMemberProperty == comparisonProperty ||
        (isc.isA.String(arrayMemberProperty) &&
         isc.isA.String(comparisonProperty) &&
         arrayMemberProperty.toLowerCase() == comparisonProperty.toLowerCase()));
};

//> @classAttr Array.DATE_VALUES (Function : See below : R)
// This is a built-in comparator for the +link{array.find,find} and +link{array.findIndex,findIndex}
// methods of Array.  Passing this comparator to those methods will find instances where Dates
// in the search criteria match Dates in the array members (ordinarily, Javascript only regards
// Dates as equal if they refer to the exact same object).  This comparator compares <i>logical</i>
// dates; the time elements of the values being compared are ignored, so two Dates representing
// different times on the same day will be considered equal.
// @see Array.DATETIME_VALUES
// @visibility external
//<
Array.DATE_VALUES = function(arrayMemberProperty, comparisonProperty, propertyName) {
    return (
        arrayMemberProperty == comparisonProperty ||
        (isc.isA.Date(arrayMemberProperty) &&
         isc.isA.Date(comparisonProperty) &&
         isc.DateUtil.compareLogicalDates(arrayMemberProperty, comparisonProperty) == 0));
};

//> @classAttr Array.DATETIME_VALUES (Function : See below : R)
// This is a built-in comparator for the +link{array.find,find} and +link{array.findIndex,findIndex}
// methods of Array.  Passing this comparator to those methods will find instances where Dates
// in the search criteria match Dates in the array members (ordinarily, Javascript only regards
// Dates as equal if they refer to the exact same object).  This comparator compares entire
// date values, including the time elements of the values being compared, so two Dates
// representing different times on the same day (even if they are only a millisecond apart)
// will not be considered equal.
// @see Array.DATE_VALUES
// @visibility external
//<
Array.DATETIME_VALUES = function (arrayMemberProperty, comparisonProperty, propertyName) {

    return (
        arrayMemberProperty == comparisonProperty ||
        (isc.isA.Date(arrayMemberProperty) &&
         isc.isA.Date(comparisonProperty) &&
         isc.DateUtil.compareDates(arrayMemberProperty, comparisonProperty) == 0));
};


if (!Array.prototype.localeStringFormatter)
    Array.prototype.localeStringFormatter = "toString";

//> @classAttr Array.excludeFromSortProperty (String : "_excludeFromSort" : IRA)
// If this property is set on a record, calling +link{Array.add} won't trigger
// a sort even if +link{Array.sortProps} are set.
//<
Array.excludeFromSortProperty = "_excludeFromSort";

// add a bunch of methods to the Array prototype so all arrays can use them
isc.addMethods(Array.prototype, {

iscToLocaleString : function () {
    return this[this.localeStringFormatter]();
},

//>    @method        array.getPrototype()
//        Return the Array.prototype -- for conformity with the Class.getPrototype() method
//        Used in exporting arrays.
//<
getPrototype : function () {
    return Array.prototype;
},


//>    @method        array.newInstance()
//        Create a new array, adding any arguments passed in as properties.
//        Here so we can make standard newInstance() calls on arrays.
//
//        @param    [all arguments]    (Object)    objects with properties to override from default
//        @return    (Array)    new array.
//<
newInstance : Array.newInstance,
create : Array.newInstance,

// List Interface
// --------------------------------------------------------------------------------------------

//>    @method        array.get()
// @include list.get()
//<
get : function (pos) {
    return this[pos]
},

//>    @method        array.getLength()
// @include list.getLength()
//<
getLength : function () {
    return this.length
},

//>    @method        array.isEmpty()
// @include list.isEmpty()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
isEmpty : function () {
    return this.getLength() == 0;
},

//>    @method        array.first()
// @include list.first()
//<
first : function () {
    return this[0]
},

//>    @method        array.last()
// @include list.last()
//<
last : function () {
    return this[this.length-1]
},

nativeIndexOf : Array.prototype.indexOf,

//>    @method        array.indexOf()
// @include list.indexOf()
//<

indexOf : function (obj, pos, endPos, comparator) {

    var OBJ = Object(this),
        length = OBJ.length >>> 0;

    // normalize position to the start of the list
    if (pos == null) pos = 0;
    else if (pos < 0) pos = Math.max(0, length + pos);
    if (endPos == null) endPos = length - 1;

    var hasComparator = (comparator != null);
    for (var i = pos; i <= endPos; i++) {
        if (hasComparator ? comparator(OBJ[i], obj) : OBJ[i] == obj) {
            return i;
        }
    }

    // not found -- return the not found flag
    return -1;
},


fastIndexOf : function (obj, pos, endPos) {
    // normalize position to the start of the list
    if (pos == null) pos = 0;
    if (endPos == null) endPos = this.length - 1;

    for (var i = pos; i <= endPos; i++) {
        if (this[i] == obj) {
            return i;
        }
    }

    // not found -- return the not found flag
    return -1;
},

nativeLastIndexOf : Array.prototype.lastIndexOf,

//>    @method        array.lastIndexOf()
// @include list.lastIndexOf()
//<

lastIndexOf : function (obj, pos, endPos, comparator) {
    var OBJ = Object(this),
        length = OBJ.length >>> 0;

    // normalize position to the end of the list
    if (pos == null) pos = length - 1;
    else if (pos < 0) {
        pos = length + pos;
        if (pos < 0) return -1;
    }
    if (endPos == null) endPos = 0;

    var hasComparator = (comparator != null);
    for (var i = pos; i >= endPos; i--) {
        if (hasComparator ? comparator(OBJ[i], obj) : OBJ[i] == obj) {
            return i;
        }
    }

    // not found -- return the not found flag
    return -1;
},

//>    @method        array.contains()
// @include list.contains()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
contains : function (obj, pos, comparator) {
    return (this.indexOf(obj, pos, null, comparator) != -1);
},

_containsDuplicates : function (comparator) {
    for (var i = 0, len = this.length; i < len - 1; ++i) {
        var obj = this[i];
        if (this.contains(obj, i + 1, comparator)) return true;
    }
    return false;
},


removeDuplicates : function () {
    for (var i = 0, len = this.length; i < len - 1; ++i) {
        var obj = this[i];
        if (obj == null) continue;
        var nextIndex = this.indexOf(obj, i+1);
        while (nextIndex != -1) {
            this.removeAt(nextIndex);
            nextIndex = this.indexOf(obj, nextIndex);
        }
    }


},

// helper method for doing a substring search

containsSubstring : function (obj, startPos, endPos, ignoreCase, matchStyle) {
    if (obj == null) return true;
    if (matchStyle == null) matchStyle = "substring";
    var result = this.indexOf(obj, startPos, endPos, function (a, b) {
        var filter = b == null ? null : (isc.isA.String(b) ? b : b.toString()),
            value = a == null ? null : (isc.isA.String(a) ? a : a.toString())
        ;
        if (ignoreCase) {
            if (filter != null) filter = filter.toLowerCase();
            if (value != null) value = value.toLowerCase();
        }
        var r = false;
        if (value != null && filter != null) {
            if (value == filter) {
                r = true;
            } else if (matchStyle == "substring" &&
                                        value && value.contains && value.contains(filter))
            {
                r = true;
            } else if (matchStyle == "startsWith" &&
                                        value && value.startsWith && value.startsWith(filter))
            {
                r = true;
            }
        }
        return r;
    });

    return result >= 0;
},

//> @method     array.containsAll()
// @include list.containsAll()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
containsAll : function (list) {
    if (list == null) return true;
    var length = list.getLength();
    for (var i = 0; i < length; i++) {
        if (!this.contains(list.get(i))) return false;
    }
    return true;
},

// string-based method - substring search - returns true if all of the values from the passed
// list appear somewhere in the contents of the values in this list
containsAllSubstring : function (list, ignoreCase) {
    if (list == null) return true;
    var length = list.getLength();
    for (var i = 0; i < length; i++) {
        if (!this.containsSubstring(list.get(i), null, null, ignoreCase)) return false;
    }
    return true;
},

//>    @method        array.intersect()
// @include list.intersect()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
intersect : function () {
    var results = [];

    // for each element in this array
    for (var i = 0; i < this.length; i++) {
        // if the element is in each argument, add it to the results
        var item = this.get(i),
            isPresent = true;

        // skip null elements
        if (item == null) continue;

        // for each array passed in
        for (var a = 0; a < arguments.length; a++) {
            // if the item is not in that array
            if (!arguments[a].contains(item)) {
                // it hasn't been found
                isPresent = false;
                break;
            }
        }
        if (isPresent) results.add(item);
    }

    // return true
    return results;
},

// variant of intersect that specifically deals with arrays of dates, which need to be compared
// with compareDates() and compareLogicalDates()
intersectDates : function () {
    var results = [];

    // for each element in this array
    for (var i = 0; i < this.length; i++) {
        // if the element is in each argument, add it to the results
        var item = this.get(i),
            isPresent = true
        ;

        // skip null elements
        if (item == null) continue;

        var logicalDate = item.logicalDate;

            // for each array passed in
        for (var a = 0; a < arguments.length; a++) {
            var otherArray = arguments[a];
            var inOtherArray = false;
            if (!otherArray) continue;
            for (var b = 0; b < otherArray.length; b++) {
                var otherItem = otherArray[b];
                if (!otherItem) continue;
                if (logicalDate) {
                    if (isc.DateUtil.compareLogicalDates(item, otherItem) == 0) {
                        inOtherArray = true;
                        break;
                    }
                } else {
                    if (isc.DateUtil.compareDates(item, otherItem) == 0) {
                        inOtherArray = true;
                        break;
                    }
                }
            }
            if (!inOtherArray) {
                isPresent = false;
                break;
            }
        }
        if (isPresent) results.add(item);
    }

    return results;
},

// variant of intersect that compares arrays of values as strings - returns entries from this
// array that appear as a substring of at least one entry in each of the passed arrays

_intersectSubstringIgnoreCase: true,
intersectSubstring : function (lists, ignoreCase, matchStyle) {
    // If the "lists" param is not a list of lists, make it one
    if (!isc.isAn.Array(lists)) lists = [lists];
    if (!isc.isAn.Array(lists[0])) lists =[lists];
    var results = [];
    if (ignoreCase == null) ignoreCase = this._intersectSubstringIgnoreCase;
    ;

    // for each element in this array
    for (var i = 0; i < this.length; i++) {
        // if the element is in each argument, add it to the results
        var item = this.get(i),
            isPresent = true;

        // skip null elements
        if (!item) continue;

        // for each array passed in
        for (var a = 0; a < lists.length; a++) {
            var otherArray = lists[a];
            if (!otherArray) continue;

            // match if any of the elements in the passed array contains "item" as a substring
            if (!otherArray.containsSubstring(item, null, null, ignoreCase, matchStyle)) {
                isPresent = false;
                break;
            }
        }
        if (isPresent) results.add(item);
    }

    // return true
    return results;
},

//>    @method        array.equals()
// @include list.equals()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
equals : function (list) {
    if (list == null || !isc.isA.List(list)) return false;

    var length = list.getLength();

    // arrays of differing lengths cannot be equals
    if (length != this.getLength()) return false;

    for (var i = 0; i < length; i++) {
        if (list.get(i) != this.get(i)) return false;
    }
    return true;
},

//>    @method        array.getItems()
// @include list.getItems()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
getItems : function (itemList) {
    var length = itemList.getLength(),
        outputs = new Array(length);
    for (var i = 0; i < length; ++i) {
        outputs[i] = this.get(itemList.get(i));
    }
    return outputs;
},

//>    @method        array.getRange()
// @include list.getRange()
//<
getRange : function (start, end) {
    if (end == null) end = this.length - 1;
    return this.slice(start, end);
},

//>    @method        array.duplicate()    (A)
// @include list.duplicate()
//<

duplicate : function () {
    return isc._emptyArray.concat(this); // NOTE: concat creates a copy
},

// getData() from list - no analogous method

//>    @method        array.set()
// @include list.set()
//<
set : function (pos, item) {
    var result = this[pos];
    this[pos] = item;
    this.dataChanged();
    return result;
},

//>    @method        array.addAt()
// @include list.addAt()
//<
addAt : function (obj, pos) {
    if (pos == null) pos = 0;

    this.splice(pos, 0, obj);

    // call dataChanged in case anyone is observing it
    this.dataChanged();

    // return the object that was added
    return obj;
},

//>    @method        array.removeAt()
// @include list.removeAt()
//<
removeAt : function (pos) {
    // make sure the pos passed in is valid
    var length = this.length;
    if (pos >= length || pos < 0) return null;

    var removedList = this.splice(pos, 1);

    // call dataChanged in case anyone is observing it
    this.dataChanged();

    return removedList[0];
},

//>    @method        array.add()
// @include list.add()
//<
add : function (object, secondArg, disallowSortingOnLoadingMarker) {
    var undef;
    if (secondArg !== undef) {
        // support calling as add(index, object)
        return this.addAt(object, secondArg);
    }
    var pos;
    // if the list.sortUnique is true, we're only supposed to have each item once
    if (this.sortUnique) {
        // find the current position of the item in the list
        pos = this.indexOf(object);
        // if it wasn't found, put it at the end
        if (pos == -1) pos = this.length;
    } else {
        // otherwise we always put the item at the end
        pos = this.length;
    }
    // actually stick the object in the list
    this[pos] = object;

    // if we are currently sorted, maintain current sort

    if (!this._addListRunning) {
        if (this.sortProps && this.sortProps.length > 0 &&
            (object == null || !object[Array.excludeFromSortProperty]))
        {

            this.sortByProperties(
                this.sortProps, this.sortDirections, this.sortNormalizers, undef, undef,
                false, disallowSortingOnLoadingMarker);
        }

        // call dataChanged in case anyone is observing it
        this.dataChanged();
    }

    // return the object that was added
    return object;
},

//>    @method        array.addList()
// @include list.addList()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
addList : function (list, listStartRow, listEndRow) {
    if (list == null) return null;

    this._startChangingData();

    if (listStartRow == null) listStartRow = 0;
    if (listEndRow == null) listEndRow = list.getLength();

    var recursive = this._addListRunning;
    this._addListRunning = true;
    var mustResort = false;
    for (var pos = listStartRow; pos < listEndRow; pos++) {
        var object = list.get(pos)
        this.add(object);
        if (object != null && !object[Array.excludeFromSortProperty]) mustResort = true;
    }
    if (!recursive) delete this._addListRunning;

    if (this.sortProps && this.sortProps.length > 0 && mustResort) {

        var undef;
        this.sortByProperties(
            this.sortProps,
            this.sortDirections,
            this.sortNormalizers,
            undef,
            undef,
            false
        );
    }

    this._doneChangingData();

    // return the objects that were added
    return list;
},

//>    @method        array.setLength()
// @include list.setLength()
//<
setLength : function (length) {
    this.length = length;
},

//>    @method        array.addListAt()
// @include list.addListAt()
//<

addListAt : function (list, pos) {
    if (list == null) return null;

    // extract the tail of this array, from pos through the end
    var tail = this.splice(pos, this.length - pos);

    // add the new items in list
    if (isc.isAn.Array(list)) {
        list.forEach(function(value, index) {this[pos + index] = value;}, this);
    } else {
        for (var i = 0; i < list.getLength(); i++) this[pos + i] = list.get(i);
    }

    // add back the tail
    var tailPos = pos + list.getLength();
    tail.forEach(function(value, index) {this[tailPos + index] = value;}, this);

    // call dataChanged in case anyone is observing it
    this.dataChanged();

    // return the list that was added
    return list;
},


//>    @method        array.remove()
// @include list.remove()
//<
remove : function (obj) {


    var index = this.indexOf(obj);
    if (index == -1) return false;

    this.removeAt(index);
    // removeAt() calls dataChanged().

    return true; // indicating object was removed, per java.util.Collection
},

//>    @method        array.removeList()
// @include list.removeList()
//<
removeList : function (list) {
    if (list == null) return null;

    // run through all the items, putting things we want to retain into new list output
    for (var output = [], i = 0, l = this.length;i < l;i++) {
        if (!list.contains(this[i])) output.add(this[i]);
    }
    // now set the items in this list to the items in output
    this.setArray(output);

    // return the list that was removed
    return list;
},

// useful in chaining expressions eg someList.removeEvery(null).getProperty(...)
// .. removeList/removeAll don't work in this circumstance
removeEvery : function (value) {
    this.removeList([value]);
    return this;
},

// methods to ensure dataChanged() fired only once when a series of changes are made: see List.js
_startChangingData : function () {
    var undef;
    if (this._dataChangeFlag === undef) this._dataChangeFlag = 0;
    this._dataChangeFlag++;
},

_doneChangingData : function () {
    if (--this._dataChangeFlag == 0) this.dataChanged();
},

//>    @method        array.dataChanged()    (A)
// @include list.dataChanged()
//<
dataChanged : function () {

    if (this.onDataChanged) this.onDataChanged()
},

// In some cases we want to perform a one-liner - call dataChanged unless we're inside a data
// changing loop
_isChangingData : function () {
    return (this._dataChangeFlag != null && this._dataChangeFlag > 0);
},

// End of List API
// --------------------------------------------------------------------------------------------

//>    @method        array.setArray()
// Completely change the contents of one array to the contents of another array.
// <P>
// This is useful if you have an external pointer to an array, but you want to change its
// contents, such as when you remove some items from the array.
//
//        @group    dataChanged
//
//        @param    (Array)        array to set this array to
//<

setArray : function (list) {
    this.setLength(0);

    // fill slots
    if (isc.isAn.Array(list)) {
        list.forEach(function(value, index) {this[index] = value;}, this);
    } else {
        for (var i = 0; i < list.getLength(); i++) this[i] = list.get(i);
    }

    // call dataChanged in case someone is observing data in the list
    this.dataChanged();
},

//>    @method        array.addAsList()
// Add either a single object or a list of items to this array.
//
//      @group  dataChanged
//
//      @param  list  (Array | Object)  a single object or a list of items to add
//
//      @return       (List)            list of items that were added
//<
addAsList : function (list) {
    if (!isc.isAn.Array(list)) list = [list];
    // return the objects that were added
    return this.addList(list);
},

//>    @method        array.removeRange()
// Remove and return a range of elements from an array - same return value as array.slice(),
// but removes the slice from the array
//
//        @group    dataChanged
//
//        @param    startPos    (number)    start position of range to remove
//      @param  endPos      (number)    end position of range to remove
//
//      @return (Array) array of items that were removed
//<
removeRange : function (startPos, endPos) {
    // fall through to splice
    var undef;
    if (startPos === undef) return this;    // no arguments
    if (!isc.isA.Number(startPos)) startPos = 0;
    if (!isc.isA.Number(endPos)) endPos = this.length;
    return this.splice(startPos, endPos - startPos);
},

//>    @method        array.removeWhere()
//            Remove all instances of object from this array
//        @group    dataChanged
//
//        @param    property    (String)    property to look for
//        @param    value        (String)    value to look for
//<
removeWhere : function (property, value) {
    for (var i = 0, newList = []; i < this.length; i++) {
        if (!this[i] || this[i][property] != value) {
            newList.add(this[i]);
        }
    }
    this.setArray(newList);
},

// Corollary to removeWhere - remove every item where some property is not set to some
// specified value.
removeUnless : function (property, value) {
    for (var i = 0, newList = []; i < this.length; i++) {
        if (this[i] && this[i][property] == value) {
            newList.add(this[i]);
        }
    }
    this.setArray(newList);
},

//>    @method        array.removeEmpty()
//            Remove all empty slots in this array (where array[n] == null)
//        @group    dataChanged
//<
removeEmpty : function (property, value) {
    for (var i = 0, newList = []; i < this.length; i++) {
        if (this[i] != null) {
            newList.add(this[i]);
        }
    }
    this.setArray(newList);
},

//> @method array.getProperty()
// @include list.getProperty
// @visibility external
//<
getProperty : function (property) {
    var output = new Array(this.length);
    for (var i = this.length; i--; ) {
        var entry = this[i];
        output[i] = (entry ? entry[property] : null);
    }
    return output;
},

//>@method array.getValueMap()
// @include list.getValueMap()
// @visibility external
//<
getValueMap : function (idField, displayField) {
    var valueMap = {},
        length = this.getLength()
    ;
    if (isc.isA.ResultSet(this) && !this.lengthIsKnown() && this.initialData) {
        // if this is a ResultSet of unknown length but with initialData, use the length of
        // the initialData - see similar code in ListGrid._updateValueMapFromODS
        length = this.initialData.getLength();
    }
    for (var i = 0, l = length; i < l; i++) {
        var item = this.get(i);
        // Don't attempt to pull properties from empty values / basic data types in the list.
        if (!isc.isAn.Object(item)) continue;
        if (item && item[idField] != null) {
            valueMap[item[idField]] = item[displayField];
        }
    }
    return valueMap;
},

//>    @method        array.map()
// Calls a function for each member of an array, passing in the member, its index and
// the array itself as arguments. Returns a new array containing the
// resulting values.
// <P>
// This behavior is part of the
// +externalLink{http://www.ecma-international.org/ecma-262/6.0/#sec-array.prototype.map,ECMA-262 specification}.
// <P>
// <b>Backwards compatibility note:</b> Historically SmartClient provided a version of
// array.map() which differed from the native behavior in a couple of ways:
// <ul>
// <li>If passed a string as the function argument, it would invoke a same-named method on
//   each member of the array. This is now deprecated in favor of
//   calling +link{array.callMethod()} directly</li>
// <li>If additional arguments other than the <code>function</code> were passed to this
//   method, when the function was invoked for each member, these additional arguments
//   would be passed in when the function was invoked. This is also deprecated as it
//   conflicts with the default native implementation</li>
// </ul>
//        @group    iteration
//
//        @param    method  (Function) function to execute for each item
//        @return    (Array)        array of returned values
// @visibility external
//<

_nativeMap : Array.prototype.map,
map : function (method, arg1, arg2, arg3, arg4, arg5) {

    var OBJ = Object(this),
        isFunc = isc.isA.Function(method);

    if (!isFunc) {
        if (isc.isA.String(method)) {
            if (isc._deprecatedMapWarningShown == null) {
                isc._deprecatedMapWarningShown = {};
            }
            if (!isc._deprecatedMapWarningShown[method]) {
                isc.logWarn("Array.map() passed a string rather than a function:" + method +
                    ". This usage is deprecated in favor of Array.callMethod().");
                isc._deprecatedMapWarningShown[method] = true;
            }
        }
        return this.callMethod(method, arg1, arg2, arg3, arg4, arg5);
    }

    var undef,
        mimicNativeImp = (arg2 === undef && arg3=== undef && arg4 === undef && arg5 === undef);
    if (!mimicNativeImp) {
        if (!isc._deprecatedMapArgsWarningShown) {
            isc.logWarn("Array.map() passed " + arguments.length + "arguments. " +
                "This usage is deprecated.");
            isc._deprecatedMapArgsWarningShown = true;
        }
        return this.mapArgs(method, arg1, arg2, arg3, arg4, arg5);
    }

    // Use the default implementation (assuming it exists)
    if (this._nativeMap) return this._nativeMap(method, arg1);

    // for older browsers, mimic it.
    var length = OBJ.length >>> 0;

    var output = new Array(length);
    for (var i = 0; i < length; ++i) {
        var item;
        item = OBJ[i];
        output[i] = method.call(arg1, item, i, OBJ);
    }
    return output;
},

// Historically this method was implemented in array.call
// Moved to a separate method since this differs from the native JS array.call
// implementation
mapArgs : function (func, arg1, arg2, arg3, arg4, arg5) {
    var result = [],
        length = this.getLength();
    for (var i = 0; i < length; i++) {
        result[i] = func(this[i], arg1,arg2,arg3,arg4,arg5);
    }
    return result;
},


//>    @method array.callMethod()
// Calls a method on each member of an array and returns a new array containing the
// resulting values.
// <P>
// The <code>method</code> argument should be the String name of a
// method present on each item, which will be invoked.  If any item is null
// or lacks the named method, null will be returned for that item.
// <P>
// Examples:<PRE>
//    // line up widgets at 20 pixels from page edge
//    [widget1, widget2].callMethod("setPageLeft", 20);
//
//    // find furthest right widget
//    [widget1, widget2].callMethod("getPageRight").max();
// </PRE>
//
//        @group    iteration
//
//        @param    method  (String) Name of method to execute for on item
//        @param    [arguments 1-N]    (Any)         arguments to pass to the method
//                                           invoked on each item
//        @return    (Array)        array of returned values
// @visibility external
//<
// Historically this method was implemented in array.call (along with the
// 'mapArgs' logic)
// Moved to a separate method since this differs from the native JS array.call
// implementation
callMethod : function (method, arg1, arg2, arg3, arg4, arg5) {
    var result = [],
        length = this.getLength();
    for (var i = 0; i < length; i++) {
        var item = this.get(i);
        result[i] = (item && item[method] != null) ? item[method](arg1,arg2,arg3,arg4,arg5) : null;
    }
    return result;
},


//>    @method        array.setProperty()
//    Set item[property] = value for each item in this array.
//        @group    iteration
//
//        @param    property    (String)    name of the property to set
//        @param    value        (Any)        value to set to
// @visibility external
//<
setProperty : function (property, value) {
    for(var i = 0, l = this.length;i < l;i++)
        if (this[i]) this[i][property] = value;
},

//>    @method        array.clearProperty()
// Delete property in each item in this array.
//        @group    iteration
//
//        @param    property     (String)    name of the property to clear
// @return (boolean) returns true if any of the properties in the array had a value for the
//     specified property.
// @visibility external
//<
clearProperty : function (property) {
    var hadValue = false, undef;
    for(var i = 0, l = this.length;i < l;i++) {
        hadValue = hadValue || this[i] !== undef;
        if (this[i]) delete this[i][property];
    }
    return hadValue;
},


_extractProperty : function (property) {
    var hadValue = false,
        output = new Array(this.length),
        undef;
    for (var i = this.length; i--; ) {
        var record = this[i];
        hadValue = hadValue || (record !== undef);
        if (record) {
            output[i] = record[property];
            delete record[property];
        } else {
            output[i] = null;
        }
    }
    return (hadValue ? output : null);
},

//>    @method        array.getProperties()
// Return a copy of the array where each object has only the list of properties provided.
//        @group    iteration
//
//        @param    properties    (Array of String[])    names of the properties you want to export
//                            (object)    object with the properties you want to export
//
//        @return    (Array)        new Array with each item limited to the specified properties
//<
getProperties : function (properties) {
    return isc.applyMask(this, properties);
},

//>    @method        array.getUniqueItems()
// Return a list of each unique item in this list exactly once.
// <P>
// Returns in the same order they were found in the list.
// <P>
// Usage example:<br>
// &nbsp;&nbsp;&nbsp;&nbsp;uniqueList = myArray.getProperty("foo").getUniqueItems();
//
//        @group    subset
//
//        @return    (Array)    list of each unique item in the list
// @visibility external
//<
getUniqueItems : function () {
    for (var output = [], i = 0, l = this.length; i < l; i++) {
        if (!output.contains(this[i])) output[output.length] = this[i];
    }
    return output;
},

//>    @method        array.slice()
// Return a contiguous range of rows of the array.
// DOES NOT include element at position <code>end</code> (similar to .substring())
// <P>
// NOTE: uses browser's native implementation if one is provided
//
// @param    start    (number)    start index
// @param    [end]    (number)    end index, if not specified will be list.length
//
// @return    (Array)    new array with items from start -> end-1 in it
// @group    subset
//<
slice :
    (Array.prototype.slice
        ? Array.prototype.slice
        : function (start, end) {
            if (end == null) end = this.length;
            for(var output = [], l = this.length; start < end && start < l;start++)
                output[output.length] = this[start];
            return output;
        }
    ),

//>    @method array.findIndex()
// @include list.findIndex
//<

findIndex : function (property, value, comparator) {
    if (isc.isA.List(this) || !isc.isA.Function(property)) {
        // NOTE: implementation stolen by List interface.  Must use only List API for internal access.
        return this.findNextIndex(0, property, value, null, comparator);
    }
    var OBJ = Object(this);
    return Array.prototype.findNextIndex.call(OBJ, 0, property, value, null, comparator);
},

//>    @method array.findNextIndex()
// @include list.findNextIndex
//<
findNextIndex : function (start, property, value, endPos, comparator) {
    var OBJ = Object(this),
        len = OBJ.length >>> 0;
    if (start == null) start = 0;
    else if (start >= len) return -1;
    if (endPos == null) endPos = len - 1;

    if (property == null) return -1;

    var up = endPos >= start;

    if (isc.isA.String(property)) {
        // single property to match
        if (comparator) {
            for (var i = start; (up ? i <= endPos : i >= endPos) ; (up ? i++ : i--)) {
                if (this[i] && comparator(this[i][property], value, property)) return i;
            }
        } else {
            for (var i = start; (up ? i <= endPos : i >= endPos) ; (up ? i++ : i--)) {
                if (this[i] && this[i][property] == value) return i;
            }
        }
        return -1;


    } else if (isc.isA.Function(property)) {
        var predicate = property,
            thisArg = value;
        for (var i = start; (up ? i <= endPos : i >= endPos) ; (up ? i++ : i--)) {
            value = OBJ[i];
            if (predicate.call(thisArg, value, i, OBJ)) return i;
        }
        return -1;

    } else {
        // "property" is an object specifying a set of properties to match
        return this.findNextMatch(property, start, endPos, comparator);
    }
},

findAllIndices : function (property, value, comparitor) {
    var matches = [];
    var start = 0;
    var match;
    do {

        match = this.findNextIndex(start, property, value, null, comparitor);
        if (match != -1) {
            matches.add(match);
            start = match+1;
        }

    } while (match != -1);
    return matches;
},

// internal: assumes multiple properties
findNextMatch : function (properties, start, end, comparator) {
    if (properties._constructor == "AdvancedCriteria") {
        if (isc.DataSource == null) {
            isc.warn("DataBinding module not loaded, AdvancedCriteria not supported for find()/findAll()");
            return -1;
        }
        var dataSource = isc.DataSource.get(this.dataSource) || isc.DataSource;
        var result = dataSource.applyFilter(this.getRange(start, end + 1), properties);
        if (result.size() != 0) return this.findIndex(result.get(0));
        else return -1;
    }

    var propertyNames = isc.getKeys(properties),
        up = end >= start;

    // This processing is largely duplicated, to avoid a check on comparator in the inner loop
    if (comparator) {
        var isFunction = isc.isA.Function(comparator),
            isObject = !isFunction && isc.isAn.Object(comparator),
            isArray = !isFunction && isc.isAn.Array(comparator)
        ;
        if (isArray) {
            // comparator should be a Function or an object of fieldName --> Function, not an Array
            return -1;
        }
        // check the comparators are valid functions in advance, rather than in the main loop
        var validComps = {};
        if (isObject) {
            for (var i = 0; i < propertyNames.length; i++) {
                // multiple-comparator object - establish whether each is a valid Function
                validComps[propertyNames[i]] = isc.isA.Function(comparator[propertyNames[i]]);
                if (!validComps[propertyNames[i]]) {
                    isc.logWarn("Invalid comparator for " + propertyNames[i] + " - " +
                        isc.echo(comparator[propertyNames[i]])
                    );
                }
            }
        }
        for (var i = start; (up ? i <= end : i >= end); (up ? i++ : i--)) {
            var item = this.get(i);
            if (!item) continue;
            var found = true;
            for (var j = 0; j < propertyNames.length; j++) {
                var propertyName = propertyNames[j];
                if (isFunction) {
                    // single comparator, already known to be a Function
                    if (!comparator(item[propertyName], properties[propertyName], propertyName)) {
                        found = false;
                        break;
                    }
                } else if (isObject) {
                    // multiple-comparator object - if the one involved is a Function, execute it
                    if (validComps[propertyName]) {
                        if (!comparator[propertyName](item[propertyName], properties[propertyName], propertyName)) {
                            found = false;
                            break;
                        }
                    }
                }
            }
            if (found) return i;
        }
    } else {
        for (var i = start; (up ? i <= end : i >= end); (up ? i++ : i--)) {
            var item = this.get(i);
            if (!item) continue;
            var found = true;
            for (var j = 0; j < propertyNames.length; j++) {
                var propertyName = propertyNames[j];
                if (item[propertyName] != properties[propertyName]) {
                    found = false;
                    break;
                }
            }
            if (found) return i;
        }
    }
    return -1;
},

//>    @method array.find()
// @include list.find
//<

find : function (property, value, comparator) {
    var undef;
    // NOTE: implementation stolen by List interface.  Must use only List API for internal access.
    if (isc.isA.List(this) || !isc.isA.Function(property)) {
        var index = this.findIndex(property, value, comparator);
        return (index != -1) ? this.get(index) : undef;
    }
    var OBJ = Object(this),
        index = Array.prototype.findIndex.call(OBJ, property, value, comparator);

    // match native find(); return 'undefined' if predicate doesn't return true for any value
    if (index == -1) return undef;
    return ("get" in OBJ ? OBJ.get(index) : OBJ[index]);
},

// given values for the primary key fields ("record"), find the _index of_ the unique
// matching record.
// Will automatically trim extra, non-key fields from "record"
findByKeys : function (record, dataSource, pos, endPos, comparator) {
    if (record == null) {
        //>DEBUG
        isc.Log.logWarn("findByKeys: passed null record");
        //<DEBUG
        return -1;
    }

    // get the values for all the primary key fields from the passed record
    var findKeys = {},
        keyFields = dataSource.getPrimaryKeyFields(),
        hasKeys = false,
        comparators = comparator ? null : {}
    ;

    for (var keyField in keyFields) {
        hasKeys = true;
        var r = record[keyField];
        if (r == null) {
            //>DEBUG
            isc.Log.logWarn("findByKeys: passed record does not have a value for key field '"
                         + keyField + "'");
            //<DEBUG
            return -1;
        }
        findKeys[keyField] = r;
        if (comparators && isc.isAn.Object(r)) {

            comparators[keyField] = isc.DynamicForm.compareValues;
            //this.logWarn("defaulting comparator[" + keyField + "] to DF.compareValues()", "arrayFind");
        }
    }

    if (!hasKeys) {
        //>DEBUG
        isc.Log.logWarn("findByKeys: dataSource '" + dataSource.ID + "' does not have primary " +
                     "keys declared, can't find record");
        //<DEBUG
        return -1;
    }

    if (isc.getKeys(comparators).length > 0) comparator = comparators;

    // go through the recordSet looking for a record with the same values for the primary keys
    return this.findNextIndex(pos, findKeys, null, endPos, comparator);
},

//>    @method        array.containsProperty()
//  Determine whether this array contains any members where the property passed in matches the value
//  passed in.
//
//        @group    find
//        @param    property    (String)    property to look for
//                            (object)    key:value pairs to look for
//        @param    [value]        (Any)        value to compare against (if property is a string)
//
//        @return    (boolean)   true if this array contains an object with the appropriate property value
// @visibility external
//<
containsProperty : function (property, value) {
    var index = this.findIndex(property, value);
    return (index != -1);
},

//>    @method array.findAll()
// @include list.findAll
//<
findAll : function (property, value, comparator) {

    if (property == null) return null;

    if (isc.isA.String(property)) {
        var matches = null,
            l = this.length;

        // single property to match
        var multiVal = isc.isAn.Array(value),
            hasComparator = (comparator != null);
        for (var i = 0; i < l; i++) {
            var item = this[i];
            if (item && (multiVal ?
                    value.contains(item[property], null, comparator) :
                    (hasComparator ?
                        comparator(item[property], value) :
                        item[property] == value)))
            {
                if (matches == null) matches = [];
                matches.add(item);
            }
        }
        return matches;


    } else if (isc.isA.Function(property)) {
        var matches = null,
            l = this.length,
            iterator = property,
            context = value;

        for (var i = 0; i < l; i++) {
            var item = this[i];
            if (iterator(item, context)) {
                if (matches == null) matches = [];
                matches.add(item);
            }
        }
        return matches;
    } else {
        // "property" is an object specifying a set of properties to match
        return this.findAllMatches(property, comparator);
    }
},

// internal: assumes multiple properties
findAllMatches : function (properties, comparators) {
    var l = this.getLength(),
        propertyNames = isc.getKeys(properties),
        matches = null,
        hasComparators = (comparators != null),
        singleComparator = (hasComparators && !isc.isAn.Object(comparators) && comparators);

    if (properties._constructor == "AdvancedCriteria") {
        if (isc.DataSource == null) {
            isc.warn("DataBinding module not loaded, AdvancedCriteria not supported for find()/findAll()");
            return -1;
        }
        var dataSource = isc.DataSource.get(this.dataSource) || isc.DataSource;
        return dataSource.applyFilter(this.getRange(0, this.getLength() + 1), properties);
    }
    for (var i = 0; i < l; i++) {
        var item = this.get(i);
        if (!item) continue;
        var found = true;
        for (var j = 0; j < propertyNames.length; j++) {
            var propertyName = propertyNames[j],
                comparator = (hasComparators && (singleComparator || comparators[propertyName])),
                itemValue = item[propertyName],
                propertiesValue = properties[propertyName];
            if (comparator ?
                !comparator(itemValue, propertiesValue) :
                (itemValue != propertiesValue))
            {
                found = false;
                break;
            }
        }
        if (found) {
            if (matches == null) matches = [];
            matches.add(item);
        }
    }
    return matches;
},

//>    @method        array.slide()    (A)
// Slide element at position start to position destination, moving all the other elements to cover
// the gap.
//
//        @param    start        (number)    start position
//        @param    destination    (number)    destination position for the value at start
// @visibility external
//<
slide : function (start, destination) {
    this.slideRange(start, start+1, destination);
},

//>    @method        array.slideRange()    (A)
// Slide a range of elements from start to end to position destination, moving all the other
// elements to cover the gap.
//
//        @param    start        (number)    start position
//        @param    end         (number)    end position (exclusive, like substring() and slice())
//        @param    destination    (number)    destination position for the range
// @visibility external
//<
slideRange : function (rangeStart, rangeEnd, destination) {
    if (rangeStart == destination) return;
    // remove the range to be moved
    var removed = this.splice(rangeStart, rangeEnd - rangeStart);
    // and add it at the destination
    this.addListAt(removed, destination);
},

//>    @method        array.slideList()    (A)
// Slide the array of rows list to position destination.
//
//        @param    start        (number)    start position
//        @param    destination    (number)    destination position for this[start]
//<
slideList : function (list, destination) {
    var output = [],
        i
    ;

//XXX if destination is negative, set to 0 (same effect, cleaner code below)
if (destination < 0) destination = 0;

    // take all the things from this table before destination that aren't in the list to be moved
    for(i = 0;i < destination;i++)
        if (!list.contains(this[i]))
            output.add(this[i]);

    // now put in all the things to be moved
    for(i = 0;i < list.length;i++)
        output.add(list[i]);

    // now put in all the things after destination that aren't in the list to be moved
    for(i = destination;i < this.length;i++)
        if (!list.contains(this[i]))
            output.add(this[i]);

    // now copy the reordered list back into this array
    this.setArray(output);
},

//>    @method        array.makeIndex()    (A)
// Make an index for the items in this Array by a particular property of each item.
// <P>
// Returns an Object with keys for each distinct listItem[property] value.  Each key will point
// to an array of items that share that property value.  The sub-array will be in the same order
// that they are in this list.
//
//        @param    property        (String)            names of the property to index by
//        @param    alwaysMakeArray    (boolean : false)
//              if true, we always make an array for every index.  if false, we make an Array only
//              when more than one item has the same value for the index property
//        @return    (Object)                    index object
// @visibility external
//<
// NOTE: we don't document the awkard -1 param to allow collisions
makeIndex : function (property, alwaysMakeArray, useIndexAsKey) {
    var index = {};
    var allowCollisions = (alwaysMakeArray == -1);
    alwaysMakeArray = (alwaysMakeArray != null && alwaysMakeArray != 0);
    for (var i = 0; i < this.length; i++) {
        var item = this[i],
            key = item[property]
        ;

        // if the item has no value for the key property
        if (key == null) {
            // either skip it..
            if (!useIndexAsKey) continue;
            // or place it in the index under its position in the array
            key = i;
        }

        if (allowCollisions) {
            index[key] = item;
            continue;
        }

        var existingValue = index[key];
        if (existingValue == null) {
            if (alwaysMakeArray) {
                // every entry should be an array
                index[key] = [item];
            } else {
                index[key] = item;
            }
        } else {
            if (alwaysMakeArray) {
                // any non-null value is an array we created the first time we found an item
                // with this key value
                index[key].add(item);
            } else {
                // if the existing value is an array, add to it, otherwise put the new and old
                // value together in a new array
                if (isc.isAn.Array(existingValue)) {
                    index[key].add(item);
                } else {
                    index[key] = [existingValue, item];
                }
            }
        }
    }

    return index;
},


//>    @method        array.arraysToObjects()    (A)
// Map an array of arrays to an array of objects.
// <P>
// Each array becomes one object, which will have as many properties as the number of property
// names passed as the "propertyList".  The values of the properties will be the values found
// in the Array, in order.
// <P>
// For example:
// <pre>
//    var arrays = [
//       ["Mickey", "Mouse"],
//       ["Donald", "Duck"],
//       ["Yosemite", "Sam"]
//    ];
//    var objects = arrays.arraysToObjects(["firstName", "lastName"]);
// </pre>
// <code>objects</code> is now:
// <pre>
//    [
//       { firstName:"Mickey", lastName:"Mouse" },
//       { firstName:"Donald", lastName:"Duck" },
//       { firstName:"Yosemite", lastName:"Sam" }
//    ]
// </pre>
//
//        @param    propertyList    (Array of String)        names of the properties to assign to
//
//        @return    (Array of Object)        corresponding array of objects
//<
arraysToObjects : function (propertyList) {
    // get the number of properties we're dealing with
    var propLength = propertyList.length;
    // for each item in this array
    var output = new Array(this.length);
    for (var i = this.length; i--; ) {
        // make a new object to hold the output
        var entry = this[i],
            it = output[i] = {};
        // for each property in the propertyList list
        for (var p = propLength; p--; ) {
            var property = propertyList[p];
            // assign that item in the array to the proper name of the new object
            it[property] = entry[p];
        }
    }
    // return the list that was generated
    return output;
},

//>    @method        array.objectsToArrays()    (A)
// Map an array of objects into an array of arrays.
// <P>
// Each object becomes one array, which contains the values of a list of properties from
// the source object.
// <P>
// For example:
// <pre>
//    var objects = [
//       { firstName:"Mickey", lastName:"Mouse" },
//       { firstName:"Donald", lastName:"Duck" },
//       { firstName:"Yosemite", lastName:"Sam" }
//    ]
//    var arrays = objects.objectsToArrays(["firstName", "lastName"]);
// </pre>
// <code>arrays</code> is now:
// <pre>
// [
//    ["Mickey", "Mouse"],
//    ["Donald", "Duck"],
//    ["Yosemite", "Sam"]
// ]
// </pre>
//
//        @param    propertyList    (Array of String)        names of the properties to output
//
//        @return    (Array of Object)        corresponding array of arrays
//<
objectsToArrays : function (propertyList) {
    // get the number of properties we're dealing with
    var propLength = propertyList.length;
    // for each item in this array
    var output = new Array(this.length);
    for (var i = this.length; i--; ) {
        // make a new object to hold the output
        var entry = this[i],
            it = output[i] = [];
        // for each property in the propertyList list
        for (var p = propLength; p--; ) {
            var property = propertyList[p];
            // assign that item in the array to the proper name of the new object
            it[p] = entry[property];
        }
    }
    // return the list that was generated
    return output;
},


_MAX_APPLY_ARGCOUNT: 65535,

//>    @method        array.spliceArray()
//             Like array.splice() but takes an array (to concat) as a third parameter,
//          rather than a number of additional parameters.
//
//      @param  startPos    (number)        starting position for the splice
//      @param  deleteCount (number)        Number of elements to delete from affected array
//      @param  newArray    (Array of Any[])         Array of elements to splice into existing array
//      @return             (Array of Any)  Array of removed elements
//<
spliceArray : function (startPos, deleteCount, newArray) {
    var undef;
    if (startPos    === undef) return this.splice();
    if (deleteCount === undef) return this.splice(startPos);
    if (newArray    === undef) return this.splice(startPos, deleteCount);
    if (!isc.isAn.Array(newArray)) {
        isc.Log.logWarn("spliceArray() method passed a non-array third parameter. Ignoring...", "Array");
        return this.splice(startPos, deleteCount);
    }


    if (newArray.length + 2 <= this._MAX_APPLY_ARGCOUNT) {
        return this.splice.apply(this, [startPos, deleteCount].concat(newArray))
    }

    // extract tail of this array, from startPos through end
    var tail = this.splice(startPos, this.length - startPos);

    // add the elements from newArray at startPos
    newArray.forEach(function(value, index) {this[startPos + index] = value;}, this);

    var deleted = [];
    if (deleteCount < 0) deleteCount = 0;

    // add back the tail, less any deleted items, and build deleted list result
    var tailPos = startPos + newArray.length - deleteCount;
    tail.forEach(function(value, index) {
        if (index < deleteCount) deleted[index]= value;
        else              this[tailPos + index]= value;
    }, this);

    return deleted;
},

// stack peek method - returns the top item on the stack without removing it.
peek : function () {
    var item = this.pop();
    this.push(item);
    return item;
},

// see ResultSet.getCachedRow()
getCachedRow : function (rowNum) {
    return this[rowNum];
},

// Shuffles the elements of this array using the Fisher–Yates shuffle algorithm:
// https://en.wikipedia.org/wiki/Fisher–Yates_shuffle

shuffle : function () {
    var n = this.length;
    while (n > 0) {
        var i = Math.floor(Math.random() * n);
        n--;
        var tmp = this[n];
        this[n] = this[i];
        this[i] = tmp;
    }
},

//
// ----------------------------------------------------------------------------------
// add the observation methods to the Array.prototype as well so we can use 'em there
//

observe: isc.Class.getPrototype().observe,
ignore : isc.Class.getPrototype().ignore,

// Synonyms and backcompat
// --------------------------------------------------------------------------------------------

    //>!BackCompat 2004.6.15 for old ISC names
    removeItem : function (pos) { return this.removeAt(pos) },
    getItem : function (pos) { return this.get(pos) },
    setItem : function (pos) { return this.set(pos) },
    // NOTE: instead of calling clearAll(), setLength(0) should be called (which is much more
    // efficient), however clearAll() still exists to support the old behavior of returning the
    // removed items.
    clearAll : function (list) { return this.removeList(this) },
    //<!BackCompat

    // Support for java.util.List API
    size : function () { return this.getLength() },
    subList : function (start, end) { return this.getRange(start, end) },
    addAll : function (list) { return this.addList(list); },
    removeAll : function (list) {
        var origLength = this.getLength();
        this.removeList(list);
        return this.getLength() != origLength; // return whether list was changed
    },
    clear : function () { this.setLength(0); },
    toArray : function () { return this.duplicate(); }
    // NOTE: incomplete compatibility:
    // - no iterators.  This exists in Java largely for concurrent modification reasons.
    // - remove(int): in Java, the collision between remove(int) and remove(object) is
    //   implemented by method overloading.  In JS, we assume if you pass a number you want
    //   removal by index, but this means remove(5) cannot be used to remove the first instance
    //   of the number 5 from our List.
    // - retainAll: not yet implemented.  Similar to intersect, except the Java version
    //   requires the List to change in place instead of returning the intersection, in order
    //   to preserve the target List's class.
    // - toArray(): in Java, this means go to a native, non-modifiable Array

});


if (!isc.Browser.isIE || isc.Browser.isIE8Strict) {
    Array.prototype.duplicate = Array.prototype.slice;
}


if (isc.Browser.isIE) {

     [].fastIndexOf();
     [].fastIndexOf();
}

if (Array.prototype.nativeIndexOf != null) {
    Array.prototype.indexOf = function (obj, pos, endPos, comparator) {

        var OBJ = Object(this),
            length = OBJ.length >>> 0;
        if (pos == null) pos = 0;
        else if (pos < 0) pos = Math.max(0, length + pos);
        if (endPos == null) endPos = length - 1;

        var i;
        if (comparator != null) {
            for (i = pos; i <= endPos; ++i) {
                if (comparator(OBJ[i], obj)) return i;
            }
        } else {
            if (isc.isAn.Instance(obj)) {
                i = Array.prototype.nativeIndexOf.call(OBJ, obj, pos);
                if (i > endPos) i = -1;
                return i;
            }

            for (i = pos; i <= endPos; ++i) {
                if (OBJ[i] == obj) return i;
            }
        }

        return -1;
    };
} else {
    // native indexOf() doesn't exist in IE <= 8
    Array.prototype.nativeIndexOf = Array.prototype.indexOf;
}


if (isc.Browser.isFirefox || isc.Browser.isSafari) {
    Array.prototype.fastIndexOf = Array.prototype.nativeIndexOf;
}

// Fixes to splice() in older browsers.




//>IE8
// filter() doesn't exist in IE <= 8
if (Array.prototype.filter == null) {

    isc.addMethods(Array.prototype, {

        filter : function (callback, thisObject) {
            var result = [],
                initialLength = this.length; // scan original elements only
            for (var i = 0; i < initialLength; i++) {
                // skip positions for which no elements have been defined
                if (i in this && callback.call(thisObject, this[i])) {
                    result.add(this[i]);
                }
            }
            return result;
        }
    });

}
// forEach() doesn't exist in IE <= 8
if (Array.prototype.forEach == null) {

    isc.addMethods(Array.prototype, {

        forEach : function (callback, thisObject) {
            var initialLength = this.length;
            for (var i = 0; i < initialLength; i++) {
                if (i in this) {
                    callback.call(thisObject, this[i], i, this)
                }
            }
        }
    });

}
//<IE8

// fill() is supported by recent versions of all browsers, including MS Edge, but not IE
if (Array.prototype.fill == null) {
    isc.addMethods(Array.prototype, {
        fill : function (value, start, end) {
            for (var i=start; i<end; i++) {
                this[i] = value;
            }
        }
    });
}

// Array helpers
isc.Array = {
    // Rotates the range of the array `arr` from `i` to `j` (inclusive) in-place by `n` places
    // to the right (or by `-n` places to the left if `n` is negative).
    _rotate : function (arr, i, j, n) {

        if (arr.length < 2) {
            return;
        }

        var m = j - i + 1;
        if (m > 1) {
            n = (m + (n % m)) % m;
            var gcd = isc.Math._gcd(n, m),
                s = (m / gcd);

            for (var p = gcd; p--; ) {
                var kPrime = i + n,
                    k = i + p,
                    temp = arr[k];
                for (var q = s - 1; q--; ) {
                    var l = k - n;
                    if (k < kPrime) {
                        l += m;
                    }
                    arr[k] = arr[l];
                    k = l;
                }
                arr[k] = temp;
            }
        }
    },

    // Move { arr[i], ..., arr[i + n - 1] } to appear after arr[j].
    _moveAfter : function (arr, i, j, n) {

        if (i < j) {
            isc.Array._rotate(arr, i, j, -n);
        } else {
            isc.Array._rotate(arr, j + 1, i + n - 1, n);
        }
    },

    // _binarySearch() returns either the lowest index of a value in `values' that equals `value'
    // or indicates the lowest index in `values' at which `value' may be inserted without breaking
    // the sort order of `values', as induced by `compareFn'.
    //
    // This function assumes that `values' is already sorted by `compareFn'.
    //
    // Parameters:
    // - values (Array of any) an array of values in which to search.
    // - value (any) the value to search for.
    // - [compareFn] (Function) an optional comparator function used to compare values in
    //   `values' with `value'. `compareFn' is called with two arguments. The first is a value
    //   from `values' and the second is always `value'. `compareFn' defaults to
    //   isc.Array._defaultCompareFn if it is not specified.
    // - [strict] (boolean) Should this function search for identical values to `value'
    //   (via ===), or is a zero of `compareFn' sufficient for determining equality? The
    //   default value is false. Note that `compareFn' must return zero when passed identically
    //   equal values for this function to work correctly.
    //
    // Returns:
    // (integer) If `value' is in `values' then this function returns the index of `value' in
    // the array. Otherwise, the return value is `-(insertion index) - 1', where the insertion
    // index is the lowest index at which `value' could be inserted into `values' while maintaining
    // the sort order.
    _binarySearch : function (values, value, compareFn, strict) {

        if (!compareFn) {
            compareFn = isc.Array._defaultCompareFn;
        }

        var low = 0,
            len = values.length,
            high = len - 1;
        var i = 0,
            comparison;
        while (low <= high) {
            i = Math.floor((low + high) / 2);
            comparison = compareFn(values[i], value);
            if (comparison < 0) {
                low = i + 1;
            } else if (comparison > 0) {
                high = i - 1;
            } else {


                // `values[i]' equals `value' according to the compare function. However,
                // it may be that `i' is in the middle of a range of equal values. Keep
                // decrementing `i' until it is the lowest index of that range.
                // If `strict' is true then we are actually looking to return the index of an
                // identically equal value in the `values' array.

                if (strict) {
                    var j = i;

                    do {
                        if (values[j] === value) {
                            return j;
                        }
                        ++j;
                    } while (j < len && compareFn(values[j], value) == 0);
                }

                while (i > 0 && compareFn(values[i - 1], value) == 0) {
                    if (strict && values[i - 1] === value) {
                        return i - 1;
                    }
                    --i;
                }

                // `i' is the insertion index. If strict, return `-i - 1' because the value was
                // not strictly in the `values' array.
                if (strict) {

                    return -i - 1;

                } else {
                    return i;
                }
            }
        }

        // Return the lowest index such that `values' at that index is greater than `value'.
        // That is the index at which `value' could be inserted while maintaining sort order.
        // The actual return value is `-(insertion index) - 1', so that callers can know whether
        // the value was in the `values' array by checking the sign.
        var undef;
        if (comparison !== undef && comparison < 0) {
            // values[i] < value, so i + 1 is the correct insertion index.
            return -(i + 1) - 1;
        } else {


            // values[i] > value, so i is the correct insertion index.
            return -i - 1;
        }
    },

    // Default comparator function used by _binarySearch() if `compareFn' is not provided.
    //
    // Parameters:
    // - lhs (any)
    // - rhs (any)
    //
    // Returns:
    // (number) -1 if `lhs' is less than `rhs', 0 if `lhs' and `rhs' are equal, or 1 if `lhs'
    // is greater than `rhs'
    _defaultCompareFn : function (lhs, rhs) {
        if (lhs < rhs) {
            return -1;
        } else if (lhs > rhs) {
            return 1;
        } else {
            return 0;
        }
    }
};

isc.ClassFactory.defineClass("BitSet");

isc.BitSet.addProperties({

    addPropertiesOnCreate: false,
    init : function () {
        this._ranges = [];
        return this.Super("init", arguments);
    },

    _getRangesIndex : function (index) {
        var k = isc.Array._binarySearch(this._ranges, index);
        return (k < 0 ? -(2 + k) : k);
    },

    get : function (index) {
        return (this._getRangesIndex(index) % 2 == 0);
    },

    nextIndex : function (iterIndex) {

        var ranges = this._ranges;
        return (iterIndex + 1 < ranges.length ? ranges[iterIndex + 1] : -1);
    },

    all : function (value, start, end) {

        var i = this._getRangesIndex(start),
            j = this._getRangesIndex(end - 1);
        return (i == j && (value == (i % 2 == 0)));
    },

    none : function (value, start, end) {

        var i = this._getRangesIndex(start),
            j = this._getRangesIndex(end - 1);
        return (i == j && (value != (i % 2 == 0)));
    },

    firstIndexOf : function (value, start, end) {
        if (!(start < end)) {
            return -1;
        }
        var ranges = this._ranges,
            j = this._getRangesIndex(start);
        if (value == (j % 2 == 0)) {
            return start;
        } else if (j + 1 < ranges.length && ranges[j + 1] < end) {
            return ranges[j + 1];
        } else {
            return -1;
        }
    },

    lastIndexOf : function (value, start, end) {
        if (!(start < end)) {
            return -1;
        }
        var ranges = this._ranges,
            j = this._getRangesIndex(end - 1);
        if (value == (j % 2 == 0)) {
            return end - 1;
        } else if (0 <= j && start <= ranges[j] - 1) {
            return ranges[j] - 1;
        } else {
            return -1;
        }
    },

    // Same as setRange(index, index + 1, value), but returns whether the value at the given
    // index was changed.
    set : function (index, value) {

        var k = this._getRangesIndex(index),
            changed = (value != (k % 2 == 0));
        if (changed) {
            this._setRange(index, k, index + 1, k, value);
        }
        return changed;
    },

    setRange : function (start, end, value) {
        if (!(0 <= start && start < end)) {
            return;
        }

        this._setRange(
            start, this._getRangesIndex(start), end, this._getRangesIndex(end - 1), value);
    },

    // Implementation for set() and setRange():
    _setRange : function (start, i, end, j, value) {
        var ranges = this._ranges;


        // The terminology used here assumes that value is true.
        var startFalse = (value != (i % 2 == 0)),
            endFalse = (value != (j % 2 == 0)),
            mergeLeft = (startFalse && 0 <= i && start == ranges[i]),
            mergeRight = (
                endFalse &&
                j + 1 < ranges.length &&
                end == ranges[j + 1]),
            addStart = (!mergeLeft && startFalse),
            addEnd = (!mergeRight && endFalse),
            index = i + (mergeLeft ? 0 : 1),
            howMany = (j - i + (mergeLeft ? 1 : 0) + (mergeRight ? 1 : 0));
        if (addStart && addEnd) {
            ranges.splice(index, howMany, start, end);
        } else if (addStart) {
            ranges.splice(index, howMany, start);
        } else if (addEnd) {
            ranges.splice(index, howMany, end);
        } else {
            ranges.splice(index, howMany);
        }

    }
});
/*
    Isomorphic SmartClient web presentation layer
    Copyright 2000 and beyond Isomorphic Software, Inc.

    OWNERSHIP NOTICE
    Isomorphic Software owns and reserves all rights not expressly granted in this source code,
    including all intellectual property rights to the structure, sequence, and format of this code
    and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.

    CONFIDENTIALITY NOTICE
    The contents of this file are confidential and protected by non-disclosure agreement:
      * You may not expose this file to any person who is not bound by the same obligations.
      * You may not expose or send this file unencrypted on a public network.

    SUPPORTED INTERFACES
    Most interfaces expressed in this source code are internal and unsupported. Isomorphic supports
    only the documented behaviors of properties and methods that are marked "@visibility external"
    in this code. All other interfaces may be changed or removed without notice. The implementation
    of any supported interface may also be changed without notice.

    If you have any questions, please email <sourcecode@isomorphic.com>.

    This entire comment must accompany any portion of Isomorphic Software source code that is
    copied or moved from this file.
*/



//> @class NumberUtil
// Static singleton class containing APIs for interacting with Numbers.
// @treeLocation Client Reference/System
// @visibility external
//<
isc.defineClass("NumberUtil");

isc.NumberUtil.addClassProperties({
// decimal symbol used in Number.toString() - doesn't vary by locale (whereas toLocaleString() does)
_jsDecimalSymbol : ".",



//> @classAttr NumberUtil.decimalSymbol (String : "." : IR)
// The decimal symbol to use when formatting numbers
// <P><smartgwt>
// Note: the correct symbol is normally auto-derived from GWT's locale system, so the
// only valid reason to set it is desiring to use a language from one locale in combination
// with formatting rules from another locale, in a single application and for a single end user.
// </smartgwt>
// @group i18nMessages
// @visibility external
//<
decimalSymbol : ".",

//> @classAttr NumberUtil.groupingSymbol (String : "," : IR)
// The grouping symbol, or thousands separator, to use when formatting numbers
// <P><smartgwt>
// Note: the correct symbol is normally auto-derived from GWT's locale system, so the
// only valid reason to set it is desiring to use a language from one locale in combination
// with formatting rules from another locale, in a single application and for a single end user.
// </smartgwt>
// @group i18nMessages
// @visibility external
//<
groupingSymbol : ",",

//> @classAttr NumberUtil.negativeSymbol (String : "-" : IR)
// The negative symbol to use when formatting numbers
// <P><smartgwt>
// Note: the correct symbol is normally auto-derived from GWT's locale system, so the
// only valid reason to set it is desiring to use a language from one locale in combination
// with formatting rules from another locale, in a single application and for a single end user.
// </smartgwt>
// @group i18nMessages
// @visibility external
//<
negativeSymbol : "-",

//> @classAttr NumberUtil.currencySymbol (String : "$" : IR)
// The currency symbol to use when formatting numbers
// <P><smartgwt>
// Note: the correct symbol is normally auto-derived from GWT's locale system, so the
// only valid reason to set it is desiring to use a language from one locale in combination
// with formatting rules from another locale, in a single application and for a single end user.
// </smartgwt>
// @group i18nMessages
// @visibility external
//<
currencySymbol : "$",

//> @classAttr NumberUtil.negativeFormat (Number : 1 : IR)
// The format to use when formatting nagative numbers.  Supported values are: 1 = before,
// 2 = after, 3 = beforeSpace, 4 = afterSpace, 5 = parens
// <P><smartgwt>
// Note: the correct format is normally auto-derived from GWT's locale system, so the
// only valid reason to set it is desiring to use a language from one locale in combination
// with formatting rules from another locale, in a single application and for a single end user.
// </smartgwt>
// @group i18nMessages
// @visibility external
//<
negativeFormat : 1,

//> @classAttr NumberUtil.groupingFormat (Number : 1 : IR)
// The grouping-format for numbers
// <P><smartgwt>
// Note: the correct format is normally auto-derived from GWT's locale system, so the
// only valid reason to set it is desiring to use a language from one locale in combination
// with formatting rules from another locale, in a single application and for a single end user.
// </smartgwt>
// @group i18nMessages
// @visibility external
//<
groupingFormat : 1, // 0 = none; 1 = 123,456,789; 2 = 12,34,56,789


//> @classMethod NumberUtil.setStandardFormatter()
// Set the standard "toString()" formatter for Number objects.
// After this call, all <code>numberUtil.toString()</code>  calls will yield a number
// in this format.
//
// @param functionName (String) name of a formatting function on the number object prototype
// @group stringProcessing
//<
setStandardFormatter : function (functionName) {
    if (isc.isA.Function(isc.NumberUtil[functionName]))
        isc.NumberUtil.formatter = functionName;
},

//> @classMethod NumberUtil.setStandardLocaleStringFormatter()
// Set the standard locale formatter for all Number objects.
// After this call, all  <code>isc.iscToLocaleString(number)</code> for number instances
// calls will yield the string returned by the formatter specified.
//
// @param functionName (String) name of a formatting function (on number instances)
// @group stringProcessing
//<
setStandardLocaleStringFormatter : function (functionName) {
    if (isc.isA.Function(isc.NumberUtil[functionName]))
        isc.NumberUtil.localeStringFormatter = functionName;
},

_1zero : "0",
_2zero : "00",
_3zero : "000",
_4zero : "0000",

_getZeroString : function (length) {
    if (length <= 0) return;

    var nu = isc.NumberUtil,
        pad
    ;
    // with > 4 zeros (very rare), build up a leading pad 4 0's at a time
    while (length > 4) {
        if (pad == null) pad = nu._4zero;
        else pad += nu._4zero;
        length -= 4;
    }

    var finalPad;
    switch (length) {
        case 4: finalPad = nu._4zero; break;
        case 3: finalPad = nu._3zero; break;
        case 2: finalPad = nu._2zero; break;
        case 1: finalPad = nu._1zero; break;
    }

    // no leading pad (less than 4 zeros total)
    if (pad == null) return finalPad;
    return pad + finalPad;
},

// Remove any exponent from a the formatted number, adding zeros where
// necessary while preserving the precision represented in the string.
_expandExponent : function (formattedNumber) {

    return formattedNumber.replace(/^([+-])?(\d+).?(\d*)[eE]([-+]?\d+)$/,

        // Search for an exponential in the formatted number, matching four groups:
        //     sign, natural, fraction, coeffcient
        //
        //     sign        = sign of the number
        //     natural     = integer part of significand (a natural number since no sign)
        //     fraction    = fractional part of significand
        //     coefficient = coefficient of number, including sign

        function(matchedString, sign, natural, fraction, coefficient){

            // We define the following variables
            //     lessThanOne           - whether number's absolute value is less than one
            //     normalizedCoefficient - coefficient normalized for the number of digits in
            //                             natural, integer part of the significand (off by one);
            //                             this abstractly represents the total number of digits
            //                             (including any added zeros) to the left of the
            //                             decimal point in the final formatted number
            //     digitsToCross         - when moving the decimal point left or right from its
            //                             place in the significand to remove the exponential,
            //                             the number of digits from the signficand that will
            //                             be crossed (excluding zeros added by our own logic)

            var lessThanOne = +coefficient < 0,
                normalizedCoefficient = natural.length + (+coefficient),
                digitsToCross = (lessThanOne ? natural : fraction).length;

            // Now, build a string of zeros whose length is determined by the absolute value
            // of the coefficient, less the number of digits to cross; this is the number of
            // zeros needed to separate the number from the decimal point.

            coefficient = Math.abs(coefficient);

            var nZeros = coefficient >= digitsToCross ?
                         coefficient - digitsToCross + lessThanOne : 0,
                zeros = nZeros > 0 ? isc.NumberUtil._getZeroString(nZeros) : "";

            // Form the significand (joining both parts together), and attach zeros
            var significand = natural + fraction;
            if (lessThanOne) significand  = zeros + significand;
            else             significand += zeros;

            // If absolute value of number is less than one, offset the
            // normalized coefficient by the number of zeros.
            if (lessThanOne) normalizedCoefficient += zeros.length;

            // Output the digits to the left of the decimal point; we may be done
            var result = (sign || "") + significand.substr(0, normalizedCoefficient);

            // If not, add the remaining fractional digits to the right of the decimal
            if (normalizedCoefficient < significand.length) {
                result += "." + significand.substr(normalizedCoefficient);
            }
            return result;
        });
},

//> @classMethod NumberUtil.stringify()
// Return the passed number as a string padded out to digits length.
//
// @param number (number) Number object to stringify
// @param [digits] (number) Number of digits to pad to.  (Default is 2)
// @return (String) Padded string version of the number
//
// @example var str = isc.NumberUtil.stringify(myNumberVar, 2);
// @group stringProcessing
// @visibility external
//<

stringify : function (number, totalDigits, predecimal) {
    if (!isc.isA.Number(number)) return "";


    return isc.NumberUtil._stringify(totalDigits, predecimal, number);
},

_stringify : function (totalDigits, predecimal, number, radix) {
    if (number == null) number = this;
    // default to 2 digits
    if (!totalDigits) totalDigits = 2;

    var numberString = (radix != null ? number.toString(radix) : number.toString()),
        zeroes = totalDigits - numberString.length;

    // predecimal: ignore any decimal digits, such that two numbers with differing decimal
    // precision get the same total number of characters before the decimal.
    if (predecimal) {
        var dotIndex = numberString.indexOf(isc.dot);
        if (dotIndex != -1) {
            zeroes += (numberString.length - dotIndex);
        }
    }
    var pad = isc.NumberUtil._getZeroString(zeroes);

    if (pad == null) return numberString;
    return pad + numberString;
},

//> @classMethod NumberUtil.isBetween()
// Returns true if the number parameter falls between the 'first' and 'second' parameters.
//
// @param number (number) Number object to be evaluated
// @param [first] (number) Number at the lower boundary
// @param [second] (number) Number at the upper boundary
// @param [inclusive] (number) Whether or not the numbers at either end of the boundary should be included in the comparison
// @return (Boolean) True if the given <code>number</code> falls inside the given range, false otherwise
//
// @example n = 3; bool = n.isBetween(3, 3, 6, true); // true
// @group stringProcessing
// @visibility external
//<
isBetween : function (number, first, second, inclusive) {
    if (!isc.isA.Number(number)) return false;


    return isc.NumberUtil._isBetween(first, second, inclusive, number);
},

_isBetween : function (first, second, inclusive, number) {

    if (number == null) number = this;

    var min = Math.min(first, second),
        max = Math.max(first, second);

    if (inclusive) {
        return min <= number && number <= max;
    } else {
        return min < number && number < max;
    }
},

//> @classMethod NumberUtil.clamp()
// Returns a clamped number between a min and max.
// <p>
// <smartclient>
// <pre>
// var clamped = isc.NumberUtil.clamp(10, 0, 5); // Returns 5 because 10 is greater than 5
// var clamped = isc.NumberUtil.clamp(-3, 0, 5); // Returns 0 because -3 is less than 0
// var clamped = isc.NumberUtil.clamp(4, 0, 5); // Returns 4 because 4 is between 0 and 5
// </pre>
// </smartclient>
// <smartgwt>
// <pre>
// int clamped = NumberUtil.clamp(10, 0, 5); // Returns 5 because 10 is greater than 5
// int clamped = NumberUtil.clamp(-3, 0, 5); // Returns 0 because -3 is less than 0
// int clamped = NumberUtil.clamp(4, 0, 5); // Returns 4 because 4 is between 0 and 5
// </pre>
// </smartgwt>
// @param number (Number) the number to clamp
// @param min (Number) the number to return if the number is lower than min
// @param max (Number) the number to return if the number is higher than max
// @return (Number) the clamped number
//
// @visibility external
//<
clamp : function (number, min, max) {
    return Math.min(Math.max(number, min), max);
},

//> @classMethod NumberUtil.toCurrencyString()
// Return the passed number as a currency-formatted string, or an empty string if not passed a
// number.
//
// @param number (Number) the number to convert
// @param [currencyChar] (String) Currency symbol, default taken from the locale and can be
//                                set to an empty string. If not passed and missing from the
//                                locale, defaults to <code>"$"</code>.
// @param [decimalChar] (String) Decimal separator symbol, default taken from the locale. If
//                                if not passed and missing from the locale, defaults to
//                                <code>"."</code>.
// @param [padDecimal] (boolean) Should decimal portion be padded out to two digits? True
//                               by default.
// @param [currencyCharLast] (boolean) Should the currency symbol be shown at the end of the
//                                      string?  If unspecified, it will prefix the number.
// @return (String) Currency-formatted string version of the number
// @group stringProcessing
// @visibility external
//<
toCurrencyString : function (number, currencyChar, decimalChar, padDecimal, currencyCharLast) {
    if (!isc.isA.Number(number)) return "";


    return isc.NumberUtil._toCurrencyString(currencyChar, decimalChar, padDecimal, currencyCharLast, number)
},

_toCurrencyString : function (currencyChar, decimalChar, padDecimal, currencyCharLast, number) {
    if (number == null) number = this;

    var negative = number < 0,
        wholeNumber = number < 0 ? Math.ceil(number) : Math.floor(number),
        decimalNumber = Math.abs(Math.round((number - wholeNumber)*100)),
        output = isc.StringBuffer.create();

    wholeNumber = Math.abs(wholeNumber);

    // default currency/decimal symbols and decimal padding on
    // allow empty string for no currency character
    currencyChar = currencyChar || isc.NumberUtil.currencySymbol || "$";
    decimalChar = decimalChar || isc.NumberUtil.decimalSymbol || ".";
    if (padDecimal == null) padDecimal = true;

    // output sign

    if (negative) output.append(isc.NumberUtil.negativeSymbol || "-");

    // output currency symbol first by default
    if (currencyCharLast != true) output.append(currencyChar);

    // output whole number
    output.append(wholeNumber.stringify(1));

    // output decimal symbol and decimal number
    // (unless padding is off and decimal portion is 0)
    if (padDecimal) {
        output.append(decimalChar);
        output.append(decimalNumber.stringify(2));
    } else if (decimalNumber != 0) {
        output.append(decimalChar);
        if (decimalNumber % 10 == 0) output.append(decimalNumber/10);
        else output.append(decimalNumber.stringify(2));
    }

    // output currency symbol last if specified
    if (currencyCharLast == true) output.append(currencyChar);

    return output.release(false);
},

//> @classMethod NumberUtil.toLocalizedString()
//  Format the passed number for readability, with:
//  <ul>
//      <li>separators between three-digit groups</li>
//      <li>optional fixed decimal precision (so decimal points align on right-aligned numbers)</li>
//      <li>localized decimal, grouping, and negative symbols</li>
//  </ul>
//  +link{NumberUtil.decimalSymbol, Decimal symbol},
//  +link{NumberUtil.groupingSymbol, grouping symbol}, and
//  +link{NumberUtil.negativeSymbol, negative symbol} will normally come from
//  SmartClient locale settings (which may come from either client OS or application locale
//  settings), but they are also supported as arguments for mixed-format applications
//  (eg normalize all currency to +link{NumberUtil.toUSCurrencyString, US format}, but use the
// current locale format for other numbers).
//
//  @param number (Number) the number object to convert
//  @param [decimalPrecision] (number) decimal-precision for the formatted value
//  @param [decimalSymbol] (String) the symbol that appears before the decimal part of the number
//  @param [groupingSymbol] (String) the symbol shown between groups of 3 non-decimal digits
//  @param [negativeSymbol] (String) the symbol that indicate a negative number
//  @return (String) formatted number or empty string if not passed a number.
//  @visibility external
//<

toLocalizedString : function (
        number, decimalPrecision, decimalSymbol, groupingSymbol, negativeSymbol, minInteger,
        maxFraction, minPrecision, maxPrecision)
{
    if (!isc.isA.Number(number)) return "";

    var negative = (number < 0),
        wholeString = null,
        decimalString = null;
    if (negative) {
        number = -number;
    }


    var bySignificantDigits = (minPrecision != null || maxPrecision != null),
        minFraction = 0;
    if (bySignificantDigits) {
        // `minPrecision` must be an integer between 1 and 21.
        minPrecision = Math.max(1, Math.min(21, minPrecision || 0));
        // `maxPrecision` must be an integer between `minPrecision` and 21.
        maxPrecision = Math.max(minPrecision, Math.min(21, maxPrecision || 0));
    } else {
        // `minInteger` must be an integer between 1 and 21.
        minInteger = Math.max(1, Math.min(21, minInteger || 0));
        // `minFraction` must be an integer between 0 and 20.
        minFraction = Math.max(0, Math.min(20, decimalPrecision || 0));
        // `maxFraction` must be an integer between `minFraction` and 20.
        maxFraction = Math.max(minFraction, Math.min(20, maxFraction || 0));
    }
    var zeroStr = isc.NumberUtil._getZeroString(1);
    if (bySignificantDigits) {
        var p = maxPrecision, e = 0, m;

        if (number == 0) {
            e = 0;
            m = isc.NumberUtil._getZeroString(p);
            if (e == p - 1) {
                wholeString = m;
            }
        } else {

            e = Math.floor(Math.log(number) / Math.LN10);
            var n = 0;
            if (e < p) {
                n = Math.round(number * Math.pow(10, -(e - p + 1)));
            } else {
                n = Math.round(number / Math.pow(10, e - p + 1));
            }
            if (n == Math.pow(10, p)) {
                ++e;
                n /= 10;
            }

            if (e >= p) {

                wholeString = (
                    isc.NumberUtil._toFixed(n) + isc.NumberUtil._getZeroString(e - p + 1));
            } else if (e == p - 1) {
                wholeString = isc.NumberUtil._toFixed(n);
            } else {
                m = isc.NumberUtil._toFixed(n);
            }
        }

        if (wholeString == null) {
            if (e >= 0) {
                wholeString = m.substr(0, e + 1);
                decimalString = m.substr(e + 1, p - (e + 1));
            } else {
                wholeString = zeroStr;
                decimalString = isc.NumberUtil._getZeroString(-(e + 1)) + m;
            }

            var cut0 = maxPrecision - minPrecision,
                cut = cut0;
            while (cut > 0) {
                if (decimalString.charAt(p - (e + 1) - 1 - (cut0 - cut)) == zeroStr) {
                    --cut;
                } else {
                    break;
                }
            }
            if (p - (e + 1) == cut0 - cut) {
                decimalString = null;
            } else {
                decimalString = decimalString.substr(0, p - (e + 1) - (cut0 - cut));
            }
        }
    } else {
        var f = maxFraction,
            n = Math.round(number * Math.pow(10, f)),
            m = (n == 0 ? zeroStr : isc.NumberUtil._toFixed(n)),
            l = 0;
        if (f > 0) {
            var k = m.length;
            if (k <= f) {
                m = isc.NumberUtil._getZeroString(f + 1 - k) + m;
                k = f + 1;
            }
            wholeString = m.substr(0, k - f);
            decimalString = m.substr(k - f, f);
            l = k - f;

            var cut0 = maxFraction - minFraction,
                cut = cut0;
            while (cut > 0) {
                if (decimalString.charAt(f - 1 - (cut0 - cut)) == zeroStr) {
                    --cut;
                } else {
                    break;
                }
            }
            if (f == cut0 - cut) {
                decimalString = null;
            } else {
                decimalString = decimalString.substr(0, f - (cut0 - cut));
            }
        } else {
            wholeString = m;
            l = m.length;
        }
        if (l < minInteger) {
            wholeString = isc.NumberUtil._getZeroString(minInteger - l) + wholeString;
        }
    }

    var wholeLength = wholeString.length,
        r = wholeLength % 3,
        // `tripletCount` is the number of complete chunks of 3 digits.
        tripletCount = (wholeLength - r) / 3,
        beforeTripletLength = (negative ? 1 : 0) + (r != 0 ? 1 : 0),
        numGroupSymbols = (r != 0 ? 1 : 0) + tripletCount - 1,
        templateLength = (
            beforeTripletLength +
            numGroupSymbols +
            tripletCount +
            (decimalString != null ? 2 : 0)),
        template = new Array(templateLength);

    var k = 0;
    if (negative) {
        template[k++] = (negativeSymbol || isc.NumberUtil.negativeSymbol);
    }

    // Whole part - slice it into chunks joined with grouping symbols.
    groupingSymbol = groupingSymbol || isc.NumberUtil.groupingSymbol;
    var notFirstGroup = false;
    if (r != 0) {
        // Start with the incomplete chunk (first 1 or 2 digits), if any, ...
        template[k++] = wholeString.substr(0, r);
        notFirstGroup = true;
    }
    for (var i = 0, j = r; i < tripletCount; ++i, j += 3, notFirstGroup = true) {
        if (notFirstGroup) {
            template[k++] = groupingSymbol;
        }
        // ... then slice out each chunk of 3 digits.
        template[k++] = wholeString.substr(j, 3);
    }

    // Append the decimal part.
    if (decimalString != null) {
        template[k++] = (decimalSymbol || isc.NumberUtil.decimalSymbol);
        template[k] = decimalString;
    }

    // Assembly - join the chunks of the whole part with grouping symbols, and glue together
    // the whole part, decimal symbol, decimal part, and negative sign as appropriate.
    return template.join("");
},

_toFixed : function (n) {

    var nStr = n.toFixed(),
        k = nStr.lastIndexOf("e");
    if (k == -1) {
        return nStr;
    } else {

        var lastPow = parseInt(nStr.substr(k + 1), 10),
            numDigits = 1 + lastPow,
            str = "",
            sum = 0;
        do {
            var digit = parseInt(nStr, 10),
                pow = parseInt(nStr.substr(k + 1), 10);
            if (lastPow > pow + 1) {
                str = str + isc.NumberUtil._getZeroString(lastPow - pow - 1) + digit;
            } else {
                str = str + digit;
            }
            sum += digit * Math.pow(10, pow);
            nStr = (n - sum).toFixed();
            k = nStr.lastIndexOf("e");
            lastPow = pow;
        } while (k != -1);

        var l = numDigits - str.length - nStr.length;
        if (l > 0) {
            return str + isc.NumberUtil._getZeroString(l) + nStr;
        } else {
            return str + nStr;
        }
    }
},

// Internal helper that converts a number `numBytes' (representing a byte count) to a localized
// string. When `otherNumBytes' is different, the formatted string is distinguished from
// `toMiBString(otherNumBytes, numBytes)' by inclusion of as many digits of precision as are
// necessary to differentiate the two byte counts, up to 20 digits of precision.
toMiBString : function (numBytes, otherNumBytes) {

    // If the two byte counts are more than 0.16 MiB apart, then one digit of precision is
    // sufficient.
    if (Math.abs(numBytes - otherNumBytes) > 167773) {
        return Math.round(numBytes / 104857.6) / 10;
    }

    var numMiB = numBytes / 1048576,
        mib;
    if (numBytes == otherNumBytes) {
        mib = isc.NumberUtil.toLocalizedString(numMiB, 20);
        var periodPos = mib.search(/[^\d]/);
        if (periodPos >= 0 && mib.length >= periodPos + 20) {
            for (var j = 1; j <= 20; ++j) {
                var c = mib.charCodeAt(periodPos + j);
                if (49 <= c && c <= 57) {
                    return isc.NumberUtil.toLocalizedString(numMiB, j);
                }
            }
        }
        return mib;

    } else {
        var otherNumMiB = otherNumBytes / 1048576,
            otherMiB;
        for (var j = 1; j <= 20; ++j) {
            mib = isc.NumberUtil.toLocalizedString(numMiB, j);
            otherMiB = isc.NumberUtil.toLocalizedString(otherNumMiB, j);

            // If, when `numMiB' and `otherNumMiB' are converted to strings (`mib' and `otherMiB',
            // respectively), they are different strings and `mib' is not a whole number with
            // decimal point and all trailing zeroes, then return `mib'.
            //
            // The trailing zeroes test is meant to prevent strings like:
            // "Size of 'uploaded-file' (0.01 MiB) exceeds maximum allowed file size of 0.00 MiB."
            // .. which makes it seem like the maximum file size is 0 MiB.
            if (mib !== otherMiB && !/[^\d]0+$/.test(mib)) return mib;
        }
        return mib;
    }
},

// same as toLocalizedString but handles extra zeroes using decimalPrecision and decimalPad values
floatValueToLocalizedString : function (number, decimalPrecision, decimalPad, stripGroupingSymbols) {
    if (!isc.isA.Number(number)) return "";
    if (decimalPad == null) decimalPad = 0;
    // default decimalPrecision for float is 2
    if (decimalPrecision == null) {
        // if passed a null decimalPrecision, stringify the passed "number" and use its
        // precision, if any, by default - always detect ".", not the localized decimalSymbol
        var vStr = "" + number;
        var index = vStr.indexOf(isc.NumberUtil._jsDecimalSymbol);
        // precision is the string-length of everything after the decimalSymbol, if any
        if (index >= 0) decimalPrecision = vStr.length - (index+1);
        // otherwise, use the legacy default of 2
        else decimalPrecision = 2;
    }
    var res = isc.NumberUtil.toLocalizedString(number, decimalPrecision);
    // when editing a localized float, we don't want to include groupingSymbols in the string
    if (stripGroupingSymbols) res = res.replaceAll(isc.NumberUtil.groupingSymbol, "");
    var decIndx = res.indexOf(isc.NumberUtil.decimalSymbol);
    var zerosToAdd = 0;
    if (decIndx < 0) {
        if (decimalPad == 0) return res;
        zerosToAdd = decimalPad;
        // no decimalSymbol were found, so we adding one
        res += isc.NumberUtil.decimalSymbol;
    } else {
        zerosToAdd = decimalPad - (res.length - decIndx - 1);
    }
    if (zerosToAdd > 0) {
        // add zeroes to the end according decimalPad value
        res += new Array(zerosToAdd + 1).join('0');
    } else if (zerosToAdd < 0) {
        // all extra zeroes should be removed
        for (var i = (res.length - 1); i>(decIndx + decimalPad); i--) {
            if (res.charAt(i) != '0' && res.charAt(i) != isc.NumberUtil.decimalSymbol) break;
        }
        // remove decimalSymbol if is the last one
        if (res.charAt(i) == isc.NumberUtil.decimalSymbol) i--;
        res = res.substr(0, i + 1);
    }
    return res;
},

//> @classMethod NumberUtil.toUSString()
//  Format the passed number as a US string.  Returns empty string if not passed a number.
//
//  @param number (Number) the number object to format
//  @param [decimalPrecision] (number)
//  @return (String) formatted number or empty string if not passed a number
//  @visibility external
//<
toUSString : function (
    number, decimalPrecision, minInteger, maxFraction, minPrecision, maxPrecision)
{
    return isc.NumberUtil.toLocalizedString(
        number, decimalPrecision, ".", ",", "-",
        minInteger, maxFraction, minPrecision, maxPrecision);
},

//> @classMethod NumberUtil.toUSCurrencyString()
//  Format the passed number as a US Dollar currency string. Returns empty string if not passed
// a number.
//
//  @param number (Number) the number object to format
//  @param [decimalPrecision] (number)
//  @return (String) formatted number
//  @visibility external
//<
toUSCurrencyString : function(number, decimalPrecision) {
    if (!isc.isA.Number(number)) return "";
    var util = isc.NumberUtil;
    return "$" + util.toLocalizedString(number, decimalPrecision, ".", ",", "-");
},

_toUSPercentString : function (
    number, minInteger, minFraction, maxFraction, minPrecision, maxPrecision)
{
    if (!isc.isA.Number(number)) {
        return "";
    } else {
        return (isc.NumberUtil.toLocalizedString(
            100 * number, minFraction, ".", ",", "-",
            minInteger, maxFraction, minPrecision, maxPrecision) + "%");
    }
},

//> @method NumberUtil.iscToLocaleString()
// Customizeable version of the <code>toLocaleString()</code> method for numbers.
// Called by <code>isc.iscToLocaleString()</code>.
// Uses the formatter set by NumberUtil.setStandardLocaleStringFormatter(), or at the instance
// level by NumberUtil.setLocaleStringFormatter()
//
// @param number (Number) the number to format
// @return (String) formatted number as a string
//
// @group stringProcessing
//<
iscToLocaleString : function (number) {
    var f = isc.NumberUtil.localeStringFormatter;
    //var method = Number[f] || isc.NumberUtil[f];
    var method = isc.isA.Function(f) ? f : isc.NumberUtil[f];
    return method ? method(number) : number.toString();
},

//> @method NumberUtil.toFormattedString()
// Allow use of a custom number formatter - can be passed in as a parameter, or set by
// NumberUtil.setStandardFormatter()
//
// @param number (Number) the number to format
// @param [formatter] (String) name of a Number function to use
// @return (String) formatted number as a string
//
// @group stringProcessing
//<

toFormattedString : function (number, formatter) {
    var f = formatter || isc.NumberUtil.formatter;
    var method = isc.isA.Function(f) ? f : isc.NumberUtil[f];
    return method ? method(number) : number.toString();
},

//> @classMethod NumberUtil.parseInt()
// Parse string that contains integer number. This method correctly handles locale based
// separators and currency symbol.
//
// @param string (String) the string to parse
// @return (Number) parsed number as a Number
// @visibility external
//
//<

parseInt : function (string, ignoreLocale) {
    if (isc.isA.String(string)) {

        var groupingSymbol = ignoreLocale ? "," : this.groupingSymbol,
            currencySymbol = ignoreLocale ? "$" : this.currencySymbol
        ;
        string = string.replace(
            new RegExp("[" + groupingSymbol + "|"  + currencySymbol + "]", "g"), ""
        );
    }
    return parseInt(string);
},

//> @classMethod NumberUtil.parseFloat()
// Parse string that contains float number. This method correctly handles locale based
// separators, decimal points and currency symbol.
//
// @param string (String) the string to parse
// @return (float) parsed number as a Number
// @visibility external
//<
parseFloat : function (string, ignoreLocale) {
    if (isc.isA.String(string)) {

        var decimalSymbol = ignoreLocale ? "." : this.decimalSymbol,
            groupingSymbol = ignoreLocale ? "," : this.groupingSymbol,
            currencySymbol = ignoreLocale ? "$" : this.currencySymbol
        ;
        string = string.replace(new RegExp("[" + groupingSymbol + "|"  +
                                           currencySymbol + "]", "g"), "");
        if (decimalSymbol != ".") {
            string = string.replace(new RegExp("[" + decimalSymbol + "]", "g"), ".");
        }
    }
    return parseFloat(string);
},

parseLocaleFloat : function (string, decimalSymbol, groupingSymbol) {
    if (string == null) return Number.NaN;
    if (!isc.isA.String(string)) {

        if (isNaN(string)) return Number.NaN;
        else return parseFloat(string);
    }
    if (!decimalSymbol) decimalSymbol = isc.NumberUtil.decimalSymbol;
    if (!groupingSymbol) groupingSymbol = isc.NumberUtil.groupingSymbol;
    var numberString = "";
    var lastGroupingSymbolIndex = -1;
    var decimalSymbolFound = false;
    var isPositiveNumber = true;
    // user could use grouping symbol in number or not, if he used we should check that every
    // three symbols are followed by one grouping symbol
    var groupingSymbolUsed = string.contains(groupingSymbol);
    for (var i = 0; i < string.length; i++) {
        if (i == 0) {
            if (string.charAt(i) == "-") {
                isPositiveNumber = false;
                continue;
            } else if (string.charAt(i) == "+") {
                continue;
            }
        }
        // no grouping symbols should be found after decimal symbol found
        var mustBeGroupingSymbol = !decimalSymbolFound && groupingSymbolUsed;
        if (mustBeGroupingSymbol) {
            if (lastGroupingSymbolIndex != -1) {
                // grouping symbol should be after every three letters in the line
                mustBeGroupingSymbol = (i - lastGroupingSymbolIndex) == 4;
            } else {
                // first should be on third position or less
                mustBeGroupingSymbol = (i == 3) || (string.charAt(i) == groupingSymbol);
            }
        }
        if (string.charAt(i) == groupingSymbol) {
            if (!mustBeGroupingSymbol) {
                return Number.NaN;
            }
            lastGroupingSymbolIndex = i;
            continue;
        } else if (mustBeGroupingSymbol && string.charAt(i) != decimalSymbol) {
            return Number.NaN;
        } else if (string.charAt(i) == decimalSymbol) {
            if (decimalSymbolFound) return Number.NaN;
            if (groupingSymbolUsed && (i - lastGroupingSymbolIndex) != 4) return Number.NaN;
            decimalSymbolFound = true;
            numberString += ".";
            continue;
        }
        // Number should not contain any other non-digit symbols
        if (string.charAt(i) < "0" || string.charAt(i) > "9") return Number.NaN;
        numberString += string[i];
    }
    if (!decimalSymbolFound && groupingSymbolUsed && ((i - lastGroupingSymbolIndex) != 4)) {
        return Number.NaN;
    }
    return isPositiveNumber? parseFloat(numberString) : -parseFloat(numberString);
},

parseLocaleInt : function (string, groupingSymbol) {
    if (string == null) return Number.NaN;
    if (!groupingSymbol) groupingSymbol = isc.NumberUtil.groupingSymbol;
    var numberString = "";
    var lastGroupingSymbolIndex = -1;
    var isPositiveNumber = true;
    var groupingSymbolUsed = string.contains(groupingSymbol);
    for (var i = 0; i < string.length; i++) {
        if (i == 0) {
            if (string.charAt(i) == "-") {
                isPositiveNumber = false;
                continue;
            } else if (string.charAt(i) == "+") {
                continue;
            }
        }
        // no grouping symbols should be found after decimal symbol found
        var mustBeGroupingSymbol = groupingSymbolUsed;
        if (mustBeGroupingSymbol) {
            if (lastGroupingSymbolIndex != -1) {
                // grouping symbol should be after every three letters in the line
                mustBeGroupingSymbol = (i - lastGroupingSymbolIndex) == 4;
            } else {
                // first should be on third position or less
                mustBeGroupingSymbol = (i == 3) || (string.charAt(i) == groupingSymbol);
            }
        }
        if (string.charAt(i) == groupingSymbol) {
            if (!mustBeGroupingSymbol) {
                return Number.NaN;
            }
            lastGroupingSymbolIndex = i;
            continue;
        } else if (mustBeGroupingSymbol) {
            return Number.NaN;
        }
        // Number should not contain any other non-digit symbols
        if (string.charAt(i) < "0" || string.charAt(i) > "9") return Number.NaN;
        numberString += string[i];
    }
    if (groupingSymbolUsed && ((i - lastGroupingSymbolIndex) != 4)) {
        return Number.NaN;
    }

    return isPositiveNumber? parseInt(numberString) : -parseInt(numberString);
},

parseLocaleCurrency : function (string, currencySymbol, decimalSymbol, groupingSymbol) {
    if (string == null) return Number.NaN;
    if (!currencySymbol) currencySymbol = isc.NumberUtil.currencySymbol;
    // correct input could be CHF1.227,33 and 1.227,33CHF (symbol could contain several letters)
    if (string.startsWith(currencySymbol)) {
        string = string.substring(currencySymbol.length);
    } else if (string.endsWith(currencySymbol)) {
        string = string.substring(0, string.length - currencySymbol.length);
    }
    return this.parseLocaleFloat(string);
},

//> @classMethod NumberUtil.parseIfNumeric()
//
// If given a numeric string (that is, a non-empty string which converts to a
// number), will return the equivalent integer. Otherwise, returns the
// parameter unchanged. Useful for dealing with values that can be numbers or
// strings, but which you want to coerce to a numeric type if possible.
//
// @param numberOrString (Any) the string or number to parse
// @return (Any) an integer, if possible, otherwise the input unchanged
// @visibility external
//<
// Used for dealing with heights and widths. They can be numbers or strings
// (e.g. "50%" or "*"), and thus are deserialized as strings. But we
// sometimes want to know whether it's "really" a string, or instead a
// "numeric string" like "100".
parseIfNumeric : function (numberOrString) {
    if (isc.isA.Number(numberOrString)) {
        return numberOrString;
    } else if (isc.isA.nonemptyString(numberOrString)) {
        // Note that we want to return strings with trailing characters (like
        // "100%") unchanged, even though parseInt would produce an integer
        // from them. To check for that, isNaN is probably faster than a
        // regexp.
        if (isNaN(numberOrString)) {
            return numberOrString;
        } else {
            return parseInt(numberOrString, 10);
        }
    } else {
        // If it's neither Number nor String, or an empty String, just return
        // it. An empty string could be parsed to 0, but that's not necessarily
        // what was meant.
        return numberOrString;
    }
},

//>    @classMethod    NumberUtil.format()
// Return the parameter number formatted according to the parameter +link{type:FormatString}.
// This method is used to implement the +link{DataSourceField.format} functionality, but it can
// also be used to format arbitrary numbers programmatically.
// @param  number  (Number) The number to format
// @param  format  (FormatString) The format to apply
// @return (String) formatted number string
// @visibility external
//<
format : function(number, pformat) {

    if (!isc.isA.Number(number)) {
        this.logWarn("Cannot format '" + number + "' - not a Number");
        return number;
    }

    if (!isc.isA.String(pformat)) {
        this.logWarn("Cannot use format '" + pformat + "' - not a String");
        return number;
    }

    if (pformat == "") {
        return number.toString();
    }

    var format = pformat + "",
        n = number + 0,
        neg = n < 0,
        abs = Math.abs(number),
        negFormat,
        parts = abs.toString().split('.'),
        intPart = parts[0],
        decPart = parts[1],
        formatParts = format.match(/^([^']|'[^']*')*?(?=;)/);

    if (neg) {
        if (formatParts) {
            format = negFormat = format.substring(formatParts[0].length + 1);
        }
    } else {
        format = formatParts == null ? format : formatParts[0];
    }

    var quote = format.indexOf("'"),
        literals = [],
        positions = [];
    while (quote != -1) {
        var start = quote,
            end = format.indexOf("'", start+1);
        if (end == -1) {
            var error = "Invalid format string \"" + pformat + "\" - contains " +
                            "mismatched quotes"
            this.logWarn(error);
            return error;
        }
        var literal = format.substring(start+1, end);
        if (literal === "") literal = "'";
        literals.push(literal);
        positions.push(start);
        format = format.substring(0, start) + format.substring(end+1);
        quote = format.indexOf("'");
    }

    var grouping = format.indexOf(",");
    if (grouping > -1) {
        format = format.replace(/,/g, '');
    }

    var zeroesStart = format.indexOf("0"),
        poundsStart = format.indexOf("#"),
        decimalPos = format.indexOf("."),
        numberStarts = Math.min(zeroesStart == -1 ? 999 : zeroesStart,
                                poundsStart == -1 ? 999 : poundsStart,
                                decimalPos == -1 ? 999 : decimalPos),
        numberEnds = format.length-1,
        percent = false,
        permil = false,
        zeroes = 0;

    for (var i = format.length-1; i > numberStarts; i--) {
        var ch = format.charAt(i);
        if (ch == '0' || ch == '#' || ch == '.') break;
        if (ch == '%') percent = true;
        if (ch == '\u2030') permil = true;
        numberEnds--;
    }

    if (numberStarts == 999 || numberEnds < 0 || numberStarts > numberEnds) {
        // This matches the (somewhat arbitrary-seeming) Java DecimalFormat behavior
        parts = Math.abs(n).toString().split('.');
        intPart = parts[0];
        decPart = "";
        var prefix = format;
        if (positions) {
            for (var i = positions.length-1; i >= 0; i--) {
                prefix = prefix.substring(0, positions[i]) + literals[i] + prefix.substring(positions[i]);
            }
        }
        if (neg && !negFormat) prefix = "-" + prefix;
        var suffix = "",
            dPoint = "";
    } else {

        if (zeroesStart != -1 && poundsStart != -1 && decimalPos != -1) {
            if (zeroesStart < poundsStart && poundsStart < decimalPos) {
                var error = "Invalid format string \"" + pformat + "\" - cannot specify '0' to the " +
                                "left of '#' in the integer part"
                this.logWarn(error);
                return error;
            }
        }

        var curr = format.indexOf("\u00a4");
        while (curr != -1) {
            format = format.substring(0, curr) + isc.NumberUtil.currencySymbol + format.substring(curr+1);
            curr = format.indexOf("\u00a4");
        }

        var prefix = format.substring(0, numberStarts);
        var suffix = format.substring(numberEnds+1);
        for (var i = positions.length-1; i >= 0; i--) {
            if (positions[i] > numberStarts && positions[i] < numberEnds) {
                this.logWarn("Format string \"" + pformat + "\" contains quoted characters within " +
                                "the actual number area - these will be ignored");
            } else if (positions[i] <= numberStarts) {
                prefix = prefix.substring(0, positions[i]) + literals[i] + prefix.substring(positions[i]);
            } else {
                positions[i] -= (numberEnds+1);
                suffix = suffix.substring(0, positions[i]) + literals[i] + suffix.substring(positions[i]);
            }
        }

        if (zeroesStart != -1 && (decimalPos == -1 || zeroesStart < decimalPos)) {
            zeroes = (decimalPos == -1 ? numberEnds+1 : decimalPos) - zeroesStart;
        }


        if (percent) {

            n = (n * 1000000)/10000;
            //this.logWarn("number is " + number + " result is " + n);
        } else if (permil) n = n * 1000;

        var precision = "";
        if (decimalPos != -1) precision = format.substring(decimalPos+1, numberEnds+1);

        n = this._roundDecimalForFormatting(n, precision.length, decPart ? decPart.length : 0);
        parts = Math.abs(n).toString().split('.');
        intPart = parts[0];
        decPart = parts[1] || "";
        if (decPart.length < precision.length) {
            var c = decPart.length;
            while (precision[c] === "0" && c++ < precision.length) decPart += "0";
        }

        if (intPart == "0") {
            intPart = "0000000000000000000000000000000000000000".substring(0, zeroes);
        } else if (zeroes > intPart.length) {
            intPart = "0000000000000000000000000000000000000000".substring(intPart.length, zeroes) + intPart;
        }

        if (grouping > -1) {
            intPart = intPart.replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1' + isc.NumberUtil.groupingSymbol);
        }

        if (neg && !negFormat) {
            // No explicit format provided for negative numbers, so just prepend a minus sign to
            // the positive-formatted number
            prefix = prefix ? "-" + prefix : "-";
        }

        var dPoint = decPart && decPart.length > 0 ? isc.NumberUtil.decimalSymbol : "";
    }

    return prefix + intPart + dPoint + decPart + suffix;
},

useAccurateRounding: false,

_roundDecimalForFormatting : function(number, targetPrecision, numberPrecision) {
    // NOTE: native toFixed() rounds unpredictably on exact 0.5, 0.05, etc, boundaries, because
    // of inaccuracies introduced by the floating-point format.  So we don't use it...
    if (numberPrecision <= targetPrecision) return number;

    // Use the absolute value of negative numbers, to force it to round away from zero like
    // both DecimalFormat and Excel do
    var neg = number < 0;
    if (neg) number = 0 - number;


    var ori = number;
    var m = Math.pow(10, targetPrecision);
    number = number * m;
    if (isc.NumberUtil.useAccurateRounding) {
        var e = Math.pow(10, numberPrecision * -1);
        number += e;
    }
    number = Math.round(number)
    number = number / m;



    return neg ? 0 - number : number;
}

});

// NOTE: toString functions CANNOT be added by addMethods, because a property named "toString"
// will not be enumerated by for..in.  This is actually part of the ECMAScript standard!

isc.NumberUtil.toString = function (number) {
    if (number == null) return "";
    if (isc.isA.Class(number)) return number.valueOf().toString();
    return number.toString();
};

// set the standard formatter for the date prototype to the native browser string
// so 'toFormattedString()' defaults to returning the standard number format string
if (!isc.NumberUtil.formatter) isc.NumberUtil.formatter = "toString";


if (!isc.NumberUtil.localeStringFormatter)
    isc.NumberUtil.localeStringFormatter = "toString";

/*
    Isomorphic SmartClient web presentation layer
    Copyright 2000 and beyond Isomorphic Software, Inc.

    OWNERSHIP NOTICE
    Isomorphic Software owns and reserves all rights not expressly granted in this source code,
    including all intellectual property rights to the structure, sequence, and format of this code
    and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.

    CONFIDENTIALITY NOTICE
    The contents of this file are confidential and protected by non-disclosure agreement:
      * You may not expose this file to any person who is not bound by the same obligations.
      * You may not expose or send this file unencrypted on a public network.

    SUPPORTED INTERFACES
    Most interfaces expressed in this source code are internal and unsupported. Isomorphic supports
    only the documented behaviors of properties and methods that are marked "@visibility external"
    in this code. All other interfaces may be changed or removed without notice. The implementation
    of any supported interface may also be changed without notice.

    If you have any questions, please email <sourcecode@isomorphic.com>.

    This entire comment must accompany any portion of Isomorphic Software source code that is
    copied or moved from this file.
*/



  //>DEBUG
// This lets us label methods with a name within addMethods
Number.prototype.Class = "Number";
  //<DEBUG


//> @object Number
// Extra methods added to the Number object, available on all number variables.  Attributes,
// parameters, or return values declared as <code>Number</code> may be null.
// @treeLocation Client Reference/System
// @see type:Integer
// @see type:Double
// @see type:Float
// @visibility external
//<

isc.addMethods(Number, {
setStandardFormatter : function (functionName) {
    isc.NumberUtil.setStandardFormatter(functionName);
},
setStandardLocaleStringFormatter : function (functionName) {
    isc.NumberUtil.setStandardLocaleStringFormatter(functionName);
}
});

// Polyfill Number.isNaN for Internet Explorer

if (Number.isNaN == null) {
Number.isNaN = function(value) {
    return value !== null && isNaN(value) && (typeof value == "number");
}
}



//> @type Integer
// A whole number, for example, 5.  Decimal numbers, for example 5.5, are not allowed.  Null is
// allowed.
// @treeLocation Client Reference/System
// @baseType Number
// @see type:int
// @see type:PositiveInteger
// @visibility external
//<

//> @type int
// A whole number, for example, 5.  Decimal numbers, for example 5.5, are not allowed.  May not
// be null.
// @treeLocation Client Reference/System
// @baseType Integer
// @visibility external
//<

//> @type PositiveInteger
// A positive whole number or 0, for example, 5.  Negative values are not allowed.  Null is
// allowed.
// @treeLocation Client Reference/System
// @baseType Integer
// @visibility external
//<

//> @type Float
// A decimal (or "floating point") number, for example, 5.5.  Null is allowed.
// @treeLocation Client Reference/System
// @baseType Number
// @see type:float
// @visibility external
//<

//> @type Double
// A decimal (or "floating point") number, for example, 5.5.  Null is allowed.
// @treeLocation Client Reference/System
// @baseType Number
// @see type:double
// @visibility external
//<

//> @type float
// A decimal (or "floating point") number, for example, 5.5.  May not be null.
// @treeLocation Client Reference/System
// @baseType Float
// @visibility external
//<

//> @type double
// A decimal (or "floating point") number, for example, 5.5.  May not be null.
// @treeLocation Client Reference/System
// @baseType Double
// @visibility external
//<

//
// add methods to all Numbers
//
isc.addMethods(Number.prototype, {
//> @method number.stringify()
//
// Return this number as a string padded out to digits length.
//
// @param [digits] (number : 2) Number of digits to pad to.  (Default is 2)
// @return (String) Padded string version of the number
//
// @example var str = myNumberVar.stringify(2);
// @group stringProcessing
// @visibility external
// @deprecated Moved to a static method on NumberUtil to avoid the possibility of collision
//              with other libraries on the native Number object
//<

stringify : isc.NumberUtil._stringify,

//> @method number.isBetween()
// Returns true if the number parameter falls between the 'first' and 'second' paramters.
//
// @param number (number) Number object to be evaluated
// @param [first] (number) Number at the lower boundary
// @param [second] (number) Number at the upper boundary
// @param [inclusive] (number) Whether or not the numbers at either end of the boundary should be included in the comparison
// @return (Boolean) True if the given <code>number</code> falls inside the given range, false otherwise
// @example n = 3; bool = n.isBetween(3, 3, 6, true); // true
// @example n = 3; bool = n.isBetween(3, 3, 6);       // false
// @visibility external
//<
isBetween : isc.NumberUtil._isBetween,

//> @method number.toCurrencyString()
// Return this number as a currency-formatted string.
//
// @param [currencyChar] (String) Currency symbol, can be set to an empty string.
//                                If unset <code>"$"</code> will be used.
// @param [decimalChar] (String) Decimal separator symbol. If unset <code>"."</code> will be used.
// @param [padDecimal] (boolean) Should decimal portion be padded out to two digits? True
//                               by default.
// @param [currencyCharLast] (boolean) Should currency symbol come at the end of the string?
//                                      If unspecified, currency symbol will be shown at the
//                                      beginning of the string.
// @return (String) Currency-formatted string version of the number
// @group stringProcessing
// @visibility external
// @deprecated Moved to a static method on NumberUtil to avoid the possibility of collision
//              with other libraries on the native Number object
//<

toCurrencyString : isc.NumberUtil._toCurrencyString

// NOTE:
// We don't provide 'setFormatter' or 'setStandardFormatter' instance methods for Numbers.
// This is because
// a) we don't want to confuse the issue of where formatters are stored (we have a pattern here
//    and on Dates of having standard formatters for all instances only)
// b) (at least in IE), numbers are not allocated as "true instances", so having a
//     number instance (var theVar = 2;) does not mean that you can set up properties on it,
//     such as theVar.formatter -- when you next refer to 'theVar', you are really given
//     another '2' instance, so your properties have been wiped out.

});

//
// add class-methods to the Number object
//  Moved to NumberUtil.js

isc.addProperties(Number.prototype, {

// doc and implementation moved to NumberUtil
iscToLocaleString : function () {
    var result = isc.NumberUtil.iscToLocaleString(this);
    return result;
},

// doc and implementation moved to NumberUtil
toFormattedString : function (formatter) {
    var result = isc.NumberUtil.toFormattedString(this, formatter)
    return result;
},

// doc and implementation moved to NumberUtil
toLocalizedString : function (decimalPrecision, decimalSymbol, groupingSymbol, negativeSymbol) {
    var result = isc.NumberUtil.toLocalizedString(this, decimalPrecision, decimalSymbol,
                groupingSymbol, negativeSymbol);
    return result;
},


toUSString : function(decimalPrecision) {
    var result = isc.NumberUtil.toUSString(this, decimalPrecision);
    return result;
},
toUSDollarString : function (decimalPrecision) {
    return isc.NumberUtil.toUSCurrencyString(this, decimalPrecision);
},
toUSCurrencyString : function(decimalPrecision) {
    var result = isc.NumberUtil.toUSCurrencyString(this, decimalPrecision);
    return result;
}

}); // end addProperties(Number.prototype) for localizable number formatter



isc.defineClass("Format");

isc.Format.addClassMethods({
    toUSString : function (theNum, decimalPrecision) {
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil.toUSString(theNum, decimalPrecision)
    },
    toUSCurrencyString : function (theNum, decimalPrecision) {
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil.toUSCurrencyString(theNum, decimalPrecision)
    },
    toUSDollarString : function (theNum, decimalPrecision) {
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil.toUSCurrencyString(theNum, decimalPrecision)
    },
    toCurrencyString : function (theNum, currencyChar, decimalChar,
                                 padDecimal, currencyCharLast) {
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil._toCurrencyString(currencyChar, decimalChar,
                                       padDecimal, currencyCharLast, theNum);
    }
});

// Instance of this class can hold numeric value of any size and precision.
isc.defineClass("BigDecimal");

isc.BigDecimal.addProperties({
    // RegExp to parse number. exec() result array values:
    // 0 - parsed value
    // 1 - sign
    // 2 - whole number (if entered witout fraction)
    // 3 - whole number (if entered with fraction)
    // 4 - fraction part (if entered with fraction)
    // 5 - exponent sing
    // 6 - exponent value
    // 7 - Infinity
    r : /^(?:(?:NaN|([+|-]?)(?:(?:(\d+)\.*|(\d*)\.(\d+))(?:[E|e]([+|-]?)(\d+))?|(Infinity))))$/,
    // Holds true if value is NaN
    // new BigDecimal starts as NaN
    nanValue: true,
    // Holds true if value is positive or negative Infinity
    infinityValue: false,
    // 1: "+"
    //-1: "-"
    sign: 1,
    // Holds significant digits of number:
    // for value 12.345: num="12345";
    // for value 607000: num="607";
    // for value 0.00809: num="809";
    num: "",
    // Holds exponent
    // realValue=num*10^exp
    exp: 0
});

isc.BigDecimal.addMethods({
    // Returns true if instance holds value which does not represent valid number.
    isNaN : function() {
        return this.nanValue;
    },
    // Returns true if instance holds Infinity (positive or negative).
    isInfinity : function() {
        return !this.nanValue && this.infinityValue;
    },
    // Returns 1 if holds positive value or -1 if holds negative value.
    getSign : function() {
        return (this.nanValue)?1:this.sign;
    },
    // Returns significant digits of number.
    getNum : function() {
        return (this.nanValue)?"0":this.num;
    },
    // Returns exponent
    getExp : function() {
        return (this.nanValue)?0:this.exp;
    },
    // Normalizes state of number: trims leading/trailing zeroes and adjusts exponent accordingly:
    // 00012300e2 becomes 123e4
    // Value is not changed - method changes only internal representation of the seam value.
    normalize : function() {
        if (this.nanValue) {
            // Reset all internals for NaN
            this.infinityValue = false;
            this.sign = 1;
            this.num = "";
            this.exp = 0;
        } else {
            if (this.infinityValue) {
                // Infinity does not have number representation - reset it
                this.num = "";
                this.exp = 0;
            } else {
                // Trim leading zeroes
                this.num = this.num.replace(/^0*/, "");
                // Trim trailing zeroes
                var trail = /0*$/.exec(this.num);
                if (trail) {
                    this.num = this.num.replace(/0*$/, "");
                    // Adjust exponent
                    this.exp += trail[0].length;
                }
                if (this.num === "") {
                    this.num = "0";
                    this.exp = 0;
                }
            }
        }
        return this;
    },
    toString : function() {
        return this.getStringValue();
    },
    // Returns value as a string.
    // If exponent parameter is true - return value in exponent representation
    getStringValue : function(exponent) {
        if (this.nanValue) {
            return "NaN";
        }
        if (this.infinityValue) {
            return (this.sign === 1?"":"-") + "Infinity";
        }
        if (exponent) {
            if (this.num.length === 1) {
                return (this.sign === 1?"":"-") + this.num + "e" + this.exp;
            }
            var res = this.num.substr(0, 1) + "." + this.num.substr(1);
            return (this.sign === 1?"":"-") + res + "e" + (this.exp + (this.num.length - 1));
        } else {
            var res = this.num;
            if (this.exp >= 0) {
                res += "0".repeat(this.exp);
            } else {
                if (res.length < Math.abs(this.exp) + 1) {
                    res = "0".repeat(Math.abs(this.exp) - res.length + 1) + res;
                }
                res = res.substr(0, res.length + this.exp) + "." + res.substr(res.length + this.exp);
            }
            return (this.sign === 1?"":"-") + res;
        }
    },
    // Returns value as Number
    // Loss of precision can occur.
    getNumberValue : function() {
        if (this.nanValue) {
            return NaN;
        } else if (this.infinityValue) {
            return Infinity * this.sign;
        } else {
            return new Number(this.getStringValue());
        }
    },
    // If THIS number is greater than parameter - return 1;
    // If THIS number equals to parameter - return 0;
    // If THIS number is less than parameter - return -1;
    // Special cases:
    //      if parameter can not be converted to number it is treated as zero;
    //      NaN treated as zero
    compareTo : function(number) {
        if (!(isc.isA.BigDecimal(number))) {
            number = isc.BigDecimal.create(number);
        }
        var thisNanValue = this.isNaN();
        var thisInfinityValue = this.isInfinity();
        var thisSign = this.getSign();
        var thisNum = this.getNum();
        var thisExp = this.getExp();
        var otherNanValue = number.isNaN();
        var otherInfinityValue = number.isInfinity();
        var otherSign = number.getSign();
        var otherNum = number.getNum();
        var otherExp = number.getExp();
        if (thisInfinityValue) {
            if (otherInfinityValue) {
                if (thisSign > otherSign) {
                    return 1;
                } else if (thisSign === otherSign) {
                    return 0;
                } else {
                    return -1;
                }
            } else {
                if (thisSign > 0) {
                    return 1;
                } else {
                    return -1;
                }
            }
        }
        if (otherInfinityValue) {
            if (otherSign < 0) {
                return 1;
            } else {
                return -1;
            }
        }
        if (thisExp > otherExp) {
            thisNum += "0".repeat(thisExp - otherExp);
        } else {
            otherNum += "0".repeat(otherExp - thisExp);
        }
        if (thisNum.length > otherNum.length) {
            otherNum = "0".repeat(thisNum.length - otherNum.length) + otherNum;
        } else {
            thisNum = "0".repeat(otherNum.length - thisNum.length) + thisNum;
        }
        if (thisNum > otherNum) {
            if (thisSign > otherSign) {
                return 1;
            } else if (thisSign === otherSign) {
                return 1;
            } else {
                return -1;
            }
        } else if (thisNum === otherNum) {
            if (thisSign > otherSign) {
                return 1;
            } else if (thisSign === otherSign) {
                return 0;
            } else {
                return -1;
            }
        } else {
            if (thisSign > otherSign) {
                return 1;
            } else if (thisSign === otherSign) {
                return -1;
            } else {
                return -1;
            }
        }
    },
    // Negates number
    // Returns new instance
    negate : function() {
        var ret = isc.BigDecimal.create(this);
        if (!ret.isNaN()) {
            if (ret.sign === 1) {
                ret.sign = -1;
            } else {
                ret.sign = 1;
            }
        }
        return ret;
    },
    // Add specified number to THIS number
    // Returns new instance
    add : function(number) {
        if (!(isc.isA.BigDecimal(number))) {
            number = isc.BigDecimal.create(number);
        }
        var thisNanValue = this.isNaN();
        var thisInfinityValue = this.isInfinity();
        var thisSign = this.getSign();
        var thisNum = this.getNum();
        var thisExp = this.getExp();
        var otherNanValue = number.isNaN();
        var otherInfinityValue = number.isInfinity();
        var otherSign = number.getSign();
        var otherNum = number.getNum();
        var otherExp = number.getExp();
        // If both values are NaN - return NaN.
        if (thisNanValue && otherNanValue) {
            return isc.BigDecimal.create();
        }
        // +Infinity-Infinity or -Infinity+Infinity results in NaN.
        if (thisInfinityValue && otherInfinityValue && thisSign != otherSign) {
            return isc.BigDecimal.create();
        }
        var ret = isc.BigDecimal.create("0");
        // If this value is (+/-)Infinity - adding anything to (+/-)Infinity equals (+/-)Infinity
        if (thisInfinityValue) {
            ret.sign = this.sign;
            ret.infinityValue = true;
            return ret.normalize();
        }
        // If other value is (+/-)Infinity - adding (+/-)Infinity to anything equals (+/-)Infinity
        if (otherInfinityValue) {
            ret.sign = number.sign;
            ret.infinityValue = true;
            return ret.normalize();
        }
        if (thisExp > otherExp) {
            thisNum += "0".repeat(thisExp - otherExp);
            thisExp = otherExp;
        } else {
            otherNum += "0".repeat(otherExp - thisExp);
            otherExp = thisExp;
        }
        if (thisNum.length > otherNum.length) {
            otherNum = "0".repeat(thisNum.length - otherNum.length) + otherNum;
        } else {
            thisNum = "0".repeat(otherNum.length - thisNum.length) + thisNum;
        }
        ret.sign = thisSign;
        ret.exp = thisExp;
        if (thisSign === otherSign) {
            var res = "";
            var carry = 0;
            // Optimization: do addition in 15 digit long chunks
            var i = thisNum.length;
            while (i >= 0) {
                var tn = thisNum.substring(Math.max(0, i - 15), i);
                var on = otherNum.substring(Math.max(0, i - 15), i);
                var s = parseInt(tn) + parseInt(on) + carry;
                var r = "000000000000000" + (s % 1000000000000000);
                res = r.substring(r.length - 15) + res;
                carry = Math.floor(s / 1000000000000000);
                i -= 15;
            }
// Code for doing addition digit by digit
//            for (var i = thisNum.length - 1; i >= 0; i--) {
//                var s = parseInt(thisNum[i]) + parseInt(otherNum[i]) + carry;
//                res = "" + (s % 10) + res;
//                carry = Math.floor(s / 10);
//            }
            if (carry > 0) {
                res = "" + carry + res;
            }
            ret.num = res;
        } else {
            if (thisNum < otherNum) {
                var tmp = thisNum;
                thisNum = otherNum;
                otherNum = tmp;
                ret.sign = otherSign;
            }
            var res = "";
            var carry = 0;
            // Optimization: do subtraction in 15 digit long chunks
            var i = thisNum.length;
            while (i >= 0) {
                var tn = thisNum.substring(Math.max(0, i - 15), i);
                var on = otherNum.substring(Math.max(0, i - 15), i);
                var s = 1000000000000000 + parseInt(tn) - parseInt(on) - carry;
                var r = "000000000000000" + (s % 1000000000000000);
                res = r.substring(r.length - 15) + res;
                carry = (Math.floor(s / 1000000000000000) >= 1)?0:1;
                i -= 15;
            }
// Code for doing subtraction digit by digit
//            for (var i = thisNum.length - 1; i >= 0; i--) {
//                var s = 10 + parseInt(thisNum[i]) - parseInt(otherNum[i]) - carry;
//                res = "" + (s % 10) + res;
//                carry = (Math.floor(s / 10) >= 1)?0:1;
//            }
            ret.num = res;
        }
        return ret.normalize();
    },
    // Subtracts specified number from THIS number.
    // Returns new instance
    subtract : function(number) {
        number = isc.BigDecimal.create(number);
        number = number.negate();
        return this.add(number);
    },
    multiply : function(number) {
        if (!(isc.isA.BigDecimal(number))) {
            number = isc.BigDecimal.create(number);
        }
        // If any is NaN - return NaN
        if (this.isNaN() || number.isNaN()) {
            return isc.BigDecimal.create();
        }
        // Multiplying any Infinity by 0 gives NaN
        if ((this.compareTo(0) === 0 && number.isInfinity())
            || (this.isInfinity() && number.compareTo(0) === 0)) {
            return isc.BigDecimal.create();
        }
        // Multiplying any Infinity by any number gives Infinity
        if (this.isInfinity() || number.isInfinity()) {
            var ret = isc.BigDecimal.create("Infinity");
            if (this.sign !== number.sign) {
                ret.sign = -1;
            }
            return ret;
        }
        // Multiplying any number by 0 gives 0
        if (this.compareTo(0) === 0 || number.compareTo(0) === 0) {
            return isc.BigDecimal.create(0);
        }
        // Inflate num values (from both sides) that they would represent
        // numbers of same magnitude.
        var tNum = this.num;
        var oNum = number.num;
        tNum += "0".repeat(Math.max(this.exp - number.exp, 0));
        oNum += "0".repeat(Math.max(number.exp - this.exp, 0));
        tNum = "0".repeat(Math.max(oNum.length - tNum.length, 0)) + tNum;
        oNum = "0".repeat(Math.max(tNum.length - oNum.length, 0)) + oNum;
        // Multiply 7-digit chunks: result would be maximum 14 digits long -
        // JS can handle this.
        var a = [];
        while (tNum.length > 0) {
            var tm = parseInt(tNum.substring(Math.max(tNum.length - 7, 0)));
            var tmpONum = oNum;
            var r1 = [];
            var r2 = [];
            while (tmpONum.length > 0) {
                var om = parseInt(tmpONum.substring(Math.max(tmpONum.length - 7, 0)));
                var r = tm * om;
                r1.push(r % 10000000);
                r1.push(0);
                r2.push(0);
                r2.push(Math.floor(r / 10000000));
                tmpONum = tmpONum.substring(0, Math.max(tmpONum.length - 7, 0));
            }
            a.push(r1);
            a.push(r2);
            tNum = tNum.substring(0, Math.max(tNum.length - 7, 0));
        }
        // If resulting array has more than 10 rows we have to use BigDecimal
        // to sum. Summing more than 10 we can get result exceeding
        // 15 digits thus loose precision.
        var useBD = true;
        if (a.length < 10) {
            useBD = false;
        }
        var y = 0;
        var x = 0;
        // Carry
        var c = (useBD)?isc.BigDecimal.create("0"):0;
        var resA = [];
        while (y < a.length) {
            var s = (useBD)?isc.BigDecimal.create("0"):0;
            var xx = x;
            var yy = y;
            while ((a[yy] !== undefined) && (a[yy][xx] !== undefined)) {
                if (useBD) {
                    s = s.add(a[yy++][xx--]);
                } else {
                    s += a[yy++][xx--];
                }
            }
            // Add previous carry and save chunk 7 digits long.
            // Higher digits saved to next carry.
            if (useBD) {
                s = s.add(c);
                var sNum = "00000000" + s.num + "0".repeat(s.exp);
                c = isc.BigDecimal.create(sNum.substring(0, sNum.length - 7));
                s = isc.BigDecimal.create(sNum.substring(sNum.length - 7));
            } else {
                s += c;
                c = Math.floor(s / 10000000);
                s = s % 10000000;
            }
            resA.push(s);
            if (x < a[0].length - 2) {
                x = x + 2;
            } else {
                if (x < a[0].length - 1) {
                    y++
                } else {
                    y = y + 2;
                }
                x = a[0].length - 1;
            }
        }
        resA.push(c);
        var resNum = "";
        for (var i = resA.length - 1; i >= 0; i--) {
            var sNum;
            if (useBD) {
                sNum = "00000000" + resA[i].num + "0".repeat(resA[i].exp);
            } else {
                sNum = "00000000" + resA[i]
            }
            // Each chunk is 7 digits long
            resNum += sNum.substring(sNum.length - 7);
        }
        var rSign = "";
        if (this.sign !== number.sign) {
            rSign = "-";
        }
        // Resulting exponent
        var rExp = Math.min(this.exp, number.exp) * 2;
        return isc.BigDecimal.create(rSign + resNum + "e" + rExp);
    },
    round : function(precision, mode) {
        // NaN, Infinity, Zero - there is nothing to round
        if (this.isNaN() || this.isInfinity() || this.num === "0") {
            return isc.BigDecimal.create(this);
        }
        if (!precision) {
            precision = 0;
        }
        // Number is already at required precision
        if ((-1 * precision) <= this.exp) {
            return isc.BigDecimal.create(this);
        }
        var leftPart;
        var rightPart;
        if ((-1 * precision) >= (this.exp + this.num.length)) {
            leftPart = "0";
            rightPart = "0".repeat((-1 * precision) - (this.exp + this.num.length)) + this.num;
        } else {
            leftPart = this.num.substring(0, this.exp + this.num.length + precision);
            rightPart = this.num.substring(this.exp + this.num.length + precision);
        }
        if (!mode) {
            mode = "round";
        }
        var left = isc.BigDecimal.create(leftPart);
        var right = isc.BigDecimal.create("0." + rightPart);
        if (mode === "round") {
            var c = right.compareTo("0.5");
            if (this.sign >= 0) {
                if (c >= 0) {
                    left = left.add(1);
                }
            } else {
                if (c > 0) {
                    left = left.add(1);
                }
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode === "ceil" || mode == "java_ceil") {
            if (this.sign >= 0) {
                left = left.add(1);
            } else {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode === "floor" || mode == "java_floor") {
            if (this.sign < 0) {
                left = left.add(1).negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode == "java_up") {
            left = left.add(1);
            if (this.sign < 0) {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode == "java_down") {
            if (this.sign < 0) {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode == "java_halfUp") {
            var c = right.compareTo("0.5");
            if (c >= 0) {
                left = left.add(1);
            }
            if (this.sign < 0) {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode == "java_halfDown") {
            var c = right.compareTo("0.5");
            if (c > 0) {
                left = left.add(1);
            }
            if (this.sign < 0) {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        } else if (mode == "java_halfEven") {
            var c = right.compareTo("0.5");
            if (c > 0) {
                left = left.add(1);
            } else if (c === 0) {
                var lastDigit = leftPart.substring(leftPart.length - 1);
                if (lastDigit === "1" || lastDigit === "3" || lastDigit === "5" || lastDigit === "7" || lastDigit === "9") {
                    left = left.add(1);
                }
            }
            if (this.sign < 0) {
                left = left.negate();
            }
            left.exp += (-1 * precision);
            return left.normalize();
        }
        return isc.BigDecimal.create(this);
    },
    ceil : function(precision) {
        return this.round(precision, "ceil");
    },
    floor : function(precision) {
        return this.round(precision, "floor");
    },
    // Divides two numbers by subtracting divisor from dividend.
    // Should be used only for similar numbers when
    // number of subtractions is less than 10.
    // Returns array with two string elements: 0 - quotient; 1 - remainder
    _divideBySubtracting : function(dividend, divisor) {
    var ret = [];
        ret[0] = 0;
        ret[1] = isc.BigDecimal.create(dividend);
        var subtrahend = isc.BigDecimal.create(divisor);
        while (ret[1].compareTo(subtrahend) >= 0) {
            var minuend = ret[1];
            ret[0]++;
            ret[1] = minuend.subtract(subtrahend);
        }
        return ret;
    },
    // Divides two numbers of same magnitude.
    // Returns array with two string elements: 0 - quotient; 1 - remainder
    _divide : function(dividend, divisor, precision) {
        var remainders = [];
        var ret = [];
        ret[0] = "";
        ret[1] = "";
        var div = dividend.substring(0, Math.min (dividend.length, divisor.length));
        if (div.length >= dividend.length) {
            dividend = ""
        } else {
            dividend = dividend.substring(div.length);
        }
        while (true) {
            var r = this._divideBySubtracting(div, divisor);
            ret[0] += r[0];
            ret[1] = r[1].getStringValue();
            if (dividend.length <= 0) {
                break;
            }
            div = ret[1] + dividend.substring(0, 1);
            dividend = dividend.substring(1);
        }
        if (precision > 0) {
            ret[0] += ".";
            var periodic = false;
            do {
                remainders.push(ret[1]);
                var div = ret[1] + "0";
                var r = this._divideBySubtracting(div, divisor);
                ret[0] += r[0];
                ret[1] = r[1].getStringValue();
                if (!isFinite(precision)) {
                    for (var i = 0; i < remainders.length; i++) {
                        if (remainders[i] === ret[1]) {
                            periodic = true;
                        }
                    }
                } else {
                    --precision;
                }
            } while ((isFinite(precision) && precision > 0) || (!isFinite(precision) && !periodic));
        }
        return ret;
    },
    divide : function(number, precision, mode) {
        if (!(isc.isA.BigDecimal(number))) {
            number = isc.BigDecimal.create(number);
        }
        // If any is NaN - return NaN
        if (this.isNaN() || number.isNaN()) {
            return isc.BigDecimal.create();
        }
        // Dividing any Infinity by any Infinity gives NaN
        if (this.isInfinity() && number.isInfinity()) {
            return isc.BigDecimal.create();
        }
        // Dividing any number by any Infinity gives 0
        if (number.isInfinity()) {
            return isc.BigDecimal.create("0");
        }
        // Dividing any Infinity by any number gives Infinity
        if (this.isInfinity()) {
            var ret = isc.BigDecimal.create("Infinity");
            if (this.sign !== number.sign) {
                ret.sign = -1;
            }
            return ret;
        }
        // Inflate num values that they would represent
        // numbers of same magnitude.
        var tNum = this.num;
        var oNum = number.num;
        tNum += "0".repeat(Math.max(this.exp - number.exp, 0));
        oNum += "0".repeat(Math.max(number.exp - this.exp, 0));
        if (!precision) {
            precision = 0;
        }
        // We divide with higher precision so we could round.
        var r = this._divide(tNum, oNum, precision + 1);
        if (r[1] !== "0") {
            // If remainder is not 0 we add 1 to least significant position:
            // if quotient was 123.45 then we get 123.451
            // We do not try to be correct here because it wont appear
            // final result. It is important rounding but not exact value.
            if (r[0].indexOf(".") === -1) {
                r[0] += ".";
            }
            r[0] += "1";
        }
        if (this.sign !== number.sign) {
            r[0] = "-" + r[0];
        }
        var ret = isc.BigDecimal.create(r[0]);
        return ret.round(precision, mode);
    },
    remainder : function(number) {
        if (!(isc.isA.BigDecimal(number))) {
            number = isc.BigDecimal.create(number);
        }
        // If any is NaN - return NaN
        if (this.isNaN() || number.isNaN()) {
            return isc.BigDecimal.create();
        }
        // Dividing any Infinity by any number gives NaN
        if (this.isInfinity()) {
            return isc.BigDecimal.create();
        }
        // Dividing any number by any Infinity gives exact same number
        if (number.isInfinity()) {
            return isc.BigDecimal.create(this);
        }
        // Inflate num values that they would represent
        // numbers of same magnitude.
        var tNum = this.num;
        var oNum = number.num;
        tNum += "0".repeat(Math.max(this.exp - number.exp, 0));
        oNum += "0".repeat(Math.max(number.exp - this.exp, 0));
        var r = this._divide(tNum, oNum, 0);
        if (this.sign === -1) {
            r[1] = "-" + r[1];
        }
        var ret = isc.BigDecimal.create(r[1]);
        ret.exp = Math.min(this.exp, number.exp);
        return ret;
    },
    // Parses provided parameter
    init : function () {
        this.Super("init", arguments);
        if (arguments && arguments[0]) {
            var value = arguments[0];
            if (isc.isA.Number(value)) {
                value = value.toExponential(20);
            }
            if (isc.isA.BigDecimal(value)) {
                this.nanValue = value.isNaN();
                this.infinityValue = value.isInfinity();
                this.sign = value.getSign();
                this.num = value.getNum();
                this.exp = value.getExp();
                this.normalize();
            } else if (isc.isA.String(value)) {
                var parts = this.r.exec(value);
                if (parts) {
                    if (parts[0] !== "NaN") {
                        this.nanValue = false;
                        if (parts[1] !== undefined) {
                            this.sign = (parts[1] === "-"?-1:1);
                        }
                        if (parts[7] !== undefined) {
                            this.infinityValue = true;
                        } else {
                            if (parts[6] !== undefined) {
                                this.exp = new Number(parts[6]);
                                if (parts[5] === '-') {
                                    this.exp *= -1;
                                }
                            }
                            if (parts[2] !== undefined) {
                                this.num = parts[2];
                                this.num = this.num.replace(/^0*/, "");
                            } else {
                                this.num = parts[3];
                                this.num = this.num.replace(/^0*/, "");
                                if (parts[4] !== undefined) {
                                    parts[4] = parts[4].replace(/0*$/, "");
                                    this.exp -= parts[4].length;
                                    this.num += parts[4];
                                    this.num = this.num.replace(/^0*/, "");
                                }
                            }
                            this.normalize();
                        }
                    }
                }
            } else if (value === Infinity) {
                this.nanValue = false;
                this.sign = 1;
                this.infinityValue = true;
            } else if (value === -Infinity) {
                this.nanValue = false;
                this.sign = -1;
                this.infinityValue = true;
            }
        }
    }
});

//
// Math helpers
//
isc.Math = {
    clamp : function (value, min, max) {
        if (value < min) return min;
        if (value > max) return max;
        return value;
    },
    // When called with two parameters `a' and `b', selects a random integer between `a' and `b'
    // inclusive, drawn uniformly.
    // When called with a single parameter `a', selects a random integer between 0 and `a' inclusive,
    // drawn uniformly.
    // @param a (int)
    // @param [b] (int)
    // @return (int)

    random : function (a, b) {

        if (b == null) {

            return Math.floor(Math.random() * (a + 1));
        } else {

            return Math.floor(Math.random() * (b - a + 1)) + a;
        }
    },

    _hexStringify : function (number, totalDigits) {
        var str = number.toString(16);
        if (str.length < totalDigits) str = isc.NumberUtil._getZeroString(totalDigits - str.length) + str;
        return str;
    },
    // Generate an RFC 4122-compliant UUID according to section 4.4. Algorithms for Creating a
    // UUID from Truly Random or Pseudo-Random Numbers.

    randomUUID : function () {
        var uint16s;
        if (window.Uint16Array && window.crypto && window.crypto.getRandomValues) {
            uint16s = new window.Uint16Array(8);
            window.crypto.getRandomValues(uint16s);
        } else {
            uint16s = new Array(8);
            var now = new Date().getTime();
            for (var i = 0; i < uint16s.length; ++i) {
                uint16s[i] = (now ^ (Math.random() * 65536)) & 0xFFFF;
            }
        }

        uint16s[3] = (uint16s[3] & 0x0FFF) | 0x4000;

        // Set the two most significant bits of clock_seq_hi_and_reserved to 0 and 1, respectively.
        uint16s[4] = (uint16s[4] & 0xBFFF) | 0x8000;

        return (this._hexStringify(uint16s[0], 4) + this._hexStringify(uint16s[1], 4) + "-" +
                this._hexStringify(uint16s[2], 4) + "-" +
                this._hexStringify(uint16s[3], 4) + "-" +
                this._hexStringify(uint16s[4], 4) + "-" +
                this._hexStringify(uint16s[5], 4) + this._hexStringify(uint16s[6], 4) + this._hexStringify(uint16s[7], 4)).toUpperCase();
    },

    // Generates a random string of length `len' from characters in a specified alphabet.
    // @param len (int) the length of the generated random string.
    // @param alphabet (String | int) when a String, each character of the string has an equal
    // probability of being selected as a character of the generated random string. When an
    // integer less than or equal to 36, the first `alphabet' characters of "0123456789abcdefghijklmnopqrstuvwxyz"
    // become the alphabet.
    randomString : function (len, alphabet) {
        var arr = new Array(len);
        var alphabetLen;
        if (isc.isA.Number(alphabet)) {
            alphabetLen = alphabet;
            alphabet = "0123456789abcdefghijklmnopqrstuvwxyz".substring(0, alphabetLen);
        } else {
            alphabetLen = alphabet.length;
        }
        for (var i = 0; i < len; ++i) {
            arr[i] = alphabet[this.random(alphabetLen - 1)];
        }
        return arr.join("");
    },

    _signum : function (x) {
        return (x < 0 ? -1 : (x > 0 ? 1 : 0));
    },



    // Calculate sqrt(a^2 + b^2) without overflow or underflow
    // Note: Firefox 27.0+ supports Math.hypot() from EcmaScript 6: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/hypot
    _hypot : function (a, b) {
        a = Math.abs(a);
        b = Math.abs(b);
        if (a > b) {
            return a * Math.sqrt(1 + b * b / a / a);
        } else if (b != 0) {
            return b * Math.sqrt(1 + a * a / b / b);
        } else {
            return a;
        }
    },

    // Calculates the shortest Euclidean distance from a test point (x3, y3) to the line between
    // start point (x1, y1) and end point (x2, y2).
    euclideanDistanceToLine : function (x1, y1, x2, y2, x3, y3) {
        // http://web.archive.org/web/20080704103329/http://local.wasp.uwa.edu.au/~pbourke/geometry/pointline/

        var dx = x2 - x1,
            dy = y2 - y1;

        var uDenom = dx * dx + dy * dy;
        // If the line's endpoints are coincident, then just return the Euclidean distance from
        // the test point to the start point.
        if (uDenom <= 0.00001) {
            return this.euclideanDistance(x1, y1, x3, y3);
        }

        var u = ((x3 - x1) * (x2 - x1) + (y3 - y1) * (y2 - y1)) / uDenom;

        if (u < 0) {
            return this.euclideanDistance(x1, y1, x3, y3);
        } else if (u > 1) {
            return this.euclideanDistance(x2, y2, x3, y3);
        } else {
            // Actually compute the point of intersection.
            var x = x1 + u * dx,
                y = y1 + u * dy;

            return this.euclideanDistance(x, y, x3, y3);
        }
    },

    // Calculates the Euclidean distance between two points.
    euclideanDistance : function (x1, y1, x2, y2) {
        if (arguments.length == 2) {
            // Assume that the two given arguments are points.
            var p1 = x1,
                p2 = y1;
            x1 = p1[0];
            y1 = p1[1];
            x2 = p2[0];
            y2 = p2[1];
        }
        return this._hypot((x1 - x2), (y1 - y2));
    },

    // Trigonometry
    // ---------------------------------------------------------------------------------------
    _radPerDeg: Math.PI / 180,

    _piOver2: Math.PI / 2,

    //> @classMethod math.toRadians()
    // Converts an angle in degrees to radians.
    // @param angle (double) the angle in degrees.
    // @return (double) the angle in radians.
    //<
    toRadians : function (angle) {
        return angle * this._radPerDeg;
    },

    //> @classMethod math.cosdeg()
    // Calculates the cosine of the given angle in degrees.
    // @param angle (double) the angle in degrees.
    // @return (double) the cosine of the given angle.
    //<
    cosdeg : function (angle) {
        return Math.cos(angle * this._radPerDeg);
    },

    //> @classMethod math.sindeg()
    // Calculates the sine of the given angle in degrees.
    // @param angle (double) the angle in degrees.
    // @return (double) the sine of the given angle.
    //<
    sindeg : function (angle) {
        return Math.sin(angle * this._radPerDeg);
    },

    // Linear Algebra
    // ---------------------------------------------------------------------------------------

    // Calculates the dot product of two vectors. To be well formed, the two vectors must have
    // the same array length (dimension).
    _dot : function (u, v) {
        var ret = 0;
        for (var i = 0; i < u.length; ++i) {
            ret += u[i] * v[i];
        }
        return ret;
    },

    // Given a matrix A (that is an Array of Arrays of Numbers) returns a new matrix that is the matrix
    // multiplication of the transpose of A times A.  If A has m rows and n columns then the
    // new matrix will have n rows and n columns.
    _dotAtA : function (A) {
        var m = A.length,
            n = A[0].length,
            AtA = new Array(n);

        for (var i = n; i--; ) {
            AtA[i] = new Array(n);
        }

        for (var i = n; i--; ) {
            var AtAi = AtA[i];
            for (var j = i; j < n; ++j) {
                var sum = 0;
                for (var k = m; k--; ) {
                    var Ak = A[k];
                    sum += Ak[i] * Ak[j];
                }
                AtAi[j] = AtA[j][i] = sum;
            }
        }
        return AtA;
    },

    // Given a matrix A, that is an Array of Arrays of Numbers, and a vector b, that is an Array of Numbers,
    // return a new vector that is the matrix multiplication of A times b.  If A has m rows and n columns,
    // then b is expected to have length n, and the returned vector will have length m.
    _dotAtb : function (A, b) {
        if (A.length != b.length) {
            return null;
        }

        var m = A[0].length, n = b.length,
            Atb = new Array(m);

        for (var i = m; i--; ) {
            var sum = 0;
            for (var j = n; j--; ) {
                sum += A[j][i] * b[j];
            }
            Atb[i] = sum;
        }
        return Atb;
    },

    // Calculates the Cholesky decomposition of a symmetric, positive-definite matrix A.
    // A must be an Array of Arrays of Numbers.  The return value is the unique,
    // lower triangular matrix L such that A = L * Lt.  If A has n rows and n columns
    // (it must have equal number of rows and columns in order to be symmetric), then the
    // returned matrix L will also have n rows and n columns.
    // See:  http://en.wikipedia.org/wiki/Cholesky_decomposition
    _cholesky : function (A) {
        if (A.length != A[0].length) {
            // The matrix A is apparently not symmetric, so return null.
            return null;
        }

        var n = A.length,
            L = isc.Math._createMatrix(n, n);

        for (var j = 0; j < n; ++j) {
            var Lj = L[j],
                sum = 0;

            for (var k = 0; k < j; ++k) {
                var Ljk = Lj[k];
                sum += Ljk * Ljk;
            }

            if (A[j][j] - sum < 0) {
                // The matrix A must not have been positive-definite.  In this case
                // the matrix has no Cholesky decomposition, so return null.
                return null;
            }

            var Ljj = Lj[j] = Math.sqrt(A[j][j] - sum);

            for (var i = j + 1; i < n; ++i) {
                var Li = L[i],
                    sum = 0;
                for (var k = 0; k < j; ++k) {
                    sum += Li[k] * Lj[k];
                }
                Li[j] = (A[i][j] - sum) / Ljj;
            }
        }

        return L;
    },

    // Return the transpose of a matrix A (an Array of Arrays of Numbers).  The transpose
    // matrix will have the same number of rows as A has columns and the same
    // number of columns as A has rows.
    _transpose : function (A) {
        var m = A.length, n = A[0].length,
            At = new Array(n);
        for (var i = n; i--; ) {
            At[i] = new Array(m);
        }
        for (var i = n; i--; ) {
            var Ati = At[i];
            for (var j = m; j--; ) {
                Ati[j] = A[j][i];
            }
        }
        return At;
    },

    // Create a matrix of m x n size as an Array of Arrays with no initial values.
    _createMatrix : function (m, n) {
        var A = new Array(m);
        for (var i = m; i--; ) {
            A[i] = new Array(n);
        }
        return A;
    },

    // Similar to _createMatrix(), but the matrix is filled with zeros.
    _createZeroMatrix : function (m, n) {
        var A = new Array(m);
        for (var i = m; i--; ) {
            var Ai = A[i] = new Array(n);
            for (var j = n; j--; ) {
                Ai[j] = 0;
            }
        }
        return A;
    },

    // Creates a new Array of length n that contains zeros as entries.
    _createZeroVector : function (n) {
        var v = new Array(n);
        for (var i = n; i--; ) {
            v[i] = 0;
        }
        return v;
    },

    // Creates a new matrix (an Array of Arrays) that has identical size and
    // entries as the given matrix A.
    _cloneMatrix : function (A) {
        var m = A.length, n = A[0].length,
            B = new Array(m);
        for (var i = m; i--; ) {
            var Ai = A[i],
                Bi = B[i] = new Array(n);
            for (var j = n; j--; ) {
                Bi[j] = Ai[j];
            }
        }
        return B;
    },

    // Calculate the Moore–Penrose pseudoinverse of a matrix A.
    _pseudoInv : function (A, maxIterations) {
        var svd = isc.Math._svd(A, maxIterations, true, true);
        if (svd != null) {
            var s = svd.s,
                m = s.length;
            for (var i = m; i--; ) {
                s[i] = (s[i] == 0 ? 0 : (1 / s[i]));
            }
            return isc.Math._dotUSVt(svd.V, s, svd.U);
        } else {
            return null;
        }
    },

    // Calculate the singular value decomposition of a matrix A into the product
    // A = U * S * Vt, where U and V are unitary matrices, and S is a
    // diagonal matrix.  The return value is an object with the keys "U" and "V"
    // each mapped to a matrix (an Array of Arrays of Numbers) and the key "s" mapped
    // to an Array of Numbers.  The matrix S in the singular value decomposition can
    // be formed by taking a zero matrix of the appropriate size (see _createZeroMatrix())
    // and filling the diagonal entries of that matrix with the entries of s:
    //
    //     var m = A.length,
    //         n = A[0].length,
    //         svd = isc.Math._svd(A),
    //         s = svd.s,
    //         S = isc.Math._createZeroMatrix(m, n);
    //     for (var i = 0; i < m && i < n; ++i) {
    //         S[i][i] = s[i];
    //     }
    //

    _svd : function (A, maxIterations, wantU, wantV, calculateThinSVD) {
        if (maxIterations == null) {
            maxIterations = 50;
        }
        if (wantU == null) {
            wantU = true;
        }
        if (wantV == null) {
            wantV = true;
        }

        var eps = 2.220446049250313e-16; // 2^-52
        var tiny = Number.MIN_VALUE;
        var m = A.length, n = A[0].length;

        if (m < n) {
            var ret = isc.Math._svd(isc.Math._transpose(A), maxIterations, wantV, wantU);
            if (ret != null) {
                var swap = ret.U;
                ret.U = ret.V;
                ret.V = swap;
            }
            return ret;
        }

        var hypot = isc.Math._hypot,
            nu = Math.min(m, n),
            q = (calculateThinSVD ? nu : m),
            p = Math.min(n, m + 1),
            nct = Math.min(m - 1, n),
            nrt = Math.max(0, Math.min(n - 2, m)),
            A = isc.Math._cloneMatrix(A),
            s = new Array(p),
            U = isc.Math._createZeroMatrix(m, q),
            V = isc.Math._createZeroMatrix(n, n),
            e = isc.Math._createZeroVector(n),
            work = isc.Math._createZeroVector(m);

        for (var k = 0, maxK = Math.max(nct, nrt); k < maxK; ++k) {
            if (k < nct) {
                s[k] = 0;
                for (var i = k; i < m; ++i) {
                    s[k] = hypot(s[k], A[i][k]);
                }
                if (s[k] != 0) {
                    if (A[k][k] < 0) {
                        s[k] = -s[k];
                    }
                    for (var i = k; i < m; ++i) {
                        A[i][k] /= s[k];
                    }
                    A[k][k] += 1;
                }
                s[k] = -s[k];
            }
            for (var j = k + 1; j < n; ++j) {
                if (k < nct && s[k] != 0) {
                    // apply the transformation
                    var t = 0;
                    for (var i = k; i < m; ++i) {
                        t += A[i][k] * A[i][j];
                    }
                    t = -t / A[k][k];
                    for (var i = k; i < m; ++i) {
                        A[i][j] += t * A[i][k];
                    }
                }

                // place the kth row of A into e for the subsequent calculation of the row transform
                e[j] = A[k][j];
            }
            if (wantU && k < nct) {
                // place the transformation in U for subsequent back multiplication
                for (var i = k; i < m; ++i) {
                    U[i][k] = A[i][k];
                }
            }
            if (k < nrt) {
                // compute the kth row transformation and place the kth super-diagonal into e[k].
                e[k] = 0;
                for (var i = k + 1; i < n; ++i) {
                    e[k] = hypot(e[k], e[i]);
                }
                if (e[k] != 0) {
                   if (e[k + 1] < 0) {
                       e[k] = -e[k];
                   }
                   for (var i = k + 1; i < n; ++i) {
                       e[i] /= e[k];
                   }
                   e[k + 1] += 1;
                }
                e[k] = -e[k];

                if (k + 1 < m && e[k] != 0) {
                    // apply the transformation
                    for (var i = k + 1; i < m; ++i) {
                        work[i] = 0;
                    }
                    for (var j = k + 1; j < n; ++j) {
                        for (var i = k + 1; i < m; ++i) {
                            work[i] += e[j] * A[i][j];
                        }
                    }
                    for (var j = k + 1; j < n; ++j) {
                        var t = -e[j] / e[k + 1];
                        for (var i = k + 1; i < m; ++i) {
                            A[i][j] += t * work[i];
                        }
                    }
                }
                if (wantV) {
                    // place the transformation in V for subsequent back multiplication
                    for (var i = k + 1; i < n; ++i) {
                        V[i][k] = e[i];
                    }
                }
            }
        }

        // Set up the final bidiagonal matrix of order p
        if (nct < n) {
            s[nct] = A[nct][nct];
        }
        if (m < p) {
            s[p - 1] = 0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0;

        // If required, generate U
        if (wantU) {
            for (var j = nct; j < q; ++j) {
                for (var i = 0; i < m; ++i) {
                    U[i][j] = 0;
                }
                U[j][j] = 1;
            }
            for (var k = nct - 1; k >= 0; --k) {
                if (s[k] != 0) {
                    for (var j = k + 1; j < q; ++j) {
                        var t = 0;
                        for (var i = k; i < m; ++i) {
                            t += U[i][k] * U[i][j];
                        }
                        t = -t / U[k][k];
                        for (var i = k; i < m; ++i) {
                            U[i][j] += t * U[i][k];
                        }
                    }
                    for (var i = k; i < m; ++i) {
                        U[i][k] = -U[i][k];
                    }
                    U[k][k] += 1;
                    for (var i = 0; i < k - 1; ++i) {
                        U[i][k] = 0;
                    }
                } else {
                    for (var i = 0; i < m; ++i) {
                        U[i][k] = 0;
                    }
                    U[k][k] = 1;
                }
            }
        }

        // If required, generate V
        if (wantV) {
            for (var k = n - 1; k >= 0; --k) {
                if (k < nrt && e[k] != 0) {
                    for (var j = k + 1; j < nu; ++j) {
                        var t = 0;
                        for (var i = k + 1; i < n; ++i) {
                            t += V[i][k] * V[i][j];
                        }
                        t = -t / V[k+1][k];
                        for (var i = k + 1; i < n; ++i) {
                            V[i][j] += t * V[i][k];
                        }
                    }
                }
                for (var i = 0; i < n; ++i) {
                    V[i][k] = 0;
                }
                V[k][k] = 1;
            }
        }

        // Main iteration loop for the singular values.
        var pp = p-1,
            iter = 0;
        while (p > 0) {
            if (iter > maxIterations) {
                return null;
            }

            // Inspect for negligible elements in the s and e arrays.
            // case 1:  s[p] and e[k-1] are negligible and k < p
            // case 2:  s[k] is negligible and k < p
            // case 3:  e[k-1] is negligible, k < p, and s[k], ..., s[p] are not negligible (QR step)
            // case 4:  e[p-1] is negligible (convergence)
            var k, caseNum;
            for (k = p - 2; k >= -1; --k) {
                if (k == -1) {
                    break;
                }
                if (Math.abs(e[k]) <= tiny + eps*(Math.abs(s[k]) + Math.abs(s[k+1]))) {
                    e[k] = 0;
                    break;
                }
            }
            if (k == p - 2) {
                // e[p - 1] is negligible (convergence)
                caseNum = 4;
            } else {
                var ks;
                for (ks = p - 1; ks >= k; --ks) {
                    if (ks == k) {
                        break;
                    }
                    var t = (ks != p ? Math.abs(e[ks]) : 0) +
                            (ks != k + 1 ? Math.abs(e[ks - 1]) : 0);
                    if (Math.abs(s[ks]) <= tiny + eps * t)  {
                        s[ks] = 0;
                        break;
                    }
                }
                if (ks == k) {
                    // e[k-1] is negligible, k < p, and
                    // s[k], ..., s[p] are not negligible => QR step
                    caseNum = 3;
                } else if (ks == p - 1) {
                    // s[p] and e[k-1] are negligible and k < p
                    caseNum = 1;
                } else {
                    // s[k] is negligible and k < p
                    caseNum = 2;
                    k = ks;
                }
            }
            ++k;

            // Perform the task indicated by the exact case:
            switch (caseNum) {
            case 1:
                // Deflate negligible s[p]
                var f = e[p-2];
                e[p-2] = 0;
                for (var j = p - 2; j >= k; --j) {
                    var t = hypot(s[j], f),
                        cs = s[j] / t,
                        sn = f / t;
                    s[j] = t;
                    if (j != k) {
                        f = -sn * e[j-1];
                        e[j-1] = cs * e[j-1];
                    }
                    if (wantV) {
                        for (var i = 0; i < n; ++i) {
                            t = cs * V[i][j] + sn * V[i][p-1];
                            V[i][p-1] = -sn * V[i][j] + cs * V[i][p-1];
                            V[i][j] = t;
                        }
                    }
                }
                break;

            case 2:
                // Split at negligible s(k).
                var f = e[k-1];
                e[k-1] = 0;
                for (var j = k; j < p; ++j) {
                    var t = hypot(s[j], f),
                        cs = s[j] / t,
                        sn = f / t;
                    s[j] = t;
                    f = -sn * e[j];
                    e[j] = cs * e[j];
                    if (wantU) {
                        for (var i = 0; i < m; ++i) {
                            t = cs * U[i][j] + sn * U[i][k-1];
                            U[i][k-1] = -sn * U[i][j] + cs * U[i][k-1];
                            U[i][j] = t;
                        }
                    }
                }
                break;

            case 3:
                // Perform one QR step

                // Calculate the shift.
                var scale = Math.max(
                        Math.abs(s[p-1]),
                        Math.abs(s[p-2]),
                        Math.abs(e[p-2]),
                        Math.abs(s[k]),
                        Math.abs(e[k])),
                    sp = s[p-1] / scale,
                    spm1 = s[p-2] / scale,
                    epm1 = e[p-2] / scale,
                    sk = s[k] / scale,
                    ek = e[k] / scale,
                    b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2,
                    c = sp * epm1 * sp * epm1,
                    shift = 0;
                if (!(b == 0 && c == 0)) {
                   shift = Math.sqrt(b * b + c);
                   if (b < 0) {
                      shift = -shift;
                   }
                   shift = c / (b + shift);
                }
                var f = (sk + sp) * (sk - sp) + shift,
                    g = sk * ek;

                // Chase zeros
                for (var j = k; j < p - 1; ++j) {
                   var t = hypot(f, g),
                       cs = f / t,
                       sn = g / t;
                   if (j != k) {
                      e[j-1] = t;
                   }
                   f = cs * s[j] + sn * e[j];
                   e[j] = cs * e[j] - sn * s[j];
                   g = sn * s[j+1];
                   s[j+1] = cs * s[j+1];
                   if (wantV) {
                       for (var i = 0; i < n; ++i) {
                           t = cs * V[i][j] + sn * V[i][j+1];
                           V[i][j+1] = -sn * V[i][j] + cs * V[i][j+1];
                           V[i][j] = t;
                       }
                   }
                   t = hypot(f, g);
                   cs = f / t;
                   sn = g / t;
                   s[j] = t;
                   f = cs * e[j] + sn * s[j+1];
                   s[j+1] = -sn * e[j] + cs * s[j+1];
                   g = sn * e[j+1];
                   e[j+1] = cs * e[j+1];
                   if (wantU && j < m - 1) {
                       for (var i = 0; i < m; ++i) {
                           t = cs * U[i][j] + sn * U[i][j+1];
                           U[i][j+1] = -sn * U[i][j] + cs * U[i][j+1];
                           U[i][j] = t;
                       }
                   }
                }
                e[p-2] = f;
                ++iter;
                break;

            case 4:
                // Convergence.

                // Make the singular values non-negative
                if (s[k] <= 0) {
                    s[k] = -s[k];
                    if (wantV) {
                        for (var i = 0; i <= pp; ++i) {
                            V[i][k] = -V[i][k];
                        }
                    }
                }

                // Order the singular values.
                for (; k < pp; ++k) {
                    if (s[k] >= s[k+1]) {
                        break;
                    }
                    var t = s[k];
                    s[k] = s[k+1];
                    s[k+1] = t;
                    if (wantV && k < n - 1) {
                        for (var i = 0; i < n; ++i) {
                            t = V[i][k+1]; V[i][k+1] = V[i][k]; V[i][k] = t;
                        }
                    }
                    if (wantU && k < m - 1) {
                        for (var i = 0; i < m; ++i) {
                            t = U[i][k+1]; U[i][k+1] = U[i][k]; U[i][k] = t;
                        }
                    }
                }
                iter = 0;
                --p;
                break;
            } // end of switch
        } // end of loop while p > 0

        return { U: U, s: s, V: V };
    },

    // Takes a matrix U, an array s that defines the diagonal elements of a diagonal matrix S, and
    // a matrix V, and returns the matrix multiplication of U times S times the transpose of V.
    // This method may be used to check the singular value decomposition of a matrix A,
    // but it is also used to calculate the Moore–Penrose pseudoinverse of A (see _pseudoInv()).
    _dotUSVt : function (U, s, V) {
        var m = U.length,
            n = V.length,
            l = Math.min(m, n),
            A = isc.Math._createMatrix(m, n);

        for (var i = m; i--; ) {
            var Ui = U[i], Ai = A[i];
            for (var j = n; j--; ) {
                var sum = 0, Vj = V[j];
                for (var k = l; k--; ) {
                    sum += Ui[k] * s[k] * Vj[k];
                }
                Ai[j] = sum;
            }
        }
        return A;
    },

    _EPSILON : (function () {
        var i = 0;
        while (1.0 + Math.pow(2, -i) > 1.0) {
            ++i;
        }
        return Math.pow(2, -i + 1);
    })(),

    // A constructor function for a complex number.
    _complexNumber : function (real, imag) {
        this.real = real;
        this.imag = imag;
    },


    _rpolyState : {
        // arrays of numbers:
        p: [], qp: [], k: [], qk: [], svk: [],
        // numbers:
        sr: 0, si: 0, u: 0, v: 0, a: 0, b: 0, c: 0, d: 0, a1: 0, a2: 0, a3: 0, a6: 0, a7: 0, e: 0,
        f: 0, g: 0, h: 0, szr: 0, szi: 0, lzr: 0, lzi: 0,
        // integers:
        n: 0,
        nn: 0
    },
    _rpoly : function (op, degree) {

        var state = isc.Math._rpolyState,
            zeros = [],
            fail = false;

        // The following statements set machine constants used in various parts of the program.
        // The meaning of the four constants are:
        // eta     The maximum relative representation error which can be described as the
        //         smallest positive floating point number such that 1.0 + eta is greater than 1.
        // `are` and `mre` refer to the unit error in `+` and `*` respectively.  They are assumed
        // to be the same as eta.
        var eta = isc.Math._EPSILON,
            are = eta,
            mre = eta;

        // Initialization of constants for shift rotation.
        var xx = Math.SQRT1_2;
        var yy = -xx;
        var cosr = Math.cos(94 * Math.PI / 180);
        var sinr = Math.sin(94 * Math.PI / 180);

        // Skip any leading coefficients that are zero.
        var op0 = 0;
        while (op0 <= degree && op[op0] == 0) {
            ++op0;
        }
        degree -= Math.min(degree, op0);

        if (degree == 0) {
            // Fail if the degree is zero.  The polynomial is constant so there are either
            // zero roots or infinitely many roots.
            fail = true;
            degree = 0;
            return { degree: degree, zeros: zeros, fail: fail };
        }
        state.n = degree;
        state.nn = degree + 1;

        // Remove the zeros at the origin if any.
        while (op[op0 + state.nn - 1] == 0) {
            var j = degree - state.n;
            zeros[j] = new isc.Math._complexNumber(0, 0);
            --state.nn;
            --state.n;
        }

        // Make a copy of the coefficients.
        for (var i = state.nn; i--; ) {
            state.p[i] = op[op0 + i];
        }

        var pt = new Array(101),
            temp = new Array(101);
        for (;;) {
            // Start the algorithm for one zero.
            if (state.n <= 2) {
                // Calculate the final zero or pair of zeros.
                if (state.n == 2) {
                    var quadOutput = isc.Math._quad(state.p[0], state.p[1], state.p[2]);
                    zeros[degree - 2] = new isc.Math._complexNumber(quadOutput.sr, quadOutput.si);
                    zeros[degree - 1] = new isc.Math._complexNumber(quadOutput.lr, quadOutput.li);
                } else if (state.n == 1) {
                    zeros[degree - 1] = new isc.Math._complexNumber(-state.p[1] / state.p[0], 0);
                }
                return { degree: degree, zeros: zeros, fail: fail };
            }

            // Find largest and smallest moduli of coefficients.
            var max = 0;
            var min = Number.MAX_VALUE;
            for (var i = state.nn; i--; ) {
                var x = Math.abs(state.p[i]);
                if (x > max) {
                    max = x;
                }
                if (x != 0 && x < min) {
                    min = x;
                }
            }

            // Scale if there are large or very small coefficients computes a scale factor to multiply
            // the coefficients of the polynomial.  The scaling is done to avoid overflow and to
            // avoid undetected underflow interfering with the convergence criterion.  The factor is
            // a power of 10.
            var sc = (Number.MIN_VALUE / eta) / min;
            if ((sc > 1 && Number.MAX_VALUE / sc >= max) || max >= 10) {
                if (sc == 0) {
                    sc = Number.MIN_VALUE;
                }
                var factor = Math.pow(10, Math.floor(Math.log(sc) / Math.LN10 + 0.5));
                if (factor != 1) {
                    if (factor == 0) {
                        // You're on the Edge...of an underflow.
                        // Workaround for MS Edge bug: minimum safe Number value per MS docs
                        // https://msdn.microsoft.com/en-us/library/ff806190(v=vs.94).aspx
                        // is: Number.MIN_VALUE: 5.00E-324
                        // but if you substitute anything smaller than -308 in the formula
                        // below, it will underflow, returning zero.  The 308 limit is
                        // suspiciously the same as the exponent of Number.MAX_VALUE: 1.79E+308.
                        // The Math.pow() above ends up resolving to Math.pow(10, -318) in, for
                        // example, our FE "Shape Gallery" example whend drawing a bezier curve
                        // (and we end up here because Edge doesn't implement the
                        // isPointInStroke() Canvas API).
                        // Also, This -308 exponent limit is a regression from IE which doesn't
                        // share this shortcoming.
                        //
                        // If left unaddressed, a zero factor here ends up causing an infinite loop by
                        // zeroing out the values in the state.p[].
                        // all the
                        factor = Math.pow(10, -308);
                    }
                    for (var i = state.nn; i--; ) {
                        state.p[i] *= factor;
                    }
                }
            }

            // Compute lower bound on moduli of zeros.
            for (var i = state.nn; i--; ) {
                pt[i] = Math.abs(state.p[i]);
            }
            pt[state.nn - 1] = -pt[state.nn - 1];
            // Compute upper estimate of bound.
            var x = Math.exp((Math.log(-pt[state.nn - 1]) - Math.log(pt[0])) / state.n);
            if (pt[state.n - 1] != 0) {
                // If Newton step at the origin is better, use it.
                var xm = -pt[state.nn - 1] / pt[state.n - 1];
                if (xm < x) {
                    x = xm;
                }
            }

            // Chop the interval (0,x) until ff <= 0.
            for (;;) {
                var xm = x / 10;
                var ff = pt[0];
                for (var i = 1; i < state.nn; ++i) {
                    ff = ff * xm + pt[i];
                }
                if (ff > 0) {
                    x = xm;
                } else {
                    break;
                }
            }

            // Do Newton iteration until x converges to two decimal places.
            for (var dx = x; Math.abs(dx / x) > 5e-3; ) {
                var ff = pt[0];
                var df = ff;
                for (var i = 1; i < state.n; ++i) {
                    ff = ff * x + pt[i];
                    df = df * x + ff;
                }
                ff = ff * x + pt[state.nn - 1];
                dx = ff / df;
                x -= dx;
            }

            var bnd = x;
            // Compute the derivative as the intial k polynomial and do 5 steps with no shift.
            var nm1 = state.n - 1;
            state.k[0] = state.p[0];
            for (var i = state.n; (--i) >= 1; ) {
                state.k[i] = (state.nn - i - 1) * state.p[i] / state.n;
            }
            var aa = state.p[state.nn - 1];
            var bb = state.p[state.n - 1];
            var zerok = (state.k[state.n - 1] == 0);
            for (var jj = 5; jj--; ) {
                var cc = state.k[state.n - 1];
                if (zerok) {
                    // Use unscaled form of recurrence.
                    for (var i = 0; i < nm1; ++i) {
                        var j = state.nn - i;
                        state.k[j] = state.k[j - 1];
                    }
                    state.k[0] = 0;
                    zerok = (state.k[state.n - 1] == 0);
                } else {
                    // Use scaled form of recurrence if value of k at 0 is nonzero.
                    var t = -aa / cc;
                    for (var i = 0; i < nm1; ++i) {
                        var j = state.nn - i;
                        state.k[j] = t * state.k[j - 1] + state.p[j];
                    }
                    state.k[0] = state.p[0];
                    zerok = (Math.abs(state.k[state.n - 1]) <= Math.abs(bb) * eta * 10);
                }
            }

            // Save k for restarts with new shifts.
            for (var i = state.n; i--; ) {
                temp[i] = state.k[i];
            }

            // Loop to select the quadratic corresponding to each new shift.
            for (var cnt = 1; cnt <= 20; ++cnt) {
                // Quadratic corresponds to a double shift to a non-real point and its complex
                // conjugate.  The point has modulus bnd and amplitude rotated by 94 degrees from
                // the previous shift.
                var xxx = cosr * xx - sinr * yy;
                yy = sinr * xx + cosr * yy;
                xx = xxx;
                state.sr = bnd * xx;
                state.si = bnd * yy;
                state.u = state.sr * -2;
                state.v = bnd;
                // Second stage calculation, fixed quadratic
                var nz = isc.Math._fxshfr(state, cnt * 20, eta, are, mre);
                if (nz != 0) {
                    // The second stage jumps directly to one of the third stage iterations and
                    // returns here if successful.  Deflate the polynomial, store the zero or
                    // zeros and return to the main algorithm.
                    var j = degree - state.n;
                    zeros[j] = new isc.Math._complexNumber(state.szr, state.szi);
                    state.nn -= nz;
                    state.n = state.nn - 1;
                    for (var i = state.nn; i--; ) {
                        state.p[i] = state.qp[i];
                    }
                    if (nz != 1) {
                        zeros[j + 1] = new isc.Math._complexNumber(state.lzr, state.lzi);
                    }
                    break;
                }

                // If the iteration is unsuccessful another quadratic is chosen after restoring k.
                for (var i = state.n; i--; ) {
                    state.k[i] = temp[i];
                }
            }
        }

        // Return with failure if no convergence with 20 shifts.
        fail = true;
        degree -= state.n;
        return { degree: degree, zeros: zeros, fail: fail };
    },


    _fxshfr : function (state, l2, eta, are, mre) {

        var betav = 0.25;
        var betas = 0.25;
        var oss = state.sr;
        var ovv = state.v;
        var otv = 0, ots = 0;

        // Evaluate polynomial by synthetic division.
        var quadsdOutput = isc.Math._quadsd(state.nn, state.u, state.v, state.p);
        for (var i = state.nn; i--; ) {
            state.qp[i] = quadsdOutput.q[i];
        }
        state.a = quadsdOutput.a;
        state.b = quadsdOutput.b;

        var type = isc.Math._calcsc(state, eta);
        var vv = 0, ss = 0, tv = 0, ts = 0;
        for (var j = 1; j <= l2; ++j, ovv = vv, oss = ss, otv = tv, ots = ts) {
            // Calculate next k polynomial and estimate v.
            isc.Math._nextk(state, type, eta);
            type = isc.Math._calcsc(state, eta);
            var newestOutput = isc.Math._newest(state, type);
            var ui = newestOutput.uu;
            var vi = newestOutput.vv;

            vv = vi;
            // Estimate s.
            ss = 0;
            if (state.k[state.n - 1] != 0) {
                ss = -state.p[state.nn - 1] / state.k[state.n - 1];
            }
            tv = 1;
            ts = 1;
            if (j == 1 || type == 3) {
                continue;
            }
            // Compute relative measures of convergence of s and v sequences.
            if (vv != 0) {
                tv = Math.abs((vv - ovv) / vv);
            }
            if (ss != 0) {
                ts = Math.abs((ss - oss) / ss);
            }
            // If decreasing, multiply two most recent convergence measures.
            var tvv = 1;
            if (tv < otv) {
                tvv = tv * otv;
            }
            var tss = 1;
            if (ts < ots) {
                tss = ts * ots;
            }
            // Compare with convergence criteria.
            var vpass = tvv < betav;
            var spass = tss < betas;
            if (!(spass || vpass)) {
                continue;
            }
            // At least one sequence has passed the convergence test.  Store variables before iterating.
            var svu = state.u;
            var svv = state.v;
            for (var i = state.n; i--; ) {
                state.svk[i] = state.k[i];
            }
            var s = ss;
            // Choose iteration according to the fastest converging sequence.
            var vtry = false;
            var stry = false;
            for (var tryQuadraticIteration = !(spass && (!vpass || tss < tvv)); true; ) {
                if (tryQuadraticIteration) {
                    var nz = isc.Math._quadit(state, ui, vi, eta, are, mre);
                    if (nz > 0) {
                        return nz;
                    }

                    // Quadratic iteration has failed. flag that it has been tried and decrease
                    // the convergence criterion.
                    vtry = true;
                    betav /= 4;
                    // Try linear iteration if it has not been tried and the s sequence is converging.
                    if (stry || !spass) {
                        // Restore variables.
                        state.u = svu;
                        state.v = svv;
                        for (var i = state.n; i--; ) {
                            state.k[i] = state.svk[i];
                        }
                        if (vpass && !vtry) {
                            tryQuadraticIteration = true;
                            continue;
                        } else {
                            break;
                        }
                    }
                    for (var i = state.n; i--; ) {
                        state.k[i] = state.svk[i];
                    }
                }

                var realitOutput = isc.Math._realit(state, s, eta, are, mre);
                s = realitOutput.sss;
                var nz = realitOutput.nz;
                var iflag = realitOutput.iflag;
                if (nz > 0) {
                    return nz;
                }

                // Linear iteration has failed.  Flag that it has been tried and decrease the convergence criterion.
                stry = true;
                betas /= 4;
                if (iflag != 0) {
                    // If linear iteration signals an almost double real zero attempt quadratic interation.
                    ui = -(s + s);
                    vi = s * s;
                    tryQuadraticIteration = true;
                    continue;
                }

                // Restore variables.
                state.u = svu;
                state.v = svv;
                for (var i = state.n; i--; ) {
                    state.k[i] = state.svk[i];
                }
                // Try quadratic iteration if it has not been tried and the v sequence is converging.
                tryQuadraticIteration = vpass && !vtry;
                if (!tryQuadraticIteration) {
                    break;
                }
            }

            // Recompute qp and scalar values to continue the second stage.
            var quadsdOutput = isc.Math._quadsd(state.nn, state.u, state.v, state.p);
            for (var i = state.nn; i--; ) {
                state.qp[i] = quadsdOutput.q[i];
            }
            state.a = quadsdOutput.a;
            state.b = quadsdOutput.b;

            type = isc.Math._calcsc(state, eta);
        }
        return 0;
    },


    _quadit : function (state, uu, vv, eta, are, mre) {

        state.u = uu;
        state.v = vv;

        var tried = false,
            relstp = 0,
            omp = 0;

        var j = 0;
        for (;;) {
            var quadOutput = isc.Math._quad(1, state.u, state.v);
            state.szr = quadOutput.sr;
            state.szi = quadOutput.si;
            state.lzr = quadOutput.lr;
            state.lzi = quadOutput.li;
            // Return if roots of the quadratic are real and not close to multiple or nearly equal
            // and of opposite sign.
            if (Math.abs(Math.abs(state.szr) - Math.abs(state.lzr))
                    > Math.abs(state.lzr) * 1e-2)
            {
                return 0;
            }
            // Evaluate polynomial by quadratic synthetic division.
            var quadsdOutput = isc.Math._quadsd(state.nn, state.u, state.v, state.p);
            for (var i = state.nn; i--; ) {
                state.qp[i] = quadsdOutput.q[i];
            }
            state.a = quadsdOutput.a;
            state.b = quadsdOutput.b;

            var mp = (
                Math.abs(state.a - state.szr * state.b) +
                Math.abs(state.szi * state.b));
            // Compute a rigorous bound on the rounding error in evaluting p.
            var zm = Math.sqrt(Math.abs(state.v));
            var ee = Math.abs(state.qp[0]) * 2;
            var t = -state.szr * state.b;
            for (var i = 1; i < state.n; ++i) {
                ee = ee * zm + Math.abs(state.qp[i]);
            }
            ee = ee * zm + Math.abs(state.a + t);
            ee = (
                (5 * mre + 4 * are) * ee -
                (5 * mre + 2 * are) * (Math.abs(state.a + t) + Math.abs(state.b) * zm) +
                are * 2 * Math.abs(t));
            // Iteration has converged sufficiently if the polynomial value is less than 20 times
            // this bound.
            if (mp <= ee * 20) {
                return 2;
            }

            ++j;
            // Stop iteration after 20 steps.
            if (j > 20) {
                return 0;
            }
            if (!(j < 2 || relstp > 1e-2 || mp < omp || tried)) {
                // A cluster appears to be stalling the convergence.  Five fixed shift steps are
                // taken with a u,v close to the cluster.
                relstp = Math.sqrt(Math.max(eta, relstp));
                state.u -= state.u * relstp;
                state.v += state.v * relstp;
                var quadsdOutput = isc.Math._quadsd(state.nn, state.u, state.v, state.p);
                for (var i = state.nn; i--; ) {
                    state.qp[i] = quadsdOutput.q[i];
                }
                state.a = quadsdOutput.a;
                state.b = quadsdOutput.b;

                for (var i = 5; i--; ) {
                    isc.Math._nextk(state, isc.Math._calcsc(state, eta), eta);
                }
                tried = true;
                j = 0;
            }

            omp = mp;
            // Calculate next k polynomial and new u and v.
            isc.Math._nextk(state, isc.Math._calcsc(state, eta), eta);
            var newestOutput = isc.Math._newest(state, isc.Math._calcsc(state, eta));
            var ui = newestOutput.uu;
            var vi = newestOutput.vv;

            // If vi is zero the iteration is not converging.
            if (vi == 0) {
                return 0;
            }
            relstp = Math.abs((vi - state.v) / vi);
            state.u = ui;
            state.v = vi;
        }
    },


    _realit : function (state, sss, eta, are, mre) {

        var nm1 = state.n - 1;

        var s = sss;
        var nz = 0;
        var iflag = 0;

        for (var j = 0, omp = 0; true; ) {
            var pv = state.p[0];
            // Evaluate p at s.
            state.qp[0] = pv;
            for (var i = 1; i < state.nn; ++i) {
                pv = pv * s + state.p[i];
                state.qp[i] = pv;
            }
            var mp = Math.abs(pv);
            // Compute a rigorous bound on the error in evaluating p.
            var ms = Math.abs(s);
            var ee = mre / (are + mre) * Math.abs(state.qp[0]);
            for (var i = 1; i < state.nn; ++i) {
                ee = ee * ms + Math.abs(state.qp[i]);
            }
            // Iteration has converged sufficiently if the polynomial value is less than 20 times
            // this bound.
            if (mp <= ((are + mre) * ee - mre * mp) * 20) {
                nz = 1;
                state.szr = s;
                state.szi = 0;
                return { sss: sss, nz: nz, iflag: iflag };
            }

            ++j;
            // Stop iteration after 10 steps.
            if (j > 10) {
                return { sss: sss, nz: nz, iflag: iflag };
            }
            if (!(j < 2 || Math.abs(t) > Math.abs(s - t) * 1e-3 || mp <= omp)) {
                // A cluster of zeros near the real axis has been encountered.  Return with `iflag`
                // set to initiate a quadratic iteration.
                iflag = 1;
                sss = s;
                return { sss: sss, nz: nz, iflag: iflag };
            }

            // Return if the polynomial value has increased significantly.
            omp = mp;
            // Compute `t`, the next polynomial, and the new iterate.
            var kv = state.k[0];
            state.qk[0] = kv;
            for (var i = 1; i < state.n; ++i) {
                kv = kv * s + state.k[i];
                state.qk[i] = kv;
            }
            if (Math.abs(kv) <= Math.abs(state.k[state.n - 1]) * 10 * eta) {
                // Use unscaled form.
                state.k[0] = 0;
                for (var i = state.n; (--i) >= 1; ) {
                    state.k[i] = state.qk[i - 1];
                }
            } else {
                // Use the scaled form of the recurrence if the value of k at s is nonzero.
                var t = -pv / kv;
                state.k[0] = state.qp[0];
                for (var i = state.n; (--i) >= 1; ) {
                    state.k[i] = t * state.qk[i - 1] + state.qp[i];
                }
            }

            kv = state.k[0];
            for (var i = 1; i < state.n; ++i) {
                kv = kv * s + state.k[i];
            }
            var t = 0;
            if (Math.abs(kv) > Math.abs(state.k[state.n - 1]) * 10 * eta) {
                t = -pv / kv;
            }
            s += t;
        }
    },


    _calcsc : function (state, eta) {
        // Synthetic division of `k` by the quadratic `1,u,v`.
        var quadsdOutput = isc.Math._quadsd(state.n, state.u, state.v, state.k);
        for (var i = state.n; i--; ) {
            state.qk[i] = quadsdOutput.q[i];
        }
        state.c = quadsdOutput.a;
        state.d = quadsdOutput.b;

        var isType3 = !(
            Math.abs(state.c) > Math.abs(state.k[state.n - 1]) * 100 * eta ||
            Math.abs(state.d) > Math.abs(state.k[state.n - 2]) * 100 * eta);

        if (isType3) {
            // type=3 indicates the quadratic is almost a factor of k.
            return 3;
        } else if (Math.abs(state.d) < Math.abs(state.c)) {
            // type=1 indicates that all formulas are divided by c.
            state.e = state.a / state.c;
            state.f = state.d / state.c;
            state.g = state.u * state.e;
            state.h = state.v * state.b;
            state.a3 = state.a * state.e + (state.h / state.c + state.g) * state.b;
            state.a1 = state.b - state.a * (state.d / state.c);
            state.a7 = state.a + state.g * state.d + state.h * state.f;
            return 1;
        } else {
            // type=2 indicates that all formulas are divided by d.
            state.e = state.a / state.d;
            state.f = state.c / state.d;
            state.g = state.u * state.b;
            state.h = state.v * state.b;
            state.a3 = (state.a + state.g) * state.e + state.h * (state.b / state.d);
            state.a1 = state.b * state.f - state.a;
            state.a7 = (state.f + state.u) * state.a + state.h;
            return 2;
        }
    },


    _nextk : function (state, type, eta) {
        if (type == 3) {
            // Use unscaled form of the recurrence if type is 3.
            state.k[0] = state.k[1] = 0;
            for (var i = state.n; (--i) >= 2; ) {
                state.k[i] = state.qk[i - 2];
            }
        } else {
            var temp = (type == 1 ? state.b : state.a);
            if (Math.abs(state.a1) > Math.abs(temp) * eta * 10) {
                // Use scaled form of the recurrence.
                state.a7 /= state.a1;
                state.a3 /= state.a1;
                state.k[0] = state.qp[0];
                state.k[1] = state.qp[1] - state.a7 * state.qp[0];
                for (var i = state.n; (--i) >= 2; ) {
                    state.k[i] = (
                        state.a3 * state.qk[i - 2] - state.a7 * state.qp[i - 1] + state.qp[i]);
                }
            } else {
                // If a1 is nearly zero then use a special form of the recurrence.
                state.k[0] = 0;
                state.k[1] = -state.a7 * state.qp[0];
                for (var i = state.n; (--i) >= 2; ) {
                    state.k[i] = state.a3 * state.qk[i - 2] - state.a7 * state.qp[i - 1];
                }
            }
        }
    },


    _newest : function (state, type) {
        if (type != 3) {
            var a4, a5;
            if (type == 2) {
                a4 = (state.a + state.g) * state.f + state.h;
                a5 = (state.f + state.u) * state.c + state.v * state.d;
            } else {
                a4 = state.a + state.u * state.b + state.h * state.f;
                a5 = state.c + (state.u + state.v * state.f) * state.d;
            }
            // Evaluate new quadratic coefficients.
            var b1 = -state.k[state.n - 1] / state.p[state.nn - 1];
            var b2 = -(state.k[state.n - 2] + b1 * state.p[state.n - 1]) / state.p[state.nn - 1];
            var c1 = state.v * b2 * state.a1;
            var c2 = b1 * state.a7;
            var c3 = b1 * b1 * state.a3;
            var c4 = c1 - c2 - c3;
            var temp = a5 + b1 * a4 - c4;
            if (temp != 0) {
                var uu = state.u - (state.u * (c3 + c2) + state.v *
                                    (b1 * state.a1 + b2 * state.a7)) / temp;
                var vv = state.v * (c4 / temp + 1);
                return { uu: uu, vv: vv };
            }
        }
        // If type=3 the quadratic is zeroed.
        return { uu: 0, vv: 0 };
    },


    _quadsd : function (nn, u, v, p) {
        var q = new Array(nn),
            b = q[0] = p[0],
            a = q[1] = p[1] - u * b;
        for (var i = 2; i < nn; ++i) {
            var c = p[i] - u * a - v * b;
            q[i] = c;
            b = a;
            a = c;
        }

        return { q: q, a: a, b: b };
    },


    _quad : function (a, b1, c) {

        var sr = 0, si = 0, lr = 0, li = 0;

        if (a == 0) {
            sr = 0;
            if (b1 != 0) {
                sr = -c / b1;
            }
            lr = 0;

            si = 0;
            li = 0;
            return { sr: sr, si: si, lr: lr, li: li };
        } else if (c == 0) {
            sr = 0;
            lr = -b1 / a;

            si = 0;
            li = 0;
            return { sr: sr, si: si, lr: lr, li: li };
        }

        // Compute discriminant avoiding overflow.
        var b = b1 / 2, d = 0, e = 0;
        if (Math.abs(b) < Math.abs(c)) {
            e = a;
            if (c < 0) {
                e = -a;
            }
            e = b * (b / Math.abs(c)) - e;
            d = Math.sqrt(Math.abs(e)) * Math.sqrt(Math.abs(c));
        } else {
            e = 1 - a / b * (c / b);
            d = Math.sqrt(Math.abs(e)) * Math.abs(b);
        }
        if (e < 0) {
            // complex conjugate zeros
            sr = -b / a;
            lr = sr;
            si = Math.abs(d / a);
            li = -si;
            return { sr: sr, si: si, lr: lr, li: li };
        } else {
            // real zeros
            if (b >= 0) {
                d = -d;
            }
            lr = (-b + d) / a;
            sr = 0;
            if (lr != 0) {
                sr = c / lr / a;
            }
            si = 0;
            li = 0;
            return { sr: sr, si: si, lr: lr, li: li };
        }
    },

    _gcd : function (a, b) {

        if (a < 0) {
            a = -a;
        }
        if (b < 0) {
            b = -b;
        }
        if (a == 0) {
            return b;
        } else if (b == 0) {
            return a;
        } else {
            var r0 = a, r1 = b, r2 = 0;
            while ((r2 = r0 % r1) != 0) {
                r0 = r1;
                r1 = r2;
            }
            return r1;
        }
    },

    _isAnAffineTransformDecomposition : function (obj) {
        return (
            isc.isAn.Object(obj) &&
            isc.isAn.Array(obj.translate) && obj.translate.length == 2 &&
            isc.isA.Number(obj.translate[0]) && isc.isA.Number(obj.translate[1]) &&
            isc.isAn.Array(obj.scale) && obj.scale.length == 2 &&
            isc.isA.Number(obj.scale[0]) && isc.isA.Number(obj.scale[1]) &&
            isc.isA.Number(obj.xShearFactor) &&
            isc.isA.Number(obj.yShearFactor) &&
            isc.isA.Number(obj.rotation) &&
            isc.isAn.Array(obj.rotationCenter) && obj.rotationCenter.length == 2 &&
            isc.isA.Number(obj.rotationCenter[0]) && isc.isA.Number(obj.rotationCenter[1]));
    },

    //> @object AffineTransformDecomposition
    // An object containing properties defining a translation, scale, x-shear, y-shear, and
    // rotation transforms, to be concatenated in that order to construct the equivalent
    // +link{class:AffineTransform,AffineTransform}.
    // @see affineTransform.decompose()
    // @treeLocation Client Reference/Drawing/AffineTransform
    // @visibility customTransform
    //<
    //> @attr affineTransformDecomposition.translate (Array of double[] : [0.0, 0.0] : IRW)
    // Array holds two values representing translation along the x and y dimensions.
    // @visibility customTransform
    //<
    //> @attr affineTransformDecomposition.scale (Array of double[] : [1.0, 1.0] : IRW)
    // Array holds 2 values representing scaling along x and y dimensions.
    // @visibility customTransform
    //<
    //> @attr affineTransformDecomposition.xShearFactor (double : 0.0 : IRW)
    // The slope of an x-shearing transformation.  The shear moves points along the x-axis a
    // distance that is proportional to the initial y-coordinate of the point.
    // @visibility customTransform
    //<
    //> @attr affineTransformDecomposition.yShearFactor (double : 0.0 : IRW)
    // The slope of a y-shearing transformation.  The shear moves points along the y-axis a
    // distance that is proportional to the initial x-coordinate of the point.
    // @visibility customTransform
    //<
    //> @attr affineTransformDecomposition.rotation (double : 0.0 : IRW)
    // Rotation in degrees about the +link{rotationCenter,center point}.
    // The positive direction is clockwise.
    // @visibility customTransform
    //<
    //> @attr affineTransformDecomposition.rotationCenter (Point : [0.0, 0.0] : IRW)
    // The center point of +link{rotation,rotation}.
    // @visibility customTransform
    //<

    // A constructor function for AffineTransformDecomposition objects.
    _affineTransformDecomposition : function (
            translate, scale, xShearFactor, yShearFactor, rotation, rotationCenter)
    {
        this.translate = translate;
        this.scale = scale;
        this.xShearFactor = xShearFactor;
        this.yShearFactor = yShearFactor;
        this.rotation = rotation;
        this.rotationCenter = rotationCenter;

    }
};

//> @class AffineTransform
// An AffineTransform represents a 2-dimensional affine transformation function given by the
// following matrix formula:
// <pre>
// [ m00, m01, m02 ]   [ x ]   [ m00 * x + m01 * y + m02 ]
// [ m10, m11, m12 ] * [ y ] = [ m10 * x + m11 * y + m12 ]
// [   0,   0,   1 ]   [ 1 ]   [                       1 ]
// </pre>
// where the m<sub>ij</sub> are properties of the AffineTransform.  The last row of the matrix
// (0,0,1) and the last entry (1) in the input and output vectors is considered implicit.  No
// extra space is used to store the last rows, and the AffineTransform only needs `x` and `y`
// in a call to +link{affineTransform.transform(),transform()}.
// <p>
// AffineTransform offers the typical means of creating, combining, and manipulating 2D affine
// transformations.  An AffineTransform can also be
// +link{affineTransform.decompose(),decomposed} into the product of basic translation, scale,
// x-shear, y-shear, and rotation transforms.  The order of matrices in this matrix
// decomposition is the same order used to define the +link{class:DrawPane,local transforms}
// of +link{class:DrawItem,DrawItems}.  The decomposition can be recomposed into a new
// AffineTransform by calling +link{classMethod:AffineTransform.recompose()}.
// @treeLocation Client Reference/Drawing
// @visibility customTransform
//<

isc.defineClass("AffineTransform").addClassProperties({
    //> @classMethod affineTransform.getRotateTransform()
    // Returns an AffineTransform that rotates points by the given angle about a center point.
    // @param angle (double) A rotation angle in degrees.  The positive direction is clockwise.
    // @param [center] (Point) An optional point that is fixed in the rotation (default (0, 0)).
    // @return (AffineTransform) the rotation transform
    // @visibility customTransform
    //<

    getRotateTransform : function (angle, cx, cy) {
        if (isc.isAn.Array(cx)) {
            cy = cx[1]; cx = cx[0];
        }
        if (!(isc.isA.Number(cx) && isc.isA.Number(cy))) {
            cx = cy = 0;
        }
        var c = isc.Math.cosdeg(angle),
            s = isc.Math.sindeg(angle);
        return isc.AffineTransform.create(
            c, -s, -c * cx + s * cy + cx,
            s, c, -s * cx - c * cy + cy);
    },

    //> @classMethod affineTransform.getTranslateTransform()
    // Returns an AffineTransform representing a translation.
    // @param dx (double) distance that the translation moves points along the x-axis
    // @param dy (double) distance that the translation moves points along the y-axis
    // @return (AffineTransform) the translation transform
    // @visibility customTransform
    //<
    getTranslateTransform : function (dx, dy) {
        if (isc.isAn.Array(dx)) {
            dy = dx[1]; dx = dx[0];
        }
        if (!(isc.isA.Number(dx) && isc.isA.Number(dy))) {
            dx = dy = 0;
        }
        return isc.AffineTransform.create(1, 0, dx, 0, 1, dy);
    },

    // An internal singleton used to avoid wasting memory storing multiple copies of a trivial
    // transform:
    _identityTransform: isc.AffineTransform.create(),
    _getIdentityTransform : function () {
        return isc.AffineTransform._identityTransform;
    },


    _transformDecomposition: {
        dx: 0, dy: 0, sx: 0, sy: 0, kx: 0, ky: 0, theta: 0, cx: 0, cy: 0,
        h00: 0, h01: 0, h02: 0, h10: 0, h11: 0, h12: 0
    },
    _decomposeTransform : function (transform, cx, cy) {
        var m00 = transform.m00,
            m01 = transform.m01,
            m02 = transform.m02,
            m10 = transform.m10,
            m11 = transform.m11,
            m12 = transform.m12,
            polarDecomp = isc.AffineTransform._polarDecomposition(m00, m01, m10, m11),
            output = isc.AffineTransform._transformDecomposition;

        if (polarDecomp.zeroMatrix) {
            output.sx = output.sy = output.kx = output.ky = output.theta = 0;
            output.dx = output.h02 = m02;
            output.dy = output.h12 = m12;
            output.h00 = output.h01 = output.h10 = output.h11;
            return output;
        }
        var reflected = polarDecomp.reflected,
            theta = polarDecomp.theta,
            c = polarDecomp.cos, s = polarDecomp.sin,
            s00 = polarDecomp.s00, s01 = polarDecomp.s01, s10 = polarDecomp.s10, s11 = polarDecomp.s11,
            detS = (s00 * s11 - s01 * s10);

        // Calculate parameters sx, sy, kx, ky, dx, and dy.
        var sx = 0, sy = 0, kx = 0, ky = 0, dx = 0, dy = 0;
        if (reflected) {
            var c2ms2 = Math.cos(2 * theta),
                twocs = Math.sin(2 * theta);



            // alpha = s * (2 * c - 1) = 2 * c * s - s
            var alpha = twocs - s,
                // beta = ((c + 1) * s^2 + (c - 1) * c^2)
                //      = c * (s^2 + c^2) + (s^2 - c^2)
                //      = c - (c^2 - s^2)
                beta = c - c2ms2,
                gamma = (-cx * beta + cy * alpha),
                delta = (cx * alpha + cy * beta);

            dx = m02 - (s00 * gamma + s01 * delta);
            dy = m12 - (s01 * gamma + s11 * delta);

            sy = twocs * s01 - c2ms2 * s11;

            ky = (c2ms2 * s01 + twocs * s11) / sy;
            sx = -detS / sy;
            kx = (twocs * s00 - c2ms2 * s01) / sx;

        } else {
            var alpha = (cy * s + cx * (1 - c)),
                beta = (-cx * s + cy * (1 - c));
            dx = m02 - (alpha * s00 + beta * s01);
            dy = m12 - (alpha * s01 + beta * s11);

            if (s00 == 0 || s11 == 0 || s01 == 0) {

                sx = s00;
                sy = s11;
                kx = ky = 0;
            } else if (detS == 0) {

                sx = s00;
                sy = s11;
                kx = ky = 0;
            } else {
                // `s00`, `s11`, and `detS` are all greater than zero.
                sx = detS / s11;
                sy = s11;
                kx = s01 / sx;
                ky = s01 / sy;
            }
        }



        output.dx = dx;
        output.dy = dy;
        output.sx = sx;
        output.sy = sy;
        output.kx = kx;
        output.ky = ky;
        output.theta = theta;
        output.cx = cx;
        output.cy = cy;

        // output.h00 = polarDecomp.h00;
        // output.h01 = polarDecomp.h01;
        // output.h10 = (reflected ? -polarDecomp.h10 : polarDecomp.h10);
        // output.h11 = (reflected ? -polarDecomp.h11 : polarDecomp.h11);


        var rightTransformFactor = this.getRotateTransform(-theta * 180 / Math.PI, cx, cy).
                                        rightMultiply(transform);
        output.h00 = rightTransformFactor.m00; output.h10 = rightTransformFactor.m10;
        output.h01 = rightTransformFactor.m01; output.h11 = rightTransformFactor.m11;
        output.h02 = rightTransformFactor.m02; output.h12 = rightTransformFactor.m12;
        return output;
    },


    _polarDecompositionOutput: {
        theta: 0,
        cos: 0, sin: 0,
        u00: 0, u01: 0, u10: 0, u11: 0,
        h00: 0, h01: 0, h10: 0, h11: 0,
        s00: 0, s01: 0, s10: 0, s11: 0,
        reflected: false,
        zeroMatrix: false
    },
    _polarDecomposition : function (m00, m01, m10, m11) {
        var output = isc.AffineTransform._polarDecompositionOutput;
        if (m00 == 0 && m01 == 0 && m10 == 0 && m11 == 0) {
            output.theta = 0;
            output.u00 = output.u11 = output.cos = 1;
            output.u01 = output.u10 = output.sin = 0;
            output.h00 = output.h01 = output.h10 = output.h11 = 0;
            output.s00 = output.s01 = output.s10 = output.s11 = 0;
            output.reflected = false;
            output.zeroMatrix = true;
            return output;
        }

        var epsilon = 1e-9,
            det = m00 * m11 - m01 * m10,
            singular = (Math.abs(det) < epsilon);

        var absDet = Math.abs(det),
            signDet = (det < 0 ? -1 : 1),
            u00 = m00 + signDet * m11,
            u01 = m01 - signDet * m10,
            u10 = m10 - signDet * m01,
            u11 = m11 + signDet * m00,
            detU = u00 * u11 - u01 * u10,
            gamma = Math.sqrt(Math.abs(detU));

        var reflected = output.reflected = (detU < 0),
            theta = output.theta = Math.atan2(u10, u00);
        u00 = output.u00 = u00 / gamma;
        u01 = output.u01 = u01 / gamma;
        u10 = output.u10 = u10 / gamma;
        u11 = output.u11 = u11 / gamma;



        // H = (A^t * A + |det A| * I) / gamma
        var h00 = output.h00 = (m00 * m00 + m10 * m10 + absDet) / gamma,
            h01 = output.h01 = (m00 * m01 + m10 * m11) / gamma,
            h10 = output.h10 = h01,
            h11 = output.h11 = (m01 * m01 + m11 * m11 + absDet) / gamma;

        // S = U * H * U^-1
        var c = output.cos = Math.cos(theta),
            s = output.sin = Math.sin(theta),
            c2 = c * c,
            s2 = s * s,
            // c^2 - s^2 = cos(2 * theta)
            c2ms2 = Math.cos(2 * theta),
            // 2 * c * s = sin(2 * theta)
            twocs = Math.sin(2 * theta),
            s00 = 0, s01 = 0, s10 = 0, s11 = 0;
        if (reflected) {
            s00 = c2 * h00 + twocs * h01 + s2 * h11;
            s01 = -c2ms2 * h01 + c * s * (h00 - h11);
            s10 = s01;
            s11 = c2 * h11 - twocs * h01 + s2 * h00;
        } else {
            s00 = c2 * h00 - twocs * h01 + s2 * h11;
            s01 = c2ms2 * h01 + c * s * (h00 - h11);
            s10 = s01;
            s11 = c2 * h11 + twocs * h01 + s2 * h00;
        }
        var detS = (s00 * s11 - s01 * s10);



        output.s00 = s00;
        output.s01 = s01;
        output.s10 = s10;
        output.s11 = s11;
        return output;
    },

    //> @classMethod affineTransform.recompose()
    // This method is the opposite of +link{affineTransform.decompose()} in that it
    // reconstructs the AffineTransformation from its matrix decomposition.
    // @param decomp (AffineTransformDecomposition) the matrix decomposition
    // @return (AffineTransform) the equivalent affine transformation
    // @visibility customTransform
    //<
    recompose : function (decomp, output) {

        if (output == null) {
            output = isc.AffineTransform.create();
        }
        if (decomp == null) {
            return;
        }

        var dx = 0, dy = 0, sx = 1, sy = 1, kx = 0, ky = 0, theta = 0, cx = 0, cy = 0;
        if (isc.isAn.Array(decomp.translate)) {
            if (isc.isA.Number(decomp.translate[0])) {
                dx = decomp.translate[0];
            }
            if (isc.isA.Number(decomp.translate[1])) {
                dy = decomp.translate[1];
            }
        }
        if (isc.isAn.Array(decomp.scale)) {
            if (isc.isA.Number(decomp.scale[0])) {
                sx = decomp.scale[0];
            }
            if (isc.isA.Number(decomp.scale[1])) {
                sy = decomp.scale[1];
            }
        }
        if (isc.isA.Number(decomp.xShearFactor)) {
            kx = decomp.xShearFactor;
        }
        if (isc.isA.Number(decomp.yShearFactor)) {
            ky = decomp.yShearFactor;
        }
        if (isc.isA.Number(decomp.rotation)) {
            theta = decomp.rotation * Math.PI / 180;
        }
        if (isc.isAn.Array(decomp.rotationCenter)) {
            if (isc.isA.Number(decomp.rotationCenter[0])) {
                cx = decomp.rotationCenter[0];
            }
            if (isc.isA.Number(decomp.rotationCenter[1])) {
                cy = decomp.rotationCenter[1];
            }
        }

        var sin = Math.sin(theta), cos = Math.cos(theta),
            sxsin = sx * sin, sxcos = sx * cos,
            sysin = sy * sin, sycos = sy * cos,
            kxkyp1 = kx * ky + 1,
            kycymcx = ky * cy - cx,
            kycxpcy = ky * cx + cy;

        output.setTransform(
            kx * sxsin + kxkyp1 * sxcos,
            -kxkyp1 * sxsin + kx * sxcos,
            (kx * kycymcx + cy) * sxsin + (kx * kycxpcy + cx) * sx * (1 - cos) + dx,
            sysin + ky * sycos,
            sycos - ky * sysin,
            kycymcx * sysin + kycxpcy * sy * (1 - cos) + dy);
        return output;
    }
});

isc.AffineTransform.addProperties({
    // Start with the identity transform.
    m00: 1, m01: 0, m02: 0,
    m10: 0, m11: 1, m12: 0,

    addPropertiesOnCreate: false,
    init : function (m00, m01, m02, m10, m11, m12) {
        if (
            isc.isA.Number(m00) && isc.isA.Number(m01) && isc.isA.Number(m02) &&
            isc.isA.Number(m10) && isc.isA.Number(m11) && isc.isA.Number(m12))
        {
            this.m00 = m00;
            this.m01 = m01;
            this.m02 = m02;
            this.m10 = m10;
            this.m11 = m11;
            this.m12 = m12;
        } else if (isc.Math._isAnAffineTransformDecomposition(m00)) {
            return isc.AffineTransform.recompose(m00);
        } else {
            var numArgs = arguments.length;
            for (var i = 0; i < numArgs; ++i) {
                var arg = arguments[i];
                if (isc.isAn.Object(arg)) {
                    isc.addProperties(this, arg);
                }
            }
        }
        return this.Super("init", arguments);
    },

    duplicate : function () {
        return isc.AffineTransform.create(
            this.m00, this.m01, this.m02, this.m10, this.m11, this.m12);
    },

    _copy : function (output) {

        output.setTransform(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12);
        return output;
    },

    //> @method affineTransform.getDeterminant()
    // Returns the <a href="http://en.wikipedia.org/wiki/Determinant">determinant</a> of this
    // transform's matrix.
    // @return (double) the determinant of the matrix
    // @visibility customTransform
    //<
    getDeterminant : function () {
        return this.m00 * this.m11 - this.m10 * this.m01;
    },

    //> @method affineTransform.getInverse()
    // Returns the <a href="http://en.wikipedia.org/wiki/Invertible_matrix">inverse matrix</a>
    // to this transform's matrix, or <code>null</code> if the inverse does not exist.
    // @return (AffineTransform) a new AffineTransform storing the inverse transformation
    // @visibility customTransform
    //<
    getInverse : function (output) {

        var det = this.getDeterminant(),
            isInvertible = isc.isA.Number(det) && det != 0;

        if (!isInvertible) return null;

        if (output == null) {
            output = isc.AffineTransform.create();
        }
        output.setTransform(
            this.m11 / det,
            -this.m01 / det,
            (this.m01 * this.m12 - this.m11 * this.m02) / det,
            -this.m10 / det,
            this.m00 / det,
            (this.m10 * this.m02 - this.m00 * this.m12) / det);
        return output;
    },

    //> @method affineTransform.leftMultiply()
    // Multiplies the matrix of this transformation by the matrix of another transformation,
    // on the left.  The resulting transformation is saved back onto this AffineTransform
    // object.
    // <p>
    // The matrix formula is as follows:
    // <pre>
    //                    [ t00, t01, t02 ]   [ m00, m01, m02 ]
    // transform * this = [ t10, t11, t12 ] * [ m10, m11, m12 ] =
    //                    [   0,   0,   1 ]   [   0,   0,   1 ]
    //
    //     [ t00 * m00 + t01 * m10, t00 * m01 + t01 * m11, t00 * m02 + t01 * m12 + t02 ]
    //     [ t10 * m00 + t11 * m10, t10 * m01 + t11 * m11, t10 * m02 + t11 * m12 + t12 ]
    //     [                     0,                     0,                           1 ]
    // <pre>
    // @param transform (AffineTransform)
    // @visibility customTransform
    //<
    leftMultiply : function (transform) {

        var m0 = this.m00,
            m1 = this.m10;
        this.m00 = transform.m00 * m0 + transform.m01 * m1;
        this.m10 = transform.m10 * m0 + transform.m11 * m1;

        m0 = this.m01;
        m1 = this.m11;
        this.m01 = transform.m00 * m0 + transform.m01 * m1;
        this.m11 = transform.m10 * m0 + transform.m11 * m1;

        m0 = this.m02;
        m1 = this.m12;
        this.m02 = transform.m00 * m0 + transform.m01 * m1 + transform.m02;
        this.m12 = transform.m10 * m0 + transform.m11 * m1 + transform.m12;
        return this;
    },

    //> @method affineTransform.rightMultiply()
    // Multiplies the matrix of this transformation by the matrix of another transformation,
    // on the right.  The resulting transformation is saved back onto this AffineTransform
    // object.
    // <p>
    // The matrix formula is as follows:
    // <pre>
    //                    [ m00, m01, m02 ]   [ t00, t01, t02 ]
    // this * transform = [ m10, m11, m12 ] * [ t10, t11, t12 ] =
    //                    [   0,   0,   1 ]   [   0,   0,   1 ]
    //
    //      [ m00 * t00 + m01 * t10, m00 * t01 + m01 * t11, m00 * t02 + m01 * t12 + m02 ]
    //      [ m10 * t00 + m11 * t10, m10 * t01 + m11 * t11, m10 * t02 + m11 * t12 + m12 ]
    //      [                     0,                     0,                           1 ]
    // </pre>
    // @param transform (AffineTransform)
    // @visibility customTransform
    //<
    rightMultiply : function (transform) {

        var mx = this.m00,
            my = this.m01;
        this.m00 = mx * transform.m00 + my * transform.m10;
        this.m01 = mx * transform.m01 + my * transform.m11;
        this.m02 = mx * transform.m02 + my * transform.m12 + this.m02;

        mx = this.m10;
        my = this.m11;
        this.m10 = mx * transform.m00 + my * transform.m10;
        this.m11 = mx * transform.m01 + my * transform.m11;
        this.m12 = mx * transform.m02 + my * transform.m12 + this.m12;
        return this;
    },

    //> @method affineTransform.preRotate()
    // Left-multiplies a rotation matrix onto the matrix of this affine transform.
    // @param angle (double) the angle in degrees
    // @param [cx] (double) X coordinate of the center of rotation
    // @param [cy] (double) Y coordinate of the center of rotation
    // @visibility customTransform
    //<
    preRotate : function (angle, cx, cy) {
        if (isc.isAn.Array(cx)) {
            cy = cx[1]; cx = cx[0];
        }
        if (!(isc.isA.Number(cx) && isc.isA.Number(cy))) {
            cx = cy = 0;
        }
        return this.leftMultiply(isc.AffineTransform.getRotateTransform(angle, cx, cy));
    },

    //> @method affineTransform.rotate()
    // Adds a rotation transform to this affine transform.
    // @param angle (double) the angle in degrees.
    // @param [cx] (double) X coordinate of the center of rotation.
    // @param [cy] (double) Y coordinate of the center of rotation.
    // @visibility customTransform
    //<
    rotate : function (angle, cx, cy) {
        if (isc.isAn.Array(cx)) {
            cy = cx[1]; cx = cx[0];
        }
        if (!(isc.isA.Number(cx) && isc.isA.Number(cy))) {
            cx = cy = 0;
        }
        return this.rightMultiply(isc.AffineTransform.getRotateTransform(angle, cx, cy));
    },

    //> @method affineTransform.preScale()
    // Left-multiplies a scaling matrix onto the matrix of this affine transform:
    // <pre>
    // [ sx,  0, 0 ]   [ m00, m01, m02 ]   [ sx * m00, sx * m01, sx * m02 ]
    // [  0, sy, 0 ] * [ m10, m11, m12 ] = [ sy * m10, sy * m11, sy * m12 ]
    // [  0,  0, 1 ]   [   0,   0,   1 ]   [        0,        0,        1 ]
    // </pre>
    // @param sx (double) the factor by which points are scaled along the x-axis
    // @param sy (double) the factor by which points are scaled along the y-axis
    // @visibility customTransform
    //<
    preScale : function (sx, sy) {

        this.m00 *= sx; this.m01 *= sx; this.m02 *= sx;
        this.m10 *= sy; this.m11 *= sy; this.m12 *= sy;
        return this;
    },

    //> @method affineTransform.scale()
    // Adds a scaling transform to this affine transform:
    // <pre>
    // [ m00, m01, m02 ]   [ sx,  0, 0 ]   [ m00 * sx, m01 * sy, m02 ]
    // [ m10, m11, m12 ] * [  0, sy, 0 ] = [ m10 * sx, m11 * sy, m12 ]
    // [   0,   0,   1 ]   [  0,  0, 1 ]   [        0,        0,   1 ]
    // </pre>
    // @param sx (double) the factor by which points are scaled along the x-axis
    // @param sy (double) the factor by which points are scaled along the y-axis
    // @visibility customTransform
    //<
    scale : function (sx, sy) {

        this.m00 *= sx; this.m01 *= sy;
        this.m10 *= sx; this.m11 *= sy;
        return this;
    },

    //> @method affineTransform.preShear()
    // Left-multiplies a shearing transform onto the matrix of this affine transform that
    // simultaneously applies shear in the x- and y-directions:
    // <pre>
    // [  1, kx, 0 ]   [ m00, m01, m02 ]   [ kx * m10 + m00, kx * m11 + m01, kx * m12 + m02 ]
    // [ ky,  1, 0 ] * [ m10, m11, m12 ] = [ ky * m00 + m10, ky * m01 + m11, ky * m02 + m12 ]
    // [  0,  0, 1 ]   [   0,   0,   1 ]   [              0,              0,              1 ]
    // </pre>
    // @param kx (double) the slope of the x-shear
    // @param ky (double) the slope of the y-shear
    // @visibility customTransform
    //<
    preShear : function (kx, ky) {

        var m00 = this.m00, m01 = this.m01, m02 = this.m02;
        this.m00 += kx * this.m10;
        this.m01 += kx * this.m11;
        this.m02 += kx * this.m12;
        this.m10 += ky * m00;
        this.m11 += ky * m01;
        this.m12 += ky * m02;
        return this;
    },

    //> @method affineTransform.shear()
    // Adds a shearing transform to this affine transform that simultaneously shifts points
    // along the x-axis a distance proportional to their y-coordinates and shifts along the
    // y-axis a distance proportional to their x-coordinates:
    // <pre>
    // [ m00, m01, m02 ]   [  1, kx, 0 ]   [ ky * m01 + m00, kx * m00 + m01, m02 ]
    // [ m10, m11, m12 ] * [ ky,  1, 0 ] = [ ky * m11 + m10, kx * m10 + m11, m12 ]
    // [   0,   0,   1 ]   [  0,  0, 1 ]   [              0,              0,   1 ]
    // </pre>
    // @param kx (double) the slope of the x-shear
    // @param ky (double) the slope of the y-shear
    // @visibility customTransform
    //<
    shear : function (kx, ky) {

        var m00 = this.m00, m10 = this.m10;
        this.m00 += ky * this.m01;
        this.m01 += kx * m00;
        this.m10 += ky * this.m11;
        this.m11 += kx * m10;
        return this;
    },

    //> @method affineTransform.preTranslate()
    // Left-multiplies a translation transform onto the matrix of this affine transform:
    // <pre>
    // [ 1, 0, dx ]   [m00, m01, m02 ]   [ m00, m01, m02 + dx ]
    // [ 0, 1, dy ] * [m10, m11, m12 ] = [ m10, m11, m12 + dy ]
    // [ 0, 0,  1 ]   [  0,   0,   1 ]   [   0,   0,        1 ]
    // </pre>
    // @param dx (double) the distance by which points are translated along the x-axis
    // @param dy (double) the distance by which points are translated along the y-axis
    // @visibility customTransform
    //<
    preTranslate : function (dx, dy) {

        this.m02 += dx;
        this.m12 += dy;
        return this;
    },

    //> @method affineTransform.translate()
    // Adds a translation transform to this affine transform:
    // <pre>
    // [ m00, m01, m02 ]   [ 1, 0, dx ]   [ m00, m01, m00 * dx + m01 * dy + m02 ]
    // [ m10, m11, m12 ] * [ 0, 1, dy ] = [ m10, m11, m10 * dx + m11 * dy + m12 ]
    // [   0,   0,   1 ]   [ 0, 0,  1 ]   [   0,   0,                         1 ]
    // </pre>
    // @param dx (double) the distance by which points are translated along the x-axis
    // @param dy (double) the distance by which points are translated along the y-axis
    // @visibility customTransform
    //<
    translate : function (dx, dy) {

        this.m02 += this.m00 * dx + this.m01 * dy;
        this.m12 += this.m10 * dx + this.m11 * dy;
        return this;
    },

    isTranslate : function (epsilon) {
        epsilon = epsilon || 1e-9;
        return Math.abs(this.m00 - 1) < epsilon && Math.abs(this.m01)     < epsilon &&
               Math.abs(this.m10)     < epsilon && Math.abs(this.m11 - 1) < epsilon;
    },

    //> @method affineTransform.preXShear()
    // Left-multiplies a shearing transform onto the matrix of this affine transform that
    // shifts points along the x-axis a distance proportional to their y-coordinates:
    // <pre>
    // [ 1, kx, 0 ]   [ m00, m01, m02 ]   [ kx * m10 + m00, kx * m11 + m01, kx * m12 + m02 ]
    // [ 0,  1, 0 ] * [ m10, m11, m12 ] = [            m10,            m11,            m12 ]
    // [ 0,  0, 1 ]   [   0,   0,   1 ]   [              0,              0,              1 ]
    // </pre>
    // @param kx (double) the slope of the x-shearing transformation
    // @visibility customTransform
    //<
    preXShear : function (kx) {

        this.m00 += kx * this.m10;
        this.m01 += kx * this.m11;
        this.m02 += kx * this.m12;
        return this;
    },

    //> @method affineTransform.xShear()
    // Adds a shearing transform to this affine transform that shifts points along the x-axis
    // a distance proportional to their y-coordinates:
    // <pre>
    // [ m00, m01, m02 ]   [ 1, kx, 0 ]   [ m00, m01 + kx * m00, m02 ]
    // [ m10, m11, m12 ] * [ 0,  1, 0 ] = [ m10, m11 + kx * m10, m12 ]
    // [   0,   0,   1 ]   [ 0,  0, 1 ]   [   0,              0,   1 ]
    // </pre>
    // @param kx (double) the slope of the x-shearing transformation
    // @visibility customTransform
    //<
    xShear : function (kx) {

        this.m01 += kx * this.m00;
        this.m11 += kx * this.m10;
        return this;
    },

    //> @method affineTransform.preYShear()
    // Left-multiplies a shearing transform onto the matrix of this affine transform that
    // shifts points along the y-axis a distance proportional to their x-coordinates:
    // <pre>
    // [  1, 0, 0 ]   [ m00, m01, m02 ]   [            m00,            m01,            m02 ]
    // [ ky, 1, 0 ] * [ m10, m11, m12 ] = [ ky * m00 + m10, ky * m01 + m11, ky * m02 + m12 ]
    // [  0, 0, 1 ]   [   0,   0,   1 ]   [              0,              0,              1 ]
    // </pre>
    // @param ky (double) the slope of the y-shearing transformation
    // @visibility customTransform
    //<
    preYShear : function (ky) {

        this.m10 += ky * this.m00;
        this.m11 += ky * this.m01;
        this.m12 += ky * this.m02;
        return this;
    },

    //> @method affineTransform.yShear()
    // Adds a shearing transform to this affine transform that shifts points along the y-axis
    // a distance proportional to their x-coordinates:
    // <pre>
    // [ m00, m01, m02 ]   [  1, 0, 0 ]   [ ky * m01 + m00, m01, m02 ]
    // [ m10, m11, m12 ] * [ ky, 1, 0 ] = [ ky * m11 + m10, m11, m12 ]
    // [   0,   0,   1 ]   [  0,  , 1 ]   [              0,   0,   1 ]
    // </pre>
    // @param ky (double) the slope of the y-shearing transformation
    // @visibility customTransform
    //<
    yShear : function (ky) {

        this.m00 += ky * this.m01;
        this.m10 += ky * this.m11;
        return this;
    },

    //> @method affineTransform.transform()
    // Applies this affine transform to the point <code>(v0,v1)</code> and returns the
    // transformed point:
    // <pre>
    // [ m00, m01, m02 ]   [ v0 ]   [ m00 * v0 + m01 * v1 + m02 ]
    // [ m10, m11, m12 ] * [ v1 ] = [ m10 * v0 + m11 * v1 + m12 ]
    // [   0,   0,   1 ]   [  1 ]   [                         1 ]
    // </pre>
    // @param v0 (double) the x-coordinate of the point to be transformed
    // @param v1 (double) the y-coordinate of the point to be transformed
    // @return (Point) the transformed point
    // @visibility customTransform
    //<
    transform : function (v0, v1, output) {
        if (isc.isAn.Array(v0)) {
            output = v1; v1 = v0[1]; v0 = v0[0];
        }
        if (!isc.isAn.Array(output)) {
            output = new Array(2);
        }
        output[0] = this.m00 * v0 + this.m01 * v1 + this.m02;
        output[1] = this.m10 * v0 + this.m11 * v1 + this.m12;
        return output;
    },

    //> @method affineTransform.setTransform()
    // Sets the matrix of this affine transform to the matrix specified by six numbers.
    // @param m00 (double) the (0,0)-entry of the matrix
    // @param m01 (double) the (0,1)-entry of the matrix
    // @param m02 (double) the (0,2)-entry of the matrix
    // @param m10 (double) the (1,0)-entry of the matrix
    // @param m11 (double) the (1,1)-entry of the matrix
    // @param m12 (double) the (1,2)-entry of the matrix
    // @visibility customTransform
    //<
    setTransform : function (m00, m01, m02, m10, m11, m12) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
    },

    //> @method affineTransform.decompose()
    // Decomposes the AffineTransform into the product of translation, scale, x-shear, y-shear,
    // and rotation transforms:
    // <pre>
    // [ m00, m01, m02 ]
    // [ m10, m11, m12 ] =
    // [   0,   0,   1 ]
    //
    //      [ 1, 0, translate[0] ]   [ scale[0],        0, 0 ]   [ 1, xShearFactor, 0 ]
    //      [ 0, 1, translate[1] ] * [        0, scale[1], 0 ] * [ 0,            1, 0 ] *
    //      [ 0, 0,            1 ]   [        0,        0, 1 ]   [ 0,            0, 1 ]
    //
    //          [            1, 0, 0 ]
    //          [ yShearFactor, 1, 0 ] * R
    //          [            0, 0, 1 ]
    // </pre>
    // where the rotation matrix <code>R</code> produces rotation about an optional center
    // point (default (0, 0)):
    // <pre>
    //     [ 1, 0, center[0] ]   [ cos(theta), -sin(theta), 0 ]   [ 1, 0, -center[0] ]
    // R = [ 0, 1, center[1] ] * [ sin(theta),  cos(theta), 0 ] * [ 0, 1, -center[1] ]
    //     [ 0, 0,         1 ]   [          0,           0, 1 ]   [ 0, 0,          1 ]
    // </pre>
    // and <code>theta</code> is the equivalent in radians of the degrees of rotation.
    // <p>
    // Note that the order of the translation/scale/shear/rotation transforms is the same as
    // the +link{class:DrawPane,local transforms} of +link{class:DrawItem,DrawItems}.
    // @param [center] (Point) an optional center point of rotation
    // @return (AffineTransformDecomposition) an object consisting of the variables in the
    // above matrix formula
    // @visibility customTransform
    //<
    decompose : function (cx, cy) {
        if (isc.isAn.Array(cx)) {
            cy = cx[1]; cx = cx[0];
        }
        if (!(isc.isA.Number(cx) && isc.isA.Number(cy))) {
            cx = cy = 0;
        }
        var decomp = isc.AffineTransform._decomposeTransform(this, cx, cy);
        return new isc.Math._affineTransformDecomposition(
            [decomp.dx, decomp.dy], [decomp.sx, decomp.sy], decomp.kx, decomp.ky,
            decomp.theta * 180 / Math.PI, [cx, cy]);
    }
});
// NOTE: toString functions CANNOT be added by addMethods, because a property named "toString"
// will not be enumerated by for..in.  This is actually part of the ECMAScript standard!

isc.AffineTransform.getPrototype().toString = function () {
    return isc.StringBuffer.concat(
        "[", this.m00.toFixed(5), ", ", this.m01.toFixed(5), ", ", this.m02.toFixed(5), "]\n",
        "[", this.m10.toFixed(5), ", ", this.m11.toFixed(5), ", ", this.m12.toFixed(5), "]");
};







//> @class DateUtil
// Static singleton class containing APIs for interacting with Dates.
// @treeLocation Client Reference/System
// @visibility external
//<

isc.defineClass("DateUtil");

isc.DateUtil.addClassMethods({

    _min : function (date1, date2) {

        return (date1.getTime() < date2.getTime() ? date1 : date2);
    },

    _max : function (date1, date2) {

        return (date1.getTime() < date2.getTime() ? date2 : date1);
    },

    //>    @classMethod DateUtil.format()
    // Return the parameter date formatted according to the parameter +link{type:FormatString}.
    // This method is used to implement the +link{DataSourceField.format,DataSourceField.format}
    // functionality, but it can also be used to format arbitrary dates programmatically.
    // @group dateFormatting
    // @param date (Date) The date to format
    // @param format (FormatString) The format to apply to this date
    // @return (String) formatted date string
    // @visibility external
    //<

    format : function (date, format, useCustomTimezone) {

        // bail if the passed date is null or not a Date
        if (!date || !isc.isA.Date(date)) return "";

        if (!isc.isA.String(format)) {
            isc.logWarn("Cannot use Date format '" + format + "' - not a String");
            return date.toString();
        }

        // duplicate() the passed date because it may be shifted according to timezone
        var localDate = isc.isA.Date(date) ? date.duplicate() : date;

        // if useCustomTimezone is specifically false, don't apply the date offset
        if (useCustomTimezone != false) {
            if (isc.isA.Date(localDate) && isc.Time._customTimezone) {
                // shift the date into the custom timezone before formatting
                localDate = isc.DateUtil._getDisplayOffsetDate(localDate);
            }
        }

        var p = function p(s) {
            return (s.toString().length == 1) ? "0" + s : s;
        };

        return format ? format.replace(/dd?d?d?|EE?E?E?|MM?M?M?|yy?y?y?|YY?Y?Y?|LL?L?L?|ww?|CC?|cc?|DD?|hh?|HH?|mm?|ss?|SS?S?|a|u|'[^']*'/g,
        function (innerFormat) {
            switch (innerFormat) {
            case "hh":
                var hour = localDate.getHours();
                if (format.contains("a") && hour == 0) hour = 12;
                return p(hour < 13 ? hour : (hour - 12));
            case "h":
                var hour = localDate.getHours();
                if (format.contains("a") && hour == 0) hour = 12;
                return hour < 13 ? hour : (hour - 12);
            case "HH":
                var hour = localDate.getHours();
                if (format.contains("a") && hour == 0) hour = 12;
                return p(hour);
            case "H":
                var hour = localDate.getHours();
                if (format.contains("a") && hour == 0) hour = 12;
                return hour;
            case "mm":
                return p(localDate.getMinutes());
            case "m":
                return localDate.getMinutes();
            case "ss":
                return p(localDate.getSeconds());
            case "s":
                return localDate.getSeconds();
            case "SSS":
                var millis = localDate.getMilliseconds();
                return millis >= 100 ? millis : (millis >= 10 ? "0" + millis : "00" + millis);
            case "SS":
                var millis = localDate.getMilliseconds();
                return millis >= 10 ? millis : "0" + millis;
            case "S":
                return localDate.getMilliseconds();
            case "yyyy":
                return localDate.getFullYear();
            case "yy":
                return localDate.getFullYear().toString().substring(2, 4);
            case "YYYY":
                return isc.DateUtil.getWeekNumber(localDate)[0];
            case "YY":
                return isc.DateUtil.getWeekNumber(localDate)[0].toString().substring(2, 4);
            case "dddd":
            case "EEEE":
                return localDate.getDayName();
            case "ddd":
            case "E":
            case "EE":
            case "EEE":
                return localDate.getShortDayName();
            case "dd":
                return p(localDate.getDate());
            case "d":
                return localDate.getDate().toString();
            case "DD":
                return p(isc.DateUtil.getDayNumber(localDate));
            case "D":
                return isc.DateUtil.getDayNumber(localDate).toString();
            case "u":
                return (localDate.getDay() || 7) + "";
            case "MMMM":
                return localDate.getMonthName();
            case "MMM":
                return localDate.getShortMonthName();
            case "MM":
                return p((localDate.getMonth() + 1));
            case "M":
                return localDate.getMonth() + 1;
            case "w":
                return isc.DateUtil.getWeekNumber(localDate)[1];
            case "ww":
                return p(isc.DateUtil.getWeekNumber(localDate)[1]);
            case "a":
                return localDate.getHours() < 12 ? isc.Time.AMIndicator : isc.Time.PMIndicator;
            case "''":
                return "'";
            default:

                return innerFormat[0] === "'" && innerFormat[innerFormat.length - 1] === "'" ?
                    innerFormat.slice(1, -1) : "";
            }
        }
        ) : "";
    },

    getWeekNumber : function(date) {
        var d = new Date(date);
        d.setHours(0,0,0);
        // The ISO standard is: the first week of a year is the one that contains the year's
        // first Thursday.  http://en.wikipedia.org/wiki/ISO-8601#Week_dates
        d.setDate(d.getDate() + 4 - (d.getDay()||7));
        // Get first day of year
        var yearStart = new Date(d.getFullYear(),0,1);
        // Calculate full weeks to nearest Thursday
        var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
        // Return array of year and week number
        return [d.getFullYear(), weekNo];
    },

    getDayNumber : function(date) {
        var d = new Date(date);
        d.setHours(0,0,0);
        var yearStart = new Date(d.getFullYear(),0,1);
        return Math.ceil(((d - yearStart) / 86400000) + 1);
    },

    //> @classMethod DateUtil.createLogicalDate()
    // Create a new Date to represent a logical date value (rather than a specific datetime value),
    // typically for display in a +link{DataSourceField.type,date type field}. The generated
    // Date value will have year, month and date set to the specified values
    // (in browser native local time).
    // @param year (int) full year
    // @param month (int) month (zero based, so 0 is January)
    // @param date (int) date within the month
    // @return (Date) new javascript Date object representing the Date in question
    // @visibility external
    //<
    // For logical dates, the only requirement for the "time" component value is that the
    // date shows up correctly in local time.

    createLogicalDate : function (year, month, date, suppressConversion) {
        // first param can be a Date - if it's null, assume new Date()
        if (year == null) year = new Date();
        if (isc.isA.Date(year)) {
            // update the date-parts if they weren't also passed - means you can, for example,
            // get a logicalDate for the 1st of this month in one step
            // - createLogicalDate(null, null, 1)
            year = year.duplicate();
            if (date == null) date = year.getDate();
            if (month == null) month = year.getMonth();
            year = year.getFullYear();
        }
        var d = new Date();
        d.setHours(12, 0, 0, 0);
        year = (year != null ? year : d.getFullYear());
        month = (month != null ? month : d.getMonth());
        date = (date != null ? date : d.getDate());
        d.setFullYear(year, month, date);

        if (suppressConversion) {
            // If the 'suppressConversion' flag was passed, we will want to return null to indicate
            // we were passed an invalid date if the values passed in had to be converted
            // (For example a month of 13 effecting the year, etc)
            var isValid = (d.getFullYear() == year &&
                           d.getMonth() == month &&
                           d.getDate() == date );
            if (!isValid) return null;
        }

        d.logicalDate = true;
        return d;
    },

    //> @classMethod DateUtil.getDisplayYear()
    // Returns the full year from the passed datetime, as it will be displayed to the user.
    // This might not be the same value as that returned by getFullYear() if a
    // +link{Time.setDefaultDisplayTimezone(), custom timezone}
    // has been applied.  Only necessary for datetimes - for logical dates and times, this
    // method returns the same value as getFullYear().
    // @param datetime (Date) datetime instance to work with
    // @return (int) the 4-digit display year from the passed datetime
    // @visibility external
    //<
    getDisplayYear : function (datetime) {
        return this.getLogicalDateOnly(datetime).getFullYear();
    },

    //> @classMethod DateUtil.getDisplayMonth()
    // Returns the month number from the passed datetime, as it will be displayed to the user.
    // This might not be the same value as that returned by getMonth() if a
    // +link{Time.setDefaultDisplayTimezone(), custom timezone}
    // has been applied.  Only necessary for datetimes - for logical dates and times, this
    // method returns the same value as getMonth().
    // @param datetime (Date) datetime instance to work with
    // @return (int) the month number from the passed datetime
    // @visibility external
    //<
    getDisplayMonth : function (datetime) {
        //return date._getTimezoneOffsetDate(isc.Time.getUTCHoursDisplayOffset(date),
        //    isc.Time.getUTCMinutesDisplayOffset(date)).getUTCMonth() + 1;
        return this.getLogicalDateOnly(datetime).getMonth();
    },

    //> @classMethod DateUtil.getDisplayDay()
    // Returns the day of month from the passed datetime, as it will be displayed to the user.
    // This might not be the same value as that returned by getDate() if a
    // +link{Time.setDefaultDisplayTimezone(), custom timezone}
    // has been applied.  Only necessary for datetimes - for logical dates and times, this
    // method returns the same value as getDate().
    // @param datetime (Date) datetime instance to work with
    // @return (int) the day of month from the passed datetime
    // @visibility external
    //<
    getDisplayDay : function (datetime) {
        return this.getLogicalDateOnly(datetime).getDate();
    },

    //> @classMethod DateUtil.getDisplayHours()
    // Returns the hours value from the passed datetime, as it will be displayed to the user.
    // This might not be the same value as that returned by getHours() if a
    // +link{Time.setDefaultDisplayTimezone(), custom timezone}
    // has been applied.  Only necessary for datetimes - for logical dates and times, this
    // method returns the same value as getHours().
    // @param datetime (Date) datetime instance to work with
    // @return (int) the hours value from the passed datetime
    // @visibility external
    //<
    getDisplayHours : function (datetime) {
        return this.getLogicalTimeOnly(datetime).getHours();
    },

    //> @classMethod DateUtil.getDisplayMinutes()
    // Returns the minutes value from the passed datetime, as it will be displayed to the user.
    // This might not be the same value as that returned by getMinutes() if a
    // +link{Time.setDefaultDisplayTimezone(), custom timezone}
    // has been applied.  Only necessary for datetimes - for logical dates and times, this
    // method returns the same value as getMinutes().
    // @param datetime (Date) datetime instance to work with
    // @return (int) the minutes value from the passed datetime
    // @visibility external
    //<
    getDisplayMinutes : function (datetime) {
        return this.getLogicalTimeOnly(datetime).getMinutes();
    },

    getDisplaySeconds : function (datetime) {
        return this.getLogicalTimeOnly(datetime).getSeconds();
    },

    getDisplayMilliseconds : function (datetime) {
        return this.getLogicalTimeOnly(datetime).getMilliseconds();
    }

});

//>    @object Date
//
//    Extensions to the Date class, including added static methods on the Date object, and
//  additional instance methods available on all date instances.
//
//  @treeLocation Client Reference/System
//  @visibility external
//<

//>    @staticMethod isc.timeStamp()
//  Shorthand for <code>new Date().getTime();</code>, this returns a timeStamp - a large number
//  which is incremented by 1 every millisecond.  Can be used to generate unique identifiers,
//  or perform timing tasks.
//
//  @visibility external
//    @return    (int)    a large integer (actually the number of milliseconds since 1/1/1970)
//<

isc.addGlobal("timeStamp", function () {

    return new Date().getTime()
});


// synonym
isc.addGlobal("timestamp", isc.timeStamp);


  //>DEBUG
// This lets us label methods with a name within addMethods
Date.prototype.Class = "Date";
Date.Class = "Date";
  //<DEBUG


isc.Date = Date;


isc.DateUtil.addClassProperties({
    // add a constant for an error message when attempting to convert an invalid string to a
    // date
    INVALID_DATE_STRING:"Invalid date format"
});


//
// add methods to DateUtil for parsing additional formats
//
isc.DateUtil.addClassMethods({

//> @classMethod DateUtil.newInstance()
// Cover function for creating a date in the 'Isomorphic-style',
//     eg: DateUtil.newInstance(args)
// rather than new Date(args)
// @return             (Date)  Date object
// @deprecated As of SmartClient 5.5, use +link{DateUtil.create}.
//<
newInstance : function (arg1, arg2, arg3, arg4, arg5, arg6, arg7) {
    return new Date(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
},


//>    @classMethod DateUtil.create()
//  Create a new <code>Date</code> object - synonym for <code>new Date(arguments)</code>
//    @return (Date) Date object
//  @visibility external
//<
create : function (arg1, arg2, arg3, arg4, arg5, arg6, arg7) {
    // handle being passed a subset of parameters
    // Note that passing undefined into new Date() results in an invalid date where
    // getTime() returns NaN
    var undef;
    if (arg1 === undef) return new Date();
    if (arg2 === undef) return new Date(arg1);
    if (arg3 === undef) arg3 = 0;
    if (arg4 === undef) arg4 = 0;
    if (arg5 === undef) arg5 = 0;
    if (arg6 === undef) arg6 = 0;
    if (arg7 === undef) arg7 = 0;
    return new Date(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
},

//> @classMethod DateUtil.createLogicalTime()
// Create a new Date object to represent a logical time value (rather than a specific datetime
// value), typically for display in a +link{DataSourceField.type,time type field}. The generated
// Date value will have year, month and date set to the epoch date (Jan 1 1970), and time
// elements set to the supplied hour, minute and second (in browser native local time).
// @param hour (int) hour (0-23)
// @param minute (int) minute (0-59)
// @param second (int) second (0-59)
// @return (Date) new Javascript Date object representing the time in question
// @visibility external
//<
// This is a synonym for Time.createLogicalTime();
createLogicalTime : function (hour, minute, second, millisecond) {
    return isc.Time.createLogicalTime(hour,minute,second,millisecond);
},

createDatetime : function (year, month, date, hours, minutes, seconds, milliseconds, suppressConversion) {
    if (year == null) {
        // support passing no year to default to new Date() - assign it as the
        // year param so the isA.Date(year) condition below deals with it
        year = new Date();
    }
    if (isc.isA.Date(year)) {
        // support passing a date object as the year param
        if (hours == null) hours = year.getHours();
        if (minutes == null) minutes = year.getMinutes();
        if (seconds == null) seconds = year.getSeconds();
        if (milliseconds == null) milliseconds = year.getMilliseconds();
        if (date == null) date = year.getDate();
        if (month == null) month = year.getMonth();
        year = year.getFullYear();
    }
    var hasHours = hours != null,
        hasMinutes = minutes != null,
        hasSeconds = seconds != null;

    // Handle being passed strings
    if (isc.isA.String(hours)) hours = parseInt(hours || 12, 10);
    if (isc.isA.String(minutes)) minutes = parseInt(minutes || 0, 10);
    if (isc.isA.String(seconds)) seconds = parseInt(seconds || 0, 10);

    var newDate;
    if (!isc.Time._customTimezone) {
        newDate = new Date(year, month, date);
        if (hasHours) {
            if (milliseconds != null) newDate.setHours(hours, minutes, seconds, milliseconds);
            else if (hasSeconds) newDate.setHours(hours, minutes, seconds);
            else if (hasMinutes) newDate.setHours(hours, minutes);
            else newDate.setHours(hours);
        }

        if (!suppressConversion) return newDate;

        // If the 'suppressConversion' flag was passed, we will want to return null to indicate
        // we were passed an invalid date if the values passed in had to be converted
        // (For example a month of 13 effecting the year, etc)
        var isValid = (newDate.getFullYear() == year &&
                       newDate.getMonth() == month &&
                       newDate.getDate() == date &&
                       (!hasHours || newDate.getHours() == hours) &&
                       (!hasMinutes || newDate.getMinutes() == minutes) &&
                       (!hasSeconds || newDate.getSeconds() == seconds)
                       );
        return (isValid ? newDate : null);
    } else {

        // We need a date where the UTCTime is set such that when we apply our
        // custom timezone offset we get back the local time.
        // Do this by creating a new date with UTC time matching this custom display time
        // and then shifting that date by the inverse of our display timezone offset.
        if (hours == null) hours = 0;
        if (minutes == null) minutes = 0;
        if (seconds == null) seconds = 0;
        if (milliseconds == null) milliseconds = 0;

        newDate = new Date(Date.UTC(year, month, date, hours, minutes, seconds, milliseconds));
        // If the 'suppressConversion' flag was passed, we will want to return null to indicate
        // we were passed an invalid date if the values passed in had to be converted
        // (For example a month of 13 effecting the year, etc)
        // Easiest to check this against the date before we apply the offset to correct for
        // our timezone
        if (suppressConversion) {
            var isValid = (newDate.getUTCFullYear() == year &&
                           newDate.getUTCMonth() == month &&
                           newDate.getUTCDate() == date &&
                           (!hasHours || newDate.getUTCHours() ==hours) &&
                           (!hasMinutes || newDate.getUTCMinutes() == minutes) &&
                           (!hasSeconds || newDate.getUTCSeconds() == seconds)
                           );
            if (!isValid) newDate = null;
        }
        if (newDate != null) {
            // Subtract the UTCHoursDisplayOffset and UTCMinutesDisplayOffset, then adjust
            // for DST if required.

            newDate._applyTimezoneOffset(
                -isc.Time.UTCHoursDisplayOffset,
                -isc.Time.UTCMinutesDisplayOffset
            );

            newDate._applyTimezoneOffset(-isc.Time.getUTCHoursDisplayOffset(newDate, 0),
                                         -isc.Time.getUTCMinutesDisplayOffset(newDate, 0));
        }
        return newDate;
    }
},

// Return a new date that reflects the supplied date adjusted for the display timezone.

_getDisplayOffsetDate : function (datetime) {
    if (datetime == null) return null;
    var displayDate = datetime._getTimezoneOffsetDate(
        isc.Time.getUTCHoursDisplayOffset(datetime),
        isc.Time.getUTCMinutesDisplayOffset(datetime));
    displayDate._applyTimezoneOffset(0, displayDate.getTimezoneOffset());
    return displayDate;
},

//> @classMethod DateUtil.getLogicalDateOnly()
// Get a logical date - a value appropriate for a DataSourceField of type "date" - from a
// datetime value (a value from a DataSourceField of type "datetime").
// <P>
// This method correctly takes into account the current
// +link{Time.setDefaultDisplayTimezone,display timezone}, specifically, the returned Date
// will reflect the day, month and year that appears when the datetime is rendered
// by a SmartClient component rather than the date values that would be returned by
// Date.getDay() et al (which can differ, since getDay() uses the browser's local timezone).
// <P>
// For further background on date, time and datetime types, storage and transmission, see
// +link{group:dateFormatAndStorage,this overview}.
//
// @param date (Date) a Date instance representing a datetime value
// @return (Date) a Date instance representing just the date portion of the datetime value, as
//                a logical date
// @visibility external
//<
getLogicalDateOnly : function (datetime) {
    if (!isc.isA.Date(datetime)) {
        isc.logWarn("getLogicalDateOnly() passed invalid value:" + datetime
            + ". Returning null.");
        return null;
    }
    var year, month, day;
    // handle being passed something that's already a logical date
    if (datetime.logicalDate) {
        year  = datetime.getFullYear();
        month = datetime.getMonth();
        day   = datetime.getDate();
    } else {
        var offsetDate = this._getDisplayOffsetDate(datetime);
        month = offsetDate.getMonth();
        day   = offsetDate.getDate();
        year  = offsetDate.getFullYear();
    }

    return this.createLogicalDate(year, month, day);
},

//> @classMethod DateUtil.getLogicalTimeOnly()
// Get a logical time - a value appropriate for a DataSourceField of type "time" - from a
// datetime value (a value from a DataSourceField of type "datetime").
// <P>
// This method correctly takes into account the current
// +link{Time.setDefaultDisplayTimezone,display timezone}, specifically, the returned Date will
// reflect the hour, minute and second that appears when the datetime is rendered by a SmartClient
// component rather than the time values that would be returned by Date.getHours() et al (which
// can differ, since getHours() uses the browser's local timezone).
// <P>
// For further background on date, time and datetime types, storage and transmission, see
// +link{group:dateFormatAndStorage,this overview}.
//
// @param date (Date) a Date instance representing a datetime value
// @return (Date) a Date instance representing just the time portion of the datetime value, as
//                a logical time
// @visibility external
//<
getLogicalTimeOnly : function (datetime) {
    if (!isc.isA.Date(datetime)) {
        isc.logWarn("getLogicalTimeOnly() passed invalid value:" + datetime
            + ". Returning null.");
        return null;
    }

    var offsetHours = 0, offsetMinutes = 0;
    if (!datetime.logicalTime) {
        offsetHours = isc.Time.getUTCHoursDisplayOffset(datetime);
        offsetMinutes = isc.Time.getUTCMinutesDisplayOffset(datetime) +
                        datetime.getTimezoneOffset();
    }

    return this.createLogicalTime(datetime.getHours() + offsetHours, datetime.getMinutes() + offsetMinutes,
                                  datetime.getSeconds(), datetime.getMilliseconds());
},


//> @classMethod DateUtil.combineLogicalDateAndTime()
// Combine a logical date (a value appropriate for a DataSourceField of type "date") with a
// logical time (a value appropriate for a DataSourceField of type "time") into a datetime
// value (a value appropriate for a DataSourceField of type "datetime")
// <P>
// This method correctly takes into account the current
// +link{Time.setDefaultDisplayTimezone,display timezone}, specifically, the returned datetime
// value will show the same date and time as the passed date and time objects when rendered by
// a SmartClient component that has been configured with a field of type "datetime".
// <P>
// For further background on date, time and datetime types, storage and transmission, see
// +link{group:dateFormatAndStorage,this overview}.
//
// @param date (Date) a Date instance representing logical date value
// @param time (Date) a Date instance representing logical time value
// @return (Date) a Date instance representing a datetime value combining the logical date and
//                time passed
// @visibility external
//<
combineLogicalDateAndTime : function (date, time) {
    var hasDate = isc.isA.Date(date),
        hasTime = isc.isA.Date(time);
    if (!hasDate || !hasTime) {
        // date only, convert from logical date to datetime.
        if (hasDate) {
            // pass in the result of 'getFullYear()' etc. These numbers are the correct
            // abs values - createDatetime will handle shifting them to account for
            // timezones.
            return this.createDatetime(date.getFullYear(), date.getMonth(), date.getDate(), 0,0,0);
        } else if (hasTime) {
            // We could log a warning and bail in this case. However may as well just
            // give back a datetime with the same time value as the 'time' passed in.
            return time.duplicate();
        } else {
            isc.logWarn("combineLogicalDateAndTime passed invalid parameters:"
                 + date + " and " + time + ". Returning null.");
            return null;
        }
    }

    // Get hours / minutes in display timezone.
    var hour = time.getHours(),
        minutes = time.getMinutes();
    return this.createDatetime(
                date.getFullYear(), date.getMonth(), date.getDate(),
                hour, minutes, time.getSeconds(), time.getMilliseconds()
           );
},


//>    @classMethod DateUtil.compareDates()
// Compare two dates; returns 0 if equal, -1 if the first date is greater (later), or 1 if
// the second date is greater.  If either value is not a Date object, it is treated as the
// epoch (midnight on Jan 1 1970) for comparison purposes.
//  @param  date1   (Date)  first date to compare
//  @param  date2   (Date)  second date to compare
//  @return (int)    0 if equal, -1 if first date &gt; second date, 1 if second date &gt; first date
// @visibility external
//<
compareDates : function (a, b, allowRelativeDates) {
    if (a == b) return 0; // same date instance
    if (allowRelativeDates) {
        // adds support for comparing the absolute values of relative date objects, shortcuts
        // and strings
        a = this.getAbsoluteDate(a);
        b = this.getAbsoluteDate(b);
    }
    var aval = (isc.isA.Date(a) ? a.getTime() : 0),
        bval = (isc.isA.Date(b) ? b.getTime() : 0);
    return aval > bval ? -1 : (bval > aval ? 1 : 0);
},

//>    @classMethod DateUtil.compareLogicalDates()
// Compare two dates, normalizing out the time elements so that only the date elements are
// considered; returns 0 if equal, -1 if the first date is greater (later), or 1 if
// the second date is greater.
//  @param  date1   (Date)  first date to compare
//  @param  date2   (Date)  second date to compare
//  @return (int)    0 if equal, -1 if first date &gt; second date, 1 if second date &gt;
//                      first date.  Returns false if either argument is not a date
// @visibility external
//<
compareLogicalDates : function (a, b, allowRelativeDates) {
    if (a == b) return 0; // same date instance
    if (!isc.isA.Date(a) || !isc.isA.Date(b)) {
        if (allowRelativeDates) {
            // adds support for comparing the absolute logical values of relative date objects,
            // shortcuts and strings
            a = this.getAbsoluteDate(a, null, null, true);
            b = this.getAbsoluteDate(b, null, null, true);
        }
        if (!isc.isA.Date(a) || !isc.isA.Date(b)) {
            return false; // bad arguments, so return false
        }
    }
    var aYear = a.getFullYear(),
        aMonth = a.getMonth(),
        aDay = a.getDate(),
        bYear = b.getFullYear(),
        bMonth = b.getMonth(),
        bDay = b.getDate();

    var aval = aYear * 10000 + aMonth * 100 + aDay,
        bval = bYear * 10000 + bMonth * 100 + bDay;

    return aval > bval ? -1 : (bval > aval ? 1 : 0);
},

// `month' begins at 0.
getJulianDayNumber : function (year, month, date) {
    // http://quasar.as.utexas.edu/BillInfo/JulianDatesG.html
    var y = year,
        m = month + 1,
        d = date;

    if (m <= 2) {
        --y;
        m += 12;
    }
    var a = parseInt(y / 100),
        b = parseInt(a / 4),
        c = 2 - a + b,
        e = parseInt(365.25 * (y + 4716)),
        f = parseInt(30.6001 * (m + 1))
    return c + d + e + f - 1524;
},

_getWeekdayCounts : function (weekendDays) {
    weekendDays = weekendDays || this.getWeekendDays();
    var weekdayCounts = weekendDays._weekdayCounts;
    if (!weekdayCounts) {
        var isWeekend = {}, numWeekends = 0;
        for (var i = 0; i < weekendDays.length; ++i) {
            if (!isWeekend[weekendDays[i]]) {
                ++numWeekends;
                isWeekend[weekendDays[i]] = true;
            }
        }

        weekdayCounts = [];
        for (var d = 0; d <= 6; ++d) {
            var weekdayCount = 0;
            var counts = [ 0 ];
            for (var dd = 1; dd < 7; ++dd) {
                if (!isWeekend[(d + dd - 1) % 7]) ++weekdayCount;
                counts.push(weekdayCount);
            }
            weekdayCounts[d] = counts;
        }
        weekdayCounts._numWeekends = numWeekends;
        weekendDays._weekdayCounts = weekdayCounts;
    }
    return weekdayCounts;
},

_getDayDiff : function (date1, date2, weekdaysOnly, useCustomTimezone, weekendDays) {
    var logicalDate1, logicalDate2;
    var compareRes = this.compareDates(date1, date2);
    var sign = (compareRes > 0 ? 1 : -1);
    if (compareRes >= 0) { // `date1' is before `date2'.
        if (useCustomTimezone !== false) {
            logicalDate1 = this.getLogicalDateOnly(date1);
            logicalDate2 = this.getLogicalDateOnly(date2);
        } else {
            logicalDate1 = date1;
            logicalDate2 = date2;
        }
    } else {
        if (useCustomTimezone !== false) {
            logicalDate1 = this.getLogicalDateOnly(date2);
            logicalDate2 = this.getLogicalDateOnly(date1);
        } else {
            logicalDate1 = date2;
            logicalDate2 = date1;
        }
    }

    var jd1 = this.getJulianDayNumber(logicalDate1.getFullYear(), logicalDate1.getMonth(),
                                      logicalDate1.getDate()),
        jd2 = this.getJulianDayNumber(logicalDate2.getFullYear(), logicalDate2.getMonth(),
                                      logicalDate2.getDate());

    if (weekdaysOnly) {
        var dd = jd2 - jd1;
        var weekdayCounts = this._getWeekdayCounts(weekendDays);
        return sign * (parseInt(dd / 7) * (7 - weekdayCounts._numWeekends) +
                       weekdayCounts[logicalDate1.getDay()][dd % 7]);
    } else {
        return sign * (jd2 - jd1);
    }
},

//>    @type DateInputFormat
//  3 character string containing the <code>"M"</code>, <code>"D"</code> and <code>"Y"</code>
//  characters to indicate the format of strings being parsed into Date instances via
//  <code>DateUtil.parseInput()</code>.
//  <P>
//  As an example - an input format of "MDY" would parse "01/02/1999" to Jan 2nd 1999
// <smartclient>
//  <P>
//  Note: In addition to these standard formats, a custom date string parser function may be
//  passed directly to +link{DateUtil.setInputFormat()} or passed into
// +link{DateUtil.parseInput()} as the inputFormat parameter.
// </smartclient>
// @baseType String
// @visibility external
//<

//> @classMethod DateUtil.setInputFormat()
// Sets up the default system-wide input format for strings being parsed into dates via
// <code>DateUtil.parseInput()</code>. This will effect how SmartClient components showing
// editable date or datetime fields parse user-entered values into live Date objects.
// <P>
// The input format can be specified as a +link{type:DateInputFormat} - a 3 character string like
// <code>"MDY"</code> indicating the order of the Month, Day and Year components of date strings.
// <P>
// As an example - an input format of "MDY" would parse "01/02/1999" to Jan 2nd 1999<br>
// This standard parsing logic will also handle date-time strings such as "01/02/1999 08:45", or
// "01/02/1999 16:21:05".
// <P>
// Notes:
// <ul>
// <li>If the inputFormat is not explicitly set,the system automatically determines
//     the standard input format will be based on the specified
//     +link{DateUtil.setShortDisplayFormat,DateUtil.shortDisplayFormat} wherever possible.
//     For example if the short display format has been set to "toEuropeanShortDate" the input
//     format will default to "DMY".</li>
// <li>The default date parsing functionality built into SmartClient will handle dates presented
//     with any separator string, and can handle 1 or 2 digit day and month values and 2 or 4
//     digit year values. This means that in many cases custom date display formats can be parsed
//     back to Date values without the need for a custom parser function. However if more
//     sophisticated parsing logic is required, a function may be passed into this method. In
//     this case the parser function should be able to handle parsing date and datetime values
//     formatted via
//     <smartclient>+link{Date.toShortDate()} and +link{Date.toShortDateTime()}.</smartclient>
//     <smartgwt>+link{DateUtil.formatAsShortDate()} and +link{DateUtil.formatAsShorDatetime()}.
//     </smartgwt></li>
// <li>Date parsing and formatting logic may be overridden at the component level by setting
//     properties directly on the component or field in question.</li>
// </ul>
// @param format (DateInputFormat | Function) Default format for strings to be parsed into Dates.
// <smartclient>
// If this method is passed a function, it is expected to take a single parameter
// (the formatted date string), and return the appropriate Javascript Date object (or null if
// appropriate).
// </smartclient>
// @see DateUtil.parseInput()
// @example dateFormat
// @example customDateFormat
// @visibility external
//<
setInputFormat : function (format) {

    this._inputFormat = format;
},

//> @classMethod DateUtil.getInputFormat()
// Retrieves the default format for strings being parsed into dates via
// <code>DateUtil.parseInput()</code>
// @see DateUtil.setInputFormat()
// @return (String) the current inputFormat for dates
// @visibility external
//<
getInputFormat : function () {
    if (this._inputFormat != null) return this._inputFormat;
    return this.mapDisplayFormatToInputFormat("toShortDate");
},

hasInputFormat : function () {
    return (this._inputFormat != null);
},

// Given a display format return the associated input format
_inputFormatMap:{
    toUSShortDate:"MDY",
    toUSShortDateTime:"MDY",
    toUSShortDatetime:"MDY",
    toEuropeanShortDate:"DMY",
    toEuropeanShortDateTime:"DMY",
    toEuropeanShortDatetime:"DMY",
    toJapanShortDate:"YMD",
    toJapanShortDateTime:"YMD",
    toJapanShortDatetime:"YMD"
},
mapDisplayFormatToInputFormat : function (displayFormat) {
    if (displayFormat == null || displayFormat == "toShortDate") {
        displayFormat = Date.prototype._shortFormat;
    } else if (displayFormat == "toNormalDate") {
        displayFormat = Date.prototype.formatter;
    }
    if (isc.isA.Function(displayFormat)) {
        isc.Log.logInfo("Unable to determine input format associated with display format " +
                        "function - returning default input format", "Date");
        return this._inputFormat || "MDY";
    }
    var inputFormat = this._inputFormatMap[displayFormat];
    // Note: isA.String check is necessary - all objects have toString / toLocaleString
    // present on them and we definitely don't want to return those native object formatters
    // as what will become a dateString parsing function!
    if (inputFormat != null && isc.isA.String(inputFormat)) return inputFormat;

    // a couple of special cases where we actually return functions.
    if (displayFormat == "toSerializeableDate") return this.parseSchemaDate;

    // Otherwise you're on your own - assume you've set up input foramt, or overridden this method
    isc.Log.logInfo("Unable to determine input format associated with display format " +
                     displayFormat + " - returning default input format", "Date");

    return this._inputFormat || "MDY";
},

//>    @classMethod DateUtil.parseInput()
// Parse a date passed in as a string, returning the appropriate date object.
// @param dateString (String) date value as a string
// @param [format] (DateInputFormat) Format of the date string being passed.
//                                      If not passed, the default date input format as set up
//                                      via setInputFormat() will be used.
// @param [centuryThreshold] (Integer) For date formats that support a 2 digit
//                                  year, if parsed year is 2 digits and less than this
//                                  number, assume year to be 20xx rather than 19xx
// @param [suppressConversion] (Boolean)
//          If the string passed in was not a valid date, in some cases we can convert to a
//          valid date (for example incrementing the year if the month is greater than 12).
//          This optional parameter will suppress such conversions - anything that doesn't
//          parse directly to a valid date will simply return null.
// @return (Date) date value, or null if the string could not be parsed to a valid date.
// @group dateFormatting
// @visibility external
//<

// Note: undocumented isDatetime parameter. Are we creating a logical "date" value or a standard
// datetime type value where the time component is important? If ommitted assume datetime.
// Implementation-wise, if isDatetime is explicitly false, we will use the system local timezone
// rather than any timezone specified via Time.setDisplayTimezone().

parseInput : function (dateString, format, centuryThreshold, suppressConversion,
                        isDatetime)
{
    var logicalDate = (isDatetime == false);

    if (isc.isA.Date(dateString)) return dateString;

    if (!isc.isA.String(dateString) || isc.isAn.emptyString(dateString)) {
        return null;
    }

    // Strip the '$$DATE$$:' prefix if present.
    var origDateString = dateString;
    dateString = dateString.trim();

    if (dateString.startsWith("$$DATESTAMP$$:")) {
        return new Date(parseInt(dateString.substring(14)));
    }

    if (dateString.startsWith("$$DATE$$:")) {
        dateString = dateString.substring(9).trimLeft();
    }

    // Default to the standard input format
    if (format == null) format = this.getInputFormat();

    // If the format passed in is the name of a function on the Date class, or an
    // explicit function, assume its a parser and call it directly

    if (isc.isA.Function(Date[format])) format = Date[format];
    if (isc.isA.Function(format)) {
        return format(origDateString, centuryThreshold, suppressConversion);
    }

    // use the helper method _splitDateString() to get an array of values back
    // (representing year / month / day, etc.)
    // If null is returned, this was not a valid date - just return null.
    // Otherwise make the month zero-based, by reducing by one, and pass construct a new date
    // from the values returned.
    var array = this._splitDateString(dateString, format);

    if (array != null) {
        var year = array[0],
            bce = year && year.contains("-");

        if (year && bce) year = year.replaceAll("-", "");

        if (year) {
            if (year.length <= 2) {
                year = parseInt(year, 10);
                if (centuryThreshold != null) {
                    if (year < centuryThreshold) year += 2000;
                    else year += 1900;
                }
                array[0] = year;
            } else if (year.length == 3) {
                array[0] = "0" + year.toString();
            } else {
                array[0] = year;
            }
            if (bce) array[0] = "-" + array[0];
        }

        if (logicalDate) {
            return this.createLogicalDate(array[0], array[1], array[2], suppressConversion);
        } else {
            return this.createDatetime(array[0], array[1], array[2],
                        array[3], array[4], array[5], null, suppressConversion);
        }
    } else {
        return null;
    }
},

// Helper used by the Relative date item -- returns true if the date-string passed
// in includes a time portion.
// False if it does not (or if it's not a recognized date-string at all)
isDatetimeString : function (dateString, format) {
    format = format || this.getInputFormat();
    if (!isc.isA.Function(format)) {
        var array = this._splitDateString(dateString, format, false);
        if (array == null) return false;

        return (array[3] != null && !isc.isA.emptyString(array[3])) &&
               (array[4] != null && !isc.isA.emptyString(array[4]));
    }


    if (!dateString.contains(" ")) return false;
    // get the offset of the last colon and assume there's a valid time portion if the characters
    // either side of it are numbers
    var colonOffset = dateString.lastIndexOf(isc.Time.defaultTimeSeparator);
    if (colonOffset < 1) return false;
    if (isNaN(dateString.substring(colonOffset-1, colonOffset)) ||
        isNaN(dateString.substring(colonOffset+1, colonOffset+2)))
    {
        return false;
    }
    return true;
},

// Parse a date or datetime value from a dataset or specified in code.
// NB: unlike parseInput, this method should not change behavior in different locales, or dates
// coming over the wire or specified in code will suddenly break!
//
// For Datetime, XML Schema uses "2005-08-01T21:35:48.350Z", see
//    http://www.w3.org/TR/xmlschema-2/#dateTime
// SmartClient Server parses "yyyy-mm-dd" format
parseSchemaDate : function (value) {
    if (isc.isA.Date(value)) return value;

    // bail to avoid crash in string conversion
    if (value == null) return null;

    if (!isc.isA.String(value)) value = (value.toString ? value.toString() : value + "");

    // Notes on regex:
    // - date-elements should be separated by "-", but we also support "/" because this method
    //   is also used when receiving REST responses from the server (by the isDate validator),
    //   to convert the on-the-wire string format for dates into actual Date instances.
    // - result[4] is the optional timestamp including the T and colon separators
    // - result[8] would be the optional milliseconds including the ".", whereas
    //   result[9] is just the numeric part
    //   results[10] is the timezone - either "Z" (zulu time or GMT) or +/- HH:MM
    var result = value.match(/(\d{4})[\/-](\d{2})[\/-](\d{2})([T ](\d{2}):(\d{2})(:(\d{2}))?)?(\.(\d+))?([+-]\d\d?:\d{2}|Z)?/);
//    isc.Log.logWarn("isDate: '" + value + "', regex match: " + result);

    if (result == null) return null;

    value = value.trim();

    var secondsIndex = 8;
    var msIndex = 10;
    var tzIndex = 11;


    var dateValue;
    // NOTE: pass only the relevant arguments as Moz does not like being passed nulls

    if (!result[4]) { // no VALID time
        // before creating a logical date, check if the value has additional characters that
        // make it look like it has something in place of a time-value, even if it isn't
        // valid for schema-format - return null in this case, rather than a valid logicalDate
        if (value.length > 10 && value.contains(" ")) return null;
        // result[2] should contain the month, but if this value is greater than 12 (twelve month),
        // then result[3] should be the month and result[2] should be the day of the month.
        if (result[2] > 12) {
            var month = result[3];
            result[3] = result[2];
            result[2] = month;
        }
        dateValue = this.createLogicalDate(result[1], result[2] - 1, result[3]);
    } else if (!result[msIndex]) { // no ms
        dateValue = new Date(Date.UTC(result[1], result[2] - 1, result[3],
                                      result[5], result[6], result[secondsIndex] || 0));
    } else {
        var ms = result[msIndex];

        // XML Schema says any number of fractional digits can be specified.  new Date() is
        // expecting a whole number of milliseconds (and further precision would be ignored).
        // Multiply by a power of ten based on the number of digits provided, such that ".9"
        // becomes 900 and ".98367" becomes 984.
        if (ms.length != 3) {
            var multiplier = Math.pow(10,3-ms.length);
            ms = Math.round(parseInt(ms,10) * multiplier);
        }
        //isc.Log.logWarn("ms is: " + ms);

        dateValue = new Date(Date.UTC(result[1], result[2] - 1, result[3],
                                      result[5], result[6], result[secondsIndex] || 0, ms));
    }
    // Handle timezone offset from GMT

    if (result[tzIndex] && result[tzIndex].toLowerCase() != "z") {
        var HM = result[tzIndex].split(":"),
            H = HM[0],
            negative = H && H.startsWith("-"),
            M = HM[1];
        H = parseInt(H, 10);
        M = parseInt(M, 10);
        var dateTime = dateValue.getTime();


        // Note no need to account for negative on hours since the "+" or "-" prefix was picked up
        // in parseInt
        if (isc.isA.Number(H)) dateTime -= (3600000 * H);
        if (isc.isA.Number(M)) dateTime -= (60000 * M * (negative ? -1 : 1));
        dateValue.setTime(dateTime);
    }

    return dateValue
},

// ISC DSResponses that use our SQLTransform logic (basically our backend DB implementation)
// will call this method by default - giving the user an opportunity to override.  This can be
// disabled by setting jsTranslater.writeNativeDate: true in server.properties.
//
// Note: month is zero-based, just like the native Date constructor.
parseServerDate : function (year, month, day) {
    return this.createLogicalDate(year, month, day);
},

// ISC DSResponses will call this method by default for fields of type "time"
parseServerTime : function (hour, minute, second) {
    return this.createLogicalTime(hour, minute, second);
},


_splitDateString : function (string, format, zeroEmptyTime) {
    var isFunc = isc.isA.Function(format);

    if (zeroEmptyTime == null) zeroEmptyTime = true;

    var month, day, year, hour, minute, second;

    var monthIndex = format && !isFunc ? format.indexOf("M") : 0,
        dayIndex = format && !isFunc ? format.indexOf("D") : 1,
        yearIndex = format && !isFunc ? format.indexOf("Y") : 2;
    // shortDate implies it's of the format MM/DD/YYYY

    //>Safari12
    if (isc.Browser.isSafari && isc.Browser.safariVersion <= 312) {
        var splitDate = this._splitDateViaSubstring(string, monthIndex, dayIndex, yearIndex,
                                                    zeroEmptyTime);
        year = splitDate[0];
        month = splitDate[1];
        day = splitDate[2];
        hour = splitDate[3];
        minute = splitDate[4];
        second = splitDate[5];

    // For browsers that support RegExp properly, use regexp pattern matching to get the result
    // (This has the advantage that we can deal with dates of the form 1/1/1999, and attempt to
    //  convert MM/YY/DD -- though we're relying on the native browser handling for the
    //  Date constructor being passed a 2 digit year)
    } else {
    //<Safari12

        // Each of the first three slots is either YYYY / YY or MM / M (or DD/D) (depends on the
        // format passed in)
        // Note: We don't support years greater than 9999. Attempting to set a year greater than
        // 9999 on a JS date causes a native browser crash on IE6
        var regex =
        //          YYYY || YY/[M]M  /  YYYY || YY/[M]M  /  YYYY || YY/[M]M [(space) [H]H  :    MM    [:     SS]] (case-insensitive am/pm)
        new RegExp(/^\s*(-?\d{1,4})[^\d](-?\d{1,4})[^\d](-?\d{1,4})([^\d](\d{1,2})[^\d](\d\d)[^\d]?(\d\d)?)?\s*([AaPp][Mm]?)?\s*$/),
            results = string.match(regex);

        if (results == null) return null;
        // Notes - we need to match the order of day / month / year to the format passed in
        // Also - the month value in the string is 1-based rather than zero based

        // Note: this was parseInt(results[index]) -1, but both IE and Mozilla will do the
        // wrong thing here - if the substring was "09", the parseInt would return 0 rather
        // than 9.
        // In any case, the parseInt is rendered unnecessary by the 'isA.Number' check below.
        month = results[monthIndex +1] -1;
        day = results[dayIndex+1];
        year = results[yearIndex +1];

        // Note - results[4] is the whole time string (if present)
        // Zero out any time fields that are not present - this may happen if
        // - time has invalid format (could check by examining results[4] too)
        // - time not included in dateString (could check by examining results[4] too)
        // - time has no seconds (legal - just zero out the seconds)
        hour = results[5];
        if (zeroEmptyTime && hour == null) hour = 0;
        minute = results[6];
        if (zeroEmptyTime && results[6] == null) minute = 0;
        second = results[7];
        if (zeroEmptyTime && results[7] == null) second = 0;

        if (results[8]) {
            // support am/pm markers (a/p/am/pm, case insensitive)
            hour = parseInt(hour);
            if (results[8].toLowerCase().startsWith("a")) {
                if (hour == 12) hour = 0;
            } else {
                if (hour < 12) hour += 12;
            }
        }
    //>Safari12
    }
    //<Safari12
    // If they all are numbers, this was a valid date string
    // NOTE: If year - month - day gives a number then they
    // are all numbers, or strings that implicitly convert to numbers.
    // We could also use this syntax:
    // if(parseInt(year) == year && parseInt(month) == month ...)
    // but this is slower in both Moz and IE
    var isValid = zeroEmptyTime ?
                    isc.isA.Number(year - month - day - hour - minute - second) :
                    isc.isA.Number(year - month - day);
    if (isValid) {
        // Return the hours modulo 24 in case the hours were formatted by a Java `SimpleDateFormat'
        // using the 'k' pattern char. This takes care of both 'H' and 'k'.
        // http://ideone.com/E5HC4E

        return ([year,month,day,hour != null ? hour % 24 : null ,minute,second]);
    }
    else return null
},

//>    @type DateDisplayFormat
// Valid display formats for dates.  These strings are the names of formatters which can be
// passed to <code>DateUtil.setNormalDisplayFormat()</code> or
// <code>DateUtil.setShortDisplayFormat()</code> and will be subsequently used as default long
// or short formatters for date objects by SmartClient components.<br>
// Default set of valid display formats is as follows:<br><br>
//
// @value toString
// Default native browser 'toString()' implementation. May vary by browser.<br>
// <i>Example</i>: <code>Fri Nov 04 2005 11:03:00 GMT-0800 (Pacific Standard Time)</code>
// @value toLocaleString
// Default native browser 'toLocaleString()' implementation. May vary by browser.
// <i>Example</i>: <code>Friday, November 04, 2005 11:03:00 AM</code>
// @value toUSShortDate Short date in format MM/DD/YYYY.<br>
// <i>Example</i>: <code>11/4/2005</code>
// @value toUSShortDatetime Short date with time in format MM/DD/YYYY HH:MM<br>
// <i>Example</i>: <code>11/4/2005 11:03</code>
// @value toEuropeanShortDate Short date in format DD/MM/YYYY.<br>
// <i>Example</i>: <code>4/11/2005</code>
// @value toEuropeanShortDatetime Short date with time in format DD/MM/YYYY HH:MM<br>
// <i>Example</i>: <code>4/11/2005 11:03</code>
// @value toJapanShortDate Short date in format YYYY/MM/DD.<br>
// <i>Example</i>: <code>2005/11/4</code>
// @value toJapanShortDatetime Short date with time in format YYYY/MM/DD HH:MM<br>
// <i>Example</i>: <code>2005/11/4 11:03</code>
// @value toSerializeableDate Date in the format YYYY-MM-DD HH:MM:SS<br>
// <i>Example</i>: <code>2005-11-04 11:09:15</code>
// @value toDateStamp   Date in the format &lt;YYYYMMDD&gt;T&lt;HHMMSS&gt;Z
// <i>Example</i>: <code>20051104T111001Z</code>
// <br>
// <br>
// Note: In addition to these standard formats, custom formatting can be set by passing
// a function directly to +link{DateUtil.setNormalDisplayFormat()} et al. This
// function will then be executed whenever the appropriate formatter method is called [eg
// +link{date.toNormalDate()}], in the scope of the date instance in question.
// <p>
// Custom formatting can also be applied by passing a +link{FormatString} instead of a
// <code>DateDisplayFormat</code> string to +link{DateUtil.setNormalDisplayFormat()} et al. See
// the <code>FormatString</code> docs for details.
//
//  @visibility external
//<

//> @classMethod DateUtil.setNormalDisplayFormat()
// Set the default formatter for date objects to the method name passed in.  After calling this
// method, subsequent calls to <smartclient>+link{Date.toNormalDate()}</smartclient>
// <smartgwt>+link{DateUtil.formatAsNormalDate()</smartgwt> will return a string formatted
// according to this format specification. Note: this will be the standard long date format used
// by SmartClient components.
// <p>
// The <code>format</code> parameter may be a +link{FormatString}, a +link{DateDisplayFormat}
// string, or a function. If passed a function, this function will be executed in the scope of
// the Date and should return the formatted string.<br>
// <p>
// Initial default normalDisplayFormat is <code>"toLocaleString"</code>
// @group    dateFormatting
// @param    format    (FormatString | DateDisplayFormat | Function)    new formatter
//      @visibility external
//<
setNormalDisplayFormat : function (format) {
    // if a valid formatter was passed in, set our .formatter property
    if (isc.isA.Function(Date.prototype[format]) ||
        isc.isA.Function(format) ||
        isc.isA.String(format))
    {
        Date.prototype.formatter = format;
    }
},

setNormalDateDisplayFormat : function (format) {
    this.setNormalDisplayFormat(format);
},

//> @classMethod DateUtil.setNormalDatetimeDisplayFormat()
// Set the default normal format for datetime values. After calling this method, subsequent
// calls to <smartclient>+link{Date.toNormalDatetime()}</smartclient>
// <smartgwt>+link{DateUtil.format()}</smartgwt> will return a string formatted according to
// this format specification. Note that this will be the standard datetime format used by
// SmartClient components.
// <P>
// The <code>format</code> parameter may be a +link{FormatString}, a +link{DateDisplayFormat}
// string, or a function. If passed a function, this function will be executed in the scope of
// the Date and should return the formatted string.<br>
//
// @group    dateFormatting
// @param    format    (FormatString | DateDisplayFormat | Function)    new formatter
// @example dateFormat
// @example customDateFormat
// @visibility external
//<
setNormalDatetimeDisplayFormat : function (format) {
    // if a valid formatter was passed in, set our .formatter property
    if (isc.isA.Function(Date.prototype[format]) ||
        isc.isA.Function(format) ||
        isc.isA.String(format))
    {
        Date.prototype.datetimeFormatter = format;
    }
},

//>    @classMethod DateUtil.setShortDisplayFormat()
// Set the default short format for dates. After calling this method, subsequent calls to
// <smartclient>+link{Date.toShortDate()}</smartclient>
// <smartgwt>+link{DateUtil.formatAsShortDate}</smartgwt> will return a string formatted
// according to this format specification. Note that this will be the standard short date
// format used by SmartClient components.
// <P>
// The <code>format</code> parameter may be a +link{FormatString}, a +link{DateDisplayFormat}
// string, or a function. If passed a function, this function will be executed in the scope of
// the Date and should return the formatted string.<br>
// <P>
// Initial default shortDateFormat is <code>"toUSShortDate"</code>. This property
// is commonly modified for localization of applications. See
// +externalLink{http://en.wikipedia.org/wiki/Date_format_by_country}
// for a useful overview of standard date formats per country.
//
// @group    dateFormatting
// @param    format    (FormatString | DateDisplayFormat | Function)    new formatter
// @example dateFormat
// @example customDateFormat
// @visibility external
//<
setShortDisplayFormat : function (format) {
    if (isc.isA.Function(Date.prototype[format]) ||
        isc.isA.Function(format) ||
        isc.isA.String(format))
    {
        Date.prototype._shortFormat = format;
    }
},

//>    @classMethod DateUtil.setDefaultDateSeparator
// Sets a new default separator that will be used when formatting dates. By default, this
// is a forward slash character: "/"
// @group   dateFormatting
// @param separator (String) separator to use in dates
// @visibility external
//<
setDefaultDateSeparator : function (separator) {
    Date.prototype._shortDateTemplate = [,,,,separator,,,,,separator,,,,null];
    Date.prototype._separator = separator;
},

//>    @classMethod DateUtil.getDefaultDateSeparator
// gets the default date separator string
// @group   dateFormatting
// @return (String) the default date separator
// @visibility external
//<
getDefaultDateSeparator : function () {
    if (Date.prototype._separator) return Date.prototype._separator;
    else return "/";
},

//> @classMethod DateUtil.setShortDatetimeDisplayFormat()
// Set the default short format for datetime values. After calling this method, subsequent
// calls to <smartclient>+link{Date.toShortDateTime()}</smartclient>
// <smartgwt>+link{DateUtil.formatAsShortDatetime()}</smartgwt> will return a string formatted
// according to this format specification. Note that this will be the standard datetime format
// used by SmartClient components.
// <P>
// The <code>format</code> parameter may be a +link{FormatString}, a +link{DateDisplayFormat}
// string, or a function. If passed a function, this function will be executed in the scope of
// the Date and should return the formatted string.<br>
// <P>
// Initial default format is <code>"toUSShortDatetime"</code>.  See
// +externalLink{http://en.wikipedia.org/wiki/Date_format_by_country}
// for a useful overview of standard date formats per country.
//
// @group    dateFormatting
// @param    format    (FormatString | DateDisplayFormat | Function)    new formatter
// @example dateFormat
// @example customDateFormat
// @visibility external
//<
setShortDatetimeDisplayFormat : function (format) {
    if (isc.isA.Function(Date.prototype[format]) ||
        isc.isA.Function(format) ||
        isc.isA.String(format))
    {
        Date.prototype._shortDatetimeFormat = format;
    }
},


//> @object FiscalYear
//
// An object representing the start of a given Fiscal Year in the current locale.
// <P>
// See +link{FiscalCalendar} for more information on how FiscalYears are set up and used.
//
// @treeLocation Client Reference/System/Date
// @visibility external
//<

//> @attr fiscalYear.fiscalYear (Integer : null : IRW)
//
// The actual fiscal year that this date relates to.
// <P>
// A fiscal year ends when the next one begins. A fiscal year may span the boundary
// between two calendar years in which case the +link{fiscalYear.fiscalYear} value may
// not match the +link{fiscalYear.year} value.
// <P>
// For example fiscalYear 2020 may start in July of 2019 and end in July of 2020. In this
// case the <code>fiscalYear</code> would be set to <code>2020</code> and the
// +link{fiscalYear.year} would be set to <code>2019</code>
//
// @visibility external
//<

//> @attr fiscalYear.year (Integer : null : IRW)
//
// The 4-digit calendar year when this fiscal year starts.
//
// @visibility external
//<

//> @attr fiscalYear.month (Integer : null : IRW)
//
// The zero-based month-number when this fiscal year starts.
//
// @visibility external
//<

//> @attr fiscalYear.date (Integer : null : IRW)
//
// The one-based day-number in the +link{fiscalYear.month, specified month} when this fiscal
// year starts.
//
// @visibility external
//<

//> @object FiscalCalendar
//
// An object representing the start date for fiscal years in the current locale.
// <P>
// A fiscal year spans a configurable date range - it may not exactly
// match a calendar year in length and it can start on any date within the calendar year
// and potentially end in the next calendar year.
// <P>
// Developers may specify explicit fiscal year start dates by adding +link{FiscalYear}
// objects to the +link{FiscalCalendar.fiscalYears, fiscal years array}.
// If none are provided, or if there is no entry for the given year, one is
// manufactured based on the default +link{FiscalCalendar.defaultMonth, month}
// and +link{FiscalCalendar.defaultDate, date}.
//
// @treeLocation Client Reference/System/Date
// @visibility external
//<

//> @attr fiscalCalendar.defaultMonth (Integer : null : IRW)
//
// The default zero-based month-number to use for calculating fiscal dates when no
// +link{FiscalCalendar.fiscalYears, fiscal years} are provided. This value together
// with +link{fiscalCalendar.defaultDate} will be used as the start date for the
// fiscal years where no explicitly specified fiscalYear configuration is present.
// <br>
// See also +link{fiscalCalendar.defaultYearMode}.
//
// @visibility external
//<

//> @attr fiscalCalendar.defaultDate (Integer : null : IRW)
//
// The default one-based day-number in the +link{fiscalCalendar.defaultMonth, specified month}
// to use for calculating fiscal dates when no +link{FiscalCalendar.fiscalYears, fiscal years}
// are provided. This value together
// with +link{fiscalCalendar.defaultMonth} will be used as the start date for the
// fiscal years where no explicitly specified fiscalYear configuration is present.
// <br>
// See also +link{fiscalCalendar.defaultYearMode}.
//
// @visibility external
//<

//> @type FiscalYearMode
//
// Strategies for calculating the FiscalYear within a +link{fiscalCalendar} from the
// specified +link{fiscalCalendar.defaultDate} and +link{fiscalCalendar.defaultMonth}
// If the specified fiscal year date starts in one calendar year and ends in the next.
//
// @value "end" The fiscalYear value for the date range will match the calendar year
//  in which the period ends. For example if the defaultDate and defaultMonth were set
//  to represent April 1st, the fiscal year starting on April 1st 2020 would end on
//  April 1st 2021. Setting the fiscalYearMode to <code>end</code> would mean the
//  fiscalYear value for this block would be 2021.
//
// @value "start" The fiscalYear value for the date range will match the calendar year
//  in which the period starts. For example if the defaultDate and defaultMonth were set
//  to represent April 1st, the fiscal year starting on April 1st 2020 would end on
//  April 1st 2021. Setting the fiscalYearMode to <code>start</code> would mean the
//  fiscalYear value for this block would be 2020.
// @visibility external
//<

//> @attr fiscalCalendar.defaultYearMode (FiscalYearMode : "end" : IRW)
//
// This attribute controls how the displayed fiscalYear value should be calculated for
// dates falling within a period not explicitly listed in the
// +link{fiscalCalendar.fiscalYears,fiscal years array}.
// <P>
// The +link{fiscalCalendar.defaultMonth} and +link{fiscalCalendar.defaultDate} will be
// used to calculate the start of the fiscal year period. The defaultYearMode
// determines whether the reported fiscalYear for this period matches the year in which
// the period starts or the year in which it ends (so whether a fiscal year spanning
// dates within both 2020 and 2021 is reported as fiscalYear 2020 or 2021).
// @visibility external
//<

//> @attr fiscalCalendar.fiscalYears (Array of FiscalYear : null : IRW)
//
// An array of +link{FiscalYear, FiscalYear objects} which each represent the start date of a
// single fiscal year.
//
// @visibility external
//<

//>    @classMethod DateUtil.setFiscalCalendar()
// Sets the global fiscal calendar, which is used for all calls to
// getFiscalYear() / getFiscalWeek() if those methods aren't passed a fiscalCalander.
//
// @param fiscalCalendar (FiscalCalendar) the object representing the start month and date of
//           the fiscal year in the current locale
// @visibility external
//<
setFiscalCalendar : function (fiscalCalendar) {
    if (!fiscalCalendar.fiscalYears) fiscalCalendar.fiscalYears = [];
    Date.prototype.fiscalCalendar = fiscalCalendar;
    // init the start/endDate values on any specified FiscalYear objects
    this._getFiscalYearObjectForDate(new Date());
},

//>    @classMethod DateUtil.getFiscalCalendar()
// Returns the global +link{FiscalCalendar, FiscalCalendar object} representing the start month and
// date of the fiscal year in the current locale.
// @return (FiscalCalendar)    the FiscalCalendar object
// @visibility external
//<
getFiscalCalendar : function () {
    if (!Date.prototype.fiscalCalendar.fiscalYears) {
        Date.prototype.fiscalCalendar.fiscalYears = [];
    }
    return Date.prototype.fiscalCalendar;
},

//>    @classMethod DateUtil.getFiscalStartDate()
// Returns the start date of the fiscal year for the passed date.
//
// @param date (Date | number) the date, or the year-number, to get the fiscal year for
// @param [fiscalCalendar] (FiscalCalendar) the object representing the starts of one or more
//                              fiscal years
// @return (Date)    the start of the fiscal year for the passed date and fiscalCalendar
// @visibility external
//<
getFiscalStartDate : function (date, fiscalCalendar) {
    var fiscalYear = this._getFiscalYearObjectForDate(date, fiscalCalendar);
    return new Date(fiscalYear.year, fiscalYear.month, fiscalYear.date);
},


getFiscalEndDate : function (date, fiscalCalendar) {
    var fy = this._getFiscalYearObjectForDate(date, fiscalCalendar),
        nfy = this.getFiscalYear(fy.fiscalYear + 1);
    if (nfy.year < fy.fiscalYear) nfy = this.getFiscalYear(nfy.fiscalYear + 1);
    var endDate = new Date(nfy.startDate.getTime()-1);
    return endDate;
},


_getFiscalYearObjectForDate : function (date, fiscalCalendar) {

    fiscalCalendar = fiscalCalendar || this.getFiscalCalendar();
    if (!fiscalCalendar.fiscalYears) fiscalCalendar.fiscalYears = [];

    var fiscalYears = fiscalCalendar.fiscalYears;

    var defaultStartDate = fiscalCalendar.defaultDate,
        defaultStartMonth = fiscalCalendar.defaultMonth;
    // If unspecified default to calendar years.
    if (defaultStartDate == null) defaultStartDate = 1;
    if (defaultStartMonth == null) defaultStartMonth = 0;

    // In order to rapidly find the fiscalYearObject associated with some date,
    // do a one-time calculation of the start and endDates of each specified fiscal year
    // and store them on the objects.

    var initialized = true;
    for (var i = 0; i < fiscalYears.length; i++) {
        if (fiscalYears[i].startDate == null || fiscalYears[i].endDate == null) {
            initialized = false;

            fiscalYears[i].startDate = this.createDatetime(
                                        fiscalYears[i].year,
                                        fiscalYears[i].month,
                                        fiscalYears[i].date
                                       );
       }
    }
    fiscalYears.setSort({property: "startDate", direction: "ascending" });
    if (!initialized) {
        for (var i = 0; i < fiscalYears.length; i++) {
            var endDate;

            var fy = fiscalYears[i],
                nextFY = fiscalYears[i+1];
            // If the next entry in the fiscalYears array starts in the following year
            // (or later in the same year), consider that the end date for this FY.
            // Otherwise use the defaultDate/defaultMonth of the next year.
            // This allows the specified fiscalYears array to be sparse
            // (For example custom behavior could be specified for 2000 and 2010 only, and
            // every year in between will use the default month/date start)
            if (nextFY && (nextFY.year == fy.year || (nextFY.year == fy.year+1))) {
                fy.endDate = new Date(nextFY.startDate.getTime()-1);
            } else {

                fy.endDate = this.createDatetime(
                                fy.year+1, defaultStartMonth, defaultStartDate);
                // reduce by 1ms so it's the end of the prev day
                // This will avoid confusion with whether it rolls over a year
                // if the date is actually jan 1st
                fy.endDate.setTime(fy.endDate.getTime()-1);
            }
        }
    }


    // If we're passed just a year value, return the fiscalYear definition where
    // 'fiscalYear' is set to the specified date (may have to be created)
    if (!isc.isA.Date(date)) {

        var fiscalYearObj = fiscalYears.find("fiscalYear", date);
        if (fiscalYearObj != null) {
             return fiscalYearObj;
        }

        // We know we need to create a new fiscalYear object who's fiscalYear
        // property will be set to the specified date value.
        var calendarYear = date;
        if (fiscalCalendar.defaultYearMode != "start" &&
            (defaultStartMonth != 0 || defaultStartDate != 1))
        {
            calendarYear -= 1;
        }
        // Build a default object and return it.

        var result = {
            year:calendarYear,
            fiscalYear:date,
            month:defaultStartMonth,
            date:defaultStartDate,
            startDate: this.getStartOf(new Date(calendarYear, defaultStartMonth,
                                                defaultStartDate), "d")
        };
        return result;

    } else {
        var date_timestamp = date.getTime();
        // Array should already be sorted - re-sort just in case it was missed.
        fiscalYears.sortByProperty("startDate", Array.ASCENDING);
        for (var i = 0; i < fiscalYears.length; i++) {
            if (date_timestamp < fiscalYears[i].startDate.getTime()) break;
            if (date_timestamp <= fiscalYears[i].endDate.getTime()) {
                // date falls between start and end of the specified fiscal year so use it.
                return fiscalYears[i];
            }
        }

        // At this point we know we didn't have an entry in the fiscal years array
        // for this date, so create one based on the default start date
        var dateYear = date.getFullYear(),
            startDate = this.createDatetime(dateYear,
                                          defaultStartMonth,
                                          defaultStartDate);
        // Date falls before default start date, shift back a year.
        if (startDate.getTime() > date_timestamp) {
            dateYear -= 1;
            startDate = this.createDatetime(dateYear,
                                          defaultStartMonth,
                                          defaultStartDate);
        }

        // Calculate the endDate - the year it falls in will determine the reported
        // 'fiscalYear'.
        var endDate = this.createDatetime(dateYear+1,
                                          defaultStartMonth,
                                          defaultStartDate);
        // Shunt back to the end of the prev day.
        endDate.setTime(endDate.getTime()-1);

        // If there's a specified fiscalYear in our array that starts before the
        // calculated endDate, truncate this year a little earlier to account for it.
        var endDate_timestamp = endDate.getTime();
        for (var i = 0; i < fiscalYears.length; i++) {

            if (endDate_timestamp < fiscalYears[i].endDate.getTime()) {
                continue;
            } else {
                if (endDate_timestamp > fiscalYears[i].startDate.getTime()) {
                    endDate = new Date(fiscalYears[i].startDate.getTime()-1);
                } else break;
            }
        }

        var fiscalYear = dateYear;
        // If we span 2 calendar years and the year mode is set to "end",
        // (or unset - since this is default behavior), increment the fiscal year to
        // match the end date.
        if (endDate.getFullYear() != startDate.getFullYear()
             && fiscalCalendar.defaultYearMode != "start")
        {
            if (endDate.getFullYear() < date.getFullYear()) {
                fiscalYear = date.getFullYear();

                var tempStart = new Date(fiscalYear, defaultStartMonth, defaultStartDate);
                if (date.getTime() > tempStart.getTime()) {
                    fiscalYear++;
                }
            } else {
                fiscalYear = endDate.getFullYear();
            }
        }

        return {
            year:dateYear,
            fiscalYear:fiscalYear,
            date:defaultStartDate,
            month:defaultStartMonth
        };

    }
},

//>    @classMethod DateUtil.setShowChooserFiscalYearPickers()
// Sets the global attribute that dictates whether the +link{DateChooser, choosers} shelled
// from +link{DateItem, DateItems} show a UI for working with Fiscal Years.
//
// @param showChooserFiscalYearPickers (boolean) whether to show Fiscal Year pickers in DateChoosers by default
// @visibility external
//<
setShowChooserFiscalYearPickers : function (showChooserFiscalYearPickers) {
    isc.DateItem.addProperties({
        showChooserFiscalYearPicker: showChooserFiscalYearPickers
    });
    isc.DateChooser.addProperties({
        showFiscalYearChooser: showChooserFiscalYearPickers
    });
},

//>    @classMethod DateUtil.setShowChooserWeekPickers()
// Sets the global attribute that dictates whether the +link{DateChooser, choosers} shelled
// from +link{DateItem, DateItems} show a UI for working with Weeks.
//
// @param showChooserWeekPickers (boolean) whether to show Fiscal Week pickers in DateChoosers by default
// @visibility external
//<
setShowChooserWeekPickers : function (showChooserWeekPickers) {
    isc.DateItem.addProperties({
        showChooserWeekPicker: showChooserWeekPickers
    });
    isc.DateChooser.addProperties({
        showWeekChooser: showChooserWeekPickers
    });
},


//>    @classMethod DateUtil.setFirstDayOfWeek()
// Sets the global attribute that dictates which day should be treated as the first day of the
// week in calendars and date calculations.  The parameter is expected to be an integer value
// between 0 (Sunday) and 6 (Saturday).
// <P>
// The default value is picked up from the current locale.
//
// @param firstDayOfWeek (int) the number of the day to use as the first day of the week
// @visibility external
//<
setFirstDayOfWeek : function (firstDayOfWeek) {
    if (isc.DateChooser) {
        if (firstDayOfWeek == null || firstDayOfWeek < 0 || firstDayOfWeek > 6)
            firstDayOfWeek = 0;
        isc.DateChooser.addProperties({firstDayOfWeek: firstDayOfWeek});
    }
},

//>    @classMethod DateUtil.getFirstDayOfWeek()
// Returns the global attribute that dictates which day should be treated as the first day of
// the week in calendars and date calculations.  The parameter is expected to be an integer
// value between 0 (Sunday) and 6 (Saturday).
// <P>
// The default value is picked up from the current locale.
//
// @return (int) the number of the day being used as the first day of the week
// @visibility external
//<
getFirstDayOfWeek : function () {
    if (isc.DateChooser) {
        return isc.DateChooser.getInstanceProperty("firstDayOfWeek");
    }
    return 0;
},



//>    @classMethod DateUtil.getFiscalYear()
// Returns the +link{FiscalYear} object for the fiscal year in which the passed date exists.
//
// @param date (Date | int) the date to get the fiscal year for
// @param [fiscalCalendar] (FiscalCalendar) the object representing the start of the fiscal period
// @return (FiscalYear) the +link{FiscalYear} object for the passed date
// @visibility external
//<
getFiscalYear : function (date, fiscalCalendar) {
    return this._getFiscalYearObjectForDate(date, fiscalCalendar);
},

//>    @classMethod DateUtil.getFiscalWeek()
// Returns a date's week-number, according to the fiscal calendar
//
// @param date (Date) the date to get the fiscal year for
// @param [fiscalCalendar] (FiscalCalendar) the object representing the starts of fiscal years
// @return (int) the fiscal week for the passed date
// @visibility external
//<
getFiscalWeek : function (date, fiscalCalendar, firstDayOfWeek) {
    fiscalCalendar = fiscalCalendar || this.getFiscalCalendar();

    var yearStart = this.getFiscalStartDate(date, fiscalCalendar),
        logicalYearStart = this.getLogicalDateOnly(yearStart),
        logicalDate = date.logicalDate ? date : this.getLogicalDateOnly(date);
    return this._getWeekOffset(logicalDate, logicalYearStart, firstDayOfWeek);
},

// Used by getWeek() / getFiscalWeek()
_stackCount:0,
_getWeekOffset : function (date, startDate, firstDayOfWeek) {
    // this method isn't based on january 1 - instead, it's based on the start of the week
    // containing the first thursday in the year (catering for firstDayOfWeek)
    // - take the start of the passed date's week and divide the delta by 7 days
    // - add 1
    if (firstDayOfWeek == null) {
        firstDayOfWeek = isc.DateChooser.getInstanceProperty("firstDayOfWeek");
    }
    var weekStart = this.getStartOf(date, "w", true, firstDayOfWeek);

    // calculate the day-diff in UTC days, which are always 24 hours long - fixes
    // an incorrect week-number for the week including the spring DST change
    var days = isc.DateUtil.daysBetween(startDate, weekStart);
    var weeks = Math.floor(days / 7);

    return weeks + 1;
},

treatAsUTC : function (date) {
    var result = new Date(date);
    result.setMinutes(result.getMinutes() - result.getTimezoneOffset());
    return result;
},

daysBetween : function (startDate, endDate) {
    var millisecondsPerDay = 24 * 60 * 60 * 1000;
    return (isc.DateUtil.treatAsUTC(endDate) - isc.DateUtil.treatAsUTC(startDate)) / millisecondsPerDay;
},

isWeekend : function (date, weekendDays) {
    return !isc.DateUtil.isWeekday(date, weekendDays);
},
isWeekday : function (date, weekendDays) {
    var logicalDate = isc.DateUtil.createLogicalDate(date);
    var result = !(weekendDays || isc.DateUtil.getWeekendDays()).contains(logicalDate.getDay());
    return result;
},
getNextWeekday : function (date, weekendDays, includeParamDate) {
    weekendDays = weekendDays || isc.DateUtil.getWeekendDays();

    //var newDate = isc.DateUtil.createLogicalDate(date);
    var newDate = date.duplicate();

    // if the passed date is a weekday, and includeParamDate is true, just return the copy as-is
    if (includeParamDate && isc.DateUtil.isWeekday(newDate)) return newDate;

    newDate.setDate(newDate.getDate()+1);
    while (!isc.DateUtil.isWeekday(newDate, weekendDays)) {
        newDate.setDate(newDate.getDate()+1);
    }
    return newDate;
},
getPreviousWeekday : function (date, weekendDays, includeParamDate) {
    weekendDays = weekendDays || isc.DateUtil.getWeekendDays();

    //var newDate = isc.DateUtil.createLogicalDate(date);
    var newDate = date.duplicate();

    // if the passed date is a weekday, and includeParamDate is true, just return the copy as-is
    if (includeParamDate && isc.DateUtil.isWeekday(newDate)) return newDate;

    newDate.setDate(newDate.getDate()-1);
    while (!isc.DateUtil.isWeekday(newDate, weekendDays)) {
        newDate.setDate(newDate.getDate()-1);
    }
    return newDate;
},


//>    @classMethod DateUtil.setLocaleStringFormatter() (A)
// Set default the +link{Date.iscToLocaleString()} formatter for all date instances.
//
//        @param    format (DateDisplayFormat | Function) new formatter for iscToLocaleString()
//        @group    dateFormatting
//      @visibility internal
//<

setLocaleStringFormatter : function (functionName) {
    if (isc.isA.Function(Date.prototype[functionName]) || isc.isA.Function(functionName))
        Date.prototype.localeStringFormatter = functionName;
},

//>    @classMethod DateUtil.today()
// Return a <code>logicalDate</code> representing the current day in the
// +link{time.setDefaultDisplayTimezone, defaultDisplayTimezone}.
// @group dateFormatting
// @visibility external
//<
today : function () {
    // return today in the defaultDisplayTimezone
    return isc.DateUtil.getLogicalDateOnly(new Date());
},

// Localizing dayName / monthNames
//> @classAttr DateUtil.shortDayNames (Array : null : IRWA)
// This property may be set to an array of names of days of the week. <br>
// For example:
// <pre>
// ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]
// </pre>
// The appropriate day name will then be returned from +link{date.getShortDayName()}, and may
// be used whenever SmartClient components display day-names (for example in the
// +link{class:DateItem, DateItem class}).<br>
// Note: For US based applications the first item in the array should be the name for Sunday,
// then Monday, Tuesday, etc. For browsers with different locales this may vary.
// To determine the first day for some locale, you can run the following code:
// <pre>
//    alert(new Date(2000, 0, 2).getDay());
// </pre>
// You should see an alert with a number between zero and 6. This represents the numerical
// 'day' value for Sunday for your browser's locale, since Jan 2nd 2000 was a Sunday.
// Therefore if this code alerted the number 6, Sunday should appear last in your list
// of day-names, and Monday first.
// @group i18nMessages
// @visibility external
//<



//> @classAttr DateUtil.dayNames (Array : null : IRWA)
// This property may be set to an array of names of days of the week. <br>
// For example:
// <pre>
// ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
// </pre>
// The appropriate day name will then be returned from +link{date.getDayName()} and
// +link{dateUtil.getDayNames()}, and may
// be used whenever SmartClient components display day-names (for example in the
// +link{class:DateItem, DateItem class}).<br>
// @group i18nMessages
// @visibility external
//<
dayNames: ["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],

//> @classAttr DateUtil.shortMonthNames (Array : null : IRWA)
// This property may be set to an array of shortened month-names.<br>
// For example:
// <pre>
// ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
// </pre>
// The appropriate month name will then be returned from +link{date.getShortMonthName()},
// and may be used whenever SmartClient components display month-names (for example in the
// +link{class:DateItem, DateItem class}).
// @group i18nMessages
// @visibility external
//<


derivedShortMonthNameLength: 3,

//> @classAttr DateUtil.monthNames (Array : null : IRWA)
// This property may be set to an array of names of months.<br>
// For example:
// <pre>
// ["January", "February", "March", "April", "May", "June", "July",
//  "August", "September", "October", "November", "December"]
// </pre>
// The appropriate month name will then be returned from +link{date.getMonthName()},
// and may be used whenever SmartClient components display month-names (for example in the
// +link{class:DateItem, DateItem class}).
// @group i18nMessages
// @visibility external
//<
monthNames: ["January","February","March","April","May","June","July","August","September",
             "October","November","December"],

//>    @classMethod DateUtil.getShortMonthNames() (A)
// Return an array of the short names of each month, suitable for use in a selection list, etc.
// If +link{DateUtil.shortMonthNames} is specified, this list will be used - by default, all
// locales specify shortMonthNames.
// @param length (int) maximum length of each day string - default is no maximum (full strings)
// @return (Array of String) array of short month names
// @group dateFormatting
//<
getShortMonthNames : function (length) {
    var rawNames = this.shortMonthNames || Date.shortMonthNames;



    // NOOP starts - this block of code will never run, because shortMonthNames will alway be set
    if (rawNames == null) rawNames = this._derivedShortMonthNames;
    if (rawNames == null) {
        var list = this._derivedShortMonthNames = [];
        for (var i = 0; i < 12; i++) {
            // Changed the day in this synthetic date to 2 in order to derive the
            // correct month in timezones that are ahead of GMT (if you convert
            // midnight on the first of a month to UTC in such timezones, you
            // get the previous month...)
            var date = this.createLogicalDate(2000,i,2);
            // have deriveShortMonthNames() return the shortened strings according to the
            // internal default (3 chars)
            list[i] = date.deriveShortMonthName(this.derivedShortMonthNameLength);
        }
        rawNames = this._derivedShortMonthNames;
    }
    // NOOP ends

    var names = [];
    for (var i =0; i< 12; i++) {
        if (!length) {
            // zero or null length - return the full rawName - we used to default to 3 chars,
            // but that's a bit pointless, since the rawNames are already *short*MonthNames,
            // but they may not be 3 chars long, or of *any* fixed length
            names[i] = rawNames[i];
        } else {
            names[i] = rawNames[i].substring(0,length);
        }
    }
    return names;
},

//>    @classMethod DateUtil.getMonthNames() (A)
// Return an array of the full names of each month, suitable for use in a selection list, etc.
// If +link{DateUtil.monthNames} is specified, this list will be used. Otherwise the value
// will be derived from the native browser date formatters.  Note, if we have to derive names
// from the native browser date string, the day names may be in an abbreviated form, like the
// result of calling +link{getShortMonthNames()} - we have no control over this, we have to work
// with whatever the browser returns, which may vary by browser as well as locale.  If a
// consistent and correct set of day names is important in your application, ensure that
// <code>DateUtil.monthNames</code> is set.
// @group dateFormatting
// @return (Array of String) array of month names
//<
getMonthNames : function () {
    var rawNames = Date.monthNames || this.monthNames;
    if (rawNames == null) rawNames = this._derivedMonthNames;
    if (rawNames == null) {
        var list = this._derivedMonthNames = [];
        for (var i = 0; i < 12; i++) {
            // Changed the day in this synthetic date to 2 in order to derive the
            // correct month in timezones that are ahead of GMT (if you convert
            // midnight on the first of a month to UTC in such timezones, you
            // get the previous month...)
            var date = this.createLogicalDate(2000,i,2);
            list[i] = this.deriveMonthName();
        }
        rawNames = this._derivedMonthNames;
    }
    return rawNames;
},

//>    @classMethod DateUtil.getShortDayNames() (A)
// Return an array of the short names of each day, suitable for use in a selection list, etc.
// Day names are picked up from a +link{DateUtil.shortDayNames} list specified in each locale.
// @group dateFormatting
// @param length (int) maximum length of each day string - default is no maximum (full strings)
// @return (Array of String) array of short day names
// @visibility external
//<
getShortDayNames : function (length) {
    length = length || 3;
    var rawNames = this.shortDayNames || Date.shortDayNames;
    if (rawNames == null) rawNames = this._derivedShortDayNames;
    if (rawNames == null) {
        this._derivedShortDayNames = [];
        var dateObj = new Date();
        dateObj.setDate(1);
        if (dateObj.getDay() > 0) dateObj.setDate(dateObj.getDate() + (7-dateObj.getDay()));
        var startDate = dateObj.getDate();
        for (var i = 0; i < 7; i++) {
            dateObj.setDate(startDate + i);
            this._derivedShortDayNames[i] = dateObj.deriveShortDayName();
        }
        rawNames = this._derivedShortDayNames;
    }
    var names = [];
    for (var i = 0; i < 7; i++) {
        names[i] = rawNames[i].substring(0,length);
    }
    return names;
},

//> @classMethod DateUtil.getDayNames() (A)
// Return an array of the full names of each day, suitable for use in a selection list, etc.
// Day names are picked up from +link{DateUtil.dayNames}, which defaults to an array of
// English-language strings and these are updated to localized values by loading a locale.
// <p>
// If <code>DateUtil.dayNames</code> is purposely cleared, this method will fall back to
// deriving day-names from the native browser date string.  Note, if we have to use this native
// backup behavior, the day names may vary by browser as well as locale - for example, they
// may be in an abbreviated form, similar to the result of calling
// +link{DateUtil.getShortDayNames}.
// @group dateFormatting
// @return (Array of String) array of day names
// @visibility external
//<
getDayNames : function () {
    var rawNames = Date.dayNames || this.dayNames;
    if (rawNames == null) rawNames = this._derivedDayNames;
    if (rawNames == null) {
        this._derivedDayNames = [];
        var dateObj = new Date();
        dateObj.setDate(1);
        if (dateObj.getDay() > 0) dateObj.setDate(dateObj.getDate() + (7-dateObj.getDay()));
        var startDate = dateObj.getDate();
        for (var i = 0; i < 7; i++) {
            dateObj.setDate(startDate + i);
            this._derivedShortDayNames[i] = dateObj.deriveDayName();
        }
        rawNames = this._derivedDayNames;
    }
    var names = [];
    for (var i = 0; i < 7; i++) {
        names[i] = rawNames[i];
    }
    return names;
},

//> @classAttr DateUtil.weekendDays (Array of int : [0, 6] : IR)
// Days that are considered "weekend" days.   Values should be the integers returned by the
// JavaScript built-in Date.getDay(), eg, 0 is Sunday and 6 is Saturday.  Override to
// accommodate different workweeks such as Saudi Arabia (Saturday -> Wednesday) or Israel
// (Sunday -> Thursday).
//
// @visibility external
//<

//> @classMethod DateUtil.setWeekendDays()
// Sets the days that are considered +link{DateUtil.weekendDays, weekend days}.  The parameter
// should be array of the integers returned by the JavaScript built-in Date.getDay(), eg, 0 is
// Sunday and 6 is Saturday.  Override to accommodate different workweeks such as Saudi Arabia
// (Saturday -> Wednesday) or Israel (Sunday -> Thursday).
//
// @param weekendDays (Array of Integer) the array of day-numbers to assign as weekend days
// @visibility external
//<
setWeekendDays : function (weekendDays) {
    this.weekendDays = weekendDays;
},

//> @classMethod DateUtil.getWeekendDays()
// Return an array of days that are considered "weekend" days. Values will be the integers
// returned by the JavaScript built-in Date.getDay(), eg, 0 is Sunday and 6 is Saturday.
// Override +link{DateUtil.weekendDays} to accommodate different workweeks such as Saudi Arabia
// (Saturday -> Wednesday) or  Israel (Sunday -> Thursday).
// @group dateFormatting
//
// @return (Array of Integer) array of weekend days
// @visibility external
//<
getWeekendDays : function () {
    var daysArr = this.weekendDays || Date.weekendDays;
    if (daysArr == null) daysArr = this._derivedWeekendDays;
    if (daysArr == null) {
        daysArr = this._derivedWeekendDays = [0, 6];
    }
    return daysArr;
},

getFormattedDateRangeString : function (fromDate, toDate) {
    if (fromDate != null && !isc.isA.Date(fromDate)) {
        fromDate = null;
    }
    if (toDate != null && !isc.isA.Date(toDate)) {
        toDate = null;
    }
    var fromMonth = fromDate ? fromDate.getMonth() : null,
        fromMonthName = fromDate ? fromDate.getShortMonthName() : null,
        fromYear = fromDate ? fromDate.getFullYear() : null,
        fromDay = fromDate ? fromDate.getDate() : null,
        toMonth = toDate ? toDate.getMonth() : null,
        toMonthName = toDate ? toDate.getShortMonthName() : null,
        toYear = toDate ? toDate.getFullYear() : null,
        toDay = toDate ? toDate.getDate() : null,
        result = ""
    ;

    if (fromDate && toDate) {
        if (fromYear == toYear) {
            // dates are in the same year - check the months
            if (fromMonth == toMonth) {
                // dates are in the same month - check the day-numbers
                if (fromDay == toDay) {
                    // dates are the same - use just the one date
                    result = fromMonthName + " " + fromDate.getDate() + ", " + fromYear;
                } else {
                    // day-numbers are different, use "month start - end, year"
                    result = fromMonthName + " " + fromDate.getDate() + " - " +
                        toDate.getDate() + ", " + fromYear;
                }
            } else {
                // dates are in different months, use "month start - month end, year"
                result = fromMonthName + " " + fromDate.getDate() + " - " +
                    toMonthName + " " + toDate.getDate() + ", " + fromYear;
            }
        } else {
            // different years - use "month start year - month end year"
                result = fromMonthName + " " + fromDate.getDate() + ", " + fromYear + " - " +
                    toMonthName + " " + toDate.getDate() + ", " + toYear;
        }
    } else if (fromDate) {
        // only a fromDate provided use "month start - end, year"
        result = fromMonthName + " " + fromDate.getDate() + ", " + fromYear;
    } else if (toDate) {
        // only a toDate provided use "month start - end, year"
        result = toMonthName + " " + toDate.getDate() + ", " + toYear;
    }

    return result;
},

// Helper to set the time to zero for a datetime

setToZeroTime : function (date) {
    if (date == null || !isc.isA.Date(date)) return date;

    // Clear the "logicalDate" flag so when we run through formatters we respect
    // developer specified timezone rather than displaying time in the browser native timezone
    var wasLogicalDate = date.logicalDate;
    date.logicalDate = false;

    var timestamp = date.getTime();

    // Apply the timezone offset such that if the default system-wide formatter is used
    // and applies the display timezone offset, 00:00 will be seen.
    var hourOffset = isc.Time.getUTCHoursDisplayOffset(date),
        minuteOffset = isc.Time.getUTCMinutesDisplayOffset(date)
    ;

    if (wasLogicalDate) {
        var previousDay = new Date(date);
        previousDay.setHours(0);
        previousDay.setMinutes(0);

        var previousDayHourOffset = isc.Time.getUTCHoursDisplayOffset(previousDay);
        if (hourOffset != previousDayHourOffset) {
            // logical dates have a time of 12-noon - if the date in question happens to be
            // the one that DST changes on, the final date (with a time of 00:00) will have
            // a different hourOffset - use that one instead.
            hourOffset = previousDayHourOffset;
        }
    }

    var utcHours = hourOffset > 0 ? 24-hourOffset : 0-hourOffset,
        utcMins = 60-minuteOffset;

    if (utcMins >= 60) {
        utcMins -= 60;

    // If the minute offset was non-zero and the offset as a whole is positive
    // we need to knock an additional hour off (as the hours/minutes are cumulative so
    // we otherwise will roll forward to 01:00 local time)

    } else if (utcMins != 0) {
        utcHours -= 1;
    }


    var oldDisplayDate;
    if (wasLogicalDate) {
        oldDisplayDate = date.getDate();
    } else {
        var offsetDate = date._getTimezoneOffsetDate(hourOffset, minuteOffset);
        oldDisplayDate = offsetDate.getUTCDate();
    }

    date.setUTCHours(utcHours);
    date.setUTCMinutes(utcMins);

    var displayOffsetDate = date._getTimezoneOffsetDate(hourOffset, minuteOffset),
        displayDate = displayOffsetDate.getUTCDate(),
        adjustedUTCHours = utcHours;

    if (displayDate != oldDisplayDate) {
        // Cant just check for displayDate > oldDisplayDate since it might be the first or
        // last of a month...
        var moveForward = date.getTime() < timestamp;

        adjustedUTCHours += moveForward ? 24 : -24;
        date.setUTCHours(adjustedUTCHours);
    }


    if (date.getUTCHours() != utcHours) {
        date.setTime(timestamp);
        date.setUTCHours(adjustedUTCHours+1);
        if (date.getUTCHours() != utcHours+1) {
            date.setTime(timestamp);
            date.setUTCHours(adjustedUTCHours+2);
        }
    }

    // No need to return the date - we updated it directly.

}

});

//
//    add methods to the Date.prototype for additional formatting options
//
isc.addMethods(Date.prototype, {

//>    @method        date.duplicate()    (A)
//      Copy the value of this date into a new Date() object for independent manipulation
//  @visibility external
//<
duplicate : function () {
    var newDate = new Date();
    newDate.setTime(this.getTime());
    newDate.logicalDate = this.logicalDate;
    newDate.logicalTime = this.logicalTime;
    newDate._fromRelativeDate = this._fromRelativeDate;
    newDate._relativeDateTimestamp = this._relativeDateTimestamp
    return newDate;
},

//>    @method        date.clearTimeFields()    (A)
//            Zero-out the time fields for a date.
//        @group    dateFormatting
//<
clearTimeFields : function () {
    this.setHours(0);
    this.setMinutes(0);
    this.setSeconds(0);
    this.setMilliseconds(0);
    return this;
},




// Determine the day name from this.toString()
deriveShortDayName : function (length) {
    var string = this.toString();
    if (length == null || length <=0 || length > 3) length = 3;
    return string.substring(0,length);
},

// Determine the day name from this.toString(), without a target length
deriveDayName : function () {
    var string = this.toString();
    var length = string.indexOf(" ");
    return string.substring(0,length);
},

//>    @method        date.getShortDayName()
// Return the abbreviated (up to 3 chars) day of week name for this date (Mon, Tue, etc).
// To modify the value returned by this method, set +link{DateUtil.shortDayNames}
//
//        @group    dateFormatting
//      @param  length  (int)    Number of characters to return (Defaults to 3, can't be
//                                  longer than 3)
//        @return        (String)    Abbreviated day name
//      @visibility external
//<
getShortDayName : function () {
    return isc.DateUtil.getShortDayNames()[this.getDay()];
},

//>    @method        date.getDayName()
// Return the full day of week name for this date (Monday, Tuesday, etc).
// To modify the value returned by this method, set +link{DateUtil.dayNames}
//
// @group    dateFormatting
// @return        (String)    Day name
// @visibility external
//<
getDayName : function () {
    return isc.DateUtil.getDayNames()[this.getDay()];
},

// deriveShortMonthNames() - figure out the names of months from the native browser
// date formatting methods.
deriveShortMonthName : function (length) {
    // Use this.toUTCString - to work around Opera's different toString format
    var string = this.toUTCString();
    var start = 8;  // The correct start point if we have a 2-digit day portion in the date

    var defaultLength = Date.derivedShortMonthNameLength;
    if (length == null || length < 0 || length > defaultLength) length = defaultLength;

    if (string.substring(6, 7) == ' ') {  // we have a single-digit day number - only IE
                                          // does this, the others put a leading 0 in
        start = 7;
    }
    return string.substring(start, (start+length));
},

deriveMonthName : function () {
    // Use this.toUTCString - to work around Opera's different toString format
    var string = this.toUTCString();
    var start = 8;  // The correct start point if we have a 2-digit day portion in the date
    if (string.substring(6, 7) == ' ') {  // we have a single-digit day number - only IE
                                          // does this, the others put a leading 0 in
        start = 7;
    }
    var length = string.indexOf(" ", start);
    return string.substring(start, (start+length));
},


//>    @method date.getShortMonthName()
// Return the abbreviated name of the month for this date (Jan, Feb, etc)
// To modify the value returned by this method,
// <smartclient>set +link{DateUtil.shortMonthNames}</smartclient>
// <smartgwt>use {@link com.smartgwt.client.util.DateUtil#setShortMonthNames()}</smartgwt>.
// @param length (int) Number of characters to return (Defaults to 3, can't be longer than 3)
// @return (String) Abbreviated month name (3 character string)
// @group dateFormatting
// @visibility external
//<
getShortMonthName : function (length) {
    return isc.DateUtil.getShortMonthNames(length)[this.getMonth()];
},

//>    @method        date.getMonthName()
// Return the full name of the month for this date (January, February, etc)
// To modify the value returned by this method,
// <smartclient>set +link{DateUtil.shortMonthNames}</smartclient>
// <smartgwt>use {@link com.smartgwt.client.util.DateUtil#setMonthNames()}</smartgwt>.
// @group    dateFormatting
// @return        (String)    Month name
// @visibility external
//<
getMonthName : function () {
    return isc.DateUtil.getMonthNames()[this.getMonth()];
},

//>    @method        date.getShortYear()
//      Return a 2 digit year for this date.
//    @group    dateFormatting
//    @return        (String)    year number, padded to 2 characters
//  @visibility external
//<
getShortYear : function () {
    var year = this.getFullYear();
    return (year % 100).stringify(2);
},


firstWeekIncludesDay: 4,
getYearStart : function (firstDayOfWeek) {
    if (firstDayOfWeek == null) {
        firstDayOfWeek = isc.DateChooser.getInstanceProperty("firstDayOfWeek");
    }

    var yearStart = isc.DateUtil.createLogicalDate(this.getFullYear(),0,1);

    var delta = 0;
    if (yearStart.getDay() < this.firstWeekIncludesDay) {
        // eg, firstDayOfWeek is saturday, jan 1 is wednesday - first thursday is jan 2
        delta = this.firstWeekIncludesDay - yearStart.getDay();
    } else if (yearStart.getDay() > this.firstWeekIncludesDay) {
        // eg, jan 1 is friday - jan 1 + ((7-5) + 4) = first thursday is jan 7
        delta = (7 - yearStart.getDay()) + this.firstWeekIncludesDay;
    }
    if (delta != 0) yearStart.setDate(yearStart.getDate() + delta);

    // yearStart is now the first thursday on or after jan 1 - just return the start of week
    yearStart = isc.DateUtil.getStartOf(yearStart, "W", true, firstDayOfWeek);
    return yearStart;
},

//>    @method date.getWeek()
// Returns an integer containing the week number.
// @group dateFormatting
// @return (int) week number, starting with 1
// @visibility external
//<
getWeek : function (firstDayOfWeek) {
    var logicalDate = this;

    // Normalize to a logical date, and compare with the logical yearStart - this will get rid
    // of any oddities around time of day and custom timezones etc (any datetime within the
    // logical day will round to the same logicalDate object)
    if (!this.logicalDate) {
        logicalDate = isc.DateUtil.getLogicalDateOnly(this);
    }

    if (firstDayOfWeek == null) {
        firstDayOfWeek = isc.DateChooser.getInstanceProperty("firstDayOfWeek");
    }

    // get the start of the week that contains the first (Thursday) after January 1
    var yearStart = logicalDate.getYearStart(firstDayOfWeek);

    // make sure it's a logical date
    if (!yearStart.logicalDate) yearStart = isc.DateUtil.getLogicalDateOnly(yearStart);

    if (logicalDate.getTime() < yearStart.getTime()) {
        // this date is before the calculated yearStart - return a week offset for this date
        // into the previous year, by taking a week off the yearStart
        return isc.DateUtil.getAbsoluteDate("-1w", yearStart).getWeek(firstDayOfWeek);
    }

    // divide the day delta between this date and the yearStart by 7 and add 1
    var result = Math.floor((logicalDate.getTime() - yearStart.getTime()) / (60000 * 60 * 24 * 7)) + 1;
    return result;
},

getFiscalCalendar : function () {
    return isc.DateUtil.getFiscalCalendar();
},

//>    @method date.getFiscalYear()
// Returns the +link{FiscalYear} object appropriate for the the current date, according to the
// +link{FiscalCalendar, FiscalCalendar}.
// @return (FiscalYear) the fiscal year object
// @visibility external
//<
getFiscalYear : function (fiscalCalendar) {
    return isc.DateUtil.getFiscalYear(this, fiscalCalendar);
},

//>    @method date.getFiscalWeek()
// Returns the fiscal week number of the current date, according to the global
// +link{DateUtil.setFiscalCalendar, FiscalCalendar}.
// @param [fiscalCalendar] (FiscalCalendar) the object representing the starts of fiscal years
// @return (int) the week number, offset from the start of the fiscal period
// @visibility external
//<
getFiscalWeek : function (fiscalCalendar, firstDayOfWeek) {
    return isc.DateUtil.getFiscalWeek(this, fiscalCalendar, firstDayOfWeek);
},

//
// Date Formatters (toNormalDate(), toShortDate(), etc.)
//
// Date formatters are applied to date objects to convert them into strings for display.
// Dates are intended to be localizable.
// For localization, a developer would typically set either the shortDateFormatter or
// normalDateFormatter, as well as the inputDateFormat, and then call
// "toNormalDate()" / "toShortDate()" and "parseInput()" as normal.

//>    @method        date.toDateStamp()
//            Return this date in the format (UTC timezone):
//                <code><i>YYYYMMDD</i>T<i>HHMMSS</i>[Z]</code>
//        @group    dateFormatting
//        @return                    (String)    formatted date string
//  @visibility external
//<
toDateStamp : function () {
    return    this.getUTCFullYear()
          + (this.getUTCMonth()+1).stringify()
          + this.getUTCDate().stringify()
          + "T"
          +    this.getUTCHours().stringify()
          + this.getUTCMinutes().stringify()
          + this.getUTCSeconds().stringify()
          + "Z";
},

//>    @method date.toNormalDate()
// Returns the date as a formatted string using the format set up via the
// <code>setNormalDisplayFormat()</code> method. Note that the default formatter for this
// method is <code>"toLocaleString"</code>.
// @group   dateFormatting
// @param format (DateDisplayFormat) Optional Format for the date returned
// @return  (String) formatted date string
// @visibility external
//<
// This method is used by our data components such as ListGrid to display long format dates.
// @param useCustomTimezone (boolean) If true, format the date using the timezone
//  setDefaultDisplayTimezone() rather than the native browser locale.
//  Defaults to true.
//  Has no effect if no custom timezone applied
//  * Note that the native browser formatters including toLocaleString won't respect the
//    developer specified timezone of course. We could workaround this (create a new date, shift
//    by offset between specified timezone and native timezone, and call the native formatter on that)
//    but we currently don't.
toNormalDate : function (formatter, useCustomTimezone) {


    if (!formatter) formatter = this.formatter;
    // fire the formatter in the scope of this date, so date is available as 'this'

    if (isc.isA.Function(formatter)) {
        return formatter.apply(this, [useCustomTimezone])
    } else if (this[formatter]) {
        return this[formatter](useCustomTimezone);
    } else if (isc.isA.String(formatter)) {
        return isc.DateUtil.format(this, formatter, useCustomTimezone);  // WWW - what about useCustomTimezone??
    }
},

toNormalDateTime : function (formatter, useCustomTimezone) {
    return this.toNormalDatetime(formatter, useCustomTimezone);
},

//>    @method date.toNormalDatetime()
// Returns the datetime as a formatted string using the format set up via the
// <code>setNormalDatetimeDisplayFormat()</code> method.
// @group   dateFormatting
// @param format (DateDisplayFormat) Optional Format for the date returned
// @param [useCustomTimezone] (Boolean) If a custom timezone has been set via
//   Time.setDefaultDisplayTimezone(), by default date formatters will respect this timezone.
//   To suppress this behavior, this parameter should be set to false.
// @return  (String) formatted date string
// @visibility external
//<
toNormalDatetime : function (formatter, useCustomTimezone) {
    if (!formatter) formatter = this.datetimeFormatter;
    return this.toNormalDate(formatter, useCustomTimezone);
},

//>    @method date.toShortDate()
// Returns the date as a formatted string using the format set up via the
// <code>setShortDisplayFormat()</code> method.
// @group   dateFormatting
// @param format (DateDisplayFormat) Optional Format for the date returned
// @param [useCustomTimezone] (Boolean) If a custom timezone has been set via
//   Time.setDefaultDisplayTimezone(), by default date formatters will respect this timezone.
//   to suppress this behavior, this parameter should be set to false.
// @return  (String) formatted date string
// @visibility external
//<

toShortDate : function (formatter, useCustomTimezone) {
    if (!formatter) formatter = this._shortFormat;
    if (isc.isA.Function(formatter)) return formatter.apply(this, [useCustomTimezone]);
    else if (isc.isA.Function(this[formatter])) {
        if (formatter == "toSerializeableDate") return this[formatter]();
        return this[formatter](useCustomTimezone);
    } else if (isc.isA.String(formatter)) {
        return isc.DateUtil.format(this, formatter, useCustomTimezone);  // WWW - what about useCustomTimezone??
    }

    isc.logWarn("Date.toShortDate() specified formatter not understood:" + formatter);
    return this.toUSShortDate();

},


//>    @method date.toShortDateTime()
// Returns the datetime as a formatted string using the format set up via the
// <code>setShortDatetimeDisplayFormat()</code> method.
// @group   dateFormatting
// @param format (DateDisplayFormat) Optional Format for the date returned
// @param [useCustomTimezone] (Boolean) If a custom timezone has been set via
//   Time.setDefaultDisplayTimezone(), by default date formatters will respect this timezone.
//   to suppress this behavior, this parameter should be set to false.
// @return  (String) formatted date string
// @visibility external
//<



toShortDateTime : function (formatter, useCustomTimezone) {
    return this.toShortDatetime(formatter,useCustomTimezone);
},

toShortDatetime : function (formatter, useCustomTimezone) {
    if (!formatter) formatter = this._shortDatetimeFormat;
    return this.toShortDate(formatter, useCustomTimezone);
},


//>    @method date.setDefaultDateSeparator
// Sets a new default separator that will be used when formatting dates. By default, this
// is a forward slash character: "/"
// @group dateFormatting
// @param separator (String) separator to use in dates
// @visibility external
//<
setDefaultDateSeparator : function (separator) {
    this._shortDateTemplate = [,,,,separator,,,,,separator,,,,null];
    this._separator = separator;
},

//>    @method date.getDefaultDateSeparator
// gets the default date separator string
// @group dateFormatting
// @return(String) the default date separator
// @visibility external
//<
getDefaultDateSeperator : function (separator) {
    if (this._separator) return this._separator;
    else return "/";
},


_shortDateTemplate:[,,,,"/",,,,,"/",,,,null],
_$MDY:"MDY",
_$DMY:"DMY",
_$YMD:"YMD",
_$MDY:"MDY",

// _applyTimezoneOffset()
// shift a date by some arbitrary number of hours/minutes
// third parameter allows you to specify the starting date time [result of date.getTime()]
// to offset from
_applyTimezoneOffset : function (hourOffset, minuteOffset, dateTime) {
    if (dateTime == null) dateTime = this.getTime();
    if (isc.isA.Number(hourOffset)) dateTime += (3600000 * hourOffset);
    if (isc.isA.Number(minuteOffset)) dateTime += (60000 * minuteOffset);
    this.setTime(dateTime);
},

// _getTimezoneOffsetDate()
// This is a helper method - given a date with a certain UTC time, apply an explicit timezone
// offset to return a date where the UTC time is offset by the specified hours/minutes.
// We'll use this when formatting dates for display in arbitrary local times [so we can't just
// use the native browser local timezone methods like getHours()]

_getTimezoneOffsetDate : function (hourOffset, minuteOffset) {
    var offsetDate = Date._timezoneOffsetDate;
    if (offsetDate == null) offsetDate = Date._timezoneOffsetDate = new Date();

    offsetDate._applyTimezoneOffset(hourOffset, minuteOffset, this.getTime());
    return offsetDate;

},


// _toShortDate()
// Internal method to give us a shortDate - either DD/MM/YYYY, MM/DD/YYYY or YYYY/MM/DD.
// this will be passed "MDY" / "DYM" / etc. as a format parameter.
// useCustomTimezone parameter: use the hour and minute offset specified by
// Time.setDefaultDisplayTimezone() rather than the native browser local timezone
_$zero:"0",
_toShortDate : function (format, useCustomTimezone) {

    // if this is a "logical date", don't use the developer-specified custom timezone when
    // formatting. Typically handled by DBC's passing in the useCustomTimezone parameter, but
    // we can also check for the logical date marker

    if (useCustomTimezone == null) {
        useCustomTimezone = !this.logicalDate;
    }
    var template = this._shortDateTemplate,
        month,day,year;

    // Browser native locale timezone
    if (!useCustomTimezone || !isc.Time._customTimezone) {
        month = this.getMonth()+1;
        day = this.getDate();
        year = this.getFullYear();

    // Developer specified custom timezone
    } else {
        var offsetDate = this._getTimezoneOffsetDate(
                            isc.Time.getUTCHoursDisplayOffset(this),
                            isc.Time.getUTCMinutesDisplayOffset(this)
                         );

        month = offsetDate.getUTCMonth() + 1;
        day = offsetDate.getUTCDate();
        year = offsetDate.getUTCFullYear();
    }

    var monthIndex, dayIndex, yearIndex;

    if (format == this._$MDY) {
        monthIndex = 0;
        dayIndex = 5;
        yearIndex = 10;
    } else if (format == this._$DMY) {
        dayIndex = 0;
        monthIndex = 5;
        yearIndex = 10;
    } else if (format == this._$YMD) {
        yearIndex = 0;
        monthIndex = 5;
        dayIndex = 10
    // Unlikely - don't bother avoiding string alloc's for every one of these options
    } else {
        dayIndex = format.indexOf("D")*5;
        yearIndex = format.indexOf("Y")*5;
        monthIndex = format.indexOf("M")*5;
    }

    // Note: each number has 4 slots so it can accommodate a full year
    // For month/day - if we need a leading zero, fill the first slot with it
    // Use fillNumber to fill 3 slots even though we have a max of 2 digits to ensure
    // the last slot gets cleared out if it was populated by a year already.
    template[dayIndex] = day < 10 ? this._$zero : null
    isc._fillNumber(template, day, dayIndex+1, 3);

    template[monthIndex] = month < 10 ? this._$zero : null
    isc._fillNumber(template, month, monthIndex+1, 3);

    template[yearIndex + 1] = null;
    isc._fillNumber(template, year, yearIndex, 4);
    return template.join(isc.emptyString);
},

//>    @method        date.toUSShortDate()
//            Return this date in the format: <code>MM/DD/YYYY</code>
//        @group    dateFormatting
//        @return                    (String)    formatted date string
//  @visibility external
//<
toUSShortDate : function (useCustomTimezone) {
    return this._toShortDate(this._$MDY, useCustomTimezone);
},

// _toShortTime - returns the time portion of the date in HH:MM
_timeTemplate:[null,null],
_toShortTime : function (useCustomTimezone) {

    return isc.Time.toShortTime(this, "toShortPadded24HourTime");
},

//>    @method        date.toUSShortDateTime()
//  Return this date in the format: <code>MM/DD/YYYY HH:MM</code>
//
//        @group    dateFormatting
//        @return                    (String)    formatted date string
//  @visibility external
//<
toUSShortDateTime : function (useCustomTimezone) {
    return this.toUSShortDatetime(useCustomTimezone);
},


toUSShortDatetime : function (useCustomTimezone) {
    return this.toUSShortDate(useCustomTimezone) + " " + this._toShortTime(useCustomTimezone);
},


//>    @method        date.toEuropeanShortDate()
//            Return this date in the format: <code>DD/MM/YYYY</code>
//        @group    dateFormatting
//        @return                    (String)    formatted date string
//      @visibility external
//<
toEuropeanShortDate : function (useCustomTimezone) {
    return this._toShortDate(this._$DMY, useCustomTimezone);
},

//>    @method        date.toEuropeanShortDateTime()
// Return this date in the format: <code>DD/MM/YYYY HH:MM</code>.
//        @group    dateFormatting
//        @return                    (String)    formatted date string
//      @visibility external
//<
toEuropeanShortDateTime : function (useCustomTimezone) {
    return this.toEuropeanShortDatetime();
},


toEuropeanShortDatetime : function (useCustomTimezone) {
    return this.toEuropeanShortDate(useCustomTimezone) + " " +
            this._toShortTime(useCustomTimezone);
},

//> @method date.toJapanShortDate()
// Return the date in this format: <code>YYYY/MM/DD</code>
// @group dateFormatting
// @return (String) formatted date string
// @visibility external
//<
toJapanShortDate : function (useCustomTimezone) {
    return this._toShortDate(this._$YMD, useCustomTimezone);
},

//>    @method        date.toJapanShortDateTime()
//            Return this date in the format: <code>YYYY/MM/DD HH:MM:SS</code>
//        @group    dateFormatting
//        @return                    (String)    formatted date string
//      @visibility external
//<
toJapanShortDateTime : function (useCustomTimezone) {
    return this.toJapanShortDatetime(useCustomTimezone);
},


toJapanShortDatetime : function (useCustomTimezone) {
    return this.toJapanShortDate(useCustomTimezone) + " " + this._toShortTime(useCustomTimezone);
},

//>    @method        date._serialize()    (A)
//            Serialize this date to a string in a format that can be reinstantiated back into a date.
//                <code>$$DATE$$:<i>YYYY</i>-<i>MM</i>-<i>DD</i></code>
//        @group    dateFormatting
//        @return                    (String)    formatted date string
//      @visibility internal
//<
_serialize : function () {
    if (isc.Comm._legacyJSMode) {
        // legacy mode: add $$DATE$$ that only our server-side JS parser understands
        return isc.SB.concat('"' + this.toDBDate(), '"');
    } else {
        // any other caller: return code that would reconstruct the same Date in a JS
        // interpreter

        return isc.SB.concat("new Date(", this.getTime(), ")");
    }
},



//> @groupDef dateFormatAndStorage
// The SmartClient system has the following features for handling Date and Time type values
// within DataSources and databound components.
// <P>
// DataSources and databound components may define fields of type <code>date</code>,
// <code>time</code>, or <code>datetime</code>.
// <P>
// <h3>"date" handling</h3>
// <P>
// Fields of type +link{type:FieldType,date} are considered to be logical Dates with no time
// value, such as a holiday or birthday.  In the browser, values for "date" fields are stored
// as Date objects, but when formatted for display to the user, they are typically displayed
// without any time information.
// <P>
// When using the SmartClient server framework, "date" values are automatically transmitted
// with year, month and day preserved and time value ignored.
// <P>
// When sent or received in XML or JSON, date field values should be serialized in the
// +externalLink{http://www.w3.org/TR/xmlschema-2/#dateTime,XML Schema date format} -
// <code>YYYY-MM-DD</code> - are expected to be received in the same format.  Any time value
// present for a "date" field is ignored.
// <smartclient>
// <P>
// The +link{DateUtil.createLogicalDate()} method may be used to create a new Date object to
// represent a logical date value on the browser.
// </smartclient>
// <smartgwt>
// <P>
// The DateUtil.createLogicalDate() method may be used to create a new Date object to represent
// a logical date value on the browser.
// </smartgwt>
// <P>
// System wide formatting for dates may be controlled via the
// +link{DateUtil.setNormalDisplayFormat()} and +link{DateUtil.setShortDisplayFormat()} methods.
// <P>
// <h3>"datetime" handling</h3>
// <P>
// Fields of type +link{type:FieldType,datetime} are dates with full time information.
// In the browser, values for datetime fields are stored as Date objects.
// <P>
// When using the SmartClient server framework, "datetime" values are automatically transmitted
// such that the resulting Date object has the same GMT/UTC timestamp.  This value is referred
// to elsewhere in these discussions as an "epoch value", and it is precisely defined as: the
// number of milliseconds since midnight on January 1st 1970 in the UTC timezone
// (because 1970-01-01 00:00:00 UTC is "the epoch").
// <P>
// To ensure that "datetime" values are persisted on the server with full millisecond resolution
// (rather than only seconds), you may need to set +link{dataSourceField.storeMilliseconds}.
// <P>
// When sent or received in XML or JSON, datetime field values should be serialized out as full
// datetimes using the standard
// +externalLink{http://www.w3.org/TR/xmlschema-2/#dateTime,XML Schema datetime format}
// (EG:<code>2006-01-10T12:22:04-04:00</code>).  If no timezone offset is supplied, the value
// is assumed to be GMT/UTC.
// <P>
// System wide formatting for datetimes may be controlled via the
// +link{DateUtil.setShortDatetimeDisplayFormat()} method.  Datetimes will be displayed to the
// user in browser local time by default (see also timezone notes below).
// <P>
// <h3>"time" handling</h3>
// <P>
// Fields of type +link{type:FieldType,time} are time values in the absence of a day, such as
// the beginning of the workday (9:00).  In the browser, values for "time" fields are stored as
// Date objects with the time in browser local time.  The date information has no meaning and
// only the time information is displayed to the user.
// <P>
// Time formatting is handled by the +link{Time} class APIs.
// <br>
// When using the SmartClient server framework, "time" values are automatically transmitted
// such that the resulting Date object has the same hour, minute and second values in local
// time, and year/month/day is ignored.
// <P>
// When sent or received in XML or JSON, date field values should be serialized as hours,
// minutes and seconds using the standard
// +externalLink{http://www.w3.org/TR/xmlschema-2/#dateTime,XML Schema time format} -
// <code>"22:01:45"</code>.  Timezone is not relevant and should be omitted.
// <smartclient>
// <P>
// The +link{DateUtil.createLogicalTime()} method may be used to create a new Date object to
// represent a logical time value on the browser.
// </smartclient>
// <smartgwt>
// <P>
// The DateUtil.createLogicalTime() method may be used to create a new Date object to represent
// a logical time value on the browser.
// </smartgwt>
// <P>
// <h3>Timezone settings and Daylight Savings Time</h3>
// <P>
// By default, "datetime" values will be shown to the user in browser local time, as derived
// from the native browser locale.  Developers may modify this behavior by specifying an
// explicit display timezone via +link{Time.setDefaultDisplayTimezone()}.
// <P>
// Note that depending on the specific date being displayed, a Daylight Savings Time offset may
// also be applied based on the browser locale.  To disable this behavior set
// +link{isc.Time.adjustForDST} to false.
// <P>
// If a custom timezone is specified, it will be respected by all +link{TimeDisplayFormat}s, and
// by the standard short +link{DateDisplayFormat}s when formatting dates representing datetime
// type values. However native JavaScript Date formatters,
// including <code>toLocaleString()</code> will not respect the specified timezone. Developers
// specifying a custom timezone may therefore wish to modify the
// +link{DateUtil.setNormalDisplayFormat()} to avoid using a native JS Date formatter function.
// <P>
// Note that in addition to the system-wide date, datetime and time-formatting settings described
// above, databound components also support applying custom display formats for date values.
// Typically this can be achieved via a custom <code>dateFormatter</code> or
// <code>timeFormatter</code> at the field level (see +link{dataSourceField.dateFormatter},
// +link{dataSourceField.timeFormatter} and for example +link{listGridField.dateFormatter}).
// Date formatting may also be configured at the component level by setting the
// <code>dateFormatter</code>, <code>datetimeFormatter</code> and <code>timeFormatter</code>
// attributes (See for example +link{listGrid.dateFormatter}, +link{listGrid.timeFormatter},
// and +link{listGrid.datetimeFormatter}).
// <P>
// <h3>Database storage of datetime values by SmartClient Server</h3>
// <P>
// Support for timezones and datetime values varies across the database vendors.  There is
// a standard approach proposed by the SQL:1999 standard, but as is often the case with SQL
// standards, support is far from universal and there are many idiosyncrasies.  This leads
// to a situation where different databases offer different ways for an internationalized
// application to store datetimes, and some offer facilities that others lack.  For example,
// PostgreSQL supports the SQL:1999 standard TIMESTAMP WITH TIME ZONE syntax; MySQL allows
// you to achieve the same end by providing proprietary methods to set a timezone globally
// or per-connection; Informix has no explicit timezone support at all.  For these
// reasons, SmartClient Server implements framework-level support for difficult datetime
// issues like timezones and Daylight Saving Time, and does not rely on any native database
// features.
// <P>
// <h4>Database storage of datetimes in a nutshell</h4>
// <ol>
// <li>SmartClient stores datetime values by formatting them as a string, and retrieves them
// by asking the database to format as a string.  SmartClient uses the same timezone for
// formatting and for reading from the database, avoiding any shift in the datetime value from
// storing and retrieving the date.
// <li>SmartClient is unaware of the actual timezone used by the database, and does not specify
// a timezone when storing or retrieving values.  Depending on your database settings, your
// database may be interpreting the datetime strings stored by SmartClient as server local time,
// UTC, or another timezone.  Thus, if you use JDBC directly or a SQL querying tool to read
// datetime values from your database, the value you get may be different from what is
// retrieved via SmartClient.  If it's important to make these values match, you can configure
// SmartClient and your database to read and write using the same timezone - see the more
// detailed discussion below</li>
// </ol>
// <P>
// <h4>Database storage of datetimes in detail</h4>
// Every database supported by SmartClient handles datetimes as human-readable strings of text
// like '2012-05-13 16:48:20' (in terms of the SQL interface, that is - doubtless many of them
// implement datetimes internally as epoch values).  Of course this is perfectly reasonable,
// but viewed globally it is also vague unless you specify a timezone, and support for doing
// that varies across the database vendors as described above.  If you are using the SQL storage
// engine built in to SmartClient Server (Pro or better only), uniform support for the storage
// of datetime values in database tables is provided at the framework level.
// <p>
// As previously discussed, datetime values are transmitted between client and server by
// encoding and decoding in UTC, ensuring that there is no shift in the datetime value.  If the
// browser and server are in different timezones, Date.toString() on the server will show a
// different date and time than you see in the browser, but the underlying datetime value is
// the same.
// <P>
// Then, for storing to a database, SmartClient's storage behavior is governed by the
// <code>server.properties</code> flag <code>sql.{database-name}.useUTCDateTimes</code>. For
// example:<pre>
//     sql.defaultDatabase: AppDatabase
//     sql.AppDatabase.database.type: mysql
//     sql.AppDatabase.driver: com.mysql.jdbc.jdbc2.optional.MysqlDataSource
//     <b>sql.AppDatabase.useUTCDateTimes: true</b>
//     etc
// </pre>
// If the <code>useUTCDateTimes</code> flag is set, SmartClient generates SQL that renders
// datetimes as UTC values; otherwise it generates SQL that renders datetime values in the
// JVM's local timezone.  This process is reversed when datetime values are fetched back out
// of the database, so values round-trip correctly.
// <p>
// To aid understanding, consider this round-trip example.  We have a user in New York and a
// user in London; the server is in San Francisco and is configured to use the US Pacific
// timezone (this is mentioned explicitly because servers are often configured to use UTC,
// wherever they are in the world).  Our New York user saves a record representing an online
// meeting to take place on May 23 2016 at 2pm local time.  This is what happens:<ul>
// <li>Client code uses local time '2016-05-23 14:00:00' in the user's local timezone (EDT, US
// Eastern Daylight Time, which is GMT-0400) to derive the epoch value 1464026400000, which
// also represents '2016-05-23 18:00:00' UTC (as you would expect, since EDT is GMT-0400)</li>
// <li>If the <code>useUTCDateTimes</code> flag is set, the server renders this epoch value as
// a UTC time when generating the SQL.  It is important to understand that this concept of the
// datetime being UTC is something we are doing at the framework level; the database may think
// it is storing a local datetime, or a UTC datetime, or it may not consider the issue of
// timezones at all.  The important thing is, we told it to insert '2016-05-23 18:00:00', so
// we can reasonably expect that this is the value we will get out of it when we read the row
// back</li>
// <li>If the <code>useUTCDateTimes</code> flag is not set, the server renders this epoch value
// as a time in the JVM's local timezone when generating the SQL.  Again, keep in mind that the
// concept of the datetime being in a particular timezone is something we are doing at the
// framework level; as above, the important thing is, we told it to insert '2016-05-23 11:00:00'
// (because it is May so San Francisco is on Pacific Daylight Time, which is GMT-0700), so that
// is what we will get back when we read it (there are cases where this may not be true; see
// the section "Store using UTC or local timezone?" below)</li>
// <li>Now our user in London comes along and reads the same record.  The row is read and an
// epoch time is derived, by treating the value read from the database as either a UTC datetime
// or a time in the JVM's local timezone, depending on the <code>useUTCDateTimes</code> flag
// (in fact, it isn't always that straightforward behind the scenes because some databases/JDBC
// drivers perform automatic conversions on datetime values that cannot be suppressed, but
// SmartClient Server compensates for such cases)</li>
// <li>The UTC epoch value delivered from the server is now used to create a Date object on the
// client; built-in datetime converters and/or SmartClient facilities like the
// +link{Time.setDefaultDisplayTimezone(),default display timezone} will be used to derive a
// display value applicable to the London user, for whom the equivalent datetime is
// '2016-05-23 19:00:00' (London is on British Summer Time, GMT+0100, in May)</li>
// </ul>
// As the above example shows, the process is actually fairly straightforward.  However, you
// need to consider that it is the SmartClient framework that ensures that datetimes coming out
// of the database are converted using the same timezone that was used when they went into the
// database.  Any non-SmartClient systems that read the same database tables will have to do
// any necessary conversions manually.
// <P>
// <h3>Store using UTC or local timezone?</h3>
// <P>
// As described above, SmartClient Server can be configured to store datetimes using either
// UTC or the JVM's local timezone.  On the face of it, there is little to choose between the
// two: SmartClient will ensure that values are consistent across server and client regardless
// of which you choose.  However, we recommend that you choose UTC as your storage strategy,
// for two compelling reasons<ul>
// <li>Because storage using the JVM's local timezone just uses whatever the local timezone
// happens to be at the time of writing or reading, changing the operating system or JVM
// timezone will change the meaning of the datetimes already stored.For example, if you change
// your server's timezone from US Eastern to US Pacific, any datetimes you have already stored
// will effectively be shifted forward by three hours.  This does not happen if you choose UTC
// as your SmartClient storage strategy, because it is independent of server timezone</li>
// <li>As most people know, Daylight Saving Time is a scheme used by many countries worldwide
// to maximize the number of usable hours of daylight in the summer months.  This involves
// shifting clocks forward in Spring (typically by one hour, but other values are used) and
// then back again in autumn.  This leads to two different but related problems if you choose
// to use any ordinary local timezone for storage of datetimes<ul>
//   <li>In Spring, there is a missing hour, usually the hour between 1am and 2am on the day
//   of transition to DST.  If you are using a real local timezone for storage of datetimes,
//   it is not possible to record any datetime value occuring within that hour</li>
//   <li>In Autumn, there is an extra hour, usually created by setting the time back to 1am
//   when 2am is reached on the day of DST transition.  If you are using a real local timezone
//   for storage of datetimes, it is not possible to unambiguously record any datetime value
//   occurring within that two-hour period</li>
//   </ul>
// Because UTC is a fixed reference point and not a "real" timezone, DST is not relevant and
// all datetimes can be recorded unambiguously without exceptions or edge cases.
// </ul>
// <P>
// <h3>Troubleshooting Date and Time values</h3>
// <P>
// Date and time storage and timezones can be confusing, and Isomorphic receives a steady
// stream of false bug reports from users that are incorrectly analyzing logs and diagnostics.
// Please consider the following points when troubleshooting issues such as date values
// changing to a different day, or datetime value shifting when saved and reloaded:
// <P>
// <h4>1. compare values for "datetime" fields via date.getTime()</h4>
// <P>
// Whenever you use Date.toString() (client or server-side) the value you get is based on the
// server or browser timezone.
// <P>
// Perhaps you are troubleshooting an issue with datetimes and you try to log the value of a
// Date like this:
// <pre>
//    Date someDate = &lt;<i>some expression</i>&gt;;
//    log("date value is: " + someDate);
// </pre>
// Code like this will show the datetime value in the server's timezone if executed
// server-side, and in the client's timezone if executed client-side.  If they are in different
// timezones, the hour or day will be different, <b>whereas the actual datetime value -
// milliseconds since epoch as retrieved by Date.getTime() - is the same</b>.  To correctly
// compare two datetime values, compare the result of getTime().
// <P>
// <h4>2. "date" and "time" field values <b>cannot</b> be compared via getTime()</h4>
// <P>
// This is the inverse situation as for "datetime" values.  As explained above, "date" values
// have no meaningful values for time fields (hours/minutes/seconds) and "time" values have no
// meaningful values for date fields (month/day/year).  Here, the result of Date.getTime() is
// not meaningful, and values should be compared via getHours(), getMonth() et al.
// <P>
// <h4>3. the display timezone does not affect Date.getHours(), Date.getDay() et al</h4>
// <P>
// If you've called setDefaultDisplayTimezone() to cause all datetime values to be rendered in
// a particular timezone, this does not affect the return values of Date.getHours(), which will
// still return values for the browser's current timezone.  Hence it is not a bug if you have a
// "datetime" value which is displaying as 4am, but getHours() returns 10 or some other
// number.  This just reflects the timezone offset between the timezone passed to
// setDefaultDisplayTimezone() and the browser's local timezone.
// <P>
// <h4>4. use correct DataSourceField types and use the matching FormItem type</h4>
// <P>
// If you declare a field as type "date" but values you provide actually contain specific
// hours, minutes and seconds, these will not be preserved.  The system will discard or reset
// the hours, minutes and seconds in the course of serialization or editing.  Likewise
// if you declare a field as type "time" but actually provide values where year, month and day
// have meaning, these values will be dropped.
// <P>
// Similarly, DateItem expects values for "date" fields, TimeItem expects values for "time"
// fields, and DateTimeItem expects values for "datetime" fields.  Providing the wrong type of
// value to a control, such as providing a value from a "datetime" field to a DateItem, will
// have unspecified results.
// <P>
// <smartclient>
// If you want to take the date and time aspects of a "datetime" value and edit them in separate
// FormItems, use +link{DateUtil.getLogicalDateOnly()} and +link{DateUtil.getLogicalTimeOnly()}
// to split a datetime value into date and time values, and use
// +link{DateUtil.combineLogicalDateAndTime()} to re-combine such values. Otherwise it is very
// easy to make mistakes related to timezone offsets.
// </smartclient>
// <smartgwt>
// If you want to take the date and time aspects of a "datetime" value and edit them in separate
// FormItems, use
// <code>getLogicalDateOnly()</code> and <code>DateUtil.getLogicalTimeOnly()</code> to
// split a datetime value into date and time values, and use
// <code>DateUtil.combineLogicalDateAndTime()</code> to re-combine
// such values. Otherwise it is very
// easy to make mistakes related to timezone offsets.
// </smartgwt>
// <P>
// <h4>5. check data at every phase when troubleshooting</h4>
// <P>
// If you're having a problem with round-tripping "datetime" values or "date" values shifting
// to another day, you need to isolate the problem to a specific layer.  Bearing in mind the
// techniques above for comparing values, you potentially need to look at any/all of the
// following:
// <ol>
// <li> what value do I have on the server-side before it's sent to the client?
// <li> what value is being transmitted to the client? (use the RPC Tab of the Developer
// Console to see the actual data sent)
// <ul>
// <li> was the value shifted to a different time/date by my serialization approach?
// <li> does it have the right format? (see above for correct JSON/XML formats)
// </ul>
// <li> what value do I have on the client before it gets to any widgets (eg, do a direct call
// to +link{DataSource.fetchData()} and inspect the data in the callback)
// <li> what value does the FormItem or other editing widget report before saving is attempted?
// <li> what value is reported right before the value is serialized for transmission to the
// server (+link{DataSource.transformRequest()} is a good place to check)
// <li> what value is being transmitted to the server? (use the RPC tab - same concerns as for
// server-to-client transmission above)
// <li> what value does the server have after de-serialization, before saving to the database
// or other permanent storage?
// <li> what value is sent to the database or permanent storage?  If generating SQL or another
// similar query language, does the value in the SQL statement include an explicit timezone?
// If not, how will the database interpret it?
// </ol>
//
// @title Date and Time Format and Storage
// @treeLocation Concepts
// @visibility external
//<


_xmlSerialize : function (name, type, namespace, prefix) {
    return isc.Comm._xmlValue(name, this.toSchemaDate(null, isc.Comm._trimMillis),
                              type || (this.logicalDate ? "date" :
                                        (this.logicalTime &&
                                        !isc.DataSource.serializeTimeAsDatetime ? "time" : "datetime")),
                              namespace, prefix);
},

// logicalType parameter - option to specify "date" vs "datetime" vs "time" which impacts
// how this date instance should be serialized out.
// Alternatively logicalDate / logicalTime attributes may be hung onto the date objet
// directly.
// Used by DataSources when serializing dates out
toSchemaDate : function (logicalType, trimMillis) {
    // logical date values have no meaningful time
    // Note that they also have "no meaningful timezone" - we display native browser locale time
    // to the user and when we serialize to send to the server we serialize in that same
    // local timezone.
    if ((logicalType == "date") || this.logicalDate) {
        return isc.SB.concat(
            this.getFullYear().stringify(4),
            "-",
            (this.getMonth() + 1).stringify(2),     // getMonth() is zero-based
            "-",
            this.getDate().stringify(2)
        );
    };

    // logical times are serialized as truncated schema strings (HH:MM:SS) by default
    if ((!isc.DataSource || !isc.DataSource.serializeTimeAsDatetime) &&
        (logicalType == "time" || this.logicalTime))
    {
        var value = isc.SB.concat(
            this.getHours().stringify(2), ":",
            this.getMinutes().stringify(2), ":",
            this.getSeconds().stringify(2));
        if (trimMillis !== true) {
            value += "." + this.getUTCMilliseconds().stringify(3);
        };
        return value;
    }

    // represent date time values in UTC
    var value = isc.SB.concat(
        this.getUTCFullYear().stringify(4),
        "-",
        (this.getUTCMonth() + 1).stringify(2),     // getMonth() is zero-based
        "-",
        this.getUTCDate().stringify(2),
        "T",
        this.getUTCHours().stringify(2),
        ":",
        this.getUTCMinutes().stringify(2),
        ":",
        this.getUTCSeconds().stringify(2));
    if (trimMillis !== true) {
        value += "." + this.getUTCMilliseconds().stringify(3);
    };
    return value;
},

//>    @method        date.toSerializeableDate()    (A)
// Return this date in 'serialized' format <code>YYYY-MM-DD HH:MM:SS</code>
// @group dateFormatting
// @return (String) formatted date string
// @visibility external
//<

toSerializeableDate : function (useCustomTimezone) {
    var output = isc.SB.create();
    output.append(
            this.getFullYear().stringify(4),
            "-",
            (this.getMonth() + 1).stringify(2),     // getMonth() is zero-based
            "-",
            this.getDate().stringify(2)
    );

    output.append(isc.Comm.xmlSchemaMode ? "T" : " ",
                  isc.Time.toShortTime(this, "toPadded24HourTime"));
    return output.release(false);
},

//>    @method        date.toDBDate()    (A)
//            Return this date in the format the database can parse as a datetime:
//                <code>$$DATE$$:<i>YYYY-MM-DD HH:MM:SS</i></code>
//        @group    dateFormatting
//
//        @return                    (String)    formatted date string
//  @visibility internal
//<
// Leave this internal for now
toDBDate : function () {
    return isc.StringBuffer.concat(
            "$$DATE$$:",
            this.toSerializeableDate()
            );
},


//>    @method        date.toDBDateTime()    (A)
//            Return this date in the format the database can parse as a dateTime:
//                <code>$$DATE$$:<i>YYYY-MM-DD HH:MM:SS</i></code>
//        @group    dateFormatting
//
//        @return                    (String)    formatted date string
//      @visibility internal
//<

toDBDateTime : function () {    return this.toDBDate();       },

//>    @method        date.setFormatter()
//  Set the formatter for this date object to the method name passed in.  After this call
//  wherever appropriate SmartClient components will use this formatter function to return
//  the date as a string.
//        @group    dateFormatting
//        @param    functionName    (String)    name of a date formatter method on this Date
//      @visibility external
//      @deprecated As of SmartClient 5.5 use the static methods
//              +link{classMethod:DateUtil.setNormalDisplayFormat} and
//              +link{classMethod:DateUtil.setShortDisplayFormat} to set default formatters for all dates
//<
setFormatter : function (formatter) {
    this.setNormalDisplayFormat(formatter);
},

//>    @method    date.setLocaleStringFormatter() (A)
//            Set the <code>iscToLocaleString()</code> formatter for a specific date object.
//            After this call, all  <code>theDate.toLocaleString()</code>  calls will yield a string
//             in this format.
//
//        @param    functionName    (String)    name of a dateFormatting function
//        @group    dateFormatting
//      @visibility internal
//      @deprecated As of SmartClient 5.5 use the static method
//                  +link{classMethod:DateUtil.setLocaleStringFormatter} instead
//<

setLocaleStringFormatter : function (functionName) {
    if (isc.isA.Function(this[functionName]) || isc.isA.Function(functionName))
        this.localeStringFormatter = functionName;
},

// ------------------------Advanced Date Comparison -------------------------------------------
// (currently undocd)
isBeforeToday : function (dateObj) {
    if (!dateObj) return false;
    var dayStart = isc.DateUtil.getStartOf(this, "D");
    return dateObj && dateObj.getTime() < dayStart.getTime();
},

isToday : function (dateObj) {
    if (!dateObj) return false;
    var dayStart = isc.DateUtil.getStartOf(this, "D"),
        dayEnd = isc.DateUtil.getEndOf(this, "D")
    ;
    return dateObj.getTime() >= dayStart.getTime() && dateObj.getTime() <= dayEnd.getTime();
},

isTomorrow : function (dateObj) {
    if (!dateObj) return false;
    var dayStart = isc.DateUtil.getStartOf(isc.DateUtil.getAbsoluteDate("+1D", this), "D"),
        dayEnd = isc.DateUtil.getEndOf(dayStart, "D")
    ;
    return dateObj.getTime() >= dayStart.getTime() && dateObj.getTime() <= dayEnd.getTime();
},

isThisWeek : function (dateObj) {
    if (!dateObj) return false;
    var weekStart = isc.DateUtil.getStartOf(this, "W"),
        weekEnd = isc.DateUtil.getEndOf(weekStart, "W")
    ;
    return dateObj.getTime() >= weekStart.getTime() && dateObj.getTime() <= weekEnd.getTime();
},

isNextWeek : function (dateObj) {
    if (!dateObj) return false;
    var weekStart = isc.DateUtil.getStartOf(isc.DateUtil.getAbsoluteDate("+1w", this), "W"),
        weekEnd = isc.DateUtil.getEndOf(weekStart, "W")
    ;
    return dateObj.getTime() >= weekStart.getTime() && dateObj.getTime() <= weekEnd.getTime();
},

isThisMonth : function (dateObj) {
    if (!dateObj) return false;
    var monthStart = isc.DateUtil.getStartOf(this, "M"),
        monthEnd = isc.DateUtil.getEndOf(monthStart, "M")
    ;
    return dateObj.getTime() >= monthStart.getTime() && dateObj.getTime() <= monthEnd.getTime();
},

isNextMonth : function (dateObj) {
    if (!dateObj) return false;
    var date = this.duplicate();
    // this wraps years as expected
    date.setDate(1);
    date.setMonth(date.getMonth()+1);
    return (dateObj.getFullYear() == date.getFullYear() && dateObj.getMonth() == date.getMonth())
}

});


//>    @method        date.toBrowserString()
//  Native <code>date.toString()</code> provided by the browser for Date objects
//        @group    dateFormatting
//      @visibility internal
//      @deprecated As of SmartClient 5.5
//<
// Note that the default formatter varies by browser/platform so it's not that useful.
// This was exposed in 5.2 so we're keeping it around for back-compat only
Date.prototype.toBrowserString = Date.prototype.toString;

//>    @method        date.toBrowserLocaleString()    (A)
//  Synonym for <code>date.toLocaleString()</code> provided by the browser for Date objects
//        @group    dateFormatting
//      @visibility internal
//      @deprecated As of SmartClient 5.5
//<

Date.prototype.toBrowserLocaleString = Date.prototype.toLocaleString;

// default the global fiscal year to the start of the calendar year
Date.prototype.fiscalCalendar = { defaultMonth:0, defaultDate:1, fiscalYears: [] };

// set the standard formatter for the date prototype to the native browser string
//    so everything works as normal until it is overridden.
if (!Date.prototype.formatter) {
    isc.DateUtil.setNormalDateDisplayFormat("toLocaleString");
}
if (!Date.prototype.datetimeFormatter) {
    isc.DateUtil.setNormalDatetimeDisplayFormat("toLocaleString");
}

// set the standard toShortDate() formatter to US Short Date
if (!Date.prototype._shortFormat) {
    isc.DateUtil.setShortDisplayFormat("toUSShortDate");
}
if (!Date.prototype._shortDatetimeFormat) {
    isc.DateUtil.setShortDatetimeDisplayFormat("toUSShortDatetime");
}

//>    @method        date.iscToLocaleString()   (A)
// Customizeable toLocaleString() type method.
// This method is called when isc.iscToLocaleString(date) is called.
//
//        @group    dateFormatting
//        @return                (String)    formatted date string
//      @visibility internal
//<
// Leave this internal - we don't really expect this to be called directly or overridden by
// the developer

Date.prototype.iscToLocaleString = function () {
    var formatter = this.localeStringFormatter;
    if (isc.isA.Function(formatter)) return formatter.apply(this);
    else if (this[formatter]) return this[formatter]();
}

// By default have iscToLocaleString() call date.toLocaleString()
if (!Date.prototype.localeStringFormatter)
    Date.prototype.localeStringFormatter = "toLocaleString";


//>Safari12
isc.DateUtil.addClassMethods({
    // Simple substring matching for splitting up a date string to avoid using unsupported
    // string.match() method in early Safari
    // Note - somewhat flawed: we're assuming well never be handed a single digit month or day
    _splitDateViaSubstring : function (string, monthIndex, dayIndex, yearIndex) {

        // We know that year may be after month and/or day - allow 3 chars ("DD/") for each
        var yearCharIndex = yearIndex * 3,
            year = string.substring(yearCharIndex, yearCharIndex +4)
        ;

        // If we have a 2 or 3 char year, this affects the position of the day/month in the
        // string
        var yearLength = year.length;

        var monthCharIndex = 0,
            dayCharIndex = 0;
        if (monthIndex > dayIndex) monthCharIndex += 3;
        else dayCharIndex += 3;

        if (monthIndex > yearIndex) monthCharIndex += yearLength + 1;
        if (dayIndex > yearIndex) dayCharIndex += yearLength + 1;

        // Note: Month is zero based rather than 1 based.
        var month = string.substring(monthCharIndex, monthCharIndex + 2) -1;
        var day = string.substring(dayCharIndex, dayCharIndex +2);

        // Hour minute second are not expected to change orders
        var hourCharIndex = 7 + yearLength,
            hour = (string.substring(hourCharIndex,hourCharIndex + 2) || 0),
            minute = (string.substring(hourCharIndex + 3, hourCharIndex + 5) || 0),
            second = (string.substring(hourCharIndex + 6, hourCharIndex + 8) || 0);

        return[year,month,day,hour,minute,second];
    }
});
//<Safari12

//>!BackCompat 2005.11.3

isc.addMethods(Date.prototype, {

//>    @method        date.toPrettyString()
//            Return this date in the format: <code>MM/DD/YY HH:MM</code>
//    @group  dateFormatting
//    @return (String)    formatted date string
//  @visibility external
//  @deprecated As of SmartClient 5.5 use +link{date.toShortDate()} instead
//<
toPrettyString : function () {
    return this.toUSShortDatetime();
}

});

isc.addMethods(Date, {


// --- Parsing functions --- :
// In 5.2 the paradigm was to provide formatters and complimentary parsers, like
// 'toEuropeanShortDate' and 'parseEuropeanShortDate'.
// We've moved away from this to instead use a single 'parseInput' function which takes a
// 'format' parameter specifying "MDY" / "DMY", etc.
// This is appropriate since we do not plan to provide parsing functions for every date formatter
// format.
// Leaving the older explicit parsing functions in place for back-compat only.

//>    @staticMethod Date.parseStandardDate()
//      Parse a date passed in as a string of format:
//      <code>YYYY-MM-DD HH:MM:SS</code> or <code>YYYY-MM-DD</code>
//      Returning a new <code>Date</code> object with the appropriate value.
//
//      @group  dateFormatting
//
//      @param  dateString  (String)    date value as a string
//
//      @return    (Date)      date value
//      @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{DateUtil.parseInput} instead
//<
parseStandardDate : function (dateString) {
    if (!isc.isA.String(dateString)) return null;

    // Note: we could be using a regexp here rather than substring matches
    var year = dateString.substring(0,4),
        month = dateString.substring(5,7)-1,
        day = dateString.substring(8,10),
        hour = dateString.substring(11, 13),
        minute = dateString.substring(14, 16),
        second = dateString.substring(17, 19);

    // If they all are numbers, construct a new date
    // NOTE: If year - month - day gives a number then they
    // are all numbers, or strings that implicitly convert to numbers.
    // We could also use this syntax:
    // if(parseInt(year) == year && parseInt(month) == month ...)
    // but this is slower in both Moz and IE
    if (dateString.length < 19) {
        if (!isc.isA.Number(year - month - day)) return null;
    } else {
        if (!isc.isA.Number(year - month - day - hour - minute - second)) return null;
    }

    return new Date(year, month, day, hour, minute, second);

},

//>    @staticMethod Date.parseSerializeableDate()
//      Parse a date passed in as a string of format:
//      <code>YYYY-MM-DD HH:MM:SS</code> or <code>YYYY-MM-DD</code>
//      Returning a new <code>Date</code> object with the appropriate value.
//      <i>This is a synonym for </i><code>Date.parseStandardDate()</code>
//
//      @group  dateFormatting
//      @param  dateString  (String)    date value as a string
//      @return    (Date)      date value
//      @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{Date.parseInput} instead
//<
parseSerializeableDate : function (dateString) {
    // synonym for parseStandardDate
    return this.parseStandardDate(dateString);
},


//>    @staticMethod Date.parseDBDate()
// Parse a date passed in as a string of format:
//  <code>$$DATE$$:<i>YYYY-MM-DD HH:MM:SS</i></code>
//      Returning a new <code>Date</code> object with the appropriate value.
//
//      @group  dateFormatting
//        @param    dateString  (String)    date value as a string
//        @return    (Date)        date value
//      @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{DateUtil.parseInput} instead
//<
parseDBDate : function (dateString) {

    // remove the leading "$$DATE$$:"
    if (isc.isA.String(dateString) && dateString.startsWith("$$DATE$$:")) {
        dateString = dateString.substring(9)
        return this.parseStandardDate(dateString);
    }

    return null;

},

//>    @staticMethod Date.parseDateStamp()
//
// Parse a dateStamp of the format: <code><i>YYYYMMDD</i>T<i>HHMMSS</i>[Z]</code><br><br>
//
// @group  dateFormatting
// @param    dateString    (String)    String to parse
// @return                (Date)        Date object, or null if not parsed correctly.
//
// @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{DateUtil.parseInput} instead
//<
parseDateStamp : function (string) {
    if (string == null || isc.isA.Date(string)) return string;

    var date = new Date( Date.UTC(
                string.substring(0,4),                // year
                parseInt(string.substring(4,6), 10)-1,    // mon
                string.substring(6,8),              // day
                // omit this character (T)
                string.substring(9,11),             // hour
                string.substring(11,13),            // min
                string.substring(13,15)
                // Technically we should look at the last character - if its something other
                // than "z" the timezone would be something other than UTC.
               ));

    if (isc.isA.Date(date)) return date;
    else                return null;

},

//>    @staticMethod Date.parseShortDate()
// Parse a date passed in as a string of format:   <code>MM/DD/YYYY</code>
//
//      @group  dateFormatting
//        @param    dateString  (String)    date value as a string
//      @param  [centuryThreshold]  (int)    if parsed year is 2 digits and less than this
//                                              number, assume year to be 20xx
//
//        @return    (Date)        date value
//  @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{DateUtil.parseInput} instead
//<
parseShortDate : function (string, centuryThreshold) {
    return this.parseInput(string, "MDY", centuryThreshold);
},

//>    @staticMethod Date.parseShortDateTime()
// Parse a date passed in as a string of format:   <code>MM/DD/YYYY HH:MM:SS</code>
//
//      @group  dateFormatting
//        @param    dateString  (String)    date value as a string
//      @param  [centuryThreshold]    (int)    if parsed year is 2 digits and less than this
//                                              number, assume year to be 20xx
//
//        @return    (Date)        date value
//  @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{DateUtil.parseInput} instead
//<

parseShortDateTime : function (string, centuryThreshold) {
    // synonym for parseShortDate - included for completeness and to provide the appropriate
    // compliment to date.toShortDateTime()
    return this.parseShortDate(string, centuryThreshold);
},

//>    @staticMethod Date.parsePrettyString()
// Parse a date passed in as a string of format:   <code>MM/DD/YY HH:MM:SS</code>
//
//      @group  dateFormatting
//        @param    dateString  (String)    date value as a string
//      @param  [centuryThreshold]    (int)    if parsed year is less than this
//                                              number, assume year to be 20xx rather than 19xx
//
//        @return    (Date)        date value
//  @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{DateUtil.parseInput} instead
//<
parsePrettyString : function (string, centuryThreshold) {
    // this is just the same as a short date with a 2 digit year.
    return this.parseShortDate(string, centuryThreshold);
},

//>    @staticMethod Date.parseEuropeanShortDate()
//            parse a date passed in as a string of format:   <code>DD/MM/YYYY</code>
//        @group    dateFormatting
//        @param    dateString  (String)    date value as a string
//      @param  [centuryThreshold]    (int)    if parsed year is 2 digits and less than this
//                                              number, assume year to be 20xx
//
//        @return    (Date)        date value
//      @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{DateUtil.parseInput} instead
//<
parseEuropeanShortDate : function (string, centuryThreshold) {
    return this.parseInput(string, "DMY", centuryThreshold);
},

//>    @staticMethod Date.parseEuropeanShortDateTime()
//            parse a date passed in as a string of format:   <code>DD/MM/YYYY HH:MM:SS</code>
//        @group    dateFormatting
//        @param    dateString  (String)    date value as a string
//      @param  [centuryThreshold]    (int)    if parsed year is 2 digits and less than this
//                                              number, assume year to be 20xx
//
//        @return    (Date)        date value
//  @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{DateUtil.parseInput} instead
//<

parseEuropeanShortDateTime : function (string, centuryThreshold) {
    return this.parseInput(string, "DMY", centuryThreshold);
}

});
//<!BackCompat



isc.addProperties(Date, {

//>!BackCompat 2016.04.29

//> @classAttr  Date.dayNames  (Array : null : IRWA)
// @include DateUtil.dayNames
// @deprecated Use +link{DateUtil.dayNames}.
//<

//> @classAttr  Date.shortDayNames  (Array : null : IRWA)
// @include DateUtil.shortDayNames
// @deprecated Use +link{DateUtil.shortDayNames}.
//<

//> @classAttr  Date.monthNames  (Array : null : IRWA)
// @include DateUtil.monthNames
// @deprecated Use +link{DateUtil.monthNames}.
//<

//> @classAttr  Date.shortMonthNames  (Array : null : IRWA)
// @include DateUtil.shortMonthNames
// @deprecated Use +link{DateUtil.shortMonthNames}.
//<

//> @classAttr Date.weekendDays (Array of int : null : IR)
// @include DateUtil.weekendDays
// @deprecated Use +link{DateUtil.weekendDays}.
//<

//> @staticMethod Date.create()
// @include DateUtil.create
// @deprecated Use +link{DateUtil.create()}.
//<
create : function (arg1, arg2, arg3, arg4, arg5, arg6, arg7) {
    return isc.DateUtil.create(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
},

//> @staticMethod Date.createLogicalDate()
// @include DateUtil.createLogicalDate
// @deprecated Use +link{DateUtil.createLogicalDate()}.
//<
createLogicalDate : function (year, month, date, suppressConversion) {
    return isc.DateUtil.createLogicalDate(year, month, date, suppressConversion);
},

//> @staticMethod Date.createLogicalTime()
// @include DateUtil.createLogicalTime
// @deprecated Use +link{DateUtil.createLogicalTime()}.
//<
createLogicalTime : function (hour, minute, second, millisecond) {
    return isc.DateUtil.createLogicalTime(hour, minute, second, millisecond);
},

//> @staticMethod Date.getLogicalDateOnly()
// @include DateUtil.getLogicalDateOnly
// @deprecated Use +link{DateUtil.getLogicalDateOnly()}.
//<
getLogicalDateOnly : function (datetime) {
    return isc.DateUtil.getLogicalDateOnly(datetime);
},

//> @staticMethod Date.getLogicalTimeOnly()
// @include DateUtil.getLogicalTimeOnly
// @deprecated Use +link{DateUtil.getLogicalTimeOnly()}.
//<
getLogicalTimeOnly : function (datetime) {
    return isc.DateUtil.getLogicalTimeOnly(datetime);
},

//> @staticMethod Date.combineLogicalDateAndTime()
// @include DateUtil.combineLogicalDateAndTime
// @deprecated Use +link{DateUtil.combineLogicalDateAndTime()}.
//<
combineLogicalDateAndTime : function (date, time) {
    return isc.DateUtil.combineLogicalDateAndTime(date, time);
},

//> @staticMethod Date.compareDates()
// @include DateUtil.compareDates
// @deprecated Use +link{DateUtil.compareDates()}.
//<
compareDates : function (a, b, c) {
    return isc.DateUtil.compareDates(a, b, c);
},

//> @staticMethod Date.compareLogicalDates()
// @include DateUtil.compareLogicalDates
// @deprecated Use +link{DateUtil.compareLogicalDates()}.
//<
compareLogicalDates : function (a, b, c) {
    return isc.DateUtil.compareLogicalDates(a, b, c);
},

//> @staticMethod Date.setInputFormat()
// @include DateUtil.setInputFormat
// @deprecated Use +link{DateUtil.setInputFormat()}.
//<
setInputFormat : function (format) {
    return isc.DateUtil.setInputFormat(format);
},

//> @staticMethod Date.getInputFormat()
// @include DateUtil.getInputFormat
// @deprecated Use +link{DateUtil.getInputFormat()}.
//<
getInputFormat : function () {
    return isc.DateUtil.getInputFormat();
},

//> @staticMethod Date.parseInput()
// @include DateUtil.parseInput
// @deprecated Use +link{DateUtil.parseInput()}.
//<
parseInput : function (dateString, format, centuryThreshold, suppressConversion, isDatetime)
{
    return isc.DateUtil.parseInput(dateString, format, centuryThreshold, suppressConversion,
                                   isDatetime);
},

//> @staticMethod Date.setNormalDisplayFormat()
// @include DateUtil.setNormalDisplayFormat
// @deprecated Use +link{DateUtil.setNormalDisplayFormat()}.
//<
setNormalDisplayFormat : function (format) {
    return isc.DateUtil.setNormalDisplayFormat(format);
},

//> @staticMethod Date.setNormalDatetimeDisplayFormat()
// @include DateUtil.setNormalDatetimeDisplayFormat
// @deprecated Use +link{DateUtil.setNormalDatetimeDisplayFormat()}.
//<
setNormalDatetimeDisplayFormat : function (format) {
    return isc.DateUtil.setNormalDatetimeDisplayFormat(format);
},

//> @staticMethod Date.setShortDisplayFormat()
// @include DateUtil.setShortDisplayFormat
// @deprecated Use +link{DateUtil.setShortDisplayFormat()}.
//<
setShortDisplayFormat : function (format) {
    return isc.DateUtil.setShortDisplayFormat(format);
},

//> @staticMethod Date.setDefaultDateSeparator()
// @include DateUtil.setDefaultDateSeparator
// @deprecated Use +link{DateUtil.setDefaultDateSeparator()}.
//<
setDefaultDateSeparator : function (separator) {
    return isc.DateUtil.setDefaultDateSeparator(separator);
},

//> @staticMethod Date.getDefaultDateSeparator()
// @include DateUtil.getDefaultDateSeparator
// @deprecated Use +link{DateUtil.getDefaultDateSeparator()}.
//<
getDefaultDateSeparator : function () {
    return isc.DateUtil.getDefaultDateSeparator();
},

//> @staticMethod Date.setShortDatetimeDisplayFormat()
// @include DateUtil.setShortDatetimeDisplayFormat
// @deprecated Use +link{DateUtil.setShortDatetimeDisplayFormat()}.
//<
setShortDatetimeDisplayFormat : function (format) {
    return isc.DateUtil.setShortDatetimeDisplayFormat(format);
},

//> @staticMethod Date.setFiscalCalendar()
// @include DateUtil.setFiscalCalendar
// @deprecated Use +link{DateUtil.setFiscalCalendar()}.
//<
setFiscalCalendar : function (fiscalCalendar) {
    return isc.DateUtil.setFiscalCalendar(fiscalCalendar);
},

//> @staticMethod Date.getFiscalCalendar()
// @include DateUtil.getFiscalCalendar
// @deprecated Use +link{DateUtil.getFiscalCalendar()}.
//<
getFiscalCalendar : function () {
    return isc.DateUtil.getFiscalCalendar();
},

//> @staticMethod Date.getFiscalStartDate()
// @include DateUtil.getFiscalStartDate
// @deprecated Use +link{DateUtil.getFiscalStartDate()}.
//<
getFiscalStartDate : function (date, fiscalCalendar) {
    return isc.DateUtil.getFiscalStartDate(date, fiscalCalendar);
},

//> @staticMethod Date.setShowChooserFiscalYearPickers()
// @include DateUtil.setShowChooserFiscalYearPickers
// @deprecated Use +link{DateUtil.setShowChooserFiscalYearPickers()}.
//<
setShowChooserFiscalYearPickers : function (showChooserFiscalYearPickers) {
    return isc.DateUtil.setShowChooserFiscalYearPickers(showChooserFiscalYearPickers);
},

//> @staticMethod Date.setShowChooserWeekPickers()
// @include DateUtil.setShowChooserWeekPickers
// @deprecated Use +link{DateUtil.setShowChooserWeekPickers()}.
//<
setShowChooserWeekPickers : function (showChooserWeekPickers) {
    return isc.DateUtil.setShowChooserWeekPickers(showChooserWeekPickers);
},

//> @staticMethod Date.setFirstDayOfWeek()
// @include DateUtil.setFirstDayOfWeek
// @deprecated Use +link{DateUtil.setFirstDayOfWeek()}.
//<
setFirstDayOfWeek : function (firstDayOfWeek) {
    return isc.DateUtil.setFirstDayOfWeek(firstDayOfWeek);
},

//> @staticMethod Date.getFirstDayOfWeek()
// @include DateUtil.getFirstDayOfWeek
// @deprecated Use +link{DateUtil.getFirstDayOfWeek()}.
//<
getFirstDayOfWeek : function () {
    return isc.DateUtil.getFirstDayOfWeek();
},

//> @staticMethod Date.getFiscalYear()
// @include DateUtil.getFiscalYear
// @deprecated Use +link{DateUtil.getFiscalYear()}.
//<
getFiscalYear : function (date, fiscalCalendar) {
    return isc.DateUtil.getFiscalYear(date, fiscalCalendar);
},

//> @staticMethod Date.getFiscalWeek()
// @include DateUtil.getFiscalWeek
// @deprecated Use +link{DateUtil.getFiscalWeek()}.
//<
getFiscalWeek : function (date, fiscalCalendar, firstDayOfWeek) {
    return isc.DateUtil.getFiscalWeek(date, fiscalCalendar, firstDayOfWeek);
},

//> @staticMethod Date.setLocaleStringFormatter()
// @include DateUtil.setLocaleStringFormatter
// @deprecated Use +link{DateUtil.setLocaleStringFormatter()}.
//<
setLocaleStringFormatter : function (functionName) {
    return isc.DateUtil.setLocaleStringFormatter(functionName);
},

//> @staticMethod Date.getMonthNames()
// @include DateUtil.getMonthNames
// @deprecated Use +link{DateUtil.getMonthNames()}.
//<
getMonthNames : function () {
    return isc.DateUtil.getMonthNames();
},

//> @staticMethod Date.getShortMonthNames()
// @include DateUtil.getShortMonthNames
// @deprecated Use +link{DateUtil.getShortMonthNames()}.
//<
getShortMonthNames : function (length) {
    return isc.DateUtil.getShortMonthNames(length);
},

//> @staticMethod Date.getDayNames()
// @include DateUtil.getDayNames
// @deprecated Use +link{DateUtil.getDayNames()}.
//<
getDayNames : function () {
    return isc.DateUtil.getDayNames();
},

//> @staticMethod Date.getShortDayNames()
// @include DateUtil.getShortDayNames
// @deprecated Use +link{DateUtil.getShortDayNames()}.
//<
getShortDayNames : function (length) {
    return isc.DateUtil.getShortDayNames(length);
},

//> @staticMethod Date.setWeekendDays()
// @include DateUtil.setWeekendDays
// @deprecated Use +link{DateUtil.setWeekendDays()}.
//<
setWeekendDays : function (weekendDays) {
    return isc.DateUtil.setWeekendDays(weekendDays);
},

//> @staticMethod Date.getWeekendDays()
// @include DateUtil.getWeekendDays
// @deprecated Use +link{DateUtil.getWeekendDays()}.
//<
getWeekendDays : function () {
    return isc.DateUtil.getWeekendDays();
},
//<!BackCompat

//>!BackCompat 2005.11.3
// parseDate() was old name for parseInput
parseDate : function (dateString, format, centuryThreshold, suppressConversion) {
    return isc.DateUtil.parseInput(dateString, format, centuryThreshold, suppressConversion);
},

// For completeness also support parseDatetime()
parseDateTime : function (dateString, format, centuryThreshold, suppressConversion) {
    return isc.DateUtil.parseDatetime(dateString,format,centuryThreshold,suppressConversion);
},
parseDatetime : function (dateString, format, centuryThreshold, suppressConversion) {
    return isc.DateUtil.parseInput(dateString, format, centuryThreshold, suppressConversion);
},
//<!BackCompat

//>!BackCompat 2005.11.3
// -- Older depracated synonym of setNormalDisplayFormat
//>    @staticMethod Date.setFormatter()
//  Set the formatter for all date objects to the method name passed in.  After this call
//  all <code>theDate.toNormalDate()</code> calls will fall through to this formatter function to
//  return the date as a string.
//        @group    dateFormatting
//        @param    functionName    (String)    name of a date formatter method on this Date
//      @visibility internal
//<

setFormatter : function (formatter) {
    this.setNormalDisplayFormat(formatter);
}
//<!BackCompat

});





//> @type RelativeDateShortcut
// A RelativeDateShortcut is a special string that represents a shortcut to a date phrase that can
// be automatically mapped to a +link{type:RelativeDateString} for use in widgets that
// leverage relative-dates, such as the +link{class:RelativeDateItem}.
// <P>
// Note that some shortcuts indicate a time period but do not directly indicate whether the value
// refers to the start or end of the time period in question. This ambiguity
// can be resolved by specifying an explicit +link{RelativeDateRangePosition} when calling APIs that
// convert from RelativeDates to absolute date values. This is the case for <i>$today</i>,
// <i>$tomorrow</i>, <i>$yesterday</i>, <i>$weekAgo</i>, <i>$weekFromNow</i>, <i>$monthAgo</i>
// and <i>$monthFromNow</i>. If a range position is not explicitly passed, these will all default
// to the start of the day in question.
// <P>
// Builtin options include
// <ul>
// <li> $now - this moment </li>
// <li> $today - the current day. By default this resolves to the start of the current day though
//   an explicit +link{RelativeDateRangePosition} may be used to specify the end of the current day.</li>
// <li> $startOfToday - the start of today</li>
// <li> $endOfToday - the end of today (one millisecond before the $startOfTomorrow) </li>
// <li> $yesterday - the previous day.</li>
// <li> $startOfYesterday - the start of yesterday</li>
// <li> $endOfYesterday - the end of yesterday (one millisecond before the $startOfToday) </li>
// <li> $tomorrow - the following day</li>
// <li> $startOfTomorrow - the start of tomorrow </li>
// <li> $endOfTomorrow - the end of tomorrow </li>
// <li> $weekAgo - the current day of the previous week </li>
// <li> $weekFromNow - the current day of the next week </li>
// <li> $startOfWeek - the start of the current week </li>
// <li> $endOfWeek - the end of the current week </li>
// <li> $monthAgo - the current day of the previous month </li>
// <li> $monthFromNow - the current day of the following month </li>
// <li> $startOfMonth - the start of the current month </li>
// <li> $endOfMonth - the end of the current month </li>
// <li> $startOfYear - the start of the current year </li>
// <li> $endOfYear - the end of the current year </li>
// </ul>
//
// <P>
//
// @baseType String
// @see RelativeDateString
// @visibility external
//<

//> @type RelativeDateString
// A string of known format used to specify a datetime offset.  For example, a
// RelativeDateString that represents "one year from today" is written as <code>"+1y"</code>.
// <P>
// RelativeDateStrings are comprised of the following parts:
// <ul>
// <li>direction: the direction in which the quantity applies - one of + or - </li>
// <li>quantity: the number of units of time to apply - a number </li>
// <li>timeUnit: an abbreviated timeUnit to use - one of ms/MS (millisecond), s/S (second),
//      mn/MN (minute), h/H (hour), d/D (day), w/W (week), m/M (month), q/Q (quarter, 3-months),
//      y/Y (year), dc/DC (decade) or c/C (century). <br>
//      The timeUnit is case sensitive. A lowercase timeUnit implies an exact offset, so <code>+1d</code>
//      refers to the current date / time increased by exactly 24 hours. If the timeUnit is
//      uppercase, it refers to the start or end boundary of the period of time in question, so
//      <code>+1D</code> would refer to the end of the day (23:39:59:999) tomorrow, and
//      <code>-1D</code> would refer to the start of the day (00:00:00:000) yesterday.</li>
// <li>[qualifier]: an optional timeUnit encapsulated in square-brackets and used to offset
//      the calculation - eg. if +1d is "plus one day", +1d[W] is "plus one day from the
//      end of the current week".  You may also specify another complete RelativeDateString as the
//      [qualifier], which offers more control - eg, +1d[+1W] indicates "plus one day from
//      the end of NEXT week".</li>
// </ul>
// <P>
// This format is very flexible. Here are a few example relative date strings:<br>
// <code>+0D</code>: End of today. There are often multiple ways to represent the same time
//  using this system - for example this could also be written as <code>-1ms[+1D]</code><br>
// <code>-0D</code>: Beginning of today.<br>
// <code>+1W</code>: End of next week.<br>
// <code>+1w[-0W]</code>: Beginning of next week.<br>
// <code>+1w[-0D]</code>: Beginning of the current day of next week.
//
// @baseType String
// @see RelativeDateShortcut
// @visibility external
//<

//> @object RelativeDate
// An object representing a relative date, useful for representing date ranges etc in criteria.
// RelativeDate objects may be created directly by SmartClient components such as the
// +link{RelativeDateItem}.
// <P>
// RelativeDate objects will have <code>"_constructor"</code> set to <code>"RelativeDate"</code>
// and must have a specified +link{RelativeDate.value}. Any other attributes are optional.
//
// @treeLocation Client Reference/System
// @visibility external
//<
// This type of object is returned by RelativeDateItem.getValue() and is understood directly by
// DataSources when assembling criteria.


//> @attr relativeDate.value (RelativeDateString | RelativeDateShortcut : null : IR)
// The value of this relative date, specified as a +link{RelativeDateString}
// or +link{RelativeDateShortcut}.
// @visibility external
//<

//> @type RelativeDateRangePosition
// When  relative dates are specified in a date range, typically in a RelativeDateItem or
// DateRangeItem, in order to make the range inclusive or exclusive, it is useful to be able
// to specify whether we're referring to the start or end of the date in question.
//
// @value "start" Indicates this relative date should be treated as the start of the specified
//    logical date.
// @value "end" Indicates this relative date should be treated as the end of the specified logical
//    date.
// @visibility external
//<

//> @attr relativeDate.rangePosition (RelativeDateRangePosition : null : IR)
// If this relative date has its value specified as a +link{RelativeDateShortcut} which doesn't
// specify an exact time-period boundary - for example <code>"$yesterday"</code>, this attribute
// may be set to specify whether the date should be interpreted as the start or end boundary of
// the time period.
// @visibility external
//<

// Add static methods to the DateUtil class (defined in Date.js)
isc.DateUtil.addClassMethods({

    // return the logical rangePosition for a builtin RelativeDateShortcut, based on it's name
    // starting with $startOf or $endOf - allows startOf-type shortcuts to be applied to the
    // end-date in a DateRangeItem, and vice-versa, while maintaining the range-rounding
    // implied by the shortcut-name
    getDefaultRangePosition : function (relativeDateShortcut) {
        if (isc.DateUtil.isRelativeDateShortcut(relativeDateShortcut)) {
            if (relativeDateShortcut.startsWith("$startOf")) return "start";
            if (relativeDateShortcut.startsWith("$endOf")) return "end";
        }
        return;
    },

    //> @classMethod DateUtil.mapRelativeDateShortcut() [A]
    // Converts a +link{RelativeDateShortcut} to a +link{RelativeDateString}.
    // @param relativeDate (RelativeDateShortcut) shortcut string to convert
    // @param [rangePosition] (RelativeDateRangePosition) Are we interested in the start or end of the
    //  specified relative date? This applies to shortcuts which do not specify a specific
    //  moment (such as <code>$today</code>) - it does not apply to shortcuts which
    //  already specify a specific moment such as <code>$startOfToday</code>. If unspecified
    //  rangePosition is always assumed to be "start"
    // @return (RelativeDateString) converted relative date string.
    // @visibility external
    //<
    mapRelativeDateShortcut : function (relativeDate, rangePosition) {
        switch (relativeDate) {
            case "$now": return "+0MS";

            case "$today":
                if (rangePosition == "end") {
                    return "+0D";
                } else {
                    return "-0D";
                }
            case "$startOfToday":
                return "-0D";
            case "$endOfToday": return "+0D";

            case "$yesterday":
                if (rangePosition == "end") {

                    return "-1d[+0D]";
                } else {
                    return "-1D";
                }
            case "$startOfYesterday":
                return "-1D";
            case "$endOfYesterday": return "-1d[+0D]";

            case "$tomorrow":
                if (rangePosition == "end") {
                    return "+1D";
                } else {
                    return "+1d[-0D]";
                }
            case "$startOfTomorrow":
                return "+1d[-0D]";
            case "$endOfTomorrow": return "+1D";

            case "$startOfWeek": return "-0W";
            case "$endOfWeek": return "+0W";

            case "$startOfMonth": return "-0M";
            case "$endOfMonth": return "+0M";

            case "$startOfYear": return "-0Y";
            case "$endOfYear": return "+0Y";

            case "$weekFromNow" :
                if (rangePosition == "end") {
                    return "+1w[+0D]";
                } else {
                    return "+1w[-0D]";
                }

            case "$weekAgo" :
                if (rangePosition == "end") {
                    return "-1w[+0D]";
                } else {
                    return "-1w[-0D]";
                }

            case "$monthFromNow" :
                if (rangePosition == "end") {
                    return "+1m[+0D]";
                } else {
                    return "+1m[-0D]";
                }

            case "$monthAgo" :
                if (rangePosition == "end") {
                    return "-1m[+0D]";
                } else {
                    return "-1m[-0D]";
                }
        }
        return relativeDate;
    },

    mapToRelativeDateShortcut : function (relativeDate, rangePosition) {
        switch (relativeDate) {
            case "+0ms": return "$now";

            case "-0d":
            case "+0d": return "$today";
            case "-0D": return "$startOfToday";
            case "+0D": return "$endOfToday";

            case "-1d": return "$yesterday";
            case "-1D": return "$startOfYesterday";
            case "-1d[+0D]": return "$endOfYesterday";

            case "+1d": return "$tomorrow";
            case "+1d[-0D]": return "$startOfTomorrow";
            case "+1D": return "$endOfTomorrow";


            case "-0W": return "$startOfWeek";
            case "+0W": return "$endOfWeek";

            case "-0M": return "$startOfMonth";
            case "+0M": return "$endOfMonth";

            case "-0Q": return "$startOfQuarter";
            case "+0Q": return "$endOfQuarter";

            case "-0Y": return "$startOfYear";
            case "+0Y": return "$endOfYear";

            case "+1w": return "$weekFromNow";
            case "-1w": return "$weekAgo";

            case "+1m": return "$monthFromNow";
            case "-1m": return "$monthAgo";

        }
        return relativeDate;
    },
    //> @classMethod DateUtil.adjustDate()
    // Returns a new +link{Date} instance, representing the <code>baseDate</code> adjusted by
    // the relative amount of the +link{RelativeDateString, relativeDateString}.
    // @param baseDate (Date) Date instance to apply a relative amount to - defaults to new Date()
    // @param relativeDateString (RelativeDateString) the relative amount to apply to the
    //                           <code>baseDate</code>
    // @return (Date) a new Date instance representing the <code>baseDate</code> adjusted by
    //                           the <code>relativeDateString</code>
    // @visibility external
    //<
    adjustDate : function (baseDate, relativeDateString) {
        var newDate = isc.DateUtil.getAbsoluteDate(relativeDateString, baseDate);
        if (!newDate) {
            this.logWarn("Missing or invalid relativeDateString parameter.");
            return null;
        }
        return newDate.duplicate();
    },

    //> @classMethod DateUtil.getAbsoluteDate()
    //  Converts a +link{RelativeDate}, <smartclient>+link{type:RelativeDateShortcut},
    // </smartclient><smartgwt>+link{RelativeDateShortcut},</smartgwt>
    // or +link{RelativeDateString} to a concrete Date.
    // @param relativeDate (RelativeDate | RelativeDateShortcut | RelativeDateString) the relative
    //   date to convert
    // @param [baseDate] (Date) base value for conversion.  Defaults to the current date/time.
    // @param [rangePosition] (RelativeDateRangePosition) optional date-range position. Only has an effect
    //   if the date passed in is a +link{type:RelativeDateShortcut} where the range position
    //   is not implicit, such as "$yesterday"
    // @param [isLogicalDate] (boolean) should the generated date be marked as a "logical" date? A
    //   logical date object is a Date value where the time component is ignored for formatting and
    //   serialization purposes - such as the date displayed within a component field of
    //   specified type "date". See +link{group:dateFormatAndStorage} for more on logical dates vs
    //   datetime type values.
    // @return (Date) resulting absolute date value
    // @visibility external
    //<
    getAbsoluteDate : function (relativeDate, baseDate, rangePosition, isLogicalDate) {
        // passed a date object, just return a duplicate of it
        if (isc.isA.Date(relativeDate)) return relativeDate.duplicate();

        var _this = isc.DateUtil;
        var value = relativeDate;

        if (_this.isRelativeDate(value)) {
            // the caller passed an actual RelativeDate object - get the relativeDateString and
            // potentially the rangePosition from the object
            if (!rangePosition) rangePosition = value.rangePosition;
            value = relativeDate.value;
        }

        // if the param isn't now a string, it's not a relativeDate - return null
        if (!isc.isA.String(value)) return null;

        // convert relativeDateShortcut to relativeDateString, if necessary.
        // This will resolve the 'rangePosition'
        if (value.startsWith("$")) {
            var mappedString = _this.mapRelativeDateShortcut(value, rangePosition);
            // if the mapped string is unchanged, it's not a supported shortcut
            if (mappedString == value) return null;
            value = mappedString;
        }

        var localBaseDate = isLogicalDate ? isc.DateUtil.createLogicalDate() : new Date();

        if (baseDate != null) localBaseDate.setTime(baseDate.getTime());
        var parts = _this.parseRelativeDateString(value, true);

        // if the string couldn't be parsed, return null
        if (!parts) return null;

        if (parts.qualifier) {
            // Qualifier is always going to be in "boundary" type increments -- support it being
            // specified as upper or lowercase.
            // get rid of the brackets and upper-case it because we're
            // just going to run the baseDate through addDate(), which already understands
            // about capitals
            parts.qualifier = parts.qualifier.toUpperCase();

            var qParts = _this.parseRelativeDateString(parts.qualifier);

            if (qParts) {
                if (isc.DateUtil._relativePeriods.contains(qParts.period)) {
                    localBaseDate = _this.dateAdd(localBaseDate,
                        qParts.period, qParts.countValue, (qParts.direction == "+" ? 1 : -1),
                        isLogicalDate, rangePosition);
                } else {
                    // invalid qualifier - log a warning and skip
                    isc.logWarn("Invalid date-offset qualifier provided: "+qParts.period+".  Valid "+
                        "options are: S, MN (or N), H, D, W, M, Q and Y (or YY, YYYY).");
                }
            }
        }

        // perform the date calculation
        var absoluteDate = _this.dateAdd(localBaseDate, parts.period,
                                        parts.countValue, (parts.direction == "+" ? 1 : -1),
                                        isLogicalDate, rangePosition);

        if (isLogicalDate) absoluteDate.isLogicalDate = true;

        return absoluteDate;
    },

    _relativePeriods: ["MS", "S", "MN", "N", "H", "D", "W", "M", "Q", "Y", "YY", "YYYY", "DC", "C"],

    // return a RelativeDate object
    getRelativeDateObject : function (relativeDate, rangePosition) {
        if (isc.isA.String(relativeDate) && this.isRelativeDate(relativeDate, true)) {
            // RelativeDateShortcut or RelativeDateString - return a RelativeDate object
            var result = { _constructor: "RelativeDate", value: relativeDate };
            if (rangePosition != null) result.rangePosition = rangePosition;
            return result;
        } else if (this.isRelativeDate(relativeDate)) {
            // passed a RelativeDate object - just return it
            return relativeDate;
        }

        // not passed a valid Relative value - return null
        return null;
    },

    // helper to convert RelativeDateShortcut/Strings in the passed criteria into proper
    // RelativeDate objects, with a constructor
    convertRelativeDateStringsToObjects : function (criteria, fields) {
        // just bail if passed null criteria
        if (!criteria) return null;

        // get a copy of the criteria to alter and return - it's ok to use clone() here as
        // we've already confirmed the param is criteria above
        var result = isc.clone(criteria);
        var tempValue;

        if (result.criteria && isc.isAn.Array(result.criteria)) {
            // complex sub-criteria, call this method again with that criteria
            var subCriteria = result.criteria;

            for (var i = subCriteria.length-1; i>=0; i--) {
                var subItem = subCriteria[i];

                if (subItem) {
                    if (subItem.criteria && isc.isAn.Array(subItem.criteria)) {
                        if (this.logIsInfoEnabled("relativeDates")) {
                            this.logInfo("Calling convertRelativeDateStringsToObjects from " +
                                "convertRelativeDateStringsToObjects "+
                                "- data is:\n\n"+isc.echoFull(subItem)+"\n\n"+
                                "criteria is: \n\n"+isc.echoFull(criteria)
                                ,"relativeDates"
                            );
                        }

                        result.criteria[i] = this.convertRelativeDateStringsToObjects(subItem, fields);

                        if (this.logIsInfoEnabled("relativeDates")) {
                            this.logInfo("Called convertRelativeDateStringsToObjects from convertRelativeDateStringsToObjects "+
                            "- data is\n\n" + isc.echoFull(result.criteria[i]), "relativeDates");
                        }
                    } else {
                        // getRelativeDateObject() returns null if the value isn't a relative date
                        tempValue = isc.DateUtil.getRelativeDateObject(subItem.value);
                        if (tempValue) result.criteria[i].value = tempValue;
                    }
                }
            }
        } else {
            // simple criterion
            // getRelativeDateObject() returns null if the value isn't a relative date
            tempValue = isc.DateUtil.getRelativeDateObject(result.value);
            if (tempValue) result.value = tempValue;
        }

        if (this.logIsInfoEnabled("relativeDates")) {
            this.logInfo("Returning from convertRelativeDates - result is:\n\n"+
                isc.echoFull(result)+"\n\n"+
                "original criteria is: \n\n"+isc.echoFull(criteria)
                ,"relativeDates"
            );
        }

        return result;
    },

    isRelativeDate : function (value, includeStrings) {
        // return true if the parameter is a RelativeDate object (or string representation)
        if (!isc.isA.Date(value) && isc.isAn.Object(value) && value._constructor == "RelativeDate") return true;
        var _this = isc.DateUtil;
        if (includeStrings && isc.isA.String(value)) {
            return _this.isRelativeDateShortcut(value) || _this.isRelativeDateString(value, true);
        }
        return false;
    },
    isRelativeDateShortcut : function (value) {
        // return true if the parameter is a string representing a RelativeDateShortcut and the
        // result of mapping it is different than the value itself - that means it's supported

        return isc.isA.String(value) && value.startsWith("$") &&
                 isc.DateUtil.mapRelativeDateShortcut(value) != value;
    },

    isRelativeDateString : function (value) {
        // return true if the parameter is a string that can be parsed as a relative date
        return isc.DateUtil.parseRelativeDateString(value, true) != null;
    },

    mapsToDate : function (value) {
        // returns true if the param is a Date, a RelativeDate object or a parse-able
        // relativeDateShortcut/String
        if (isc.isA.Date(value) || isc.DateUtil.isRelativeDate(value, true)) return true;
    },

    parseRelativeDateString : function (relativeDateString, suppressDefaults) {
        // if it's not a string, or shorter than 3 chars, it's not a relativeDateString
        if (!isc.isA.String(relativeDateString) || relativeDateString.length < 3) return null;

        var result = {};

        // string is in the format +1D[-0D]

        var parts = relativeDateString.split("[");
        if (parts[1]) {
            // qualifier is the bit in the square brackets (another relative date string)
            result.qualifier = parts[1].replace("]", "");
        }

        var value = parts[0];
        result.direction = value[0];
        result.count = "";
        result.period = "";

        for (var i=1; i<value.length; i++) {
            if (!isNaN(parseInt(value[i]))) result.count += value[i];
            else result.period += value[i];
        }
        result.count = parseInt(result.count);

        if (suppressDefaults) {
            // the value must start with a + or - character, there must be a valid count
            // and a period that exists in the _relativePeriods array (eg, D or M)
            if (!["+", "-"].contains(result.direction)) return null;
            if (isNaN(result.count)) return null;
            if (result.period.length == 0) return null;
            if (!isc.DateUtil._relativePeriods.contains(result.period.toUpperCase())) return null;
        }

        return {
            direction: (result.direction == "+" || result.direction == "-" ? result.direction : "+"),
            qualifier: result.qualifier,
            countValue: isc.isA.Number(result.count) ? result.count : 0,
            period: result.period ? result.period : "D"
        };
    },

    // helper method for adding positive and negative amounts of any time-unit from
    // milliseconds to centuries to a copy of the passed date - does not affect the param date
    // date: base date to copy and modify
    // unit: one of "ms" / "MS", "H" / "h", "D" / "d" etc - if unset, default is "d" (day)
    // amount: the number of "unit"s to offset by
    // multiplier: +1 or -1 - direction in which we're shifting the date
    // rangePosition - passed up from editors - if ", we get[Start/End]Of() accordingly
    // firstDayOfWeek - passed on to getStart/EndOf() for weeks - uses the global default if absent
    // Returns a new date, modified as requested
    dateAdd : function (passedDate, unit, amount, multiplier, isLogicalDate, rangePosition, firstDayOfWeek) {

        // always work with a copy of the passed date
        var date = passedDate.duplicate();

        // boundary: If the specified time-unit is upperCase, we want to calculate the
        // date offset to the end of the time-unit in question. For example:
        // +1d ==> offset to the same time on the next day
        // +1D ==> offset to the end of the next day
        // -1D ==> offset to the beginning of the previous day.
        var boundary = false;

        // set some defaults for missing params - if code calls dateAdd(date), with no other
        // params, the defaults will add 1 day to the passed date
        if (unit == null) unit = "d";
        if (amount == null) amount = 1;
        if (multiplier == null) multiplier = 1;
        if (isLogicalDate == null) isLogicalDate = date.logicalDate;

        // just in case we were passed a timeUnitName ("minute", rather than "mn", eg)
        if (unit.length > 2) unit = isc.DateUtil.getTimeUnitKey(unit);

        switch (unit) {
            case "MS":
                // no need to set boundary for ms - we don't have a finer gradation than this.
            case "ms":
                date.setMilliseconds(date.getMilliseconds()+(amount*multiplier));
                break;

            case "S":
                boundary = true;
            case "s":
                date.setSeconds(date.getSeconds()+(amount*multiplier));
                break;

            case "MN":
            case "N":
                boundary = true;
            case "mn":
            case "n":
                date.setMinutes(date.getMinutes()+(amount*multiplier));
                break;

            case "H":
                boundary = true;
            case "h":
                date.setHours(date.getHours()+(amount*multiplier));
                break;

            case "D":
                boundary = true;
            case "d":
                if (amount*multiplier != 0) date.setDate(date.getDate()+(amount*multiplier));
                break;

            case "W":
                boundary = true;
            case "w":
                date.setDate(date.getDate()+((amount*7)*multiplier));
                break;

            case "M":
                boundary = true;
            case "m":
                // assign last day of the target month to tempDate - it should never exceed that
                var tempDate = isc.DateUtil.createLogicalDate(date.getFullYear(),
                                   date.getMonth() + (amount * multiplier) + 1, 0);

                // for invalid date, use the min/max supported date
                if (isNaN(tempDate && tempDate.getMonth())) {
                    var extentTime = (8640000000000000-1) * multiplier;
                    tempDate = new Date(extentTime);
                }
                // tempDate has last day of month - if date has earlier day of month, use that
                if (date.getDate() < tempDate.getDate()) tempDate.setDate(date.getDate());
                // update date from tempDate - retains original logicalDate flag and time
                // portion - date will be rounded later, if "boundary" is true (M rather than m)
                date.setDate(tempDate.getDate());
                date.setFullYear(tempDate.getFullYear());
                date.setMonth(tempDate.getMonth());
                break;

            case "Q":
                boundary = true;
            case "q":
                date.setMonth(date.getMonth()+((amount*3)*multiplier));
                break;

            case "Y":
            case "YY":
            case "YYYY":
                boundary = true;
            case "y":
            case "yy":
            case "yyyy":
                date.setFullYear(date.getFullYear()+(amount*multiplier));
                break;

            case "DC":
                boundary = true;
            case "dc":
                date.setFullYear(date.getFullYear()+((amount*10)*multiplier));
                break;

            case "C":
                boundary = true;
            case "c":
                date.setFullYear(date.getFullYear()+((amount*100)*multiplier));
                break;
            default:
        }

        if (boundary) {
            // if rangePosition is set, use it irrespective of the direction of the math
            var pos = rangePosition || (multiplier > 0 ? "end" : "start");
            if (pos ==  "end") {
                date = this.getEndOf(date, unit, isLogicalDate, firstDayOfWeek);
            } else {
                date = this.getStartOf(date, unit, isLogicalDate, firstDayOfWeek);
            }
        }
        return date;
    },

    // getStartOf / getEndOf - methods to round a date to start or end of a period (week, day, etc)


    _datetimeOnlyPeriods:{
        ms:true, MS:true,
        s:true, S:true,
        mn:true, MN:true,
        n:true, N:true,
        h:true, H:true,
        d:true, D:true
    },

    //> @classMethod DateUtil.getStartOf() [A]
    // Returns the start of some period, like day, week or month, relative to a passed Date
    // instance.
    // @param date (Date) the base date to find the period start from
    // @param period (String) the period to return the start of, one of mn/h/d/w/m/y
    // @param [logicalDate] (Boolean) process and return a logicalDate with no time element
    // @param [firstDayOfWeek] (Integer) which day should be considered the firstDayOfWeek -
    //                overrides the default provided by the locale
    // @return (Date) a Date instance representing the start of the period relative to the
    //                passed date
    // @visibility external
    //<
    getStartOf : function (date, period, logicalDate, firstDayOfWeek) {
        var year, month, dateVal, hours, minutes, seconds, dayOfWeek;
        // the logicalDate param indicates whether to *return* a logicalDate, not whether the
        // date passed is already a logicalDate
        if (logicalDate == null) logicalDate = date.logicalDate;

        // firstDayOfWeek should never be null, as math will lead to NaN
        if (firstDayOfWeek == null) {
            firstDayOfWeek = isc.DateChooser ?
                             isc.DateChooser.getInstanceProperty("firstDayOfWeek") : 0;
        }

        // If we're passed a period <= "day", and we're working in logical dates, just return
        // the date - there's no way to round the time within a "logical date"
        if (logicalDate && this._datetimeOnlyPeriods[period] == true) {
            this.logInfo("DateUtil.getStartOf() passed period:"
                + period + " for logical date. Ignoring");
            var newDate = new Date(date.getTime());
            newDate.logicalDate = true;
            return newDate;
        }

        if (!isc.Time._customTimezone || date.logicalDate) {
            // no custom timezone, or the passed date is a logicalDate
            month = date.getMonth();
            dateVal = date.getDate();
            year = date.getFullYear();

            hours = date.getHours();
            minutes = date.getMinutes();
            seconds = date.getSeconds();

            dayOfWeek = date.getDay();

        // Developer specified custom timezone
        } else {
            // Use the "offsetDate" trick we use for formatting datetimes - easier to shift the
            // date and call native date APIs than to actually modify potentially
            // minute, hour, date, month, year directly.
            var offsetDate = date._getTimezoneOffsetDate(
                isc.Time.getUTCHoursDisplayOffset(date),
                isc.Time.getUTCMinutesDisplayOffset(date)
            );

            month = offsetDate.getUTCMonth();
            dateVal = offsetDate.getUTCDate();
            year = offsetDate.getUTCFullYear();

            hours = offsetDate.getUTCHours();
            minutes = offsetDate.getUTCMinutes();
            seconds = offsetDate.getUTCSeconds();

            dayOfWeek = offsetDate.getUTCDay();
        }

        switch (period.toLowerCase()) {
            case "s":
                // start of second - bit dramatic, but may as well be there
                return isc.DateUtil.createDatetime(year, month, dateVal, hours, minutes,
                                                   seconds, 0);
            case "mn":
            case "n":
                // start of minute
                return isc.DateUtil.createDatetime(year, month, dateVal, hours, minutes, 0, 0);

            case "h":
                // start of hour
                return isc.DateUtil.createDatetime(year, month, dateVal, hours, 0, 0, 0);

            case "d":
                // start of day
                if (logicalDate) {
                    return isc.DateUtil.createLogicalDate(year, month, dateVal);
                } else {
                    return isc.DateUtil.createDatetime(year, month, dateVal, 0, 0, 0, 0);
                }

            case "w":
                // start of week
                var newDate;
                if (logicalDate) {
                    newDate = isc.DateUtil.createLogicalDate(year, month, dateVal);
                } else {
                    newDate = isc.DateUtil.createDatetime(year, month, dateVal, 0, 0, 0, 0);
                }
                var delta = dayOfWeek - firstDayOfWeek;
                if (delta < 0) delta += 7;
                newDate.setDate(newDate.getDate() - delta);
                return newDate;

            case "m":
                // start of month
                if (logicalDate) {
                    return isc.DateUtil.createLogicalDate(year, month, 1);
                } else {
                    return isc.DateUtil.createDatetime(year, month, 1, 0, 0, 0, 0);
                }
            case "q":
                // start of quarter
                var quarterStart = month - (month % 3);
                if (logicalDate) {
                    return isc.DateUtil.createLogicalDate(year, quarterStart, 1);
                } else {
                    return isc.DateUtil.createDatetime(year, quarterStart, 1, 0, 0, 0, 0);
                }
            case "y":
            case "yy":
            case "yyyy":
                // start of year
                if (logicalDate) {
                    return isc.DateUtil.createLogicalDate(year, 0, 1);
                } else {
                    return isc.DateUtil.createDatetime(year, 0, 1, 0, 0, 0, 0);
                }

            case "dc":
                // start of decade
                var decade = year - (year % 10);
                if (logicalDate) {
                    return isc.DateUtil.createLogicalDate(decade, 0, 1);
                } else {
                    return isc.DateUtil.createDatetime(decade, 0, 1, 0, 0 ,0, 0);
                }

            case "c":
                // start of century
                var century = year - (year % 100);
                if (logicalDate) {
                    return isc.DateUtil.createLogicalDate(century, 0, 1);
                } else {
                    return isc.DateUtil.createDatetime(century, 0, 1, 0, 0, 0, 0);
                }
        }

        return date.duplicate();
    },

    //> @classMethod DateUtil.getEndOf() [A]
    // Returns the end of some period, like day, week or month, relative to a passed Date
    // instance.
    // @param date (Date) the base date to find the period end from
    // @param period (String) the period to return the end of, one of mn/h/d/w/m/y
    // @param [logicalDate] (Boolean) process and return a logicalDate with no time element
    // @param [firstDayOfWeek] (Integer) which day should be considered the firstDayOfWeek -
    //                overrides the default provided by the locale
    // @return (Date) a Date instance representing the end of the period relative to the
    //                passed date
    // @visibility external
    //<
    getEndOf : function (date, period, logicalDate, firstDayOfWeek) {

        var year, month, dateVal, hours, minutes, seconds, dayOfWeek;
        // the logicalDate param indicates whether to *return* a logicalDate, not whether the
        // date passed is already a logicalDate
        if (logicalDate == null) logicalDate = date.logicalDate;

        // firstDayOfWeek should never be null, as math will lead to NaN
        if (firstDayOfWeek == null) {
            firstDayOfWeek = isc.DateChooser ?
                             isc.DateChooser.getInstanceProperty("firstDayOfWeek") : 0;
        }

        // If we're passed a period <= "day", and we're working in logical dates, just return
        // the date - there's no way to round the time within a "logical date"
        if (logicalDate && this._datetimeOnlyPeriods[period] == true) {
            this.logInfo("DateUtil.getEndOf() passed period:"
                + period + " for logical date. Ignoring");
            var newDate = new Date(date.getTime());
            newDate.logicalDate = true;
            return newDate;
        }

        if (!isc.Time._customTimezone || date.logicalDate) {
            month = date.getMonth();
            dateVal = date.getDate();
            year = date.getFullYear();

            hours = date.getHours();
            minutes = date.getMinutes();
            seconds = date.getSeconds();

            dayOfWeek = date.getDay();

        // Developer specified custom timezone
        } else {
            // Use the "offsetDate" trick we use for formatting datetimes - easier to shift the
            // date and call native date APIs than to actually modify potentially
            // minute, hour, date, month, year directly.
            var offsetDate = date._getTimezoneOffsetDate(
                isc.Time.getUTCHoursDisplayOffset(date),
                isc.Time.getUTCMinutesDisplayOffset(date)
            );

            month = offsetDate.getUTCMonth();
            dateVal = offsetDate.getUTCDate();
            year = offsetDate.getUTCFullYear();

            hours = offsetDate.getUTCHours();
            minutes = offsetDate.getUTCMinutes();
            seconds = offsetDate.getUTCSeconds();

            dayOfWeek = offsetDate.getUTCDay();
        }

        switch (period.toLowerCase()) {
            case "s":
                // end of second
                return isc.DateUtil.createDatetime(year, month, dateVal, hours, minutes,
                                                   seconds, 999);
            case "mn":
            case "n":
                // end of minute
                return isc.DateUtil.createDatetime(year, month, dateVal, hours, minutes, 59,
                                                   999);

            case "h":
                // end of hour
                return isc.DateUtil.createDatetime(year, month, dateVal, hours, 59, 59, 999);

            case "d":
                // end of day
                if (logicalDate) {
                    return isc.DateUtil.createLogicalDate(year, month, dateVal);
                } else {
                    return isc.DateUtil.createDatetime(year, month, dateVal, 23, 59, 59, 999);
                }

            case "w":
                // end of week
                var delta = (6-(dayOfWeek-firstDayOfWeek));
                if (delta >= 7) delta -= 7;
                var endDate = dateVal + delta;
                if (logicalDate) {
                    return isc.DateUtil.createLogicalDate(year, month, endDate);
                } else {
                    return isc.DateUtil.createDatetime(year, month, endDate, 23, 59, 59, 999);
                }

            case "m":
                // end of month
                // Get start of *next* month, then knock back to prev day.
                var newDate;
                if (logicalDate) {
                    newDate = isc.DateUtil.createLogicalDate(year, month+1, 1);
                    newDate.setDate(newDate.getDate() - 1);
                } else {
                    newDate = isc.DateUtil.createDatetime(year, month+1, 1, 0, 0, 0, 0);
                    newDate.setTime(newDate.getTime()-1);
                }
                return newDate;

            case "q":
                // end of quarter
                var nextQ = month + 3 - (month%3),
                    newDate;
                if (logicalDate) {
                    newDate = isc.DateUtil.createLogicalDate(year, nextQ, 1);
                    newDate.setDate(newDate.getDate()-1);
                } else {
                    newDate = isc.DateUtil.createDatetime(year, nextQ, 1, 0, 0, 0, 0);
                    newDate.setTime(newDate.getTime()-1);
                }
                return newDate;

            case "y":
            case "yy":
            case "yyyy":
                // end of year
                if (logicalDate) {
                    return isc.DateUtil.createLogicalDate(year, 11, 31);
                } else {
                    return isc.DateUtil.createDatetime(year, 11, 31, 23, 59, 59, 999);
                }

            case "dc":
                // end of decade
                var decade = year + 10 - (year % 10);
                if (logicalDate) {
                    return isc.DateUtil.createLogicalDate(decade, 11, 31);
                } else {
                    return isc.DateUtil.createDatetime(decade, 11, 31, 23, 59, 59, 999);
                }

            case "c":
                // end of century
                var century = year +100 - (year % 100);
                if (logicalDate) {
                    return isc.DateUtil.createLogicalDate(century, 11, 31);
                } else {
                    return isc.DateUtil.createDatetime(century,  11, 31, 23, 59, 59, 999);
                }
        }
        return date.duplicate();
    },

    // mappings between "TimeUnit" strings and the equivalent period markers used in
    // RelativeDateStrings and Calendars/Timelines
    _timeUnitMapping:{
        ms:"millisecond",
        s:"second",
        // support mn and n for minutes (Excel uses n)
        mn:"minute",
        n:"minute",
        h:"hour",
        d:"day",
        w:"week",
        m:"month",
        q:"quarter",
        // support y, yy and yyyy for year (Excel uses yyyy)
        y:"year",
        yy:"year",
        yyyy:"year",
        dc:"decade",
        c:"century"
    },
    getTimeUnitName : function (timeUnitKey) {
    