/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.contentexport;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public final class SvgImage {
    private final SVGDocument document;
    private final GraphicsNode sn;

    private static GraphicsNode getRootNode(SVGDocument document) {
        UserAgentAdapter userAgentAdapter = new UserAgentAdapter();
        BridgeContext bridgeContext = new BridgeContext((UserAgent)userAgentAdapter);
        GVTBuilder builder = new GVTBuilder();
        return builder.build(bridgeContext, (Document)document);
    }

    public SvgImage(String svgString) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        this.document = (SVGDocument)factory.createDocument(null, (Reader)new StringReader(svgString));
        this.sn = SvgImage.getRootNode(this.document);
    }

    public SvgImage(SVGDocument document) {
        this.document = document;
        this.sn = SvgImage.getRootNode(document);
    }

    public final SVGDocument getSvgDocument() {
        return this.document;
    }

    public final GraphicsNode getRootGvtNode() {
        return this.sn;
    }

    public final Rectangle2D getViewBox() {
        SVGSVGElement svgElem = (SVGSVGElement)this.document.getDocumentElement();
        try {
            SVGRect viewBoxRect = svgElem.getViewBox().getBaseVal();
            return new Rectangle2D.Float(viewBoxRect.getX(), viewBoxRect.getY(), viewBoxRect.getWidth(), viewBoxRect.getHeight());
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public final Rectangle2D getDimensionsPx() {
        return this.getDimensions((short)5);
    }

    public final Rectangle2D getDimensions(short unitType) {
        SVGSVGElement svgElem = (SVGSVGElement)this.document.getDocumentElement();
        SVGLength xLen = svgElem.getX().getBaseVal();
        SVGLength yLen = svgElem.getY().getBaseVal();
        SVGLength widthLen = svgElem.getWidth().getBaseVal();
        SVGLength heightLen = svgElem.getHeight().getBaseVal();
        xLen.convertToSpecifiedUnits(unitType);
        yLen.convertToSpecifiedUnits(unitType);
        widthLen.convertToSpecifiedUnits(unitType);
        heightLen.convertToSpecifiedUnits(unitType);
        return new Rectangle2D.Float(xLen.getValueInSpecifiedUnits(), yLen.getValueInSpecifiedUnits(), widthLen.getValueInSpecifiedUnits(), heightLen.getValueInSpecifiedUnits());
    }

    public BufferedImage createImage() {
        Rectangle2D dimensions = this.getDimensionsPx();
        int imageWidth = (int)Math.ceil(dimensions.getWidth());
        int imageHeight = (int)Math.ceil(dimensions.getHeight());
        BufferedImage bufferedImage = new BufferedImage(imageWidth, imageHeight, 5);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, imageWidth, imageHeight);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, "Printing");
        this.sn.paint(g2d);
        g2d.dispose();
        return bufferedImage;
    }
}

