/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.crypto.CryptoUtil;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.RequiresCompleteRESTResponse;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.HttpUtil;
import com.isomorphic.util.SimpleHttpResponse;
import com.isomorphic.velocity.Velocity;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jxpath.JXPathContext;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class RESTDataSource
extends BasicDataSource {
    private static Logger log = new Logger(RESTDataSource.class.getName());
    private static ConcurrentHashMap<String, AuthToken> authTokenCache = new ConcurrentHashMap();

    @Override
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        super.init(theConfig, dsRequest);
    }

    @Override
    public DSResponse executeFetch(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeUpdate(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeAdd(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeRemove(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeCustom(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeReplace(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeDownload(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataTypeMap resolveAuth(DataTypeMap serverConfig) throws Exception {
        String authType;
        DataTypeMap<String, String> headers;
        DataTypeMap authConfig = serverConfig.getMap("auth");
        if (authConfig == null) {
            return serverConfig;
        }
        AuthToken authToken = null;
        DataTypeMap authRecord = null;
        String authDataSource = authConfig.getString("dataSource");
        if (authDataSource != null) {
            Object object;
            authToken = authTokenCache.get(authDataSource);
            if (authToken == null) {
                object = authTokenCache;
                synchronized (object) {
                    authToken = authTokenCache.get(authDataSource);
                    if (authToken == null) {
                        authToken = new AuthToken(authConfig);
                        authTokenCache.put(authDataSource, authToken);
                    }
                }
            }
            if (authToken.isExpired()) {
                object = authToken;
                synchronized (object) {
                    if (authToken.isExpired()) {
                        authToken.renew();
                    }
                }
            }
            authRecord = authToken.getAuthRecord();
        }
        String jwt = null;
        DataTypeMap jwtConfig = authConfig.getMap("jwt");
        if (jwtConfig != null) {
            DataTypeMap jwtHeader = jwtConfig.getMap("header");
            DataTypeMap jwtBody = jwtConfig.getMap("body");
            if (jwtBody == null) {
                jwtBody = jwtConfig.getMap("claims");
            }
            JwtBuilder jwtBuilder = Jwts.builder();
            if (jwtHeader != null) {
                jwtBuilder.setHeader((Map)((Object)jwtHeader));
            }
            if (jwtBody != null) {
                jwtBuilder.setClaims((Map)((Object)jwtBody));
            }
            String signature = jwtConfig.getString("signature");
            String algorithm = jwtConfig.getString("algorithm");
            if (signature != null && algorithm != null) {
                if (algorithm.startsWith("RS")) {
                    PrivateKey privateKey = CryptoUtil.pemToPrivateKey(DataTools.base64DecodeToString(signature));
                    jwtBuilder.signWith(SignatureAlgorithm.forName((String)algorithm), (Key)privateKey);
                } else {
                    jwtBuilder.signWith(SignatureAlgorithm.forName((String)algorithm), DataTools.base64DecodeToBytes(signature));
                }
            }
            jwt = jwtBuilder.compact();
        }
        if ((headers = (serverConfig = (DataTypeMap)((Object)this.deepCloneWithVelocityEval((Object)serverConfig, "jwt/authRecord interpolation", (Map)((Object)DataTools.buildMap(new Object[]{"authRecord", authRecord, "jwt", jwt}))))).getMap("headers")) == null) {
            headers = new DataTypeMap<String, String>();
            serverConfig.put("headers", headers);
        }
        if (headers.get("Authorization") == null && authToken != null && ("authHeader".equals(authType = authConfig.getString("type")) || "bearerToken".equals(authType))) {
            headers.put("Authorization", authToken.getAuthorizationHeader());
        }
        return serverConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DSResponse processRequest(DSRequest dsRequest) throws Exception {
        String responseTemplate;
        String recordXPath;
        Object outboundData;
        String requestTemplate;
        String authType;
        DataTypeMap authConfig;
        DataTypeMap serverConfig = this.getServerConfig(dsRequest);
        if (serverConfig == null) {
            throw new Exception("You must define a serverConfig");
        }
        log.debug("server config: " + DataTools.prettyPrint((Object)serverConfig));
        serverConfig = this.resolveAuth(serverConfig);
        log.debug("serverConfig after resolveAuth: " + DataTools.prettyPrint((Object)serverConfig));
        String opType = dsRequest.getOperationType();
        String httpMethod = RESTDataSource.isAdd(opType) ? serverConfig.getString("addHttpMethod", serverConfig.getString("httpMethod", "POST")) : (RESTDataSource.isUpdate(opType) ? serverConfig.getString("updateHttpMethod", serverConfig.getString("httpMethod", "PUT")) : (RESTDataSource.isRemove(opType) ? serverConfig.getString("removeHttpMethod", serverConfig.getString("httpMethod", "DELETE")) : (RESTDataSource.isFetch(opType) ? serverConfig.getString("fetchHttpMethod", serverConfig.getString("httpMethod", "GET")) : serverConfig.getString("httpMethod", "GET"))));
        String dataURL = null;
        if (RESTDataSource.isAdd(opType)) {
            dataURL = serverConfig.getString("addURL");
        } else if (RESTDataSource.isUpdate(opType)) {
            dataURL = serverConfig.getString("updateURL");
        } else if (RESTDataSource.isRemove(opType)) {
            dataURL = serverConfig.getString("removeURL");
        } else if (RESTDataSource.isFetch(opType)) {
            dataURL = serverConfig.getString("fetchURL");
        }
        if (dataURL == null) {
            dataURL = serverConfig.getString("dataURL");
        }
        if (dataURL == null) {
            throw new Exception("Can't determine dataURL for operationType: " + opType);
        }
        log.info("dataURL: " + dataURL);
        DataTypeMap<String, Object> opts = new DataTypeMap<String, Object>();
        DataTypeMap headers = serverConfig.getMap("headers", (Map)((Object)new DataTypeMap()));
        opts.put("headers", (Object)headers);
        DataTypeMap params = new DataTypeMap();
        opts.put("params", (Object)params);
        if (serverConfig.getMap("params") != null) {
            params.putAll(serverConfig.getMap("params"));
        }
        if ((authConfig = serverConfig.getMap("auth")) != null && "basic".equals(authType = authConfig.getString("type", "basic"))) {
            opts.put("username", authConfig.getString("username"));
            opts.put("password", authConfig.getString("password"));
        }
        String requestFormat = null;
        String responseFormat = null;
        if (RESTDataSource.isAdd(opType)) {
            requestFormat = serverConfig.getString("addRequestFormat");
            responseFormat = serverConfig.getString("addResponseFormat");
        } else if (RESTDataSource.isUpdate(opType)) {
            requestFormat = serverConfig.getString("updateRequestFormat");
            responseFormat = serverConfig.getString("updateResponseFormat");
        } else if (RESTDataSource.isRemove(opType)) {
            requestFormat = serverConfig.getString("removeRequestFormat");
            responseFormat = serverConfig.getString("removeResponseFormat");
        } else if (RESTDataSource.isFetch(opType)) {
            requestFormat = serverConfig.getString("fetchRequestFormat");
            responseFormat = serverConfig.getString("fetchResponseFormat");
        }
        String dataFormat = serverConfig.getString("dataFormat", "json");
        if (requestFormat == null) {
            requestFormat = serverConfig.getString("requestFormat", dataFormat);
        }
        if (responseFormat == null) {
            responseFormat = serverConfig.getString("responseFormat", dataFormat);
        }
        if ((requestTemplate = serverConfig.getString("requestTemplate")) != null) {
            requestTemplate = requestTemplate.trim();
            if (!requestFormat.equals("json") && !requestFormat.equals("params")) throw new Exception("requestFormat: " + requestFormat + " is not supported");
            outboundData = JSTranslater.instance().fromJS(requestTemplate);
        } else {
            outboundData = new HashMap();
        }
        outboundData = this.setProperties(dsRequest.getValues(), outboundData, dsRequest);
        log.debug("outboundData: " + DataTools.prettyPrint(outboundData));
        if ("params".equals(requestFormat)) {
            if (!(outboundData instanceof Map)) throw new Exception("requestFormat: params, but derived source object is of type: " + outboundData.getClass().getName());
            params.putAll((Map)outboundData);
        } else {
            if (!requestFormat.equals("json")) {
                throw new Exception("requestFormat: " + requestFormat + " is not supported");
            }
            String body = JSTranslater.instance().strictJSONMode().toJS(outboundData);
            log.debug("outbound body:\n" + body);
            opts.put("body", body);
        }
        if (headers.get("Content-Type") == null && requestFormat.equals("json")) {
            headers.put("Content-Type", "application/json; charset=UTF-8");
        }
        DSResponse dsResponse = new DSResponse(this);
        opts.put("redirectStrategy", serverConfig.getString("redirectStrategy"));
        opts.put("sslTrustStrategy", serverConfig.getString("sslTrustStrategy"));
        opts.put("numRetriesServerDown", serverConfig.getInteger((Object)"numRetriesServerDown", null));
        opts.put("retryDelayServerDown", serverConfig.getInteger((Object)"retryDelayServerDown", null));
        opts.put("numRetriesFileNotFound", serverConfig.getInteger((Object)"numRetriesFileNotFound", null));
        opts.put("retryDelayFileNotFound", serverConfig.getInteger((Object)"retryDelayFileNotFound", null));
        SimpleHttpResponse httpResponse = HttpUtil.httpRequest(httpMethod, dataURL, opts);
        if (httpResponse == null) {
            log.warn("Server unreachable");
            dsResponse.setFailure();
            dsResponse.setData("Server unreachable");
            return dsResponse;
        }
        String responseBody = httpResponse.getBodyAsString();
        int statusCode = httpResponse.getStatusCode();
        log.info("HTTP response code: " + httpResponse.getStatusCode());
        log.debug("Raw response body: " + responseBody);
        if (!httpResponse.isSuccess()) {
            log.warn("HTTP response indicates failure - code: " + statusCode);
            dsResponse.setFailure();
            dsResponse.setData(responseBody);
            return dsResponse;
        }
        if (!"json".equals(responseFormat)) {
            throw new Exception("responseFormat: " + responseFormat + " is not supported");
        }
        long t1 = System.currentTimeMillis();
        Object data = JSTranslater.instance().fromJS(responseBody);
        long t2 = System.currentTimeMillis();
        log.debug("Parsing with JSTranslater took " + (t2 - t1) + "ms");
        if (this instanceof RequiresCompleteRESTResponse) {
            dsResponse.setProperty("completeData", data);
        }
        if ((recordXPath = serverConfig.getString("recordXPath")) != null && data != null) {
            JXPathContext context = JXPathContext.newContext((Object)data);
            data = context.getValue(recordXPath);
        }
        if ((responseTemplate = serverConfig.getString("responseTemplate")) != null) {
            if (!(data instanceof Map)) {
                Object firstElement;
                if (data instanceof Collection && ((Collection)data).size() == 1 && (firstElement = ((Collection)data).iterator().next()) instanceof Map) {
                    data = firstElement;
                }
                if (!(data instanceof Map)) {
                    throw new Exception("responseTemplate is defined, but response (after recordXPath) is of type: " + data.getClass().getName() + ", but something implementing Map is expected");
                }
            }
            data = this.getProperties(data, false, false);
            dsResponse.setBypassDataFilter(true);
            Map<Object, Object> velocityContext = Velocity.getStandardContextMap(dsRequest);
            velocityContext.put("dsResponse", dsResponse);
            responseTemplate = (String)this.doVelocityEval(responseTemplate, "responseTemplate", velocityContext);
            Object templateData = null;
            if (!responseFormat.equals("json")) {
                throw new Exception("responseFormat: " + responseFormat + " is not supported");
            }
            templateData = JSTranslater.instance().fromJS(responseTemplate);
            if (templateData != null) {
                data = DataTools.setProperties((Map)data, templateData);
            }
        }
        if (RESTDataSource.isFetch(opType)) {
            long t12 = System.currentTimeMillis();
            dsResponse.setData(DataTools.makeListIfSingle(data));
            List records = dsResponse.getDataList();
            ValidationContext vc = new ValidationContext();
            ArrayList<Map> validated = new ArrayList<Map>();
            for (int i = 0; i < records.size(); ++i) {
                Map record = (Map)records.get(i);
                record = this.getProperties((Object)record, false, false);
                this.validate(record, false, vc, true);
                validated.add(record);
            }
            vc.freeResources();
            dsResponse.setBypassDataFilter(true);
            dsResponse.setData(validated);
            long t22 = System.currentTimeMillis();
            log.debug("Processing XPaths and validating took " + (t22 - t12) + "ms");
        } else {
            dsResponse.setData(data);
        }
        dsResponse.setSuccess();
        return dsResponse;
    }

    private class AuthToken {
        DataTypeMap authConfig;
        DateTime expires;
        boolean neverExpires = false;
        DataTypeMap authRecord;
        int renewWindow = 30;
        String authorizationHeader;

        public AuthToken(DataTypeMap authConfig) {
            this.authConfig = authConfig;
            this.renewWindow = authConfig.getInt("renewWindow", this.renewWindow);
            this.neverExpires = authConfig.getBoolean((Object)"neverExpires", false);
        }

        public DataTypeMap getAuthRecord() {
            return this.authRecord;
        }

        public String getAuthorizationHeader() throws Exception {
            return this.authorizationHeader;
        }

        public void expire() {
            this.expires = null;
        }

        public boolean isExpired() {
            if (this.neverExpires) {
                return false;
            }
            if (this.expires == null) {
                return true;
            }
            return this.expires.isBefore((ReadableInstant)DateTime.now().plusSeconds(this.renewWindow));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void renew() throws Exception {
            String authDataSource = this.authConfig.getString("dataSource");
            if (authDataSource == null) {
                throw new Exception("You must define an auth dataSource");
            }
            Map _record = new DSRequest(authDataSource, "fetch").execute().getDataMap();
            if (_record == null) {
                throw new Exception("Failed to renew token - no valid record in response");
            }
            this.authRecord = new DataTypeMap(new ConcurrentHashMap(_record));
            log.debug("received authRecord: " + DataTools.prettyPrint((Object)this.authRecord));
            String tokenField = this.authConfig.getString("tokenField", "access_token");
            String expiresField = this.authConfig.getString("expiresField", "expires");
            String expiresInField = this.authConfig.getString("expiresInField", "expires_in");
            String authorizationHeaderField = this.authConfig.getString("authorizationHeaderField", "authorizationHeader");
            this.authorizationHeader = this.authRecord.getString(authorizationHeaderField);
            if (this.authorizationHeader == null) {
                String authType = this.authConfig.getString("type");
                if (!"bearerToken".equals(authType)) throw new Exception("Unable to derive authorizatioHeader - explicit value not present at fieldName: " + authorizationHeaderField);
                String token = this.authRecord.getString(tokenField);
                if (token == null) {
                    throw new Exception("Bearer token not found at field: " + tokenField);
                }
                this.authorizationHeader = "Bearer " + token;
            } else {
                log.debug("Using explicit authorizationHeader: " + this.authorizationHeader);
            }
            Long expires = this.authRecord.getLong(expiresField);
            if (expires == null) {
                Integer expiresIn = this.authRecord.getInteger(expiresInField);
                if (expiresIn == null) {
                    throw new Exception("Unable to find either an " + expiresField + " or " + expiresInField + " field on the response.");
                }
                this.expires = DateTime.now().plusSeconds(expiresIn.intValue());
                return;
            } else if (expires == -1L) {
                log.info("Accepted a non-expiring token");
                this.neverExpires = true;
                return;
            } else {
                this.expires = new DateTime((Object)expires);
            }
        }
    }
}

