<%@ taglib uri="/WEB-INF/iscTaglib.xml" prefix="isomorphic" %>
<%@ page import="com.isomorphic.base.*" %>
<%@ page import="com.isomorphic.rpc.*" %>
<%@ page import="com.isomorphic.auth.*" %>
<%@ page import="com.isomorphic.site.*" %>
<%@ page import="com.isomorphic.servlet.*" %>
<%@ page import="java.util.*" %>
<%
RequestContext requestContext = RequestContext.instance(this, request, response, out);
Map user = DevCenter.getUserRecordForOutputToBrowser(requestContext);
String username = user != null ? (String)user.get("username") : null;
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<title>VisualBuilder Analytics Viewer</title>
<isomorphic:loadISC skin="Tahoe"/>
</head>
<body>

<SCRIPT>
<isomorphic:loadDS name="hostedUsageData"/>
<isomorphic:loadDS name="hostedUsageViews"/>

var userId = <% requestContext.jsTrans.toJS(username, out); %>,
    jsonSettings = {dateFormat: "logicalDateConstructor"}
;

// argument labels, per action
var argumentDesc = {
    appStart: ["initial project", "initial screen"],
    paletteSearch: ["search term"],
    createProject: ["project name"],
    createScreen: ["screen name"],
    componentAdd: ["component name", "parent class name"],
    componentMove: ["component name", "new parent class name"],
    componentEdit: ["first property changed", "new value"],
    createDataSource: ["name", "type"],
    relogin: ["session length so far (seconds)"],
    logout: ["session length (seconds)"],
    "export": ["project name"],
    projectShare: ["project name"],
    addSharedDS: ["name", "type"],
    addSharedScreen: ["screen name"],
    viewScreenCode: ["screen name"],
    switchScreen: ["new screen", "prior screen"],
    renameScreen: ["new name", "old name"],
    deleteScreen: ["screen name", "project name"],
    removeScreen: ["screen name", "project name"],
    revert:       ["screen name", "project name"],
    loadRecentVersion: ["screen name", "version (timestamp)"],
    runProject: ["project name", "run config name"],
    skinChange: ["new skin name"],
    resolutionChange: ["new resolution"]
};

// add an argument label to supplied argument value
function formatArg (action, value, position) {
    if (value == null) return null;
    var desc = argumentDesc[action];
    if (desc) value = desc[position] + ": " + value;
    return value;
}

isc.ListGrid.create({
    ID: "usageData", autoDraw: false,
    height: "100%", width: "100%",

    autoFetchData: true,
    showFilterEditor: true,
    fetchOperation: "adminFetch",
    useAllDataSourceFields: true,
    dataSource: hostedUsageData,
    autoFitWidthApproach: "both",

    showGridSummary: true,
    showGroupSummary: true,
    showGroupSummaryInHeader: true,
    groupByMaxRecords: 10000,
    summaryRowDataSource: hostedUsageData,
    summaryRowProperties: {
        fetchOperation: "adminSummaryFetch"
    },                  

    initialSort: [{
        property: "timeStamp",
        direction: "descending"
    }],
    initialCriteria: {
        _constructor: "AdvancedCriteria",
        operator: "and",
        criteria: [{
            fieldName: "timeStamp",
            operator: "greaterThan",
            value: isc.DateUtil.dateAdd(new Date(), "w", 1, -1)
        }]
    },

    fields: [{
        name: "timeStamp", width: 115,
        dateFormatter: "MM/dd/YYYY HH:mm:ss"
    },{
        name: "userId", autoFitWidth: true,
        editorType: "SelectItem", multiple: true,
        optionOperationId: "uniqueUsers",
        optionDataSource: hostedUsageData
    },{
        name: "organization", autoFitWidth: true,
        editorType: "SelectItem", multiple: true,
        optionOperationId: "uniqueOrgs",
        optionDataSource: hostedUsageData
    },{
        name: "action", autoFitWidth: true,
        editorType: "SelectItem", multiple: true,
        optionOperationId: "uniqueActions",
        optionDataSource: hostedUsageData
    }, {
        name: "data",
        formatCellValue : function (value, record) {
            return formatArg(record.action, value, 0);
        }
    }, {
        name: "data2",
        formatCellValue : function (value, record) {
            return formatArg(record.action, value, 1);
        }
    }]
});

isc.DynamicForm.create({
    ID: "usageViews", autoDraw: false, 
    numCols: 5, wrapItemTitles: false, 
    colWidths: [125, "*", 110, 120, 150], 

    fields: [{
        name: "select", title: "Select Saved View",
        editorType: "SelectItem", width:"*",
        optionDataSource: hostedUsageViews,
        valueField: "name",
        // clear the value so last view loaded can be reapplied (after making view changes)
                showPickList : function () {
            this.clearValue();
            return this.Super("showPickList", arguments);
        },
        // picker selection made
        changed : function (form, item, value) {
            var addName = form.getItem("name"),
                addButton = form.getItem("add");
            // update "save as" name to be selected view name
            addButton.setDisabled(false);
            addName.setValue(value);
            // apply the selected view name, reporting failure
            if (!form.setView(value)) {
                isc.Notify.addMessage("Could not set view '" + value + "'", null, "error");
            }
        }
    }, {
        name: "add", title: "Save Current View", endRow:false,
        editorType: "ButtonItem", startRow: false, disabled: true,
        // add new view record
        click : function (form) {
            form.addView();
        },
        // ensure hovering over disabled button alerts user to type a view name
        buttonProperties: {
            canHover: true,
            getHoverHTML: function () {
                return this.disabled ? "Type a 'Save as Name' to enable" : null;
            }
        }
    }, {
        name: "name", title: "Save as Name", type: "text",
        itemHoverHTML: function () {
            return "View will be saved under this name"
        },
        // enable save button if a name has been typed
        changed : function (form, item, value) {
            var addButton = form.getItem("add");
            addButton.setDisabled(!value);
        }
    }],
    // apply stored view and filter from hostedUsageViews
    setView : function (viewName) {
        var pickList = this.getItem("select").pickList;
        if (!pickList) return;

        var record = pickList.find({name: viewName});
        if (!record) return;

        usageData.setViewState(record.viewState);

        // the filterEditor criteria must be deserialized
        var filterCrit = isc.JSON.decode(record.filterState);
        if (filterCrit) usageData.setCriteria(filterCrit);

        return true;
    },
    // store the current view and filter to hsotedUsageViews
    addView : function (update) {
        var pickList = this.getItem("select").pickList;
        if (!pickList) return;

        var viewName = this.getItem("name").getValue(),
            filterCrit = usageData.getFilterEditorCriteria()
        ;

        var record = {
            name: viewName, userId: userId,
            viewState: usageData.getViewState(),
            filterState: isc.JSON.encode(filterCrit, jsonSettings)
        };

        // update: true; from confirm dialog callback
        if (update) { 
            pickList.updateData(record, function () {
                isc.notify("View '" + viewName + "' updated");
            });

        // if view name already exists, prompt before clobbering
        } else if (pickList.find({name: viewName}) != null) {
            isc.confirm("Overwrite existing view '" + viewName + "'?",
                function (value) {
                    if (value) usageViews.addView(true);
                });

        // default case; no view name collision
        } else {
            pickList.addData(record, function () {
                isc.notify("View '" + viewName + "' added");                
            });
        }
    }
});

isc.Label.create({
    ID: "usageDesc", height: 1,
    contents: "<b>View and Filter the available VisualBuilder Analytics Usage Records</b>"
});

isc.VLayout.create({
    width: "100%", height: "100%",
    members: [usageDesc, usageData, usageViews]
});

</SCRIPT>
</body>
</html>
