/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.util.DataTools;
import java.util.List;
import java.util.Map;

public class SQLTable
extends Base {
    String tableName;
    List primaryKeys;
    Map columnTypes;
    Map sequences;
    Map native2DSColumnMap;
    boolean quoteColumnNames;

    public SQLTable(String tableName, List primaryKeys, Map columnTypes, Map native2DSColumnMap, Map sequences, boolean quoteColumnNames) {
        this.tableName = tableName;
        this.primaryKeys = primaryKeys;
        this.columnTypes = columnTypes;
        this.sequences = sequences;
        this.native2DSColumnMap = native2DSColumnMap;
        this.quoteColumnNames = quoteColumnNames;
    }

    public String getName() {
        return this.tableName;
    }

    public List getPrimaryKeys() {
        return this.primaryKeys;
    }

    public Map getColumnTypes() {
        return this.columnTypes;
    }

    public String getColumnType(String columnName) {
        return (String)this.columnTypes.get(columnName);
    }

    public Map getSequences() {
        return this.sequences;
    }

    public String getSequence(String columnName) {
        return (String)this.sequences.get(columnName);
    }

    public Map getNative2DSColumnMap() {
        return this.native2DSColumnMap;
    }

    public boolean isQuoteColumnNames() {
        return this.quoteColumnNames;
    }

    public String getNameQuotedIfNecessary(SQLDataSource ds) throws Exception {
        return SQLTable.getNameQuotedIfNecessary(ds, this.getName());
    }

    public static String getNameQuotedIfNecessary(SQLDataSource ds, String tableName) throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean quoteTableName = DataTools.asBoolean((Object)ds.getConfig().get((Object)"quoteTableName"), (boolean)false);
        if (quoteTableName) {
            buf.append(ds.getDriver().openQuote());
        }
        buf.append(tableName);
        if (quoteTableName) {
            buf.append(ds.getDriver().closeQuote());
        }
        return buf.toString();
    }
}

