/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.Utils;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;

public class TestRunnerConfiguration {
    private static Logger log = new Logger(TestRunnerConfiguration.class.getName());
    protected static final String DEFAULT_BROWSER = "*firefox";
    protected static final String USER_EXTENSIONS = "tools/selenium/user-extensions.js";
    protected static final String SELENIUM_TEMPLATE = "_internalSource/autotest/seleniumTestSuite.template";
    protected static final String MAIL_TEMPLATE = "_internalSource/mailTemplates/autotest.template";
    protected static final String DEFAULT_CC_EMAIL = "autotest_results@isomorphic.com";
    protected static final String SGWT_EXAMPLE_MAP_FILE = "../../sgwtgen/trunk/fmpp/src/examples.ftl";
    protected static final int SGWT_RUNNER_HTTP_PORT = System.getenv("DEV_SGWT_HOSTED_MODE_PORT") != null ? Integer.parseInt(System.getenv("DEV_SGWT_HOSTED_MODE_PORT")) : 8888;
    protected final PropertyRecord[] properties = new PropertyRecord[]{new PropertyRecord("HttpPort", "SERVER_HTTP_PORT", null, "hp", 8080), new PropertyRecord("HttpTarget", "SERVER_HTTP_TARGET", null, "ht", "localhost"), new PropertyRecord("GwtDevPort", "GWT_DEV_PORT", null, "gp", 0), new PropertyRecord("TestRunnerTimeout", "TESTRUNNER_TIMEOUT", null, "ot", 60), new PropertyRecord("SeleniumTimeout", "SELENIUM_TIMEOUT", null, "st", 120), new PropertyRecord("JenkinsMaximumLifespan", "MAXIMUM_JENKINS_LIFESPAN", null, null, 21600000), new PropertyRecord("SmartGWTExampleMapFile", "SGWT_EXAMPLE_MAP_FILE", null, null, "../../sgwtgen/trunk/fmpp/src/examples.ftl"), new PropertyRecord("SgwtRunnerClassSpan", "SGWTRUNNER_CLASS_SPAN", null, null, 10), new PropertyRecord("FatalBatchError", "FATAL_BATCH_ERROR", null, null), new PropertyRecord("NightlyBuildOffset", "NIGHTLY_BUILD_OFFSET", null, null, 0.0), new PropertyRecord("BuildDate", "BUILD_DATE", null, null), new PropertyRecord("Branch", "DEV_BRANCH", "autotest.branch", "br", "MAIN"), new PropertyRecord("Files", null, null, "f"), new PropertyRecord("BatchLog", null, null, "lg"), new PropertyRecord("UserName", null, "autotest.userName", "un"), new PropertyRecord("AlertEmail", null, "autotest.alertEmail", "e"), new PropertyRecord("RepeatEmail", null, "autotest.repeatEmail", "re"), new PropertyRecord("CcEmail", null, "autotest.ccEmail", "cc", "autotest_results@isomorphic.com"), new PropertyRecord("SenderEmail", null, "autotest.senderEmail", "se"), new PropertyRecord("NoEmail", null, null, "ne"), new PropertyRecord("MailHost", null, "autotest.mailHost", "m"), new PropertyRecord("MailSubject", null, "autotest.mailSubject", "ms", "[TestRunner Batch] "), new PropertyRecord("Browser", null, "autotest.browser", "b", "*firefox"), new PropertyRecord("Timestamp", null, null, "t"), new PropertyRecord("BatchCommit", null, null, "c", false), new PropertyRecord("FileRoot", null, null, "fr"), new PropertyRecord("SaveMessages", null, null, "sm"), new PropertyRecord("CaptureScreenshot", null, null, "cs"), new PropertyRecord("MaximizeBrowser", null, null, "x", false), new PropertyRecord("WebDriverLegacyMode", null, null, "l", false), new PropertyRecord("ServerLogMode", null, null, "vm", "some"), new PropertyRecord("ServerLogOutputMethod", null, null, "vo", "email"), new PropertyRecord("HistoryDepth", null, null, "hd", 0), new SuiteSpecificPropertyRecord("ShowcaseFile", "SHOWCASE_FILE", null, null, "DefaultShowcaseFile"), new SuiteSpecificPropertyRecord("ServerFileRoot", "SERVER_FILE_ROOT", null, "sr", "DefaultShowcaseRoot"), new PropertyRecord("BatchRunDS", null, "autotest.batchRunDS", null, "batchRun"), new PropertyRecord("TestResultDS", null, "autotest.testResultDS", null, "testResult"), new PropertyRecord("MailTemplate", null, "autotest.mailTemplate", "mt", "_internalSource/mailTemplates/autotest.template", "_internalSource/mailTemplates/autotest.template", "mailTemplates/batchReport.template"), new PropertyRecord("TestRoot", "TESTRUNNER_TEST_ROOT", "autotest.testRoot", "tr", "isomorphic/QA", "isomorphic/system/reference/inlineExamples", "tests"), new PropertyRecord("SeleniumTemplateFile", "SELENIUM_TEMPLATE_FILE", "selenium.templateFile", null, "_internalSource/autotest/seleniumTestSuite.template", "_internalSource/autotest/seleniumTestSuite.template", "tools/selenium/testSuite.template"), new PropertyRecord("UserExtensionsFile", "USER_EXTENSIONS_FILE", "selenium.userExtensionsFile", null, "tools/selenium/user-extensions.js", "tools/selenium/user-extensions.js", "tools/selenium/user-extensions.js")};
    private String fileRoot;
    private String testRoot;
    private int testRunnerTimeout;
    private int seleniumTimeout;
    private String fileList;
    private String showcaseFile;
    private String serverFileRoot;
    private String mailSubject;
    private String mailTemplate;
    private int gwtDevModePort;
    private int seleniumHttpPort;
    private String seleniumHttpTarget;
    private boolean saveMessages;
    private boolean fileRootIsDevEnv;
    private boolean captureScreenshot;
    private String serverLogOutputMethod;
    private String serverLogMode;
    private int historyDepth;
    private String userExtensionsFile;
    private String seleniumTemplateFile;
    private String excludedTestFilePrefix;
    private String smartGwtExampleMapFile;

    public void setTestRunnerTimeout(int timeout) {
        this.testRunnerTimeout = timeout;
    }

    public void setSeleniumTimeout(int timeout) {
        this.seleniumTimeout = timeout;
    }

    public int getTestRunnerTimeout() {
        if (this.testRunnerTimeout > 0) {
            return this.testRunnerTimeout;
        }
        return (Integer)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public int getSeleniumTimeout() {
        if (this.seleniumTimeout > 0) {
            return this.seleniumTimeout;
        }
        return (Integer)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public void setGwtDevPort(int port) {
        this.gwtDevModePort = port;
    }

    public int getGwtDevPort() {
        if (this.gwtDevModePort != 0) {
            return this.gwtDevModePort;
        }
        return (Integer)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public String getGwtDevArgument() {
        int port = this.getGwtDevPort();
        if (port == 0) {
            return "";
        }
        return "gwt.codesvr=localhost:" + port;
    }

    public void setHttpTarget(String target) {
        this.seleniumHttpTarget = target;
    }

    public String getHttpTarget() {
        if (this.seleniumHttpTarget != null) {
            return this.seleniumHttpTarget;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public void setHttpPort(int port) {
        this.seleniumHttpPort = port;
    }

    public int getHttpPort(ShowcaseSpecifier showcase) {
        if (this.seleniumHttpPort != 0) {
            return this.seleniumHttpPort;
        }
        boolean isSgwtRunner = showcase != null ? showcase.isSmartGWTRunner() : false;
        return (Integer)this.getOptionValue(Utils.getCurrentMethodName(), null, isSgwtRunner, SGWT_RUNNER_HTTP_PORT);
    }

    protected String getHttpBaseURL(ShowcaseSpecifier showcase) {
        return "http://" + this.getHttpTarget() + ":" + this.getHttpPort(showcase) + this.getServerFileRoot(showcase);
    }

    public void setFiles(String[] files) {
        this.fileList = StringUtils.join((Object[])files, (String)" ");
    }

    public void setFiles(String fileList) {
        this.fileList = fileList;
    }

    protected String getFiles() {
        if (this.fileList != null) {
            return this.fileList;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public void setShowcaseFile(String path) {
        this.showcaseFile = path;
    }

    public String getShowcaseFile(ShowcaseSpecifier showcase) {
        if (this.showcaseFile != null) {
            return this.showcaseFile;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName(), showcase, "");
    }

    public void setServerFileRoot(String path) {
        this.serverFileRoot = path;
    }

    public String getServerFileRoot(ShowcaseSpecifier showcase) {
        String result = this.serverFileRoot != null ? this.serverFileRoot : (String)this.getOptionValue(Utils.getCurrentMethodName(), showcase, "");
        return result.replaceFirst("^([^/])", "/$1").replaceFirst("(/)*$", "/");
    }

    public void setSmartGWTExampleMapFile(String path) {
        this.smartGwtExampleMapFile = path;
    }

    public String getSmartGWTExampleMapFile() {
        String result = this.smartGwtExampleMapFile != null ? this.smartGwtExampleMapFile : (String)this.getOptionValue(Utils.getCurrentMethodName());
        return this.getPathRelativeToFileRoot(result);
    }

    public void setSeleniumTemplateFile(String path) {
        this.seleniumTemplateFile = path;
    }

    public String getSeleniumTemplateFile() {
        String result = this.seleniumTemplateFile != null ? this.seleniumTemplateFile : (String)this.getOptionValue(Utils.getCurrentMethodName());
        return this.getPathRelativeToFileRoot(result);
    }

    public void setUserExtensionsFile(String path) {
        this.userExtensionsFile = path;
    }

    public String getUserExtensionsFile() {
        String result = this.userExtensionsFile != null ? this.userExtensionsFile : (String)this.getOptionValue(Utils.getCurrentMethodName());
        return this.getPathRelativeToFileRoot(result);
    }

    protected String getPathRelativeToFileRoot(String path) {
        if (DataTools.pathIsRelative((String)path)) {
            if (Utils.isUnqualifiedFilename(path)) {
                List files;
                File file = new File(path);
                if (!file.exists() && (files = ISCFile.find((String)this.fileRoot, (boolean)true, (String)(".*" + path))) != null && files.size() > 0) {
                    path = (String)files.get(0);
                }
            } else {
                path = this.fileRoot + "/" + path;
            }
        }
        return path != null ? path.replaceFirst("(/)*$", "") : null;
    }

    protected void initFileRoot() {
        ServletContext context = ISCFile.servletContext;
        if (context != null) {
            log.warn((Object)("Danger - ServletContext detected as " + context));
        }
        String webRoot = Config.getGlobal().getPath("webRoot");
        log.info((Object)("Detected webRoot as " + webRoot));
        if (this.fileRoot != null) {
            log.info((Object)("Detected fileRoot as " + this.fileRoot));
        }
        if ("__USE_CONTAINER__".equals(webRoot)) {
            if (this.fileRoot == null) {
                this.fileRoot = ISCFile.canonicalizePath((String)System.getProperty("user.dir"));
                log.info((Object)("Setting fileRoot to current working directory " + this.fileRoot));
            }
            ISCFile.setFallBackRootDir((String)this.fileRoot);
            log.info((Object)("Setting container fallback root directory to " + this.fileRoot));
        } else {
            if (this.fileRoot == null) {
                this.fileRoot = webRoot;
                log.info((Object)"Setting fileRoot to webRoot");
            } else if (!this.fileRoot.equals(webRoot)) {
                log.warn((Object)"Both fileRoot and webRoot are set, but they are different! You may be able to modify server.properties to change webRoot.");
            }
            if (System.getenv("HAVE_DEVENV") != null) {
                this.fileRootIsDevEnv = true;
            }
        }
    }

    public void setFileRoot(String path) {
        this.fileRoot = path;
    }

    protected String getFileRoot() {
        return this.fileRoot;
    }

    public void setTestRoot(String path) {
        this.testRoot = path;
    }

    protected String getTestRoot(ShowcaseSpecifier showcase) {
        String result = this.testRoot != null ? this.testRoot : (String)this.getOptionValue(Utils.getCurrentMethodName(), showcase);
        return this.getPathRelativeToFileRoot(result);
    }

    protected int getSgwtRunnerClassSpan() {
        return (Integer)this.getOptionValue(Utils.getCurrentMethodName());
    }

    protected String getFatalBatchError() {
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    protected Double getNightlyBuildOffset() {
        return (Double)this.getOptionValue(Utils.getCurrentMethodName());
    }

    protected String getBuildDate() {
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    protected int getJenkinsMaximumLifespan() {
        return (Integer)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public String getBatchRunDS() {
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public String getTestResultDS() {
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public void setMailSubject(String subject) {
        this.mailSubject = subject;
    }

    protected String getMailSubject() {
        if (this.mailSubject != null) {
            return this.mailSubject;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName(), null, !this.useDefaultMailSubject(), null);
    }

    public void setMailTemplate(String template) {
        this.mailTemplate = template;
    }

    protected String getMailTemplate() {
        String result = this.mailTemplate != null ? this.mailTemplate : (String)this.getOptionValue(Utils.getCurrentMethodName());
        return this.getPathRelativeToFileRoot(result);
    }

    public void setSaveMessages() {
        this.saveMessages = true;
    }

    protected boolean shouldSaveMessages() {
        return this.saveMessages;
    }

    public void setServerLogMode(String mode) {
        this.serverLogMode = mode;
    }

    protected boolean shouldSaveServerLogs() {
        return !"none".equalsIgnoreCase(this.getServerLogMode());
    }

    protected String getServerLogMode() {
        if (this.serverLogMode != null) {
            return this.serverLogMode;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public void setServerLogOutputMethod(String out) {
        this.serverLogOutputMethod = out;
    }

    protected boolean shouldEmailServerLogs() {
        String out = this.getServerLogOutputMethod();
        return "email".equalsIgnoreCase(out) || "both".equalsIgnoreCase(out);
    }

    public boolean shouldCommitServerLogs() {
        String out = this.getServerLogOutputMethod();
        return "datasource".equalsIgnoreCase(out) || "both".equalsIgnoreCase(out);
    }

    protected String getServerLogOutputMethod() {
        if (this.serverLogOutputMethod != null) {
            return this.serverLogOutputMethod;
        }
        return (String)this.getOptionValue(Utils.getCurrentMethodName());
    }

    public void setCaptureScreenshot() {
        this.captureScreenshot = true;
    }

    protected boolean shouldCaptureScreenshot() {
        return this.captureScreenshot;
    }

    public void setHistoryDepth(int historyDepth) {
        this.historyDepth = historyDepth;
    }

    protected int getHistoryDepth() {
        return this.historyDepth;
    }

    protected boolean canParseLog() {
        return true;
    }

    protected boolean useDefaultMailSubject() {
        return false;
    }

    protected Object getOptionValue(String methodName) {
        return this.getOptionValue(methodName, null);
    }

    protected Object getOptionValue(String methodName, ShowcaseSpecifier showcase) {
        return this.getOptionValue(methodName, showcase, false, null);
    }

    protected Object getOptionValue(String methodName, ShowcaseSpecifier showcase, Object alternativeValue) {
        return this.getOptionValue(methodName, showcase, showcase == null, alternativeValue);
    }

    protected Object getOptionValue(String methodName, ShowcaseSpecifier showcase, boolean skipDefault, Object alternativeValue) {
        Config config = Config.getGlobal();
        for (int i = 0; i < this.properties.length; ++i) {
            String result;
            String result2;
            PropertyRecord property = this.properties[i];
            if (!methodName.equals("get" + property.propertyName)) continue;
            boolean isDouble = property.classicDefaultValue instanceof Double;
            boolean isInteger = property.classicDefaultValue instanceof Integer;
            String configName = property.configName;
            if (configName != null && (result2 = config.getPath(configName)) != null) {
                return isInteger ? Integer.valueOf(Integer.parseInt(result2)) : ISCFile.replaceUnresolvedContainer((String)result2);
            }
            String envVariable = property.envVariable;
            if (envVariable != null && (result = System.getenv(envVariable)) != null) {
                if (isDouble) {
                    return Double.parseDouble(result);
                }
                if (isInteger) {
                    return Integer.parseInt(result);
                }
                return result;
            }
            if (skipDefault) {
                return alternativeValue;
            }
            return property.getDefaultValue(showcase);
        }
        return null;
    }

    protected void installOptionValues(CommandLine line) {
        for (int i = 0; i < this.properties.length; ++i) {
            PropertyRecord property = this.properties[i];
            if (property.optionName == null) continue;
            String defaultOptionName = property.optionName;
            String negatedOptionName = "n" + property.optionName;
            try {
                Object defVal = property.classicDefaultValue;
                boolean isInteger = defVal instanceof Integer;
                boolean isBoolean = defVal instanceof Boolean;
                if (!line.hasOption(defaultOptionName) && (!line.hasOption(negatedOptionName) || !isBoolean)) continue;
                Class argClass = defVal != null ? defVal.getClass() : String.class;
                Method method = Reflection.findMethod(TestRunnerLauncher.class, (String)("set" + property.propertyName), (Class[])new Class[]{argClass});
                if (method != null) {
                    int nMethodParams = method.getParameterTypes().length;
                    if (nMethodParams == 1) {
                        String value = line.getOptionValue(defaultOptionName);
                        if (isInteger) {
                            method.invoke((Object)this, Integer.parseInt(value));
                            continue;
                        }
                        if (isBoolean) {
                            method.invoke((Object)this, line.hasOption(defaultOptionName));
                            continue;
                        }
                        method.invoke((Object)this, value);
                        continue;
                    }
                    if (nMethodParams == 0) {
                        method.invoke((Object)this, new Object[0]);
                        continue;
                    }
                    throw new Exception("Found setter set" + property.propertyName + "() but it has " + "too many arguments (" + nMethodParams + ")");
                }
                throw new Exception("Couldn't find any setter set" + property.propertyName + "()");
            }
            catch (Exception e) {
                log.error((Object)("Exception hit trying to apply option " + defaultOptionName + ": " + e));
                return;
            }
        }
    }

    protected PropertyRecord getPropertyRecord(String propertyName) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (!propertyName.equals(this.properties[i].propertyName)) continue;
            return this.properties[i];
        }
        return null;
    }

    protected static void addOptions(Options options) {
        options.addOption("fr", "file-root", true, "Sets absolute path to file root directory; defaults to current working directory");
        options.addOption("tr", "test-root", true, "Sets selenium test script root directory");
        options.addOption("sr", "server-root", true, "Sets root directory relative to web server base URL for selenium commands");
        options.addOption("st", "selenium-timeout", true, "Sets selenium timeout in seconds");
        options.addOption("ot", "original-timeout", true, "Sets original test suite timeout in seconds");
        options.addOption("ht", "http-target", true, "Hostname/IP address of the HTTP target webserver for Selenium open commands");
        options.addOption("hp", "http-port", true, "Specifies the HTTP port to use on the target for Selenium open commands");
        options.addOption("f", "files", true, "Test scripts to run, specified as quoted list of filenames or relative filename paths (from test root), separated by whitespace");
    }

    protected static Options filterAndAddOptions(Options options, Class interfaceClass) {
        TestRunnerConfiguration disposableConfig = new TestRunnerConfiguration();
        Collection original = options.getOptions();
        Options filtered = new Options();
        Method[] methods = interfaceClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes;
            boolean optionPair;
            PropertyRecord property = null;
            String propertyName = methods[i].getName().substring(3);
            for (int j = 0; j < disposableConfig.properties.length; ++j) {
                property = disposableConfig.properties[j];
                if (propertyName.equals(property.propertyName)) break;
            }
            boolean bl = optionPair = (paramTypes = methods[i].getParameterTypes()).length > 0 && paramTypes[0] == Boolean.TYPE;
            if (property == null) continue;
            for (Option option : original) {
                String defaultOptionName = property.optionName;
                String negatedOptionName = "n" + property.optionName;
                if (!option.getOpt().equals(defaultOptionName) && (!option.getOpt().equals(negatedOptionName) || !optionPair)) continue;
                filtered.addOption(option);
            }
        }
        filtered.addOption(options.getOption("h"));
        return filtered;
    }

    public class SuiteSpecificPropertyRecord
    extends PropertyRecord {
        String showcaseMethod;

        SuiteSpecificPropertyRecord(String propertyName, String envVariable, String configName, String optionName, String showcaseMethod) {
            super(propertyName, envVariable, configName, optionName);
            this.showcaseMethod = showcaseMethod;
        }

        @Override
        Object getDefaultValue(ShowcaseSpecifier showcase) {
            try {
                Method method = showcase.getClass().getDeclaredMethod("get" + this.showcaseMethod, new Class[0]);
                return method.invoke((Object)showcase, new Object[0]);
            }
            catch (Exception e) {
                log.error((Object)("Exception hit trying to call ShowcaseSpecifier method " + this.showcaseMethod + ": " + e));
                return null;
            }
        }
    }

    public class PropertyRecord {
        String propertyName;
        String envVariable;
        String configName;
        String optionName;
        Object classicDefaultValue;
        Object showcaseDefaultValue;
        Object standAloneDefaultValue;

        PropertyRecord(String propertyName, String envVariable, String configName, String optionName) {
            this.propertyName = propertyName;
            this.envVariable = envVariable;
            this.configName = configName;
            this.optionName = optionName;
        }

        PropertyRecord(String propertyName, String envVariable, String configName, String optionName, Object defaultValue) {
            this(propertyName, envVariable, configName, optionName);
            this.classicDefaultValue = defaultValue;
        }

        PropertyRecord(String propertyName, String envVariable, String configName, String optionName, Object classicDefaultValue, Object showcaseDefaultValue) {
            this(propertyName, envVariable, configName, optionName, classicDefaultValue);
            this.showcaseDefaultValue = showcaseDefaultValue;
        }

        PropertyRecord(String propertyName, String envVariable, String configName, String optionName, Object classicDefaultValue, Object showcaseDefaultValue, Object standAloneDefaultValue) {
            this(propertyName, envVariable, configName, optionName, classicDefaultValue, showcaseDefaultValue);
            this.standAloneDefaultValue = standAloneDefaultValue;
        }

        Object getDefaultValue(ShowcaseSpecifier showcase) {
            if (this.standAloneDefaultValue != null && !TestRunnerConfiguration.this.fileRootIsDevEnv) {
                return this.standAloneDefaultValue;
            }
            return showcase != null ? this.showcaseDefaultValue : this.classicDefaultValue;
        }
    }
}

