/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.Jenkins;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.SimpleHttpResponse;
import java.util.Date;
import java.util.Map;

public class JenkinsBuild {
    private static Logger log = new Logger(JenkinsBuild.class.getName());
    protected Jenkins jenkins;
    protected String buildName;
    protected String queueURL;
    protected String buildURL;
    protected DataTypeMap buildParams;
    protected DataTypeMap opts;
    protected long startTime = -1L;
    private boolean stopOnDestroy = false;

    public JenkinsBuild(Jenkins jenkins, String buildName, Map buildParams, Map opts) {
        this.jenkins = jenkins;
        this.buildName = buildName;
        this.buildParams = new DataTypeMap(buildParams);
        this.opts = new DataTypeMap(opts);
        this.startTime = new Date().getTime();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setQueueURL(String queueURL) {
        this.queueURL = queueURL;
    }

    public void destroy() {
        if (this.stopOnDestroy) {
            try {
                this.stop();
            }
            catch (Exception e) {
                log.warn((Object)"Failed to stop", (Throwable)e);
            }
        }
    }

    public void stop() throws Exception {
        DataTypeMap buildStatus = this.buildStatus();
        String stopURL = null;
        if (buildStatus != null) {
            stopURL = buildStatus.getString((Object)"url") + "stop";
        } else {
            DataTypeMap queueStatus = this.queueStatus();
            if (queueStatus != null) {
                stopURL = this.jenkins.getBaseURL() + "/queue/cancelItem?id=" + queueStatus.getString((Object)"id");
            }
        }
        if (stopURL == null) {
            throw new Exception("Unable to derive stopURL for build: " + this.buildName);
        }
        SimpleHttpResponse httpResponse = this.jenkins.httpPostWithCrumb(stopURL, null);
        if (!httpResponse.isSuccess()) {
            throw new Exception("Unable to stop jenkins build: " + this.buildName + " at stopURL: " + stopURL + " - server responded with: " + httpResponse.getStatusCode() + ", with body: " + httpResponse.getBodyAsString());
        }
    }

    public DataTypeMap queueStatus() throws Exception {
        DataTypeMap queueStatus = this.jenkins.jsonGet(this.queueURL);
        if (queueStatus != null && queueStatus.get((Object)"executable") != null) {
            this.buildURL = queueStatus.getMap((Object)"executable").getString((Object)"url");
            log.info((Object)(this.buildName + ": buildURL has become available: " + this.buildURL));
        }
        return queueStatus;
    }

    public DataTypeMap buildStatus() throws Exception {
        if (this.buildURL == null) {
            this.queueStatus();
        }
        if (this.buildURL == null) {
            return null;
        }
        return this.jenkins.jsonGet(this.buildURL);
    }

    public DataTypeMap waitForExecutionStart() throws Exception {
        return this.waitForExecutionStart(-1L);
    }

    public DataTypeMap waitForExecutionStart(long timeout) throws Exception {
        long timeStart = new Date().getTime();
        do {
            DataTypeMap buildStatus;
            if ((buildStatus = this.buildStatus()) != null) {
                return buildStatus;
            }
            DataTypeMap queueStatus = this.queueStatus();
            if (queueStatus == null) {
                throw new Exception("Unable to fetch queueStatus at queueURL: " + this.queueURL + ".  Please read the docs for Jenkins->triggerBuild() - specifically the GOTCHA section");
            }
            if (queueStatus.getBoolean((Object)"cancelled", false)) {
                log.info((Object)(this.buildName + ": build was cancelled - terminating block on waitForExecutionStart()"));
                log.info((Object)("buildStatus:" + DataTools.prettyPrint((Object)queueStatus)));
                return DataTools.buildMap((Object[])new Object[]{"result", "CANCELLED_IN_QUEUE"});
            }
            if (queueStatus.getBoolean((Object)"stuck", false)) {
                log.info((Object)(this.buildName + ": build is stuck - terminating block on waitForExecutionStart()"));
                log.info((Object)("buildStatus:" + DataTools.prettyPrint((Object)queueStatus)));
                return DataTools.buildMap((Object[])new Object[]{"result", "STUCK_IN_QUEUE"});
            }
            Thread.sleep(2000L);
        } while (timeout == -1L || new Date().getTime() - timeStart >= timeout);
        try {
            this.stop();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to stop", (Throwable)e);
        }
        return DataTools.buildMap((Object[])new Object[]{"result", "TIMED_OUT_IN_QUEUE"});
    }

    public DataTypeMap waitForExecutionComplete() throws Exception {
        return this.waitForExecutionComplete(-1L);
    }

    public DataTypeMap waitForExecutionComplete(long timeout) throws Exception {
        long timeStart = new Date().getTime();
        this.stopOnDestroy = true;
        DataTypeMap buildStatus = this.waitForExecutionStart();
        do {
            if (buildStatus == null) {
                throw new Exception("Unable to fetch buildStatus for queueURL: " + this.queueURL + ".  Please read the docs for Jenkins->triggerBuild() - specifically the GOTCHA section");
            }
            if (buildStatus.getString((Object)"result") != null) {
                this.stopOnDestroy = false;
                return buildStatus;
            }
            Thread.sleep(10000L);
            buildStatus = this.buildStatus();
        } while (timeout == -1L || new Date().getTime() - timeStart >= timeout);
        try {
            this.stop();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to stop", (Throwable)e);
        }
        return DataTools.buildMap((Object[])new Object[]{"result", "TIMED_OUT"});
    }
}

