/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.customBinaryField;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.servlet.ISCFileItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class CustomBinaryFieldDataSource
extends BasicDataSource {
    private static final List<Map<String, Object>> DEFAULT_DATA = new ArrayList<Map<String, Object>>();

    public DSResponse executeFetch(DSRequest dsRequest) throws Exception {
        List<Map<String, Object>> list = this.getRecordsForSession(dsRequest.context.request.getSession());
        DSResponse dsResponse = new DSResponse((DataSource)this);
        LinkedList<HashMap<String, Object>> data = new LinkedList<HashMap<String, Object>>();
        for (Map<String, Object> record : list) {
            HashMap<String, Object> recordToReturn = new HashMap<String, Object>(record);
            recordToReturn.remove("file");
            data.add(recordToReturn);
        }
        dsResponse.setData(data);
        return dsResponse;
    }

    public DSResponse execute(DSRequest dsRequest) throws Exception {
        DSResponse dsResponse = new DSResponse((DataSource)this);
        Map criteria = dsRequest.getCriteria();
        Object recordId = criteria.get("id");
        String operationType = dsRequest.getOperationType();
        HttpSession httpSession = dsRequest.context.request.getSession();
        if (operationType.equals("viewFile") || operationType.equals("downloadFile")) {
            criteria.putAll(this.getRecord(recordId, httpSession));
            dsResponse.setData((Object)criteria);
        } else if (operationType.equals("fetch")) {
            dsResponse = this.executeFetch(dsRequest);
        } else if (operationType.equals("add")) {
            dsResponse = this.executeAdd(dsRequest);
        } else if (operationType.equals("update")) {
            dsResponse = this.executeUpdate(dsRequest);
        }
        return dsResponse;
    }

    public DSResponse executeAdd(DSRequest dsRequest) throws Exception {
        ISCFileItem fileItem = dsRequest.getUploadedFile("file");
        byte[] data = fileItem.get();
        DSResponse dsResponse = new DSResponse((DataSource)this);
        Map newValues = dsRequest.getValues();
        newValues.put("file", data);
        newValues.put("file_date_created", new Date());
        newValues.put("file_filesize", data.length);
        List<Map<String, Object>> list = this.getRecordsForSession(dsRequest.context.request.getSession());
        list.add(newValues);
        dsResponse.setData((Object)newValues);
        return dsResponse;
    }

    public DSResponse executeUpdate(DSRequest dsRequest) throws Exception {
        ISCFileItem fileItem = dsRequest.getUploadedFile("file");
        byte[] data = fileItem.get();
        DSResponse dsResponse = new DSResponse((DataSource)this);
        Map criteria = dsRequest.getCriteria();
        Map<String, Object> record = this.getRecord(criteria.get("id"), dsRequest.context.request.getSession());
        if (record != null) {
            record.putAll(dsRequest.getValues());
            record.put("file", data);
            record.put("file_filesize", data.length);
            record.put("file_date_created", new Date());
            dsResponse.setData(record);
        } else {
            dsResponse.setStatus(-1);
        }
        return dsResponse;
    }

    private Map<String, Object> getRecord(Object id, HttpSession httpSession) {
        List<Map<String, Object>> records = this.getRecordsForSession(httpSession);
        String idAsString = String.valueOf(id);
        for (Map<String, Object> record : records) {
            String recordId = String.valueOf(record.get("id"));
            if (!recordId.equalsIgnoreCase(idAsString)) continue;
            return record;
        }
        return null;
    }

    private List<Map<String, Object>> getRecordsForSession(HttpSession session) {
        LinkedList<Map<String, Object>> list = (LinkedList<Map<String, Object>>)session.getAttribute("CustomBinaryFieldDataSource.list");
        if (list == null) {
            list = new LinkedList<Map<String, Object>>();
            list.addAll(new LinkedList<Map<String, Object>>(DEFAULT_DATA));
            session.setAttribute("CustomBinaryFieldDataSource.list", list);
        }
        return list;
    }

    static {
        HashMap<String, Object> record1 = new HashMap<String, Object>();
        String desc1 = "Australian Made parchment paper offering archival life and laser compatibility in a range of six pastel shades and white. Centurion is manufactured from woodfree pulp under the strictest of conditions to comply with the interim standard for permanent pape";
        record1.put("id", 1);
        record1.put("file", desc1.getBytes());
        record1.put("file_filename", "Copy_laser_Paper_Parchment_A4_110GSM_Buff.txt");
        record1.put("file_filesize", desc1.getBytes().length);
        record1.put("file_date_created", new Date());
        record1.put("description", desc1);
        DEFAULT_DATA.add(record1);
        HashMap<String, Object> record2 = new HashMap<String, Object>();
        String desc2 = "Makes copies of meetings in seconds. Features a rotating Mylar writing surface, uses standard thermal fax paper, includes an accessory tray that holds markers etc moves easily on durable castors, push button operation. Copying area is 830mm(h)x1300mm(w).";
        record2.put("id", 2);
        record2.put("file", desc2.getBytes());
        record2.put("file_filename", "Whiteboard_Quartet_Electronic.txt");
        record2.put("file_filesize", desc2.getBytes().length);
        record2.put("file_date_created", new Date());
        record2.put("description", desc2);
        DEFAULT_DATA.add(record2);
        HashMap<String, Object> record3 = new HashMap<String, Object>();
        String desc3 = "The highest degree of writing comfort. PhD reduces gripping pressure by increasing the hand-to-grip surface with a large cushioned triangular grip. This provides exceptional control and balance, as well as less hand fatigue. Refillable and retractable. Al";
        record3.put("id", 3);
        record3.put("file", desc3.getBytes());
        record3.put("file_filename", "Pens_Sanford_Phd_Ballpoint_Black_Barrel.txt");
        record3.put("file_filesize", desc3.getBytes().length);
        record3.put("file_date_created", new Date());
        record3.put("description", desc3);
        DEFAULT_DATA.add(record3);
    }
}

