/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.Utils;
import com.isomorphic.log.Logger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;

public class SmartGWTSampleIdMap {
    private static Logger log = new Logger(SmartGWTSampleIdMap.class.getName());
    private Map<String, String> smartClientMap;
    private Map<String, String[]> sgwtMap;

    public SmartGWTSampleIdMap(ShowcaseSpecifier.ShowcaseSpecifierType type) {
        switch (type) {
            case ssSmartGwtEE: {
                this.installMapFromFile("eeExamplesMapping");
                break;
            }
            case ssSmartGwtLGPL: {
                this.installMapFromFile("scExamplesMapping");
            }
        }
    }

    public String getSmartClientIdFromSGWTId(String sgwtId) {
        String[] bindings = this.sgwtMap.get(sgwtId);
        return null != bindings ? bindings[0] : null;
    }

    public String getSampleNameFromSGWTId(String sgwtId) {
        String[] bindings = this.sgwtMap.get(sgwtId);
        return null != bindings ? bindings[1] : null;
    }

    public boolean isSmartClientIdInMapRange(String smartClientId) {
        return this.smartClientMap.containsKey(smartClientId);
    }

    public String getSGWTIdFromSmartClientId(String smartClientId) {
        return this.smartClientMap.get(smartClientId);
    }

    private void installMapFromFile(String mapName) {
        TestRunnerConfiguration config = TestRunner.getConfiguration();
        String filePath = config.getSmartGWTExampleMapFile();
        this.smartClientMap = new HashMap<String, String>();
        this.sgwtMap = new HashMap<String, String[]>();
        int nBindings = 0;
        try {
            String[] parts;
            String nextLine;
            FileReader stream = new FileReader(filePath);
            BufferedReader br = new BufferedReader(stream);
            while ((nextLine = br.readLine()) != null && !Utils.matchRegExp("<#assign\\s+" + mapName + "\\s*=\\s*\\{", nextLine)) {
            }
            while ((nextLine = br.readLine()) != null && (parts = nextLine.split("['\"]")).length >= 6) {
                String lgplId = parts[3];
                String[] bindings = new String[]{parts[1], parts[5]};
                this.smartClientMap.put(parts[1], lgplId);
                this.sgwtMap.put(lgplId, bindings);
                ++nBindings;
            }
            log.info((Object)("built " + this.sgwtMap.size() + " bindings for map " + mapName));
        }
        catch (Exception e) {
            log.warn((Object)("unable to create an id map for table " + mapName), (Throwable)e);
            log.warn((Object)"selenium tests may be skipped without this map");
        }
        if (nBindings == 0) {
            throw new RuntimeException("no bindings found for SC=>SGWT map " + mapName + "; " + "if path " + filePath + " is correct, then the file has likely been corrupted");
        }
    }
}

