/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.log.Logger;
import com.isomorphic.scripting.AbstractScript;
import com.isomorphic.scripting.ScriptExceptionItem;
import com.isomorphic.util.DataTools;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptXBase
extends AbstractScript {
    private static Logger log = new Logger(ScriptXBase.class.getName());
    protected ScriptEngine engine;
    protected StringWriter stdout;
    protected StringWriter stderr;
    protected ScriptContext scriptContext;
    protected static final ThreadLocal<List> scriptEvalStackContainer = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map eval(DataTypeMap data) throws Exception {
        this.configure(data);
        this.init();
        this.prepareContext();
        ArrayList<Integer> scriptEvalStack = scriptEvalStackContainer.get();
        if (scriptEvalStack == null) {
            scriptEvalStack = new ArrayList<Integer>();
            scriptEvalStackContainer.set(scriptEvalStack);
        }
        scriptEvalStack.add(0);
        try {
            Map map = this.evalScript();
            return map;
        }
        finally {
            scriptEvalStack.remove(scriptEvalStack.size() - 1);
        }
    }

    protected void init() throws Exception {
        ScriptEngineManager factory = null;
        try {
            factory = new ScriptEngineManager();
        }
        catch (Throwable e) {
            log.error((Object)"Unable to init scripting - make sure you are running JDK 1.6+?", e);
            throw new Exception("Unable to init scripting.  Make sure you're running JDK 1.6+");
        }
        log.info("Initializing scripting engine: " + this.engineName);
        try {
            this.engine = factory.getEngineByName(this.engineName);
        }
        catch (Error e) {
            log.error((Object)("Unable to load engine: " + this.engineName), e);
            throw new Exception("Unable to load engine by name: " + this.engineName + ".  Please make sure you have the required JARs for this engine in WEB-INF/lib");
        }
        if (this.engine == null) {
            try {
                this.engine = factory.getEngineByExtension(this.engineName);
            }
            catch (Error e) {
                log.error((Object)("Unable to load engine: " + this.engineName), e);
                throw new Exception("Unable to load engine by extension: " + this.engineName + ".  Please make sure you have the required JARs for this engine in WEB-INF/lib");
            }
        }
        if (this.engine == null) {
            throw new Exception("Unable to load engine by name or extension: " + this.engineName + ".  Please make sure you have the required JARs for this engine in WEB-INF/lib");
        }
    }

    protected void prepareContext() throws Exception {
        this.scriptContext = this.engine.getContext();
        if (this.bindings != null) {
            for (String key : this.bindings.keySet()) {
                Object value = this.bindings.get(key);
                this.scriptContext.setAttribute(key, value, 100);
            }
        }
        if (this.captureOutput) {
            this.stdout = new StringWriter();
            this.stderr = new StringWriter();
            this.scriptContext.setWriter(this.stdout);
            this.scriptContext.setErrorWriter(this.stderr);
        }
        this.engine.setContext(this.scriptContext);
    }

    protected ScriptExceptionItem getScriptExceptionItem(ScriptExceptionItem.Type type, int line, String message, int column) {
        int footerLines;
        int importDirectivesLines = (this.importDirectives == null ? 0 : DataTools.countCompleteLines(this.importDirectives)) + 1;
        int headerLines = (this.header == null ? 0 : DataTools.countCompleteLines(this.header)) + 1;
        int scriptLines = (this.script == null ? 0 : DataTools.countCompleteLines(this.script)) + 1;
        int n = footerLines = this.footer == null ? 0 : DataTools.countCompleteLines(this.footer);
        if (line < 0) {
            return new ScriptExceptionItem(type, "Unknown Source", line, column, message);
        }
        if (line <= importDirectivesLines) {
            return new ScriptExceptionItem(type, "importDirectives", line, column, message);
        }
        if (line <= importDirectivesLines + headerLines) {
            return new ScriptExceptionItem(type, this.headerFilename, line - importDirectivesLines, column, message);
        }
        if (line <= importDirectivesLines + headerLines + scriptLines) {
            int scriptOffset = -1;
            int scriptLine = line - importDirectivesLines - headerLines;
            int sourceLine = -1;
            if (this.scriptSource != null) {
                try {
                    scriptOffset = this.scriptSource.getScriptSourceOffset(this.scriptSourceContext);
                    if (scriptOffset > 0) {
                        sourceLine = scriptLine + scriptOffset;
                    }
                }
                catch (Exception soe) {
                    log.warn((Object)"Error obtaining script offset: ", soe);
                }
            }
            return new ScriptExceptionItem(type, this.scriptSourceFilename == null ? "script" : this.scriptSourceFilename, scriptLine, sourceLine, column, message);
        }
        return new ScriptExceptionItem(type, this.footerFilename, line - importDirectivesLines - headerLines - scriptLines, column, message);
    }

    protected Exception fillInStackTrace(Exception e) {
        StackTraceElement element;
        int i;
        ScriptExceptionItem sei = null;
        StackTraceElement previousElement = null;
        ArrayList<StackTraceElement> filledStackTrace = new ArrayList<StackTraceElement>();
        boolean alreadyFilledStack = false;
        List scriptEvalStack = scriptEvalStackContainer.get();
        Integer scriptEvalStackIndex = (Integer)scriptEvalStack.get(0);
        StackTraceElement[] stackTraceArray = e.getStackTrace();
        if (scriptEvalStackIndex > 0) {
            for (i = 0; i < scriptEvalStackIndex; ++i) {
                element = stackTraceArray[i];
                filledStackTrace.add(element);
                previousElement = element;
            }
        }
        for (i = scriptEvalStackIndex.intValue(); i < stackTraceArray.length; ++i) {
            element = stackTraceArray[i];
            if (("com.isomorphic.scripting.ScriptXBase".equals(element.getClassName()) || this.getClass().getName().equals(element.getClassName())) && "evalScript".equals(element.getMethodName()) && !alreadyFilledStack) {
                if (e instanceof ScriptException) {
                    ScriptException se = (ScriptException)e;
                    sei = this.getScriptExceptionItem(ScriptExceptionItem.Type.RUNTIME, se.getLineNumber(), se.getMessage(), se.getColumnNumber());
                } else {
                    sei = this.getScriptExceptionItem(ScriptExceptionItem.Type.RUNTIME, previousElement != null ? previousElement.getLineNumber() : -1, "", -1);
                }
                int sourceLineNumber = sei.getScriptSourceLineNumber();
                if (sourceLineNumber < 0) {
                    filledStackTrace.add(new StackTraceElement(this.scriptSourceName, "", sei.getSource(), sei.getLineNumber()));
                } else {
                    filledStackTrace.add(new StackTraceElement(this.scriptSourceName, "scriptLine:" + sei.getLineNumber(), sei.getSource(), sourceLineNumber));
                }
                alreadyFilledStack = true;
                scriptEvalStackIndex = i + 2;
                scriptEvalStack.set(0, scriptEvalStackIndex);
            }
            filledStackTrace.add(element);
            previousElement = element;
        }
        StackTraceElement[] filledStackTraceArray = new StackTraceElement[filledStackTrace.size()];
        for (int j = 0; j < filledStackTrace.size(); ++j) {
            filledStackTraceArray[j] = (StackTraceElement)filledStackTrace.get(j);
        }
        e.setStackTrace(filledStackTraceArray);
        return e;
    }

    @Override
    protected Map evalScript() throws Exception {
        String evalScript = null;
        Object evalResult = null;
        try {
            evalScript = (this.importDirectives == null ? "" : this.importDirectives) + "\n" + (this.header == null ? "" : this.header) + "\n" + (this.script == null ? "" : this.script) + "\n" + (this.footer == null ? "" : this.footer);
            if (log.isDebugEnabled()) {
                log.debug("Evaluating assembled script:\n" + evalScript);
            } else {
                log.info("Evaluating script:\n" + this.script);
            }
            evalResult = this.engine.eval(evalScript);
        }
        catch (Exception e) {
            throw this.fillInStackTrace(e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("evalResult", evalResult);
        if (this.captureOutput) {
            result.put("stdout", this.stdout.toString());
            result.put("stderr", this.stderr.toString());
        }
        return result;
    }
}

