/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.StreamingResponseIterator;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDI;
import com.isomorphic.sql.DBType;
import com.isomorphic.sql.SQLClauseType;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.sql.SQLTransform;
import com.isomorphic.sql.SQLWhereClause;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.LocaleMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;

public abstract class SQLDriver
extends Base {
    private static Logger log = new Logger(SQLDriver.class.getName());
    protected static Config config = Config.getGlobal();
    protected String dbName = null;
    protected DBType dbType = null;
    protected DataTypeMap metaData = null;
    protected String defaultSchemaName = null;
    protected SQLTable table = null;
    public Connection dbConnection = null;
    protected static ConcurrentHashMap<String, Config> globalSqlConfig = new ConcurrentHashMap();
    protected Config sqlConfig = null;
    protected Config driverConfig = null;
    protected Config sandboxConfig = null;
    protected Config databaseConfig = null;
    protected boolean quoteColumnNames;
    protected boolean useColumnLabelInMetadata;
    protected boolean useUTCDateTimes;
    protected static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile(Pattern.quote("'"));
    protected static final String SINGLE_QUOTE_ESCAPE = Matcher.quoteReplacement("''");
    protected static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile(Pattern.quote("\""));
    protected static final String DOUBLE_QUOTE_ESCAPE = Matcher.quoteReplacement("\"\"");
    protected static final Pattern PERCENT_PATTERN = Pattern.compile(Pattern.quote("%"));
    protected static final String PERCENT_ESCAPE = Matcher.quoteReplacement("\\%");
    protected static final Pattern UNDERSCORE_PATTERN = Pattern.compile(Pattern.quote("_"));
    protected static final String UNDERSCORE_ESCAPE = Matcher.quoteReplacement("\\_");
    protected static final Pattern BACKSLASH_PATTERN = Pattern.compile(Pattern.quote("\\"));
    protected static final String BACKSLASH_ESCAPE = Matcher.quoteReplacement("\\\\");
    protected static final String BACKSLASH_ESCAPE_DOUBLE = Matcher.quoteReplacement("\\\\\\\\");
    protected Matcher matcher = SINGLE_QUOTE_PATTERN.matcher("");
    protected static Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    protected SQLDataSource.SequenceMode lastSequenceMode;
    public static final int NO_CONVERSION = 0;
    public static final int TO_LOWERCASE = 1;
    public static final int TO_UPPERCASE = 2;
    private static final Map EMPTY_REMAP = new HashMap();
    private static final String TIMING_LOG_UNPAGED_FETCH = "Unpaged fetch";
    private static final String TIMING_LOG_GET_CONNECTION = "get connection";
    private static final String TIMING_LOG_QUERY = "query";
    private static final String TIMING_LOG_SQLTRANSFORM = "SQLTransform";
    protected SimpleDateFormat logicalDateFormatter;
    protected SimpleDateFormat logicalTimeFormatter;
    protected SimpleDateFormat utcDateTimeFormatter;
    protected SimpleDateFormat localDateTimeFormatter;
    protected SimpleDateFormat utcDateTimeMsFormatter;
    protected SimpleDateFormat localDateTimeMsFormatter;
    protected boolean useDistinctForGroupBy = true;
    protected Map jdbcPKs = new HashMap();
    private static String snapshotFileNamePrefix = IOUtil.threadSafeTmpFileName((String)"/tmp/db_snapshot_sql");

    public SQLDataSource.SequenceMode getLastSequenceMode() {
        return this.lastSequenceMode;
    }

    public void setLastSequenceMode(SQLDataSource.SequenceMode sequenceMode) {
        this.lastSequenceMode = sequenceMode;
    }

    protected void initDateFormatters() throws Exception {
        String dateTimeFormat = this.sqlConfig.getString((Object)"defaultDateTimeFormat", "yyyy-MM-dd HH:mm:ss");
        String dateTimeMsFormat = this.sqlConfig.getString((Object)"defaultDateTimeFormatWithMilliseconds", "yyyy-MM-dd HH:mm:ss.SSS");
        String dateFormat = this.sqlConfig.getString((Object)"defaultDateFormat", "yyyy-MM-dd");
        String timeFormat = this.sqlConfig.getString((Object)"defaultTimeFormat", dateTimeFormat);
        this.utcDateTimeFormatter = new SimpleDateFormat(dateTimeFormat);
        this.utcDateTimeFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.localDateTimeFormatter = new SimpleDateFormat(dateTimeFormat);
        this.utcDateTimeMsFormatter = new SimpleDateFormat(dateTimeMsFormat);
        this.utcDateTimeMsFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.localDateTimeMsFormatter = new SimpleDateFormat(dateTimeMsFormat);
        this.logicalDateFormatter = new SimpleDateFormat(dateFormat);
        this.logicalTimeFormatter = new SimpleDateFormat(timeFormat);
    }

    protected SimpleDateFormat getLocalDateTimeFormatter() {
        return this.localDateTimeFormatter;
    }

    protected SimpleDateFormat getUTCDateTimeFormatter() {
        return this.utcDateTimeFormatter;
    }

    protected SimpleDateFormat getLocalDateTimeMsFormatter() {
        return this.localDateTimeMsFormatter;
    }

    protected SimpleDateFormat getUTCDateTimeMsFormatter() {
        return this.utcDateTimeMsFormatter;
    }

    protected SimpleDateFormat getLogicalDateFormatter() {
        return this.logicalDateFormatter;
    }

    protected SimpleDateFormat getLogicalTimeFormatter() {
        return this.logicalTimeFormatter;
    }

    public String openQuote() {
        return "\"";
    }

    public String closeQuote() {
        return "\"";
    }

    public String getQualifiedSchemaSeparator() {
        return ".";
    }

    public String sequencePrefix() {
        return config.getString((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".sequence.name.prefix"), "");
    }

    public String sequenceSuffix() {
        return config.getString((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".sequence.name.suffix"), "");
    }

    public int maxSequenceNameLength() {
        return config.getInt((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".sequence.name.maxLength"), -1);
    }

    public static SQLDriver instance() throws Exception {
        return SQLDriver.instance(config.getString((Object)"sql.defaultDatabase"));
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return SQLDriver.instance(dbName, null);
    }

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        DBType dbType = (DBType)((Object)SQLDriver.getSqlConfig(dbName).get((Object)"_dbType"));
        Class[] argTypes = new Class[]{String.class, SQLTable.class};
        Object[] argValues = new Object[]{dbName, table};
        return (SQLDriver)((Object)Reflection.instantiateClass((String)dbType.getImplementer(), (Class[])argTypes, (Object[])argValues));
    }

    public SQLDriver(String dbName, SQLTable table) throws Exception {
        this.dbName = dbName;
        this.table = table;
        this.sqlConfig = SQLDriver.getSqlConfig(dbName);
        this.dbType = (DBType)((Object)this.sqlConfig.get((Object)"_dbType"));
        this.metaData = this.sqlConfig.getMap((Object)"_metaData");
        this.driverConfig = this.sqlConfig.getSubtree("driver");
        this.sandboxConfig = this.sqlConfig.getSubtree("sandbox");
        this.databaseConfig = this.sqlConfig.getSubtree("database");
        this.defaultSchemaName = this.driverConfig.getString((Object)"databaseName");
        this.quoteColumnNames = this.sqlConfig.getBoolean((Object)"quoteColumnNames", false);
        this.useColumnLabelInMetadata = this.sqlConfig.getBoolean((Object)"useColumnLabelInMetadata", false);
        this.useUTCDateTimes = this.sqlConfig.getBoolean((Object)"useUTCDateTimes", false);
        this.initDateFormatters();
    }

    public static synchronized void purgeSqlConfig(String dbName) {
        globalSqlConfig.remove(dbName);
    }

    public static synchronized void purgeSqlConfig() {
        globalSqlConfig.clear();
    }

    public static synchronized boolean isConfigured(String dbName) {
        Config sqlConfig = globalSqlConfig.get(dbName);
        return sqlConfig != null;
    }

    public static synchronized void configure(String dbName, Config namedSqlConfig) throws Exception {
        Config sqlConfig = SQLDriver.initSqlConfig(dbName, namedSqlConfig);
        globalSqlConfig.put(dbName, sqlConfig);
    }

    public static synchronized Config getSqlConfig(String dbName) throws Exception {
        if (!SQLDriver.isConfigured(dbName)) {
            SQLDriver.configure(dbName, config.getSubtree("sql." + dbName));
        }
        return globalSqlConfig.get(dbName);
    }

    public Config getSqlConfig() {
        return this.sqlConfig;
    }

    public static Config initSqlConfig(String dbName) throws Exception {
        return SQLDriver.initSqlConfig(dbName, config.getSubtree("sql." + dbName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config initSqlConfig(String dbName, Config namedSqlConfig) throws Exception {
        DBType dbType;
        Connection conn;
        Config sqlConfig;
        String dbTypeString;
        block69: {
            if (namedSqlConfig == null) {
                namedSqlConfig = new Config();
            }
            dbTypeString = namedSqlConfig.getString((Object)"database.type");
            sqlConfig = (Config)DataTools.cascadeMaps((Map[])new Map[]{config.getSubtree("sql.default"), dbTypeString == null ? null : config.getSubtree("sql." + dbTypeString), namedSqlConfig, new Config()});
            String interfaceType = sqlConfig.getString((Object)"interface.type");
            if (interfaceType == null) {
                if (sqlConfig.getString((Object)"driver.driverName") != null) {
                    interfaceType = "driverManager";
                } else if (sqlConfig.getString((Object)"driver") != null) {
                    interfaceType = "datasource";
                } else {
                    interfaceType = "jndi";
                    log.info((Object)("No explicit configuration for db: " + dbName + " in server.properties - will look for a Connection object at " + dbName + " or java:comp/env/" + dbName + "."));
                    sqlConfig.put((Object)"driver.name", (Object)dbName);
                }
                log.debug((Object)(dbName + ": Auto-derived interface.type: " + interfaceType));
            }
            interfaceType = interfaceType.toLowerCase();
            sqlConfig.put((Object)"interface.type", (Object)interfaceType);
            Config driverConfig = sqlConfig.getSubtree("driver");
            conn = null;
            DataSource ds = null;
            String jdbcURL = null;
            Boolean credentialsInURL = null;
            if ("datasource".equals(interfaceType)) {
                String dsImplementer = sqlConfig.getString((Object)"driver");
                if (dsImplementer == null) {
                    throw new Exception(dbName + ": Missing driver name for interface.type: datasource - unable to proceed");
                }
                log.debug((Object)(dbName + ": Initializing SQL config using interface.type: datasource with driver: " + dsImplementer));
                ds = (DataSource)Reflection.newInstance((String)dsImplementer, (Object[])new Object[0]);
                try {
                    DataTools.setProperties((Map)driverConfig, (Object)ds);
                }
                catch (Exception e) {
                    log.warn((Object)(dbName + ": Exception trying to set connection properties"), (Throwable)e);
                }
                if (ds == null) {
                    throw new Exception(dbName + ": Unable to instantiate JDBC DataSource for using specified driver: " + dsImplementer);
                }
                sqlConfig.put((Object)"_ds", (Object)ds);
                try {
                    conn = ds.getConnection();
                }
                catch (SQLException se) {
                    log.warn((Object)(dbName + ": Unable to obtain initial connection: " + se.getMessage()));
                }
            } else if ("drivermanager".equals(interfaceType)) {
                jdbcURL = driverConfig.getString((Object)"url");
                Boolean credentialsSetting = sqlConfig.getBoolean((Object)"interface.credentialsInURL");
                credentialsInURL = new Boolean(credentialsSetting == null || credentialsSetting != false);
                String driverName = driverConfig.getString((Object)"driverName", dbTypeString);
                if (driverName == null) {
                    throw new Exception(dbName + ": Unable to determine driverName");
                }
                if (jdbcURL == null || jdbcURL.length() == 0) {
                    jdbcURL = "jdbc:" + driverName + "://" + driverConfig.getString((Object)"serverName") + ":" + driverConfig.get((Object)"portNumber") + "/" + driverConfig.get((Object)"databaseName") + (credentialsInURL != false ? "?user=" + driverConfig.get((Object)"user") + "&password=" + driverConfig.get((Object)"password") : "");
                }
                Class driver = null;
                String dmImplementer = sqlConfig.getString((Object)"driver");
                if (dmImplementer == null) {
                    throw new Exception(dbName + ": Missing driver name for interface.type: driverManager - unable to proceed");
                }
                log.debug((Object)(dbName + ": Initializing SQL config usint interface.type: driverManager with driver: " + dmImplementer));
                driver = Reflection.classForName((String)dmImplementer);
                if (driver == null) {
                    throw new Exception(dbName + ": Unable to instantiate JDBC Driver for database " + dbName + " using specified driver: " + dmImplementer);
                }
                log.debug((Object)(dmImplementer + " lookup successful"));
                if (ISCFile.isUnresolvedContainer((String)jdbcURL)) {
                    jdbcURL = ISCFile.replaceUnresolvedContainer((String)jdbcURL) + "; shutdown=true";
                }
                sqlConfig.put((Object)"_jdbcURL", (Object)jdbcURL);
                sqlConfig.put((Object)"_credentialsInURL", (Object)credentialsInURL);
                log.debug((Object)(dbName + ": Fetching connection via jdbc url " + jdbcURL));
                try {
                    if (!credentialsInURL.booleanValue()) {
                        log.debug((Object)(dbName + ": Passing credentials getConnection separately from JDBC URL"));
                        conn = DriverManager.getConnection(jdbcURL, driverConfig.getString((Object)"user"), driverConfig.getString((Object)"password"));
                        break block69;
                    }
                    log.debug((Object)(dbName + ": Passing JDBC URL only to getConnection"));
                    conn = DriverManager.getConnection(jdbcURL);
                }
                catch (SQLException se) {
                    log.warn((Object)(dbName + ": Unable to obtain initial connection: " + se.getMessage()));
                }
            } else if ("jndi".equals(interfaceType)) {
                String jndiName = null;
                if (ds == null) {
                    String ctxName = driverConfig.getString((Object)"context", "");
                    log.debug((Object)(dbName + ": Initializing SQL config via JNDI"));
                    Context dbContext = JNDI.bindConfiguredContext((String)ctxName);
                    jndiName = driverConfig.getString((Object)"name");
                    if (jndiName == null) {
                        throw new Exception(dbName + ": Encountered null JNDI name when trying to connect a JNDI DataSource.");
                    }
                    try {
                        ds = (DataSource)dbContext.lookup(jndiName);
                    }
                    catch (NameNotFoundException dmImplementer) {
                        // empty catch block
                    }
                    if (ds == null) {
                        dbContext = JNDI.bindConfiguredContext((String)"_container_");
                        if (dbContext != null) {
                            ds = (DataSource)dbContext.lookup(jndiName);
                        } else {
                            log.warn((Object)(dbName + ": Unable to obtain initialContext via new InitialContext() - this shouldn't happen and indicates a low level error with instantiating a Context.INITIAL_CONTEXT_FACTORY - please check for overrides of this on the command line or other bootstrap logic"));
                        }
                    }
                }
                if (ds == null) {
                    throw new Exception(dbName + ": JNDI lookup for " + jndiName + " failed.");
                }
                try {
                    conn = ds.getConnection();
                }
                catch (SQLException se) {
                    log.warn((Object)(dbName + ": Unable to obtain initial connection: " + se.getMessage()));
                }
                sqlConfig.put((Object)"_ds", (Object)ds);
                sqlConfig.put((Object)"driver.serverName", (Object)"[Auto-configured JNDI resource]");
                sqlConfig.put((Object)"driver.autoConfigured", (Object)Boolean.TRUE);
            } else {
                throw new Exception(dbName + ": Unsupported interface.type: " + interfaceType + " - check your config.");
            }
        }
        DBType dBType = dbType = dbTypeString == null ? null : DBType.fromString(dbTypeString);
        if (conn != null) {
            DataTypeMap metaData = new DataTypeMap();
            try {
                DatabaseMetaData md = conn.getMetaData();
                metaData.put((Object)"databaseMajorVersion", (Object)new Integer(md.getDatabaseMajorVersion()));
                metaData.put((Object)"databaseMinorVersion", (Object)new Integer(md.getDatabaseMinorVersion()));
                metaData.put((Object)"databaseProductName", (Object)md.getDatabaseProductName());
                metaData.put((Object)"databaseProductVersion", (Object)md.getDatabaseProductVersion());
                metaData.put((Object)"driverMajorVersion", (Object)new Integer(md.getDriverMajorVersion()));
                metaData.put((Object)"driverMinorVersion", (Object)new Integer(md.getDriverMinorVersion()));
                metaData.put((Object)"driverName", (Object)md.getDriverName());
                metaData.put((Object)"driverVersion", (Object)md.getDriverVersion());
                metaData.put((Object)"JDBCMajorVersion", (Object)new Integer(md.getJDBCMajorVersion()));
                metaData.put((Object)"JDBCMinorVersion", (Object)new Integer(md.getJDBCMinorVersion()));
                log.debug((Object)(dbName + ": Database metadata: " + DataTools.prettyPrint((Object)metaData)));
                if (dbType == null) {
                    String productName = md.getDatabaseProductName();
                    String productVersion = md.getDatabaseProductVersion();
                    String driverName = md.getDriverName();
                    String driverVersion = md.getDriverVersion();
                    dbType = DBType.Generic;
                    String lcProductName = productName.toLowerCase();
                    if (lcProductName.contains("sql server")) {
                        dbType = DBType.SQLServer;
                    } else if (lcProductName.contains("oracle")) {
                        dbType = DBType.Oracle;
                    } else if (lcProductName.contains("mysql")) {
                        dbType = DBType.MySQL;
                    } else if (lcProductName.contains("postgresql")) {
                        dbType = DBType.PostgreSQL;
                    } else if (lcProductName.contains("db2")) {
                        dbType = DBType.DB2;
                    } else if (lcProductName.contains("hsqldb")) {
                        dbType = DBType.HSQLDB;
                    } else if (lcProductName.contains("cache")) {
                        dbType = DBType.Cache;
                    } else if (lcProductName.contains("informix")) {
                        dbType = DBType.Informix;
                    } else if (lcProductName.contains("firebird")) {
                        dbType = DBType.Firebird;
                    } else {
                        throw new Exception("Unable to derive dbType from string: " + productName);
                    }
                    log.info((Object)(dbName + ": Derived DB type is: " + (Object)((Object)dbType)));
                    sqlConfig.put((Object)"database.type", (Object)dbType.toString());
                }
                if (dbType == DBType.PostgreSQL) {
                    try {
                        metaData.put((Object)"standard_conforming_strings", SQLDriver.readSingleValue(conn, "show standard_conforming_strings;", "standard_conforming_strings"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                sqlConfig.put((Object)"_metaData", (Object)metaData);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (dbType == null) {
            throw new Exception(dbName + ": database.type not explicitly specified and initial connection not available (see reason above)");
        }
        sqlConfig.put((Object)"_dbType", (Object)dbType);
        if (dbTypeString == null) {
            dbTypeString = dbType.toString();
            sqlConfig = (Config)DataTools.cascadeMaps((Map[])new Map[]{config.getSubtree("sql.default"), config.getSubtree("sql." + dbTypeString), sqlConfig, new Config()});
        }
        return sqlConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readSingleValue(Connection conn, String query, String columnName) throws Exception {
        Statement s = null;
        ResultSet rs = null;
        try {
            s = conn.createStatement();
            rs = s.executeQuery(query);
            rs.next();
            Object object = rs.getObject(columnName);
            return object;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                s.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection rawConnection() throws Exception {
        DataSource ds = (DataSource)this.sqlConfig.get((Object)"_ds");
        String jdbcURL = this.sqlConfig.getString((Object)"_jdbcURL");
        Boolean credentialsInURL = this.sqlConfig.getBoolean((Object)"_credentialsInURL");
        if (credentialsInURL == null) {
            credentialsInURL = Boolean.FALSE;
        }
        if (!this.sqlConfig.getBoolean((Object)"_oneTimeConnectionInitComplete", false)) {
            Config config = this.sqlConfig;
            synchronized (config) {
                if (!this.sqlConfig.getBoolean((Object)"_oneTimeConnectionInitComplete", false)) {
                    if (ds != null) {
                        Map driverProperties;
                        if (this.sqlConfig.getBoolean((Object)"log.enabled", false)) {
                            ds.setLogWriter(new PrintWriter(System.out));
                        }
                        if ((driverProperties = this.getDriverProperties()) != null && driverProperties.size() > 0) {
                            DataTools.setProperties((Map)driverProperties, (Object)ds);
                        }
                    } else {
                        Map driverProperties = this.getDriverProperties();
                        if (driverProperties != null && driverProperties.size() > 0) {
                            jdbcURL = jdbcURL + (credentialsInURL != false ? "&" : "?");
                            Iterator i = driverProperties.keySet().iterator();
                            while (i.hasNext()) {
                                String propName = (String)i.next();
                                Object propValue = driverProperties.get(propName);
                                jdbcURL = jdbcURL + (propName + "=" + propValue == null ? "" : propValue.toString());
                                if (!i.hasNext()) continue;
                                jdbcURL = jdbcURL + "&";
                            }
                        }
                    }
                    this.sqlConfig.put((Object)"_oneTimeConnectionInitComplete", (Object)new Boolean(true));
                }
            }
        }
        Connection conn = null;
        conn = ds != null ? ds.getConnection() : (credentialsInURL == false ? DriverManager.getConnection(jdbcURL, this.driverConfig.getString((Object)"user"), this.driverConfig.getString((Object)"password")) : DriverManager.getConnection(jdbcURL));
        return conn;
    }

    protected Map getDriverProperties() {
        HashMap<String, String> driverProperties = new HashMap<String, String>();
        if ((this.dbType == DBType.Informix || this.dbType == DBType.MySQL) && this.useUTCDateTimes) {
            driverProperties.put("serverTimezone", "UTC");
        }
        return driverProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void freeConnection() {
        block9: {
            try {
                if (this.dbConnection == null) break block9;
                Connection connection = this.dbConnection;
                synchronized (connection) {
                    if (!this.dbConnection.isClosed()) {
                        log.debug((Object)("Freeing SQLDriver dbConnection " + this.dbConnection.hashCode() + " for SQLDriver instance " + ((Object)((Object)this)).hashCode()));
                        SQLConnectionManager.free(this.dbConnection);
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)"Exception freeing the SQLDriver dbConnection", (Throwable)e);
            }
            finally {
                this.dbConnection = null;
            }
        }
    }

    public void finalize() throws Throwable {
        this.freeConnection();
    }

    public Connection getConnection() {
        return this.dbConnection;
    }

    public Connection getOrCreateConnection() throws SQLException {
        if (this.dbConnection == null) {
            this.dbConnection = SQLConnectionManager.getConnection(this.dbName);
        }
        return this.dbConnection;
    }

    public String getDBName() {
        return this.dbName;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public boolean useColumnLabelInMetadata() {
        return this.useColumnLabelInMetadata;
    }

    public SQLTable getTable() {
        return this.table;
    }

    public static List getTransformedResults(String query, DSRequest req) throws Exception {
        return SQLDriver.getTransformedResults(query, null, req);
    }

    public static List getTransformedResults(String query, String dbName, DSRequest req) throws Exception {
        return SQLDriver.getTransformedResults(query, null, dbName, null, req);
    }

    protected static List getTransformedResults(String query, Connection conn, String dbName, SQLDriver driver, DSRequest req) throws Exception {
        return SQLDriver.getTransformedResults(query, conn, dbName, driver, null, req, null);
    }

    protected static List getTransformedResults(String query, Connection conn, String dbName, SQLDriver driver, List dataSources, DSRequest req, DSResponse resp) throws Exception {
        return SQLDriver.getTransformedResults(query, conn, dbName, driver, dataSources, null, req, resp);
    }

    protected static List getTransformedResults(String query, Connection conn, String dbName, SQLDriver driver, List dataSources, Map opConfig, DSRequest req, DSResponse result) throws Exception {
        Connection workingConn;
        boolean closeConnection = false;
        boolean userOrAutoTransaction = true;
        Connection userOrAutoConn = null;
        if (req != null) {
            req.recordTimingData(TIMING_LOG_UNPAGED_FETCH, DSRequest.TimingLogType.START);
            req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.START);
            if (req.getDsTransaction() != null) {
                SQLDataSource ds = (SQLDataSource)req.getDataSource();
                userOrAutoConn = ds.getTransactionalConnection(req);
            }
        }
        if (userOrAutoConn == null) {
            if (dbName == null) {
                dbName = config.getString((Object)"sql.defaultDatabase");
            }
            if (conn == null) {
                if (driver != null && driver.dbConnection != null) {
                    conn = driver.dbConnection;
                    closeConnection = false;
                }
                if (conn == null) {
                    conn = SQLConnectionManager.getConnection(dbName);
                    closeConnection = true;
                }
                if (driver != null && driver.dbConnection == null) {
                    driver.dbConnection = conn;
                    closeConnection = false;
                }
            } else if (driver != null) {
                if (driver.dbConnection != null && driver.dbConnection != conn) {
                    SQLConnectionManager.free(driver.dbConnection);
                }
                driver.dbConnection = conn;
            }
            userOrAutoTransaction = false;
            workingConn = conn;
        } else {
            workingConn = userOrAutoConn;
        }
        if (req != null) {
            req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.END);
        }
        Statement s = null;
        ResultSet rs = null;
        boolean streaming = req != null && req.shouldStreamResults();
        int batchSize = req == null ? 0 : (int)req.getBatchSize();
        try {
            if (req == null || !"fileSourceDataSources".equals(req.getDataSourceName()) || config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true)) {
                log.info((Object)("Executing SQL query on '" + dbName + "' using connection '" + workingConn.hashCode() + "'"), (Object)query);
            }
            s = driver == null ? workingConn.createStatement() : driver.createFetchStatement(workingConn, streaming, batchSize);
            long start = System.currentTimeMillis();
            if (req != null) {
                req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.START);
            }
            rs = s.executeQuery(query);
            if (req != null) {
                req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.END);
            }
            if (streaming) {
                log.debug((Object)"Streaming the response");
                result.setData((Object)new StreamingResponseIterator(result));
                HashMap<String, Object> sContext = new HashMap<String, Object>();
                sContext.put("resultSet", rs);
                sContext.put("brokenCursorAPIs", SQLTransform.hasBrokenCursorAPIs(driver));
                sContext.put("dataSources", dataSources);
                sContext.put("opConfig", opConfig);
                sContext.put("dsRequest", req);
                result.setStreamingContext(sContext);
                result.setStartRow(req.getStartRow());
                result.setEndRow(req.getStartRow());
                result._setHasNextRecord(rs.next());
                List list = null;
                return list;
            }
            start = System.currentTimeMillis();
            if (req != null) {
                req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.START);
            }
            List data = SQLTransform.toListOfMapsOrBeans(rs, SQLTransform.hasBrokenCursorAPIs(dbName), dataSources, opConfig, req);
            if (req != null) {
                req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.END);
            }
            List list = data;
            return list;
        }
        catch (SQLException se) {
            if (!userOrAutoTransaction) {
                if (config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true)) {
                    log.info((Object)("Execute of select: " + query + " on db: " + dbName + " threw exception: " + se.toString() + " - assuming stale connection and retrying query."));
                }
                SQLConnectionManager.free(conn, true);
                conn = SQLConnectionManager.getNewConnection(dbName);
                if (driver != null) {
                    driver.dbConnection = conn;
                }
                s = driver == null ? conn.createStatement() : driver.createFetchStatement(conn, streaming, batchSize);
                rs = s.executeQuery(query);
                List list = SQLTransform.toListOfMapsOrBeans(rs, SQLTransform.hasBrokenCursorAPIs(dbName), dataSources, opConfig);
                return list;
            }
            throw se;
        }
        finally {
            if (!streaming) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
                try {
                    s.close();
                }
                catch (Exception exception) {}
                if (req != null) {
                    req.recordTimingData(TIMING_LOG_UNPAGED_FETCH, DSRequest.TimingLogType.END);
                }
            }
        }
    }

    public static Object getScalarResult(String query, DSRequest req) throws Exception {
        return SQLDriver.getScalarResult(query, null, req);
    }

    public static Object getScalarResult(String query, String dbName, DSRequest req) throws Exception {
        return SQLDriver.getScalarResult(query, null, dbName, null, req);
    }

    public static Object getScalarResult(String query, Connection conn, String dbName, SQLDriver driver, DSRequest req) throws Exception {
        List list = SQLDriver.getTransformedResults(query, conn, dbName, driver, req);
        if (list == null || list.size() == 0) {
            return null;
        }
        Map map = (Map)list.get(0);
        return map.get(DataTools.getSingle((Object)map));
    }

    public static int update(String update, DSRequest req) throws Exception {
        return SQLDriver.update(update, null, req);
    }

    public static int update(String update, String dbName, DSRequest req) throws Exception {
        return SQLDriver.update(update, null, dbName, req);
    }

    public static int update(String update, List data, String dbName, DSRequest req) throws Exception {
        return SQLDriver.update(update, data, SQLConnectionManager.getConnection(dbName), dbName, null, req);
    }

    protected static int update(String update, List data, Connection conn, String dbName, SQLDriver driver, DSRequest req) throws Exception {
        Connection workingConn;
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        boolean userOrAutoTransaction = true;
        Connection userOrAutoConn = null;
        if (req != null && req.getDsTransaction() != null) {
            SQLDataSource ds = (SQLDataSource)req.getDataSource();
            userOrAutoConn = ds.getTransactionalConnection(req);
        } else {
            log.info((Object)"DSRequest has no DSTransaction set, when testing if we should join a transaction - transaction will not be joined");
        }
        if (userOrAutoConn == null) {
            if (conn == null) {
                if (driver != null && driver.dbConnection != null) {
                    conn = driver.dbConnection;
                }
                if (conn == null) {
                    conn = SQLConnectionManager.getConnection(dbName);
                }
                if (driver != null) {
                    driver.dbConnection = conn;
                }
            } else if (driver != null) {
                if (driver.dbConnection != null && driver.dbConnection != conn) {
                    SQLConnectionManager.free(driver.dbConnection);
                }
                driver.dbConnection = conn;
            }
            userOrAutoTransaction = false;
            workingConn = conn;
        } else {
            workingConn = userOrAutoConn;
        }
        if (req == null || !"fileSourceDataSources".equals(req.getDataSourceName()) || config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true)) {
            log.info((Object)("Executing SQL query on '" + dbName + "' using connection '" + workingConn.hashCode() + "'"), (Object)update);
        }
        try {
            int ds = SQLDriver.doUpdate(update, data, workingConn, req, driver);
            return ds;
        }
        catch (SQLException se) {
            if (!userOrAutoTransaction) {
                if (config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true)) {
                    log.info((Object)("Execute of update: " + update + " on db: " + dbName + " threw exception: " + se.toString() + " - assuming stale connection and retrying update."));
                }
                SQLConnectionManager.free(conn, true);
                conn = SQLConnectionManager.getNewConnection(dbName);
                if (driver != null) {
                    driver.dbConnection = conn;
                }
                int n = SQLDriver.doUpdate(update, data, conn, req, driver);
                return n;
            }
            log.debug((Object)("FAILED to execute SQL update in '" + dbName + "' using connection'" + workingConn.hashCode() + "'"));
            throw se;
        }
        finally {
            if (!userOrAutoTransaction && driver == null) {
                SQLConnectionManager.free(conn);
            }
        }
    }

    public static int doUpdate(String update, List data, Connection conn, DSRequest req) throws SQLException {
        return SQLDriver.doUpdate(update, data, conn, req, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int doUpdate(String update, List data, Connection conn, DSRequest req, SQLDriver driver) throws SQLException {
        try {
            if (req != null) {
                driver.setLastSequenceMode(((SQLDataSource)req.getDataSource()).getSequenceMode());
            } else {
                driver.setLastSequenceMode(SQLDataSource.SequenceMode.NONE);
            }
        }
        catch (Exception e) {
            throw new SQLException("Exception getting sequenceMode: " + e.getMessage());
        }
        PreparedStatement s = driver.getPreparedStatement(conn, update, driver.getLastSequenceMode());
        try {
            int pos;
            if (data != null && !com.isomorphic.datasource.DataSource.isRemove((String)req.getOperationType())) {
                pos = 1;
                for (Object o : data) {
                    if (o instanceof InputStream) {
                        InputStream is = (InputStream)o;
                        try {
                            Method m = Reflection.findMethod((String)"java.sql.PreparedStatement", (String)"setBinaryStream", (Class[])new Class[]{Integer.TYPE, Class.forName("java.io.InputStream")});
                            m.invoke((Object)s, pos, is);
                        }
                        catch (Exception e) {
                            if (!(o instanceof ByteArrayInputStream)) {
                                is = new ByteArrayInputStream(IOUtil.toByteArray((InputStream)is));
                            }
                            s.setBinaryStream(pos, is, is.available());
                        }
                    } else if (o instanceof StringBuffer) {
                        StringBuffer sb = (StringBuffer)o;
                        s.setCharacterStream(pos, (Reader)new StringReader(sb.toString()), sb.length());
                    } else if (o == null && driver.shouldParameterizeNullValues()) {
                        s.setString(pos, null);
                    }
                    ++pos;
                }
            }
            pos = s.executeUpdate();
            return pos;
        }
        catch (IOException ioe) {
            log.warn((Object)"Exception thrown whilst processing InputStream", (Throwable)ioe);
            int n = -1;
            return n;
        }
        finally {
            try {
                if (driver != null && req != null && com.isomorphic.datasource.DataSource.isAdd((String)req.getOperationType())) {
                    driver.saveGeneratedKeys(s, req);
                }
            }
            catch (Exception e) {
                log.warn((Object)"Exception thrown during saveGeneratedKeys()", (Throwable)e);
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected PreparedStatement getPreparedStatement(Connection conn, String update, SQLDataSource.SequenceMode sequenceMode) throws SQLException {
        if (sequenceMode == SQLDataSource.SequenceMode.JDBC_DRIVER) {
            if (SQLDriver.supportsGetGeneratedKeys(conn)) {
                return conn.prepareStatement(update, 1);
            }
            return conn.prepareStatement(update);
        }
        return conn.prepareStatement(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(String sql, Connection conn, String dbName, SQLDriver driver) throws Exception {
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        if (conn == null) {
            conn = SQLConnectionManager.getConnection(dbName);
            if (driver != null) {
                driver.dbConnection = conn;
            }
        }
        Statement s = null;
        try {
            log.info((Object)("Executing SQL on '" + dbName + "'"), (Object)sql);
            s = conn.createStatement();
            boolean bl = s.execute(sql);
            return bl;
        }
        catch (SQLException se) {
            log.info((Object)("Execute of sql: " + sql + " on db: " + dbName + " threw exception: " + se.toString() + " - assuming stale connection and retrying update."));
            SQLConnectionManager.free(conn, true);
            conn = SQLConnectionManager.getNewConnection(dbName);
            if (driver != null) {
                driver.dbConnection = conn;
            }
            s = conn.createStatement();
            boolean bl = s.execute(sql);
            return bl;
        }
        finally {
            try {
                s.close();
            }
            catch (Exception exception) {}
            if (driver == null) {
                SQLConnectionManager.free(conn);
            }
        }
    }

    public boolean execute(String sql) throws Exception {
        return SQLDriver.execute(sql, this.dbConnection, this.dbName, this);
    }

    public int executeUpdate(String update, DSRequest req) throws Exception {
        return SQLDriver.update(update, null, this.dbConnection, this.dbName, this, req);
    }

    public int executeUpdate(String update, List data, DSRequest req) throws Exception {
        return SQLDriver.update(update, data, this.dbConnection, this.dbName, this, req);
    }

    public List executeQuery(String query, DSRequest req) throws Exception {
        return this.executeQuery(query, null, req, null);
    }

    public List executeQuery(String query, List dataSources, DSRequest req) throws Exception {
        return this.executeQuery(query, dataSources, null, req, null);
    }

    public List executeQuery(String query, List dataSources, DSRequest req, DSResponse resp) throws Exception {
        return this.executeQuery(query, dataSources, null, req, resp);
    }

    public List executeQuery(String query, List dataSources, Map opConfig, DSRequest req, DSResponse resp) throws Exception {
        return SQLDriver.getTransformedResults(query, this.dbConnection, this.dbName, this, dataSources, opConfig, req, resp);
    }

    public Object executeScalar(String query, DSRequest req) throws Exception {
        return SQLDriver.getScalarResult(query, this.dbConnection, this.dbName, this, req);
    }

    public boolean supportsSQLLimit() {
        return false;
    }

    public boolean limitRequiresSQLOrderClause() {
        return false;
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, DSRequest req) throws Exception {
        return this.limitQuery(query, startRow, totalRows, outputColumns);
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns) throws Exception {
        return this.limitQuery(query, startRow, totalRows, outputColumns, null, null, null);
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, String orderClause, DSRequest req, List dataSources) throws Exception {
        return this.limitQuery(query, startRow, totalRows, outputColumns, orderClause, req, dataSources, null);
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, String orderClause, DSRequest req, List dataSources, Map context) throws Exception {
        throw new Exception("limitQuery not supported by '" + (Object)((Object)this.getDBType()) + "'.  Implementation: " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    public String getRowCountQueryString(String select, String tables, String ansiJoin, String where, String joinWhere, String group, String groupWhere, Map context) {
        boolean hasGroupWhere;
        boolean hasGroup;
        boolean _useDistinctForGroupBy = this.useDistinctForGroupBy;
        boolean hasCustomGroup = hasGroup = !group.equals("$defaultGroupClause") && !group.equals("$defaultGroupWithAliasClause");
        if (!hasGroup && context != null && context.containsKey("dsRequest")) {
            DSRequest req = (DSRequest)context.get("dsRequest");
            hasGroup = req.isSummary();
        }
        boolean bl = hasGroupWhere = !groupWhere.equals("$defaultGroupWhereClause");
        if (hasGroupWhere) {
            _useDistinctForGroupBy = false;
        }
        String qry = "SELECT COUNT(*) FROM ";
        if (hasGroup) {
            qry = !hasCustomGroup && _useDistinctForGroupBy ? qry + "(SELECT distinct " + group + " FROM " : qry + "(SELECT " + select + " FROM ";
        }
        qry = qry + tables;
        boolean tableClauseIncludesAnsiJoins = DataTools.getBoolean((Map)context, (Object)"tableClauseIncludesAnsiJoins", (boolean)false);
        boolean emittedJoinClause = false;
        if (!(tableClauseIncludesAnsiJoins || "$defaultAnsiJoinClause".equals(ansiJoin) && context.get("defaultAnsiJoinClause") == null)) {
            qry = qry + ansiJoin;
            emittedJoinClause = true;
        }
        boolean emittedWhere = false;
        if (!where.equals("$defaultWhereClause") || context.get("defaultWhereClause") != null && !SQLWhereClause.isDefaultPositiveClause(context.get("defaultWhereClause"))) {
            qry = qry + " WHERE " + where;
            emittedWhere = true;
        }
        if (!(emittedJoinClause || "$defaultJoinWhereClause".equals(joinWhere) && (context.get("defaultJoinWhereClause") == null || "".equals(context.get("defaultJoinWhereClause"))))) {
            qry = !emittedWhere ? qry + " WHERE " + joinWhere : qry + " AND " + joinWhere;
        }
        if (hasGroup) {
            if (!hasCustomGroup && _useDistinctForGroupBy) {
                qry = qry + " ) work";
            } else {
                qry = qry + " GROUP BY " + group + ") work";
                if (hasGroupWhere) {
                    qry = qry + " WHERE " + groupWhere;
                }
            }
        }
        return qry;
    }

    public abstract boolean supportsNativeReplace();

    public String sortBy(Object order, Map remapTable, Map valueMaps) {
        if (order == null) {
            return "";
        }
        List orderList = order instanceof String ? DataTools.makeList((Object)order) : (List)order;
        if (orderList.size() == 0) {
            return "";
        }
        if (remapTable == null) {
            remapTable = EMPTY_REMAP;
        }
        String clause = " ORDER BY ";
        Iterator e = orderList.iterator();
        while (e.hasNext()) {
            String orderColumn = (String)e.next();
            boolean descending = false;
            if (orderColumn.startsWith("-")) {
                orderColumn = orderColumn.substring(1);
                descending = true;
            }
            Map valueMap = (Map)valueMaps.get(orderColumn);
            String remappedName = (String)remapTable.get(orderColumn);
            if (remappedName != null) {
                orderColumn = remappedName;
            }
            orderColumn = this.escapeColumnName(orderColumn);
            clause = clause + this.getExpressionForSortBy(orderColumn, valueMap, null) + (descending ? " DESC" : "");
            if (!e.hasNext()) continue;
            clause = clause + ", ";
        }
        return clause;
    }

    protected abstract String getExpressionForSortBy(String var1, Map var2, DSRequest var3);

    protected String getExpressionForSortBy(String column, Map valueMap, String functionName, DSRequest request) {
        String expr = this.getExpressionForSortBy(column, valueMap, request);
        if (functionName != null && !"".equals(functionName.trim())) {
            expr = functionName + "(" + expr + ")";
        }
        return expr;
    }

    protected String getLocalizedDisplayValue(Object displayValue, DSRequest request) {
        if (displayValue instanceof LocaleMessage) {
            if (request != null && request.context == null) {
                log.warn((Object)"Passed a DSRequest with no context, so we cannot discover the client locale.  Using the server default locale");
            }
            Locale locale = request != null && request.context != null ? request.context.getLocale() : Locale.getDefault();
            return ((LocaleMessage)displayValue).getMessage(locale);
        }
        return displayValue == null ? null : displayValue.toString();
    }

    public abstract Map fetchLastPrimaryKeys(Map var1, List var2, SQLDataSource var3, DSRequest var4) throws Exception;

    public Map getJdbcPKs() {
        return this.jdbcPKs;
    }

    public void saveGeneratedKeys(Statement s, DSRequest req) throws Exception {
        this.jdbcPKs.clear();
        if (this.getLastSequenceMode() != SQLDataSource.SequenceMode.JDBC_DRIVER) {
            log.debug((Object)"SequenceMode is not JDBC_DRIVER, skipping search for generated values");
            return;
        }
        if (!SQLDriver.supportsGetGeneratedKeys(s.getConnection())) {
            log.warn((Object)"SequenceMode is JDBC_DRIVER but the driver is not GENERATED_KEYS capable");
            return;
        }
        if (req.getDataSource() instanceof SQLDataSource) {
            SQLDataSource ds = (SQLDataSource)req.getDataSource();
            List pkNames = ds.getPrimaryKeys();
            List fieldNames = ds.getFieldNames();
            boolean proceed = false;
            for (String fieldName : fieldNames) {
                DSField field = ds.getField(fieldName);
                if (field == null || !"sequence".equals(field.getType()) && (!pkNames.contains(fieldName) || !field.getBoolean("autoGenerated", false))) continue;
                proceed = true;
                break;
            }
            if (!proceed) {
                log.debug((Object)("DataSource " + ds.getName() + " has no sequence fields and no primaryKeys where 'autoGenerated' is true.  Skipping search for generated values"));
                return;
            }
            LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
            ArrayList<String> sequenceList = new ArrayList<String>();
            ArrayList<String> sequenceFieldList = new ArrayList<String>();
            ArrayList<String> seqOrGenFieldList = new ArrayList<String>();
            int count = 0;
            int seqCount = 0;
            Iterator i = pkNames.iterator();
            while (i.hasNext()) {
                DSField pk = ds.getField((String)i.next());
                if (!"sequence".equals(pk.getType()) && !pk.getBoolean("autoGenerated", false)) continue;
                sequences.put(ds.getColumnName(pk.getName()).toLowerCase(), ds.getColumnName(pk.getName()));
                sequenceList.add(ds.getColumnName(pk.getName()));
                seqOrGenFieldList.add(pk.getName());
                ++count;
                if (!"sequence".equals(pk.getType())) continue;
                ++seqCount;
                sequenceFieldList.add(pk.getName());
            }
            if (seqCount > this.maxAllowedSequenceColumns()) {
                log.warn((Object)("DataSource " + ds.getName() + " can have a maximum of " + this.maxAllowedSequenceColumns() + " sequence fields, but it actually has " + seqCount + ": " + sequenceFieldList + ". Cannot continue."));
                return;
            }
            log.debug((Object)("Found " + count + " sequence(s)/autoGenerated PK field(s): " + seqOrGenFieldList));
            ResultSet rs = s.getGeneratedKeys();
            if (rs == null) {
                return;
            }
            if (count == 1) {
                if (rs.next()) {
                    DSField field = ds.getField((String)seqOrGenFieldList.get(0));
                    String columnName = ds.getColumnName(field.getName());
                    Object generated = rs.getObject(1);
                    if (generated != null) {
                        if (generated instanceof RowId || "oracle.sql.ROWID".equals(generated.getClass().getName())) {
                            this.jdbcPKs = this.fetchSequenceValues(seqOrGenFieldList, req, rs.getString(1));
                            this.jdbcPKs = this.mapColumnsToFields(this.jdbcPKs, ds);
                            log.debug((Object)("Discovered zero or one generated key via JDBC: " + this.jdbcPKs));
                            req.setAttribute("_jdbcGeneratedKeys", (Object)true);
                        } else {
                            String baseType = ds.getSimpleBaseType(field.getType());
                            if ("integer".equals(baseType)) {
                                long pkValue = generated instanceof Long ? ((Long)generated).longValue() : rs.getLong(1);
                                this.jdbcPKs.put(columnName, pkValue);
                            } else if ("date".equals(baseType)) {
                                Date pkValue = generated instanceof Date ? (Date)generated : rs.getDate(1);
                                this.jdbcPKs.put(columnName, pkValue);
                            } else if ("boolean".equals(baseType)) {
                                boolean pkValue = generated instanceof Boolean ? ((Boolean)generated).booleanValue() : rs.getBoolean(1);
                                this.jdbcPKs.put(columnName, pkValue);
                            } else {
                                this.jdbcPKs.put(columnName, generated.toString());
                            }
                            this.jdbcPKs = this.mapColumnsToFields(this.jdbcPKs, ds);
                            log.debug((Object)("Discovered zero or one generated key via JDBC: " + this.jdbcPKs));
                            req.setAttribute("_jdbcGeneratedKeys", (Object)true);
                        }
                        req.setAttribute("_jdbcGeneratedKeys", (Object)true);
                    } else {
                        log.warn((Object)("getGeneratedKeys: there was a row in the metadata resultset, but it contained a null value for the generated key field '" + field.getName() + "'"));
                        if (log.isInfoEnabled() && seqOrGenFieldList.contains(field.getName()) && !sequenceFieldList.contains(field.getName())) {
                            log.info((Object)("(This is because field " + field.getName() + " is a generated value, not a sequence; see the client-side documentation for the DataSourceField 'autoGenerated' property"));
                        }
                    }
                } else {
                    log.debug((Object)"No rows in metadata resultset - driver thinks there were no generated values!");
                }
            } else if (rs.next()) {
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i2 = 0; i2 < rsmd.getColumnCount(); ++i2) {
                    Object generated = rs.getObject(i2 + 1);
                    if (generated == null) continue;
                    if (generated instanceof RowId || "oracle.sql.ROWID".equals(generated.getClass().getName())) {
                        this.jdbcPKs = this.fetchSequenceValues(seqOrGenFieldList, req, rs.getString(i2 + 1));
                        break;
                    }
                    String colName = rsmd.getColumnName(i2 + 1).toLowerCase();
                    if (colName == null || !sequences.containsKey(colName)) continue;
                    this.jdbcPKs.put(ds.getFieldNameFromColumnName((String)sequences.get(colName)), generated);
                }
                this.jdbcPKs = this.mapColumnsToFields(this.jdbcPKs, ds);
                log.debug((Object)("Discovered zero or more generated key(s) via JDBC: " + this.jdbcPKs));
                if (this.jdbcPKs.keySet().size() < seqOrGenFieldList.size()) {
                    log.warn((Object)"getGeneratedKeys: there was a row in the metadata resultset, but it contained fewer keys than we need");
                    if (log.isInfoEnabled() && seqOrGenFieldList.size() > sequenceFieldList.size()) {
                        log.info((Object)("(This is probably because your dataSource specifies autoGenerated primaryKey fields " + (sequenceFieldList.size() == 0 ? "instead of" : "as well as") + " sequence fields; see the client-side documentation for the DataSourceField 'autoGenerated' property"));
                    }
                }
                req.setAttribute("_jdbcGeneratedKeys", (Object)true);
            } else {
                log.debug((Object)"No rows in metadata resultset - driver thinks there were no generated values!");
            }
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Map mapColumnsToFields(Map in, SQLDataSource ds) {
        LinkedHashMap out = new LinkedHashMap();
        for (String columnName : in.keySet()) {
            out.put(ds.native2DSFieldMap().get(columnName), in.get(columnName));
        }
        return out;
    }

    private int maxAllowedSequenceColumns() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map fetchSequenceValues(List sequences, DSRequest req, String rowId) throws Exception {
        LinkedHashMap linkedHashMap;
        block15: {
            List data;
            boolean free;
            Connection conn;
            LinkedHashMap values;
            block13: {
                LinkedHashMap linkedHashMap2;
                block14: {
                    DSTransaction dsTransaction;
                    DSRequest work = new DSRequest(req.getDataSourceName(), "fetch");
                    work.inheritClientContext(req);
                    work.setParameter((Object)"additionalOutputs", req.getParameter((Object)"additionalOutputs"));
                    Iterator i = req.getAttributeNames();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        work.setAttribute(key, req.getAttribute(key));
                    }
                    work.setPrimaryDSRequest(req);
                    req.addSubRequest(work);
                    values = new LinkedHashMap();
                    conn = null;
                    Statement stmt = null;
                    ResultSet rs = null;
                    free = false;
                    String sql = SQLDataSource.getSQLClause(SQLClauseType.All, work);
                    int index = sql.indexOf("WHERE ('1'='1')");
                    if (index != -1) {
                        sql = sql.substring(0, index) + "WHERE ROWID = '" + rowId + "'";
                    }
                    if ((dsTransaction = req.getDsTransaction()) != null) {
                        conn = (Connection)dsTransaction.getAttribute(req.getDataSource().getTransactionObjectKey(true));
                    }
                    if (conn == null) {
                        conn = ((SQLDataSource)req.getDataSource()).getConnection();
                        free = true;
                    }
                    stmt = conn.createStatement();
                    log.debug((Object)("Executing ROWID query: " + sql));
                    rs = stmt.executeQuery(sql);
                    data = SQLTransform.toListOfMaps(rs);
                    log.debug((Object)("ROWID query returned " + data.size() + " rows"));
                    if (data.size() == 1) break block13;
                    log.warn((Object)"ROWID query should return a single row, abandoning");
                    linkedHashMap2 = values;
                    if (!free || conn == null) break block14;
                    SQLConnectionManager.free(conn);
                }
                return linkedHashMap2;
            }
            try {
                Map record = (Map)data.get(0);
                if (record != null) {
                    for (int i = 0; i < sequences.size(); ++i) {
                        String key = (String)sequences.get(i);
                        Object value = record.get(key);
                        if (value == null) {
                            value = record.get(key.toUpperCase());
                        }
                        if (value == null) {
                            value = record.get(key.toLowerCase());
                        }
                        if (value != null) {
                            log.debug((Object)("Setting sequence value for field " + key + " to " + value));
                            values.put(key, value);
                            continue;
                        }
                        log.debug((Object)("No value for sequence field " + key + " found in record: " + record));
                    }
                }
                linkedHashMap = values;
                if (!free || conn == null) break block15;
            }
            catch (Throwable throwable) {
                if (free && conn != null) {
                    SQLConnectionManager.free(conn);
                }
                throw throwable;
            }
            SQLConnectionManager.free(conn);
        }
        return linkedHashMap;
    }

    public void clearState() {
        this.freeConnection();
        this.lastSequenceMode = null;
    }

    public String escapeColumnName(Object columnName) {
        return this.escapeColumnName(columnName, false);
    }

    public String escapeColumnName(Object columnName, boolean forceQuoteColumnName) {
        if (columnName == null) {
            return null;
        }
        if (forceQuoteColumnName || this.quoteColumnNames || this.table != null && this.table.isQuoteColumnNames()) {
            return this.openQuote() + this.matcher.reset(columnName.toString()).usePattern(DOUBLE_QUOTE_PATTERN).replaceAll(DOUBLE_QUOTE_ESCAPE) + this.closeQuote();
        }
        return columnName.toString();
    }

    public abstract String escapeValue(Object var1);

    public abstract String escapeValueForFilter(Object var1, String var2);

    public abstract String formatValue(Object var1);

    public String escapeClause() {
        return "";
    }

    public abstract String escapeValueUnquoted(Object var1, boolean var2);

    public String sqlInTransform(Object value, DSField field, SQLDataSource ds) throws Exception {
        return this.sqlInTransform(value, field, ds, true);
    }

    public String sqlInTransform(Object value, DSField field, SQLDataSource ds, boolean addLiteralPrefix) throws Exception {
        String sqlType;
        boolean isFloat = false;
        boolean isInteger = false;
        boolean isSequence = false;
        boolean isBoolean = false;
        boolean isTime = false;
        boolean isDate = false;
        boolean isDateTime = false;
        if (field != null) {
            try {
                isFloat = ds.simpleTypeInheritsFrom(field.getType(), "float");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isInteger = ds.simpleTypeInheritsFrom(field.getType(), "integer");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isSequence = ds.simpleTypeInheritsFrom(field.getType(), "sequence");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isBoolean = ds.simpleTypeInheritsFrom(field.getType(), "boolean");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isTime = ds.simpleTypeInheritsFrom(field.getType(), "time");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isDate = ds.simpleTypeInheritsFrom(field.getType(), "date");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isDateTime = ds.simpleTypeInheritsFrom(field.getType(), "datetime");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof GregorianCalendar) {
            value = ((GregorianCalendar)value).getTime();
        }
        if (value instanceof Date) {
            if (field != null) {
                sqlType = (String)field.get((Object)"sqlStorageStrategy");
                if ("number".equals(sqlType) || "integer".equals(sqlType) || "text".equals(sqlType)) {
                    String sqlFormat = (String)field.get((Object)"sqlDateFormat");
                    if (sqlFormat == null) {
                        sqlFormat = "yyyyMMdd";
                    }
                    if ("epoch".equalsIgnoreCase(sqlFormat)) {
                        return Long.toString(((Date)value).getTime() / 1000L);
                    }
                    if ("epochms".equalsIgnoreCase(sqlFormat)) {
                        return Long.toString(((Date)value).getTime());
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(sqlFormat);
                    String formatted = sdf.format(value);
                    return this.escapeValue(formatted);
                }
                if (isDateTime) {
                    long timeStamp = ((Date)value).getTime();
                    return this.escapeValue(this.formatTimestamp(timeStamp, true, ds, field));
                }
                if (isTime) {
                    return this.escapeValue(this.formatTime(((Date)value).getTime()));
                }
                if (isDate) {
                    return this.escapeValue(this.formatDate(((Date)value).getTime()));
                }
            }
            long timeStamp = ((Date)value).getTime();
            return this.escapeValue(this.formatTimestamp(timeStamp, true, ds, field));
        }
        if (isBoolean) {
            String val;
            sqlType = (String)field.get((Object)"sqlStorageStrategy");
            if ("number".equals(sqlType) || "integer".equals(sqlType)) {
                return value.equals(Boolean.TRUE) ? "1" : "0";
            }
            if (sqlType != null && sqlType.indexOf("singleChar") == 0 && (val = this.convertSingleCharValue(sqlType, value, field)) != null) {
                return val;
            }
        } else if (isFloat || isInteger || isSequence) {
            if (value instanceof Number) {
                return value.toString();
            }
            try {
                if (isFloat) {
                    return new Double(value.toString()).toString();
                }
                if (isInteger) {
                    return new Long(value.toString()).toString();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.escapeValue(value);
    }

    public String sqlStringComparisonRValue(String value, String operator) {
        StringBuffer sql = new StringBuffer();
        sql.append("'");
        if (operator.contains("ndsWith") || operator.contains("tains")) {
            sql.append("%");
        }
        if (operator.equals("containsPattern")) {
            if (value.startsWith("%")) {
                value = value.substring(1);
            }
            if (value.endsWith("%")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        sql.append(value);
        if (operator.contains("rtsWith") || operator.contains("tains")) {
            sql.append("%");
        }
        sql.append("'");
        return sql.toString();
    }

    public String sqlFilterTransform(Object value, DSField field, SQLDataSource ds, String filterStyle) {
        String compare = value.toString();
        if (this.caseInsensitiveStrategy() == 1 || this.caseInsensitiveStrategy() == 1) {
            compare = compare.toLowerCase();
        } else if (this.caseInsensitiveStrategy() == 2) {
            compare = compare.toUpperCase();
        }
        return this.escapeValueForFilter(compare, filterStyle);
    }

    protected String formatTimestamp(long millis, boolean convertToUTC, SQLDataSource ds, DSField field) throws Exception {
        if (convertToUTC && (ds == null || ds.shouldUseUTCDateTimes())) {
            if (field != null && field.shouldStoreMilliseconds() && this.supportsMilliseconds()) {
                return this.getUTCDateTimeMsFormatter().format(new Timestamp(millis));
            }
            return this.getUTCDateTimeFormatter().format(new Timestamp(millis));
        }
        if (field != null && field.shouldStoreMilliseconds() && this.supportsMilliseconds()) {
            return this.getLocalDateTimeMsFormatter().format(new Timestamp(millis));
        }
        return this.getLocalDateTimeFormatter().format(new Timestamp(millis));
    }

    protected String formatDate(long millis) {
        return this.getLogicalDateFormatter().format(new Timestamp(millis));
    }

    protected String formatTime(long millis) {
        return this.getLogicalTimeFormatter().format(new Timestamp(millis));
    }

    protected String convertSingleCharValue(String sqlType, Object columnValue, DSField field) {
        String t = (String)field.get((Object)"sqlTrueValue");
        String f = (String)field.get((Object)"sqlFalseValue");
        if ("singleChar10".equals(sqlType)) {
            t = "1";
            f = "0";
        } else if ("singleCharYN".equals(sqlType)) {
            t = "Y";
            f = "N";
        } else if ("singleCharTF".equals(sqlType)) {
            t = "T";
            f = "F";
        }
        if (t != null || f != null) {
            return Boolean.TRUE.equals(DataTools.asBoolean((Object)columnValue)) ? (t == null ? "null" : "'" + t + "'") : (f == null ? "null" : "'" + f + "'");
        }
        return null;
    }

    public abstract String sqlOutTransform(String var1, String var2, String var3) throws Exception;

    public String sqlOutTransform(String columnName, String remapName) throws Exception {
        return this.sqlOutTransform(columnName, remapName, null);
    }

    public String sqlOutTransform(String columnName) throws Exception {
        return this.sqlOutTransform(columnName, null, null);
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName, String functionName) throws Exception {
        return this.sqlOutTransform(columnName, remapName, tableName, functionName, null);
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName, String functionName, Map functionParams) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (tableName != null) {
            output = tableName + "." + output;
        }
        if (functionName != null && !"".equals(functionName)) {
            output = functionName + "(" + output + ")";
            if (remapName != null) {
                output = output + " AS " + this.escapeColumnName(remapName);
            }
        } else if (remapName != null && !remapName.equals(columnName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        return output;
    }

    public int getMaximumSetSize() {
        return 0;
    }

    public abstract String getNextSequenceValue(String var1, SQLDataSource var2) throws Exception;

    public Map forceSingleRow(List rows) throws Exception {
        if (rows == null) {
            throw new Exception("forceSingleRow() got null value");
        }
        if (rows.size() == 0 || rows.size() > 1) {
            throw new Exception("forceSingleRow() got " + rows.size() + " results");
        }
        return (Map)rows.get(0);
    }

    public boolean hasBrokenCursorAPIs() {
        return this.databaseConfig.getBoolean((Object)"brokenCursorAPIs", false);
    }

    public static String getSequenceName(String columnName, Map sequences, String tableName, SQLDriver sqlDriver) throws Exception {
        if (columnName == null || sequences == null || tableName == null) {
            return null;
        }
        String sequenceName = (String)sequences.get(columnName);
        if (sequenceName == null) {
            return null;
        }
        if (sequenceName.equals("__default")) {
            sequenceName = tableName + "_" + columnName;
            int fixedLength = columnName.length() + 1;
            if (sqlDriver != null) {
                String pref = sqlDriver.sequencePrefix();
                String suff = sqlDriver.sequenceSuffix();
                sequenceName = pref + sequenceName + suff;
                fixedLength += pref.length() + suff.length();
                int sequenceLength = sequenceName.length();
                int maxLength = sqlDriver.maxSequenceNameLength();
                if (maxLength >= 0 && sequenceLength > maxLength) {
                    if (fixedLength > maxLength) {
                        throw new Exception("can't create a unique sequence name for column name: '" + columnName + "' - unable to continue");
                    }
                    String truncatedTableName = tableName.substring(0, maxLength - fixedLength);
                    sequenceName = pref + truncatedTableName + "_" + columnName + suff;
                }
            }
        }
        return sequenceName;
    }

    protected String getSequenceName(String columnName) throws Exception {
        return SQLDriver.getSequenceName(columnName, this.table.getSequences(), this.table.getName(), this);
    }

    protected String getSequenceName(String columnName, SQLDataSource dataSource) throws Exception {
        return SQLDriver.getSequenceName(columnName, dataSource.getSequences(), this.table.getName(), this);
    }

    public boolean fieldIsSearchable(DSField field) {
        String fieldType = field.getType();
        return !field.isBinary() && !"blob".equals(fieldType) && !"clob".equals(fieldType);
    }

    public boolean fieldAssignableInline(DSField field) {
        String fieldType = field.getType();
        return !field.isBinary() && !"blob".equals(fieldType) && !"clob".equals(fieldType);
    }

    public Statement createFetchStatement(Connection conn, boolean streaming, long batchSize) throws SQLException {
        try {
            Statement stmt;
            if (streaming) {
                stmt = conn.createStatement(1003, 1007);
                if (this.canSetFetchSize() && this.shouldSetFetchSizeForStreaming()) {
                    stmt.setFetchSize(config.getInt((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".streaming.fetchSize"), 1));
                }
            } else {
                stmt = conn.createStatement();
                if (this.canSetFetchSize() && batchSize > 0L) {
                    stmt.setFetchSize((int)batchSize);
                }
            }
            return stmt;
        }
        catch (SQLException e) {
            if (streaming) {
                log.warn((Object)"Unable to create statement with flags: ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY.  Backing off to createStatement().");
                return conn.createStatement();
            }
            throw e;
        }
    }

    public Statement createScrollableFetchStatement(Connection conn, long batchSize) throws SQLException {
        try {
            Statement stmt = conn.createStatement(1004, 1007);
            if (this.canSetFetchSize() && batchSize > 0L) {
                stmt.setFetchSize((int)batchSize);
            }
            return stmt;
        }
        catch (SQLException e) {
            log.warn((Object)"Unable to create statement with flags: ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY.  Backing off to createStatement()");
            return conn.createStatement();
        }
    }

    public boolean shouldSetFetchSizeForStreaming() {
        return true;
    }

    public boolean canSetFetchSize() {
        return true;
    }

    public Object transformFieldValue(DSField field, Object obj) {
        return obj;
    }

    public boolean shouldUseSQLDateType(DSField field) {
        String sqlType = null;
        if (field != null) {
            sqlType = field.getProperty("sqlStorageStrategy");
        }
        if (field == null || sqlType == null) {
            String defaultDateType = this.sqlConfig.getString((Object)"defaultDateType");
            if (defaultDateType != null) {
                return defaultDateType.trim().toLowerCase().equals("date");
            }
        } else {
            return sqlType.equals("nativeDate");
        }
        return false;
    }

    protected static boolean supportsGetGeneratedKeys(Connection conn) throws SQLException {
        Method support = null;
        try {
            support = DatabaseMetaData.class.getMethod("supportsGetGeneratedKeys", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (support == null) {
            return false;
        }
        try {
            return conn.getMetaData().supportsGetGeneratedKeys();
        }
        catch (AbstractMethodError ame) {
            return false;
        }
    }

    public InputStream handleInputStream(InputStream stream) throws Exception {
        if (config.getBoolean((Object)("sql." + (Object)((Object)this.getDBType()) + ".readBinaryDataImmediately"), false)) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            IOUtil.copyStreams((InputStream)stream, (OutputStream)os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        return stream;
    }

    public Reader handleCharacterStream(Reader reader) throws Exception {
        if (config.getBoolean((Object)("sql." + (Object)((Object)this.getDBType()) + ".readBinaryDataImmediately"), false)) {
            return new StringReader(IOUtil.readerToString((Reader)reader));
        }
        return reader;
    }

    public void setConnectionProperties(Connection conn) {
    }

    public Timestamp getUTCTimestamp(ResultSet rs, int index) throws SQLException {
        return rs.getTimestamp(index, calendar);
    }

    public String getLiteralPrefix(DSField field, BasicDataSource ds) {
        return "";
    }

    public Object modifyTemporalObject(Object obj, ResultSet rs, int ii) throws SQLException {
        return obj;
    }

    public int caseInsensitiveStrategy() {
        return 1;
    }

    public int caseInsensitiveStrategyForRelativeComparisons() {
        return 1;
    }

    public String caseSensitiveEqualsPredicate() {
        return "=";
    }

    public String caseInsensitiveEqualsPredicate() {
        return "=";
    }

    public String caseSensitiveNotEqualPredicate() {
        return "<>";
    }

    public String caseInsensitiveLikePredicate() {
        return "LIKE";
    }

    public String caseSensitiveLikePredicate() {
        return "LIKE";
    }

    public boolean optimizeCaseSensitiveCriteria() {
        return false;
    }

    public String blankComparison(String fieldName, String operator) {
        if (fieldName == null) {
            return null;
        }
        if ("isBlank".equals(operator)) {
            return "(" + fieldName + " IS NULL OR " + fieldName + "='')";
        }
        return "(" + fieldName + " IS NOT NULL AND " + fieldName + "<>'')";
    }

    public String generateJoinClause(String escapedTo, String escapedFrom, Relation relation) throws Exception {
        if (relation.getJoinType() == 1) {
            log.warn((Object)("The relation between " + relation.getFromDataSource().getID() + " and " + relation.getToDataSource().getID() + " is defined as an outer join, but outer joins are not yet supported on this database product (" + (Object)((Object)this.getDBType()) + ")  Falling back to a regular inner join."));
        }
        return escapedFrom + " = " + escapedTo;
    }

    public boolean castNumbersBeforeLikeCompare() {
        return false;
    }

    public abstract String getNaturalDatabaseObjectName(String var1);

    public String sqlConcat(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuffer sql = new StringBuffer();
        for (String s : strings) {
            if (sql.length() > 0) {
                sql.append(" || ");
            }
            sql.append(s);
        }
        return sql.toString();
    }

    public boolean aliasRequiredForSubselect() {
        return false;
    }

    public boolean aliasForbiddenForSubselect() {
        return false;
    }

    public boolean shouldParameterizeNullValues() {
        return true;
    }

    public boolean supportsMilliseconds() throws Exception {
        return true;
    }

    public boolean supportsFieldComparison(String columnType, String otherColumnType) {
        return columnType != null && columnType.equals(otherColumnType);
    }

    public boolean tableExists(String tableName) throws Exception {
        return this.tableExists(tableName, null);
    }

    public boolean tableExists(String tableName, String schema) throws Exception {
        return new SQLMetaData(this.getOrCreateConnection()).tableExists(this.getNaturalDatabaseObjectName(tableName), this.getNaturalDatabaseObjectName(schema));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deriveDefaultSchema(String schema) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if (schema == null) {
                String sql = this.getDummyQuery();
                stmt = this.getOrCreateConnection().createStatement();
                rs = stmt.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                schema = rsmd.getSchemaName(1);
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return schema;
    }

    public abstract String getDummyQuery();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canQueryTable(String tableName, String schemaName) throws Exception {
        String sql = "SELECT * FROM ";
        if (schemaName != null && !schemaName.equals("")) {
            sql = sql + schemaName + this.getQualifiedSchemaSeparator();
        }
        sql = sql + tableName + " WHERE '0'='1'";
        Connection conn = this.getOrCreateConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        log.debug((Object)("Checking for table existence with query: " + sql));
        try {
            rs = stmt.executeQuery(sql);
        }
        catch (Exception e) {
            log.debug((Object)("Test query failed, assuming table does not exist.  Error was: " + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        log.debug((Object)"Test query succeeded");
        return true;
    }

    public static String getSnapshotFileName(String dbName, String schemaName) throws Exception {
        return snapshotFileNamePrefix + "." + dbName + "." + schemaName;
    }

    public static String createSnapshot(String dbName) throws Exception {
        String defaultSchemaName = config.getString((Object)("sql." + dbName + ".driver.databaseName"));
        String snapshotFileName = SQLDriver.getSnapshotFileName(dbName, defaultSchemaName);
        SQLDriver.createSnapshot(dbName, snapshotFileName);
        return snapshotFileName;
    }

    public static void createSnapshot(String dbName, String snapshotFileName) throws Exception {
        File snapshotFile = new File(snapshotFileName);
        SQLDriver.instance(dbName).createSnapshot(new File(snapshotFileName));
    }

    public void createSnapshot(File snapshotFile) throws Exception {
        if (!config.getBoolean((Object)"sql.snapshot.warnAndIgnoreIfUnsupported", false)) {
            throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
        }
        log.warn((Object)("create snapshot: no-op for " + ((Object)((Object)this)).getClass().getName() + " due to sql.snapshot.warnAndIgnoreIfUnsupported: true"));
    }

    public static void restoreFromSnapshot(String dbName) throws Exception {
        String defaultSchemaName = config.getString((Object)("sql." + dbName + ".driver.databaseName"));
        String snapshotFileName = SQLDriver.getSnapshotFileName(dbName, defaultSchemaName);
        SQLDriver.restoreFromSnapshot(dbName, snapshotFileName);
    }

    public static void restoreFromSnapshot(String dbName, String snapshotFileName) throws Exception {
        SQLDriver.instance(dbName).restoreFromSnapshot(new File(snapshotFileName));
    }

    public void restoreFromSnapshot(File snapshotFile) throws Exception {
        if (!config.getBoolean((Object)"sql.snapshot.warnAndIgnoreIfUnsupported", false)) {
            throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
        }
        log.warn((Object)("restore from snapshot: no-op for " + ((Object)((Object)this)).getClass().getName() + " due to sql.snapshot.warnAndIgnoreIfUnsupported: true"));
    }

    public static void createSandbox(String dbName, String sandboxName) throws Exception {
        long start = new Date().getTime();
        SQLDriver.instance(dbName).createSandbox(sandboxName);
        long end = new Date().getTime();
        log.debug((Object)("Created sandbox for: " + dbName + " in: " + (end - start) + "ms"));
    }

    public void createSandbox(String sandboxName) throws Exception {
        throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public static void removeSandbox(String dbName, String sandboxName) throws Exception {
        SQLDriver.instance(dbName).removeSandbox(sandboxName);
    }

    public void removeSandbox(String sandboxName) throws Exception {
        throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public static boolean exists(String dbName, String schemaName) throws Exception {
        return SQLDriver.lastModified(dbName, schemaName) != -1L;
    }

    public static long lastModified(String dbName, String schemaName) throws Exception {
        return SQLDriver.instance(dbName).lastModified(schemaName);
    }

    public boolean exists(String schemaName) throws Exception {
        throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public long lastModified(String schemaName) throws Exception {
        throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public int getDatabaseMajorVersion() throws Exception {
        return this.metaData.getInt((Object)"databaseMajorVersion", -1);
    }

    public int getDatabaseMinorVersion() throws Exception {
        return this.metaData.getInt((Object)"databaseMinorVersion", -1);
    }

    public String getDatabaseProductName() throws Exception {
        return this.metaData.getString((Object)"databaseProductName");
    }

    public String getDatabaseProductVersion() throws Exception {
        return this.metaData.getString((Object)"databaseProductVersion");
    }

    public int getDriverMajorVersion() throws Exception {
        return this.metaData.getInt((Object)"driverMajorVersion", -1);
    }

    public int getDriverMinorVersion() throws Exception {
        return this.metaData.getInt((Object)"driverMinorVersion", -1);
    }

    public String getDriverName() throws Exception {
        return this.metaData.getString((Object)"driverName");
    }

    public String getDriverVersion() throws Exception {
        return this.metaData.getString((Object)"driverVersion");
    }

    public int getJDBCMajorVersion() throws Exception {
        return this.metaData.getInt((Object)"JDBCMajorVersion", -1);
    }

    public int getJDBCMinorVersion() throws Exception {
        return this.metaData.getInt((Object)"JDBCMinorVersion", -1);
    }
}

