/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.background;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptExecutor;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultJavaScriptExecutor
implements JavaScriptExecutor {
    private final transient WeakReference<WebClient> webClient_;
    private transient List<WeakReference<JavaScriptJobManager>> jobManagerList_ = new LinkedList<WeakReference<JavaScriptJobManager>>();
    private volatile boolean shutdown_ = false;
    private transient Thread eventLoopThread_ = null;
    private static final Log LOG = LogFactory.getLog(DefaultJavaScriptExecutor.class);

    public DefaultJavaScriptExecutor(WebClient webClient) {
        this.webClient_ = new WeakReference<WebClient>(webClient);
    }

    protected void startThreadIfNeeded() {
        if (this.eventLoopThread_ == null) {
            this.eventLoopThread_ = new Thread((Runnable)this, this.getThreadName());
            this.eventLoopThread_.setDaemon(true);
            this.eventLoopThread_.start();
        }
    }

    protected String getThreadName() {
        return "JS executor for " + this.webClient_.get();
    }

    private void killThread() {
        if (this.eventLoopThread_ == null) {
            return;
        }
        try {
            this.eventLoopThread_.interrupt();
            this.eventLoopThread_.join(10000L);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"InterruptedException while waiting for the eventLoop thread to join ", (Throwable)e);
        }
        if (this.eventLoopThread_.isAlive()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Event loop thread " + this.eventLoopThread_.getName() + " still alive at " + System.currentTimeMillis()));
                LOG.warn((Object)"Event loop thread will be stopped");
            }
            this.eventLoopThread_.stop();
        }
    }

    protected JavaScriptJobManager getJobManagerWithEarliestJob() {
        JavaScriptJobManager javaScriptJobManager = null;
        JavaScriptJob earliestJob = null;
        for (WeakReference<JavaScriptJobManager> weakReference : this.jobManagerList_) {
            JavaScriptJob newJob;
            JavaScriptJobManager jobManager = (JavaScriptJobManager)weakReference.get();
            if (jobManager == null || (newJob = jobManager.getEarliestJob()) == null || earliestJob != null && earliestJob.compareTo(newJob) <= 0) continue;
            earliestJob = newJob;
            javaScriptJobManager = jobManager;
        }
        return javaScriptJobManager;
    }

    @Override
    public int pumpEventLoop(long timeoutMillis) {
        return 0;
    }

    @Override
    public void run() {
        boolean trace = LOG.isTraceEnabled();
        long sleepInterval = 10L;
        while (!this.shutdown_ && !Thread.currentThread().isInterrupted() && this.webClient_.get() != null) {
            long waitTime;
            JavaScriptJob earliestJob;
            JavaScriptJobManager jobManager = this.getJobManagerWithEarliestJob();
            if (jobManager != null && (earliestJob = jobManager.getEarliestJob()) != null && (waitTime = earliestJob.getTargetExecutionTime() - System.currentTimeMillis()) < 1L) {
                if (trace) {
                    LOG.trace((Object)("started executing job at " + System.currentTimeMillis()));
                }
                jobManager.runSingleJob(earliestJob);
                if (!trace) continue;
                LOG.trace((Object)("stopped executing job at " + System.currentTimeMillis()));
                continue;
            }
            if (this.shutdown_ || Thread.currentThread().isInterrupted() || this.webClient_.get() == null) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void addWindow(WebWindow newWindow) {
        JavaScriptJobManager jobManager = newWindow.getJobManager();
        if (jobManager != null) {
            this.updateJobMangerList(jobManager);
            this.startThreadIfNeeded();
        }
    }

    private synchronized void updateJobMangerList(JavaScriptJobManager newJobManager) {
        for (WeakReference<JavaScriptJobManager> weakReference : this.jobManagerList_) {
            JavaScriptJobManager manager = (JavaScriptJobManager)weakReference.get();
            if (newJobManager != manager) continue;
            return;
        }
        LinkedList<WeakReference<JavaScriptJobManager>> managers = new LinkedList<WeakReference<JavaScriptJobManager>>();
        for (WeakReference<JavaScriptJobManager> weakReference : this.jobManagerList_) {
            JavaScriptJobManager manager = (JavaScriptJobManager)weakReference.get();
            if (null == manager) continue;
            managers.add(weakReference);
        }
        managers.add(new WeakReference<JavaScriptJobManager>(newJobManager));
        this.jobManagerList_ = managers;
    }

    @Override
    public void shutdown() {
        this.shutdown_ = true;
        this.killThread();
        this.webClient_.clear();
        this.jobManagerList_.clear();
    }
}

