/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import java.io.IOException;
import java.util.Map;

public class HtmlLabel
extends HtmlElement {
    public static final String TAG_NAME = "label";

    HtmlLabel(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getForAttribute() {
        return this.getAttribute("for");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttribute("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }

    @Override
    public void blur() {
        HtmlElement element = this.getReferencedElement();
        if (element != null) {
            element.blur();
        }
    }

    @Override
    public void focus() {
        HtmlElement element = this.getReferencedElement();
        if (element != null) {
            element.focus();
        }
    }

    public HtmlElement getReferencedElement() {
        String elementId = this.getForAttribute();
        if (!ATTRIBUTE_NOT_DEFINED.equals(elementId)) {
            try {
                return ((HtmlPage)this.getPage()).getHtmlElementById(elementId);
            }
            catch (ElementNotFoundException e) {
                return null;
            }
        }
        for (DomNode element : this.getChildren()) {
            if (!(element instanceof HtmlInput)) continue;
            return (HtmlInput)element;
        }
        return null;
    }

    @Override
    public <P extends Page> P click(Event event, boolean ignoreVisibility) throws IOException {
        Object page = super.click(event, ignoreVisibility);
        HtmlElement element = this.getReferencedElement();
        Object response = element != null ? element.click(false, false, false, false) : page;
        return response;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }
}

