/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.store;

import com.isomorphic.store.ExpiringValue;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpiringCache<K, V> {
    protected long maxLifeInMillis;
    protected long maxEntries;
    protected LinkedHashMap<K, ExpiringValue<V>> cache;

    public ExpiringCache(final long maxLifeInMillis, final long maxEntries) {
        this.maxLifeInMillis = maxLifeInMillis;
        this.maxEntries = maxEntries;
        this.cache = new LinkedHashMap<K, ExpiringValue<V>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, ExpiringValue<V>> eldest) {
                if (maxEntries > 0L && (long)this.size() > maxEntries) {
                    return true;
                }
                return eldest.getValue().isStale(maxLifeInMillis);
            }
        };
    }

    public synchronized void put(K key, V value) {
        this.cache.remove(key);
        this.cache.put(key, new ExpiringValue<V>(value));
    }

    public synchronized ExpiringValue<V> get(K key) {
        ExpiringValue<V> expiringValue = this.cache.get(key);
        if (expiringValue == null) {
            return null;
        }
        if (expiringValue.isStale(this.maxLifeInMillis)) {
            this.cache.remove(key);
            return null;
        }
        return expiringValue;
    }
}

