/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import java.util.logging.Level;

public enum OperaSeverity {
    DEBUG,
    VERBOSE,
    INFORMATION,
    ERROR,
    CRITICAL;


    public Level toLevel() {
        switch (this) {
            case DEBUG: {
                return Level.FINE;
            }
            case VERBOSE: {
                return Level.FINER;
            }
            case ERROR: {
                return Level.WARNING;
            }
            case CRITICAL: {
                return Level.SEVERE;
            }
        }
        return Level.INFO;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static OperaSeverity get(String name) {
        for (OperaSeverity severity : OperaSeverity.values()) {
            if (!severity.toString().equals(name)) continue;
            return severity;
        }
        return INFORMATION;
    }
}

