/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.ScriptElement;
import com.gargoylesoftware.htmlunit.javascript.AbstractJavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLScriptElement;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlScript
extends HtmlElement
implements ScriptElement {
    private static final Log LOG = LogFactory.getLog(HtmlScript.class);
    public static final String TAG_NAME = "script";
    private static final String SLASH_SLASH_COLON = "//:";
    private boolean executed_;
    private boolean createdByJavascript_;

    HtmlScript(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public final String getCharsetAttribute() {
        return this.getAttribute("charset");
    }

    @Override
    @Deprecated
    public final Charset getCharset() {
        String charsetName = this.getCharsetAttribute();
        return EncodingSniffer.toCharset(charsetName);
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getLanguageAttribute() {
        return this.getAttribute("language");
    }

    @Override
    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public final String getEventAttribute() {
        return this.getAttribute("event");
    }

    public final String getHtmlForAttribute() {
        return this.getAttribute("for");
    }

    public final String getDeferAttribute() {
        return this.getAttribute("defer");
    }

    protected boolean isDeferred() {
        return this.getDeferAttribute() != ATTRIBUTE_NOT_DEFINED;
    }

    @Override
    public boolean mayBeDisplayed() {
        return false;
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        if (namespaceURI != null || !"src".equals(qualifiedName)) {
            super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
            return;
        }
        String oldValue = this.getAttributeNS(namespaceURI, qualifiedName);
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
        if (this.isAttachedToPage() && oldValue.isEmpty() && this.getFirstChild() == null) {
            PostponedAction action = new PostponedAction(this.getPage()){

                @Override
                public void execute() {
                    HtmlScript.this.executeScriptIfNeeded();
                }
            };
            AbstractJavaScriptEngine<?> engine = this.getPage().getWebClient().getJavaScriptEngine();
            engine.addPostponedAction(action);
        }
    }

    @Override
    protected void onAllChildrenAddedToPage(boolean postponed) {
        if (this.getOwnerDocument() instanceof XmlPage) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Script node added: " + this.asXml()));
        }
        PostponedAction action = new PostponedAction(this.getPage(), "Execution of script " + this){

            @Override
            public void execute() {
                HTMLDocument jsDoc = null;
                Object window = HtmlScript.this.getPage().getEnclosingWindow().getScriptableObject();
                if (window instanceof Window) {
                    jsDoc = (HTMLDocument)((Window)window).getDocument();
                    jsDoc.setExecutingDynamicExternalPosponed(HtmlScript.this.getStartLineNumber() == -1 && HtmlScript.this.getSrcAttribute() != DomElement.ATTRIBUTE_NOT_DEFINED);
                }
                try {
                    HtmlScript.this.executeScriptIfNeeded();
                }
                finally {
                    if (jsDoc instanceof HTMLDocument) {
                        jsDoc.setExecutingDynamicExternalPosponed(false);
                    }
                }
            }
        };
        AbstractJavaScriptEngine<?> engine = this.getPage().getWebClient().getJavaScriptEngine();
        if (this.hasAttribute("async") && !engine.isScriptRunning()) {
            HtmlPage owningPage = this.getHtmlPageOrNull();
            owningPage.addAfterLoadAction(action);
        } else if (this.hasAttribute("async") || postponed && StringUtils.isBlank((CharSequence)this.getTextContent())) {
            engine.addPostponedAction(action);
        } else {
            try {
                action.execute();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void executeInlineScriptIfNeeded() {
        if (!this.isExecutionNeeded()) {
            return;
        }
        String src = this.getSrcAttribute();
        if (src != ATTRIBUTE_NOT_DEFINED) {
            return;
        }
        String forr = this.getHtmlForAttribute();
        String event = this.getEventAttribute();
        if (event.endsWith("()")) {
            event = event.substring(0, event.length() - 2);
        }
        String scriptCode = this.getScriptCode();
        if (event != ATTRIBUTE_NOT_DEFINED && forr != ATTRIBUTE_NOT_DEFINED && this.hasFeature(BrowserVersionFeatures.JS_SCRIPT_SUPPORTS_FOR_AND_EVENT_WINDOW) && "window".equals(forr)) {
            Window window = (Window)this.getPage().getEnclosingWindow().getScriptableObject();
            EventHandler function = new EventHandler(this, event, scriptCode);
            window.getEventListenersContainer().addEventListener(StringUtils.substring((String)event, (int)2), (Scriptable)function, false);
            return;
        }
        if (forr == ATTRIBUTE_NOT_DEFINED || "onload".equals(event)) {
            String url = this.getPage().getUrl().toExternalForm();
            int line1 = this.getStartLineNumber();
            int line2 = this.getEndLineNumber();
            int col1 = this.getStartColumnNumber();
            int col2 = this.getEndColumnNumber();
            String desc = "script in " + url + " from (" + line1 + ", " + col1 + ") to (" + line2 + ", " + col2 + ")";
            this.executed_ = true;
            ((HtmlPage)this.getPage()).executeJavaScript(scriptCode, desc, line1);
        }
    }

    private String getScriptCode() {
        Iterable<DomNode> textNodes = this.getChildren();
        StringBuilder scriptCode = new StringBuilder();
        for (DomNode node : textNodes) {
            if (!(node instanceof DomText)) continue;
            DomText domText = (DomText)node;
            scriptCode.append(domText.getData());
        }
        return scriptCode.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeScriptIfNeeded() {
        if (!this.isExecutionNeeded()) {
            return;
        }
        HtmlPage page = (HtmlPage)this.getPage();
        String src = this.getSrcAttribute();
        if (src.equals(SLASH_SLASH_COLON)) {
            this.executeEvent("error");
            return;
        }
        if (src != ATTRIBUTE_NOT_DEFINED) {
            if (src.startsWith("javascript:")) return;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading external JavaScript: " + src));
            }
            try {
                HtmlPage.JavaScriptLoadResult result;
                this.executed_ = true;
                Charset charset = EncodingSniffer.toCharset(this.getCharsetAttribute());
                if (charset == null) {
                    charset = page.getCharset();
                }
                if ((result = page.loadExternalJavaScriptFile(src, charset)) == HtmlPage.JavaScriptLoadResult.SUCCESS) {
                    this.executeEvent("load");
                    return;
                }
                if (result != HtmlPage.JavaScriptLoadResult.DOWNLOAD_ERROR) return;
                this.executeEvent("error");
                return;
            }
            catch (FailingHttpStatusCodeException e) {
                this.executeEvent("error");
                throw e;
            }
        } else {
            if (this.getFirstChild() == null) return;
            this.executeInlineScriptIfNeeded();
            if (!this.hasFeature(BrowserVersionFeatures.EVENT_ONLOAD_INTERNAL_JAVASCRIPT)) return;
            this.executeEvent("load");
        }
    }

    private void executeEvent(String type) {
        Object scriptable = this.getScriptableObject();
        HTMLScriptElement script = (HTMLScriptElement)scriptable;
        Event event = new Event(this, type);
        script.executeEventLocally(event);
    }

    private boolean isExecutionNeeded() {
        if (this.executed_) {
            return false;
        }
        if (!this.isAttachedToPage()) {
            return false;
        }
        SgmlPage page = this.getPage();
        if (!page.getWebClient().getOptions().isJavaScriptEnabled()) {
            return false;
        }
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if (htmlPage != null && htmlPage.isParsingHtmlSnippet()) {
            return false;
        }
        for (DomNode o = this; o != null; o = o.getParentNode()) {
            if (!(o instanceof HtmlInlineFrame) && !(o instanceof HtmlNoFrames)) continue;
            return false;
        }
        if (page.getEnclosingWindow() != null && page.getEnclosingWindow().getEnclosedPage() != page) {
            return false;
        }
        if (!this.isJavaScript(this.getTypeAttribute(), this.getLanguageAttribute())) {
            String t = this.getTypeAttribute();
            String l = this.getLanguageAttribute();
            LOG.warn((Object)("Script is not JavaScript (type: " + t + ", language: " + l + "). Skipping execution."));
            return false;
        }
        return this.getPage().isAncestorOf(this);
    }

    boolean isJavaScript(String typeAttribute, String languageAttribute) {
        BrowserVersion browserVersion = this.getPage().getWebClient().getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.HTMLSCRIPT_TRIM_TYPE)) {
            typeAttribute = typeAttribute.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)typeAttribute)) {
            if ("text/javascript".equalsIgnoreCase(typeAttribute) || "text/ecmascript".equalsIgnoreCase(typeAttribute)) {
                return true;
            }
            return "application/javascript".equalsIgnoreCase(typeAttribute) || "application/ecmascript".equalsIgnoreCase(typeAttribute) || "application/x-javascript".equalsIgnoreCase(typeAttribute);
        }
        if (StringUtils.isNotEmpty((CharSequence)languageAttribute)) {
            return StringUtils.startsWithIgnoreCase((CharSequence)languageAttribute, (CharSequence)"javascript");
        }
        return true;
    }

    protected void setAndExecuteReadyState(String state) {
    }

    @Override
    public String asText() {
        return "";
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    protected void printChildrenAsXml(String indent, PrintWriter printWriter) {
        DomCharacterData textNode = (DomCharacterData)this.getFirstChild();
        if (textNode == null) {
            return;
        }
        String data = textNode.getData();
        if (data.contains("//<![CDATA[")) {
            printWriter.print(data);
            printWriter.print("\r\n");
        } else {
            printWriter.print("//<![CDATA[");
            printWriter.print("\r\n");
            printWriter.print(data);
            printWriter.print("\r\n");
            printWriter.print("//]]>");
            printWriter.print("\r\n");
        }
    }

    public void resetExecuted() {
        this.executed_ = false;
    }

    @Override
    public void processImportNode(Document doc) {
        super.processImportNode(doc);
        this.executed_ = true;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.print(this.getClass().getSimpleName());
        printWriter.print("[<");
        this.printOpeningTagContentAsXml(printWriter);
        printWriter.print(">");
        printWriter.print(this.getScriptCode());
        printWriter.print("]");
        printWriter.flush();
        return writer.toString();
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.NONE;
    }

    public void markAsCreatedByJavascript() {
        this.createdByJavascript_ = true;
    }

    public boolean wasCreatedByJavascript() {
        return this.createdByJavascript_;
    }

    @Override
    public boolean isExecuted() {
        return this.executed_;
    }

    @Override
    public void setExecuted(boolean executed) {
        this.executed_ = executed;
    }
}

