/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.spring;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.examples.SupplyItem;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class SupplyItemDao {
    Logger log = new Logger(SupplyItemDao.class.getName());
    private SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public DSResponse fetch(DSRequest dsRequest) throws Exception {
        this.log.info((Object)"procesing DMI fetch operation");
        DSResponse dsResponse = new DSResponse(dsRequest == null ? (DataSource)null : dsRequest.getDataSource());
        Session hibernateSession = this.sessionFactory.getCurrentSession();
        String itemName = (String)dsRequest.getFieldValue((Object)"itemName");
        long startRow = (int)dsRequest.getStartRow();
        long endRow = (int)dsRequest.getEndRow();
        Criteria criteria = hibernateSession.createCriteria(SupplyItem.class);
        SimpleExpression itemNameRestriction = null;
        if (itemName != null) {
            itemNameRestriction = Restrictions.like((String)"itemName", (String)itemName, (MatchMode)MatchMode.ANYWHERE);
            criteria.add((Criterion)itemNameRestriction);
        }
        criteria.setProjection(Projections.rowCount());
        Object rowCount = criteria.uniqueResult();
        long totalRows = 0L;
        if (rowCount instanceof Integer) {
            totalRows = ((Integer)rowCount).intValue();
        } else if (rowCount instanceof Long) {
            totalRows = (Long)rowCount;
        }
        endRow = Math.min(endRow, totalRows);
        criteria = hibernateSession.createCriteria(SupplyItem.class);
        if (itemName != null) {
            criteria.add((Criterion)itemNameRestriction);
        }
        criteria.setFirstResult((int)startRow);
        criteria.setMaxResults((int)(endRow - startRow));
        List matchingItems = criteria.list();
        dsResponse.setData((Object)matchingItems);
        dsResponse.setStartRow(startRow);
        dsResponse.setEndRow(endRow);
        dsResponse.setTotalRows(totalRows);
        return dsResponse;
    }

    public DSResponse add(DSRequest dsRequest, SupplyItem item) throws Exception {
        this.log.info((Object)"procesing DMI add operation");
        DSResponse dsResponse = new DSResponse();
        Session hibernateSession = this.sessionFactory.getCurrentSession();
        hibernateSession.saveOrUpdate((Object)item);
        dsResponse.setData((Object)item);
        return dsResponse;
    }

    public DSResponse update(DSRequest dsRequest, Map newValues) throws Exception {
        this.log.info((Object)"procesing DMI update operation");
        DSResponse dsResponse = new DSResponse();
        Serializable id = (Serializable)dsRequest.getFieldValue((Object)"itemID");
        Session hibernateSession = this.sessionFactory.getCurrentSession();
        SupplyItem item = (SupplyItem)hibernateSession.get(SupplyItem.class, id);
        this.log.warn((Object)("fetched item: " + DataTools.prettyPrint((Object)item)));
        DataTools.setProperties((Map)newValues, (Object)item);
        this.log.warn((Object)("Saving record: " + DataTools.prettyPrint((Object)item)));
        hibernateSession.saveOrUpdate((Object)item);
        dsResponse.setData((Object)item);
        return dsResponse;
    }

    public SupplyItem remove(SupplyItem item) throws Exception {
        this.log.info((Object)"procesing DMI remove operation");
        Session hibernateSession = this.sessionFactory.getCurrentSession();
        hibernateSession.delete((Object)item);
        return item;
    }
}

