/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.arrays;

import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBuffer;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBufferView;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class DataView
extends ArrayBufferView {
    @JsxConstructor
    public void constructor(Object array, int byteOffset, Object length) {
        if (!(array instanceof ArrayBuffer)) {
            throw ScriptRuntime.typeError((String)"First argument to DataView constructor must be an ArrayBuffer");
        }
        if (length == Undefined.instance) {
            length = ((ArrayBuffer)array).getByteLength();
        }
        super.constructor((ArrayBuffer)array, byteOffset, ((Number)length).intValue());
    }

    @JsxFunction
    public byte getInt8(int byteOffset) {
        return this.getBuffer().getBytes()[this.getByteOffset() + byteOffset];
    }

    @JsxFunction
    public void setInt8(int byteOffset, int value) {
        byte[] array = this.getBuffer().getBytes();
        array[this.getByteOffset() + byteOffset] = (byte)value;
    }

    @JsxFunction
    public short getInt16(int byteOffset, boolean littleEndian) {
        ByteBuffer buff = ByteBuffer.wrap(this.getBuffer().getBytes());
        if (littleEndian) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buff.getShort(this.getByteOffset() + byteOffset);
    }

    @JsxFunction
    public void setInt16(int byteOffset, int value, boolean littleEndian) {
        ByteBuffer buff = ByteBuffer.wrap(this.getBuffer().getBytes());
        if (littleEndian) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        }
        buff.putShort(this.getByteOffset() + byteOffset, (short)value);
    }

    @JsxFunction
    public int getInt32(int byteOffset, boolean littleEndian) {
        ByteBuffer buff = ByteBuffer.wrap(this.getBuffer().getBytes());
        if (littleEndian) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buff.getInt(this.getByteOffset() + byteOffset);
    }

    @JsxFunction
    public void setInt32(int byteOffset, int value, boolean littleEndian) {
        ByteBuffer buff = ByteBuffer.wrap(this.getBuffer().getBytes());
        if (littleEndian) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        }
        buff.putInt(this.getByteOffset() + byteOffset, value);
    }

    @JsxFunction
    public int getUint8(int byteOffset) {
        return this.getBuffer().getBytes()[this.getByteOffset() + byteOffset] & 0xFF;
    }

    @JsxFunction
    public void setUint8(int byteOffset, int value) {
        this.setInt8(byteOffset, value);
    }

    @JsxFunction
    public int getUint16(int byteOffset, boolean littleEndian) {
        ByteBuffer buff = ByteBuffer.wrap(this.getBuffer().getBytes());
        if (littleEndian) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buff.getShort(this.getByteOffset() + byteOffset) & 0xFFFF;
    }

    @JsxFunction
    public void setUint16(int byteOffset, int value, boolean littleEndian) {
        this.setInt16(byteOffset, value, littleEndian);
    }

    @JsxFunction
    public long getUint32(int byteOffset, boolean littleEndian) {
        ByteBuffer buff = ByteBuffer.wrap(this.getBuffer().getBytes());
        if (littleEndian) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        }
        return (long)buff.getInt(this.getByteOffset() + byteOffset) & 0xFFFFFFFFL;
    }

    @JsxFunction
    public void setUint32(int byteOffset, int value, boolean littleEndian) {
        this.setInt32(byteOffset, value, littleEndian);
    }

    @JsxFunction
    public float getFloat32(int byteOffset, boolean littleEndian) {
        ByteBuffer buff = ByteBuffer.wrap(this.getBuffer().getBytes());
        if (littleEndian) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buff.getFloat(this.getByteOffset() + byteOffset);
    }

    @JsxFunction
    public void setFloat32(int byteOffset, double value, boolean littleEndian) {
        ByteBuffer buff = ByteBuffer.wrap(this.getBuffer().getBytes());
        if (littleEndian) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        }
        buff.putFloat(this.getByteOffset() + byteOffset, (float)value);
    }

    @JsxFunction
    public double getFloat64(int byteOffset, boolean littleEndian) {
        ByteBuffer buff = ByteBuffer.wrap(this.getBuffer().getBytes());
        if (littleEndian) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        }
        return buff.getDouble(this.getByteOffset() + byteOffset);
    }

    @JsxFunction
    public void setFloat64(int byteOffset, double value, boolean littleEndian) {
        ByteBuffer buff = ByteBuffer.wrap(this.getBuffer().getBytes());
        if (littleEndian) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        }
        buff.putDouble(this.getByteOffset() + byteOffset, value);
    }
}

