/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.xpath;

import com.gargoylesoftware.htmlunit.html.xpath.LowerCaseFunction;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;

class XPathAdapter {
    private static final Pattern PREPROCESS_XPATH_PATTERN = Pattern.compile("(@[a-zA-Z]+)");
    private Expression mainExp_;
    private FunctionTable funcTable_;

    private void initFunctionTable() {
        this.funcTable_ = new FunctionTable();
        this.funcTable_.installFunction("lower-case", LowerCaseFunction.class);
    }

    XPathAdapter(String exprString, SourceLocator locator, PrefixResolver prefixResolver, ErrorListener errorListener, boolean caseSensitive, boolean attributeCaseSensitive) throws TransformerException {
        Expression expr;
        this.initFunctionTable();
        if (errorListener == null) {
            errorListener = new DefaultErrorHandler();
        }
        exprString = XPathAdapter.preProcessXPath(exprString, caseSensitive, attributeCaseSensitive);
        XPathParser parser = new XPathParser(errorListener, locator);
        Compiler compiler = new Compiler(errorListener, locator, this.funcTable_);
        parser.initXPath(compiler, exprString, prefixResolver);
        this.mainExp_ = expr = compiler.compile(0);
        if (locator != null && locator instanceof ExpressionNode) {
            expr.exprSetParent((ExpressionNode)locator);
        }
    }

    private static String preProcessXPath(String xpath, boolean caseSensitive, boolean attributeCaseSensitive) {
        if (!caseSensitive) {
            char[] charArray = xpath.toCharArray();
            XPathAdapter.processOutsideBrackets(charArray);
            xpath = new String(charArray);
        }
        if (!attributeCaseSensitive) {
            Matcher matcher = PREPROCESS_XPATH_PATTERN.matcher(xpath);
            while (matcher.find()) {
                String attribute = matcher.group(1);
                xpath = xpath.replace(attribute, attribute.toLowerCase(Locale.ROOT));
            }
        }
        return xpath;
    }

    private static void processOutsideBrackets(char[] array) {
        int length = array.length;
        int insideBrackets = 0;
        block4: for (int i = 0; i < length; ++i) {
            char ch = array[i];
            switch (ch) {
                case '(': 
                case '[': {
                    ++insideBrackets;
                    continue block4;
                }
                case ')': 
                case ']': {
                    --insideBrackets;
                    continue block4;
                }
                default: {
                    if (insideBrackets != 0) continue block4;
                    array[i] = Character.toLowerCase(ch);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XObject execute(XPathContext xpathContext, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        XObject xobj;
        block11: {
            xpathContext.pushNamespaceContext(namespaceContext);
            xpathContext.pushCurrentNodeAndExpression(contextNode, contextNode);
            xobj = null;
            try {
                xobj = this.mainExp_.execute(xpathContext);
            }
            catch (TransformerException te) {
                te.setLocator((SourceLocator)this.mainExp_);
                ErrorListener el = xpathContext.getErrorListener();
                if (null != el) {
                    el.error(te);
                    break block11;
                }
                throw te;
            }
            catch (Exception e) {
                while (e instanceof WrappedRuntimeException) {
                    e = ((WrappedRuntimeException)e).getException();
                }
                String msg = e.getMessage();
                if (msg == null || msg.isEmpty()) {
                    msg = XPATHMessages.createXPATHMessage((String)"ER_XPATH_ERROR", null);
                }
                TransformerException te = new TransformerException(msg, (SourceLocator)this.mainExp_, e);
                ErrorListener el = xpathContext.getErrorListener();
                if (null != el) {
                    el.fatalError(te);
                    break block11;
                }
                throw te;
            }
            finally {
                xpathContext.popNamespaceContext();
                xpathContext.popCurrentNodeAndExpression();
            }
        }
        return xobj;
    }
}

